/// <reference types="node" />
import * as http from "http";
import * as https from "https";
import Servient, { ProtocolServer, ExposedThing } from "@node-wot/core";
import { HttpConfig } from "./http";
export default class HttpServer implements ProtocolServer {
    readonly scheme: "http" | "https";
    private readonly PROPERTY_DIR;
    private readonly ACTION_DIR;
    private readonly EVENT_DIR;
    private readonly OBSERVABLE_DIR;
    private readonly port;
    private readonly address;
    private readonly baseUri;
    private readonly httpSecurityScheme;
    private readonly validOAuthClients;
    private readonly server;
    private readonly things;
    private servient;
    private oAuthValidator;
    constructor(config?: HttpConfig);
    start(servient: Servient): Promise<void>;
    stop(): Promise<void>;
    getServer(): http.Server | https.Server;
    getPort(): number;
    getHttpSecurityScheme(): string;
    private updateInteractionNameWithUriVariablePattern;
    expose(thing: ExposedThing, tdTemplate?: WoT.ExposedThingInit): Promise<void>;
    destroy(thingId: string): Promise<boolean>;
    addEndpoint(thing: ExposedThing, tdTemplate: WoT.ExposedThingInit, base: string): void;
    private checkCredentials;
    private fillSecurityScheme;
    private handleRequest;
    private isEmpty;
    private resetMultiLangThing;
    private resetMultiLangInteraction;
}
