"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.analyzeIncluded = void 0;
const path_1 = __importDefault(require("path"));
const clean_1 = require("./clean");
const glob_1 = require("./utils/glob");
async function analyzeIncluded(nodeModulesPath, globLists) {
    const includedFiles = await (0, clean_1.findFilesToRemove)(nodeModulesPath, globLists);
    const defaultGlobs = (0, glob_1.toAbsoluteGlobLists)((0, glob_1.optimizeGlobLists)(await (0, glob_1.parseDefaultGlobsFile)()), nodeModulesPath);
    const includedByDefaultMatcher = (0, glob_1.makeGlobMatcher)(defaultGlobs.included, {
        ignore: defaultGlobs.excluded,
    });
    const globMatchers = globLists.included.map((glob, index) => {
        const absoluteGlob = path_1.default.resolve(nodeModulesPath, glob);
        const matcher = (0, glob_1.makeGlobMatcher)(absoluteGlob);
        return { original: globLists.originalIncluded[index], derived: absoluteGlob, matcher };
    });
    const analyzedResults = includedFiles.map(filePath => {
        const includedByDefault = includedByDefaultMatcher(filePath);
        const includedByGlobs = [];
        globMatchers.forEach(({ original, derived, matcher }) => {
            if (matcher(filePath)) {
                includedByGlobs.push({ original, derived });
            }
        });
        return { filePath, includedByDefault, includedByGlobs };
    });
    return analyzedResults;
}
exports.analyzeIncluded = analyzeIncluded;
