#!/usr/bin/env node
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const cli_default_servient_1 = __importDefault(require("./cli-default-servient"));
const fs = require("fs");
const dotenv = __importStar(require("dotenv"));
const path = __importStar(require("path"));
const argv = process.argv.slice(2);
const defaultFile = "wot-servient.conf.json";
const baseDir = ".";
let clientOnly = false;
let flagArgConfigfile = false;
let flagArgCompilerModule = false;
let flagArgPort = false;
let compilerModule;
let flagScriptArgs = false;
const scriptArgs = [];
let confFile;
const servientPorts = new Map();
let currentProtocolPort;
let debug;
function readConf(filename) {
    return new Promise((resolve, reject) => {
        const open = filename || path.join(baseDir, defaultFile);
        fs.readFile(open, "utf-8", (err, data) => {
            if (err) {
                reject(err);
            }
            if (data) {
                let config;
                try {
                    config = JSON.parse(data);
                    if (typeof config !== "object" || Array.isArray(config)) {
                        throw new Error("Invalid configuration file");
                    }
                }
                catch (err) {
                    reject(err);
                }
                console.info("[cli]", `WoT-Servient using config file '${open}'`);
                resolve(config);
            }
        });
    });
}
function overrideConfig(conf) {
    conf = conf !== null && conf !== void 0 ? conf : {};
    servientPorts.forEach((port, protocol) => {
        if (port !== undefined) {
            if (!(protocol in conf)) {
                conf[protocol] = {};
            }
            conf[protocol].port = port;
        }
    });
    return conf;
}
const loadCompilerFunction = function (compilerModule) {
    if (compilerModule) {
        const compilerMod = require(compilerModule);
        if (!compilerMod.create) {
            throw new Error("No create function defined for " + compilerModule);
        }
        const compilerObject = compilerMod.create();
        if (!compilerObject.compile) {
            throw new Error("No compile function defined for create return object");
        }
        return compilerObject.compile;
    }
    return undefined;
};
const loadEnvVariables = function () {
    const env = dotenv.config();
    if (env.error && env.error.code && env.error.code !== "ENOENT") {
        throw env.error;
    }
    return env;
};
const runScripts = function (servient, scripts, debug) {
    return __awaiter(this, void 0, void 0, function* () {
        const env = loadEnvVariables();
        const launchScripts = (scripts) => {
            const compile = loadCompilerFunction(compilerModule);
            scripts.forEach((fname) => {
                console.info("[cli]", "WoT-Servient reading script", fname);
                fs.readFile(fname, "utf8", (err, data) => {
                    if (err) {
                        console.error("[cli]", "WoT-Servient experienced error while reading script", err);
                    }
                    else {
                        console.info("[cli]", `WoT-Servient running script '${data.substr(0, data.indexOf("\n")).replace("\r", "")}'... (${data.split(/\r\n|\r|\n/).length} lines)`);
                        fname = path.resolve(fname);
                        servient.runPrivilegedScript(data, fname, {
                            argv: scriptArgs,
                            env: env.parsed,
                            compiler: compile,
                        });
                    }
                });
            });
        };
        const inspector = require("inspector");
        if (debug && debug.shouldBreak) {
            !inspector.url() && inspector.open(debug.port, debug.host, true);
            const session = new inspector.Session();
            session.connect();
            session.post("Debugger.enable", (error) => {
                if (error) {
                    console.warn("[cli]", "Cannot set breakpoint; reason: cannot enable debugger");
                    console.warn(error);
                }
                session.post("Debugger.setBreakpointByUrl", {
                    lineNumber: 0,
                    url: "file:///" + path.resolve(scripts[0]).replace(/\\/g, "/"),
                }, (err) => {
                    if (err) {
                        console.warn("[cli]", "Cannot set breakpoint");
                        console.warn("[cli]", error);
                    }
                    launchScripts(scripts);
                });
            });
        }
        else {
            debug && !inspector.url() && inspector.open(debug.port, debug.host, false);
            launchScripts(scripts);
        }
    });
};
const runAllScripts = function (servient, debug) {
    fs.readdir(baseDir, (err, files) => {
        if (err) {
            console.warn("[cli]", "WoT-Servient experienced error while loading directory", err);
            return;
        }
        const scripts = files.filter((file) => {
            return file.substr(0, 1) !== "." && file.slice(-3) === ".js";
        });
        console.info("[cli]", `WoT-Servient using current directory with ${scripts.length} script${scripts.length > 1 ? "s" : ""}`);
        runScripts(servient, scripts.map((filename) => path.resolve(path.join(baseDir, filename))), debug);
    });
};
for (let i = 0; i < argv.length; i++) {
    if (flagArgConfigfile) {
        flagArgConfigfile = false;
        confFile = argv[i];
        argv.splice(i, 1);
        i--;
    }
    else if (flagScriptArgs) {
        scriptArgs.push(argv[i]);
        argv.splice(i, 1);
        i--;
    }
    else if (flagArgCompilerModule) {
        flagArgCompilerModule = false;
        compilerModule = argv[i];
        argv.splice(i, 1);
        i--;
    }
    else if (flagArgPort) {
        flagArgPort = false;
        servientPorts.set(currentProtocolPort, parseInt(argv[i]));
        argv.splice(i, 1);
        i--;
    }
    else if (argv[i] === "--") {
        flagScriptArgs = true;
        argv.splice(i, 1);
        i--;
    }
    else if (argv[i].match(/^(-c|--clientonly|\/c)$/i)) {
        clientOnly = true;
        argv.splice(i, 1);
        i--;
    }
    else if (argv[i].match(/^(-cp|--compiler|\/cp)$/i)) {
        flagArgCompilerModule = true;
        argv.splice(i, 1);
        i--;
    }
    else if (argv[i].match(/^(-f|--configfile|\/f)$/i)) {
        flagArgConfigfile = true;
        argv.splice(i, 1);
        i--;
    }
    else if (argv[i].match(/^--(http|coap|mqtt)\.port$/i)) {
        flagArgPort = true;
        const matches = argv[i].match(/^--(http|coap|mqtt)\.port$/i);
        currentProtocolPort = matches[1];
        argv.splice(i, 1);
        i--;
    }
    else if (argv[i].match(/^(-i|-ib|--inspect(-brk)?(=([a-z]*|[\d .]*):?(\d*))?|\/i|\/ib)$/i)) {
        const matches = argv[i].match(/^(-i|-ib|--inspect(-brk)?(=([a-z]*|[\d .]*):?(\d*))?|\/i|\/ib)$/i);
        debug = {
            shouldBreak: matches[2] === "-brk" || matches[1] === "-ib" || matches[1] === "/ib",
            host: matches[4] ? matches[4] : "127.0.0.1",
            port: matches[5] ? parseInt(matches[5]) : 9229,
        };
        argv.splice(i, 1);
        i--;
    }
    else if (argv[i].match(/^(-v|--version|\/c)$/i)) {
        console.log(require("@node-wot/core/package.json").version);
        process.exit(0);
    }
    else if (argv[i].match(/^(-h|--help|\/?|\/h)$/i)) {
        console.log(`Usage: wot-servient [options] [SCRIPT]... -- [ARGS]...
       wot-servient
       wot-servient examples/scripts/counter.js examples/scripts/example-event.js
       wot-servient -c counter-client.js
       wot-servient -f ~/mywot.conf.json examples/testthing/testthing.js
       wot-servient examples/testthing/testthing.js -- script_arg1 script_arg2

Run a WoT Servient in the current directory.
If no SCRIPT is given, all .js files in the current directory are loaded.
If one or more SCRIPT is given, these files are loaded instead of the directory.
If the file 'wot-servient.conf.json' exists, that configuration is applied.

Options:
  -v,   --version                   display node-wot version
  -i,   --inspect[=[host:]port]     activate inspector on host:port (default: 127.0.0.1:9229)
  -ib,  --inspect-brk[=[host:]port] activate inspector on host:port and break at start of user script
  -c,   --clientonly                do not start any servers
                                    (enables multiple instances without port conflicts)
  -cp,  --compiler <module>         load module as a compiler
                                    (The module must export a create function which returns
                                    an object with a compile method)
  -f,   --configfile <file>         load configuration from specified file
  -h,   --help                      show this help
        --[protocol].port           specify the port to expose the server for a specific protocol

wot-servient.conf.json syntax:
{
    "servient": {
        "clientOnly": CLIENTONLY,
        "staticAddress": STATIC,
        "scriptAction": RUNSCRIPT
    },
    "http": {
        "port": HPORT,
        "proxy": PROXY,
        "allowSelfSigned": ALLOW
    },
    "mqtt" : {
        "broker": BROKER-URL,
        "username": BROKER-USERNAME,
        "password": BROKER-PASSWORD,
        "clientId": BROKER-UNIQUEID,
        "protocolVersion": MQTT_VERSION
    },
    "credentials": {
        THING_ID1: {
            "token": TOKEN
        },
        THING_ID2: {
            "username": USERNAME,
            "password": PASSWORD
        }
    }
}

wot-servient.conf.json fields:
  ---------------------------------------------------------------------------
  All entries in the config file structure are optional
  ---------------------------------------------------------------------------
  CLIENTONLY      : boolean setting if no servers shall be started (default=false)
  STATIC          : string with hostname or IP literal for static address config
  RUNSCRIPT       : boolean to activate the 'runScript' Action (default=false)
  HPORT           : integer defining the HTTP listening port
  PROXY           : object with "href" field for the proxy URI,
                                "scheme" field for either "basic" or "bearer", and
                                corresponding credential fields as defined below
  ALLOW           : boolean whether self-signed certificates should be allowed
  BROKER-URL      : URL to an MQTT broker that publisher and subscribers will use
  BROKER-UNIQUEID : unique id set by mqtt client while connecting to broker
  MQTT_VERSION    : number indicating the MQTT protocol version to be used (3, 4, or 5)
  THING_IDx       : string with TD "id" for which credentials should be configured
  TOKEN           : string for providing a Bearer token
  USERNAME        : string for providing a Basic Auth username
  PASSWORD        : string for providing a Basic Auth password
  ---------------------------------------------------------------------------

Environment variables must be provided in a .env file in the current working directory.

Example:
VAR1=Value1
VAR2=Value2`);
        process.exit(0);
    }
}
readConf(confFile)
    .catch((err) => {
    if (err.code === "ENOENT" && !confFile) {
        console.warn("[cli]", `WoT-Servient using defaults as '${defaultFile}' does not exist`);
    }
    else {
        console.error("[cli]", "WoT-Servient config file error:", err.message);
        process.exit(err.errno);
    }
})
    .then(overrideConfig)
    .then((conf) => {
    return new cli_default_servient_1.default(clientOnly, conf);
})
    .then((servient) => {
    servient
        .start()
        .then(() => {
        if (argv.length > 0) {
            console.info("[cli]", `WoT-Servient loading ${argv.length} command line script${argv.length > 1 ? "s" : ""}`);
            return runScripts(servient, argv, debug);
        }
        else {
            return runAllScripts(servient, debug);
        }
    })
        .catch((err) => {
        console.error("[cli]", "WoT-Servient cannot start:", err.message);
    });
})
    .catch((err) => console.error("[cli]", "WoT-Servient main error:", err.message));
//# sourceMappingURL=cli.js.map