// Code generated by capnpc-go. DO NOT EDIT.

package tunnelrpc

import (
	context "golang.org/x/net/context"
	strconv "strconv"
	capnp "zombiezen.com/go/capnproto2"
	text "zombiezen.com/go/capnproto2/encoding/text"
	schemas "zombiezen.com/go/capnproto2/schemas"
	server "zombiezen.com/go/capnproto2/server"
)

type Authentication struct{ capnp.Struct }

// Authentication_TypeID is the unique identifier for the type Authentication.
const Authentication_TypeID = 0xc082ef6e0d42ed1d

func NewAuthentication(s *capnp.Segment) (Authentication, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return Authentication{st}, err
}

func NewRootAuthentication(s *capnp.Segment) (Authentication, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return Authentication{st}, err
}

func ReadRootAuthentication(msg *capnp.Message) (Authentication, error) {
	root, err := msg.RootPtr()
	return Authentication{root.Struct()}, err
}

func (s Authentication) String() string {
	str, _ := text.Marshal(0xc082ef6e0d42ed1d, s.Struct)
	return str
}

func (s Authentication) Key() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Authentication) HasKey() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Authentication) KeyBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Authentication) SetKey(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Authentication) Email() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s Authentication) HasEmail() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Authentication) EmailBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s Authentication) SetEmail(v string) error {
	return s.Struct.SetText(1, v)
}

func (s Authentication) OriginCAKey() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s Authentication) HasOriginCAKey() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s Authentication) OriginCAKeyBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s Authentication) SetOriginCAKey(v string) error {
	return s.Struct.SetText(2, v)
}

// Authentication_List is a list of Authentication.
type Authentication_List struct{ capnp.List }

// NewAuthentication creates a new list of Authentication.
func NewAuthentication_List(s *capnp.Segment, sz int32) (Authentication_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return Authentication_List{l}, err
}

func (s Authentication_List) At(i int) Authentication { return Authentication{s.List.Struct(i)} }

func (s Authentication_List) Set(i int, v Authentication) error { return s.List.SetStruct(i, v.Struct) }

func (s Authentication_List) String() string {
	str, _ := text.MarshalList(0xc082ef6e0d42ed1d, s.List)
	return str
}

// Authentication_Promise is a wrapper for a Authentication promised by a client call.
type Authentication_Promise struct{ *capnp.Pipeline }

func (p Authentication_Promise) Struct() (Authentication, error) {
	s, err := p.Pipeline.Struct()
	return Authentication{s}, err
}

type TunnelRegistration struct{ capnp.Struct }

// TunnelRegistration_TypeID is the unique identifier for the type TunnelRegistration.
const TunnelRegistration_TypeID = 0xf41a0f001ad49e46

func NewTunnelRegistration(s *capnp.Segment) (TunnelRegistration, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6})
	return TunnelRegistration{st}, err
}

func NewRootTunnelRegistration(s *capnp.Segment) (TunnelRegistration, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6})
	return TunnelRegistration{st}, err
}

func ReadRootTunnelRegistration(msg *capnp.Message) (TunnelRegistration, error) {
	root, err := msg.RootPtr()
	return TunnelRegistration{root.Struct()}, err
}

func (s TunnelRegistration) String() string {
	str, _ := text.Marshal(0xf41a0f001ad49e46, s.Struct)
	return str
}

func (s TunnelRegistration) Err() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s TunnelRegistration) HasErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) ErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetErr(v string) error {
	return s.Struct.SetText(0, v)
}

func (s TunnelRegistration) Url() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelRegistration) HasUrl() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) UrlBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetUrl(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelRegistration) LogLines() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(2)
	return capnp.TextList{List: p.List()}, err
}

func (s TunnelRegistration) HasLogLines() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetLogLines(v capnp.TextList) error {
	return s.Struct.SetPtr(2, v.List.ToPtr())
}

// NewLogLines sets the logLines field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s TunnelRegistration) NewLogLines(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(2, l.List.ToPtr())
	return l, err
}

func (s TunnelRegistration) PermanentFailure() bool {
	return s.Struct.Bit(0)
}

func (s TunnelRegistration) SetPermanentFailure(v bool) {
	s.Struct.SetBit(0, v)
}

func (s TunnelRegistration) TunnelID() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s TunnelRegistration) HasTunnelID() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) TunnelIDBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetTunnelID(v string) error {
	return s.Struct.SetText(3, v)
}

func (s TunnelRegistration) RetryAfterSeconds() uint16 {
	return s.Struct.Uint16(2)
}

func (s TunnelRegistration) SetRetryAfterSeconds(v uint16) {
	s.Struct.SetUint16(2, v)
}

func (s TunnelRegistration) EventDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(4)
	return []byte(p.Data()), err
}

func (s TunnelRegistration) HasEventDigest() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetEventDigest(v []byte) error {
	return s.Struct.SetData(4, v)
}

func (s TunnelRegistration) ConnDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(5)
	return []byte(p.Data()), err
}

func (s TunnelRegistration) HasConnDigest() bool {
	p, err := s.Struct.Ptr(5)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetConnDigest(v []byte) error {
	return s.Struct.SetData(5, v)
}

// TunnelRegistration_List is a list of TunnelRegistration.
type TunnelRegistration_List struct{ capnp.List }

// NewTunnelRegistration creates a new list of TunnelRegistration.
func NewTunnelRegistration_List(s *capnp.Segment, sz int32) (TunnelRegistration_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6}, sz)
	return TunnelRegistration_List{l}, err
}

func (s TunnelRegistration_List) At(i int) TunnelRegistration {
	return TunnelRegistration{s.List.Struct(i)}
}

func (s TunnelRegistration_List) Set(i int, v TunnelRegistration) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelRegistration_List) String() string {
	str, _ := text.MarshalList(0xf41a0f001ad49e46, s.List)
	return str
}

// TunnelRegistration_Promise is a wrapper for a TunnelRegistration promised by a client call.
type TunnelRegistration_Promise struct{ *capnp.Pipeline }

func (p TunnelRegistration_Promise) Struct() (TunnelRegistration, error) {
	s, err := p.Pipeline.Struct()
	return TunnelRegistration{s}, err
}

type RegistrationOptions struct{ capnp.Struct }

// RegistrationOptions_TypeID is the unique identifier for the type RegistrationOptions.
const RegistrationOptions_TypeID = 0xc793e50592935b4a

func NewRegistrationOptions(s *capnp.Segment) (RegistrationOptions, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8})
	return RegistrationOptions{st}, err
}

func NewRootRegistrationOptions(s *capnp.Segment) (RegistrationOptions, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8})
	return RegistrationOptions{st}, err
}

func ReadRootRegistrationOptions(msg *capnp.Message) (RegistrationOptions, error) {
	root, err := msg.RootPtr()
	return RegistrationOptions{root.Struct()}, err
}

func (s RegistrationOptions) String() string {
	str, _ := text.Marshal(0xc793e50592935b4a, s.Struct)
	return str
}

func (s RegistrationOptions) ClientId() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s RegistrationOptions) HasClientId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) ClientIdBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetClientId(v string) error {
	return s.Struct.SetText(0, v)
}

func (s RegistrationOptions) Version() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s RegistrationOptions) HasVersion() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) VersionBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetVersion(v string) error {
	return s.Struct.SetText(1, v)
}

func (s RegistrationOptions) Os() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s RegistrationOptions) HasOs() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) OsBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetOs(v string) error {
	return s.Struct.SetText(2, v)
}

func (s RegistrationOptions) ExistingTunnelPolicy() ExistingTunnelPolicy {
	return ExistingTunnelPolicy(s.Struct.Uint16(0))
}

func (s RegistrationOptions) SetExistingTunnelPolicy(v ExistingTunnelPolicy) {
	s.Struct.SetUint16(0, uint16(v))
}

func (s RegistrationOptions) PoolName() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s RegistrationOptions) HasPoolName() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) PoolNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetPoolName(v string) error {
	return s.Struct.SetText(3, v)
}

func (s RegistrationOptions) Tags() (Tag_List, error) {
	p, err := s.Struct.Ptr(4)
	return Tag_List{List: p.List()}, err
}

func (s RegistrationOptions) HasTags() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) SetTags(v Tag_List) error {
	return s.Struct.SetPtr(4, v.List.ToPtr())
}

// NewTags sets the tags field to a newly
// allocated Tag_List, preferring placement in s's segment.
func (s RegistrationOptions) NewTags(n int32) (Tag_List, error) {
	l, err := NewTag_List(s.Struct.Segment(), n)
	if err != nil {
		return Tag_List{}, err
	}
	err = s.Struct.SetPtr(4, l.List.ToPtr())
	return l, err
}

func (s RegistrationOptions) ConnectionId() uint8 {
	return s.Struct.Uint8(2)
}

func (s RegistrationOptions) SetConnectionId(v uint8) {
	s.Struct.SetUint8(2, v)
}

func (s RegistrationOptions) OriginLocalIp() (string, error) {
	p, err := s.Struct.Ptr(5)
	return p.Text(), err
}

func (s RegistrationOptions) HasOriginLocalIp() bool {
	p, err := s.Struct.Ptr(5)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) OriginLocalIpBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(5)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetOriginLocalIp(v string) error {
	return s.Struct.SetText(5, v)
}

func (s RegistrationOptions) IsAutoupdated() bool {
	return s.Struct.Bit(24)
}

func (s RegistrationOptions) SetIsAutoupdated(v bool) {
	s.Struct.SetBit(24, v)
}

func (s RegistrationOptions) RunFromTerminal() bool {
	return s.Struct.Bit(25)
}

func (s RegistrationOptions) SetRunFromTerminal(v bool) {
	s.Struct.SetBit(25, v)
}

func (s RegistrationOptions) CompressionQuality() uint64 {
	return s.Struct.Uint64(8)
}

func (s RegistrationOptions) SetCompressionQuality(v uint64) {
	s.Struct.SetUint64(8, v)
}

func (s RegistrationOptions) Uuid() (string, error) {
	p, err := s.Struct.Ptr(6)
	return p.Text(), err
}

func (s RegistrationOptions) HasUuid() bool {
	p, err := s.Struct.Ptr(6)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) UuidBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(6)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetUuid(v string) error {
	return s.Struct.SetText(6, v)
}

func (s RegistrationOptions) NumPreviousAttempts() uint8 {
	return s.Struct.Uint8(4)
}

func (s RegistrationOptions) SetNumPreviousAttempts(v uint8) {
	s.Struct.SetUint8(4, v)
}

func (s RegistrationOptions) Features() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(7)
	return capnp.TextList{List: p.List()}, err
}

func (s RegistrationOptions) HasFeatures() bool {
	p, err := s.Struct.Ptr(7)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) SetFeatures(v capnp.TextList) error {
	return s.Struct.SetPtr(7, v.List.ToPtr())
}

// NewFeatures sets the features field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s RegistrationOptions) NewFeatures(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(7, l.List.ToPtr())
	return l, err
}

// RegistrationOptions_List is a list of RegistrationOptions.
type RegistrationOptions_List struct{ capnp.List }

// NewRegistrationOptions creates a new list of RegistrationOptions.
func NewRegistrationOptions_List(s *capnp.Segment, sz int32) (RegistrationOptions_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8}, sz)
	return RegistrationOptions_List{l}, err
}

func (s RegistrationOptions_List) At(i int) RegistrationOptions {
	return RegistrationOptions{s.List.Struct(i)}
}

func (s RegistrationOptions_List) Set(i int, v RegistrationOptions) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationOptions_List) String() string {
	str, _ := text.MarshalList(0xc793e50592935b4a, s.List)
	return str
}

// RegistrationOptions_Promise is a wrapper for a RegistrationOptions promised by a client call.
type RegistrationOptions_Promise struct{ *capnp.Pipeline }

func (p RegistrationOptions_Promise) Struct() (RegistrationOptions, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationOptions{s}, err
}

type Tag struct{ capnp.Struct }

// Tag_TypeID is the unique identifier for the type Tag.
const Tag_TypeID = 0xcbd96442ae3bb01a

func NewTag(s *capnp.Segment) (Tag, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Tag{st}, err
}

func NewRootTag(s *capnp.Segment) (Tag, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Tag{st}, err
}

func ReadRootTag(msg *capnp.Message) (Tag, error) {
	root, err := msg.RootPtr()
	return Tag{root.Struct()}, err
}

func (s Tag) String() string {
	str, _ := text.Marshal(0xcbd96442ae3bb01a, s.Struct)
	return str
}

func (s Tag) Name() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Tag) HasName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Tag) NameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Tag) SetName(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Tag) Value() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s Tag) HasValue() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Tag) ValueBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s Tag) SetValue(v string) error {
	return s.Struct.SetText(1, v)
}

// Tag_List is a list of Tag.
type Tag_List struct{ capnp.List }

// NewTag creates a new list of Tag.
func NewTag_List(s *capnp.Segment, sz int32) (Tag_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return Tag_List{l}, err
}

func (s Tag_List) At(i int) Tag { return Tag{s.List.Struct(i)} }

func (s Tag_List) Set(i int, v Tag) error { return s.List.SetStruct(i, v.Struct) }

func (s Tag_List) String() string {
	str, _ := text.MarshalList(0xcbd96442ae3bb01a, s.List)
	return str
}

// Tag_Promise is a wrapper for a Tag promised by a client call.
type Tag_Promise struct{ *capnp.Pipeline }

func (p Tag_Promise) Struct() (Tag, error) {
	s, err := p.Pipeline.Struct()
	return Tag{s}, err
}

type ExistingTunnelPolicy uint16

// ExistingTunnelPolicy_TypeID is the unique identifier for the type ExistingTunnelPolicy.
const ExistingTunnelPolicy_TypeID = 0x84cb9536a2cf6d3c

// Values of ExistingTunnelPolicy.
const (
	ExistingTunnelPolicy_ignore     ExistingTunnelPolicy = 0
	ExistingTunnelPolicy_disconnect ExistingTunnelPolicy = 1
	ExistingTunnelPolicy_balance    ExistingTunnelPolicy = 2
)

// String returns the enum's constant name.
func (c ExistingTunnelPolicy) String() string {
	switch c {
	case ExistingTunnelPolicy_ignore:
		return "ignore"
	case ExistingTunnelPolicy_disconnect:
		return "disconnect"
	case ExistingTunnelPolicy_balance:
		return "balance"

	default:
		return ""
	}
}

// ExistingTunnelPolicyFromString returns the enum value with a name,
// or the zero value if there's no such value.
func ExistingTunnelPolicyFromString(c string) ExistingTunnelPolicy {
	switch c {
	case "ignore":
		return ExistingTunnelPolicy_ignore
	case "disconnect":
		return ExistingTunnelPolicy_disconnect
	case "balance":
		return ExistingTunnelPolicy_balance

	default:
		return 0
	}
}

type ExistingTunnelPolicy_List struct{ capnp.List }

func NewExistingTunnelPolicy_List(s *capnp.Segment, sz int32) (ExistingTunnelPolicy_List, error) {
	l, err := capnp.NewUInt16List(s, sz)
	return ExistingTunnelPolicy_List{l.List}, err
}

func (l ExistingTunnelPolicy_List) At(i int) ExistingTunnelPolicy {
	ul := capnp.UInt16List{List: l.List}
	return ExistingTunnelPolicy(ul.At(i))
}

func (l ExistingTunnelPolicy_List) Set(i int, v ExistingTunnelPolicy) {
	ul := capnp.UInt16List{List: l.List}
	ul.Set(i, uint16(v))
}

type ServerInfo struct{ capnp.Struct }

// ServerInfo_TypeID is the unique identifier for the type ServerInfo.
const ServerInfo_TypeID = 0xf2c68e2547ec3866

func NewServerInfo(s *capnp.Segment) (ServerInfo, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ServerInfo{st}, err
}

func NewRootServerInfo(s *capnp.Segment) (ServerInfo, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ServerInfo{st}, err
}

func ReadRootServerInfo(msg *capnp.Message) (ServerInfo, error) {
	root, err := msg.RootPtr()
	return ServerInfo{root.Struct()}, err
}

func (s ServerInfo) String() string {
	str, _ := text.Marshal(0xf2c68e2547ec3866, s.Struct)
	return str
}

func (s ServerInfo) LocationName() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s ServerInfo) HasLocationName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ServerInfo) LocationNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s ServerInfo) SetLocationName(v string) error {
	return s.Struct.SetText(0, v)
}

// ServerInfo_List is a list of ServerInfo.
type ServerInfo_List struct{ capnp.List }

// NewServerInfo creates a new list of ServerInfo.
func NewServerInfo_List(s *capnp.Segment, sz int32) (ServerInfo_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return ServerInfo_List{l}, err
}

func (s ServerInfo_List) At(i int) ServerInfo { return ServerInfo{s.List.Struct(i)} }

func (s ServerInfo_List) Set(i int, v ServerInfo) error { return s.List.SetStruct(i, v.Struct) }

func (s ServerInfo_List) String() string {
	str, _ := text.MarshalList(0xf2c68e2547ec3866, s.List)
	return str
}

// ServerInfo_Promise is a wrapper for a ServerInfo promised by a client call.
type ServerInfo_Promise struct{ *capnp.Pipeline }

func (p ServerInfo_Promise) Struct() (ServerInfo, error) {
	s, err := p.Pipeline.Struct()
	return ServerInfo{s}, err
}

type AuthenticateResponse struct{ capnp.Struct }

// AuthenticateResponse_TypeID is the unique identifier for the type AuthenticateResponse.
const AuthenticateResponse_TypeID = 0x82c325a07ad22a65

func NewAuthenticateResponse(s *capnp.Segment) (AuthenticateResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return AuthenticateResponse{st}, err
}

func NewRootAuthenticateResponse(s *capnp.Segment) (AuthenticateResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return AuthenticateResponse{st}, err
}

func ReadRootAuthenticateResponse(msg *capnp.Message) (AuthenticateResponse, error) {
	root, err := msg.RootPtr()
	return AuthenticateResponse{root.Struct()}, err
}

func (s AuthenticateResponse) String() string {
	str, _ := text.Marshal(0x82c325a07ad22a65, s.Struct)
	return str
}

func (s AuthenticateResponse) PermanentErr() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s AuthenticateResponse) HasPermanentErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) PermanentErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s AuthenticateResponse) SetPermanentErr(v string) error {
	return s.Struct.SetText(0, v)
}

func (s AuthenticateResponse) RetryableErr() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s AuthenticateResponse) HasRetryableErr() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) RetryableErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s AuthenticateResponse) SetRetryableErr(v string) error {
	return s.Struct.SetText(1, v)
}

func (s AuthenticateResponse) Jwt() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return []byte(p.Data()), err
}

func (s AuthenticateResponse) HasJwt() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) SetJwt(v []byte) error {
	return s.Struct.SetData(2, v)
}

func (s AuthenticateResponse) HoursUntilRefresh() uint8 {
	return s.Struct.Uint8(0)
}

func (s AuthenticateResponse) SetHoursUntilRefresh(v uint8) {
	s.Struct.SetUint8(0, v)
}

// AuthenticateResponse_List is a list of AuthenticateResponse.
type AuthenticateResponse_List struct{ capnp.List }

// NewAuthenticateResponse creates a new list of AuthenticateResponse.
func NewAuthenticateResponse_List(s *capnp.Segment, sz int32) (AuthenticateResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3}, sz)
	return AuthenticateResponse_List{l}, err
}

func (s AuthenticateResponse_List) At(i int) AuthenticateResponse {
	return AuthenticateResponse{s.List.Struct(i)}
}

func (s AuthenticateResponse_List) Set(i int, v AuthenticateResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s AuthenticateResponse_List) String() string {
	str, _ := text.MarshalList(0x82c325a07ad22a65, s.List)
	return str
}

// AuthenticateResponse_Promise is a wrapper for a AuthenticateResponse promised by a client call.
type AuthenticateResponse_Promise struct{ *capnp.Pipeline }

func (p AuthenticateResponse_Promise) Struct() (AuthenticateResponse, error) {
	s, err := p.Pipeline.Struct()
	return AuthenticateResponse{s}, err
}

type ClientInfo struct{ capnp.Struct }

// ClientInfo_TypeID is the unique identifier for the type ClientInfo.
const ClientInfo_TypeID = 0x83ced0145b2f114b

func NewClientInfo(s *capnp.Segment) (ClientInfo, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4})
	return ClientInfo{st}, err
}

func NewRootClientInfo(s *capnp.Segment) (ClientInfo, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4})
	return ClientInfo{st}, err
}

func ReadRootClientInfo(msg *capnp.Message) (ClientInfo, error) {
	root, err := msg.RootPtr()
	return ClientInfo{root.Struct()}, err
}

func (s ClientInfo) String() string {
	str, _ := text.Marshal(0x83ced0145b2f114b, s.Struct)
	return str
}

func (s ClientInfo) ClientId() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s ClientInfo) HasClientId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ClientInfo) SetClientId(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s ClientInfo) Features() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(1)
	return capnp.TextList{List: p.List()}, err
}

func (s ClientInfo) HasFeatures() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ClientInfo) SetFeatures(v capnp.TextList) error {
	return s.Struct.SetPtr(1, v.List.ToPtr())
}

// NewFeatures sets the features field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s ClientInfo) NewFeatures(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(1, l.List.ToPtr())
	return l, err
}

func (s ClientInfo) Version() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s ClientInfo) HasVersion() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s ClientInfo) VersionBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s ClientInfo) SetVersion(v string) error {
	return s.Struct.SetText(2, v)
}

func (s ClientInfo) Arch() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s ClientInfo) HasArch() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s ClientInfo) ArchBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s ClientInfo) SetArch(v string) error {
	return s.Struct.SetText(3, v)
}

// ClientInfo_List is a list of ClientInfo.
type ClientInfo_List struct{ capnp.List }

// NewClientInfo creates a new list of ClientInfo.
func NewClientInfo_List(s *capnp.Segment, sz int32) (ClientInfo_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4}, sz)
	return ClientInfo_List{l}, err
}

func (s ClientInfo_List) At(i int) ClientInfo { return ClientInfo{s.List.Struct(i)} }

func (s ClientInfo_List) Set(i int, v ClientInfo) error { return s.List.SetStruct(i, v.Struct) }

func (s ClientInfo_List) String() string {
	str, _ := text.MarshalList(0x83ced0145b2f114b, s.List)
	return str
}

// ClientInfo_Promise is a wrapper for a ClientInfo promised by a client call.
type ClientInfo_Promise struct{ *capnp.Pipeline }

func (p ClientInfo_Promise) Struct() (ClientInfo, error) {
	s, err := p.Pipeline.Struct()
	return ClientInfo{s}, err
}

type ConnectionOptions struct{ capnp.Struct }

// ConnectionOptions_TypeID is the unique identifier for the type ConnectionOptions.
const ConnectionOptions_TypeID = 0xb4bf9861fe035d04

func NewConnectionOptions(s *capnp.Segment) (ConnectionOptions, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return ConnectionOptions{st}, err
}

func NewRootConnectionOptions(s *capnp.Segment) (ConnectionOptions, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return ConnectionOptions{st}, err
}

func ReadRootConnectionOptions(msg *capnp.Message) (ConnectionOptions, error) {
	root, err := msg.RootPtr()
	return ConnectionOptions{root.Struct()}, err
}

func (s ConnectionOptions) String() string {
	str, _ := text.Marshal(0xb4bf9861fe035d04, s.Struct)
	return str
}

func (s ConnectionOptions) Client() (ClientInfo, error) {
	p, err := s.Struct.Ptr(0)
	return ClientInfo{Struct: p.Struct()}, err
}

func (s ConnectionOptions) HasClient() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionOptions) SetClient(v ClientInfo) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewClient sets the client field to a newly
// allocated ClientInfo struct, preferring placement in s's segment.
func (s ConnectionOptions) NewClient() (ClientInfo, error) {
	ss, err := NewClientInfo(s.Struct.Segment())
	if err != nil {
		return ClientInfo{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s ConnectionOptions) OriginLocalIp() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s ConnectionOptions) HasOriginLocalIp() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ConnectionOptions) SetOriginLocalIp(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s ConnectionOptions) ReplaceExisting() bool {
	return s.Struct.Bit(0)
}

func (s ConnectionOptions) SetReplaceExisting(v bool) {
	s.Struct.SetBit(0, v)
}

func (s ConnectionOptions) CompressionQuality() uint8 {
	return s.Struct.Uint8(1)
}

func (s ConnectionOptions) SetCompressionQuality(v uint8) {
	s.Struct.SetUint8(1, v)
}

func (s ConnectionOptions) NumPreviousAttempts() uint8 {
	return s.Struct.Uint8(2)
}

func (s ConnectionOptions) SetNumPreviousAttempts(v uint8) {
	s.Struct.SetUint8(2, v)
}

// ConnectionOptions_List is a list of ConnectionOptions.
type ConnectionOptions_List struct{ capnp.List }

// NewConnectionOptions creates a new list of ConnectionOptions.
func NewConnectionOptions_List(s *capnp.Segment, sz int32) (ConnectionOptions_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return ConnectionOptions_List{l}, err
}

func (s ConnectionOptions_List) At(i int) ConnectionOptions {
	return ConnectionOptions{s.List.Struct(i)}
}

func (s ConnectionOptions_List) Set(i int, v ConnectionOptions) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionOptions_List) String() string {
	str, _ := text.MarshalList(0xb4bf9861fe035d04, s.List)
	return str
}

// ConnectionOptions_Promise is a wrapper for a ConnectionOptions promised by a client call.
type ConnectionOptions_Promise struct{ *capnp.Pipeline }

func (p ConnectionOptions_Promise) Struct() (ConnectionOptions, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionOptions{s}, err
}

func (p ConnectionOptions_Promise) Client() ClientInfo_Promise {
	return ClientInfo_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type ConnectionResponse struct{ capnp.Struct }
type ConnectionResponse_result ConnectionResponse
type ConnectionResponse_result_Which uint16

const (
	ConnectionResponse_result_Which_error             ConnectionResponse_result_Which = 0
	ConnectionResponse_result_Which_connectionDetails ConnectionResponse_result_Which = 1
)

func (w ConnectionResponse_result_Which) String() string {
	const s = "errorconnectionDetails"
	switch w {
	case ConnectionResponse_result_Which_error:
		return s[0:5]
	case ConnectionResponse_result_Which_connectionDetails:
		return s[5:22]

	}
	return "ConnectionResponse_result_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// ConnectionResponse_TypeID is the unique identifier for the type ConnectionResponse.
const ConnectionResponse_TypeID = 0xdbaa9d03d52b62dc

func NewConnectionResponse(s *capnp.Segment) (ConnectionResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ConnectionResponse{st}, err
}

func NewRootConnectionResponse(s *capnp.Segment) (ConnectionResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ConnectionResponse{st}, err
}

func ReadRootConnectionResponse(msg *capnp.Message) (ConnectionResponse, error) {
	root, err := msg.RootPtr()
	return ConnectionResponse{root.Struct()}, err
}

func (s ConnectionResponse) String() string {
	str, _ := text.Marshal(0xdbaa9d03d52b62dc, s.Struct)
	return str
}

func (s ConnectionResponse) Result() ConnectionResponse_result { return ConnectionResponse_result(s) }

func (s ConnectionResponse_result) Which() ConnectionResponse_result_Which {
	return ConnectionResponse_result_Which(s.Struct.Uint16(0))
}
func (s ConnectionResponse_result) Error() (ConnectionError, error) {
	if s.Struct.Uint16(0) != 0 {
		panic("Which() != error")
	}
	p, err := s.Struct.Ptr(0)
	return ConnectionError{Struct: p.Struct()}, err
}

func (s ConnectionResponse_result) HasError() bool {
	if s.Struct.Uint16(0) != 0 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionResponse_result) SetError(v ConnectionError) error {
	s.Struct.SetUint16(0, 0)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewError sets the error field to a newly
// allocated ConnectionError struct, preferring placement in s's segment.
func (s ConnectionResponse_result) NewError() (ConnectionError, error) {
	s.Struct.SetUint16(0, 0)
	ss, err := NewConnectionError(s.Struct.Segment())
	if err != nil {
		return ConnectionError{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s ConnectionResponse_result) ConnectionDetails() (ConnectionDetails, error) {
	if s.Struct.Uint16(0) != 1 {
		panic("Which() != connectionDetails")
	}
	p, err := s.Struct.Ptr(0)
	return ConnectionDetails{Struct: p.Struct()}, err
}

func (s ConnectionResponse_result) HasConnectionDetails() bool {
	if s.Struct.Uint16(0) != 1 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionResponse_result) SetConnectionDetails(v ConnectionDetails) error {
	s.Struct.SetUint16(0, 1)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewConnectionDetails sets the connectionDetails field to a newly
// allocated ConnectionDetails struct, preferring placement in s's segment.
func (s ConnectionResponse_result) NewConnectionDetails() (ConnectionDetails, error) {
	s.Struct.SetUint16(0, 1)
	ss, err := NewConnectionDetails(s.Struct.Segment())
	if err != nil {
		return ConnectionDetails{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// ConnectionResponse_List is a list of ConnectionResponse.
type ConnectionResponse_List struct{ capnp.List }

// NewConnectionResponse creates a new list of ConnectionResponse.
func NewConnectionResponse_List(s *capnp.Segment, sz int32) (ConnectionResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return ConnectionResponse_List{l}, err
}

func (s ConnectionResponse_List) At(i int) ConnectionResponse {
	return ConnectionResponse{s.List.Struct(i)}
}

func (s ConnectionResponse_List) Set(i int, v ConnectionResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionResponse_List) String() string {
	str, _ := text.MarshalList(0xdbaa9d03d52b62dc, s.List)
	return str
}

// ConnectionResponse_Promise is a wrapper for a ConnectionResponse promised by a client call.
type ConnectionResponse_Promise struct{ *capnp.Pipeline }

func (p ConnectionResponse_Promise) Struct() (ConnectionResponse, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionResponse{s}, err
}

func (p ConnectionResponse_Promise) Result() ConnectionResponse_result_Promise {
	return ConnectionResponse_result_Promise{p.Pipeline}
}

// ConnectionResponse_result_Promise is a wrapper for a ConnectionResponse_result promised by a client call.
type ConnectionResponse_result_Promise struct{ *capnp.Pipeline }

func (p ConnectionResponse_result_Promise) Struct() (ConnectionResponse_result, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionResponse_result{s}, err
}

func (p ConnectionResponse_result_Promise) Error() ConnectionError_Promise {
	return ConnectionError_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p ConnectionResponse_result_Promise) ConnectionDetails() ConnectionDetails_Promise {
	return ConnectionDetails_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type ConnectionError struct{ capnp.Struct }

// ConnectionError_TypeID is the unique identifier for the type ConnectionError.
const ConnectionError_TypeID = 0xf5f383d2785edb86

func NewConnectionError(s *capnp.Segment) (ConnectionError, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return ConnectionError{st}, err
}

func NewRootConnectionError(s *capnp.Segment) (ConnectionError, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return ConnectionError{st}, err
}

func ReadRootConnectionError(msg *capnp.Message) (ConnectionError, error) {
	root, err := msg.RootPtr()
	return ConnectionError{root.Struct()}, err
}

func (s ConnectionError) String() string {
	str, _ := text.Marshal(0xf5f383d2785edb86, s.Struct)
	return str
}

func (s ConnectionError) Cause() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s ConnectionError) HasCause() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionError) CauseBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s ConnectionError) SetCause(v string) error {
	return s.Struct.SetText(0, v)
}

func (s ConnectionError) RetryAfter() int64 {
	return int64(s.Struct.Uint64(0))
}

func (s ConnectionError) SetRetryAfter(v int64) {
	s.Struct.SetUint64(0, uint64(v))
}

func (s ConnectionError) ShouldRetry() bool {
	return s.Struct.Bit(64)
}

func (s ConnectionError) SetShouldRetry(v bool) {
	s.Struct.SetBit(64, v)
}

// ConnectionError_List is a list of ConnectionError.
type ConnectionError_List struct{ capnp.List }

// NewConnectionError creates a new list of ConnectionError.
func NewConnectionError_List(s *capnp.Segment, sz int32) (ConnectionError_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1}, sz)
	return ConnectionError_List{l}, err
}

func (s ConnectionError_List) At(i int) ConnectionError { return ConnectionError{s.List.Struct(i)} }

func (s ConnectionError_List) Set(i int, v ConnectionError) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionError_List) String() string {
	str, _ := text.MarshalList(0xf5f383d2785edb86, s.List)
	return str
}

// ConnectionError_Promise is a wrapper for a ConnectionError promised by a client call.
type ConnectionError_Promise struct{ *capnp.Pipeline }

func (p ConnectionError_Promise) Struct() (ConnectionError, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionError{s}, err
}

type ConnectionDetails struct{ capnp.Struct }

// ConnectionDetails_TypeID is the unique identifier for the type ConnectionDetails.
const ConnectionDetails_TypeID = 0xb5f39f082b9ac18a

func NewConnectionDetails(s *capnp.Segment) (ConnectionDetails, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return ConnectionDetails{st}, err
}

func NewRootConnectionDetails(s *capnp.Segment) (ConnectionDetails, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return ConnectionDetails{st}, err
}

func ReadRootConnectionDetails(msg *capnp.Message) (ConnectionDetails, error) {
	root, err := msg.RootPtr()
	return ConnectionDetails{root.Struct()}, err
}

func (s ConnectionDetails) String() string {
	str, _ := text.Marshal(0xb5f39f082b9ac18a, s.Struct)
	return str
}

func (s ConnectionDetails) Uuid() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s ConnectionDetails) HasUuid() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionDetails) SetUuid(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s ConnectionDetails) LocationName() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s ConnectionDetails) HasLocationName() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ConnectionDetails) LocationNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s ConnectionDetails) SetLocationName(v string) error {
	return s.Struct.SetText(1, v)
}

// ConnectionDetails_List is a list of ConnectionDetails.
type ConnectionDetails_List struct{ capnp.List }

// NewConnectionDetails creates a new list of ConnectionDetails.
func NewConnectionDetails_List(s *capnp.Segment, sz int32) (ConnectionDetails_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return ConnectionDetails_List{l}, err
}

func (s ConnectionDetails_List) At(i int) ConnectionDetails {
	return ConnectionDetails{s.List.Struct(i)}
}

func (s ConnectionDetails_List) Set(i int, v ConnectionDetails) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionDetails_List) String() string {
	str, _ := text.MarshalList(0xb5f39f082b9ac18a, s.List)
	return str
}

// ConnectionDetails_Promise is a wrapper for a ConnectionDetails promised by a client call.
type ConnectionDetails_Promise struct{ *capnp.Pipeline }

func (p ConnectionDetails_Promise) Struct() (ConnectionDetails, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionDetails{s}, err
}

type TunnelAuth struct{ capnp.Struct }

// TunnelAuth_TypeID is the unique identifier for the type TunnelAuth.
const TunnelAuth_TypeID = 0x9496331ab9cd463f

func NewTunnelAuth(s *capnp.Segment) (TunnelAuth, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return TunnelAuth{st}, err
}

func NewRootTunnelAuth(s *capnp.Segment) (TunnelAuth, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return TunnelAuth{st}, err
}

func ReadRootTunnelAuth(msg *capnp.Message) (TunnelAuth, error) {
	root, err := msg.RootPtr()
	return TunnelAuth{root.Struct()}, err
}

func (s TunnelAuth) String() string {
	str, _ := text.Marshal(0x9496331ab9cd463f, s.Struct)
	return str
}

func (s TunnelAuth) AccountTag() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s TunnelAuth) HasAccountTag() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelAuth) AccountTagBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s TunnelAuth) SetAccountTag(v string) error {
	return s.Struct.SetText(0, v)
}

func (s TunnelAuth) TunnelSecret() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s TunnelAuth) HasTunnelSecret() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelAuth) SetTunnelSecret(v []byte) error {
	return s.Struct.SetData(1, v)
}

// TunnelAuth_List is a list of TunnelAuth.
type TunnelAuth_List struct{ capnp.List }

// NewTunnelAuth creates a new list of TunnelAuth.
func NewTunnelAuth_List(s *capnp.Segment, sz int32) (TunnelAuth_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return TunnelAuth_List{l}, err
}

func (s TunnelAuth_List) At(i int) TunnelAuth { return TunnelAuth{s.List.Struct(i)} }

func (s TunnelAuth_List) Set(i int, v TunnelAuth) error { return s.List.SetStruct(i, v.Struct) }

func (s TunnelAuth_List) String() string {
	str, _ := text.MarshalList(0x9496331ab9cd463f, s.List)
	return str
}

// TunnelAuth_Promise is a wrapper for a TunnelAuth promised by a client call.
type TunnelAuth_Promise struct{ *capnp.Pipeline }

func (p TunnelAuth_Promise) Struct() (TunnelAuth, error) {
	s, err := p.Pipeline.Struct()
	return TunnelAuth{s}, err
}

type RegistrationServer struct{ Client capnp.Client }

// RegistrationServer_TypeID is the unique identifier for the type RegistrationServer.
const RegistrationServer_TypeID = 0xf71695ec7fe85497

func (c RegistrationServer) RegisterConnection(ctx context.Context, params func(RegistrationServer_registerConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_registerConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_registerConnection_Params{Struct: s}) }
	}
	return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c RegistrationServer) UnregisterConnection(ctx context.Context, params func(RegistrationServer_unregisterConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_unregisterConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_unregisterConnection_Params{Struct: s}) }
	}
	return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type RegistrationServer_Server interface {
	RegisterConnection(RegistrationServer_registerConnection) error

	UnregisterConnection(RegistrationServer_unregisterConnection) error
}

func RegistrationServer_ServerToClient(s RegistrationServer_Server) RegistrationServer {
	c, _ := s.(server.Closer)
	return RegistrationServer{Client: server.New(RegistrationServer_Methods(nil, s), c)}
}

func RegistrationServer_Methods(methods []server.Method, s RegistrationServer_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 2)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_registerConnection{c, opts, RegistrationServer_registerConnection_Params{Struct: p}, RegistrationServer_registerConnection_Results{Struct: r}}
			return s.RegisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_unregisterConnection{c, opts, RegistrationServer_unregisterConnection_Params{Struct: p}, RegistrationServer_unregisterConnection_Results{Struct: r}}
			return s.UnregisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	return methods
}

// RegistrationServer_registerConnection holds the arguments for a server call to RegistrationServer.registerConnection.
type RegistrationServer_registerConnection struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  RegistrationServer_registerConnection_Params
	Results RegistrationServer_registerConnection_Results
}

// RegistrationServer_unregisterConnection holds the arguments for a server call to RegistrationServer.unregisterConnection.
type RegistrationServer_unregisterConnection struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  RegistrationServer_unregisterConnection_Params
	Results RegistrationServer_unregisterConnection_Results
}

type RegistrationServer_registerConnection_Params struct{ capnp.Struct }

// RegistrationServer_registerConnection_Params_TypeID is the unique identifier for the type RegistrationServer_registerConnection_Params.
const RegistrationServer_registerConnection_Params_TypeID = 0xe6646dec8feaa6ee

func NewRegistrationServer_registerConnection_Params(s *capnp.Segment) (RegistrationServer_registerConnection_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return RegistrationServer_registerConnection_Params{st}, err
}

func NewRootRegistrationServer_registerConnection_Params(s *capnp.Segment) (RegistrationServer_registerConnection_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return RegistrationServer_registerConnection_Params{st}, err
}

func ReadRootRegistrationServer_registerConnection_Params(msg *capnp.Message) (RegistrationServer_registerConnection_Params, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_registerConnection_Params{root.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) String() string {
	str, _ := text.Marshal(0xe6646dec8feaa6ee, s.Struct)
	return str
}

func (s RegistrationServer_registerConnection_Params) Auth() (TunnelAuth, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelAuth{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) HasAuth() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetAuth(v TunnelAuth) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewAuth sets the auth field to a newly
// allocated TunnelAuth struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Params) NewAuth() (TunnelAuth, error) {
	ss, err := NewTunnelAuth(s.Struct.Segment())
	if err != nil {
		return TunnelAuth{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s RegistrationServer_registerConnection_Params) TunnelId() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s RegistrationServer_registerConnection_Params) HasTunnelId() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetTunnelId(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s RegistrationServer_registerConnection_Params) ConnIndex() uint8 {
	return s.Struct.Uint8(0)
}

func (s RegistrationServer_registerConnection_Params) SetConnIndex(v uint8) {
	s.Struct.SetUint8(0, v)
}

func (s RegistrationServer_registerConnection_Params) Options() (ConnectionOptions, error) {
	p, err := s.Struct.Ptr(2)
	return ConnectionOptions{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetOptions(v ConnectionOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated ConnectionOptions struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Params) NewOptions() (ConnectionOptions, error) {
	ss, err := NewConnectionOptions(s.Struct.Segment())
	if err != nil {
		return ConnectionOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// RegistrationServer_registerConnection_Params_List is a list of RegistrationServer_registerConnection_Params.
type RegistrationServer_registerConnection_Params_List struct{ capnp.List }

// NewRegistrationServer_registerConnection_Params creates a new list of RegistrationServer_registerConnection_Params.
func NewRegistrationServer_registerConnection_Params_List(s *capnp.Segment, sz int32) (RegistrationServer_registerConnection_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3}, sz)
	return RegistrationServer_registerConnection_Params_List{l}, err
}

func (s RegistrationServer_registerConnection_Params_List) At(i int) RegistrationServer_registerConnection_Params {
	return RegistrationServer_registerConnection_Params{s.List.Struct(i)}
}

func (s RegistrationServer_registerConnection_Params_List) Set(i int, v RegistrationServer_registerConnection_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_registerConnection_Params_List) String() string {
	str, _ := text.MarshalList(0xe6646dec8feaa6ee, s.List)
	return str
}

// RegistrationServer_registerConnection_Params_Promise is a wrapper for a RegistrationServer_registerConnection_Params promised by a client call.
type RegistrationServer_registerConnection_Params_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_registerConnection_Params_Promise) Struct() (RegistrationServer_registerConnection_Params, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_registerConnection_Params{s}, err
}

func (p RegistrationServer_registerConnection_Params_Promise) Auth() TunnelAuth_Promise {
	return TunnelAuth_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p RegistrationServer_registerConnection_Params_Promise) Options() ConnectionOptions_Promise {
	return ConnectionOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type RegistrationServer_registerConnection_Results struct{ capnp.Struct }

// RegistrationServer_registerConnection_Results_TypeID is the unique identifier for the type RegistrationServer_registerConnection_Results.
const RegistrationServer_registerConnection_Results_TypeID = 0xea50d822450d1f17

func NewRegistrationServer_registerConnection_Results(s *capnp.Segment) (RegistrationServer_registerConnection_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegistrationServer_registerConnection_Results{st}, err
}

func NewRootRegistrationServer_registerConnection_Results(s *capnp.Segment) (RegistrationServer_registerConnection_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegistrationServer_registerConnection_Results{st}, err
}

func ReadRootRegistrationServer_registerConnection_Results(msg *capnp.Message) (RegistrationServer_registerConnection_Results, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_registerConnection_Results{root.Struct()}, err
}

func (s RegistrationServer_registerConnection_Results) String() string {
	str, _ := text.Marshal(0xea50d822450d1f17, s.Struct)
	return str
}

func (s RegistrationServer_registerConnection_Results) Result() (ConnectionResponse, error) {
	p, err := s.Struct.Ptr(0)
	return ConnectionResponse{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Results) SetResult(v ConnectionResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated ConnectionResponse struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Results) NewResult() (ConnectionResponse, error) {
	ss, err := NewConnectionResponse(s.Struct.Segment())
	if err != nil {
		return ConnectionResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// RegistrationServer_registerConnection_Results_List is a list of RegistrationServer_registerConnection_Results.
type RegistrationServer_registerConnection_Results_List struct{ capnp.List }

// NewRegistrationServer_registerConnection_Results creates a new list of RegistrationServer_registerConnection_Results.
func NewRegistrationServer_registerConnection_Results_List(s *capnp.Segment, sz int32) (RegistrationServer_registerConnection_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return RegistrationServer_registerConnection_Results_List{l}, err
}

func (s RegistrationServer_registerConnection_Results_List) At(i int) RegistrationServer_registerConnection_Results {
	return RegistrationServer_registerConnection_Results{s.List.Struct(i)}
}

func (s RegistrationServer_registerConnection_Results_List) Set(i int, v RegistrationServer_registerConnection_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_registerConnection_Results_List) String() string {
	str, _ := text.MarshalList(0xea50d822450d1f17, s.List)
	return str
}

// RegistrationServer_registerConnection_Results_Promise is a wrapper for a RegistrationServer_registerConnection_Results promised by a client call.
type RegistrationServer_registerConnection_Results_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_registerConnection_Results_Promise) Struct() (RegistrationServer_registerConnection_Results, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_registerConnection_Results{s}, err
}

func (p RegistrationServer_registerConnection_Results_Promise) Result() ConnectionResponse_Promise {
	return ConnectionResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type RegistrationServer_unregisterConnection_Params struct{ capnp.Struct }

// RegistrationServer_unregisterConnection_Params_TypeID is the unique identifier for the type RegistrationServer_unregisterConnection_Params.
const RegistrationServer_unregisterConnection_Params_TypeID = 0xf9cb7f4431a307d0

func NewRegistrationServer_unregisterConnection_Params(s *capnp.Segment) (RegistrationServer_unregisterConnection_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Params{st}, err
}

func NewRootRegistrationServer_unregisterConnection_Params(s *capnp.Segment) (RegistrationServer_unregisterConnection_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Params{st}, err
}

func ReadRootRegistrationServer_unregisterConnection_Params(msg *capnp.Message) (RegistrationServer_unregisterConnection_Params, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_unregisterConnection_Params{root.Struct()}, err
}

func (s RegistrationServer_unregisterConnection_Params) String() string {
	str, _ := text.Marshal(0xf9cb7f4431a307d0, s.Struct)
	return str
}

// RegistrationServer_unregisterConnection_Params_List is a list of RegistrationServer_unregisterConnection_Params.
type RegistrationServer_unregisterConnection_Params_List struct{ capnp.List }

// NewRegistrationServer_unregisterConnection_Params creates a new list of RegistrationServer_unregisterConnection_Params.
func NewRegistrationServer_unregisterConnection_Params_List(s *capnp.Segment, sz int32) (RegistrationServer_unregisterConnection_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return RegistrationServer_unregisterConnection_Params_List{l}, err
}

func (s RegistrationServer_unregisterConnection_Params_List) At(i int) RegistrationServer_unregisterConnection_Params {
	return RegistrationServer_unregisterConnection_Params{s.List.Struct(i)}
}

func (s RegistrationServer_unregisterConnection_Params_List) Set(i int, v RegistrationServer_unregisterConnection_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_unregisterConnection_Params_List) String() string {
	str, _ := text.MarshalList(0xf9cb7f4431a307d0, s.List)
	return str
}

// RegistrationServer_unregisterConnection_Params_Promise is a wrapper for a RegistrationServer_unregisterConnection_Params promised by a client call.
type RegistrationServer_unregisterConnection_Params_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_unregisterConnection_Params_Promise) Struct() (RegistrationServer_unregisterConnection_Params, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_unregisterConnection_Params{s}, err
}

type RegistrationServer_unregisterConnection_Results struct{ capnp.Struct }

// RegistrationServer_unregisterConnection_Results_TypeID is the unique identifier for the type RegistrationServer_unregisterConnection_Results.
const RegistrationServer_unregisterConnection_Results_TypeID = 0xb046e578094b1ead

func NewRegistrationServer_unregisterConnection_Results(s *capnp.Segment) (RegistrationServer_unregisterConnection_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Results{st}, err
}

func NewRootRegistrationServer_unregisterConnection_Results(s *capnp.Segment) (RegistrationServer_unregisterConnection_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Results{st}, err
}

func ReadRootRegistrationServer_unregisterConnection_Results(msg *capnp.Message) (RegistrationServer_unregisterConnection_Results, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_unregisterConnection_Results{root.Struct()}, err
}

func (s RegistrationServer_unregisterConnection_Results) String() string {
	str, _ := text.Marshal(0xb046e578094b1ead, s.Struct)
	return str
}

// RegistrationServer_unregisterConnection_Results_List is a list of RegistrationServer_unregisterConnection_Results.
type RegistrationServer_unregisterConnection_Results_List struct{ capnp.List }

// NewRegistrationServer_unregisterConnection_Results creates a new list of RegistrationServer_unregisterConnection_Results.
func NewRegistrationServer_unregisterConnection_Results_List(s *capnp.Segment, sz int32) (RegistrationServer_unregisterConnection_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return RegistrationServer_unregisterConnection_Results_List{l}, err
}

func (s RegistrationServer_unregisterConnection_Results_List) At(i int) RegistrationServer_unregisterConnection_Results {
	return RegistrationServer_unregisterConnection_Results{s.List.Struct(i)}
}

func (s RegistrationServer_unregisterConnection_Results_List) Set(i int, v RegistrationServer_unregisterConnection_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_unregisterConnection_Results_List) String() string {
	str, _ := text.MarshalList(0xb046e578094b1ead, s.List)
	return str
}

// RegistrationServer_unregisterConnection_Results_Promise is a wrapper for a RegistrationServer_unregisterConnection_Results promised by a client call.
type RegistrationServer_unregisterConnection_Results_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_unregisterConnection_Results_Promise) Struct() (RegistrationServer_unregisterConnection_Results, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_unregisterConnection_Results{s}, err
}

type TunnelServer struct{ Client capnp.Client }

// TunnelServer_TypeID is the unique identifier for the type TunnelServer.
const TunnelServer_TypeID = 0xea58385c65416035

func (c TunnelServer) RegisterTunnel(ctx context.Context, params func(TunnelServer_registerTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_registerTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_registerTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "registerTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_registerTunnel_Params{Struct: s}) }
	}
	return TunnelServer_registerTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) GetServerInfo(ctx context.Context, params func(TunnelServer_getServerInfo_Params) error, opts ...capnp.CallOption) TunnelServer_getServerInfo_Results_Promise {
	if c.Client == nil {
		return TunnelServer_getServerInfo_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "getServerInfo",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_getServerInfo_Params{Struct: s}) }
	}
	return TunnelServer_getServerInfo_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) UnregisterTunnel(ctx context.Context, params func(TunnelServer_unregisterTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_unregisterTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_unregisterTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      2,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "unregisterTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_unregisterTunnel_Params{Struct: s}) }
	}
	return TunnelServer_unregisterTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) ObsoleteDeclarativeTunnelConnect(ctx context.Context, params func(TunnelServer_obsoleteDeclarativeTunnelConnect_Params) error, opts ...capnp.CallOption) TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise {
	if c.Client == nil {
		return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      3,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "obsoleteDeclarativeTunnelConnect",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error {
			return params(TunnelServer_obsoleteDeclarativeTunnelConnect_Params{Struct: s})
		}
	}
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) Authenticate(ctx context.Context, params func(TunnelServer_authenticate_Params) error, opts ...capnp.CallOption) TunnelServer_authenticate_Results_Promise {
	if c.Client == nil {
		return TunnelServer_authenticate_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      4,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "authenticate",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_authenticate_Params{Struct: s}) }
	}
	return TunnelServer_authenticate_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) ReconnectTunnel(ctx context.Context, params func(TunnelServer_reconnectTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_reconnectTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_reconnectTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      5,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "reconnectTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 5}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_reconnectTunnel_Params{Struct: s}) }
	}
	return TunnelServer_reconnectTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) RegisterConnection(ctx context.Context, params func(RegistrationServer_registerConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_registerConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_registerConnection_Params{Struct: s}) }
	}
	return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) UnregisterConnection(ctx context.Context, params func(RegistrationServer_unregisterConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_unregisterConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_unregisterConnection_Params{Struct: s}) }
	}
	return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type TunnelServer_Server interface {
	RegisterTunnel(TunnelServer_registerTunnel) error

	GetServerInfo(TunnelServer_getServerInfo) error

	UnregisterTunnel(TunnelServer_unregisterTunnel) error

	ObsoleteDeclarativeTunnelConnect(TunnelServer_obsoleteDeclarativeTunnelConnect) error

	Authenticate(TunnelServer_authenticate) error

	ReconnectTunnel(TunnelServer_reconnectTunnel) error

	RegisterConnection(RegistrationServer_registerConnection) error

	UnregisterConnection(RegistrationServer_unregisterConnection) error
}

func TunnelServer_ServerToClient(s TunnelServer_Server) TunnelServer {
	c, _ := s.(server.Closer)
	return TunnelServer{Client: server.New(TunnelServer_Methods(nil, s), c)}
}

func TunnelServer_Methods(methods []server.Method, s TunnelServer_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 8)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "registerTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_registerTunnel{c, opts, TunnelServer_registerTunnel_Params{Struct: p}, TunnelServer_registerTunnel_Results{Struct: r}}
			return s.RegisterTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "getServerInfo",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_getServerInfo{c, opts, TunnelServer_getServerInfo_Params{Struct: p}, TunnelServer_getServerInfo_Results{Struct: r}}
			return s.GetServerInfo(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      2,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "unregisterTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_unregisterTunnel{c, opts, TunnelServer_unregisterTunnel_Params{Struct: p}, TunnelServer_unregisterTunnel_Results{Struct: r}}
			return s.UnregisterTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      3,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "obsoleteDeclarativeTunnelConnect",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_obsoleteDeclarativeTunnelConnect{c, opts, TunnelServer_obsoleteDeclarativeTunnelConnect_Params{Struct: p}, TunnelServer_obsoleteDeclarativeTunnelConnect_Results{Struct: r}}
			return s.ObsoleteDeclarativeTunnelConnect(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      4,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "authenticate",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_authenticate{c, opts, TunnelServer_authenticate_Params{Struct: p}, TunnelServer_authenticate_Results{Struct: r}}
			return s.Authenticate(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      5,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "reconnectTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_reconnectTunnel{c, opts, TunnelServer_reconnectTunnel_Params{Struct: p}, TunnelServer_reconnectTunnel_Results{Struct: r}}
			return s.ReconnectTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_registerConnection{c, opts, RegistrationServer_registerConnection_Params{Struct: p}, RegistrationServer_registerConnection_Results{Struct: r}}
			return s.RegisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_unregisterConnection{c, opts, RegistrationServer_unregisterConnection_Params{Struct: p}, RegistrationServer_unregisterConnection_Results{Struct: r}}
			return s.UnregisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	return methods
}

// TunnelServer_registerTunnel holds the arguments for a server call to TunnelServer.registerTunnel.
type TunnelServer_registerTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_registerTunnel_Params
	Results TunnelServer_registerTunnel_Results
}

// TunnelServer_getServerInfo holds the arguments for a server call to TunnelServer.getServerInfo.
type TunnelServer_getServerInfo struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_getServerInfo_Params
	Results TunnelServer_getServerInfo_Results
}

// TunnelServer_unregisterTunnel holds the arguments for a server call to TunnelServer.unregisterTunnel.
type TunnelServer_unregisterTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_unregisterTunnel_Params
	Results TunnelServer_unregisterTunnel_Results
}

// TunnelServer_obsoleteDeclarativeTunnelConnect holds the arguments for a server call to TunnelServer.obsoleteDeclarativeTunnelConnect.
type TunnelServer_obsoleteDeclarativeTunnelConnect struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_obsoleteDeclarativeTunnelConnect_Params
	Results TunnelServer_obsoleteDeclarativeTunnelConnect_Results
}

// TunnelServer_authenticate holds the arguments for a server call to TunnelServer.authenticate.
type TunnelServer_authenticate struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_authenticate_Params
	Results TunnelServer_authenticate_Results
}

// TunnelServer_reconnectTunnel holds the arguments for a server call to TunnelServer.reconnectTunnel.
type TunnelServer_reconnectTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_reconnectTunnel_Params
	Results TunnelServer_reconnectTunnel_Results
}

type TunnelServer_registerTunnel_Params struct{ capnp.Struct }

// TunnelServer_registerTunnel_Params_TypeID is the unique identifier for the type TunnelServer_registerTunnel_Params.
const TunnelServer_registerTunnel_Params_TypeID = 0xb70431c0dc014915

func NewTunnelServer_registerTunnel_Params(s *capnp.Segment) (TunnelServer_registerTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_registerTunnel_Params{st}, err
}

func NewRootTunnelServer_registerTunnel_Params(s *capnp.Segment) (TunnelServer_registerTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_registerTunnel_Params{st}, err
}

func ReadRootTunnelServer_registerTunnel_Params(msg *capnp.Message) (TunnelServer_registerTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_registerTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_registerTunnel_Params) String() string {
	str, _ := text.Marshal(0xb70431c0dc014915, s.Struct)
	return str
}

func (s TunnelServer_registerTunnel_Params) OriginCert() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_registerTunnel_Params) HasOriginCert() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) SetOriginCert(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_registerTunnel_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelServer_registerTunnel_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelServer_registerTunnel_Params) SetHostname(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelServer_registerTunnel_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(2)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_registerTunnel_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_registerTunnel_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_registerTunnel_Params_List is a list of TunnelServer_registerTunnel_Params.
type TunnelServer_registerTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_registerTunnel_Params creates a new list of TunnelServer_registerTunnel_Params.
func NewTunnelServer_registerTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_registerTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return TunnelServer_registerTunnel_Params_List{l}, err
}

func (s TunnelServer_registerTunnel_Params_List) At(i int) TunnelServer_registerTunnel_Params {
	return TunnelServer_registerTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_registerTunnel_Params_List) Set(i int, v TunnelServer_registerTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_registerTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0xb70431c0dc014915, s.List)
	return str
}

// TunnelServer_registerTunnel_Params_Promise is a wrapper for a TunnelServer_registerTunnel_Params promised by a client call.
type TunnelServer_registerTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_registerTunnel_Params_Promise) Struct() (TunnelServer_registerTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_registerTunnel_Params{s}, err
}

func (p TunnelServer_registerTunnel_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type TunnelServer_registerTunnel_Results struct{ capnp.Struct }

// TunnelServer_registerTunnel_Results_TypeID is the unique identifier for the type TunnelServer_registerTunnel_Results.
const TunnelServer_registerTunnel_Results_TypeID = 0xf2c122394f447e8e

func NewTunnelServer_registerTunnel_Results(s *capnp.Segment) (TunnelServer_registerTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_registerTunnel_Results{st}, err
}

func NewRootTunnelServer_registerTunnel_Results(s *capnp.Segment) (TunnelServer_registerTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_registerTunnel_Results{st}, err
}

func ReadRootTunnelServer_registerTunnel_Results(msg *capnp.Message) (TunnelServer_registerTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_registerTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_registerTunnel_Results) String() string {
	str, _ := text.Marshal(0xf2c122394f447e8e, s.Struct)
	return str
}

func (s TunnelServer_registerTunnel_Results) Result() (TunnelRegistration, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelRegistration{Struct: p.Struct()}, err
}

func (s TunnelServer_registerTunnel_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Results) SetResult(v TunnelRegistration) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated TunnelRegistration struct, preferring placement in s's segment.
func (s TunnelServer_registerTunnel_Results) NewResult() (TunnelRegistration, error) {
	ss, err := NewTunnelRegistration(s.Struct.Segment())
	if err != nil {
		return TunnelRegistration{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_registerTunnel_Results_List is a list of TunnelServer_registerTunnel_Results.
type TunnelServer_registerTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_registerTunnel_Results creates a new list of TunnelServer_registerTunnel_Results.
func NewTunnelServer_registerTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_registerTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_registerTunnel_Results_List{l}, err
}

func (s TunnelServer_registerTunnel_Results_List) At(i int) TunnelServer_registerTunnel_Results {
	return TunnelServer_registerTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_registerTunnel_Results_List) Set(i int, v TunnelServer_registerTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_registerTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xf2c122394f447e8e, s.List)
	return str
}

// TunnelServer_registerTunnel_Results_Promise is a wrapper for a TunnelServer_registerTunnel_Results promised by a client call.
type TunnelServer_registerTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_registerTunnel_Results_Promise) Struct() (TunnelServer_registerTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_registerTunnel_Results{s}, err
}

func (p TunnelServer_registerTunnel_Results_Promise) Result() TunnelRegistration_Promise {
	return TunnelRegistration_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_getServerInfo_Params struct{ capnp.Struct }

// TunnelServer_getServerInfo_Params_TypeID is the unique identifier for the type TunnelServer_getServerInfo_Params.
const TunnelServer_getServerInfo_Params_TypeID = 0xdc3ed6801961e502

func NewTunnelServer_getServerInfo_Params(s *capnp.Segment) (TunnelServer_getServerInfo_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_getServerInfo_Params{st}, err
}

func NewRootTunnelServer_getServerInfo_Params(s *capnp.Segment) (TunnelServer_getServerInfo_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_getServerInfo_Params{st}, err
}

func ReadRootTunnelServer_getServerInfo_Params(msg *capnp.Message) (TunnelServer_getServerInfo_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_getServerInfo_Params{root.Struct()}, err
}

func (s TunnelServer_getServerInfo_Params) String() string {
	str, _ := text.Marshal(0xdc3ed6801961e502, s.Struct)
	return str
}

// TunnelServer_getServerInfo_Params_List is a list of TunnelServer_getServerInfo_Params.
type TunnelServer_getServerInfo_Params_List struct{ capnp.List }

// NewTunnelServer_getServerInfo_Params creates a new list of TunnelServer_getServerInfo_Params.
func NewTunnelServer_getServerInfo_Params_List(s *capnp.Segment, sz int32) (TunnelServer_getServerInfo_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_getServerInfo_Params_List{l}, err
}

func (s TunnelServer_getServerInfo_Params_List) At(i int) TunnelServer_getServerInfo_Params {
	return TunnelServer_getServerInfo_Params{s.List.Struct(i)}
}

func (s TunnelServer_getServerInfo_Params_List) Set(i int, v TunnelServer_getServerInfo_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_getServerInfo_Params_List) String() string {
	str, _ := text.MarshalList(0xdc3ed6801961e502, s.List)
	return str
}

// TunnelServer_getServerInfo_Params_Promise is a wrapper for a TunnelServer_getServerInfo_Params promised by a client call.
type TunnelServer_getServerInfo_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_getServerInfo_Params_Promise) Struct() (TunnelServer_getServerInfo_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_getServerInfo_Params{s}, err
}

type TunnelServer_getServerInfo_Results struct{ capnp.Struct }

// TunnelServer_getServerInfo_Results_TypeID is the unique identifier for the type TunnelServer_getServerInfo_Results.
const TunnelServer_getServerInfo_Results_TypeID = 0xe3e37d096a5b564e

func NewTunnelServer_getServerInfo_Results(s *capnp.Segment) (TunnelServer_getServerInfo_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_getServerInfo_Results{st}, err
}

func NewRootTunnelServer_getServerInfo_Results(s *capnp.Segment) (TunnelServer_getServerInfo_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_getServerInfo_Results{st}, err
}

func ReadRootTunnelServer_getServerInfo_Results(msg *capnp.Message) (TunnelServer_getServerInfo_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_getServerInfo_Results{root.Struct()}, err
}

func (s TunnelServer_getServerInfo_Results) String() string {
	str, _ := text.Marshal(0xe3e37d096a5b564e, s.Struct)
	return str
}

func (s TunnelServer_getServerInfo_Results) Result() (ServerInfo, error) {
	p, err := s.Struct.Ptr(0)
	return ServerInfo{Struct: p.Struct()}, err
}

func (s TunnelServer_getServerInfo_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_getServerInfo_Results) SetResult(v ServerInfo) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated ServerInfo struct, preferring placement in s's segment.
func (s TunnelServer_getServerInfo_Results) NewResult() (ServerInfo, error) {
	ss, err := NewServerInfo(s.Struct.Segment())
	if err != nil {
		return ServerInfo{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_getServerInfo_Results_List is a list of TunnelServer_getServerInfo_Results.
type TunnelServer_getServerInfo_Results_List struct{ capnp.List }

// NewTunnelServer_getServerInfo_Results creates a new list of TunnelServer_getServerInfo_Results.
func NewTunnelServer_getServerInfo_Results_List(s *capnp.Segment, sz int32) (TunnelServer_getServerInfo_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_getServerInfo_Results_List{l}, err
}

func (s TunnelServer_getServerInfo_Results_List) At(i int) TunnelServer_getServerInfo_Results {
	return TunnelServer_getServerInfo_Results{s.List.Struct(i)}
}

func (s TunnelServer_getServerInfo_Results_List) Set(i int, v TunnelServer_getServerInfo_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_getServerInfo_Results_List) String() string {
	str, _ := text.MarshalList(0xe3e37d096a5b564e, s.List)
	return str
}

// TunnelServer_getServerInfo_Results_Promise is a wrapper for a TunnelServer_getServerInfo_Results promised by a client call.
type TunnelServer_getServerInfo_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_getServerInfo_Results_Promise) Struct() (TunnelServer_getServerInfo_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_getServerInfo_Results{s}, err
}

func (p TunnelServer_getServerInfo_Results_Promise) Result() ServerInfo_Promise {
	return ServerInfo_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_unregisterTunnel_Params struct{ capnp.Struct }

// TunnelServer_unregisterTunnel_Params_TypeID is the unique identifier for the type TunnelServer_unregisterTunnel_Params.
const TunnelServer_unregisterTunnel_Params_TypeID = 0x9b87b390babc2ccf

func NewTunnelServer_unregisterTunnel_Params(s *capnp.Segment) (TunnelServer_unregisterTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Params{st}, err
}

func NewRootTunnelServer_unregisterTunnel_Params(s *capnp.Segment) (TunnelServer_unregisterTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Params{st}, err
}

func ReadRootTunnelServer_unregisterTunnel_Params(msg *capnp.Message) (TunnelServer_unregisterTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_unregisterTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_unregisterTunnel_Params) String() string {
	str, _ := text.Marshal(0x9b87b390babc2ccf, s.Struct)
	return str
}

func (s TunnelServer_unregisterTunnel_Params) GracePeriodNanoSec() int64 {
	return int64(s.Struct.Uint64(0))
}

func (s TunnelServer_unregisterTunnel_Params) SetGracePeriodNanoSec(v int64) {
	s.Struct.SetUint64(0, uint64(v))
}

// TunnelServer_unregisterTunnel_Params_List is a list of TunnelServer_unregisterTunnel_Params.
type TunnelServer_unregisterTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_unregisterTunnel_Params creates a new list of TunnelServer_unregisterTunnel_Params.
func NewTunnelServer_unregisterTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_unregisterTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return TunnelServer_unregisterTunnel_Params_List{l}, err
}

func (s TunnelServer_unregisterTunnel_Params_List) At(i int) TunnelServer_unregisterTunnel_Params {
	return TunnelServer_unregisterTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_unregisterTunnel_Params_List) Set(i int, v TunnelServer_unregisterTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_unregisterTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0x9b87b390babc2ccf, s.List)
	return str
}

// TunnelServer_unregisterTunnel_Params_Promise is a wrapper for a TunnelServer_unregisterTunnel_Params promised by a client call.
type TunnelServer_unregisterTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_unregisterTunnel_Params_Promise) Struct() (TunnelServer_unregisterTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_unregisterTunnel_Params{s}, err
}

type TunnelServer_unregisterTunnel_Results struct{ capnp.Struct }

// TunnelServer_unregisterTunnel_Results_TypeID is the unique identifier for the type TunnelServer_unregisterTunnel_Results.
const TunnelServer_unregisterTunnel_Results_TypeID = 0xa29a916d4ebdd894

func NewTunnelServer_unregisterTunnel_Results(s *capnp.Segment) (TunnelServer_unregisterTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Results{st}, err
}

func NewRootTunnelServer_unregisterTunnel_Results(s *capnp.Segment) (TunnelServer_unregisterTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Results{st}, err
}

func ReadRootTunnelServer_unregisterTunnel_Results(msg *capnp.Message) (TunnelServer_unregisterTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_unregisterTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_unregisterTunnel_Results) String() string {
	str, _ := text.Marshal(0xa29a916d4ebdd894, s.Struct)
	return str
}

// TunnelServer_unregisterTunnel_Results_List is a list of TunnelServer_unregisterTunnel_Results.
type TunnelServer_unregisterTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_unregisterTunnel_Results creates a new list of TunnelServer_unregisterTunnel_Results.
func NewTunnelServer_unregisterTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_unregisterTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_unregisterTunnel_Results_List{l}, err
}

func (s TunnelServer_unregisterTunnel_Results_List) At(i int) TunnelServer_unregisterTunnel_Results {
	return TunnelServer_unregisterTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_unregisterTunnel_Results_List) Set(i int, v TunnelServer_unregisterTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_unregisterTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xa29a916d4ebdd894, s.List)
	return str
}

// TunnelServer_unregisterTunnel_Results_Promise is a wrapper for a TunnelServer_unregisterTunnel_Results promised by a client call.
type TunnelServer_unregisterTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_unregisterTunnel_Results_Promise) Struct() (TunnelServer_unregisterTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_unregisterTunnel_Results{s}, err
}

type TunnelServer_obsoleteDeclarativeTunnelConnect_Params struct{ capnp.Struct }

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_TypeID is the unique identifier for the type TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
const TunnelServer_obsoleteDeclarativeTunnelConnect_Params_TypeID = 0xa766b24d4fe5da35

func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{st}, err
}

func NewRootTunnelServer_obsoleteDeclarativeTunnelConnect_Params(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{st}, err
}

func ReadRootTunnelServer_obsoleteDeclarativeTunnelConnect_Params(msg *capnp.Message) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{root.Struct()}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params) String() string {
	str, _ := text.Marshal(0xa766b24d4fe5da35, s.Struct)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List is a list of TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List struct{ capnp.List }

// NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params creates a new list of TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params_List(s *capnp.Segment, sz int32) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List{l}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) At(i int) TunnelServer_obsoleteDeclarativeTunnelConnect_Params {
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{s.List.Struct(i)}
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) Set(i int, v TunnelServer_obsoleteDeclarativeTunnelConnect_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) String() string {
	str, _ := text.MarshalList(0xa766b24d4fe5da35, s.List)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise is a wrapper for a TunnelServer_obsoleteDeclarativeTunnelConnect_Params promised by a client call.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise) Struct() (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{s}, err
}

type TunnelServer_obsoleteDeclarativeTunnelConnect_Results struct{ capnp.Struct }

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_TypeID is the unique identifier for the type TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
const TunnelServer_obsoleteDeclarativeTunnelConnect_Results_TypeID = 0xfeac5c8f4899ef7c

func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{st}, err
}

func NewRootTunnelServer_obsoleteDeclarativeTunnelConnect_Results(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{st}, err
}

func ReadRootTunnelServer_obsoleteDeclarativeTunnelConnect_Results(msg *capnp.Message) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{root.Struct()}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results) String() string {
	str, _ := text.Marshal(0xfeac5c8f4899ef7c, s.Struct)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List is a list of TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List struct{ capnp.List }

// NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results creates a new list of TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results_List(s *capnp.Segment, sz int32) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List{l}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) At(i int) TunnelServer_obsoleteDeclarativeTunnelConnect_Results {
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{s.List.Struct(i)}
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) Set(i int, v TunnelServer_obsoleteDeclarativeTunnelConnect_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) String() string {
	str, _ := text.MarshalList(0xfeac5c8f4899ef7c, s.List)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise is a wrapper for a TunnelServer_obsoleteDeclarativeTunnelConnect_Results promised by a client call.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise) Struct() (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{s}, err
}

type TunnelServer_authenticate_Params struct{ capnp.Struct }

// TunnelServer_authenticate_Params_TypeID is the unique identifier for the type TunnelServer_authenticate_Params.
const TunnelServer_authenticate_Params_TypeID = 0x85c8cea1ab1894f3

func NewTunnelServer_authenticate_Params(s *capnp.Segment) (TunnelServer_authenticate_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_authenticate_Params{st}, err
}

func NewRootTunnelServer_authenticate_Params(s *capnp.Segment) (TunnelServer_authenticate_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_authenticate_Params{st}, err
}

func ReadRootTunnelServer_authenticate_Params(msg *capnp.Message) (TunnelServer_authenticate_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_authenticate_Params{root.Struct()}, err
}

func (s TunnelServer_authenticate_Params) String() string {
	str, _ := text.Marshal(0x85c8cea1ab1894f3, s.Struct)
	return str
}

func (s TunnelServer_authenticate_Params) OriginCert() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_authenticate_Params) HasOriginCert() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) SetOriginCert(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_authenticate_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelServer_authenticate_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelServer_authenticate_Params) SetHostname(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelServer_authenticate_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(2)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_authenticate_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_authenticate_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_authenticate_Params_List is a list of TunnelServer_authenticate_Params.
type TunnelServer_authenticate_Params_List struct{ capnp.List }

// NewTunnelServer_authenticate_Params creates a new list of TunnelServer_authenticate_Params.
func NewTunnelServer_authenticate_Params_List(s *capnp.Segment, sz int32) (TunnelServer_authenticate_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return TunnelServer_authenticate_Params_List{l}, err
}

func (s TunnelServer_authenticate_Params_List) At(i int) TunnelServer_authenticate_Params {
	return TunnelServer_authenticate_Params{s.List.Struct(i)}
}

func (s TunnelServer_authenticate_Params_List) Set(i int, v TunnelServer_authenticate_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_authenticate_Params_List) String() string {
	str, _ := text.MarshalList(0x85c8cea1ab1894f3, s.List)
	return str
}

// TunnelServer_authenticate_Params_Promise is a wrapper for a TunnelServer_authenticate_Params promised by a client call.
type TunnelServer_authenticate_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_authenticate_Params_Promise) Struct() (TunnelServer_authenticate_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_authenticate_Params{s}, err
}

func (p TunnelServer_authenticate_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type TunnelServer_authenticate_Results struct{ capnp.Struct }

// TunnelServer_authenticate_Results_TypeID is the unique identifier for the type TunnelServer_authenticate_Results.
const TunnelServer_authenticate_Results_TypeID = 0xfc5edf80e39c0796

func NewTunnelServer_authenticate_Results(s *capnp.Segment) (TunnelServer_authenticate_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_authenticate_Results{st}, err
}

func NewRootTunnelServer_authenticate_Results(s *capnp.Segment) (TunnelServer_authenticate_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_authenticate_Results{st}, err
}

func ReadRootTunnelServer_authenticate_Results(msg *capnp.Message) (TunnelServer_authenticate_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_authenticate_Results{root.Struct()}, err
}

func (s TunnelServer_authenticate_Results) String() string {
	str, _ := text.Marshal(0xfc5edf80e39c0796, s.Struct)
	return str
}

func (s TunnelServer_authenticate_Results) Result() (AuthenticateResponse, error) {
	p, err := s.Struct.Ptr(0)
	return AuthenticateResponse{Struct: p.Struct()}, err
}

func (s TunnelServer_authenticate_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Results) SetResult(v AuthenticateResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated AuthenticateResponse struct, preferring placement in s's segment.
func (s TunnelServer_authenticate_Results) NewResult() (AuthenticateResponse, error) {
	ss, err := NewAuthenticateResponse(s.Struct.Segment())
	if err != nil {
		return AuthenticateResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_authenticate_Results_List is a list of TunnelServer_authenticate_Results.
type TunnelServer_authenticate_Results_List struct{ capnp.List }

// NewTunnelServer_authenticate_Results creates a new list of TunnelServer_authenticate_Results.
func NewTunnelServer_authenticate_Results_List(s *capnp.Segment, sz int32) (TunnelServer_authenticate_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_authenticate_Results_List{l}, err
}

func (s TunnelServer_authenticate_Results_List) At(i int) TunnelServer_authenticate_Results {
	return TunnelServer_authenticate_Results{s.List.Struct(i)}
}

func (s TunnelServer_authenticate_Results_List) Set(i int, v TunnelServer_authenticate_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_authenticate_Results_List) String() string {
	str, _ := text.MarshalList(0xfc5edf80e39c0796, s.List)
	return str
}

// TunnelServer_authenticate_Results_Promise is a wrapper for a TunnelServer_authenticate_Results promised by a client call.
type TunnelServer_authenticate_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_authenticate_Results_Promise) Struct() (TunnelServer_authenticate_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_authenticate_Results{s}, err
}

func (p TunnelServer_authenticate_Results_Promise) Result() AuthenticateResponse_Promise {
	return AuthenticateResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_reconnectTunnel_Params struct{ capnp.Struct }

// TunnelServer_reconnectTunnel_Params_TypeID is the unique identifier for the type TunnelServer_reconnectTunnel_Params.
const TunnelServer_reconnectTunnel_Params_TypeID = 0xa353a3556df74984

func NewTunnelServer_reconnectTunnel_Params(s *capnp.Segment) (TunnelServer_reconnectTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5})
	return TunnelServer_reconnectTunnel_Params{st}, err
}

func NewRootTunnelServer_reconnectTunnel_Params(s *capnp.Segment) (TunnelServer_reconnectTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5})
	return TunnelServer_reconnectTunnel_Params{st}, err
}

func ReadRootTunnelServer_reconnectTunnel_Params(msg *capnp.Message) (TunnelServer_reconnectTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_reconnectTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Params) String() string {
	str, _ := text.Marshal(0xa353a3556df74984, s.Struct)
	return str
}

func (s TunnelServer_reconnectTunnel_Params) Jwt() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasJwt() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetJwt(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_reconnectTunnel_Params) EventDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasEventDigest() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetEventDigest(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s TunnelServer_reconnectTunnel_Params) ConnDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasConnDigest() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetConnDigest(v []byte) error {
	return s.Struct.SetData(2, v)
}

func (s TunnelServer_reconnectTunnel_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s TunnelServer_reconnectTunnel_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s TunnelServer_reconnectTunnel_Params) SetHostname(v string) error {
	return s.Struct.SetText(3, v)
}

func (s TunnelServer_reconnectTunnel_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(4)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(4, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_reconnectTunnel_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(4, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_reconnectTunnel_Params_List is a list of TunnelServer_reconnectTunnel_Params.
type TunnelServer_reconnectTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_reconnectTunnel_Params creates a new list of TunnelServer_reconnectTunnel_Params.
func NewTunnelServer_reconnectTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_reconnectTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5}, sz)
	return TunnelServer_reconnectTunnel_Params_List{l}, err
}

func (s TunnelServer_reconnectTunnel_Params_List) At(i int) TunnelServer_reconnectTunnel_Params {
	return TunnelServer_reconnectTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_reconnectTunnel_Params_List) Set(i int, v TunnelServer_reconnectTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_reconnectTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0xa353a3556df74984, s.List)
	return str
}

// TunnelServer_reconnectTunnel_Params_Promise is a wrapper for a TunnelServer_reconnectTunnel_Params promised by a client call.
type TunnelServer_reconnectTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_reconnectTunnel_Params_Promise) Struct() (TunnelServer_reconnectTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_reconnectTunnel_Params{s}, err
}

func (p TunnelServer_reconnectTunnel_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(4)}
}

type TunnelServer_reconnectTunnel_Results struct{ capnp.Struct }

// TunnelServer_reconnectTunnel_Results_TypeID is the unique identifier for the type TunnelServer_reconnectTunnel_Results.
const TunnelServer_reconnectTunnel_Results_TypeID = 0xd4d18de97bb12de3

func NewTunnelServer_reconnectTunnel_Results(s *capnp.Segment) (TunnelServer_reconnectTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_reconnectTunnel_Results{st}, err
}

func NewRootTunnelServer_reconnectTunnel_Results(s *capnp.Segment) (TunnelServer_reconnectTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_reconnectTunnel_Results{st}, err
}

func ReadRootTunnelServer_reconnectTunnel_Results(msg *capnp.Message) (TunnelServer_reconnectTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_reconnectTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Results) String() string {
	str, _ := text.Marshal(0xd4d18de97bb12de3, s.Struct)
	return str
}

func (s TunnelServer_reconnectTunnel_Results) Result() (TunnelRegistration, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelRegistration{Struct: p.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Results) SetResult(v TunnelRegistration) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated TunnelRegistration struct, preferring placement in s's segment.
func (s TunnelServer_reconnectTunnel_Results) NewResult() (TunnelRegistration, error) {
	ss, err := NewTunnelRegistration(s.Struct.Segment())
	if err != nil {
		return TunnelRegistration{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_reconnectTunnel_Results_List is a list of TunnelServer_reconnectTunnel_Results.
type TunnelServer_reconnectTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_reconnectTunnel_Results creates a new list of TunnelServer_reconnectTunnel_Results.
func NewTunnelServer_reconnectTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_reconnectTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_reconnectTunnel_Results_List{l}, err
}

func (s TunnelServer_reconnectTunnel_Results_List) At(i int) TunnelServer_reconnectTunnel_Results {
	return TunnelServer_reconnectTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_reconnectTunnel_Results_List) Set(i int, v TunnelServer_reconnectTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_reconnectTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xd4d18de97bb12de3, s.List)
	return str
}

// TunnelServer_reconnectTunnel_Results_Promise is a wrapper for a TunnelServer_reconnectTunnel_Results promised by a client call.
type TunnelServer_reconnectTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_reconnectTunnel_Results_Promise) Struct() (TunnelServer_reconnectTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_reconnectTunnel_Results{s}, err
}

func (p TunnelServer_reconnectTunnel_Results_Promise) Result() TunnelRegistration_Promise {
	return TunnelRegistration_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type RegisterUdpSessionResponse struct{ capnp.Struct }

// RegisterUdpSessionResponse_TypeID is the unique identifier for the type RegisterUdpSessionResponse.
const RegisterUdpSessionResponse_TypeID = 0xab6d5210c1f26687

func NewRegisterUdpSessionResponse(s *capnp.Segment) (RegisterUdpSessionResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegisterUdpSessionResponse{st}, err
}

func NewRootRegisterUdpSessionResponse(s *capnp.Segment) (RegisterUdpSessionResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegisterUdpSessionResponse{st}, err
}

func ReadRootRegisterUdpSessionResponse(msg *capnp.Message) (RegisterUdpSessionResponse, error) {
	root, err := msg.RootPtr()
	return RegisterUdpSessionResponse{root.Struct()}, err
}

func (s RegisterUdpSessionResponse) String() string {
	str, _ := text.Marshal(0xab6d5210c1f26687, s.Struct)
	return str
}

func (s RegisterUdpSessionResponse) Err() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s RegisterUdpSessionResponse) HasErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegisterUdpSessionResponse) ErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s RegisterUdpSessionResponse) SetErr(v string) error {
	return s.Struct.SetText(0, v)
}

// RegisterUdpSessionResponse_List is a list of RegisterUdpSessionResponse.
type RegisterUdpSessionResponse_List struct{ capnp.List }

// NewRegisterUdpSessionResponse creates a new list of RegisterUdpSessionResponse.
func NewRegisterUdpSessionResponse_List(s *capnp.Segment, sz int32) (RegisterUdpSessionResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return RegisterUdpSessionResponse_List{l}, err
}

func (s RegisterUdpSessionResponse_List) At(i int) RegisterUdpSessionResponse {
	return RegisterUdpSessionResponse{s.List.Struct(i)}
}

func (s RegisterUdpSessionResponse_List) Set(i int, v RegisterUdpSessionResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegisterUdpSessionResponse_List) String() string {
	str, _ := text.MarshalList(0xab6d5210c1f26687, s.List)
	return str
}

// RegisterUdpSessionResponse_Promise is a wrapper for a RegisterUdpSessionResponse promised by a client call.
type RegisterUdpSessionResponse_Promise struct{ *capnp.Pipeline }

func (p RegisterUdpSessionResponse_Promise) Struct() (RegisterUdpSessionResponse, error) {
	s, err := p.Pipeline.Struct()
	return RegisterUdpSessionResponse{s}, err
}

type SessionManager struct{ Client capnp.Client }

// SessionManager_TypeID is the unique identifier for the type SessionManager.
const SessionManager_TypeID = 0x839445a59fb01686

func (c SessionManager) RegisterUdpSession(ctx context.Context, params func(SessionManager_registerUdpSession_Params) error, opts ...capnp.CallOption) SessionManager_registerUdpSession_Results_Promise {
	if c.Client == nil {
		return SessionManager_registerUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "registerUdpSession",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 16, PointerCount: 2}
		call.ParamsFunc = func(s capnp.Struct) error { return params(SessionManager_registerUdpSession_Params{Struct: s}) }
	}
	return SessionManager_registerUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c SessionManager) UnregisterUdpSession(ctx context.Context, params func(SessionManager_unregisterUdpSession_Params) error, opts ...capnp.CallOption) SessionManager_unregisterUdpSession_Results_Promise {
	if c.Client == nil {
		return SessionManager_unregisterUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "unregisterUdpSession",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		call.ParamsFunc = func(s capnp.Struct) error { return params(SessionManager_unregisterUdpSession_Params{Struct: s}) }
	}
	return SessionManager_unregisterUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type SessionManager_Server interface {
	RegisterUdpSession(SessionManager_registerUdpSession) error

	UnregisterUdpSession(SessionManager_unregisterUdpSession) error
}

func SessionManager_ServerToClient(s SessionManager_Server) SessionManager {
	c, _ := s.(server.Closer)
	return SessionManager{Client: server.New(SessionManager_Methods(nil, s), c)}
}

func SessionManager_Methods(methods []server.Method, s SessionManager_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 2)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "registerUdpSession",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := SessionManager_registerUdpSession{c, opts, SessionManager_registerUdpSession_Params{Struct: p}, SessionManager_registerUdpSession_Results{Struct: r}}
			return s.RegisterUdpSession(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "unregisterUdpSession",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := SessionManager_unregisterUdpSession{c, opts, SessionManager_unregisterUdpSession_Params{Struct: p}, SessionManager_unregisterUdpSession_Results{Struct: r}}
			return s.UnregisterUdpSession(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	return methods
}

// SessionManager_registerUdpSession holds the arguments for a server call to SessionManager.registerUdpSession.
type SessionManager_registerUdpSession struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  SessionManager_registerUdpSession_Params
	Results SessionManager_registerUdpSession_Results
}

// SessionManager_unregisterUdpSession holds the arguments for a server call to SessionManager.unregisterUdpSession.
type SessionManager_unregisterUdpSession struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  SessionManager_unregisterUdpSession_Params
	Results SessionManager_unregisterUdpSession_Results
}

type SessionManager_registerUdpSession_Params struct{ capnp.Struct }

// SessionManager_registerUdpSession_Params_TypeID is the unique identifier for the type SessionManager_registerUdpSession_Params.
const SessionManager_registerUdpSession_Params_TypeID = 0x904e297b87fbecea

func NewSessionManager_registerUdpSession_Params(s *capnp.Segment) (SessionManager_registerUdpSession_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2})
	return SessionManager_registerUdpSession_Params{st}, err
}

func NewRootSessionManager_registerUdpSession_Params(s *capnp.Segment) (SessionManager_registerUdpSession_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2})
	return SessionManager_registerUdpSession_Params{st}, err
}

func ReadRootSessionManager_registerUdpSession_Params(msg *capnp.Message) (SessionManager_registerUdpSession_Params, error) {
	root, err := msg.RootPtr()
	return SessionManager_registerUdpSession_Params{root.Struct()}, err
}

func (s SessionManager_registerUdpSession_Params) String() string {
	str, _ := text.Marshal(0x904e297b87fbecea, s.Struct)
	return str
}

func (s SessionManager_registerUdpSession_Params) SessionId() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s SessionManager_registerUdpSession_Params) HasSessionId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s SessionManager_registerUdpSession_Params) SetSessionId(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s SessionManager_registerUdpSession_Params) DstIp() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s SessionManager_registerUdpSession_Params) HasDstIp() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s SessionManager_registerUdpSession_Params) SetDstIp(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s SessionManager_registerUdpSession_Params) DstPort() uint16 {
	return s.Struct.Uint16(0)
}

func (s SessionManager_registerUdpSession_Params) SetDstPort(v uint16) {
	s.Struct.SetUint16(0, v)
}

func (s SessionManager_registerUdpSession_Params) CloseAfterIdleHint() int64 {
	return int64(s.Struct.Uint64(8))
}

func (s SessionManager_registerUdpSession_Params) SetCloseAfterIdleHint(v int64) {
	s.Struct.SetUint64(8, uint64(v))
}

// SessionManager_registerUdpSession_Params_List is a list of SessionManager_registerUdpSession_Params.
type SessionManager_registerUdpSession_Params_List struct{ capnp.List }

// NewSessionManager_registerUdpSession_Params creates a new list of SessionManager_registerUdpSession_Params.
func NewSessionManager_registerUdpSession_Params_List(s *capnp.Segment, sz int32) (SessionManager_registerUdpSession_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2}, sz)
	return SessionManager_registerUdpSession_Params_List{l}, err
}

func (s SessionManager_registerUdpSession_Params_List) At(i int) SessionManager_registerUdpSession_Params {
	return SessionManager_registerUdpSession_Params{s.List.Struct(i)}
}

func (s SessionManager_registerUdpSession_Params_List) Set(i int, v SessionManager_registerUdpSession_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_registerUdpSession_Params_List) String() string {
	str, _ := text.MarshalList(0x904e297b87fbecea, s.List)
	return str
}

// SessionManager_registerUdpSession_Params_Promise is a wrapper for a SessionManager_registerUdpSession_Params promised by a client call.
type SessionManager_registerUdpSession_Params_Promise struct{ *capnp.Pipeline }

func (p SessionManager_registerUdpSession_Params_Promise) Struct() (SessionManager_registerUdpSession_Params, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_registerUdpSession_Params{s}, err
}

type SessionManager_registerUdpSession_Results struct{ capnp.Struct }

// SessionManager_registerUdpSession_Results_TypeID is the unique identifier for the type SessionManager_registerUdpSession_Results.
const SessionManager_registerUdpSession_Results_TypeID = 0x8635c6b4f45bf5cd

func NewSessionManager_registerUdpSession_Results(s *capnp.Segment) (SessionManager_registerUdpSession_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return SessionManager_registerUdpSession_Results{st}, err
}

func NewRootSessionManager_registerUdpSession_Results(s *capnp.Segment) (SessionManager_registerUdpSession_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return SessionManager_registerUdpSession_Results{st}, err
}

func ReadRootSessionManager_registerUdpSession_Results(msg *capnp.Message) (SessionManager_registerUdpSession_Results, error) {
	root, err := msg.RootPtr()
	return SessionManager_registerUdpSession_Results{root.Struct()}, err
}

func (s SessionManager_registerUdpSession_Results) String() string {
	str, _ := text.Marshal(0x8635c6b4f45bf5cd, s.Struct)
	return str
}

func (s SessionManager_registerUdpSession_Results) Result() (RegisterUdpSessionResponse, error) {
	p, err := s.Struct.Ptr(0)
	return RegisterUdpSessionResponse{Struct: p.Struct()}, err
}

func (s SessionManager_registerUdpSession_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s SessionManager_registerUdpSession_Results) SetResult(v RegisterUdpSessionResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated RegisterUdpSessionResponse struct, preferring placement in s's segment.
func (s SessionManager_registerUdpSession_Results) NewResult() (RegisterUdpSessionResponse, error) {
	ss, err := NewRegisterUdpSessionResponse(s.Struct.Segment())
	if err != nil {
		return RegisterUdpSessionResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// SessionManager_registerUdpSession_Results_List is a list of SessionManager_registerUdpSession_Results.
type SessionManager_registerUdpSession_Results_List struct{ capnp.List }

// NewSessionManager_registerUdpSession_Results creates a new list of SessionManager_registerUdpSession_Results.
func NewSessionManager_registerUdpSession_Results_List(s *capnp.Segment, sz int32) (SessionManager_registerUdpSession_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return SessionManager_registerUdpSession_Results_List{l}, err
}

func (s SessionManager_registerUdpSession_Results_List) At(i int) SessionManager_registerUdpSession_Results {
	return SessionManager_registerUdpSession_Results{s.List.Struct(i)}
}

func (s SessionManager_registerUdpSession_Results_List) Set(i int, v SessionManager_registerUdpSession_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_registerUdpSession_Results_List) String() string {
	str, _ := text.MarshalList(0x8635c6b4f45bf5cd, s.List)
	return str
}

// SessionManager_registerUdpSession_Results_Promise is a wrapper for a SessionManager_registerUdpSession_Results promised by a client call.
type SessionManager_registerUdpSession_Results_Promise struct{ *capnp.Pipeline }

func (p SessionManager_registerUdpSession_Results_Promise) Struct() (SessionManager_registerUdpSession_Results, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_registerUdpSession_Results{s}, err
}

func (p SessionManager_registerUdpSession_Results_Promise) Result() RegisterUdpSessionResponse_Promise {
	return RegisterUdpSessionResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type SessionManager_unregisterUdpSession_Params struct{ capnp.Struct }

// SessionManager_unregisterUdpSession_Params_TypeID is the unique identifier for the type SessionManager_unregisterUdpSession_Params.
const SessionManager_unregisterUdpSession_Params_TypeID = 0x96b74375ce9b0ef6

func NewSessionManager_unregisterUdpSession_Params(s *capnp.Segment) (SessionManager_unregisterUdpSession_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return SessionManager_unregisterUdpSession_Params{st}, err
}

func NewRootSessionManager_unregisterUdpSession_Params(s *capnp.Segment) (SessionManager_unregisterUdpSession_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return SessionManager_unregisterUdpSession_Params{st}, err
}

func ReadRootSessionManager_unregisterUdpSession_Params(msg *capnp.Message) (SessionManager_unregisterUdpSession_Params, error) {
	root, err := msg.RootPtr()
	return SessionManager_unregisterUdpSession_Params{root.Struct()}, err
}

func (s SessionManager_unregisterUdpSession_Params) String() string {
	str, _ := text.Marshal(0x96b74375ce9b0ef6, s.Struct)
	return str
}

func (s SessionManager_unregisterUdpSession_Params) SessionId() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s SessionManager_unregisterUdpSession_Params) HasSessionId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s SessionManager_unregisterUdpSession_Params) SetSessionId(v []byte) error {
	return s.Struct.SetData(0, v)
}

// SessionManager_unregisterUdpSession_Params_List is a list of SessionManager_unregisterUdpSession_Params.
type SessionManager_unregisterUdpSession_Params_List struct{ capnp.List }

// NewSessionManager_unregisterUdpSession_Params creates a new list of SessionManager_unregisterUdpSession_Params.
func NewSessionManager_unregisterUdpSession_Params_List(s *capnp.Segment, sz int32) (SessionManager_unregisterUdpSession_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return SessionManager_unregisterUdpSession_Params_List{l}, err
}

func (s SessionManager_unregisterUdpSession_Params_List) At(i int) SessionManager_unregisterUdpSession_Params {
	return SessionManager_unregisterUdpSession_Params{s.List.Struct(i)}
}

func (s SessionManager_unregisterUdpSession_Params_List) Set(i int, v SessionManager_unregisterUdpSession_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_unregisterUdpSession_Params_List) String() string {
	str, _ := text.MarshalList(0x96b74375ce9b0ef6, s.List)
	return str
}

// SessionManager_unregisterUdpSession_Params_Promise is a wrapper for a SessionManager_unregisterUdpSession_Params promised by a client call.
type SessionManager_unregisterUdpSession_Params_Promise struct{ *capnp.Pipeline }

func (p SessionManager_unregisterUdpSession_Params_Promise) Struct() (SessionManager_unregisterUdpSession_Params, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_unregisterUdpSession_Params{s}, err
}

type SessionManager_unregisterUdpSession_Results struct{ capnp.Struct }

// SessionManager_unregisterUdpSession_Results_TypeID is the unique identifier for the type SessionManager_unregisterUdpSession_Results.
const SessionManager_unregisterUdpSession_Results_TypeID = 0xf24ec4ab5891b676

func NewSessionManager_unregisterUdpSession_Results(s *capnp.Segment) (SessionManager_unregisterUdpSession_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return SessionManager_unregisterUdpSession_Results{st}, err
}

func NewRootSessionManager_unregisterUdpSession_Results(s *capnp.Segment) (SessionManager_unregisterUdpSession_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return SessionManager_unregisterUdpSession_Results{st}, err
}

func ReadRootSessionManager_unregisterUdpSession_Results(msg *capnp.Message) (SessionManager_unregisterUdpSession_Results, error) {
	root, err := msg.RootPtr()
	return SessionManager_unregisterUdpSession_Results{root.Struct()}, err
}

func (s SessionManager_unregisterUdpSession_Results) String() string {
	str, _ := text.Marshal(0xf24ec4ab5891b676, s.Struct)
	return str
}

// SessionManager_unregisterUdpSession_Results_List is a list of SessionManager_unregisterUdpSession_Results.
type SessionManager_unregisterUdpSession_Results_List struct{ capnp.List }

// NewSessionManager_unregisterUdpSession_Results creates a new list of SessionManager_unregisterUdpSession_Results.
func NewSessionManager_unregisterUdpSession_Results_List(s *capnp.Segment, sz int32) (SessionManager_unregisterUdpSession_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return SessionManager_unregisterUdpSession_Results_List{l}, err
}

func (s SessionManager_unregisterUdpSession_Results_List) At(i int) SessionManager_unregisterUdpSession_Results {
	return SessionManager_unregisterUdpSession_Results{s.List.Struct(i)}
}

func (s SessionManager_unregisterUdpSession_Results_List) Set(i int, v SessionManager_unregisterUdpSession_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_unregisterUdpSession_Results_List) String() string {
	str, _ := text.MarshalList(0xf24ec4ab5891b676, s.List)
	return str
}

// SessionManager_unregisterUdpSession_Results_Promise is a wrapper for a SessionManager_unregisterUdpSession_Results promised by a client call.
type SessionManager_unregisterUdpSession_Results_Promise struct{ *capnp.Pipeline }

func (p SessionManager_unregisterUdpSession_Results_Promise) Struct() (SessionManager_unregisterUdpSession_Results, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_unregisterUdpSession_Results{s}, err
}

const schema_db8274f9144abc7e = "x\xda\xccY{p\x14e\xb6?\xa7{&\x9d@\x86" +
	"IW\x0f\x04\xa6\xe4\xe6^\x0a\xcaK\x14\x14\xb8\xdeB" +
	"\xae\xde\x04L\xb8&\xf2H\xcf\x90\xbb\x96\xa0eg\xe6" +
	"#tv\xa6{\xe8\xee\x89\x04A\x1e\x82\x88\xe5\x0b\x04" +
	"E\x94\x95\xc5r\xb7D\xdd\x85U\xd7eKke\xd7" +
	"\x17\xa5\xa8X\xb8\x05\x8a\xb5\xab\xc8>(\\W\xc4\xb5" +
	"\xdcu\xed\xad\xd3=\xfd\xc8$$A\xf6\x8f\xfdor" +
	"\xfa\xfb\xcew\xce\xef\xfc\xbes\xcewr\xe9w*\x1b" +
	"\xb9)\xd1\xda\x18\x80\xbc-Za\xb3\xfaw\x96\xef\x9c" +
	"\xf0\xab\xb5 '\x11\xed[\x9eoM|e\xad}\x1f" +
	"\xa2\xbc\x000mi\xc5r\x94\xd6W\x08\x00\xd2\x9a\x8a" +
	"\xdf\x03\xda\xb7\x8d\xda\xf3\xc8c\xcd[n\x051\xc9\x07" +
	"\x8b\x01\xa71\xa1\x15\xa5\x1e\x81V\x16\x85\x0d\xd2\xbb\xf4" +
	"\xcb\xbeF\xbcda\xe2\xed7iuXu\x84T\xbf" +
	" \xd4\xa3t\xd0\xd9p@ \xd5W\xe4\xdf\xda\xf5\xdf" +
	"[__\x07b\x92\xeb\xa5\xfa\xd9\xca\xe5(\x1d\xa8\xa4" +
	"\x95/W\xce\x07\xb4?\xdf2\xfa\x89\xef\xbf\xf9\xdaz" +
	"\x10/D(Y\xfaA\xe5{\x08(}V\xf9c@" +
	"\xfb\xe0\x17\x0b\xcf<\xf3\xcae\xb7\x818\x91\x16 -" +
	"\xd8T5\x8e\x03\x94\x1e\xafj\x00\xb4O\x9e\xfa\xdb\x86" +
	"\x9b'\xce\xbb\x17\xe4\x89\xc8\x01D9Zq\xa0*I" +
	"+>\xac\"k\x1af\x1f\xdc\x97\x9cv\xff\x962\xd3" +
	"\x9d\x85\xfb\x87\xd5\xa3th\x18\x19tp\xd8M\x80\xf6" +
	"_F<\xf4f\xf1\xaa\xe7\xee\x0f\x9f7ex=i" +
	"k\x19N\xe7\x8d\xeb\x9ep\xe3/_~\xfa\x01\x90'" +
	"!\xda\xc7:.z\x97\xdf\xb1\xfb}hG\x81\x8e\x9f" +
	"\x96\x1f\xbe\x8b\x8c_9\x9c\x94\xbdu\xf1\xf3?\xbf\xf7" +
	"\xe9\x0d\x0f\x81|!\"\x80\x03\xd6\x87\xc3\xffJ\x0b\xbe" +
	"p\x94m9\xf2\xc2\xbc\xfc\xa6\xed\xbb\\\xf7\x9d\xefc" +
	"\xab9\x0e\"\xf6\xba\x96/\xf3\xed\x8f\xa6\x1f-\x01\x13" +
	"\xa5Ob\xf5i\x04\x9c6\xa1\xba\x0e\x01\xed\xcb\xde;" +
	"1\x7f\xeeO\x16\xff0\xb4wfl9\xed\xdd\xb0\xf8" +
	"\xf4\xfe\x9aT\xfe\x892\x87\x1d_\xae\x8c\xedF\xa9=" +
	"F\x0e\xcb12\xe1\xa9\x7f\xbb\xa6j\xd9\x89\xd9{@" +
	"\x9c\xe4\xa9Y\x1aK\x91\x9a\xc8\xf5\xfc7\xca\xb6_<" +
	"SN'\x07\xb8|\xac\x03\xa55\xa4g\xda\xca\x98c" +
	"\xcf\x1d\xfb\xb7_T\xf9\xc8\xe7\xcf\xf6\x07\xf3c#:" +
	"P\xda7\x82N}v\x04!3\xb2\x05\x8f\xbd8%" +
	"\xf2\\8\xee#\xe3'\x09\x99\x89q\x8a\xfb\xd8Of" +
	"\xc5\xb4O\xd7\xbeX\xa6\xcdYx \xde\x8a\xd2\x07q" +
	"\xd2v\xd4Y\xdc\xba\xf0\xbe\xcd\xd1\x13\xf7\xbdJ\x96\x86" +
	"\x08\x17%\xa2M+\xd6\x18(m\xac\xa1\x9f\xebkj" +
	"y@;\xb9\xe7\x7f~4+{\xf4\xf5~,\x95\xa2" +
	"\x89\xd3\x92\x98\xa0_\xb1\x04\x19z|\xd2\xde\x9b\xffx" +
	"\xd7\xa1\xc3%C\x1d\x0c\xd5\x84\x13\xc2\x95\x09\xc2\xcfg" +
	"@\x19J\xce\xca\x1d\x89.\x94\xf6:\xea\x9erVs" +
	"'\x941\xab\x7f\xfd\xbf\xc7BA\xdb\x9b\xf8\x08!b" +
	"\xcf\xfb\xff\x85]U+\x8f\x1f\x0f\x1f\xf4X\xc2Ad" +
	"\x9f\xb3\xf5O?8y\xcf\xa9|\xf6w\x0e\xf1<\xcc" +
	"\x8e&f\x105?K\x10\xd1k\xebb\xcd\xe3\x8e\xb4" +
	"\x9dtC\xe9\xaa88r\x16-81\x92T\\v" +
	"\xe3L\xb6h\xfa\xb5'\xfb\\\xf9\xe8\xa8\x19(\x8d\x1c" +
	"\xe5\x90l\xd4\x06\x94&\xd6\xd6\x02\xd8\xdd?\xddt\xed" +
	"\x13/\xcd;\xed\xde\x05\xc7\xd81\xb5S\x89\x1aw\xdf" +
	"\xd24\xff\xf2q\xfbO\x87\x8d\x15k\x89\x9d\xd2\x84Z" +
	":i\xf1\xf4S\xff7\xe1\xeeWN\xf7G\xc1\xe6\xda" +
	"z\x94\xdak\x1d\x0a\xd2\xe2Og\x7f\xefp2\x9e<" +
	"S\x06`\x85\x13\xbc\xda.\x946\xd6:\xc1\xab}\x95" +
	"hv\xdb\xfb7,{\xe7\xd6\xcf\xbf(\x8f\xb5\xa3\xba" +
	"gL\x0a\xa5\xbb\xc6\x90\xea\x8dc\x88\x19\x0f,\xf8\xc3" +
	"\xaaS[G}\xd9\xc7\xe3\x89\xc9.\x94\xaeL\xd2\xca" +
	"\xcb\x93\x1b\xa4\x07\xe9\x97\xfd\xb6\xf0\xe8\x94\xa6U\xaf\x7f" +
	"\x15\xba\x0bk\x92\xad\xe4\xf0\xfd\xc2\xc3\xc7W\xff\xe6\x86" +
	"\xaf\xc3\x0e\xafL~D\x0eoJ\x92\xc3+>}\xf0" +
	"\xea{\x16=\xf9M8\xb0\xc9\xb5\xb4\xd5*j\x1a\xcb" +
	"\x19\x85H\xe6\x12\xefgfrF)h\x85\x193\x8b" +
	"\xd6\x12\xa6YjF\xb1X\x8a5\x98\x05]3Y\x1b" +
	"\xa2\\\xc3G\x00\"\x08 *]\x00\xf2\x8d<\xca9" +
	"\x0eE\xc4\x04\x85^TI\xb8\x84G\xd9\xe2P\xe4\xb8" +
	"\x04e\x1eq\xe98\x009\xc7\xa3\xbc\x8cC\xe4\x13\xc8" +
	"\x03\x88\xc5\xcd\x00\xf22\x1e\xe5u\x1c\xda\x05f\xe4\x15" +
	"\x8di\x10\xb7\x9a\x0d\x03\xab\x81\xc3j@\xdb`\x96\xd1" +
	"\xa3t\xe4 \xceBb\xa1\xeb&\x0bc\xc0a\x0c\xd0" +
	"^\xa2\x17\x0d\xb3]\xb3P\xcd\xa5\xd8b\x83\x99\xb8\x04" +
	"+\x80\xc3\x0a\xc0\x81\xdcK3\xd3Tum\xae\xa2)" +
	"\x9d\xcc\x00 \xcf*\xf9(\x80\x9f\xb4\xd1K\xef\xe2\x94" +
	"\xed\xc0\x89\x93\x04\x0c20z\xf4\x13\xffc7p\xe2" +
	"X\xc16X\xa7jZ\xcc\xc0\xf6l\xc1\xd1\xcd\xebZ" +
	"#\xdaE\xcd\xfd\x80\xccp?\xc4\xe9\xd4Fl\xc3\xc0" +
	":\xbe\xafuW\xe5T\xa6Y\xf1\x16m\xb1^\x06y" +
	"k\x7f\x90\xb7\x96 _\x17\x82|\xcd,\x00y\x05\x8f" +
	"\xf2\xed\x1c\x8a|\x09\xf3\xf5\xf5\x00\xf2j\x1e\xe5;9" +
	"\xb43\xce!-Y\x00\xf0\xd1\\\xcc\x14\xabh0\x93" +
	"d#\x00\xdbxt@\x1f\x01\xb8\xaa\x9b\x19d\xbb\x17" +
	"\x84\xb8bd\x96\xf8\x81\x1a\x00\xe9\xe6e\xaai\xa9Z" +
	"\xe7\x02G\xde\xd0\xa6\xe7\xd4L\x0fyU\xed\xd89v" +
	"\x06\x00\xa28\xf2:\x00\xe4Dq\x16@\x83\xda\xa9\xe9" +
	"\x06\xb3\xb3\xaa\x99\xd15\x8d\x01\x9f\xb1Vu(9E" +
	"\xcb0\xff\xa0\x8a\xbe\x07\xb9\x07\xa4\x99\xd1\xcd\x8c\xc9J" +
	"\x88\xbe\xe3\xdb\x14C\xe1\xf3\xa6\\\xed\xe3\xd8|\x1d\x80" +
	"\xdc\xc4\xa3\xdc\x16\xc2q.\xe18\x87G\xf9\xda\x10\x8e" +
	"\xed\x84c\x1b\x8f\xf2\"\x0em\xddP;U\xed*\x06" +
	"\xbc\x11f\xa0iiJ\x9e\x11f%<V\xe9\x05K" +
	"\xd55\x13k\x82\xfc\x0f\x885!\xa4\x84\xc189\xd9" +
	"\xa3\x94\xc7(]\x1b\x9fbfQ\xc8Y\xa6\x1c\xf1=" +
	"\x89\xcd\x00\x90+y\x94\x13\x1c6\x18\xcc,\xe6,\xac" +
	"\x09\xca\xec?\xe3T\x0f\xbe\x10\x0dS\xfd\xd1p*\x80" +
	"\x9c\xe5Q.p\x88%\xf4\xf2\xb3B\xd9\x80G\x97\x85" +
	"K\xb7\x03\xc8\x16\x8f\xf2j\x0em\xd3=\xa4\x050\xeb" +
	"!Z\x975\xad\x96\x82\xf7\xd7\xaa\xaci\xb5\xe9\x86\x85" +
	"\x02p(\x00\xf1V7\xd9\xcc\xc5t\xa7Z\xb29v" +
	"\xb5\xcak\x16F\x81\xc3(\x0cx\xa9\\~\xc4)\xb1" +
	"\xb9\xb7\xdd\xf3f\"\x91\xe1?y\x94\xff+\xe4\xcd\x14" +
	"\xcac\x97\xf2(_\xc1\xa1\xadd2zQ\xb3\x16\x00" +
	"\xaft\x96q>\xcd \x9e1X@\x87\xa1C\xed%" +
	"\x872\xb0\xe3\x86\x92\xef\x15a\x02\xbb\x9aGyt\xff" +
	"p\xf9'F\xfbI$t\x812\xc4\xc5\x14sS\xf8" +
	"d\x83\x99B1g\x91\xff\xd5\xb6\xed\x02@\x91\x1b\xcf" +
	"\xa3|)\x871\xfc\xc6v\x11\x98\xb49@\xa0\x8e\x19" +
	"\x86n`MP\xe2J\xc4\xca\x94\x0e@]kb\x96" +
	"\xa2\xe6\x90H\xef\xf7[e\xf4\x1b\xec\xd6\x06\x88\xb8\xe2" +
	"\xf1\x0d\xc4\xbd\xdeh\x10yjx\x94/\xe0\xd0\xee4" +
	"\x94\x0ckc\x06\xaazv\x9e\xa2\xe9i\x9ee\xfaP" +
	"a\xc4\xb9\x1e\x9arn\x91\x09\xfe\xae\x81\xf7\x1b\xac\x04" +
	"Bi{[\x9dks\xc2\xb7y\xe5\xb8\xa0\xd4\xf9\x04" +
	"[\xd3\x11\xe4b?\xdbl$*\xde\xce\xa3\xbc%\x94" +
	"\xb57Q^\xba\x97G\xf9a\x0e\xc5H$\x81\x11\x00" +
	"\xf1A\xbaY[x\x94wr\xbd\x0b\"\xebf\x9a\xd5" +
	"\xa4v\x82\xc0\xcc@J&6\xa9\x9d\x0cx\xf3|3" +
	"W\xe5 x\xe8\x1d\xa6\x9ec\x16kb\x99\x9cb(" +
	"\x96\xda\xcd\xdc\xef%2zA\x1d\x88\xb7\xa9>\x17\x83" +
	"\xf8\x1b\xf7z\x90\x10\x1d\xc6\x05\xe9O`\xa1\xd6a\x00" +
	"k]\xe5d\x99\xae\xf5\xe1@pcJ<@s\xa0" +
	"\xea\x16,\x9f_\xb0TA\xd7L\xb2/\x14\xfa\x19\xfd" +
	"\x85\xde\x08B\xefe\xca\x8dk\xc3\x91/e\xcaM\xdb" +
	"\x83 \x8b\x11\xce\x8d\xfc\x8e]\x00\xf2N\x1e\xe5'9" +
	"lp\x8b8\xd6\x04\x8f\xe0R\xb4\xdcR5G\x87\xba" +
	"\x8c\x92\x0b\xb2\xa9m\xb0BN\xc9\xb0f,\x95e@" +
	"\x04\x0e\xd1\xa1H\xbe`0\xd3DU\xd7\xe4\xa2\x92S" +
	"y\xab\xc7o\xa5\xb4b\xbe\xcd`\xdd*\xeaEs\xa6" +
	"e\xb1\xbcP\xb0\xcc\xa14Z\x01@\x94\x1f\x045g" +
	"\x96%\xdf\xfa \xf7\xf8\x00M\xa2\xe4{1\x8f\xf2t" +
	"\x0e\xe3\xc5\xa2\x1a\xe4\xba\x9c\x9eq\xe2\x06\xf1yJ\x9e" +
	"\xf5\x89v\xc5\xa0w\xb5\xd7M\xf7\x92\xed\xbfRc0" +
	"p/N\xae;\xcdj\xc8d\xba\x02\x8d<\xcasB" +
	"&\xb7L\x0d\xf9\xe1\x99<\xb7#\xf0C\xf8.\xeb\xf1" +
	"\xac\xaacy\xca\xdc\x1e\x98%gf\x82pM\xb0f" +
	" \xfb\xc2\x17j~\xa1\xce\xf1\x90l\x9c\xee\xd9(\xf5" +
	"`+@z\x19\xf2\x98^\x87\x81\x99\xd2\x1a\x9c\x05\x90" +
	"^A\xf2\xdb1\xb0TZ\x8fI\x80\xf4j\x92\xdf\x89" +
	"\xfe\x9bA\xda\x88\xbb\x01\xd2w\x92x\x1b-\x8f\xf0\xce" +
	"\x95\x90\xb6:\xea\xb7\x90|'\xc9\xa3\x91\x04F\x01\xa4" +
	"\x1dX\x0f\x90\xdeF\xf2gH^\xc1%\xb0\x02@\xda" +
	"\x8b]\x00\xe9=$\x7f\x9e\xe4B4A\xcf&i\x1f" +
	"\x1a\x00\xe9\x9f\x91\xfc%\x92W\x8eN`%\x80\xb4\xdf" +
	"\x91\xbfH\xf27H^5&\x81U\x00\xd2\x01\\\x0b" +
	"\x90~\x8d\xe4\x87I>\x0c\x138\x0c@:\x84\xdb\x01" +
	"\xd2\x87I\xfe[\x92\x0f\xafH\xe0p\x00\xe9\x03\xc7\x9e" +
	"#$\xff\x98\xe4\xd5\x91\x04V\x03H\x1f\xe2.\x80\xf4" +
	"\xc7$\xff3\xc9cB\x02c\x00\xd2'\x8e_\xa7H" +
	"^\xc9\x95\xb5\xec\x1e\xa3\xca\xfar^7\xfd\x90\xb1\xd2" +
	"\x1dG\x97\xeemz\x9czo\x8c\x07C0@\x8c\x03" +
	"\xda\x05]\xcf\xcd\xeb\xcd\xd4\xb8\xa5t\x9a\xde\x1b\xa0&" +
	"\x98K\x00\x92\xd0\xaf\xfb\x10\xd7\xb5\x96\xac\x9f\x08\xca\xb3" +
	"\x8eg\x89j\xce,Zz\xb1\x00uY\xc5bY?" +
	"\xe7\x18Em\xb6\xa1\xe7\x17 3\xf2\xaa\xa6\xe4\x06\xc9" +
	"FU\xc0a\x15\x94R\x82\xa7{\xe0\xd4t\xf6\x17\x8d" +
	"\xcfh\xae\x9c\xd1u\x85\x19\x0b\x94\xce\xa1\xe4\xa9\xa9A" +
	"\xe7\x18\xd7B\x09\xa9\xae[\xc9\x15\xbfMz\xea\xddJ" +
	"\xa4\x1a\xdcVd\xb0~\xdf\x1bS\x0c\x9eJz7\x84" +
	"\xbd\x0b*\x86&\x88t\x0eW\xd2?d\xf3;\x99\xe5" +
	"\xfe\xa2\x87+=\x1b\x84p\x99?\xb7\xdd)f\xc6\x87" +
	"\xe2z0\xce\x19\xfc\xa9\xd3O\xe1\xef\xa7\xec{=g" +
	"\xe8\xb9C\xb1_\xc4\xa3\xbc$\x14{\xd6\xda\xcfs'" +
	"\x15\xcc9D\x9e+\x0d:\xa8P\x14x\x94Wp\x18" +
	"\xa7w)\xd6\x04s\xdf^F\xf7~\x8b\x13\x15Z\xb4" +
	",\x03\\\xe6\xb19T>\xfc\x09\xe8\xe0\xdd\xd9\xd0\xdc" +
	"\xf6\xba\xdeA\x01\xf7\xa7\x8ae'\x9f\xf5\xc9\xd5\xe0\x1e" +
	"J<\x1b\xed\x8cX\xbc\x09+z\xb3:q\xefr\xe0" +
	"\xc4\xc7\x05\x0c\xa6\x90\xe8\x0d\x1d\xc5\x1d\x06p\xe2V\x01" +
	"9\x7ff\x8d\xdelZ\xdcx\x07p\xe2z\x01y\x7f" +
	"\xe4\x8c\xde\xb4kJ\xcf0\x04N\\)`\xc4\x1f\xe5" +
	"\xa37+\x13\x97v\x01'\xaa\x02F\xfdi6z\xe3" +
	"T\xf1\xfa\xb5\xc0\x89\xed\xc1L\x07\x1a\\?\x1a\xd1\xf6" +
	"8\x0au\x0eK{Ox\xdcU\x00\x8dh{=0" +
	"\x7f\xb6&\xd8Y\xe5\x0d) \x9eQ,\xd6H\xcd\x99" +
	"{\xff\xb1\x94\x00\xa0\x11\xe5\x08\x86F\x85\x00\xe7\xfb\xbe" +
	"L\xb1:'\xce\xdf\xb6e\xf2\xf6\x7f\xcb\x94\xc4\xf7g" +
	"5\x9d\xe3\x0f\xbbBz\xbbB\x0f\xdfA\x1a\xbf\xc8\xd9" +
	"\xbc\xf0\xc8\x1f\xa7\xcd\xa4\xff\xdf}\xfd\x87\xa8qz\x83" +
	"G\xf9H\xe8Z\xbfK\xc2\xb7y\x94\x8f\x85\x1a\xa7\xa3" +
	"t\xd7\x8f\xf0(\x9f\x09\xe6\x97\x9f\xdd\x01 \x9f\xe11" +
	"\x15jD\xc4\xbf\xd3\xc2\xaf\xa9\\;m\x08\xbamH" +
	"\x147\x03\xa4+\xa9\x8c'\x9c6$\xe2\xb6!\"v" +
	"\x00\xa4kH~A\xb8\x0d\x19\x83\xd7\x01\xa4G\x93|" +
	"<\xf6~\xd7\x08E#h\xd4rz\xe7\x1cU\xeb\xb7" +
	"\xb6y\x03U\xb4f+j\xaeh0\x08Jk)\xd9" +
	"4\x85\xaa\xbd;iu\x87*i\"a\x16M\x7f\xe0" +
	"r\x0e/\xca!U\x9ef\xc3\xd0\xd1(kb\xa7\x06" +
	"M\xac\xdf\xc3R/~5\x8f\xf2\x02\x0aE\xa3\x1b\x0a" +
	"\xb9#h\xbb\xeb2J\xd1d}|\x00\x9e\x19\xfe\x14" +
	"\xc0\\\xa2\x17s\xd9\x14\x03\xc12z\xca \x18\xb4\x99" +
	"M\xb3\xb8\x97\xb9\xdc\xe1\xb0\xf7\x8f\x0e\xf4\xfe\x9f\x11\x1a" +
	"\x0e{\x13z\xf4\xfem\xd5w8\xeca\xd0g8\xec" +
	"~p8\xda{8|\x1e\xcfW\xb7\x8c\x852\xc69" +
	"\xcdL\x87<j\xf4\xff\xb3[v\xd3\xab\xcewL\xe0" +
	"\x15\xa4\x7f\x04\x00\x00\xff\xff\xa5\x0ed\xc9"

func init() {
	schemas.Register(schema_db8274f9144abc7e,
		0x82c325a07ad22a65,
		0x839445a59fb01686,
		0x83ced0145b2f114b,
		0x84cb9536a2cf6d3c,
		0x85c8cea1ab1894f3,
		0x8635c6b4f45bf5cd,
		0x904e297b87fbecea,
		0x9496331ab9cd463f,
		0x96b74375ce9b0ef6,
		0x97b3c5c260257622,
		0x9b87b390babc2ccf,
		0xa29a916d4ebdd894,
		0xa353a3556df74984,
		0xa766b24d4fe5da35,
		0xab6d5210c1f26687,
		0xb046e578094b1ead,
		0xb4bf9861fe035d04,
		0xb5f39f082b9ac18a,
		0xb70431c0dc014915,
		0xc082ef6e0d42ed1d,
		0xc793e50592935b4a,
		0xcbd96442ae3bb01a,
		0xd4d18de97bb12de3,
		0xdbaa9d03d52b62dc,
		0xdc3ed6801961e502,
		0xe3e37d096a5b564e,
		0xe6646dec8feaa6ee,
		0xea50d822450d1f17,
		0xea58385c65416035,
		0xf24ec4ab5891b676,
		0xf2c122394f447e8e,
		0xf2c68e2547ec3866,
		0xf41a0f001ad49e46,
		0xf5f383d2785edb86,
		0xf71695ec7fe85497,
		0xf9cb7f4431a307d0,
		0xfc5edf80e39c0796,
		0xfeac5c8f4899ef7c)
}
