/* 
 * command.h : command list
 * version 0.0.3 - Copyright (C) 2002-2003 Alessandro Fausto
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *	Redistributions of source code must retain the above copyright
 *	notice, this list of conditions and the following disclaimer.
 *
 *	Redistributions in binary form must reproduce the above copyright
 *	notice, this list of conditions and the following disclaimer in the
 *	documentation and/or other materials provided with the distribution.
 *
 *	Neither the name of the author nor the names of the contributors may
 *	be used to endorse or promote products derived from this software 
 *	without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * To contact me write at:
 *             fareale@libero.it
 *   for bugs: fareale.bug@libero.it
 */

/*
 * v 0.0B1 : 28/04/2002
 */

#ifndef __COMMAND_H__
#define __COMMAND_H__

#define MAX_CMD_LEN 128
#define ON_PRESS       1
#define ON_RELEASE     2
#define ON_REPEAT      4

 struct CMD {
	unsigned short code ;
	unsigned short mode ; // on press, on release, on repeat
	char command[ MAX_CMD_LEN] ;
 } ;

 int getNumberofEntry() ;
 const struct CMD * getCommand( int pos) ;
 //const struct CMD * findCommand( unsigned short code, int value) ;
 int executeCommand( unsigned short code, int value) ;
 int addCommand( char * command, unsigned short code, unsigned short mode) ;

 void ledSet( int fd, int mask) ;    // lit masked leds
 void ledClear( int fd, int mask) ;  // unlit masked leds
 void ledBlink( int fd, int mask) ;  //

 int InitCommand() ;

#endif
