// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Alert Alert
//
// swagger:model Alert
type Alert struct {

	// capacity
	// Required: true
	Capacity *int32 `json:"capacity"`

	// only relevant for GET, ignored in POST requests
	// Read Only: true
	CreatedAt string `json:"created_at,omitempty"`

	// decisions
	Decisions []*Decision `json:"decisions"`

	// the Meta of the events leading to overflow
	// Required: true
	Events []*Event `json:"events"`

	// events count
	// Required: true
	EventsCount *int32 `json:"events_count"`

	// only relevant for GET, ignored in POST requests
	// Read Only: true
	ID int64 `json:"id,omitempty"`

	// labels
	Labels []string `json:"labels"`

	// leakspeed
	// Required: true
	Leakspeed *string `json:"leakspeed"`

	// only relevant for LAPI->CAPI, ignored for cscli->LAPI and crowdsec->LAPI
	// Read Only: true
	MachineID string `json:"machine_id,omitempty"`

	// a human readable message
	// Required: true
	Message *string `json:"message"`

	// meta
	Meta Meta `json:"meta,omitempty"`

	// remediation
	Remediation bool `json:"remediation,omitempty"`

	// scenario
	// Required: true
	Scenario *string `json:"scenario"`

	// scenario hash
	// Required: true
	ScenarioHash *string `json:"scenario_hash"`

	// scenario version
	// Required: true
	ScenarioVersion *string `json:"scenario_version"`

	// simulated
	// Required: true
	Simulated *bool `json:"simulated"`

	// source
	// Required: true
	Source *Source `json:"source"`

	// start at
	// Required: true
	StartAt *string `json:"start_at"`

	// stop at
	// Required: true
	StopAt *string `json:"stop_at"`

	// only relevant for LAPI->CAPI, ignored for cscli->LAPI and crowdsec->LAPI
	// Read Only: true
	UUID string `json:"uuid,omitempty"`
}

// Validate validates this alert
func (m *Alert) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCapacity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDecisions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEvents(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEventsCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLeakspeed(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMeta(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScenario(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScenarioHash(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScenarioVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSimulated(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStopAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Alert) validateCapacity(formats strfmt.Registry) error {

	if err := validate.Required("capacity", "body", m.Capacity); err != nil {
		return err
	}

	return nil
}

func (m *Alert) validateDecisions(formats strfmt.Registry) error {
	if swag.IsZero(m.Decisions) { // not required
		return nil
	}

	for i := 0; i < len(m.Decisions); i++ {
		if swag.IsZero(m.Decisions[i]) { // not required
			continue
		}

		if m.Decisions[i] != nil {
			if err := m.Decisions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("decisions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("decisions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Alert) validateEvents(formats strfmt.Registry) error {

	if err := validate.Required("events", "body", m.Events); err != nil {
		return err
	}

	for i := 0; i < len(m.Events); i++ {
		if swag.IsZero(m.Events[i]) { // not required
			continue
		}

		if m.Events[i] != nil {
			if err := m.Events[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("events" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("events" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Alert) validateEventsCount(formats strfmt.Registry) error {

	if err := validate.Required("events_count", "body", m.EventsCount); err != nil {
		return err
	}

	return nil
}

func (m *Alert) validateLeakspeed(formats strfmt.Registry) error {

	if err := validate.Required("leakspeed", "body", m.Leakspeed); err != nil {
		return err
	}

	return nil
}

func (m *Alert) validateMessage(formats strfmt.Registry) error {

	if err := validate.Required("message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

func (m *Alert) validateMeta(formats strfmt.Registry) error {
	if swag.IsZero(m.Meta) { // not required
		return nil
	}

	if err := m.Meta.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("meta")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("meta")
		}
		return err
	}

	return nil
}

func (m *Alert) validateScenario(formats strfmt.Registry) error {

	if err := validate.Required("scenario", "body", m.Scenario); err != nil {
		return err
	}

	return nil
}

func (m *Alert) validateScenarioHash(formats strfmt.Registry) error {

	if err := validate.Required("scenario_hash", "body", m.ScenarioHash); err != nil {
		return err
	}

	return nil
}

func (m *Alert) validateScenarioVersion(formats strfmt.Registry) error {

	if err := validate.Required("scenario_version", "body", m.ScenarioVersion); err != nil {
		return err
	}

	return nil
}

func (m *Alert) validateSimulated(formats strfmt.Registry) error {

	if err := validate.Required("simulated", "body", m.Simulated); err != nil {
		return err
	}

	return nil
}

func (m *Alert) validateSource(formats strfmt.Registry) error {

	if err := validate.Required("source", "body", m.Source); err != nil {
		return err
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

func (m *Alert) validateStartAt(formats strfmt.Registry) error {

	if err := validate.Required("start_at", "body", m.StartAt); err != nil {
		return err
	}

	return nil
}

func (m *Alert) validateStopAt(formats strfmt.Registry) error {

	if err := validate.Required("stop_at", "body", m.StopAt); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this alert based on the context it is used
func (m *Alert) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCreatedAt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDecisions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEvents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMachineID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMeta(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Alert) contextValidateCreatedAt(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "created_at", "body", string(m.CreatedAt)); err != nil {
		return err
	}

	return nil
}

func (m *Alert) contextValidateDecisions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Decisions); i++ {

		if m.Decisions[i] != nil {
			if err := m.Decisions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("decisions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("decisions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Alert) contextValidateEvents(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Events); i++ {

		if m.Events[i] != nil {
			if err := m.Events[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("events" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("events" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Alert) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", int64(m.ID)); err != nil {
		return err
	}

	return nil
}

func (m *Alert) contextValidateMachineID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "machine_id", "body", string(m.MachineID)); err != nil {
		return err
	}

	return nil
}

func (m *Alert) contextValidateMeta(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Meta.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("meta")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("meta")
		}
		return err
	}

	return nil
}

func (m *Alert) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {
		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("source")
			}
			return err
		}
	}

	return nil
}

func (m *Alert) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", string(m.UUID)); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Alert) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Alert) UnmarshalBinary(b []byte) error {
	var res Alert
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
