#ifndef _DRV_TAPI_LINUX_H
#define _DRV_TAPI_LINUX_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

******************************************************************************/

/**
   \file drv_tapi_linux.h
   This file contains the declarations of the linux specific driver functions.
*/

/* ============================= */
/* Global Includes               */
/* ============================= */

/* Linux Includes*/
#include <linux/version.h>
#include <linux/interrupt.h>           /* in_interrupt() */
#include <linux/delay.h>               /* mdelay - udelay */
#include <asm/poll.h>                  /* POLLIN, POLLOUT */

#include "ifx_types.h"                 /* ifx type definitions */

#include "ifxos_thread.h"

/* ============================= */
/* Macros & Definitions          */
/* ============================= */

/** Definitions for select queues. */
/** Returned by select() to indicate that the fd is ready to writing. */
#define  TAPI_OS_SYSWRITE  POLLOUT
/** Returned by select() to indicate that the fd is ready for reading. */
#define  TAPI_OS_SYSREAD   POLLIN

/** Determine if the current state is in interrupt or task context. */
#define TAPI_OS_IN_INTERRUPT() \
   /*lint -save -e 155 -e 506 -e 774 */    \
   (in_interrupt() ? IFX_TRUE : IFX_FALSE) \
   /*lint -restore */

/** Returns the magic number of IOCTL command, see <asm/ioctl.h>.
\param iocmd - ioctl command of which magic number is decoded */
#define IFXOX_IO_GETMAGIC(iocmd) \
                 _IOC_TYPE((iocmd))

/** lock/take the mutex but be interruptable by signals.
    Difference to IFXOS_MutexLock is that the sleep is also interrupted when
    a signal is received by the sleeping thread.
\param mutex - mutex handle
*/
#define TAPI_OS_LOCK_GET_INTERRUPTIBLE(lockId)    \
   (down_interruptible(&(lockId)->object))


/* ============================= */
/* Global Structures             */
/* ============================= */
#define TIMER_ELEMENT   struct timer_list

/* Functionpointer to the callbackfunction */
typedef IFX_void_t (*TIMER_ENTRY)(IFX_void_t * timer_id, IFX_ulong_t arg);
typedef IFX_void_t (*linux_timer_callback)(IFX_ulong_t);

/* Timer ID */
typedef struct
{
#ifdef LINUX_2_6
   /* !!! important, work struct must be the first element, because we
          need to cast it later on to Timer_ID */
   struct work_struct timerTask;
#else
   struct tq_struct timerTask;
#endif /* LINUX_2_6 */
   struct timer_list Timer_List;
   IFX_boolean_t bPeriodical;
   IFX_uint32_t Periodical_Time;
   TIMER_ENTRY pTimerEntry;
   IFX_ulong_t nArgument;
   IFX_boolean_t bStopped;
} *Timer_ID;


/* ============================= */
/* Global function declaration   */
/* ============================= */
extern IFX_int32_t TAPI_OS_ThreadPriorityModify(IFX_uint32_t newPriority);
extern IFX_void_t  TAPI_OS_ThreadKill(IFXOS_ThreadCtrl_t *pThrCntrl);

#endif /*_DRV_TAPI_LINUX_H */
