#ifndef _DRV_TAPI_OSMAP_H
#define _DRV_TAPI_OSMAP_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

*******************************************************************************/

/**
   \file drv_tapi_osmap.h
   This file contains the includes and the defines specific to the OS.
*/

#include "ifx_types.h"     /* ifx type definitions */

#ifndef HAVE_IFX_ULONG_T
   #warning please update your ifx_types.h, using local definition of IFX_ulong_t
   /* unsigned long type - valid for 32bit systems only */
   typedef unsigned long               IFX_ulong_t;
   #define HAVE_IFX_ULONG_T
#endif /* HAVE_IFX_ULONG_T */

#ifndef HAVE_IFX_LONG_T
   #warning please update your ifx_types.h, using local definition of IFX_long_t
   /* long type - valid for 32bit systems only */
   typedef long                        IFX_long_t;
   #define HAVE_IFX_LONG_T
#endif /* HAVE_IFX_LONG_T */

#ifndef HAVE_IFX_INTPTR_T
   #warning please update your ifx_types.h, using local definition of IFX_intptr_t
   typedef IFX_long_t                  IFX_intptr_t;
   #define HAVE_IFX_INTPTR_T
#endif /* HAVE_IFX_INTPTR_T */

#ifndef HAVE_IFX_SIZE_T
   #warning please update your ifx_types.h, using local definition of IFX_size_t
   typedef IFX_ulong_t                 IFX_size_t;
   #define HAVE_IFX_SIZE_T
#endif /* HAVE_IFX_SIZE_T */

#ifndef HAVE_IFX_SSIZE_T
   #warning please update your ifx_types.h, using local definition of IFX_ssize_t
   typedef IFX_long_t                  IFX_ssize_t;
   #define HAVE_IFX_SSIZE_T
#endif /* HAVE_IFX_SSIZE_T */

#include "ifxos_interrupt.h"
#include "ifxos_memory_alloc.h"
#include "ifxos_copy_user_space.h"
#include "ifxos_debug.h" /* debug features */
#include "ifxos_event.h"
#include "ifxos_select.h"
#include "ifxos_mutex.h"
#include "ifxos_lock.h"
#include "ifxos_time.h"
#include "ifx_fifo.h"  /* fifo (used for streaming) */
#include "ifxos_thread.h"

/* ============================= */
/* Global Defines                */
/* ============================= */
#define DBG_LEVEL_OFF      4
#define DBG_LEVEL_HIGH     3
#define DBG_LEVEL_NORMAL   2
#define DBG_LEVEL_LOW      1

#define CREATE_TRACE_GROUP(name) \
   unsigned int G_nTraceGroup##name = DBG_LEVEL_HIGH

#define DECLARE_TRACE_GROUP(name) extern unsigned int G_nTraceGroup##name
#define PRINTF IFXOS_PRINT_USR_RAW /* defined in lib_ifxos */
#define TRACE(name,level,message) do {if(level >= G_nTraceGroup##name) \
      { PRINTF message ; } } while(0)
#define SetTraceLevel(name, level) G_nTraceGroup##name = (level)

#ifdef DEBUG
/** assert in debug code
\param expr - expression to be evaluated. If expr != TRUE assert is printed
              out with line number */
#define TAPI_ASSERT(expr) \
   do { \
      /*lint -e(506, 774) */ \
      if(!(expr)) { \
         (void) IFXOS_DBG_PRINT_USR ("\n\r" __FILE__ ":%d: Assertion %s " \
                                     "failed!\n\r",__LINE__, #expr); \
      } \
   } while (0)
#else /* DEBUG */
/** assert in debug code
\param expr - expression to be evaluated. If expr != TRUE assert is printed
              out with line number */
#define TAPI_ASSERT(expr)
#endif /* DEBUG */


/* ============================= */
/* Name mapping tables           */
/* ============================= */
/*
   Mapping table - Dynamic memory handling.
*/
#define TAPI_OS_Malloc                    IFXOS_BlockAlloc
#define TAPI_OS_Free                      IFXOS_BlockFree

/*
   Mapping table - Kernel-space / User-space data exchange.
*/
#define TAPI_OS_CpyKern2Usr               IFXOS_CpyToUser
#define TAPI_OS_CpyUsr2Kern               IFXOS_CpyFromUser

/*
   Mapping table - Mutex handling.
*/
#define TAPI_OS_mutex_t                   IFXOS_mutex_t
#define TAPI_OS_MutexInit                 IFXOS_MutexInit
#define TAPI_OS_MutexDelete               IFXOS_MutexDelete
#define TAPI_OS_MutexGet                  IFXOS_MutexGet
#define TAPI_OS_MutexRelease              IFXOS_MutexRelease

/*
   Mapping table - Lock handling.
*/
#define TAPI_OS_lock_t                    IFXOS_lock_t
#define TAPI_OS_LockInit                  IFXOS_LockInit
#define TAPI_OS_LockGet                   IFXOS_LockGet
#define TAPI_OS_LockRelease               IFXOS_LockRelease
#define TAPI_OS_LockDelete                IFXOS_LockDelete

/*
   Mapping table - Interrupt handling.
*/
#define TAPI_OS_INTSTAT                   IFXOS_INTSTAT
#define TAPI_OS_LOCKINT                   IFXOS_LOCKINT
#define TAPI_OS_UNLOCKINT                 IFXOS_UNLOCKINT

/*
   Mapping table - Event signalling.
*/
#define TAPI_OS_event_t                   IFXOS_event_t
#define TAPI_OS_EventInit                 IFXOS_EventInit
#define TAPI_OS_EventWakeUp               IFXOS_EventWakeUp
#define TAPI_OS_EventWait                 IFXOS_EventWait
#define TAPI_OS_WAIT_FOREVER              IFXOS_WAIT_FOREVER
#define TAPI_OS_EventDelete               IFXOS_EventDelete

/*
   Mapping table - Select handling.
*/
#define TAPI_OS_drvSelectQueue_t          IFXOS_drvSelectQueue_t
#define TAPI_OS_drvSelectTable_t          IFXOS_drvSelectTable_t
#define TAPI_OS_drvSelectOSArg_t          IFXOS_drvSelectOSArg_t
#define TAPI_OS_DrvSelectQueueInit        IFXOS_DrvSelectQueueInit
#define TAPI_OS_DRV_SEL_WAKEUP_TYPE_RD    IFXOS_DRV_SEL_WAKEUP_TYPE_RD
#define TAPI_OS_DrvSelectQueueWakeUp      IFXOS_DrvSelectQueueWakeUp
#define TAPI_OS_DrvSelectQueueAddTask     IFXOS_DrvSelectQueueAddTask
#define TAPI_OS_DrvSelectQueueDelete(param) /* does not exist */

/*
   Mapping table - Thread handling.
*/
#define TAPI_OS_THREAD_PRIO_HIGH          IFXOS_THREAD_PRIO_HIGH
#define TAPI_OS_THREAD_PRIO_HIGHEST       IFXOS_THREAD_PRIO_HIGHEST
#define TAPI_OS_ThreadCtrl_t              IFXOS_ThreadCtrl_t
#define TAPI_OS_ThreadInit                IFXOS_ThreadInit
#define TAPI_OS_THREAD_PRIORITY_MODIFY    TAPI_OS_ThreadPriorityModify
#define TAPI_OS_THREAD_KILL               TAPI_OS_ThreadKill
#define TAPI_OS_ThreadDelete              IFXOS_ThreadDelete

/*
   Function map - Time and Wait Functions and Defines.
*/
#define TAPI_OS_USecSleep                 IFXOS_USecSleep

#endif /* _DRV_TAPI_OSMAP_H */
