# 0.8.23 Release

- guid: 9a9ab08b-9ca0-4242-b617-5a8b21ea42a0
- author: Markus Raab
- pubDate: Sun, 13 May 2018 08:57:15 +0200
- shortDesc: Notification, Web UI, Build System

We are proud to release Elektra 0.8.23.

In 717 commits 11 authors changed 835 files with 31144 insertions(+), 21773 deletions(-).

## What is Elektra?

Elektra serves as a universal and secure framework to access
configuration settings in a specified, global, hierarchical key database.
For more information, visit [https://libelektra.org](https://libelektra.org).

For a small demo see here:

[![asciicast](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r.png)](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r)

You can also read the news [on our website](https://www.libelektra.org/news/0.8.23-release)

## Highlights

- Notification: New transport plugin
- Web UI greatly improved
- Overhaul of Build System and Daily Stretch Repository

### Notification: New transport plugin

To keep persistent configuration settings in sync with the configuration settings of applications, notifications are needed.
For notifications it is important that they do not block the execution of the applications.
In Elektra we achieve this using transport plugins.

Elektra's notification feature has received its first transport plugin pair:
D-Bus.
Transport plugins provide a link between applications using Elektra.
These plugins send and receive notifications when a key is modified within the
key database.
The existing `dbus` plugin has been modified to use an asynchronous I/O binding
for sending messages, if available.
The new `dbusrecv` plugin is responsible for receiving messages sent from the
`dbus` plugin and other sources with the same
[message format](https://www.libelektra.org/plugins/dbus#notification-format).

For more details see the
[notification tutorial](https://github.com/ElektraInitiative/libelektra/tree/master/doc/tutorials/notifications.md)
or the
[example applications](https://master.libelektra.org/examples).

Thanks to Thomas Wahringer.

### Web UI greatly improved

The goal of the Web UI is to provide safe and unified access to all configuration settings of a system.
Different to other UIs, it generates its interface according specifications as found in Elektra.

For example, if a configuration setting only has a number of choices, you get exactly these choices
within the user interface.

To get outstanding usability, Web UI now provides:

- undo functionality
- visibility functionality to hide irrelevant configuration settings
- built-in validation for many types of configuration settings
- support for arrays
- descriptions of configuration settings embedded in the user interface

Furthermore:

- The Web-UI now is able to install itself via cmake.
- The API was updated for [elektrad](https://master.libelektra.org/doc/api_blueprints/elektrad.apib)
  and [webd](https://master.libelektra.org/doc/api_blueprints/webd.apib) (former clusterd).

[Read here to get started](https://www.libelektra.org/tools/web).

> Note that new version of the Web UI requires Elektra 0.8.23 or later.

Thanks to Daniel Bugl.

### Overhaul of Build System and Daily Stretch Repository

We started to overhaul our build system to improve build times and responsiveness.
It focuses heavily on containerisation to improve hardware utilization.

If you are interested in `#devops` have a look at our
[Jenkinsfile](https://github.com/ElektraInitiative/libelektra/blob/master/scripts/jenkins/Jenkinsfile).

Daily builds Debian packages for Stretch are available again in our
[stretch repository](https://debian-stretch-repo.libelektra.org).
Add it to your `sources.list`:

```
deb     [trusted=yes] https://debian-stretch-repo.libelektra.org/ stretch main
deb-src [trusted=yes] https://debian-stretch-repo.libelektra.org/ stretch main
```

Thanks to Lukas Winkler.

## Other New Features

We added even more functionality, which could not make it to the highlights:

- A new experimental [I/O binding for glib](https://www.libelektra.org/bindings/io_glib)
  has been added.
  It can be used to integrate the notification feature with applications based
  on glib.
- The Order Preserving Minimal Perfect Hash Map (OPMPHM), used to speed up the lookups, got optimized
  and a benchmark was added,
  thanks to Kurt Micheli
- We added a script that calculates the complexity of configuration settings based on their specification,
  thanks to Anton Hößl
- `kdb ls` now has `-0` option to allow key names with newlines (needed for Web UI)
- The [csvstorage](https://www.libelektra.org/plugins/csvstorage) now can treat selected columns
  to be part of the key. Error messages were improved.
  thanks to Thomas Waser

## Other News

- We added a tutorial about securing the integrity and confidentiality of configuration values,
  thanks to Peter Nirschl
- Peter Nirschl finished his [thesis](https://www.libelektra.org/ftp/elektra/publications/nirschl2018cryptographic.pdf)
  ([signature](https://www.libelektra.org/ftp/elektra/publications/nirschl2018cryptographic.pdf.sig)).
  It includes a benchmark of different cryptographic providers.
- Markus Raab gave a [talk](https://cfp.linuxwochen.at/de/LWW18/public/events/798) at Linuxwochen Wien (in German).
  For similar talks in English, please refer to the [FOSDEM talks](https://fosdem.org/2018/schedule/speaker/markus_raab/).
- We replaced the word "project" to "initiative" in the [Code of Conduct](https://www.libelektra.org/devgettingstarted/code-of-conduct) (project has per definition an end date).

## Documentation

We improved the documentation in the following ways:

- FAQ was extended by [Why do I need Elektra if I already use configuration management tools?](https://www.libelektra.org/docgettingstarted/faq)
- Documentation about the recommended [environment](https://www.libelektra.org/devgettingstarted/testing) for test runs were added
- uniformly add `.` at end of short help
- Logo for Doc Set was added and logo for favicon was updated,
  thanks to René Schwaiger
- template of design decisions was updated to use the words
  problem (instead of issue) and rationale (instead of argument).
- [METADATA.ini](https://www.libelektra.org/docgettingstarted/meta-specification):
  - added visibility (as used in Web UI)
  - added type (only check/type existed)
  - plenty of metadata is now used by Web UI
- update docu for type plugin that `check/type/min` and `check/type/max` are deprecated
- Fixed various spelling mistakes,
  thanks to René Schwaiger
- Document limitations of resolver (kdbOpen fails if no home directory found)
  and json/yaml plugins (intermixing of array and objects not detected, which is possible
  in Elektra but impossible in JSON)
- Required environment to run tests is documented.
- A decision about [deferred plugin calls](https://master.libelektra.org/doc/decisions/deferred_plugin_calls.md) has been made and implemented,
  thanks to Thomas Wahringer.

## Compatibility

As always, the ABI and API of kdb.h is fully compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile programs without errors (API).

We removed:

- the not used error code `12` from `kdb mv` from docu

We changed:

- `kdb get`, `kdb mv` and `kdb cp` now use error code `11` if keys are not found
- cascading keys as arguments to `kdb cp` and `kdb mv` now fail instead
  of doing something unexpected, thanks to René Schwaiger for reporting

Shell scripts:

- cp and mv no longer accept cascading keys.

## Notes for Maintainer

These notes are of interest for people maintaining packages of Elektra:

- Docu is updated that [cmake3](https://cmake.org/cmake/help/v3.0/) is required.
  thanks to Lukas Winkler for reporting.
- To run all tests successfully, the `spec` and `list` plugin is required.
  So if `ENABLE_TESTING` is checked, cmake checks the presence of a storage,
  a resolver, the list and the spec plugin,
  thanks to René Schwaiger
- Tests no longer clear environment or reset locales.
  This fixes lua and dbus problems but might cause problems if TMPDIR is set,
  thanks to Lukas Winkler
- This will be the last release supporting Debian Wheezy
  (LTS support will stop in May).
  Directly after the release, Jessie (oldstable) with gcc 4.8.4 will
  be the oldest supported platform.

We added:

- the private headerfiles `kdbnotificationinternal.h`, `kdbioplugin.h`.
- the headerfiles `kdbio_glib.h` and `kdbio_uv.h`
- the plugin `libelektra-dbusrecv.so`
- the scripts `build-web`, `run-elektrad`, and `run-web`
- the test case `testmod_dbusrecv`
- the constant `ENABLE_ASAN` in the constants plugin
- several man pages such as: `kdb-run-elektrad.1` and `kdb-run-web.1`

We removed:

- `Base64.pdf` is not installed anymore
- doxygen-generated man pages such as: `doc_docker_jenkinsnode_README_md.3elektra`,
  `doc_docker_README_md.3elektra`, and `doc_vagrant_README_md.3elektra`

## Website

The website is generated from the repository, so all information about
plugins, bindings and tools are always up to date. Furthermore, we changed:

- Error page that is shown if no JavaScript is enabled now more clearly
  says that the Website only renders content from the repo and
  only contains free JavaScript.
- The [FAQ](https://www.libelektra.org/docgettingstarted/faq) is now
  more visible (added to "getting started").
- The [Code of Conduct](https://www.libelektra.org/devgettingstarted/code-of-conduct)
  was added.

## Notes for Elektra's Developers

These notes are of interest for people developing Elektra:

- `. run_env` is a script to be sourced from the build directory.
  It sets environment variables, so that Elektra from the build
  directory is used (instead of the installed one).
- All current versions of Clang-Format (6.0+) and the outdated Clang-Format 5 will now produce exactly the same output for the whole codebase,
  thanks to René Schwaiger.
- To make enums nicely formatting, make sure at least one member
  is documented.
- You can now add a [Markdown Shell Recorder][] test for a plugin
  via the CMake function `add_plugin` by adding `TEST_README`.
  Furthermore `TEST_REQUIRED_PLUGINS` allows us to specify which
  additional plugins are required,
  thanks to René Schwaiger
- `const` was added to exceptions in catch blocks
  thanks to René Schwaiger
- We now mention to read [doc/DESIGN.md](https://master.libelektra.org/doc/DESIGN.md)
  in the contributing guidelines.
- The CMake functions

  - `add_plugin`
  - `add_msr_test`
  - `add_msr_test_plugin`, and the new
  - `add_shell_recorder_test`

  now allow you to specify a list of required plugins for [Shell Recorder][] and
  Markdown Shell Recorder tests.

- The [Markdown Shell Recorder][] now compares the whole output of `stderr` with the text following the directive `STDERR:`,
  thanks to René Schwaiger
- You can now leave the text following the directive `STDERR:` in a [Markdown Shell Recorder][] test empty:

  ```sh
  true # Print nothing to `stderr`
  # STDERR:
  ```

  . The Markdown Shell Recorder will then check if the command printed nothing to the standard error output.

- The [Shell Recorder][] now also prints the content of the protocol file if a test was unsuccessful or you used the command switch `-p`,
  and always cleans up the protocol,
  thanks to René Schwaiger
- We added an [Markdown Shell Recorder][] test for the [Constants](http://libelektra.org/plugins/constants) plugin.
- The [Markdown Shell Recorder][] now prints the path of the test file.
  thanks to René Schwaiger
- The Haskell binding now explicitly requires GHC installed with a minimum version of 8.0.0 during cmake
  thanks to René Schwaiger and Lukas Winkler
- If any of the tests in `make run_memcheck` fail valgrind will now set an exit-code which will get picked up by make,
  thanks to Lukas Winkler
- We introduced git reference repositories to save I/O on our build system,
  thanks to Lukas Winkler
- Set `LD_LIBRARY_PATH` in all tests removing the need to specify it for running ctest,
  thanks to Lukas Winkler
- Provide the `RUN_SERIAL` property to all tests that can not be run in parallel,
  thanks to Lukas Winkler
- Speeding up your test runs via `ctest -j` is now possible,
  thanks to Lukas Winkler
- We now disable the [Xerces plugin](http://libelektra.org/plugins/xerces) if you use GCC with enabled ASAN to build Elektra. This update
  makes sure that you do not build the plugin with compilation settings that are known to
  [cause problems](https://github.com/ElektraInitiative/libelektra/issues/1895).
- Documentation and debugging capabilities of [Markdown Shell Recorder][] were improved.
- We added style guidelines for CMake code to
  [`doc/CODING.md`](https://github.com/ElektraInitiative/libelektra/blob/master/doc/CODING.md#cmake-guidelines).

[markdown shell recorder]: https://master.libelektra.org/tests/shell/shell_recorder/tutorial_wrapper
[shell recorder]: https://master.libelektra.org/tests/shell/shell_recorder

## Fixes

Many problems were resolved with the following fixes:

- [YAML CPP](http://libelektra.org/plugins/yamlcpp) now also saves key values directly below a mountpoint correctly,
  thanks to René Schwaiger
- If you use a minimal configuration ([`dump`](http://libelektra.org/plugins/dump), [`resolver`](https://www.libelektra.org/plugins/resolver), list, and spec), all test of the test suite now finish successfully again,
  thanks to René Schwaiger
- small refactoring in `kdb-test`
- The Haskell plugin failed to build if the Haskell bindings were not included explicitly by name.
- Fix invalid handling of keynames in the [spec](http://libelektra.org/plugins/spec) plugin.
- The [Shell Recorder][] counts the number of executed tests properly again.
- CMake now fails if the required plugins [list](http://libelektra.org/plugins/list) or [spec](http://libelektra.org/plugins/spec) (on
  non-[MinGW](http://mingw.org) platforms) are missing from the current build configuration.
- The [Lua](http://libelektra.org/plugins/lua), [Python 2](http://libelektra.org/plugins/python2),
  [Python](http://libelektra.org/plugins/python), and [Ruby](http://libelektra.org/plugins/ruby) plugins now require SWIG bindings for
  the corresponding programming language,
  thanks to René Schwaiger
- The [type checker](https://www.libelektra.org/plugins/type) now also honors `type` next to `check/type`
- Fix various compiler warnings
- The detection of Botan, Libgcrypt, LibGit2 and OpenSSL now also works properly, if we treat warnings as errors (compiler switch `-Werror`),
  thanks to René Schwaiger
- The [multifile plugin](http://libelektra.org/plugins/multifile) now passes the child config
  to the storage plugins too and also handles symlinks correctly,
  thanks to Thomas Waser

## Workshop

[Elektra Initiative](https://www.libelektra.org/developers/authors) are the people behind Elektra.
Our goal is to build up expertise with configuration settings and improve the situation in the FLOSS landscape.
To learn more about the needs of configuration-wise non-trivial FLOSS applications, we have workshops.
After a successful workshop with the LCDproc's maintainer, the next Workshop will be with people from KDE.

We will use the opportunity of [Akademy](https://akademy.kde.org/2018) being in Vienna.
We already got positive feedback from kconfig maintainers (David Faure and Aleix Pol).

If you are interested, you can sign up.
We are looking forward to an informative, interactive and interesting workshop!

## Outlook

We are currently working on following topics:

- Klemens Böswirth: [elektrifying LCDproc](https://www.libelektra.org/news/elektrify-lcdproc)
  After some setbacks (the two original developers who wanted to work on LCDproc resigned because of job duties)
  LCDproc development restarted now successfully.
  The new plan is to have more intermediate stages.
  In particular the first integration will be a minimal invasive integration without high-level API.
- Armin Wurzinger: type system for Elektra's specification language
- Anton Hössl: Puppet
- Daniel Bugl: Web UI
- Hani Torabi Makhsos: reduce community entry barriers
- Kurt Micheli: order preserving minimal perfect hash map
- Lukas Winkler: continous integration
- Mihael Pranjić: mmap plugin (i.e. avoiding reparsing of configuration files)
- Peter Nirschl: integrity and confidentiality
- René Schwaiger: parsing techniques
- Thomas Wahringer: notification techniques
- Thomas Waser: Linux distribution based on Elektra
- Ulrike Schaefer: generate shell completion files from Elektra's specification
- Vanessa Kos: misconfiguration bug database
- We created a proof of concept for a Chef resource and an Ansible module successfully setting Elektra's keys.
  They are not yet published. If you are interested on this preliminary work, please contact us.

## Get It!

You can download the release from [here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.23.tar.gz)
or [GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.23.tar.gz?raw=true)

The [hashsums are:](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.23.tar.gz.hashsum?raw=true)

- name: elektra-0.8.23.tar.gz
- size: 5870069
- md5sum: 0a065ed381a59b6213bd46fd3c82ba83
- sha1: 0727b420ff721e654b0ba6ab1d0c78e5e2341d26
- sha256: f1d3cd4888ba3ef47c1327cbddf21dff7be289f94217f12e5e93105273ca6c48

The release tarball is also available signed by Markus Raab using GnuPG from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.23.tar.gz.gpg) or
[GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases//elektra-0.8.23.tar.gz.gpg?raw=true)

Already built API-Docu can be found [online](https://doc.libelektra.org/api/0.8.23/html/)
or [GitHub](https://github.com/ElektraInitiative/doc/tree/master/api/0.8.23).

## Stay tuned!

Subscribe to the
[RSS feed](https://www.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
issue tracker [on GitHub](http://issues.libelektra.org)
or Markus Raab by email using elektra@markus-raab.org.

[Permalink to this NEWS entry](https://www.libelektra.org/news/0.8.23-release)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
[Elektra Initiative](https://www.libelektra.org/developers/authors)
