/*
 * Copyright 2019-present Facebook, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
struct GetEntityRequest {
  1: string id;
}

struct GetEntityResponse {
  1: string entity;
}

service GetEntity {
  GetEntityResponse getEntity(1: GetEntityRequest r);

  bool getBool();
  byte getByte();
  i16 getI16();
  i32 getI32();
  i64 getI64();
  double getDouble();
  string getString();
  binary getBinary();
  map<string, string> getMap();
  set<string> getSet();
  list<string> getList();
}
