/*
 * Copyright 2004-present Facebook, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <thrift/lib/cpp2/server/ThriftServer.h>
#include <thrift/lib/cpp2/server/TransportRoutingHandler.h>

namespace apache {
namespace thrift {

class Cpp2Worker;

class RSRoutingHandler : public TransportRoutingHandler {
 public:
  RSRoutingHandler() = default;
  ~RSRoutingHandler() override;
  RSRoutingHandler(const RSRoutingHandler&) = delete;
  RSRoutingHandler& operator=(const RSRoutingHandler&) = delete;

  void stopListening() override;
  bool canAcceptConnection(const std::vector<uint8_t>& bytes) override;
  bool canAcceptEncryptedConnection(const std::string& protocolName) override;
  void handleConnection(
      wangle::ConnectionManager* connectionManager,
      folly::AsyncTransportWrapper::UniquePtr sock,
      folly::SocketAddress const* peerAddress,
      wangle::TransportInfo const& tinfo,
      std::shared_ptr<Cpp2Worker> worker) override;

 private:
  std::atomic<bool> listening_{true};
};
} // namespace thrift
} // namespace apache
