#!/usr/bin/env python3
from enum import Enum
from typing import TypeVar, Type, Union

from thrift.py3.types import Struct
from thrift.py3.common import Protocol as Protocol
from folly.iobuf import IOBuf

sT = TypeVar("sT", bound=Struct)

class Transform(Enum):
    NONE: Transform = ...
    ZLIB_TRANSFORM: Transform = ...
    SNAPPY_TRANSFORM: Transform = ...
    ZSTD_TRANSFORM: Transform = ...

def serialize(tstruct: sT, protocol: Protocol = ...) -> bytes: ...
def serialize_iobuf(tstruct: sT, protocol: Protocol = ...) -> IOBuf: ...
def deserialize(
    structKlass: Type[sT],
    buf: Union[bytes, bytearray, IOBuf, memoryview],
    protocol: Protocol = ...,
) -> sT: ...
def serialize_with_header(
    tstruct: sT, protocol: Protocol = ..., transform: Transform = ...
) -> bytes: ...
def serialize_with_header_iobuf(
    tstruct: sT, protocol: Protocol = ..., transform: Transform = ...
) -> IOBuf: ...
def deserialize_from_header(
    structKlass: Type[sT], buf: Union[bytes, bytearray, IOBuf, memoryview]
) -> sT: ...
