<!--- AUTOGENERATED BY `./recipes.py test train` -->
# Repo documentation for [gn]()
## Table of Contents

**[Recipe Modules](#Recipe-Modules)**
  * [macos_sdk](#recipe_modules-macos_sdk) (Python3 ✅) &mdash; The `macos_sdk` module provides safe functions to access a semi-hermetic XCode installation.
  * [target](#recipe_modules-target) (Python3 ✅)
  * [windows_sdk](#recipe_modules-windows_sdk) (Python3 ✅)

**[Recipes](#Recipes)**
  * [gn](#recipes-gn) (Python3 ✅) &mdash; Recipe for building GN.
  * [macos_sdk:examples/full](#recipes-macos_sdk_examples_full) (Python3 ✅)
  * [target:examples/full](#recipes-target_examples_full) (Python3 ✅)
  * [windows_sdk:examples/full](#recipes-windows_sdk_examples_full) (Python3 ✅)
## Recipe Modules

### *recipe_modules* / [macos\_sdk](/infra/recipe_modules/macos_sdk)

[DEPS](/infra/recipe_modules/macos_sdk/__init__.py#7): [recipe\_engine/cipd][recipe_engine/recipe_modules/cipd], [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/step][recipe_engine/recipe_modules/step]

PYTHON_VERSION_COMPATIBILITY: PY3

The `macos_sdk` module provides safe functions to access a semi-hermetic
XCode installation.

Available only to Google-run bots.

#### **class [MacOSSDKApi](/infra/recipe_modules/macos_sdk/api.py#14)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

API for using OS X SDK distributed via CIPD.

&emsp; **@contextmanager**<br>&mdash; **def [\_\_call\_\_](/infra/recipe_modules/macos_sdk/api.py#30)(self):**

Sets up the XCode SDK environment.

This call is a no-op on non-Mac platforms.

This will deploy the helper tool and the XCode.app bundle at
`[START_DIR]/cache/macos_sdk`.

To avoid machines rebuilding these on every run, set up a named cache in
your cr-buildbucket.cfg file like:

    caches: {
      # Cache for mac_toolchain tool and XCode.app
      name: "macos_sdk"
      path: "macos_sdk"
    }

If you have builders which e.g. use a non-current SDK, you can give them
a uniqely named cache:

    caches: {
      # Cache for N-1 version mac_toolchain tool and XCode.app
      name: "macos_sdk_old"
      path: "macos_sdk"
    }

Usage:
  with api.macos_sdk():
    # sdk with mac build bits

Raises:
    StepFailure or InfraFailure.

&emsp; **@property**<br>&mdash; **def [sdk\_dir](/infra/recipe_modules/macos_sdk/api.py#25)(self):**
### *recipe_modules* / [target](/infra/recipe_modules/target)

[DEPS](/infra/recipe_modules/target/__init__.py#7): [recipe\_engine/platform][recipe_engine/recipe_modules/platform]

PYTHON_VERSION_COMPATIBILITY: PY3

#### **class [TargetApi](/infra/recipe_modules/target/api.py#82)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

&emsp; **@property**<br>&mdash; **def [host](/infra/recipe_modules/target/api.py#87)(self):**
### *recipe_modules* / [windows\_sdk](/infra/recipe_modules/windows_sdk)

[DEPS](/infra/recipe_modules/windows_sdk/__init__.py#7): [recipe\_engine/cipd][recipe_engine/recipe_modules/cipd], [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/step][recipe_engine/recipe_modules/step]

PYTHON_VERSION_COMPATIBILITY: PY3

#### **class [WindowsSDKApi](/infra/recipe_modules/windows_sdk/api.py#10)([RecipeApi][recipe_engine/wkt/RecipeApi]):**

API for using Windows SDK distributed via CIPD.

&emsp; **@contextmanager**<br>&mdash; **def [\_\_call\_\_](/infra/recipe_modules/windows_sdk/api.py#19)(self):**

Setups the Windows SDK environment.

This call is a no-op on non-Windows platforms.

Raises:
    StepFailure or InfraFailure.
## Recipes

### *recipes* / [gn](/infra/recipes/gn.py)

[DEPS](/infra/recipes/gn.py#10): [macos\_sdk](#recipe_modules-macos_sdk), [target](#recipe_modules-target), [windows\_sdk](#recipe_modules-windows_sdk), [recipe\_engine/buildbucket][recipe_engine/recipe_modules/buildbucket], [recipe\_engine/cas][recipe_engine/recipe_modules/cas], [recipe\_engine/cipd][recipe_engine/recipe_modules/cipd], [recipe\_engine/context][recipe_engine/recipe_modules/context], [recipe\_engine/file][recipe_engine/recipe_modules/file], [recipe\_engine/json][recipe_engine/recipe_modules/json], [recipe\_engine/path][recipe_engine/recipe_modules/path], [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/python][recipe_engine/recipe_modules/python], [recipe\_engine/raw\_io][recipe_engine/recipe_modules/raw_io], [recipe\_engine/step][recipe_engine/recipe_modules/step]

PYTHON_VERSION_COMPATIBILITY: PY3

Recipe for building GN.

&mdash; **def [RunSteps](/infra/recipes/gn.py#106)(api, repository):**
### *recipes* / [macos\_sdk:examples/full](/infra/recipe_modules/macos_sdk/examples/full.py)

[DEPS](/infra/recipe_modules/macos_sdk/examples/full.py#7): [macos\_sdk](#recipe_modules-macos_sdk), [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/step][recipe_engine/recipe_modules/step]

PYTHON_VERSION_COMPATIBILITY: PY3

&mdash; **def [RunSteps](/infra/recipe_modules/macos_sdk/examples/full.py#15)(api):**
### *recipes* / [target:examples/full](/infra/recipe_modules/target/examples/full.py)

[DEPS](/infra/recipe_modules/target/examples/full.py#7): [target](#recipe_modules-target), [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/step][recipe_engine/recipe_modules/step]

PYTHON_VERSION_COMPATIBILITY: PY3

&mdash; **def [RunSteps](/infra/recipe_modules/target/examples/full.py#15)(api):**
### *recipes* / [windows\_sdk:examples/full](/infra/recipe_modules/windows_sdk/examples/full.py)

[DEPS](/infra/recipe_modules/windows_sdk/examples/full.py#7): [windows\_sdk](#recipe_modules-windows_sdk), [recipe\_engine/platform][recipe_engine/recipe_modules/platform], [recipe\_engine/properties][recipe_engine/recipe_modules/properties], [recipe\_engine/step][recipe_engine/recipe_modules/step]

PYTHON_VERSION_COMPATIBILITY: PY3

&mdash; **def [RunSteps](/infra/recipe_modules/windows_sdk/examples/full.py#15)(api):**

[recipe_engine/recipe_modules/buildbucket]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/1b1ecd03e0b00399784c43add1465f685b6d1ab9/README.recipes.md#recipe_modules-buildbucket
[recipe_engine/recipe_modules/cas]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/1b1ecd03e0b00399784c43add1465f685b6d1ab9/README.recipes.md#recipe_modules-cas
[recipe_engine/recipe_modules/cipd]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/1b1ecd03e0b00399784c43add1465f685b6d1ab9/README.recipes.md#recipe_modules-cipd
[recipe_engine/recipe_modules/context]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/1b1ecd03e0b00399784c43add1465f685b6d1ab9/README.recipes.md#recipe_modules-context
[recipe_engine/recipe_modules/file]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/1b1ecd03e0b00399784c43add1465f685b6d1ab9/README.recipes.md#recipe_modules-file
[recipe_engine/recipe_modules/json]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/1b1ecd03e0b00399784c43add1465f685b6d1ab9/README.recipes.md#recipe_modules-json
[recipe_engine/recipe_modules/path]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/1b1ecd03e0b00399784c43add1465f685b6d1ab9/README.recipes.md#recipe_modules-path
[recipe_engine/recipe_modules/platform]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/1b1ecd03e0b00399784c43add1465f685b6d1ab9/README.recipes.md#recipe_modules-platform
[recipe_engine/recipe_modules/properties]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/1b1ecd03e0b00399784c43add1465f685b6d1ab9/README.recipes.md#recipe_modules-properties
[recipe_engine/recipe_modules/python]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/1b1ecd03e0b00399784c43add1465f685b6d1ab9/README.recipes.md#recipe_modules-python
[recipe_engine/recipe_modules/raw_io]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/1b1ecd03e0b00399784c43add1465f685b6d1ab9/README.recipes.md#recipe_modules-raw_io
[recipe_engine/recipe_modules/step]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/1b1ecd03e0b00399784c43add1465f685b6d1ab9/README.recipes.md#recipe_modules-step
[recipe_engine/wkt/RecipeApi]: https://chromium.googlesource.com/infra/luci/recipes-py.git/+/1b1ecd03e0b00399784c43add1465f685b6d1ab9/recipe_engine/recipe_api.py#883
