"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LinuxService = void 0;
const child_process = require("child_process");
const common_1 = require("@nestjs/common");
const config_service_1 = require("../../../core/config/config.service");
const logger_service_1 = require("../../../core/logger/logger.service");
let LinuxService = class LinuxService {
    constructor(configService, logger) {
        this.configService = configService;
        this.logger = logger;
    }
    restartHost() {
        const cmd = [(this.configService.ui.linux && this.configService.ui.linux.restart) ?
                this.configService.ui.linux.restart : 'sudo -n shutdown -r now'];
        this.logger.warn(`Rebooting linux server with command: "${cmd.join(' ')}"`);
        setTimeout(() => {
            child_process.exec(cmd.join(' '), (err) => {
                if (err) {
                    this.logger.error(err.message);
                }
            });
        }, 100);
        return { ok: true, command: cmd };
    }
    shutdownHost() {
        const cmd = [(this.configService.ui.linux && this.configService.ui.linux.shutdown) ?
                this.configService.ui.linux.shutdown : 'sudo -n shutdown -h now'];
        this.logger.warn(`Shutting down linux server with command: "${cmd.join(' ')}"`);
        setTimeout(() => {
            child_process.exec(cmd.join(' '), (err) => {
                if (err) {
                    this.logger.error(err.message);
                }
            });
        }, 500);
        return { ok: true, command: cmd };
    }
};
LinuxService = __decorate([
    common_1.Injectable(),
    __metadata("design:paramtypes", [config_service_1.ConfigService,
        logger_service_1.Logger])
], LinuxService);
exports.LinuxService = LinuxService;
//# sourceMappingURL=linux.service.js.map