"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPropertyValueConfiguration = exports.isDeviceConfiguration = exports.isBaseDeviceConfiguration = exports.isMqttConfiguration = exports.isPluginConfiguration = void 0;
const z2mModels_1 = require("./z2mModels");
const isPluginConfiguration = (x, logger = undefined) => {
    if (x.mqtt === undefined || !(0, exports.isMqttConfiguration)(x.mqtt)) {
        logger === null || logger === void 0 ? void 0 : logger.error('Incorrect configuration: mqtt does not contain required fields');
        return false;
    }
    if (x.defaults !== undefined && !(0, exports.isBaseDeviceConfiguration)(x.defaults)) {
        logger === null || logger === void 0 ? void 0 : logger.error('Incorrect configuration: Device defaults are incorrect: ' + JSON.stringify(x.defaults));
        return false;
    }
    if (x.experimental !== undefined && !isStringArray(x.experimental)) {
        logger === null || logger === void 0 ? void 0 : logger.error('Incorrect configuration: Experimental flags are incorrect ' + JSON.stringify(x.experimental));
        return false;
    }
    if (x.exclude_grouped_devices !== undefined && typeof x.exclude_grouped_devices !== 'boolean') {
        logger === null || logger === void 0 ? void 0 : logger.error('Incorrect configuration: exclude_grouped_devices must be a boolean, if defined.');
        return false;
    }
    if (x.devices !== undefined) {
        if (!Array.isArray(x.devices)) {
            logger === null || logger === void 0 ? void 0 : logger.error('Incorrect configuration: devices must be an array');
            return false;
        }
        for (const element of x.devices) {
            if (!(0, exports.isDeviceConfiguration)(element)) {
                logger === null || logger === void 0 ? void 0 : logger.error('Incorrect configuration: Entry for device is not correct: ' + JSON.stringify(element));
                return false;
            }
        }
    }
    return true;
};
exports.isPluginConfiguration = isPluginConfiguration;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const isMqttConfiguration = (x) => (x.base_topic !== undefined
    && typeof x.base_topic === 'string'
    && x.base_topic.length > 0
    && x.server !== undefined
    && typeof x.server === 'string'
    && x.server.length > 0);
exports.isMqttConfiguration = isMqttConfiguration;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const isBaseDeviceConfiguration = (x) => {
    // Optional boolean exclude property
    if (x.exclude !== undefined && typeof x.exclude !== 'boolean') {
        return false;
    }
    // Optional excluded_keys which must be an array of strings if present
    if (x.excluded_keys !== undefined && !isStringArray(x.excluded_keys)) {
        return false;
    }
    // Optional 'experimental' which must be an array of strings if present
    if (x.experimental !== undefined && !isStringArray(x.experimental)) {
        return false;
    }
    // Optional values property which must be an array of PropertyValueConfigurations if present
    if (x.values !== undefined) {
        if (!Array.isArray(x.values)) {
            return false;
        }
        for (const element of x.values) {
            if (!(0, exports.isPropertyValueConfiguration)(element)) {
                return false;
            }
        }
    }
    return true;
};
exports.isBaseDeviceConfiguration = isBaseDeviceConfiguration;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const isDeviceConfiguration = (x) => {
    // Required id property
    if (x.id === undefined || typeof x.id !== 'string' || x.id.length < 1) {
        return false;
    }
    // Optional included_keys which must be an array of strings if present
    if (x.included_keys !== undefined && !isStringArray(x.included_keys)) {
        return false;
    }
    // Check if exposes is an array of ExposesEntry, if configured.
    if (x.exposes !== undefined) {
        if (!Array.isArray(x.exposes)) {
            return false;
        }
        for (const element of x.exposes) {
            if (!(0, z2mModels_1.isExposesEntry)(element)) {
                return false;
            }
        }
    }
    return (0, exports.isBaseDeviceConfiguration)(x);
};
exports.isDeviceConfiguration = isDeviceConfiguration;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const isPropertyValueConfiguration = (x) => {
    // Required 'property' property
    if (x.property === undefined || typeof x.property !== 'string' || x.property.length < 1) {
        return false;
    }
    // Optional include property
    if (x.include !== undefined && !isStringArray(x.include)) {
        return false;
    }
    // Optional exclude property
    if (x.exclude !== undefined && !isStringArray(x.exclude)) {
        return false;
    }
    return true;
};
exports.isPropertyValueConfiguration = isPropertyValueConfiguration;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const isStringArray = (x) => {
    if (!Array.isArray(x)) {
        return false;
    }
    for (const element of x) {
        if (typeof element !== 'string') {
            return false;
        }
    }
    return true;
};
//# sourceMappingURL=configModels.js.map