import { PlatformConfig } from 'homebridge';
import { ConverterConfigValidatorCollection } from './converters/creators';
import { BasicLogger } from './logger';
import { ExposesEntry } from './z2mModels';
export interface PluginConfiguration extends PlatformConfig {
    mqtt: MqttConfiguration;
    defaults?: BaseDeviceConfiguration;
    experimental?: string[];
    devices?: DeviceConfiguration[];
    exclude_grouped_devices?: boolean;
}
export declare const isPluginConfiguration: (x: PlatformConfig, converterConfigValidator: ConverterConfigValidatorCollection, logger?: BasicLogger | undefined) => x is PluginConfiguration;
export interface MqttConfiguration extends Record<string, unknown> {
    base_topic: string;
    server: string;
    ca?: string;
    key?: string;
    cert?: string;
    user?: string;
    password?: string;
    client_id?: string;
    reject_unauthorized?: boolean;
    keepalive?: number;
    version?: number;
    disable_qos?: boolean;
}
export declare const isMqttConfiguration: (x: any) => x is MqttConfiguration;
export interface BaseDeviceConfiguration extends Record<string, unknown> {
    exclude?: boolean;
    excluded_keys?: string[];
    values?: PropertyValueConfiguration[];
    converters?: object;
    experimental?: string[];
}
export interface DeviceConfiguration extends BaseDeviceConfiguration {
    id: string;
    included_keys?: string[];
    exposes?: ExposesEntry[];
}
export declare const isBaseDeviceConfiguration: (x: any) => x is BaseDeviceConfiguration;
export declare const isDeviceConfiguration: (x: any) => x is DeviceConfiguration;
export interface PropertyValueConfiguration extends Record<string, unknown> {
    property: string;
    include?: string[];
    exclude?: string[];
}
export declare const isPropertyValueConfiguration: (x: any) => x is PropertyValueConfiguration;
//# sourceMappingURL=configModels.d.ts.map