"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasicSensorHandler = void 0;
const z2mModels_1 = require("../../z2mModels");
const monitor_1 = require("../monitor");
const helpers_1 = require("../../helpers");
const hap_1 = require("../../hap");
class BasicSensorHandler {
    constructor(accessory, sensorExpose, otherExposes, identifierGen, service, additionalSubType) {
        this.sensorExpose = sensorExpose;
        this.monitors = [];
        this.identifier = '';
        const endpoint = sensorExpose.endpoint;
        let sub = endpoint;
        if (additionalSubType !== undefined) {
            if (sub === undefined) {
                sub = additionalSubType;
            }
            else {
                sub += ' ' + additionalSubType;
            }
        }
        this.serviceName = accessory.getDefaultServiceDisplayName(sub);
        this.identifier = identifierGen(endpoint, accessory);
        this.service = accessory.getOrAddService(service(this.serviceName, sub));
        this.tryCreateLowBattery(otherExposes, this.service);
        this.tryCreateTamper(otherExposes, this.service);
    }
    get getableKeys() {
        const keys = [];
        if ((0, z2mModels_1.exposesCanBeGet)(this.sensorExpose)) {
            keys.push(this.sensorExpose.property);
        }
        if (this.tamperExpose !== undefined && (0, z2mModels_1.exposesCanBeGet)(this.tamperExpose)) {
            keys.push(this.tamperExpose.property);
        }
        if (this.lowBatteryExpose !== undefined && (0, z2mModels_1.exposesCanBeGet)(this.lowBatteryExpose)) {
            keys.push(this.lowBatteryExpose.property);
        }
        return keys;
    }
    createOptionalGenericCharacteristics(exposes, service) {
        this.tryCreateTamper(exposes, service);
        this.tryCreateLowBattery(exposes, service);
    }
    tryCreateTamper(exposes, service) {
        this.tamperExpose = exposes.find(e => e.name === 'tamper' && (0, z2mModels_1.exposesIsPublished)(e));
        if (this.tamperExpose !== undefined) {
            (0, helpers_1.getOrAddCharacteristic)(service, hap_1.hap.Characteristic.StatusTampered);
            const mapping = new Map();
            mapping.set(this.tamperExpose.value_on, hap_1.hap.Characteristic.StatusTampered.TAMPERED);
            mapping.set(this.tamperExpose.value_off, hap_1.hap.Characteristic.StatusTampered.NOT_TAMPERED);
            this.monitors.push(new monitor_1.MappingCharacteristicMonitor(this.tamperExpose.property, service, hap_1.hap.Characteristic.StatusTampered, mapping));
        }
    }
    tryCreateLowBattery(exposes, service) {
        this.lowBatteryExpose = exposes.find(e => e.name === 'battery_low' && (0, z2mModels_1.exposesIsPublished)(e));
        if (this.lowBatteryExpose !== undefined) {
            (0, helpers_1.getOrAddCharacteristic)(service, hap_1.hap.Characteristic.StatusLowBattery);
            const mapping = new Map();
            mapping.set(this.lowBatteryExpose.value_on, hap_1.hap.Characteristic.StatusLowBattery.BATTERY_LEVEL_LOW);
            mapping.set(this.lowBatteryExpose.value_off, hap_1.hap.Characteristic.StatusLowBattery.BATTERY_LEVEL_NORMAL);
            this.monitors.push(new monitor_1.MappingCharacteristicMonitor(this.lowBatteryExpose.property, service, hap_1.hap.Characteristic.StatusLowBattery, mapping));
        }
    }
    updateState(state) {
        this.monitors.forEach(m => m.callback(state));
    }
}
exports.BasicSensorHandler = BasicSensorHandler;
//# sourceMappingURL=basic.js.map