import { API, DynamicPlatformPlugin, Logger, PlatformAccessory, PlatformConfig } from 'homebridge';
import { PluginConfiguration } from './configModels';
import * as mqtt from 'mqtt';
export declare class Zigbee2mqttPlatform implements DynamicPlatformPlugin {
    readonly log: Logger;
    readonly api: API;
    readonly config?: PluginConfiguration;
    private baseDeviceConfig;
    private readonly mqttClient?;
    private static readonly MIN_Z2M_VERSION;
    private static readonly TOPIC_BRIDGE;
    private readonly accessories;
    private didReceiveDevices;
    private lastReceivedZigbee2MqttVersion;
    private lastReceivedDevices;
    private lastReceivedGroups;
    private groupUpdatePending;
    private deviceUpdatePending;
    constructor(log: Logger, config: PlatformConfig, api: API);
    private initializeMqttClient;
    isExperimentalFeatureEnabled(feature: string): boolean;
    private static createMqttOptions;
    private checkZigbee2MqttVersion;
    private onMessage;
    private handleDeviceUpdate;
    private removeStaleDevices;
    private handleReceivedDevices;
    configureAccessory(accessory: PlatformAccessory): void;
    private static getIdentifiersFromDevice;
    private getAdditionalConfigForDevice;
    private mergeDeviceConfig;
    private isDeviceExcluded;
    private addAccessory;
    private createOrUpdateAccessory;
    isConnected(): boolean;
    publishMessage(topic: string, payload: string, options: mqtt.IClientPublishOptions): Promise<void>;
    private createGroupAccessories;
    private createDeviceListEntryFromGroup;
    private determineExposesForGroup;
}
//# sourceMappingURL=platform.d.ts.map