"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BinarySensorHandler = exports.ConfigurableBinarySensorHandler = exports.isBinarySensorConfig = exports.BinarySensorTypeDefinition = void 0;
const z2mModels_1 = require("../../z2mModels");
const monitor_1 = require("../monitor");
const helpers_1 = require("../../helpers");
const basic_1 = require("./basic");
class BinarySensorTypeDefinition {
    constructor(service, characteristic, hapOnValue, hapOffValue, additionalSubType) {
        this.service = service;
        this.characteristic = characteristic;
        this.hapOnValue = hapOnValue;
        this.hapOffValue = hapOffValue;
        this.additionalSubType = additionalSubType;
    }
}
exports.BinarySensorTypeDefinition = BinarySensorTypeDefinition;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const isBinarySensorConfig = (x) => (x !== undefined && (x.type === undefined
    || (typeof x.type === 'string' && x.type.length > 0)));
exports.isBinarySensorConfig = isBinarySensorConfig;
class ConfigurableBinarySensorHandler extends basic_1.BasicSensorHandler {
    constructor(accessory, expose, otherExposes, identifierGen, logName, configTag, defaultType, typeDefinitions) {
        let definition = typeDefinitions.get(defaultType);
        if (definition === undefined) {
            throw new Error(`Unknown default binary sensor type ${defaultType} for ${logName}`);
        }
        if (configTag !== undefined) {
            const converterConfig = accessory.getConverterConfiguration(configTag);
            if ((0, exports.isBinarySensorConfig)(converterConfig) && converterConfig.type !== undefined) {
                const chosenDefinition = typeDefinitions.get(converterConfig.type);
                if (chosenDefinition !== undefined) {
                    definition = chosenDefinition;
                }
                else {
                    accessory.log.error(`Invalid type chosen for ${logName}: ${converterConfig.type} (${accessory.displayName})`);
                }
            }
        }
        super(accessory, expose, otherExposes, identifierGen, definition.service, definition.additionalSubType);
        accessory.log.debug(`Configuring ${logName} for ${this.serviceName}`);
        (0, helpers_1.getOrAddCharacteristic)(this.service, definition.characteristic);
        const mapping = new Map();
        mapping.set(expose.value_on, definition.hapOnValue);
        mapping.set(expose.value_off, definition.hapOffValue);
        this.monitors.push(new monitor_1.MappingCharacteristicMonitor(expose.property, this.service, definition.characteristic, mapping));
    }
}
exports.ConfigurableBinarySensorHandler = ConfigurableBinarySensorHandler;
ConfigurableBinarySensorHandler.exposesType = z2mModels_1.ExposesKnownTypes.BINARY;
class BinarySensorHandler extends ConfigurableBinarySensorHandler {
    constructor(accessory, expose, otherExposes, identifierGen, logName, service, characteristic, hapOnValue, hapOffValue, additionalSubType) {
        super(accessory, expose, otherExposes, identifierGen, logName, undefined, '', new Map([
            ['', new BinarySensorTypeDefinition(service, characteristic, hapOnValue, hapOffValue, additionalSubType)],
        ]));
    }
}
exports.BinarySensorHandler = BinarySensorHandler;
//# sourceMappingURL=binary.js.map