"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContactSensorHandler = void 0;
const hap_1 = require("../../hap");
const binary_1 = require("./binary");
class ContactSensorHandler extends binary_1.BinarySensorHandler {
    constructor(expose, otherExposes, accessory) {
        super(accessory, expose, otherExposes, ContactSensorHandler.generateIdentifier, 'ContactSensor', (n, t) => new hap_1.hap.Service.ContactSensor(n, t), hap_1.hap.Characteristic.ContactSensorState, hap_1.hap.Characteristic.ContactSensorState.CONTACT_NOT_DETECTED, hap_1.hap.Characteristic.ContactSensorState.CONTACT_DETECTED);
    }
    static generateIdentifier(endpoint) {
        let identifier = hap_1.hap.Service.ContactSensor.UUID;
        if (endpoint !== undefined) {
            identifier += '_' + endpoint.trim();
        }
        return identifier;
    }
}
exports.ContactSensorHandler = ContactSensorHandler;
ContactSensorHandler.exposesName = 'contact';
//# sourceMappingURL=contact.js.map