"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeviceTemperatureSensorHandler = void 0;
const z2mModels_1 = require("../../z2mModels");
const monitor_1 = require("../monitor");
const helpers_1 = require("../../helpers");
const hap_1 = require("../../hap");
const basic_1 = require("./basic");
class DeviceTemperatureSensorHandler extends basic_1.BasicSensorHandler {
    constructor(expose, allExposes, accessory) {
        super(accessory, expose, allExposes, DeviceTemperatureSensorHandler.generateIdentifier, (n, t) => new hap_1.hap.Service.TemperatureSensor(n, t), DeviceTemperatureSensorHandler.exposesName);
        accessory.log.debug(`Configuring Device TemperatureSensor for ${this.serviceName}`);
        const characteristic = (0, helpers_1.getOrAddCharacteristic)(this.service, hap_1.hap.Characteristic.CurrentTemperature);
        if (!(0, helpers_1.copyExposesRangeToCharacteristic)(expose, characteristic)) {
            // Cannot take over range from exposes entry -> Set default range
            characteristic.setProps({
                minValue: -100,
                maxValue: 100,
            });
        }
        this.monitors.push(new monitor_1.PassthroughCharacteristicMonitor(expose.property, this.service, hap_1.hap.Characteristic.CurrentTemperature));
    }
    static generateIdentifier(endpoint) {
        if (endpoint === DeviceTemperatureSensorHandler.exposesName) {
            endpoint = undefined;
        }
        let identifier = hap_1.hap.Service.TemperatureSensor.UUID + '_' + DeviceTemperatureSensorHandler.exposesName;
        if (endpoint !== undefined) {
            identifier += '_' + endpoint.trim();
        }
        return identifier;
    }
}
exports.DeviceTemperatureSensorHandler = DeviceTemperatureSensorHandler;
DeviceTemperatureSensorHandler.exposesName = 'device_temperature';
DeviceTemperatureSensorHandler.exposesType = z2mModels_1.ExposesKnownTypes.NUMERIC;
//# sourceMappingURL=device_temperature.js.map