"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HumiditySensorHandler = void 0;
const z2mModels_1 = require("../../z2mModels");
const monitor_1 = require("../monitor");
const helpers_1 = require("../../helpers");
const hap_1 = require("../../hap");
const basic_1 = require("./basic");
class HumiditySensorHandler extends basic_1.BasicSensorHandler {
    constructor(expose, allExposes, accessory) {
        super(accessory, expose, allExposes, HumiditySensorHandler.generateIdentifier, (n, t) => new hap_1.hap.Service.HumiditySensor(n, t));
        accessory.log.debug(`Configuring HumiditySensor for ${this.serviceName}`);
        const characteristic = (0, helpers_1.getOrAddCharacteristic)(this.service, hap_1.hap.Characteristic.CurrentRelativeHumidity);
        (0, helpers_1.copyExposesRangeToCharacteristic)(expose, characteristic);
        this.monitors.push(new monitor_1.PassthroughCharacteristicMonitor(expose.property, this.service, hap_1.hap.Characteristic.CurrentRelativeHumidity));
    }
    static generateIdentifier(endpoint) {
        let identifier = hap_1.hap.Service.HumiditySensor.UUID;
        if (endpoint !== undefined) {
            identifier += '_' + endpoint.trim();
        }
        return identifier;
    }
}
exports.HumiditySensorHandler = HumiditySensorHandler;
HumiditySensorHandler.exposesName = 'humidity';
HumiditySensorHandler.exposesType = z2mModels_1.ExposesKnownTypes.NUMERIC;
//# sourceMappingURL=humidity.js.map