"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OccupancySensorHandler = void 0;
const hap_1 = require("../../hap");
const binary_1 = require("./binary");
class OccupancySensorHandler extends binary_1.ConfigurableBinarySensorHandler {
    constructor(expose, otherExposes, accessory) {
        super(accessory, expose, otherExposes, OccupancySensorHandler.generateIdentifier, 'OccupancySensor', OccupancySensorHandler.converterConfigTag, OccupancySensorHandler.defaultType, OccupancySensorHandler.getTypeDefinitions());
    }
    static isValidConverterConfiguration(config, tag, logger) {
        if (!(0, binary_1.isBinarySensorConfig)(config)) {
            return false;
        }
        if (config.type !== undefined && !OccupancySensorHandler.getTypeDefinitions().has(config.type)) {
            logger === null || logger === void 0 ? void 0 : logger.error(`Invalid type chosen for ${tag} converter: ${config.type}`);
            return false;
        }
        return true;
    }
    static getTypeDefinitions() {
        return new Map([
            [OccupancySensorHandler.defaultType, new binary_1.BinarySensorTypeDefinition((n, t) => new hap_1.hap.Service.OccupancySensor(n, t), hap_1.hap.Characteristic.OccupancyDetected, hap_1.hap.Characteristic.OccupancyDetected.OCCUPANCY_DETECTED, hap_1.hap.Characteristic.OccupancyDetected.OCCUPANCY_NOT_DETECTED)],
            [OccupancySensorHandler.typeMotion, new binary_1.BinarySensorTypeDefinition((n, t) => new hap_1.hap.Service.MotionSensor(n, t), hap_1.hap.Characteristic.MotionDetected, true, false, 'occupancy')],
        ]);
    }
    static generateIdentifier(endpoint, accessory) {
        const config = accessory.getConverterConfiguration(OccupancySensorHandler.converterConfigTag);
        let identifier = ((0, binary_1.isBinarySensorConfig)(config) && config.type === OccupancySensorHandler.typeMotion) ?
            `${OccupancySensorHandler.converterConfigTag}_${hap_1.hap.Service.MotionSensor.UUID}` : hap_1.hap.Service.OccupancySensor.UUID;
        if (endpoint !== undefined) {
            identifier += '_' + endpoint.trim();
        }
        return identifier;
    }
}
exports.OccupancySensorHandler = OccupancySensorHandler;
OccupancySensorHandler.exposesName = 'occupancy';
OccupancySensorHandler.converterConfigTag = 'occupancy';
OccupancySensorHandler.defaultType = 'occupancy';
OccupancySensorHandler.typeMotion = 'motion';
//# sourceMappingURL=occupancy.js.map