"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PresenceSensorHandler = void 0;
const hap_1 = require("../../hap");
const binary_1 = require("./binary");
class PresenceSensorHandler extends binary_1.BinarySensorHandler {
    constructor(expose, otherExposes, accessory) {
        super(accessory, expose, otherExposes, PresenceSensorHandler.generateIdentifier, 'Occupancy Sensor (presence)', (n, t) => new hap_1.hap.Service.OccupancySensor(n, (PresenceSensorHandler.exposesName + ' ' + (t !== null && t !== void 0 ? t : '')).trim()), hap_1.hap.Characteristic.OccupancyDetected, hap_1.hap.Characteristic.OccupancyDetected.OCCUPANCY_DETECTED, hap_1.hap.Characteristic.OccupancyDetected.OCCUPANCY_NOT_DETECTED);
    }
    static generateIdentifier(endpoint) {
        let identifier = PresenceSensorHandler.exposesName + '_' + hap_1.hap.Service.OccupancySensor.UUID;
        if (endpoint !== undefined) {
            identifier += '_' + endpoint.trim();
        }
        return identifier;
    }
}
exports.PresenceSensorHandler = PresenceSensorHandler;
PresenceSensorHandler.exposesName = 'presence';
//# sourceMappingURL=presence.js.map