/*
 * include/asm-arm/arch-stmp3xxx/regsemi_linux.h
 *
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __ARCH_REGS_LRADC_H
#define __ARCH_REGS_LRADC_H

#ifndef REGS_LRADC_BASE
#define REGS_LRADC_BASE (REGS_BASE + 0x00050000)
#endif

HW_REGISTER(HW_LRADC_CTRL0, REGS_LRADC_BASE, 0x00)
#define BP_LRADC_CTRL0_SCHEDULE		0
#define BM_LRADC_CTRL0_SCHEDULE		0x000000FF
#define BF_LRADC_CTRL0_SCHEDULE(v)	(((v) << BP_LRADC_CTRL0_SCHEDULE) & BM_LRADC_CTRL0_SCHEDULE)
#define BM_LRADC_CTRL0_TOUCH_DETECT_ENABLE     0x00100000
#define BM_LRADC_CTRL0_YMINUS_ENABLE           0x00080000
#define BM_LRADC_CTRL0_XMINUS_ENABLE           0x00040000
#define BM_LRADC_CTRL0_YPLUS_ENABLE            0x00020000
#define BM_LRADC_CTRL0_XPLUS_ENABLE            0x00010000
#define BP_LRADC_CTRL0_ONCHIP_GROUNDREF	21
#define BM_LRADC_CTRL0_ONCHIP_GROUNDREF	0x00200000
#define BP_LRADC_CTRL0_CLKGATE		30
#define BM_LRADC_CTRL0_CLKGATE		0x40000000
#define BP_LRADC_CTRL0_SFTRST		31
#define BM_LRADC_CTRL0_SFTRST		0x80000000

HW_REGISTER(HW_LRADC_CTRL1, REGS_LRADC_BASE, 0x10)
#define BM_LRADC_CTRL1_TOUCH_DETECT_IRQ_EN	0x01000000
#define BM_LRADC_CTRL1_LRADC7_IRQ_EN      0x00800000
#define BM_LRADC_CTRL1_LRADC6_IRQ_EN      0x00400000
#define BM_LRADC_CTRL1_LRADC5_IRQ_EN	0x00200000
#define BM_LRADC_CTRL1_LRADC0_IRQ_EN	0x00010000
#define BP_LRADC_CTRL1_LRADC0_IRQ_EN	16
#define BM_LRADC_CTRL1_TOUCH_DETECT_IRQ	0x00000100
#define BM_LRADC_CTRL1_LRADC7_IRQ      0x00000080
#define BM_LRADC_CTRL1_LRADC6_IRQ	0x00000040
#define BP_LRADC_CTRL1_LRADC6_IRQ	6
#define BM_LRADC_CTRL1_LRADC5_IRQ	0x00000020
#define BM_LRADC_CTRL1_LRADC0_IRQ	0x00000001
#define BP_LRADC_CTRL1_LRADC0_IRQ	0

HW_REGISTER(HW_LRADC_CTRL2, REGS_LRADC_BASE, 0x20)
#define BP_LRADC_CTRL2_DIVIDE_BY_TWO	24
#define BM_LRADC_CTRL2_DIVIDE_BY_TWO	0xFF000000
#define BF_LRADC_CTRL2_DIVIDE_BY_TWO(v)	(((v) << BP_LRADC_CTRL2_DIVIDE_BY_TWO) & BM_LRADC_CTRL2_DIVIDE_BY_TWO)
#define BM_LRADC_CTRL2_BL_AMP_BYPASS	0x00800000
#define BM_LRADC_CTRL2_BL_ENABLE	0x00400000
#define BM_LRADC_CTRL2_BL_MUX_SELECT	0x00200000
#define BM_LRADC_CTRL2_BL_BRIGHTNESS	0x001f0000
#define BP_LRADC_CTRL2_BL_BRIGHTNESS	16
#define BF_LRADC_CTRL2_BL_BRIGHTNESS(v)	\
		(((v) << BP_LRADC_CTRL2_BL_BRIGHTNESS) & \
		BM_LRADC_CTRL2_BL_BRIGHTNESS)
#define BM_LRADC_CTRL2_TEMPSENSE_PWD	0x00008000

HW_REGISTER(HW_LRADC_CTRL3, REGS_LRADC_BASE, 0x30)
#define BP_LRADC_CTRL3_CYCLE_TIME	8
#define BM_LRADC_CTRL3_CYCLE_TIME	0x00000300
#define BF_LRADC_CTRL3_CYCLE_TIME(v)	(((v) << BP_LRADC_CTRL3_CYCLE_TIME) & BM_LRADC_CTRL3_CYCLE_TIME)

HW_REGISTER_RO(HW_LRADC_STATUS, REGS_LRADC_BASE, 0x40)
#define BM_LRADC_STATUS_TOUCH_DETECT_RAW 0x00000001

HW_REGISTER_INDEXED(HW_LRADC_CHn, REGS_LRADC_BASE, 0x50, 0x10)
#define BP_LRADC_CHn_NUM_SAMPLES	24
#define BM_LRADC_CHn_NUM_SAMPLES	0x1F000000
#define BF_LRADC_CHn_NUM_SAMPLES(v)	(((v) << BP_LRADC_CHn_NUM_SAMPLES) & BM_LRADC_CHn_NUM_SAMPLES)
#define BP_LRADC_CHn_ACCUMULATE		29
#define BM_LRADC_CHn_ACCUMULATE		0x20000000
#define BP_LRADC_CHn_VALUE		0
#define BM_LRADC_CHn_VALUE		0x0003FFFF
#define BF_LRADC_CHn_VALUE(v)		(((v) << BP_LRADC_CHn_VALUE) & BM_LRADC_CHn_VALUE)

HW_REGISTER_INDEXED(HW_LRADC_DELAYn, REGS_LRADC_BASE, 0xD0, 0x10)
#define BP_LRADC_DELAYn_DELAY		0
#define BM_LRADC_DELAYn_DELAY		0x000007FF
#define BF_LRADC_DELAYn_DELAY(v)	(((v) << BP_LRADC_DELAYn_DELAY) & BM_LRADC_DELAYn_DELAY)
#define BP_LRADC_DELAYn_LOOP_COUNT      11
#define BM_LRADC_DELAYn_LOOP_COUNT      0x0000F800
#define BF_LRADC_DELAYn_LOOP_COUNT(v)   (((v) << BP_LRADC_DELAYn_LOOP_COUNT) & BM_LRADC_DELAYn_LOOP_COUNT)
#define BP_LRADC_DELAYn_TRIGGER_DELAYS	16
#define BM_LRADC_DELAYn_TRIGGER_DELAYS	0x000F0000
#define BF_LRADC_DELAYn_TRIGGER_DELAYS(v)	(((v) << BP_LRADC_DELAYn_TRIGGER_DELAYS) & BM_LRADC_DELAYn_TRIGGER_DELAYS)
#define BP_LRADC_DELAYn_KICK		20
#define BM_LRADC_DELAYn_KICK		0x00100000
#define BP_LRADC_DELAYn_TRIGGER_LRADCS	24
#define BM_LRADC_DELAYn_TRIGGER_LRADCS	0xFF000000
#define BF_LRADC_DELAYn_TRIGGER_LRADCS(v)	(((v) << BP_LRADC_DELAYn_TRIGGER_LRADCS) & BM_LRADC_DELAYn_TRIGGER_LRADCS)


HW_REGISTER_RO(HW_LRADC_DEBUG0, REGS_LRADC_BASE, 0x110)
HW_REGISTER(HW_LRADC_DEBUG1, REGS_LRADC_BASE, 0x120)
HW_REGISTER(HW_LRADC_CONVERSION, REGS_LRADC_BASE, 0x130)
#define BM_LRADC_CONVERSION_AUTOMATIC      0x00100000
#define BP_LRADC_CONVERSION_SCALE_FACTOR      16
#define BM_LRADC_CONVERSION_SCALE_FACTOR      0x00030000
#define BF_LRADC_CONVERSION_SCALE_FACTOR(v)   (((v) << BP_LRADC_CONVERSION_SCALE_FACTOR) & BM_LRADC_CONVERSION_SCALE_FACTOR)
#define BM_LRADC_CONVERSION_SCALED_BATT_VOLTAGE      0x000003FF
HW_REGISTER(HW_LRADC_CTRL4, REGS_LRADC_BASE, 0x140)
#define BP_LRADC_CTRL4_LRADC7SELECT	28
#define BM_LRADC_CTRL4_LRADC7SELECT	0xF0000000
#define BF_LRADC_CTRL4_LRADC7SELECT(v)	(((v) << BP_LRADC_CTRL4_LRADC7SELECT) & BM_LRADC_CTRL4_LRADC7SELECT)
#define BP_LRADC_CTRL4_LRADC6SELECT	24
#define BM_LRADC_CTRL4_LRADC6SELECT	0x0F000000
#define BF_LRADC_CTRL4_LRADC6SELECT(v)	(((v) << BP_LRADC_CTRL4_LRADC6SELECT) & BM_LRADC_CTRL4_LRADC6SELECT)
#define BP_LRADC_CTRL4_LRADC5SELECT	20
#define BM_LRADC_CTRL4_LRADC5SELECT	0x00F00000
#define BF_LRADC_CTRL4_LRADC5SELECT(v)	(((v) << BP_LRADC_CTRL4_LRADC5SELECT) & BM_LRADC_CTRL4_LRADC5SELECT)
#define BP_LRADC_CTRL4_LRADC4SELECT	16
#define BM_LRADC_CTRL4_LRADC4SELECT	0x000F0000
#define BF_LRADC_CTRL4_LRADC4SELECT(v)	(((v) << BP_LRADC_CTRL4_LRADC4SELECT) & BM_LRADC_CTRL4_LRADC4SELECT)
#define BP_LRADC_CTRL4_LRADC3SELECT	12
#define BM_LRADC_CTRL4_LRADC3SELECT	0x0000F000
#define BF_LRADC_CTRL4_LRADC3SELECT(v)	(((v) << BP_LRADC_CTRL4_LRADC3SELECT) & BM_LRADC_CTRL4_LRADC3SELECT)
#define BP_LRADC_CTRL4_LRADC2SELECT	8
#define BM_LRADC_CTRL4_LRADC2SELECT	0x00000F00
#define BF_LRADC_CTRL4_LRADC2SELECT(v)	(((v) << BP_LRADC_CTRL4_LRADC2SELECT) & BM_LRADC_CTRL4_LRADC2SELECT)
#define BP_LRADC_CTRL4_LRADC1SELECT	4
#define BM_LRADC_CTRL4_LRADC1SELECT	0x000000F0
#define BF_LRADC_CTRL4_LRADC1SELECT(v)	(((v) << BP_LRADC_CTRL4_LRADC1SELECT) & BM_LRADC_CTRL4_LRADC1SELECT)
#define BP_LRADC_CTRL4_LRADC0SELECT	0
#define BM_LRADC_CTRL4_LRADC0SELECT	0x0000000F
#define BF_LRADC_CTRL4_LRADC0SELECT(v)	(((v) << BP_LRADC_CTRL4_LRADC0SELECT) & BM_LRADC_CTRL4_LRADC0SELECT)

HW_REGISTER_RO(HW_LRADC_VERSION, REGS_LRADC_BASE, 0x150)
#endif /* __ARCH_REGS_LRADC_H */
