/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSCLKCTRL_H
#define _REGSCLKCTRL_H  1

#include "regs.h"

#ifndef REGS_CLKCTRL_BASE
#define REGS_CLKCTRL_BASE (REGS_BASE + 0x00040000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_PLLCTRL0 - PLL Control Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  RSRVD1;
        unsigned POWER        :  1;
        unsigned RSRVD2       :  1;
        unsigned EN_USB_CLKS  :  1;
        unsigned RSRVD3       :  1;
        unsigned DIV_SEL      :  2;
        unsigned RSRVD4       :  2;
        unsigned CP_SEL       :  2;
        unsigned RSRVD5       :  2;
        unsigned LFR_SEL      :  2;
        unsigned RSRVD6       :  2;
    } B;
} hw_clkctrl_pllctrl0_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_PLLCTRL0 register
//

#define HW_CLKCTRL_PLLCTRL0_ADDR      (REGS_CLKCTRL_BASE + 0x00000000)
#define HW_CLKCTRL_PLLCTRL0_SET_ADDR  (REGS_CLKCTRL_BASE + 0x00000004)
#define HW_CLKCTRL_PLLCTRL0_CLR_ADDR  (REGS_CLKCTRL_BASE + 0x00000008)
#define HW_CLKCTRL_PLLCTRL0_TOG_ADDR  (REGS_CLKCTRL_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_PLLCTRL0           (*(volatile hw_clkctrl_pllctrl0_t *) HW_CLKCTRL_PLLCTRL0_ADDR)
#define HW_CLKCTRL_PLLCTRL0_RD()      (HW_CLKCTRL_PLLCTRL0.U)
#define HW_CLKCTRL_PLLCTRL0_WR(v)     (HW_CLKCTRL_PLLCTRL0.U = (v))
#define HW_CLKCTRL_PLLCTRL0_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_PLLCTRL0_SET_ADDR) = (v))
#define HW_CLKCTRL_PLLCTRL0_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_PLLCTRL0_CLR_ADDR) = (v))
#define HW_CLKCTRL_PLLCTRL0_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_PLLCTRL0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_CLKCTRL_PLLCTRL0 bitfields
//

//--- Register HW_CLKCTRL_PLLCTRL0, field LFR_SEL

#define BP_CLKCTRL_PLLCTRL0_LFR_SEL      28
#define BM_CLKCTRL_PLLCTRL0_LFR_SEL      0x30000000

#define BF_CLKCTRL_PLLCTRL0_LFR_SEL(v)   (((v) << 28) & BM_CLKCTRL_PLLCTRL0_LFR_SEL)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLLCTRL0_LFR_SEL(v)   BF_CS1(CLKCTRL_PLLCTRL0, LFR_SEL, v)
#endif

#define BV_CLKCTRL_PLLCTRL0_LFR_SEL__DEFAULT    0x0
#define BV_CLKCTRL_PLLCTRL0_LFR_SEL__TIMES_2    0x1
#define BV_CLKCTRL_PLLCTRL0_LFR_SEL__TIMES_05   0x2
#define BV_CLKCTRL_PLLCTRL0_LFR_SEL__UNDEFINED  0x3

//--- Register HW_CLKCTRL_PLLCTRL0, field CP_SEL

#define BP_CLKCTRL_PLLCTRL0_CP_SEL      24
#define BM_CLKCTRL_PLLCTRL0_CP_SEL      0x03000000

#define BF_CLKCTRL_PLLCTRL0_CP_SEL(v)   (((v) << 24) & BM_CLKCTRL_PLLCTRL0_CP_SEL)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLLCTRL0_CP_SEL(v)   BF_CS1(CLKCTRL_PLLCTRL0, CP_SEL, v)
#endif

#define BV_CLKCTRL_PLLCTRL0_CP_SEL__DEFAULT    0x0
#define BV_CLKCTRL_PLLCTRL0_CP_SEL__TIMES_2    0x1
#define BV_CLKCTRL_PLLCTRL0_CP_SEL__TIMES_05   0x2
#define BV_CLKCTRL_PLLCTRL0_CP_SEL__UNDEFINED  0x3

//--- Register HW_CLKCTRL_PLLCTRL0, field DIV_SEL

#define BP_CLKCTRL_PLLCTRL0_DIV_SEL      20
#define BM_CLKCTRL_PLLCTRL0_DIV_SEL      0x00300000

#define BF_CLKCTRL_PLLCTRL0_DIV_SEL(v)   (((v) << 20) & BM_CLKCTRL_PLLCTRL0_DIV_SEL)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLLCTRL0_DIV_SEL(v)   BF_CS1(CLKCTRL_PLLCTRL0, DIV_SEL, v)
#endif

#define BV_CLKCTRL_PLLCTRL0_DIV_SEL__DEFAULT    0x0
#define BV_CLKCTRL_PLLCTRL0_DIV_SEL__LOWER      0x1
#define BV_CLKCTRL_PLLCTRL0_DIV_SEL__LOWEST     0x2
#define BV_CLKCTRL_PLLCTRL0_DIV_SEL__UNDEFINED  0x3

//--- Register HW_CLKCTRL_PLLCTRL0, field EN_USB_CLKS

#define BP_CLKCTRL_PLLCTRL0_EN_USB_CLKS      18
#define BM_CLKCTRL_PLLCTRL0_EN_USB_CLKS      0x00040000

#define BF_CLKCTRL_PLLCTRL0_EN_USB_CLKS(v)   (((v) << 18) & BM_CLKCTRL_PLLCTRL0_EN_USB_CLKS)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLLCTRL0_EN_USB_CLKS(v)   BF_CS1(CLKCTRL_PLLCTRL0, EN_USB_CLKS, v)
#endif

//--- Register HW_CLKCTRL_PLLCTRL0, field POWER

#define BP_CLKCTRL_PLLCTRL0_POWER      16
#define BM_CLKCTRL_PLLCTRL0_POWER      0x00010000

#define BF_CLKCTRL_PLLCTRL0_POWER(v)   (((v) << 16) & BM_CLKCTRL_PLLCTRL0_POWER)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLLCTRL0_POWER(v)   BF_CS1(CLKCTRL_PLLCTRL0, POWER, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_PLLCTRL1 - PLL Control Register 1 - RESERVED
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  LOCK_COUNT;
        unsigned RSRVD1      : 14;
        unsigned FORCE_LOCK  :  1;
        unsigned LOCK        :  1;
    } B;
} hw_clkctrl_pllctrl1_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_PLLCTRL1 register
//

#define HW_CLKCTRL_PLLCTRL1_ADDR      (REGS_CLKCTRL_BASE + 0x00000010)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_PLLCTRL1           (*(volatile hw_clkctrl_pllctrl1_t *) HW_CLKCTRL_PLLCTRL1_ADDR)
#define HW_CLKCTRL_PLLCTRL1_RD()      (HW_CLKCTRL_PLLCTRL1.U)
#define HW_CLKCTRL_PLLCTRL1_WR(v)     (HW_CLKCTRL_PLLCTRL1.U = (v))
#define HW_CLKCTRL_PLLCTRL1_SET(v)    (HW_CLKCTRL_PLLCTRL1_WR(HW_CLKCTRL_PLLCTRL1_RD() |  (v)))
#define HW_CLKCTRL_PLLCTRL1_CLR(v)    (HW_CLKCTRL_PLLCTRL1_WR(HW_CLKCTRL_PLLCTRL1_RD() & ~(v)))
#define HW_CLKCTRL_PLLCTRL1_TOG(v)    (HW_CLKCTRL_PLLCTRL1_WR(HW_CLKCTRL_PLLCTRL1_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_CLKCTRL_PLLCTRL1 bitfields
//

//--- Register HW_CLKCTRL_PLLCTRL1, field LOCK

#define BP_CLKCTRL_PLLCTRL1_LOCK      31
#define BM_CLKCTRL_PLLCTRL1_LOCK      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_PLLCTRL1_LOCK(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_PLLCTRL1_LOCK)
#else
#define BF_CLKCTRL_PLLCTRL1_LOCK(v)   (((v) << 31) & BM_CLKCTRL_PLLCTRL1_LOCK)
#endif

//--- Register HW_CLKCTRL_PLLCTRL1, field FORCE_LOCK

#define BP_CLKCTRL_PLLCTRL1_FORCE_LOCK      30
#define BM_CLKCTRL_PLLCTRL1_FORCE_LOCK      0x40000000

#define BF_CLKCTRL_PLLCTRL1_FORCE_LOCK(v)   (((v) << 30) & BM_CLKCTRL_PLLCTRL1_FORCE_LOCK)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLLCTRL1_FORCE_LOCK(v)   BF_CS1(CLKCTRL_PLLCTRL1, FORCE_LOCK, v)
#endif

//--- Register HW_CLKCTRL_PLLCTRL1, field LOCK_COUNT

#define BP_CLKCTRL_PLLCTRL1_LOCK_COUNT      0
#define BM_CLKCTRL_PLLCTRL1_LOCK_COUNT      0x0000FFFF

#define BF_CLKCTRL_PLLCTRL1_LOCK_COUNT(v)   (((v) << 0) & BM_CLKCTRL_PLLCTRL1_LOCK_COUNT)


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_CPU - CPU Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV_CPU           :  6;
        unsigned RSRVD1            :  4;
        unsigned DIV_CPU_FRAC_EN   :  1;
        unsigned RSRVD2            :  1;
        unsigned INTERRUPT_WAIT    :  1;
        unsigned RSRVD3            :  3;
        unsigned DIV_XTAL          : 10;
        unsigned DIV_XTAL_FRAC_EN  :  1;
        unsigned RSRVD4            :  1;
        unsigned BUSY_REF_CPU      :  1;
        unsigned BUSY_REF_XTAL     :  1;
        unsigned RSRVD5            :  2;
    } B;
} hw_clkctrl_cpu_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_CPU register
//

#define HW_CLKCTRL_CPU_ADDR      (REGS_CLKCTRL_BASE + 0x00000020)
#define HW_CLKCTRL_CPU_SET_ADDR  (REGS_CLKCTRL_BASE + 0x00000024)
#define HW_CLKCTRL_CPU_CLR_ADDR  (REGS_CLKCTRL_BASE + 0x00000028)
#define HW_CLKCTRL_CPU_TOG_ADDR  (REGS_CLKCTRL_BASE + 0x0000002C)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_CPU           (*(volatile hw_clkctrl_cpu_t *) HW_CLKCTRL_CPU_ADDR)
#define HW_CLKCTRL_CPU_RD()      (HW_CLKCTRL_CPU.U)
#define HW_CLKCTRL_CPU_WR(v)     (HW_CLKCTRL_CPU.U = (v))
#define HW_CLKCTRL_CPU_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_CPU_SET_ADDR) = (v))
#define HW_CLKCTRL_CPU_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_CPU_CLR_ADDR) = (v))
#define HW_CLKCTRL_CPU_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_CPU_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_CLKCTRL_CPU bitfields
//

//--- Register HW_CLKCTRL_CPU, field BUSY_REF_XTAL

#define BP_CLKCTRL_CPU_BUSY_REF_XTAL      29
#define BM_CLKCTRL_CPU_BUSY_REF_XTAL      0x20000000

#define BF_CLKCTRL_CPU_BUSY_REF_XTAL(v)   (((v) << 29) & BM_CLKCTRL_CPU_BUSY_REF_XTAL)

//--- Register HW_CLKCTRL_CPU, field BUSY_REF_CPU

#define BP_CLKCTRL_CPU_BUSY_REF_CPU      28
#define BM_CLKCTRL_CPU_BUSY_REF_CPU      0x10000000

#define BF_CLKCTRL_CPU_BUSY_REF_CPU(v)   (((v) << 28) & BM_CLKCTRL_CPU_BUSY_REF_CPU)

//--- Register HW_CLKCTRL_CPU, field DIV_XTAL_FRAC_EN

#define BP_CLKCTRL_CPU_DIV_XTAL_FRAC_EN      26
#define BM_CLKCTRL_CPU_DIV_XTAL_FRAC_EN      0x04000000

#define BF_CLKCTRL_CPU_DIV_XTAL_FRAC_EN(v)   (((v) << 26) & BM_CLKCTRL_CPU_DIV_XTAL_FRAC_EN)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CPU_DIV_XTAL_FRAC_EN(v)   BF_CS1(CLKCTRL_CPU, DIV_XTAL_FRAC_EN, v)
#endif

//--- Register HW_CLKCTRL_CPU, field DIV_XTAL

#define BP_CLKCTRL_CPU_DIV_XTAL      16
#define BM_CLKCTRL_CPU_DIV_XTAL      0x03FF0000

#define BF_CLKCTRL_CPU_DIV_XTAL(v)   (((v) << 16) & BM_CLKCTRL_CPU_DIV_XTAL)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CPU_DIV_XTAL(v)   BF_CS1(CLKCTRL_CPU, DIV_XTAL, v)
#endif

//--- Register HW_CLKCTRL_CPU, field INTERRUPT_WAIT

#define BP_CLKCTRL_CPU_INTERRUPT_WAIT      12
#define BM_CLKCTRL_CPU_INTERRUPT_WAIT      0x00001000

#define BF_CLKCTRL_CPU_INTERRUPT_WAIT(v)   (((v) << 12) & BM_CLKCTRL_CPU_INTERRUPT_WAIT)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CPU_INTERRUPT_WAIT(v)   BF_CS1(CLKCTRL_CPU, INTERRUPT_WAIT, v)
#endif

//--- Register HW_CLKCTRL_CPU, field DIV_CPU_FRAC_EN

#define BP_CLKCTRL_CPU_DIV_CPU_FRAC_EN      10
#define BM_CLKCTRL_CPU_DIV_CPU_FRAC_EN      0x00000400

#define BF_CLKCTRL_CPU_DIV_CPU_FRAC_EN(v)   (((v) << 10) & BM_CLKCTRL_CPU_DIV_CPU_FRAC_EN)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CPU_DIV_CPU_FRAC_EN(v)   BF_CS1(CLKCTRL_CPU, DIV_CPU_FRAC_EN, v)
#endif

//--- Register HW_CLKCTRL_CPU, field DIV_CPU

#define BP_CLKCTRL_CPU_DIV_CPU      0
#define BM_CLKCTRL_CPU_DIV_CPU      0x0000003F

#define BF_CLKCTRL_CPU_DIV_CPU(v)   (((v) << 0) & BM_CLKCTRL_CPU_DIV_CPU)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CPU_DIV_CPU(v)   BF_CS1(CLKCTRL_CPU, DIV_CPU, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_HBUS - AHB, APBH Bus Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV                    :  5;
        unsigned DIV_FRAC_EN            :  1;
        unsigned RSRVD1                 : 10;
        unsigned SLOW_DIV               :  3;
        unsigned RSRVD2                 :  1;
        unsigned AUTO_SLOW_MODE         :  1;
        unsigned CPU_INSTR_AS_ENABLE    :  1;
        unsigned CPU_DATA_AS_ENABLE     :  1;
        unsigned TRAFFIC_AS_ENABLE      :  1;
        unsigned TRAFFIC_JAM_AS_ENABLE  :  1;
        unsigned APBXDMA_AS_ENABLE      :  1;
        unsigned APBHDMA_AS_ENABLE      :  1;
        unsigned PXP_AS_ENABLE          :  1;
        unsigned DCP_AS_ENABLE          :  1;
        unsigned BUSY                   :  1;
        unsigned RSRVD4                 :  2;
    } B;
} hw_clkctrl_hbus_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_HBUS register
//

#define HW_CLKCTRL_HBUS_ADDR      (REGS_CLKCTRL_BASE + 0x00000030)
#define HW_CLKCTRL_HBUS_SET_ADDR  (REGS_CLKCTRL_BASE + 0x00000034)
#define HW_CLKCTRL_HBUS_CLR_ADDR  (REGS_CLKCTRL_BASE + 0x00000038)
#define HW_CLKCTRL_HBUS_TOG_ADDR  (REGS_CLKCTRL_BASE + 0x0000003C)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_HBUS           (*(volatile hw_clkctrl_hbus_t *) HW_CLKCTRL_HBUS_ADDR)
#define HW_CLKCTRL_HBUS_RD()      (HW_CLKCTRL_HBUS.U)
#define HW_CLKCTRL_HBUS_WR(v)     (HW_CLKCTRL_HBUS.U = (v))
#define HW_CLKCTRL_HBUS_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_HBUS_SET_ADDR) = (v))
#define HW_CLKCTRL_HBUS_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_HBUS_CLR_ADDR) = (v))
#define HW_CLKCTRL_HBUS_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_HBUS_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_CLKCTRL_HBUS bitfields
//

//--- Register HW_CLKCTRL_HBUS, field BUSY

#define BP_CLKCTRL_HBUS_BUSY      29
#define BM_CLKCTRL_HBUS_BUSY      0x20000000

#define BF_CLKCTRL_HBUS_BUSY(v)   (((v) << 29) & BM_CLKCTRL_HBUS_BUSY)

//--- Register HW_CLKCTRL_HBUS, field DCP_AS_ENABLE

#define BP_CLKCTRL_HBUS_DCP_AS_ENABLE      28
#define BM_CLKCTRL_HBUS_DCP_AS_ENABLE      0x10000000

#define BF_CLKCTRL_HBUS_DCP_AS_ENABLE(v)   (((v) << 28) & BM_CLKCTRL_HBUS_DCP_AS_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_DCP_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, DCP_AS_ENABLE, v)
#endif

//--- Register HW_CLKCTRL_HBUS, field PXP_AS_ENABLE

#define BP_CLKCTRL_HBUS_PXP_AS_ENABLE      27
#define BM_CLKCTRL_HBUS_PXP_AS_ENABLE      0x08000000

#define BF_CLKCTRL_HBUS_PXP_AS_ENABLE(v)   (((v) << 27) & BM_CLKCTRL_HBUS_PXP_AS_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_PXP_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, PXP_AS_ENABLE, v)
#endif

//--- Register HW_CLKCTRL_HBUS, field APBHDMA_AS_ENABLE

#define BP_CLKCTRL_HBUS_APBHDMA_AS_ENABLE      26
#define BM_CLKCTRL_HBUS_APBHDMA_AS_ENABLE      0x04000000

#define BF_CLKCTRL_HBUS_APBHDMA_AS_ENABLE(v)   (((v) << 26) & BM_CLKCTRL_HBUS_APBHDMA_AS_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_APBHDMA_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, APBHDMA_AS_ENABLE, v)
#endif

//--- Register HW_CLKCTRL_HBUS, field APBXDMA_AS_ENABLE

#define BP_CLKCTRL_HBUS_APBXDMA_AS_ENABLE      25
#define BM_CLKCTRL_HBUS_APBXDMA_AS_ENABLE      0x02000000

#define BF_CLKCTRL_HBUS_APBXDMA_AS_ENABLE(v)   (((v) << 25) & BM_CLKCTRL_HBUS_APBXDMA_AS_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_APBXDMA_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, APBXDMA_AS_ENABLE, v)
#endif

//--- Register HW_CLKCTRL_HBUS, field TRAFFIC_JAM_AS_ENABLE

#define BP_CLKCTRL_HBUS_TRAFFIC_JAM_AS_ENABLE      24
#define BM_CLKCTRL_HBUS_TRAFFIC_JAM_AS_ENABLE      0x01000000

#define BF_CLKCTRL_HBUS_TRAFFIC_JAM_AS_ENABLE(v)   (((v) << 24) & BM_CLKCTRL_HBUS_TRAFFIC_JAM_AS_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_TRAFFIC_JAM_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, TRAFFIC_JAM_AS_ENABLE, v)
#endif

//--- Register HW_CLKCTRL_HBUS, field TRAFFIC_AS_ENABLE

#define BP_CLKCTRL_HBUS_TRAFFIC_AS_ENABLE      23
#define BM_CLKCTRL_HBUS_TRAFFIC_AS_ENABLE      0x00800000

#define BF_CLKCTRL_HBUS_TRAFFIC_AS_ENABLE(v)   (((v) << 23) & BM_CLKCTRL_HBUS_TRAFFIC_AS_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_TRAFFIC_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, TRAFFIC_AS_ENABLE, v)
#endif

//--- Register HW_CLKCTRL_HBUS, field CPU_DATA_AS_ENABLE

#define BP_CLKCTRL_HBUS_CPU_DATA_AS_ENABLE      22
#define BM_CLKCTRL_HBUS_CPU_DATA_AS_ENABLE      0x00400000

#define BF_CLKCTRL_HBUS_CPU_DATA_AS_ENABLE(v)   (((v) << 22) & BM_CLKCTRL_HBUS_CPU_DATA_AS_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_CPU_DATA_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, CPU_DATA_AS_ENABLE, v)
#endif

//--- Register HW_CLKCTRL_HBUS, field CPU_INSTR_AS_ENABLE

#define BP_CLKCTRL_HBUS_CPU_INSTR_AS_ENABLE      21
#define BM_CLKCTRL_HBUS_CPU_INSTR_AS_ENABLE      0x00200000

#define BF_CLKCTRL_HBUS_CPU_INSTR_AS_ENABLE(v)   (((v) << 21) & BM_CLKCTRL_HBUS_CPU_INSTR_AS_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_CPU_INSTR_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, CPU_INSTR_AS_ENABLE, v)
#endif

//--- Register HW_CLKCTRL_HBUS, field AUTO_SLOW_MODE

#define BP_CLKCTRL_HBUS_AUTO_SLOW_MODE      20
#define BM_CLKCTRL_HBUS_AUTO_SLOW_MODE      0x00100000

#define BF_CLKCTRL_HBUS_AUTO_SLOW_MODE(v)   (((v) << 20) & BM_CLKCTRL_HBUS_AUTO_SLOW_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_AUTO_SLOW_MODE(v)   BF_CS1(CLKCTRL_HBUS, AUTO_SLOW_MODE, v)
#endif

//--- Register HW_CLKCTRL_HBUS, field SLOW_DIV

#define BP_CLKCTRL_HBUS_SLOW_DIV      16
#define BM_CLKCTRL_HBUS_SLOW_DIV      0x00070000

#define BF_CLKCTRL_HBUS_SLOW_DIV(v)   (((v) << 16) & BM_CLKCTRL_HBUS_SLOW_DIV)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_SLOW_DIV(v)   BF_CS1(CLKCTRL_HBUS, SLOW_DIV, v)
#endif

#define BV_CLKCTRL_HBUS_SLOW_DIV__BY1   0x0
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY2   0x1
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY4   0x2
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY8   0x3
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY16  0x4
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY32  0x5

//--- Register HW_CLKCTRL_HBUS, field DIV_FRAC_EN

#define BP_CLKCTRL_HBUS_DIV_FRAC_EN      5
#define BM_CLKCTRL_HBUS_DIV_FRAC_EN      0x00000020

#define BF_CLKCTRL_HBUS_DIV_FRAC_EN(v)   (((v) << 5) & BM_CLKCTRL_HBUS_DIV_FRAC_EN)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_HBUS, DIV_FRAC_EN, v)
#endif

//--- Register HW_CLKCTRL_HBUS, field DIV

#define BP_CLKCTRL_HBUS_DIV      0
#define BM_CLKCTRL_HBUS_DIV      0x0000001F

#define BF_CLKCTRL_HBUS_DIV(v)   (((v) << 0) & BM_CLKCTRL_HBUS_DIV)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_DIV(v)   BF_CS1(CLKCTRL_HBUS, DIV, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_XBUS - APBX Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV          : 10;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 20;
        unsigned BUSY         :  1;
    } B;
} hw_clkctrl_xbus_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_XBUS register
//

#define HW_CLKCTRL_XBUS_ADDR      (REGS_CLKCTRL_BASE + 0x00000040)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_XBUS           (*(volatile hw_clkctrl_xbus_t *) HW_CLKCTRL_XBUS_ADDR)
#define HW_CLKCTRL_XBUS_RD()      (HW_CLKCTRL_XBUS.U)
#define HW_CLKCTRL_XBUS_WR(v)     (HW_CLKCTRL_XBUS.U = (v))
#define HW_CLKCTRL_XBUS_SET(v)    (HW_CLKCTRL_XBUS_WR(HW_CLKCTRL_XBUS_RD() |  (v)))
#define HW_CLKCTRL_XBUS_CLR(v)    (HW_CLKCTRL_XBUS_WR(HW_CLKCTRL_XBUS_RD() & ~(v)))
#define HW_CLKCTRL_XBUS_TOG(v)    (HW_CLKCTRL_XBUS_WR(HW_CLKCTRL_XBUS_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_CLKCTRL_XBUS bitfields
//

//--- Register HW_CLKCTRL_XBUS, field BUSY

#define BP_CLKCTRL_XBUS_BUSY      31
#define BM_CLKCTRL_XBUS_BUSY      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_XBUS_BUSY(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_XBUS_BUSY)
#else
#define BF_CLKCTRL_XBUS_BUSY(v)   (((v) << 31) & BM_CLKCTRL_XBUS_BUSY)
#endif

//--- Register HW_CLKCTRL_XBUS, field DIV_FRAC_EN

#define BP_CLKCTRL_XBUS_DIV_FRAC_EN      10
#define BM_CLKCTRL_XBUS_DIV_FRAC_EN      0x00000400

#define BF_CLKCTRL_XBUS_DIV_FRAC_EN(v)   (((v) << 10) & BM_CLKCTRL_XBUS_DIV_FRAC_EN)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XBUS_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_XBUS, DIV_FRAC_EN, v)
#endif

//--- Register HW_CLKCTRL_XBUS, field DIV

#define BP_CLKCTRL_XBUS_DIV      0
#define BM_CLKCTRL_XBUS_DIV      0x000003FF

#define BF_CLKCTRL_XBUS_DIV(v)   (((v) << 0) & BM_CLKCTRL_XBUS_DIV)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XBUS_DIV(v)   BF_CS1(CLKCTRL_XBUS, DIV, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_XTAL - XTAL Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV_UART            :  2;
        unsigned RSRVD1              : 24;
        unsigned TIMROT_CLK32K_GATE  :  1;
        unsigned DIGCTRL_CLK1M_GATE  :  1;
        unsigned DRI_CLK24M_GATE     :  1;
        unsigned PWM_CLK24M_GATE     :  1;
        unsigned FILT_CLK24M_GATE    :  1;
        unsigned UART_CLK_GATE       :  1;
    } B;
} hw_clkctrl_xtal_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_XTAL register
//

#define HW_CLKCTRL_XTAL_ADDR      (REGS_CLKCTRL_BASE + 0x00000050)
#define HW_CLKCTRL_XTAL_SET_ADDR  (REGS_CLKCTRL_BASE + 0x00000054)
#define HW_CLKCTRL_XTAL_CLR_ADDR  (REGS_CLKCTRL_BASE + 0x00000058)
#define HW_CLKCTRL_XTAL_TOG_ADDR  (REGS_CLKCTRL_BASE + 0x0000005C)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_XTAL           (*(volatile hw_clkctrl_xtal_t *) HW_CLKCTRL_XTAL_ADDR)
#define HW_CLKCTRL_XTAL_RD()      (HW_CLKCTRL_XTAL.U)
#define HW_CLKCTRL_XTAL_WR(v)     (HW_CLKCTRL_XTAL.U = (v))
#define HW_CLKCTRL_XTAL_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_XTAL_SET_ADDR) = (v))
#define HW_CLKCTRL_XTAL_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_XTAL_CLR_ADDR) = (v))
#define HW_CLKCTRL_XTAL_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_XTAL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_CLKCTRL_XTAL bitfields
//

//--- Register HW_CLKCTRL_XTAL, field UART_CLK_GATE

#define BP_CLKCTRL_XTAL_UART_CLK_GATE      31
#define BM_CLKCTRL_XTAL_UART_CLK_GATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_XTAL_UART_CLK_GATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_XTAL_UART_CLK_GATE)
#else
#define BF_CLKCTRL_XTAL_UART_CLK_GATE(v)   (((v) << 31) & BM_CLKCTRL_XTAL_UART_CLK_GATE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XTAL_UART_CLK_GATE(v)   BF_CS1(CLKCTRL_XTAL, UART_CLK_GATE, v)
#endif

//--- Register HW_CLKCTRL_XTAL, field FILT_CLK24M_GATE

#define BP_CLKCTRL_XTAL_FILT_CLK24M_GATE      30
#define BM_CLKCTRL_XTAL_FILT_CLK24M_GATE      0x40000000

#define BF_CLKCTRL_XTAL_FILT_CLK24M_GATE(v)   (((v) << 30) & BM_CLKCTRL_XTAL_FILT_CLK24M_GATE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XTAL_FILT_CLK24M_GATE(v)   BF_CS1(CLKCTRL_XTAL, FILT_CLK24M_GATE, v)
#endif

//--- Register HW_CLKCTRL_XTAL, field PWM_CLK24M_GATE

#define BP_CLKCTRL_XTAL_PWM_CLK24M_GATE      29
#define BM_CLKCTRL_XTAL_PWM_CLK24M_GATE      0x20000000

#define BF_CLKCTRL_XTAL_PWM_CLK24M_GATE(v)   (((v) << 29) & BM_CLKCTRL_XTAL_PWM_CLK24M_GATE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XTAL_PWM_CLK24M_GATE(v)   BF_CS1(CLKCTRL_XTAL, PWM_CLK24M_GATE, v)
#endif

//--- Register HW_CLKCTRL_XTAL, field DRI_CLK24M_GATE

#define BP_CLKCTRL_XTAL_DRI_CLK24M_GATE      28
#define BM_CLKCTRL_XTAL_DRI_CLK24M_GATE      0x10000000

#define BF_CLKCTRL_XTAL_DRI_CLK24M_GATE(v)   (((v) << 28) & BM_CLKCTRL_XTAL_DRI_CLK24M_GATE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XTAL_DRI_CLK24M_GATE(v)   BF_CS1(CLKCTRL_XTAL, DRI_CLK24M_GATE, v)
#endif

//--- Register HW_CLKCTRL_XTAL, field DIGCTRL_CLK1M_GATE

#define BP_CLKCTRL_XTAL_DIGCTRL_CLK1M_GATE      27
#define BM_CLKCTRL_XTAL_DIGCTRL_CLK1M_GATE      0x08000000

#define BF_CLKCTRL_XTAL_DIGCTRL_CLK1M_GATE(v)   (((v) << 27) & BM_CLKCTRL_XTAL_DIGCTRL_CLK1M_GATE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XTAL_DIGCTRL_CLK1M_GATE(v)   BF_CS1(CLKCTRL_XTAL, DIGCTRL_CLK1M_GATE, v)
#endif

//--- Register HW_CLKCTRL_XTAL, field TIMROT_CLK32K_GATE

#define BP_CLKCTRL_XTAL_TIMROT_CLK32K_GATE      26
#define BM_CLKCTRL_XTAL_TIMROT_CLK32K_GATE      0x04000000

#define BF_CLKCTRL_XTAL_TIMROT_CLK32K_GATE(v)   (((v) << 26) & BM_CLKCTRL_XTAL_TIMROT_CLK32K_GATE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XTAL_TIMROT_CLK32K_GATE(v)   BF_CS1(CLKCTRL_XTAL, TIMROT_CLK32K_GATE, v)
#endif

//--- Register HW_CLKCTRL_XTAL, field DIV_UART

#define BP_CLKCTRL_XTAL_DIV_UART      0
#define BM_CLKCTRL_XTAL_DIV_UART      0x00000003

#define BF_CLKCTRL_XTAL_DIV_UART(v)   (((v) << 0) & BM_CLKCTRL_XTAL_DIV_UART)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XTAL_DIV_UART(v)   BF_CS1(CLKCTRL_XTAL, DIV_UART, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_PIX - PIX (LCDIF) Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV          : 12;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 16;
        unsigned BUSY         :  1;
        unsigned RSRVD2       :  1;
        unsigned CLKGATE      :  1;
    } B;
} hw_clkctrl_pix_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_PIX register
//

#define HW_CLKCTRL_PIX_ADDR      (REGS_CLKCTRL_BASE + 0x00000060)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_PIX           (*(volatile hw_clkctrl_pix_t *) HW_CLKCTRL_PIX_ADDR)
#define HW_CLKCTRL_PIX_RD()      (HW_CLKCTRL_PIX.U)
#define HW_CLKCTRL_PIX_WR(v)     (HW_CLKCTRL_PIX.U = (v))
#define HW_CLKCTRL_PIX_SET(v)    (HW_CLKCTRL_PIX_WR(HW_CLKCTRL_PIX_RD() |  (v)))
#define HW_CLKCTRL_PIX_CLR(v)    (HW_CLKCTRL_PIX_WR(HW_CLKCTRL_PIX_RD() & ~(v)))
#define HW_CLKCTRL_PIX_TOG(v)    (HW_CLKCTRL_PIX_WR(HW_CLKCTRL_PIX_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_CLKCTRL_PIX bitfields
//

//--- Register HW_CLKCTRL_PIX, field CLKGATE

#define BP_CLKCTRL_PIX_CLKGATE      31
#define BM_CLKCTRL_PIX_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_PIX_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_PIX_CLKGATE)
#else
#define BF_CLKCTRL_PIX_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_PIX_CLKGATE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PIX_CLKGATE(v)   BF_CS1(CLKCTRL_PIX, CLKGATE, v)
#endif

//--- Register HW_CLKCTRL_PIX, field BUSY

#define BP_CLKCTRL_PIX_BUSY      29
#define BM_CLKCTRL_PIX_BUSY      0x20000000

#define BF_CLKCTRL_PIX_BUSY(v)   (((v) << 29) & BM_CLKCTRL_PIX_BUSY)

//--- Register HW_CLKCTRL_PIX, field DIV_FRAC_EN

#define BP_CLKCTRL_PIX_DIV_FRAC_EN      12
#define BM_CLKCTRL_PIX_DIV_FRAC_EN      0x00001000

#define BF_CLKCTRL_PIX_DIV_FRAC_EN(v)   (((v) << 12) & BM_CLKCTRL_PIX_DIV_FRAC_EN)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PIX_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_PIX, DIV_FRAC_EN, v)
#endif

//--- Register HW_CLKCTRL_PIX, field DIV

#define BP_CLKCTRL_PIX_DIV      0
#define BM_CLKCTRL_PIX_DIV      0x00000FFF

#define BF_CLKCTRL_PIX_DIV(v)   (((v) << 0) & BM_CLKCTRL_PIX_DIV)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PIX_DIV(v)   BF_CS1(CLKCTRL_PIX, DIV, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_SSP - Synchronous Serial Port Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV          :  9;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 19;
        unsigned BUSY         :  1;
        unsigned RSRVD2       :  1;
        unsigned CLKGATE      :  1;
    } B;
} hw_clkctrl_ssp_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_SSP register
//

#define HW_CLKCTRL_SSP_ADDR      (REGS_CLKCTRL_BASE + 0x00000070)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_SSP           (*(volatile hw_clkctrl_ssp_t *) HW_CLKCTRL_SSP_ADDR)
#define HW_CLKCTRL_SSP_RD()      (HW_CLKCTRL_SSP.U)
#define HW_CLKCTRL_SSP_WR(v)     (HW_CLKCTRL_SSP.U = (v))
#define HW_CLKCTRL_SSP_SET(v)    (HW_CLKCTRL_SSP_WR(HW_CLKCTRL_SSP_RD() |  (v)))
#define HW_CLKCTRL_SSP_CLR(v)    (HW_CLKCTRL_SSP_WR(HW_CLKCTRL_SSP_RD() & ~(v)))
#define HW_CLKCTRL_SSP_TOG(v)    (HW_CLKCTRL_SSP_WR(HW_CLKCTRL_SSP_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_CLKCTRL_SSP bitfields
//

//--- Register HW_CLKCTRL_SSP, field CLKGATE

#define BP_CLKCTRL_SSP_CLKGATE      31
#define BM_CLKCTRL_SSP_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_SSP_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_SSP_CLKGATE)
#else
#define BF_CLKCTRL_SSP_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_SSP_CLKGATE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP_CLKGATE(v)   BF_CS1(CLKCTRL_SSP, CLKGATE, v)
#endif

//--- Register HW_CLKCTRL_SSP, field BUSY

#define BP_CLKCTRL_SSP_BUSY      29
#define BM_CLKCTRL_SSP_BUSY      0x20000000

#define BF_CLKCTRL_SSP_BUSY(v)   (((v) << 29) & BM_CLKCTRL_SSP_BUSY)

//--- Register HW_CLKCTRL_SSP, field DIV_FRAC_EN

#define BP_CLKCTRL_SSP_DIV_FRAC_EN      9
#define BM_CLKCTRL_SSP_DIV_FRAC_EN      0x00000200

#define BF_CLKCTRL_SSP_DIV_FRAC_EN(v)   (((v) << 9) & BM_CLKCTRL_SSP_DIV_FRAC_EN)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_SSP, DIV_FRAC_EN, v)
#endif

//--- Register HW_CLKCTRL_SSP, field DIV

#define BP_CLKCTRL_SSP_DIV      0
#define BM_CLKCTRL_SSP_DIV      0x000001FF

#define BF_CLKCTRL_SSP_DIV(v)   (((v) << 0) & BM_CLKCTRL_SSP_DIV)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP_DIV(v)   BF_CS1(CLKCTRL_SSP, DIV, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_GPMI - General-Purpose Media Interface Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV          : 10;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 18;
        unsigned BUSY         :  1;
        unsigned RSRVD2       :  1;
        unsigned CLKGATE      :  1;
    } B;
} hw_clkctrl_gpmi_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_GPMI register
//

#define HW_CLKCTRL_GPMI_ADDR      (REGS_CLKCTRL_BASE + 0x00000080)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_GPMI           (*(volatile hw_clkctrl_gpmi_t *) HW_CLKCTRL_GPMI_ADDR)
#define HW_CLKCTRL_GPMI_RD()      (HW_CLKCTRL_GPMI.U)
#define HW_CLKCTRL_GPMI_WR(v)     (HW_CLKCTRL_GPMI.U = (v))
#define HW_CLKCTRL_GPMI_SET(v)    (HW_CLKCTRL_GPMI_WR(HW_CLKCTRL_GPMI_RD() |  (v)))
#define HW_CLKCTRL_GPMI_CLR(v)    (HW_CLKCTRL_GPMI_WR(HW_CLKCTRL_GPMI_RD() & ~(v)))
#define HW_CLKCTRL_GPMI_TOG(v)    (HW_CLKCTRL_GPMI_WR(HW_CLKCTRL_GPMI_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_CLKCTRL_GPMI bitfields
//

//--- Register HW_CLKCTRL_GPMI, field CLKGATE

#define BP_CLKCTRL_GPMI_CLKGATE      31
#define BM_CLKCTRL_GPMI_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_GPMI_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_GPMI_CLKGATE)
#else
#define BF_CLKCTRL_GPMI_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_GPMI_CLKGATE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_GPMI_CLKGATE(v)   BF_CS1(CLKCTRL_GPMI, CLKGATE, v)
#endif

//--- Register HW_CLKCTRL_GPMI, field BUSY

#define BP_CLKCTRL_GPMI_BUSY      29
#define BM_CLKCTRL_GPMI_BUSY      0x20000000

#define BF_CLKCTRL_GPMI_BUSY(v)   (((v) << 29) & BM_CLKCTRL_GPMI_BUSY)

//--- Register HW_CLKCTRL_GPMI, field DIV_FRAC_EN

#define BP_CLKCTRL_GPMI_DIV_FRAC_EN      10
#define BM_CLKCTRL_GPMI_DIV_FRAC_EN      0x00000400

#define BF_CLKCTRL_GPMI_DIV_FRAC_EN(v)   (((v) << 10) & BM_CLKCTRL_GPMI_DIV_FRAC_EN)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_GPMI_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_GPMI, DIV_FRAC_EN, v)
#endif

//--- Register HW_CLKCTRL_GPMI, field DIV

#define BP_CLKCTRL_GPMI_DIV      0
#define BM_CLKCTRL_GPMI_DIV      0x000003FF

#define BF_CLKCTRL_GPMI_DIV(v)   (((v) << 0) & BM_CLKCTRL_GPMI_DIV)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_GPMI_DIV(v)   BF_CS1(CLKCTRL_GPMI, DIV, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_SPDIF - SPDIF Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD    : 31;
        unsigned CLKGATE  :  1;
    } B;
} hw_clkctrl_spdif_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_SPDIF register
//

#define HW_CLKCTRL_SPDIF_ADDR      (REGS_CLKCTRL_BASE + 0x00000090)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_SPDIF           (*(volatile hw_clkctrl_spdif_t *) HW_CLKCTRL_SPDIF_ADDR)
#define HW_CLKCTRL_SPDIF_RD()      (HW_CLKCTRL_SPDIF.U)
#define HW_CLKCTRL_SPDIF_WR(v)     (HW_CLKCTRL_SPDIF.U = (v))
#define HW_CLKCTRL_SPDIF_SET(v)    (HW_CLKCTRL_SPDIF_WR(HW_CLKCTRL_SPDIF_RD() |  (v)))
#define HW_CLKCTRL_SPDIF_CLR(v)    (HW_CLKCTRL_SPDIF_WR(HW_CLKCTRL_SPDIF_RD() & ~(v)))
#define HW_CLKCTRL_SPDIF_TOG(v)    (HW_CLKCTRL_SPDIF_WR(HW_CLKCTRL_SPDIF_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_CLKCTRL_SPDIF bitfields
//

//--- Register HW_CLKCTRL_SPDIF, field CLKGATE

#define BP_CLKCTRL_SPDIF_CLKGATE      31
#define BM_CLKCTRL_SPDIF_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_SPDIF_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_SPDIF_CLKGATE)
#else
#define BF_CLKCTRL_SPDIF_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_SPDIF_CLKGATE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SPDIF_CLKGATE(v)   BF_CS1(CLKCTRL_SPDIF, CLKGATE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_EMI - EMI Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV_EMI            :  6;
        unsigned RSRVD1             :  2;
        unsigned DIV_XTAL           :  4;
        unsigned RSRVD2             :  4;
        unsigned DCC_RESYNC_ENABLE  :  1;
        unsigned BUSY_DCC_RESYNC    :  1;
        unsigned RSRVD3             :  8;
        unsigned BUSY_SYNC_MODE     :  1;
        unsigned BUSY_REF_CPU       :  1;
        unsigned BUSY_REF_EMI       :  1;
        unsigned BUSY_REF_XTAL      :  1;
        unsigned SYNC_MODE_EN       :  1;
        unsigned CLKGATE            :  1;
    } B;
} hw_clkctrl_emi_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_EMI register
//

#define HW_CLKCTRL_EMI_ADDR      (REGS_CLKCTRL_BASE + 0x000000A0)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_EMI           (*(volatile hw_clkctrl_emi_t *) HW_CLKCTRL_EMI_ADDR)
#define HW_CLKCTRL_EMI_RD()      (HW_CLKCTRL_EMI.U)
#define HW_CLKCTRL_EMI_WR(v)     (HW_CLKCTRL_EMI.U = (v))
#define HW_CLKCTRL_EMI_SET(v)    (HW_CLKCTRL_EMI_WR(HW_CLKCTRL_EMI_RD() |  (v)))
#define HW_CLKCTRL_EMI_CLR(v)    (HW_CLKCTRL_EMI_WR(HW_CLKCTRL_EMI_RD() & ~(v)))
#define HW_CLKCTRL_EMI_TOG(v)    (HW_CLKCTRL_EMI_WR(HW_CLKCTRL_EMI_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_CLKCTRL_EMI bitfields
//

//--- Register HW_CLKCTRL_EMI, field CLKGATE

#define BP_CLKCTRL_EMI_CLKGATE      31
#define BM_CLKCTRL_EMI_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_EMI_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_EMI_CLKGATE)
#else
#define BF_CLKCTRL_EMI_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_EMI_CLKGATE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_EMI_CLKGATE(v)   BF_CS1(CLKCTRL_EMI, CLKGATE, v)
#endif

//--- Register HW_CLKCTRL_EMI, field SYNC_MODE_EN

#define BP_CLKCTRL_EMI_SYNC_MODE_EN      30
#define BM_CLKCTRL_EMI_SYNC_MODE_EN      0x40000000

#define BF_CLKCTRL_EMI_SYNC_MODE_EN(v)   (((v) << 30) & BM_CLKCTRL_EMI_SYNC_MODE_EN)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_EMI_SYNC_MODE_EN(v)   BF_CS1(CLKCTRL_EMI, SYNC_MODE_EN, v)
#endif

//--- Register HW_CLKCTRL_EMI, field BUSY_REF_XTAL

#define BP_CLKCTRL_EMI_BUSY_REF_XTAL      29
#define BM_CLKCTRL_EMI_BUSY_REF_XTAL      0x20000000

#define BF_CLKCTRL_EMI_BUSY_REF_XTAL(v)   (((v) << 29) & BM_CLKCTRL_EMI_BUSY_REF_XTAL)

//--- Register HW_CLKCTRL_EMI, field BUSY_REF_EMI

#define BP_CLKCTRL_EMI_BUSY_REF_EMI      28
#define BM_CLKCTRL_EMI_BUSY_REF_EMI      0x10000000

#define BF_CLKCTRL_EMI_BUSY_REF_EMI(v)   (((v) << 28) & BM_CLKCTRL_EMI_BUSY_REF_EMI)

//--- Register HW_CLKCTRL_EMI, field BUSY_REF_CPU

#define BP_CLKCTRL_EMI_BUSY_REF_CPU      27
#define BM_CLKCTRL_EMI_BUSY_REF_CPU      0x08000000

#define BF_CLKCTRL_EMI_BUSY_REF_CPU(v)   (((v) << 27) & BM_CLKCTRL_EMI_BUSY_REF_CPU)

//--- Register HW_CLKCTRL_EMI, field BUSY_SYNC_MODE

#define BP_CLKCTRL_EMI_BUSY_SYNC_MODE      26
#define BM_CLKCTRL_EMI_BUSY_SYNC_MODE      0x04000000

#define BF_CLKCTRL_EMI_BUSY_SYNC_MODE(v)   (((v) << 26) & BM_CLKCTRL_EMI_BUSY_SYNC_MODE)

//--- Register HW_CLKCTRL_EMI, field BUSY_DCC_RESYNC

#define BP_CLKCTRL_EMI_BUSY_DCC_RESYNC      17
#define BM_CLKCTRL_EMI_BUSY_DCC_RESYNC      0x00020000

#define BF_CLKCTRL_EMI_BUSY_DCC_RESYNC(v)   (((v) << 17) & BM_CLKCTRL_EMI_BUSY_DCC_RESYNC)

//--- Register HW_CLKCTRL_EMI, field DCC_RESYNC_ENABLE

#define BP_CLKCTRL_EMI_DCC_RESYNC_ENABLE      16
#define BM_CLKCTRL_EMI_DCC_RESYNC_ENABLE      0x00010000

#define BF_CLKCTRL_EMI_DCC_RESYNC_ENABLE(v)   (((v) << 16) & BM_CLKCTRL_EMI_DCC_RESYNC_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_EMI_DCC_RESYNC_ENABLE(v)   BF_CS1(CLKCTRL_EMI, DCC_RESYNC_ENABLE, v)
#endif

//--- Register HW_CLKCTRL_EMI, field DIV_XTAL

#define BP_CLKCTRL_EMI_DIV_XTAL      8
#define BM_CLKCTRL_EMI_DIV_XTAL      0x00000F00

#define BF_CLKCTRL_EMI_DIV_XTAL(v)   (((v) << 8) & BM_CLKCTRL_EMI_DIV_XTAL)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_EMI_DIV_XTAL(v)   BF_CS1(CLKCTRL_EMI, DIV_XTAL, v)
#endif

//--- Register HW_CLKCTRL_EMI, field DIV_EMI

#define BP_CLKCTRL_EMI_DIV_EMI      0
#define BM_CLKCTRL_EMI_DIV_EMI      0x0000003F

#define BF_CLKCTRL_EMI_DIV_EMI(v)   (((v) << 0) & BM_CLKCTRL_EMI_DIV_EMI)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_EMI_DIV_EMI(v)   BF_CS1(CLKCTRL_EMI, DIV_EMI, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_IR - IR Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IR_DIV     : 10;
        unsigned RSRVD1     :  6;
        unsigned IROV_DIV   :  9;
        unsigned RSRVD2     :  2;
        unsigned IROV_BUSY  :  1;
        unsigned IR_BUSY    :  1;
        unsigned AUTO_DIV   :  1;
        unsigned RSRVD3     :  1;
        unsigned CLKGATE    :  1;
    } B;
} hw_clkctrl_ir_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_IR register
//

#define HW_CLKCTRL_IR_ADDR      (REGS_CLKCTRL_BASE + 0x000000B0)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_IR           (*(volatile hw_clkctrl_ir_t *) HW_CLKCTRL_IR_ADDR)
#define HW_CLKCTRL_IR_RD()      (HW_CLKCTRL_IR.U)
#define HW_CLKCTRL_IR_WR(v)     (HW_CLKCTRL_IR.U = (v))
#define HW_CLKCTRL_IR_SET(v)    (HW_CLKCTRL_IR_WR(HW_CLKCTRL_IR_RD() |  (v)))
#define HW_CLKCTRL_IR_CLR(v)    (HW_CLKCTRL_IR_WR(HW_CLKCTRL_IR_RD() & ~(v)))
#define HW_CLKCTRL_IR_TOG(v)    (HW_CLKCTRL_IR_WR(HW_CLKCTRL_IR_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_CLKCTRL_IR bitfields
//

//--- Register HW_CLKCTRL_IR, field CLKGATE

#define BP_CLKCTRL_IR_CLKGATE      31
#define BM_CLKCTRL_IR_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_IR_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_IR_CLKGATE)
#else
#define BF_CLKCTRL_IR_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_IR_CLKGATE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_IR_CLKGATE(v)   BF_CS1(CLKCTRL_IR, CLKGATE, v)
#endif

//--- Register HW_CLKCTRL_IR, field AUTO_DIV

#define BP_CLKCTRL_IR_AUTO_DIV      29
#define BM_CLKCTRL_IR_AUTO_DIV      0x20000000

#define BF_CLKCTRL_IR_AUTO_DIV(v)   (((v) << 29) & BM_CLKCTRL_IR_AUTO_DIV)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_IR_AUTO_DIV(v)   BF_CS1(CLKCTRL_IR, AUTO_DIV, v)
#endif

//--- Register HW_CLKCTRL_IR, field IR_BUSY

#define BP_CLKCTRL_IR_IR_BUSY      28
#define BM_CLKCTRL_IR_IR_BUSY      0x10000000

#define BF_CLKCTRL_IR_IR_BUSY(v)   (((v) << 28) & BM_CLKCTRL_IR_IR_BUSY)

//--- Register HW_CLKCTRL_IR, field IROV_BUSY

#define BP_CLKCTRL_IR_IROV_BUSY      27
#define BM_CLKCTRL_IR_IROV_BUSY      0x08000000

#define BF_CLKCTRL_IR_IROV_BUSY(v)   (((v) << 27) & BM_CLKCTRL_IR_IROV_BUSY)

//--- Register HW_CLKCTRL_IR, field IROV_DIV

#define BP_CLKCTRL_IR_IROV_DIV      16
#define BM_CLKCTRL_IR_IROV_DIV      0x01FF0000

#define BF_CLKCTRL_IR_IROV_DIV(v)   (((v) << 16) & BM_CLKCTRL_IR_IROV_DIV)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_IR_IROV_DIV(v)   BF_CS1(CLKCTRL_IR, IROV_DIV, v)
#endif

//--- Register HW_CLKCTRL_IR, field IR_DIV

#define BP_CLKCTRL_IR_IR_DIV      0
#define BM_CLKCTRL_IR_IR_DIV      0x000003FF

#define BF_CLKCTRL_IR_IR_DIV(v)   (((v) << 0) & BM_CLKCTRL_IR_IR_DIV)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_IR_IR_DIV(v)   BF_CS1(CLKCTRL_IR, IR_DIV, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_SAIF - SAIF Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  DIV;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 12;
        unsigned BUSY         :  1;
        unsigned RSRVD2       :  1;
        unsigned CLKGATE      :  1;
    } B;
} hw_clkctrl_saif_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_SAIF register
//

#define HW_CLKCTRL_SAIF_ADDR      (REGS_CLKCTRL_BASE + 0x000000C0)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_SAIF           (*(volatile hw_clkctrl_saif_t *) HW_CLKCTRL_SAIF_ADDR)
#define HW_CLKCTRL_SAIF_RD()      (HW_CLKCTRL_SAIF.U)
#define HW_CLKCTRL_SAIF_WR(v)     (HW_CLKCTRL_SAIF.U = (v))
#define HW_CLKCTRL_SAIF_SET(v)    (HW_CLKCTRL_SAIF_WR(HW_CLKCTRL_SAIF_RD() |  (v)))
#define HW_CLKCTRL_SAIF_CLR(v)    (HW_CLKCTRL_SAIF_WR(HW_CLKCTRL_SAIF_RD() & ~(v)))
#define HW_CLKCTRL_SAIF_TOG(v)    (HW_CLKCTRL_SAIF_WR(HW_CLKCTRL_SAIF_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_CLKCTRL_SAIF bitfields
//

//--- Register HW_CLKCTRL_SAIF, field CLKGATE

#define BP_CLKCTRL_SAIF_CLKGATE      31
#define BM_CLKCTRL_SAIF_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_SAIF_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_SAIF_CLKGATE)
#else
#define BF_CLKCTRL_SAIF_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_SAIF_CLKGATE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SAIF_CLKGATE(v)   BF_CS1(CLKCTRL_SAIF, CLKGATE, v)
#endif

//--- Register HW_CLKCTRL_SAIF, field BUSY

#define BP_CLKCTRL_SAIF_BUSY      29
#define BM_CLKCTRL_SAIF_BUSY      0x20000000

#define BF_CLKCTRL_SAIF_BUSY(v)   (((v) << 29) & BM_CLKCTRL_SAIF_BUSY)

//--- Register HW_CLKCTRL_SAIF, field DIV_FRAC_EN

#define BP_CLKCTRL_SAIF_DIV_FRAC_EN      16
#define BM_CLKCTRL_SAIF_DIV_FRAC_EN      0x00010000

#define BF_CLKCTRL_SAIF_DIV_FRAC_EN(v)   (((v) << 16) & BM_CLKCTRL_SAIF_DIV_FRAC_EN)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SAIF_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_SAIF, DIV_FRAC_EN, v)
#endif

//--- Register HW_CLKCTRL_SAIF, field DIV

#define BP_CLKCTRL_SAIF_DIV      0
#define BM_CLKCTRL_SAIF_DIV      0x0000FFFF

#define BF_CLKCTRL_SAIF_DIV(v)   (((v) << 0) & BM_CLKCTRL_SAIF_DIV)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SAIF_DIV(v)   (HW_CLKCTRL_SAIF.B.DIV = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_TV - TV Encode Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD            : 30;
        unsigned CLK_TV_GATE      :  1;
        unsigned CLK_TV108M_GATE  :  1;
    } B;
} hw_clkctrl_tv_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_TV register
//

#define HW_CLKCTRL_TV_ADDR      (REGS_CLKCTRL_BASE + 0x000000D0)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_TV           (*(volatile hw_clkctrl_tv_t *) HW_CLKCTRL_TV_ADDR)
#define HW_CLKCTRL_TV_RD()      (HW_CLKCTRL_TV.U)
#define HW_CLKCTRL_TV_WR(v)     (HW_CLKCTRL_TV.U = (v))
#define HW_CLKCTRL_TV_SET(v)    (HW_CLKCTRL_TV_WR(HW_CLKCTRL_TV_RD() |  (v)))
#define HW_CLKCTRL_TV_CLR(v)    (HW_CLKCTRL_TV_WR(HW_CLKCTRL_TV_RD() & ~(v)))
#define HW_CLKCTRL_TV_TOG(v)    (HW_CLKCTRL_TV_WR(HW_CLKCTRL_TV_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_CLKCTRL_TV bitfields
//

//--- Register HW_CLKCTRL_TV, field CLK_TV108M_GATE

#define BP_CLKCTRL_TV_CLK_TV108M_GATE      31
#define BM_CLKCTRL_TV_CLK_TV108M_GATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_TV_CLK_TV108M_GATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_TV_CLK_TV108M_GATE)
#else
#define BF_CLKCTRL_TV_CLK_TV108M_GATE(v)   (((v) << 31) & BM_CLKCTRL_TV_CLK_TV108M_GATE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_TV_CLK_TV108M_GATE(v)   BF_CS1(CLKCTRL_TV, CLK_TV108M_GATE, v)
#endif

//--- Register HW_CLKCTRL_TV, field CLK_TV_GATE

#define BP_CLKCTRL_TV_CLK_TV_GATE      30
#define BM_CLKCTRL_TV_CLK_TV_GATE      0x40000000

#define BF_CLKCTRL_TV_CLK_TV_GATE(v)   (((v) << 30) & BM_CLKCTRL_TV_CLK_TV_GATE)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_TV_CLK_TV_GATE(v)   BF_CS1(CLKCTRL_TV, CLK_TV_GATE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_ETM - ETM Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV          :  6;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 22;
        unsigned BUSY         :  1;
        unsigned RSRVD2       :  1;
        unsigned CLKGATE      :  1;
    } B;
} hw_clkctrl_etm_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_ETM register
//

#define HW_CLKCTRL_ETM_ADDR      (REGS_CLKCTRL_BASE + 0x000000E0)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_ETM           (*(volatile hw_clkctrl_etm_t *) HW_CLKCTRL_ETM_ADDR)
#define HW_CLKCTRL_ETM_RD()      (HW_CLKCTRL_ETM.U)
#define HW_CLKCTRL_ETM_WR(v)     (HW_CLKCTRL_ETM.U = (v))
#define HW_CLKCTRL_ETM_SET(v)    (HW_CLKCTRL_ETM_WR(HW_CLKCTRL_ETM_RD() |  (v)))
#define HW_CLKCTRL_ETM_CLR(v)    (HW_CLKCTRL_ETM_WR(HW_CLKCTRL_ETM_RD() & ~(v)))
#define HW_CLKCTRL_ETM_TOG(v)    (HW_CLKCTRL_ETM_WR(HW_CLKCTRL_ETM_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_CLKCTRL_ETM bitfields
//

//--- Register HW_CLKCTRL_ETM, field CLKGATE

#define BP_CLKCTRL_ETM_CLKGATE      31
#define BM_CLKCTRL_ETM_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_ETM_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_ETM_CLKGATE)
#else
#define BF_CLKCTRL_ETM_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_ETM_CLKGATE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_ETM_CLKGATE(v)   BF_CS1(CLKCTRL_ETM, CLKGATE, v)
#endif

//--- Register HW_CLKCTRL_ETM, field BUSY

#define BP_CLKCTRL_ETM_BUSY      29
#define BM_CLKCTRL_ETM_BUSY      0x20000000

#define BF_CLKCTRL_ETM_BUSY(v)   (((v) << 29) & BM_CLKCTRL_ETM_BUSY)

//--- Register HW_CLKCTRL_ETM, field DIV_FRAC_EN

#define BP_CLKCTRL_ETM_DIV_FRAC_EN      6
#define BM_CLKCTRL_ETM_DIV_FRAC_EN      0x00000040

#define BF_CLKCTRL_ETM_DIV_FRAC_EN(v)   (((v) << 6) & BM_CLKCTRL_ETM_DIV_FRAC_EN)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_ETM_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_ETM, DIV_FRAC_EN, v)
#endif

//--- Register HW_CLKCTRL_ETM, field DIV

#define BP_CLKCTRL_ETM_DIV      0
#define BM_CLKCTRL_ETM_DIV      0x0000003F

#define BF_CLKCTRL_ETM_DIV(v)   (((v) << 0) & BM_CLKCTRL_ETM_DIV)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_ETM_DIV(v)   BF_CS1(CLKCTRL_ETM, DIV, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_FRAC - Fractional Clock Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CPUFRAC     :  6;
        unsigned CPU_STABLE  :  1;
        unsigned CLKGATECPU  :  1;
        unsigned EMIFRAC     :  6;
        unsigned EMI_STABLE  :  1;
        unsigned CLKGATEEMI  :  1;
        unsigned PIXFRAC     :  6;
        unsigned PIX_STABLE  :  1;
        unsigned CLKGATEPIX  :  1;
        unsigned IOFRAC      :  6;
        unsigned IO_STABLE   :  1;
        unsigned CLKGATEIO   :  1;
    } B;
} hw_clkctrl_frac_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_FRAC register
//

#define HW_CLKCTRL_FRAC_ADDR      (REGS_CLKCTRL_BASE + 0x000000F0)
#define HW_CLKCTRL_FRAC_SET_ADDR  (REGS_CLKCTRL_BASE + 0x000000F4)
#define HW_CLKCTRL_FRAC_CLR_ADDR  (REGS_CLKCTRL_BASE + 0x000000F8)
#define HW_CLKCTRL_FRAC_TOG_ADDR  (REGS_CLKCTRL_BASE + 0x000000FC)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_FRAC           (*(volatile hw_clkctrl_frac_t *) HW_CLKCTRL_FRAC_ADDR)
#define HW_CLKCTRL_FRAC_RD()      (HW_CLKCTRL_FRAC.U)
#define HW_CLKCTRL_FRAC_WR(v)     (HW_CLKCTRL_FRAC.U = (v))
#define HW_CLKCTRL_FRAC_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_FRAC_SET_ADDR) = (v))
#define HW_CLKCTRL_FRAC_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_FRAC_CLR_ADDR) = (v))
#define HW_CLKCTRL_FRAC_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_FRAC_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_CLKCTRL_FRAC bitfields
//

//--- Register HW_CLKCTRL_FRAC, field CLKGATEIO

#define BP_CLKCTRL_FRAC_CLKGATEIO      31
#define BM_CLKCTRL_FRAC_CLKGATEIO      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_FRAC_CLKGATEIO(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_FRAC_CLKGATEIO)
#else
#define BF_CLKCTRL_FRAC_CLKGATEIO(v)   (((v) << 31) & BM_CLKCTRL_FRAC_CLKGATEIO)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC_CLKGATEIO(v)   BF_CS1(CLKCTRL_FRAC, CLKGATEIO, v)
#endif

//--- Register HW_CLKCTRL_FRAC, field IO_STABLE

#define BP_CLKCTRL_FRAC_IO_STABLE      30
#define BM_CLKCTRL_FRAC_IO_STABLE      0x40000000

#define BF_CLKCTRL_FRAC_IO_STABLE(v)   (((v) << 30) & BM_CLKCTRL_FRAC_IO_STABLE)

//--- Register HW_CLKCTRL_FRAC, field IOFRAC

#define BP_CLKCTRL_FRAC_IOFRAC      24
#define BM_CLKCTRL_FRAC_IOFRAC      0x3F000000

#define BF_CLKCTRL_FRAC_IOFRAC(v)   (((v) << 24) & BM_CLKCTRL_FRAC_IOFRAC)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC_IOFRAC(v)   BF_CS1(CLKCTRL_FRAC, IOFRAC, v)
#endif

//--- Register HW_CLKCTRL_FRAC, field CLKGATEPIX

#define BP_CLKCTRL_FRAC_CLKGATEPIX      23
#define BM_CLKCTRL_FRAC_CLKGATEPIX      0x00800000

#define BF_CLKCTRL_FRAC_CLKGATEPIX(v)   (((v) << 23) & BM_CLKCTRL_FRAC_CLKGATEPIX)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC_CLKGATEPIX(v)   BF_CS1(CLKCTRL_FRAC, CLKGATEPIX, v)
#endif

//--- Register HW_CLKCTRL_FRAC, field PIX_STABLE

#define BP_CLKCTRL_FRAC_PIX_STABLE      22
#define BM_CLKCTRL_FRAC_PIX_STABLE      0x00400000

#define BF_CLKCTRL_FRAC_PIX_STABLE(v)   (((v) << 22) & BM_CLKCTRL_FRAC_PIX_STABLE)

//--- Register HW_CLKCTRL_FRAC, field PIXFRAC

#define BP_CLKCTRL_FRAC_PIXFRAC      16
#define BM_CLKCTRL_FRAC_PIXFRAC      0x003F0000

#define BF_CLKCTRL_FRAC_PIXFRAC(v)   (((v) << 16) & BM_CLKCTRL_FRAC_PIXFRAC)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC_PIXFRAC(v)   BF_CS1(CLKCTRL_FRAC, PIXFRAC, v)
#endif

//--- Register HW_CLKCTRL_FRAC, field CLKGATEEMI

#define BP_CLKCTRL_FRAC_CLKGATEEMI      15
#define BM_CLKCTRL_FRAC_CLKGATEEMI      0x00008000

#define BF_CLKCTRL_FRAC_CLKGATEEMI(v)   (((v) << 15) & BM_CLKCTRL_FRAC_CLKGATEEMI)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC_CLKGATEEMI(v)   BF_CS1(CLKCTRL_FRAC, CLKGATEEMI, v)
#endif

//--- Register HW_CLKCTRL_FRAC, field EMI_STABLE

#define BP_CLKCTRL_FRAC_EMI_STABLE      14
#define BM_CLKCTRL_FRAC_EMI_STABLE      0x00004000

#define BF_CLKCTRL_FRAC_EMI_STABLE(v)   (((v) << 14) & BM_CLKCTRL_FRAC_EMI_STABLE)

//--- Register HW_CLKCTRL_FRAC, field EMIFRAC

#define BP_CLKCTRL_FRAC_EMIFRAC      8
#define BM_CLKCTRL_FRAC_EMIFRAC      0x00003F00

#define BF_CLKCTRL_FRAC_EMIFRAC(v)   (((v) << 8) & BM_CLKCTRL_FRAC_EMIFRAC)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC_EMIFRAC(v)   BF_CS1(CLKCTRL_FRAC, EMIFRAC, v)
#endif

//--- Register HW_CLKCTRL_FRAC, field CLKGATECPU

#define BP_CLKCTRL_FRAC_CLKGATECPU      7
#define BM_CLKCTRL_FRAC_CLKGATECPU      0x00000080

#define BF_CLKCTRL_FRAC_CLKGATECPU(v)   (((v) << 7) & BM_CLKCTRL_FRAC_CLKGATECPU)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC_CLKGATECPU(v)   BF_CS1(CLKCTRL_FRAC, CLKGATECPU, v)
#endif

//--- Register HW_CLKCTRL_FRAC, field CPU_STABLE

#define BP_CLKCTRL_FRAC_CPU_STABLE      6
#define BM_CLKCTRL_FRAC_CPU_STABLE      0x00000040

#define BF_CLKCTRL_FRAC_CPU_STABLE(v)   (((v) << 6) & BM_CLKCTRL_FRAC_CPU_STABLE)

//--- Register HW_CLKCTRL_FRAC, field CPUFRAC

#define BP_CLKCTRL_FRAC_CPUFRAC      0
#define BM_CLKCTRL_FRAC_CPUFRAC      0x0000003F

#define BF_CLKCTRL_FRAC_CPUFRAC(v)   (((v) << 0) & BM_CLKCTRL_FRAC_CPUFRAC)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC_CPUFRAC(v)   BF_CS1(CLKCTRL_FRAC, CPUFRAC, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_FRAC1 - Fractional Clock Control Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1      : 30;
        unsigned VID_STABLE  :  1;
        unsigned CLKGATEVID  :  1;
    } B;
} hw_clkctrl_frac1_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_FRAC1 register
//

#define HW_CLKCTRL_FRAC1_ADDR      (REGS_CLKCTRL_BASE + 0x00000100)
#define HW_CLKCTRL_FRAC1_SET_ADDR  (REGS_CLKCTRL_BASE + 0x00000104)
#define HW_CLKCTRL_FRAC1_CLR_ADDR  (REGS_CLKCTRL_BASE + 0x00000108)
#define HW_CLKCTRL_FRAC1_TOG_ADDR  (REGS_CLKCTRL_BASE + 0x0000010C)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_FRAC1           (*(volatile hw_clkctrl_frac1_t *) HW_CLKCTRL_FRAC1_ADDR)
#define HW_CLKCTRL_FRAC1_RD()      (HW_CLKCTRL_FRAC1.U)
#define HW_CLKCTRL_FRAC1_WR(v)     (HW_CLKCTRL_FRAC1.U = (v))
#define HW_CLKCTRL_FRAC1_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_FRAC1_SET_ADDR) = (v))
#define HW_CLKCTRL_FRAC1_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_FRAC1_CLR_ADDR) = (v))
#define HW_CLKCTRL_FRAC1_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_FRAC1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_CLKCTRL_FRAC1 bitfields
//

//--- Register HW_CLKCTRL_FRAC1, field CLKGATEVID

#define BP_CLKCTRL_FRAC1_CLKGATEVID      31
#define BM_CLKCTRL_FRAC1_CLKGATEVID      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_FRAC1_CLKGATEVID(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_FRAC1_CLKGATEVID)
#else
#define BF_CLKCTRL_FRAC1_CLKGATEVID(v)   (((v) << 31) & BM_CLKCTRL_FRAC1_CLKGATEVID)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC1_CLKGATEVID(v)   BF_CS1(CLKCTRL_FRAC1, CLKGATEVID, v)
#endif

//--- Register HW_CLKCTRL_FRAC1, field VID_STABLE

#define BP_CLKCTRL_FRAC1_VID_STABLE      30
#define BM_CLKCTRL_FRAC1_VID_STABLE      0x40000000

#define BF_CLKCTRL_FRAC1_VID_STABLE(v)   (((v) << 30) & BM_CLKCTRL_FRAC1_VID_STABLE)


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_CLKSEQ - Clock Frequency Sequence Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BYPASS_SAIF  :  1;
        unsigned BYPASS_PIX   :  1;
        unsigned RSRVD0       :  1;
        unsigned BYPASS_IR    :  1;
        unsigned BYPASS_GPMI  :  1;
        unsigned BYPASS_SSP   :  1;
        unsigned BYPASS_EMI   :  1;
        unsigned BYPASS_CPU   :  1;
        unsigned BYPASS_ETM   :  1;
        unsigned RSRVD1       : 23;
    } B;
} hw_clkctrl_clkseq_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_CLKSEQ register
//

#define HW_CLKCTRL_CLKSEQ_ADDR      (REGS_CLKCTRL_BASE + 0x00000110)
#define HW_CLKCTRL_CLKSEQ_SET_ADDR  (REGS_CLKCTRL_BASE + 0x00000114)
#define HW_CLKCTRL_CLKSEQ_CLR_ADDR  (REGS_CLKCTRL_BASE + 0x00000118)
#define HW_CLKCTRL_CLKSEQ_TOG_ADDR  (REGS_CLKCTRL_BASE + 0x0000011C)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_CLKSEQ           (*(volatile hw_clkctrl_clkseq_t *) HW_CLKCTRL_CLKSEQ_ADDR)
#define HW_CLKCTRL_CLKSEQ_RD()      (HW_CLKCTRL_CLKSEQ.U)
#define HW_CLKCTRL_CLKSEQ_WR(v)     (HW_CLKCTRL_CLKSEQ.U = (v))
#define HW_CLKCTRL_CLKSEQ_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_CLKSEQ_SET_ADDR) = (v))
#define HW_CLKCTRL_CLKSEQ_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_CLKSEQ_CLR_ADDR) = (v))
#define HW_CLKCTRL_CLKSEQ_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_CLKSEQ_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_CLKCTRL_CLKSEQ bitfields
//

//--- Register HW_CLKCTRL_CLKSEQ, field BYPASS_ETM

#define BP_CLKCTRL_CLKSEQ_BYPASS_ETM      8
#define BM_CLKCTRL_CLKSEQ_BYPASS_ETM      0x00000100

#define BF_CLKCTRL_CLKSEQ_BYPASS_ETM(v)   (((v) << 8) & BM_CLKCTRL_CLKSEQ_BYPASS_ETM)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_ETM(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_ETM, v)
#endif

//--- Register HW_CLKCTRL_CLKSEQ, field BYPASS_CPU

#define BP_CLKCTRL_CLKSEQ_BYPASS_CPU      7
#define BM_CLKCTRL_CLKSEQ_BYPASS_CPU      0x00000080

#define BF_CLKCTRL_CLKSEQ_BYPASS_CPU(v)   (((v) << 7) & BM_CLKCTRL_CLKSEQ_BYPASS_CPU)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_CPU(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_CPU, v)
#endif

//--- Register HW_CLKCTRL_CLKSEQ, field BYPASS_EMI

#define BP_CLKCTRL_CLKSEQ_BYPASS_EMI      6
#define BM_CLKCTRL_CLKSEQ_BYPASS_EMI      0x00000040

#define BF_CLKCTRL_CLKSEQ_BYPASS_EMI(v)   (((v) << 6) & BM_CLKCTRL_CLKSEQ_BYPASS_EMI)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_EMI(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_EMI, v)
#endif

//--- Register HW_CLKCTRL_CLKSEQ, field BYPASS_SSP

#define BP_CLKCTRL_CLKSEQ_BYPASS_SSP      5
#define BM_CLKCTRL_CLKSEQ_BYPASS_SSP      0x00000020

#define BF_CLKCTRL_CLKSEQ_BYPASS_SSP(v)   (((v) << 5) & BM_CLKCTRL_CLKSEQ_BYPASS_SSP)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_SSP(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_SSP, v)
#endif

//--- Register HW_CLKCTRL_CLKSEQ, field BYPASS_GPMI

#define BP_CLKCTRL_CLKSEQ_BYPASS_GPMI      4
#define BM_CLKCTRL_CLKSEQ_BYPASS_GPMI      0x00000010

#define BF_CLKCTRL_CLKSEQ_BYPASS_GPMI(v)   (((v) << 4) & BM_CLKCTRL_CLKSEQ_BYPASS_GPMI)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_GPMI(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_GPMI, v)
#endif

//--- Register HW_CLKCTRL_CLKSEQ, field BYPASS_IR

#define BP_CLKCTRL_CLKSEQ_BYPASS_IR      3
#define BM_CLKCTRL_CLKSEQ_BYPASS_IR      0x00000008

#define BF_CLKCTRL_CLKSEQ_BYPASS_IR(v)   (((v) << 3) & BM_CLKCTRL_CLKSEQ_BYPASS_IR)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_IR(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_IR, v)
#endif

//--- Register HW_CLKCTRL_CLKSEQ, field BYPASS_PIX

#define BP_CLKCTRL_CLKSEQ_BYPASS_PIX      1
#define BM_CLKCTRL_CLKSEQ_BYPASS_PIX      0x00000002

#define BF_CLKCTRL_CLKSEQ_BYPASS_PIX(v)   (((v) << 1) & BM_CLKCTRL_CLKSEQ_BYPASS_PIX)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_PIX(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_PIX, v)
#endif

//--- Register HW_CLKCTRL_CLKSEQ, field BYPASS_SAIF

#define BP_CLKCTRL_CLKSEQ_BYPASS_SAIF      0
#define BM_CLKCTRL_CLKSEQ_BYPASS_SAIF      0x00000001

#define BF_CLKCTRL_CLKSEQ_BYPASS_SAIF(v)   (((v) << 0) & BM_CLKCTRL_CLKSEQ_BYPASS_SAIF)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_SAIF(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_SAIF, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_RESET - System Software Reset Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIG    :  1;
        unsigned CHIP   :  1;
        unsigned RSRVD  : 30;
    } B;
} hw_clkctrl_reset_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_RESET register
//

#define HW_CLKCTRL_RESET_ADDR      (REGS_CLKCTRL_BASE + 0x00000120)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_RESET           (*(volatile hw_clkctrl_reset_t *) HW_CLKCTRL_RESET_ADDR)
#define HW_CLKCTRL_RESET_RD()      (HW_CLKCTRL_RESET.U)
#define HW_CLKCTRL_RESET_WR(v)     (HW_CLKCTRL_RESET.U = (v))
#define HW_CLKCTRL_RESET_SET(v)    (HW_CLKCTRL_RESET_WR(HW_CLKCTRL_RESET_RD() |  (v)))
#define HW_CLKCTRL_RESET_CLR(v)    (HW_CLKCTRL_RESET_WR(HW_CLKCTRL_RESET_RD() & ~(v)))
#define HW_CLKCTRL_RESET_TOG(v)    (HW_CLKCTRL_RESET_WR(HW_CLKCTRL_RESET_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_CLKCTRL_RESET bitfields
//

//--- Register HW_CLKCTRL_RESET, field CHIP

#define BP_CLKCTRL_RESET_CHIP      1
#define BM_CLKCTRL_RESET_CHIP      0x00000002

#define BF_CLKCTRL_RESET_CHIP(v)   (((v) << 1) & BM_CLKCTRL_RESET_CHIP)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_RESET_CHIP(v)   BF_CS1(CLKCTRL_RESET, CHIP, v)
#endif

//--- Register HW_CLKCTRL_RESET, field DIG

#define BP_CLKCTRL_RESET_DIG      0
#define BM_CLKCTRL_RESET_DIG      0x00000001

#define BF_CLKCTRL_RESET_DIG(v)   (((v) << 0) & BM_CLKCTRL_RESET_DIG)

#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_RESET_DIG(v)   BF_CS1(CLKCTRL_RESET, DIG, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_STATUS - ClkCtrl Status
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD      : 30;
        unsigned CPU_LIMIT  :  2;
    } B;
} hw_clkctrl_status_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_STATUS register
//

#define HW_CLKCTRL_STATUS_ADDR      (REGS_CLKCTRL_BASE + 0x00000130)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_STATUS           (*(volatile hw_clkctrl_status_t *) HW_CLKCTRL_STATUS_ADDR)
#define HW_CLKCTRL_STATUS_RD()      (HW_CLKCTRL_STATUS.U)
#endif


//
// constants & macros for individual HW_CLKCTRL_STATUS bitfields
//

//--- Register HW_CLKCTRL_STATUS, field CPU_LIMIT

#define BP_CLKCTRL_STATUS_CPU_LIMIT      30
#define BM_CLKCTRL_STATUS_CPU_LIMIT      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_STATUS_CPU_LIMIT(v)   ((((reg32_t) v) << 30) & BM_CLKCTRL_STATUS_CPU_LIMIT)
#else
#define BF_CLKCTRL_STATUS_CPU_LIMIT(v)   (((v) << 30) & BM_CLKCTRL_STATUS_CPU_LIMIT)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_CLKCTRL_VERSION - ClkCtrl Version
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  STEP;
        reg8_t   MINOR;
        reg8_t   MAJOR;
    } B;
} hw_clkctrl_version_t;
#endif


//
// constants & macros for entire HW_CLKCTRL_VERSION register
//

#define HW_CLKCTRL_VERSION_ADDR      (REGS_CLKCTRL_BASE + 0x00000140)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_VERSION           (*(volatile hw_clkctrl_version_t *) HW_CLKCTRL_VERSION_ADDR)
#define HW_CLKCTRL_VERSION_RD()      (HW_CLKCTRL_VERSION.U)
#endif


//
// constants & macros for individual HW_CLKCTRL_VERSION bitfields
//

//--- Register HW_CLKCTRL_VERSION, field MAJOR

#define BP_CLKCTRL_VERSION_MAJOR      24
#define BM_CLKCTRL_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_CLKCTRL_VERSION_MAJOR)
#else
#define BF_CLKCTRL_VERSION_MAJOR(v)   (((v) << 24) & BM_CLKCTRL_VERSION_MAJOR)
#endif

//--- Register HW_CLKCTRL_VERSION, field MINOR

#define BP_CLKCTRL_VERSION_MINOR      16
#define BM_CLKCTRL_VERSION_MINOR      0x00FF0000

#define BF_CLKCTRL_VERSION_MINOR(v)   (((v) << 16) & BM_CLKCTRL_VERSION_MINOR)

//--- Register HW_CLKCTRL_VERSION, field STEP

#define BP_CLKCTRL_VERSION_STEP      0
#define BM_CLKCTRL_VERSION_STEP      0x0000FFFF

#define BF_CLKCTRL_VERSION_STEP(v)   (((v) << 0) & BM_CLKCTRL_VERSION_STEP)


#endif // _REGSCLKCTRL_H

////////////////////////////////////////////////////////////////////////////////
