/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSLRADC_H
#define _REGSLRADC_H  1

#include "regs.h"

#ifndef REGS_LRADC_BASE
#define REGS_LRADC_BASE (REGS_BASE + 0x00050000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_LRADC_CTRL0 - LRADC Control Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   SCHEDULE;
        reg8_t   RSRVD1;
        unsigned XPLUS_ENABLE         :  1;
        unsigned YPLUS_ENABLE         :  1;
        unsigned XMINUS_ENABLE        :  1;
        unsigned YMINUS_ENABLE        :  1;
        unsigned TOUCH_DETECT_ENABLE  :  1;
        unsigned ONCHIP_GROUNDREF     :  1;
        unsigned RSRVD2               :  8;
        unsigned CLKGATE              :  1;
        unsigned SFTRST               :  1;
    } B;
} hw_lradc_ctrl0_t;
#endif


//
// constants & macros for entire HW_LRADC_CTRL0 register
//

#define HW_LRADC_CTRL0_ADDR      (REGS_LRADC_BASE + 0x00000000)
#define HW_LRADC_CTRL0_SET_ADDR  (REGS_LRADC_BASE + 0x00000004)
#define HW_LRADC_CTRL0_CLR_ADDR  (REGS_LRADC_BASE + 0x00000008)
#define HW_LRADC_CTRL0_TOG_ADDR  (REGS_LRADC_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_LRADC_CTRL0           (*(volatile hw_lradc_ctrl0_t *) HW_LRADC_CTRL0_ADDR)
#define HW_LRADC_CTRL0_RD()      (HW_LRADC_CTRL0.U)
#define HW_LRADC_CTRL0_WR(v)     (HW_LRADC_CTRL0.U = (v))
#define HW_LRADC_CTRL0_SET(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL0_SET_ADDR) = (v))
#define HW_LRADC_CTRL0_CLR(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL0_CLR_ADDR) = (v))
#define HW_LRADC_CTRL0_TOG(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_LRADC_CTRL0 bitfields
//

//--- Register HW_LRADC_CTRL0, field SFTRST

#define BP_LRADC_CTRL0_SFTRST      31
#define BM_LRADC_CTRL0_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_LRADC_CTRL0_SFTRST(v)   ((((reg32_t) v) << 31) & BM_LRADC_CTRL0_SFTRST)
#else
#define BF_LRADC_CTRL0_SFTRST(v)   (((v) << 31) & BM_LRADC_CTRL0_SFTRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL0_SFTRST(v)   BF_CS1(LRADC_CTRL0, SFTRST, v)
#endif

//--- Register HW_LRADC_CTRL0, field CLKGATE

#define BP_LRADC_CTRL0_CLKGATE      30
#define BM_LRADC_CTRL0_CLKGATE      0x40000000

#define BF_LRADC_CTRL0_CLKGATE(v)   (((v) << 30) & BM_LRADC_CTRL0_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL0_CLKGATE(v)   BF_CS1(LRADC_CTRL0, CLKGATE, v)
#endif

//--- Register HW_LRADC_CTRL0, field ONCHIP_GROUNDREF

#define BP_LRADC_CTRL0_ONCHIP_GROUNDREF      21
#define BM_LRADC_CTRL0_ONCHIP_GROUNDREF      0x00200000

#define BF_LRADC_CTRL0_ONCHIP_GROUNDREF(v)   (((v) << 21) & BM_LRADC_CTRL0_ONCHIP_GROUNDREF)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL0_ONCHIP_GROUNDREF(v)   BF_CS1(LRADC_CTRL0, ONCHIP_GROUNDREF, v)
#endif

#define BV_LRADC_CTRL0_ONCHIP_GROUNDREF__OFF  0x0
#define BV_LRADC_CTRL0_ONCHIP_GROUNDREF__ON   0x1

//--- Register HW_LRADC_CTRL0, field TOUCH_DETECT_ENABLE

#define BP_LRADC_CTRL0_TOUCH_DETECT_ENABLE      20
#define BM_LRADC_CTRL0_TOUCH_DETECT_ENABLE      0x00100000

#define BF_LRADC_CTRL0_TOUCH_DETECT_ENABLE(v)   (((v) << 20) & BM_LRADC_CTRL0_TOUCH_DETECT_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL0_TOUCH_DETECT_ENABLE(v)   BF_CS1(LRADC_CTRL0, TOUCH_DETECT_ENABLE, v)
#endif

#define BV_LRADC_CTRL0_TOUCH_DETECT_ENABLE__OFF  0x0
#define BV_LRADC_CTRL0_TOUCH_DETECT_ENABLE__ON   0x1

//--- Register HW_LRADC_CTRL0, field YMINUS_ENABLE

#define BP_LRADC_CTRL0_YMINUS_ENABLE      19
#define BM_LRADC_CTRL0_YMINUS_ENABLE      0x00080000

#define BF_LRADC_CTRL0_YMINUS_ENABLE(v)   (((v) << 19) & BM_LRADC_CTRL0_YMINUS_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL0_YMINUS_ENABLE(v)   BF_CS1(LRADC_CTRL0, YMINUS_ENABLE, v)
#endif

#define BV_LRADC_CTRL0_YMINUS_ENABLE__OFF  0x0
#define BV_LRADC_CTRL0_YMINUS_ENABLE__ON   0x1

//--- Register HW_LRADC_CTRL0, field XMINUS_ENABLE

#define BP_LRADC_CTRL0_XMINUS_ENABLE      18
#define BM_LRADC_CTRL0_XMINUS_ENABLE      0x00040000

#define BF_LRADC_CTRL0_XMINUS_ENABLE(v)   (((v) << 18) & BM_LRADC_CTRL0_XMINUS_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL0_XMINUS_ENABLE(v)   BF_CS1(LRADC_CTRL0, XMINUS_ENABLE, v)
#endif

#define BV_LRADC_CTRL0_XMINUS_ENABLE__OFF  0x0
#define BV_LRADC_CTRL0_XMINUS_ENABLE__ON   0x1

//--- Register HW_LRADC_CTRL0, field YPLUS_ENABLE

#define BP_LRADC_CTRL0_YPLUS_ENABLE      17
#define BM_LRADC_CTRL0_YPLUS_ENABLE      0x00020000

#define BF_LRADC_CTRL0_YPLUS_ENABLE(v)   (((v) << 17) & BM_LRADC_CTRL0_YPLUS_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL0_YPLUS_ENABLE(v)   BF_CS1(LRADC_CTRL0, YPLUS_ENABLE, v)
#endif

#define BV_LRADC_CTRL0_YPLUS_ENABLE__OFF  0x0
#define BV_LRADC_CTRL0_YPLUS_ENABLE__ON   0x1

//--- Register HW_LRADC_CTRL0, field XPLUS_ENABLE

#define BP_LRADC_CTRL0_XPLUS_ENABLE      16
#define BM_LRADC_CTRL0_XPLUS_ENABLE      0x00010000

#define BF_LRADC_CTRL0_XPLUS_ENABLE(v)   (((v) << 16) & BM_LRADC_CTRL0_XPLUS_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL0_XPLUS_ENABLE(v)   BF_CS1(LRADC_CTRL0, XPLUS_ENABLE, v)
#endif

#define BV_LRADC_CTRL0_XPLUS_ENABLE__OFF  0x0
#define BV_LRADC_CTRL0_XPLUS_ENABLE__ON   0x1

//--- Register HW_LRADC_CTRL0, field SCHEDULE

#define BP_LRADC_CTRL0_SCHEDULE      0
#define BM_LRADC_CTRL0_SCHEDULE      0x000000FF

#define BF_LRADC_CTRL0_SCHEDULE(v)   (((v) << 0) & BM_LRADC_CTRL0_SCHEDULE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL0_SCHEDULE(v)   (HW_LRADC_CTRL0.B.SCHEDULE = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_LRADC_CTRL1 - LRADC Control Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LRADC0_IRQ           :  1;
        unsigned LRADC1_IRQ           :  1;
        unsigned LRADC2_IRQ           :  1;
        unsigned LRADC3_IRQ           :  1;
        unsigned LRADC4_IRQ           :  1;
        unsigned LRADC5_IRQ           :  1;
        unsigned LRADC6_IRQ           :  1;
        unsigned LRADC7_IRQ           :  1;
        unsigned TOUCH_DETECT_IRQ     :  1;
        unsigned RSRVD1               :  7;
        unsigned LRADC0_IRQ_EN        :  1;
        unsigned LRADC1_IRQ_EN        :  1;
        unsigned LRADC2_IRQ_EN        :  1;
        unsigned LRADC3_IRQ_EN        :  1;
        unsigned LRADC4_IRQ_EN        :  1;
        unsigned LRADC5_IRQ_EN        :  1;
        unsigned LRADC6_IRQ_EN        :  1;
        unsigned LRADC7_IRQ_EN        :  1;
        unsigned TOUCH_DETECT_IRQ_EN  :  1;
        unsigned RSRVD2               :  7;
    } B;
} hw_lradc_ctrl1_t;
#endif


//
// constants & macros for entire HW_LRADC_CTRL1 register
//

#define HW_LRADC_CTRL1_ADDR      (REGS_LRADC_BASE + 0x00000010)
#define HW_LRADC_CTRL1_SET_ADDR  (REGS_LRADC_BASE + 0x00000014)
#define HW_LRADC_CTRL1_CLR_ADDR  (REGS_LRADC_BASE + 0x00000018)
#define HW_LRADC_CTRL1_TOG_ADDR  (REGS_LRADC_BASE + 0x0000001C)

#ifndef __LANGUAGE_ASM__
#define HW_LRADC_CTRL1           (*(volatile hw_lradc_ctrl1_t *) HW_LRADC_CTRL1_ADDR)
#define HW_LRADC_CTRL1_RD()      (HW_LRADC_CTRL1.U)
#define HW_LRADC_CTRL1_WR(v)     (HW_LRADC_CTRL1.U = (v))
#define HW_LRADC_CTRL1_SET(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL1_SET_ADDR) = (v))
#define HW_LRADC_CTRL1_CLR(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL1_CLR_ADDR) = (v))
#define HW_LRADC_CTRL1_TOG(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_LRADC_CTRL1 bitfields
//

//--- Register HW_LRADC_CTRL1, field TOUCH_DETECT_IRQ_EN

#define BP_LRADC_CTRL1_TOUCH_DETECT_IRQ_EN      24
#define BM_LRADC_CTRL1_TOUCH_DETECT_IRQ_EN      0x01000000

#define BF_LRADC_CTRL1_TOUCH_DETECT_IRQ_EN(v)   (((v) << 24) & BM_LRADC_CTRL1_TOUCH_DETECT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_TOUCH_DETECT_IRQ_EN(v)   BF_CS1(LRADC_CTRL1, TOUCH_DETECT_IRQ_EN, v)
#endif

#define BV_LRADC_CTRL1_TOUCH_DETECT_IRQ_EN__DISABLE  0x0
#define BV_LRADC_CTRL1_TOUCH_DETECT_IRQ_EN__ENABLE   0x1

//--- Register HW_LRADC_CTRL1, field LRADC7_IRQ_EN

#define BP_LRADC_CTRL1_LRADC7_IRQ_EN      23
#define BM_LRADC_CTRL1_LRADC7_IRQ_EN      0x00800000

#define BF_LRADC_CTRL1_LRADC7_IRQ_EN(v)   (((v) << 23) & BM_LRADC_CTRL1_LRADC7_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC7_IRQ_EN(v)   BF_CS1(LRADC_CTRL1, LRADC7_IRQ_EN, v)
#endif

#define BV_LRADC_CTRL1_LRADC7_IRQ_EN__DISABLE  0x0
#define BV_LRADC_CTRL1_LRADC7_IRQ_EN__ENABLE   0x1

//--- Register HW_LRADC_CTRL1, field LRADC6_IRQ_EN

#define BP_LRADC_CTRL1_LRADC6_IRQ_EN      22
#define BM_LRADC_CTRL1_LRADC6_IRQ_EN      0x00400000

#define BF_LRADC_CTRL1_LRADC6_IRQ_EN(v)   (((v) << 22) & BM_LRADC_CTRL1_LRADC6_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC6_IRQ_EN(v)   BF_CS1(LRADC_CTRL1, LRADC6_IRQ_EN, v)
#endif

#define BV_LRADC_CTRL1_LRADC6_IRQ_EN__DISABLE  0x0
#define BV_LRADC_CTRL1_LRADC6_IRQ_EN__ENABLE   0x1

//--- Register HW_LRADC_CTRL1, field LRADC5_IRQ_EN

#define BP_LRADC_CTRL1_LRADC5_IRQ_EN      21
#define BM_LRADC_CTRL1_LRADC5_IRQ_EN      0x00200000

#define BF_LRADC_CTRL1_LRADC5_IRQ_EN(v)   (((v) << 21) & BM_LRADC_CTRL1_LRADC5_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC5_IRQ_EN(v)   BF_CS1(LRADC_CTRL1, LRADC5_IRQ_EN, v)
#endif

#define BV_LRADC_CTRL1_LRADC5_IRQ_EN__DISABLE  0x0
#define BV_LRADC_CTRL1_LRADC5_IRQ_EN__ENABLE   0x1

//--- Register HW_LRADC_CTRL1, field LRADC4_IRQ_EN

#define BP_LRADC_CTRL1_LRADC4_IRQ_EN      20
#define BM_LRADC_CTRL1_LRADC4_IRQ_EN      0x00100000

#define BF_LRADC_CTRL1_LRADC4_IRQ_EN(v)   (((v) << 20) & BM_LRADC_CTRL1_LRADC4_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC4_IRQ_EN(v)   BF_CS1(LRADC_CTRL1, LRADC4_IRQ_EN, v)
#endif

#define BV_LRADC_CTRL1_LRADC4_IRQ_EN__DISABLE  0x0
#define BV_LRADC_CTRL1_LRADC4_IRQ_EN__ENABLE   0x1

//--- Register HW_LRADC_CTRL1, field LRADC3_IRQ_EN

#define BP_LRADC_CTRL1_LRADC3_IRQ_EN      19
#define BM_LRADC_CTRL1_LRADC3_IRQ_EN      0x00080000

#define BF_LRADC_CTRL1_LRADC3_IRQ_EN(v)   (((v) << 19) & BM_LRADC_CTRL1_LRADC3_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC3_IRQ_EN(v)   BF_CS1(LRADC_CTRL1, LRADC3_IRQ_EN, v)
#endif

#define BV_LRADC_CTRL1_LRADC3_IRQ_EN__DISABLE  0x0
#define BV_LRADC_CTRL1_LRADC3_IRQ_EN__ENABLE   0x1

//--- Register HW_LRADC_CTRL1, field LRADC2_IRQ_EN

#define BP_LRADC_CTRL1_LRADC2_IRQ_EN      18
#define BM_LRADC_CTRL1_LRADC2_IRQ_EN      0x00040000

#define BF_LRADC_CTRL1_LRADC2_IRQ_EN(v)   (((v) << 18) & BM_LRADC_CTRL1_LRADC2_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC2_IRQ_EN(v)   BF_CS1(LRADC_CTRL1, LRADC2_IRQ_EN, v)
#endif

#define BV_LRADC_CTRL1_LRADC2_IRQ_EN__DISABLE  0x0
#define BV_LRADC_CTRL1_LRADC2_IRQ_EN__ENABLE   0x1

//--- Register HW_LRADC_CTRL1, field LRADC1_IRQ_EN

#define BP_LRADC_CTRL1_LRADC1_IRQ_EN      17
#define BM_LRADC_CTRL1_LRADC1_IRQ_EN      0x00020000

#define BF_LRADC_CTRL1_LRADC1_IRQ_EN(v)   (((v) << 17) & BM_LRADC_CTRL1_LRADC1_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC1_IRQ_EN(v)   BF_CS1(LRADC_CTRL1, LRADC1_IRQ_EN, v)
#endif

#define BV_LRADC_CTRL1_LRADC1_IRQ_EN__DISABLE  0x0
#define BV_LRADC_CTRL1_LRADC1_IRQ_EN__ENABLE   0x1

//--- Register HW_LRADC_CTRL1, field LRADC0_IRQ_EN

#define BP_LRADC_CTRL1_LRADC0_IRQ_EN      16
#define BM_LRADC_CTRL1_LRADC0_IRQ_EN      0x00010000

#define BF_LRADC_CTRL1_LRADC0_IRQ_EN(v)   (((v) << 16) & BM_LRADC_CTRL1_LRADC0_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC0_IRQ_EN(v)   BF_CS1(LRADC_CTRL1, LRADC0_IRQ_EN, v)
#endif

#define BV_LRADC_CTRL1_LRADC0_IRQ_EN__DISABLE  0x0
#define BV_LRADC_CTRL1_LRADC0_IRQ_EN__ENABLE   0x1

//--- Register HW_LRADC_CTRL1, field TOUCH_DETECT_IRQ

#define BP_LRADC_CTRL1_TOUCH_DETECT_IRQ      8
#define BM_LRADC_CTRL1_TOUCH_DETECT_IRQ      0x00000100

#define BF_LRADC_CTRL1_TOUCH_DETECT_IRQ(v)   (((v) << 8) & BM_LRADC_CTRL1_TOUCH_DETECT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_TOUCH_DETECT_IRQ(v)   BF_CS1(LRADC_CTRL1, TOUCH_DETECT_IRQ, v)
#endif

#define BV_LRADC_CTRL1_TOUCH_DETECT_IRQ__CLEAR    0x0
#define BV_LRADC_CTRL1_TOUCH_DETECT_IRQ__PENDING  0x1

//--- Register HW_LRADC_CTRL1, field LRADC7_IRQ

#define BP_LRADC_CTRL1_LRADC7_IRQ      7
#define BM_LRADC_CTRL1_LRADC7_IRQ      0x00000080

#define BF_LRADC_CTRL1_LRADC7_IRQ(v)   (((v) << 7) & BM_LRADC_CTRL1_LRADC7_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC7_IRQ(v)   BF_CS1(LRADC_CTRL1, LRADC7_IRQ, v)
#endif

#define BV_LRADC_CTRL1_LRADC7_IRQ__CLEAR    0x0
#define BV_LRADC_CTRL1_LRADC7_IRQ__PENDING  0x1

//--- Register HW_LRADC_CTRL1, field LRADC6_IRQ

#define BP_LRADC_CTRL1_LRADC6_IRQ      6
#define BM_LRADC_CTRL1_LRADC6_IRQ      0x00000040

#define BF_LRADC_CTRL1_LRADC6_IRQ(v)   (((v) << 6) & BM_LRADC_CTRL1_LRADC6_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC6_IRQ(v)   BF_CS1(LRADC_CTRL1, LRADC6_IRQ, v)
#endif

#define BV_LRADC_CTRL1_LRADC6_IRQ__CLEAR    0x0
#define BV_LRADC_CTRL1_LRADC6_IRQ__PENDING  0x1

//--- Register HW_LRADC_CTRL1, field LRADC5_IRQ

#define BP_LRADC_CTRL1_LRADC5_IRQ      5
#define BM_LRADC_CTRL1_LRADC5_IRQ      0x00000020

#define BF_LRADC_CTRL1_LRADC5_IRQ(v)   (((v) << 5) & BM_LRADC_CTRL1_LRADC5_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC5_IRQ(v)   BF_CS1(LRADC_CTRL1, LRADC5_IRQ, v)
#endif

#define BV_LRADC_CTRL1_LRADC5_IRQ__CLEAR    0x0
#define BV_LRADC_CTRL1_LRADC5_IRQ__PENDING  0x1

//--- Register HW_LRADC_CTRL1, field LRADC4_IRQ

#define BP_LRADC_CTRL1_LRADC4_IRQ      4
#define BM_LRADC_CTRL1_LRADC4_IRQ      0x00000010

#define BF_LRADC_CTRL1_LRADC4_IRQ(v)   (((v) << 4) & BM_LRADC_CTRL1_LRADC4_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC4_IRQ(v)   BF_CS1(LRADC_CTRL1, LRADC4_IRQ, v)
#endif

#define BV_LRADC_CTRL1_LRADC4_IRQ__CLEAR    0x0
#define BV_LRADC_CTRL1_LRADC4_IRQ__PENDING  0x1

//--- Register HW_LRADC_CTRL1, field LRADC3_IRQ

#define BP_LRADC_CTRL1_LRADC3_IRQ      3
#define BM_LRADC_CTRL1_LRADC3_IRQ      0x00000008

#define BF_LRADC_CTRL1_LRADC3_IRQ(v)   (((v) << 3) & BM_LRADC_CTRL1_LRADC3_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC3_IRQ(v)   BF_CS1(LRADC_CTRL1, LRADC3_IRQ, v)
#endif

#define BV_LRADC_CTRL1_LRADC3_IRQ__CLEAR    0x0
#define BV_LRADC_CTRL1_LRADC3_IRQ__PENDING  0x1

//--- Register HW_LRADC_CTRL1, field LRADC2_IRQ

#define BP_LRADC_CTRL1_LRADC2_IRQ      2
#define BM_LRADC_CTRL1_LRADC2_IRQ      0x00000004

#define BF_LRADC_CTRL1_LRADC2_IRQ(v)   (((v) << 2) & BM_LRADC_CTRL1_LRADC2_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC2_IRQ(v)   BF_CS1(LRADC_CTRL1, LRADC2_IRQ, v)
#endif

#define BV_LRADC_CTRL1_LRADC2_IRQ__CLEAR    0x0
#define BV_LRADC_CTRL1_LRADC2_IRQ__PENDING  0x1

//--- Register HW_LRADC_CTRL1, field LRADC1_IRQ

#define BP_LRADC_CTRL1_LRADC1_IRQ      1
#define BM_LRADC_CTRL1_LRADC1_IRQ      0x00000002

#define BF_LRADC_CTRL1_LRADC1_IRQ(v)   (((v) << 1) & BM_LRADC_CTRL1_LRADC1_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC1_IRQ(v)   BF_CS1(LRADC_CTRL1, LRADC1_IRQ, v)
#endif

#define BV_LRADC_CTRL1_LRADC1_IRQ__CLEAR    0x0
#define BV_LRADC_CTRL1_LRADC1_IRQ__PENDING  0x1

//--- Register HW_LRADC_CTRL1, field LRADC0_IRQ

#define BP_LRADC_CTRL1_LRADC0_IRQ      0
#define BM_LRADC_CTRL1_LRADC0_IRQ      0x00000001

#define BF_LRADC_CTRL1_LRADC0_IRQ(v)   (((v) << 0) & BM_LRADC_CTRL1_LRADC0_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL1_LRADC0_IRQ(v)   BF_CS1(LRADC_CTRL1, LRADC0_IRQ, v)
#endif

#define BV_LRADC_CTRL1_LRADC0_IRQ__CLEAR    0x0
#define BV_LRADC_CTRL1_LRADC0_IRQ__PENDING  0x1


////////////////////////////////////////////////////////////////////////////////
//// HW_LRADC_CTRL2 - LRADC Control Register 2
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TEMP_ISRC0            :  4;
        unsigned TEMP_ISRC1            :  4;
        unsigned TEMP_SENSOR_IENABLE0  :  1;
        unsigned TEMP_SENSOR_IENABLE1  :  1;
        unsigned RSRVD2                :  2;
        unsigned EXT_EN0               :  1;
        unsigned EXT_EN1               :  1;
        unsigned RSRVD1                :  1;
        unsigned TEMPSENSE_PWD         :  1;
        unsigned BL_BRIGHTNESS         :  5;
        unsigned BL_MUX_SELECT         :  1;
        unsigned BL_ENABLE             :  1;
        unsigned BL_AMP_BYPASS         :  1;
        reg8_t   DIVIDE_BY_TWO;
    } B;
} hw_lradc_ctrl2_t;
#endif


//
// constants & macros for entire HW_LRADC_CTRL2 register
//

#define HW_LRADC_CTRL2_ADDR      (REGS_LRADC_BASE + 0x00000020)
#define HW_LRADC_CTRL2_SET_ADDR  (REGS_LRADC_BASE + 0x00000024)
#define HW_LRADC_CTRL2_CLR_ADDR  (REGS_LRADC_BASE + 0x00000028)
#define HW_LRADC_CTRL2_TOG_ADDR  (REGS_LRADC_BASE + 0x0000002C)

#ifndef __LANGUAGE_ASM__
#define HW_LRADC_CTRL2           (*(volatile hw_lradc_ctrl2_t *) HW_LRADC_CTRL2_ADDR)
#define HW_LRADC_CTRL2_RD()      (HW_LRADC_CTRL2.U)
#define HW_LRADC_CTRL2_WR(v)     (HW_LRADC_CTRL2.U = (v))
#define HW_LRADC_CTRL2_SET(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL2_SET_ADDR) = (v))
#define HW_LRADC_CTRL2_CLR(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL2_CLR_ADDR) = (v))
#define HW_LRADC_CTRL2_TOG(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL2_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_LRADC_CTRL2 bitfields
//

//--- Register HW_LRADC_CTRL2, field DIVIDE_BY_TWO

#define BP_LRADC_CTRL2_DIVIDE_BY_TWO      24
#define BM_LRADC_CTRL2_DIVIDE_BY_TWO      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_LRADC_CTRL2_DIVIDE_BY_TWO(v)   ((((reg32_t) v) << 24) & BM_LRADC_CTRL2_DIVIDE_BY_TWO)
#else
#define BF_LRADC_CTRL2_DIVIDE_BY_TWO(v)   (((v) << 24) & BM_LRADC_CTRL2_DIVIDE_BY_TWO)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL2_DIVIDE_BY_TWO(v)   (HW_LRADC_CTRL2.B.DIVIDE_BY_TWO = (v))
#endif

//--- Register HW_LRADC_CTRL2, field BL_AMP_BYPASS

#define BP_LRADC_CTRL2_BL_AMP_BYPASS      23
#define BM_LRADC_CTRL2_BL_AMP_BYPASS      0x00800000

#define BF_LRADC_CTRL2_BL_AMP_BYPASS(v)   (((v) << 23) & BM_LRADC_CTRL2_BL_AMP_BYPASS)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL2_BL_AMP_BYPASS(v)   BF_CS1(LRADC_CTRL2, BL_AMP_BYPASS, v)
#endif

#define BV_LRADC_CTRL2_BL_AMP_BYPASS__DISABLE  0x0
#define BV_LRADC_CTRL2_BL_AMP_BYPASS__ENABLE   0x1

//--- Register HW_LRADC_CTRL2, field BL_ENABLE

#define BP_LRADC_CTRL2_BL_ENABLE      22
#define BM_LRADC_CTRL2_BL_ENABLE      0x00400000

#define BF_LRADC_CTRL2_BL_ENABLE(v)   (((v) << 22) & BM_LRADC_CTRL2_BL_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL2_BL_ENABLE(v)   BF_CS1(LRADC_CTRL2, BL_ENABLE, v)
#endif

//--- Register HW_LRADC_CTRL2, field BL_MUX_SELECT

#define BP_LRADC_CTRL2_BL_MUX_SELECT      21
#define BM_LRADC_CTRL2_BL_MUX_SELECT      0x00200000

#define BF_LRADC_CTRL2_BL_MUX_SELECT(v)   (((v) << 21) & BM_LRADC_CTRL2_BL_MUX_SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL2_BL_MUX_SELECT(v)   BF_CS1(LRADC_CTRL2, BL_MUX_SELECT, v)
#endif

//--- Register HW_LRADC_CTRL2, field BL_BRIGHTNESS

#define BP_LRADC_CTRL2_BL_BRIGHTNESS      16
#define BM_LRADC_CTRL2_BL_BRIGHTNESS      0x001F0000

#define BF_LRADC_CTRL2_BL_BRIGHTNESS(v)   (((v) << 16) & BM_LRADC_CTRL2_BL_BRIGHTNESS)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL2_BL_BRIGHTNESS(v)   BF_CS1(LRADC_CTRL2, BL_BRIGHTNESS, v)
#endif

//--- Register HW_LRADC_CTRL2, field TEMPSENSE_PWD

#define BP_LRADC_CTRL2_TEMPSENSE_PWD      15
#define BM_LRADC_CTRL2_TEMPSENSE_PWD      0x00008000

#define BF_LRADC_CTRL2_TEMPSENSE_PWD(v)   (((v) << 15) & BM_LRADC_CTRL2_TEMPSENSE_PWD)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL2_TEMPSENSE_PWD(v)   BF_CS1(LRADC_CTRL2, TEMPSENSE_PWD, v)
#endif

#define BV_LRADC_CTRL2_TEMPSENSE_PWD__DISABLE  0x0
#define BV_LRADC_CTRL2_TEMPSENSE_PWD__ENABLE   0x1

//--- Register HW_LRADC_CTRL2, field EXT_EN1

#define BP_LRADC_CTRL2_EXT_EN1      13
#define BM_LRADC_CTRL2_EXT_EN1      0x00002000

#define BF_LRADC_CTRL2_EXT_EN1(v)   (((v) << 13) & BM_LRADC_CTRL2_EXT_EN1)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL2_EXT_EN1(v)   BF_CS1(LRADC_CTRL2, EXT_EN1, v)
#endif

#define BV_LRADC_CTRL2_EXT_EN1__DISABLE  0x0
#define BV_LRADC_CTRL2_EXT_EN1__ENABLE   0x1

//--- Register HW_LRADC_CTRL2, field EXT_EN0

#define BP_LRADC_CTRL2_EXT_EN0      12
#define BM_LRADC_CTRL2_EXT_EN0      0x00001000

#define BF_LRADC_CTRL2_EXT_EN0(v)   (((v) << 12) & BM_LRADC_CTRL2_EXT_EN0)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL2_EXT_EN0(v)   BF_CS1(LRADC_CTRL2, EXT_EN0, v)
#endif

//--- Register HW_LRADC_CTRL2, field TEMP_SENSOR_IENABLE1

#define BP_LRADC_CTRL2_TEMP_SENSOR_IENABLE1      9
#define BM_LRADC_CTRL2_TEMP_SENSOR_IENABLE1      0x00000200

#define BF_LRADC_CTRL2_TEMP_SENSOR_IENABLE1(v)   (((v) << 9) & BM_LRADC_CTRL2_TEMP_SENSOR_IENABLE1)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL2_TEMP_SENSOR_IENABLE1(v)   BF_CS1(LRADC_CTRL2, TEMP_SENSOR_IENABLE1, v)
#endif

#define BV_LRADC_CTRL2_TEMP_SENSOR_IENABLE1__DISABLE  0x0
#define BV_LRADC_CTRL2_TEMP_SENSOR_IENABLE1__ENABLE   0x1

//--- Register HW_LRADC_CTRL2, field TEMP_SENSOR_IENABLE0

#define BP_LRADC_CTRL2_TEMP_SENSOR_IENABLE0      8
#define BM_LRADC_CTRL2_TEMP_SENSOR_IENABLE0      0x00000100

#define BF_LRADC_CTRL2_TEMP_SENSOR_IENABLE0(v)   (((v) << 8) & BM_LRADC_CTRL2_TEMP_SENSOR_IENABLE0)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL2_TEMP_SENSOR_IENABLE0(v)   BF_CS1(LRADC_CTRL2, TEMP_SENSOR_IENABLE0, v)
#endif

#define BV_LRADC_CTRL2_TEMP_SENSOR_IENABLE0__DISABLE  0x0
#define BV_LRADC_CTRL2_TEMP_SENSOR_IENABLE0__ENABLE   0x1

//--- Register HW_LRADC_CTRL2, field TEMP_ISRC1

#define BP_LRADC_CTRL2_TEMP_ISRC1      4
#define BM_LRADC_CTRL2_TEMP_ISRC1      0x000000F0

#define BF_LRADC_CTRL2_TEMP_ISRC1(v)   (((v) << 4) & BM_LRADC_CTRL2_TEMP_ISRC1)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL2_TEMP_ISRC1(v)   BF_CS1(LRADC_CTRL2, TEMP_ISRC1, v)
#endif

#define BV_LRADC_CTRL2_TEMP_ISRC1__300   0xF
#define BV_LRADC_CTRL2_TEMP_ISRC1__280   0xE
#define BV_LRADC_CTRL2_TEMP_ISRC1__260   0xD
#define BV_LRADC_CTRL2_TEMP_ISRC1__240   0xC
#define BV_LRADC_CTRL2_TEMP_ISRC1__220   0xB
#define BV_LRADC_CTRL2_TEMP_ISRC1__200   0xA
#define BV_LRADC_CTRL2_TEMP_ISRC1__180   0x9
#define BV_LRADC_CTRL2_TEMP_ISRC1__160   0x8
#define BV_LRADC_CTRL2_TEMP_ISRC1__140   0x7
#define BV_LRADC_CTRL2_TEMP_ISRC1__120   0x6
#define BV_LRADC_CTRL2_TEMP_ISRC1__100   0x5
#define BV_LRADC_CTRL2_TEMP_ISRC1__80    0x4
#define BV_LRADC_CTRL2_TEMP_ISRC1__60    0x3
#define BV_LRADC_CTRL2_TEMP_ISRC1__40    0x2
#define BV_LRADC_CTRL2_TEMP_ISRC1__20    0x1
#define BV_LRADC_CTRL2_TEMP_ISRC1__ZERO  0x0

//--- Register HW_LRADC_CTRL2, field TEMP_ISRC0

#define BP_LRADC_CTRL2_TEMP_ISRC0      0
#define BM_LRADC_CTRL2_TEMP_ISRC0      0x0000000F

#define BF_LRADC_CTRL2_TEMP_ISRC0(v)   (((v) << 0) & BM_LRADC_CTRL2_TEMP_ISRC0)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL2_TEMP_ISRC0(v)   BF_CS1(LRADC_CTRL2, TEMP_ISRC0, v)
#endif

#define BV_LRADC_CTRL2_TEMP_ISRC0__300   0xF
#define BV_LRADC_CTRL2_TEMP_ISRC0__280   0xE
#define BV_LRADC_CTRL2_TEMP_ISRC0__260   0xD
#define BV_LRADC_CTRL2_TEMP_ISRC0__240   0xC
#define BV_LRADC_CTRL2_TEMP_ISRC0__220   0xB
#define BV_LRADC_CTRL2_TEMP_ISRC0__200   0xA
#define BV_LRADC_CTRL2_TEMP_ISRC0__180   0x9
#define BV_LRADC_CTRL2_TEMP_ISRC0__160   0x8
#define BV_LRADC_CTRL2_TEMP_ISRC0__140   0x7
#define BV_LRADC_CTRL2_TEMP_ISRC0__120   0x6
#define BV_LRADC_CTRL2_TEMP_ISRC0__100   0x5
#define BV_LRADC_CTRL2_TEMP_ISRC0__80    0x4
#define BV_LRADC_CTRL2_TEMP_ISRC0__60    0x3
#define BV_LRADC_CTRL2_TEMP_ISRC0__40    0x2
#define BV_LRADC_CTRL2_TEMP_ISRC0__20    0x1
#define BV_LRADC_CTRL2_TEMP_ISRC0__ZERO  0x0


////////////////////////////////////////////////////////////////////////////////
//// HW_LRADC_CTRL3 - LRADC Control Register 3
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned INVERT_CLOCK       :  1;
        unsigned DELAY_CLOCK        :  1;
        unsigned RSRVD1             :  2;
        unsigned HIGH_TIME          :  2;
        unsigned RSRVD2             :  2;
        unsigned CYCLE_TIME         :  2;
        unsigned RSRVD3             :  4;
        unsigned RSRVD4             :  8;
        unsigned FORCE_ANALOG_PWDN  :  1;
        unsigned FORCE_ANALOG_PWUP  :  1;
        unsigned DISCARD            :  2;
        unsigned RSRVD5             :  6;
    } B;
} hw_lradc_ctrl3_t;
#endif


//
// constants & macros for entire HW_LRADC_CTRL3 register
//

#define HW_LRADC_CTRL3_ADDR      (REGS_LRADC_BASE + 0x00000030)
#define HW_LRADC_CTRL3_SET_ADDR  (REGS_LRADC_BASE + 0x00000034)
#define HW_LRADC_CTRL3_CLR_ADDR  (REGS_LRADC_BASE + 0x00000038)
#define HW_LRADC_CTRL3_TOG_ADDR  (REGS_LRADC_BASE + 0x0000003C)

#ifndef __LANGUAGE_ASM__
#define HW_LRADC_CTRL3           (*(volatile hw_lradc_ctrl3_t *) HW_LRADC_CTRL3_ADDR)
#define HW_LRADC_CTRL3_RD()      (HW_LRADC_CTRL3.U)
#define HW_LRADC_CTRL3_WR(v)     (HW_LRADC_CTRL3.U = (v))
#define HW_LRADC_CTRL3_SET(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL3_SET_ADDR) = (v))
#define HW_LRADC_CTRL3_CLR(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL3_CLR_ADDR) = (v))
#define HW_LRADC_CTRL3_TOG(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL3_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_LRADC_CTRL3 bitfields
//

//--- Register HW_LRADC_CTRL3, field DISCARD

#define BP_LRADC_CTRL3_DISCARD      24
#define BM_LRADC_CTRL3_DISCARD      0x03000000

#define BF_LRADC_CTRL3_DISCARD(v)   (((v) << 24) & BM_LRADC_CTRL3_DISCARD)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL3_DISCARD(v)   BF_CS1(LRADC_CTRL3, DISCARD, v)
#endif

#define BV_LRADC_CTRL3_DISCARD__1_SAMPLE   0x1
#define BV_LRADC_CTRL3_DISCARD__2_SAMPLES  0x2
#define BV_LRADC_CTRL3_DISCARD__3_SAMPLES  0x3

//--- Register HW_LRADC_CTRL3, field FORCE_ANALOG_PWUP

#define BP_LRADC_CTRL3_FORCE_ANALOG_PWUP      23
#define BM_LRADC_CTRL3_FORCE_ANALOG_PWUP      0x00800000

#define BF_LRADC_CTRL3_FORCE_ANALOG_PWUP(v)   (((v) << 23) & BM_LRADC_CTRL3_FORCE_ANALOG_PWUP)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL3_FORCE_ANALOG_PWUP(v)   BF_CS1(LRADC_CTRL3, FORCE_ANALOG_PWUP, v)
#endif

#define BV_LRADC_CTRL3_FORCE_ANALOG_PWUP__OFF  0x0
#define BV_LRADC_CTRL3_FORCE_ANALOG_PWUP__ON   0x1

//--- Register HW_LRADC_CTRL3, field FORCE_ANALOG_PWDN

#define BP_LRADC_CTRL3_FORCE_ANALOG_PWDN      22
#define BM_LRADC_CTRL3_FORCE_ANALOG_PWDN      0x00400000

#define BF_LRADC_CTRL3_FORCE_ANALOG_PWDN(v)   (((v) << 22) & BM_LRADC_CTRL3_FORCE_ANALOG_PWDN)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL3_FORCE_ANALOG_PWDN(v)   BF_CS1(LRADC_CTRL3, FORCE_ANALOG_PWDN, v)
#endif

#define BV_LRADC_CTRL3_FORCE_ANALOG_PWDN__ON   0x0
#define BV_LRADC_CTRL3_FORCE_ANALOG_PWDN__OFF  0x1

//--- Register HW_LRADC_CTRL3, field CYCLE_TIME

#define BP_LRADC_CTRL3_CYCLE_TIME      8
#define BM_LRADC_CTRL3_CYCLE_TIME      0x00000300

#define BF_LRADC_CTRL3_CYCLE_TIME(v)   (((v) << 8) & BM_LRADC_CTRL3_CYCLE_TIME)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL3_CYCLE_TIME(v)   BF_CS1(LRADC_CTRL3, CYCLE_TIME, v)
#endif

#define BV_LRADC_CTRL3_CYCLE_TIME__6MHZ  0x0
#define BV_LRADC_CTRL3_CYCLE_TIME__4MHZ  0x1
#define BV_LRADC_CTRL3_CYCLE_TIME__3MHZ  0x2
#define BV_LRADC_CTRL3_CYCLE_TIME__2MHZ  0x3

//--- Register HW_LRADC_CTRL3, field HIGH_TIME

#define BP_LRADC_CTRL3_HIGH_TIME      4
#define BM_LRADC_CTRL3_HIGH_TIME      0x00000030

#define BF_LRADC_CTRL3_HIGH_TIME(v)   (((v) << 4) & BM_LRADC_CTRL3_HIGH_TIME)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL3_HIGH_TIME(v)   BF_CS1(LRADC_CTRL3, HIGH_TIME, v)
#endif

#define BV_LRADC_CTRL3_HIGH_TIME__42NS   0x0
#define BV_LRADC_CTRL3_HIGH_TIME__83NS   0x1
#define BV_LRADC_CTRL3_HIGH_TIME__125NS  0x2
#define BV_LRADC_CTRL3_HIGH_TIME__250NS  0x3

//--- Register HW_LRADC_CTRL3, field DELAY_CLOCK

#define BP_LRADC_CTRL3_DELAY_CLOCK      1
#define BM_LRADC_CTRL3_DELAY_CLOCK      0x00000002

#define BF_LRADC_CTRL3_DELAY_CLOCK(v)   (((v) << 1) & BM_LRADC_CTRL3_DELAY_CLOCK)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL3_DELAY_CLOCK(v)   BF_CS1(LRADC_CTRL3, DELAY_CLOCK, v)
#endif

#define BV_LRADC_CTRL3_DELAY_CLOCK__NORMAL   0x0
#define BV_LRADC_CTRL3_DELAY_CLOCK__DELAYED  0x1

//--- Register HW_LRADC_CTRL3, field INVERT_CLOCK

#define BP_LRADC_CTRL3_INVERT_CLOCK      0
#define BM_LRADC_CTRL3_INVERT_CLOCK      0x00000001

#define BF_LRADC_CTRL3_INVERT_CLOCK(v)   (((v) << 0) & BM_LRADC_CTRL3_INVERT_CLOCK)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL3_INVERT_CLOCK(v)   BF_CS1(LRADC_CTRL3, INVERT_CLOCK, v)
#endif

#define BV_LRADC_CTRL3_INVERT_CLOCK__NORMAL  0x0
#define BV_LRADC_CTRL3_INVERT_CLOCK__INVERT  0x1


////////////////////////////////////////////////////////////////////////////////
//// HW_LRADC_STATUS - LRADC Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TOUCH_DETECT_RAW     :  1;
        unsigned RSRVD2               : 15;
        unsigned CHANNEL0_PRESENT     :  1;
        unsigned CHANNEL1_PRESENT     :  1;
        unsigned CHANNEL2_PRESENT     :  1;
        unsigned CHANNEL3_PRESENT     :  1;
        unsigned CHANNEL4_PRESENT     :  1;
        unsigned CHANNEL5_PRESENT     :  1;
        unsigned CHANNEL6_PRESENT     :  1;
        unsigned CHANNEL7_PRESENT     :  1;
        unsigned TOUCH_PANEL_PRESENT  :  1;
        unsigned TEMP0_PRESENT        :  1;
        unsigned TEMP1_PRESENT        :  1;
        unsigned RSRVD3               :  5;
    } B;
} hw_lradc_status_t;
#endif


//
// constants & macros for entire HW_LRADC_STATUS register
//

#define HW_LRADC_STATUS_ADDR      (REGS_LRADC_BASE + 0x00000040)

#ifndef __LANGUAGE_ASM__
#define HW_LRADC_STATUS           (*(volatile hw_lradc_status_t *) HW_LRADC_STATUS_ADDR)
#define HW_LRADC_STATUS_RD()      (HW_LRADC_STATUS.U)
#endif


//
// constants & macros for individual HW_LRADC_STATUS bitfields
//

//--- Register HW_LRADC_STATUS, field TEMP1_PRESENT

#define BP_LRADC_STATUS_TEMP1_PRESENT      26
#define BM_LRADC_STATUS_TEMP1_PRESENT      0x04000000

#define BF_LRADC_STATUS_TEMP1_PRESENT(v)   (((v) << 26) & BM_LRADC_STATUS_TEMP1_PRESENT)

//--- Register HW_LRADC_STATUS, field TEMP0_PRESENT

#define BP_LRADC_STATUS_TEMP0_PRESENT      25
#define BM_LRADC_STATUS_TEMP0_PRESENT      0x02000000

#define BF_LRADC_STATUS_TEMP0_PRESENT(v)   (((v) << 25) & BM_LRADC_STATUS_TEMP0_PRESENT)

//--- Register HW_LRADC_STATUS, field TOUCH_PANEL_PRESENT

#define BP_LRADC_STATUS_TOUCH_PANEL_PRESENT      24
#define BM_LRADC_STATUS_TOUCH_PANEL_PRESENT      0x01000000

#define BF_LRADC_STATUS_TOUCH_PANEL_PRESENT(v)   (((v) << 24) & BM_LRADC_STATUS_TOUCH_PANEL_PRESENT)

//--- Register HW_LRADC_STATUS, field CHANNEL7_PRESENT

#define BP_LRADC_STATUS_CHANNEL7_PRESENT      23
#define BM_LRADC_STATUS_CHANNEL7_PRESENT      0x00800000

#define BF_LRADC_STATUS_CHANNEL7_PRESENT(v)   (((v) << 23) & BM_LRADC_STATUS_CHANNEL7_PRESENT)

//--- Register HW_LRADC_STATUS, field CHANNEL6_PRESENT

#define BP_LRADC_STATUS_CHANNEL6_PRESENT      22
#define BM_LRADC_STATUS_CHANNEL6_PRESENT      0x00400000

#define BF_LRADC_STATUS_CHANNEL6_PRESENT(v)   (((v) << 22) & BM_LRADC_STATUS_CHANNEL6_PRESENT)

//--- Register HW_LRADC_STATUS, field CHANNEL5_PRESENT

#define BP_LRADC_STATUS_CHANNEL5_PRESENT      21
#define BM_LRADC_STATUS_CHANNEL5_PRESENT      0x00200000

#define BF_LRADC_STATUS_CHANNEL5_PRESENT(v)   (((v) << 21) & BM_LRADC_STATUS_CHANNEL5_PRESENT)

//--- Register HW_LRADC_STATUS, field CHANNEL4_PRESENT

#define BP_LRADC_STATUS_CHANNEL4_PRESENT      20
#define BM_LRADC_STATUS_CHANNEL4_PRESENT      0x00100000

#define BF_LRADC_STATUS_CHANNEL4_PRESENT(v)   (((v) << 20) & BM_LRADC_STATUS_CHANNEL4_PRESENT)

//--- Register HW_LRADC_STATUS, field CHANNEL3_PRESENT

#define BP_LRADC_STATUS_CHANNEL3_PRESENT      19
#define BM_LRADC_STATUS_CHANNEL3_PRESENT      0x00080000

#define BF_LRADC_STATUS_CHANNEL3_PRESENT(v)   (((v) << 19) & BM_LRADC_STATUS_CHANNEL3_PRESENT)

//--- Register HW_LRADC_STATUS, field CHANNEL2_PRESENT

#define BP_LRADC_STATUS_CHANNEL2_PRESENT      18
#define BM_LRADC_STATUS_CHANNEL2_PRESENT      0x00040000

#define BF_LRADC_STATUS_CHANNEL2_PRESENT(v)   (((v) << 18) & BM_LRADC_STATUS_CHANNEL2_PRESENT)

//--- Register HW_LRADC_STATUS, field CHANNEL1_PRESENT

#define BP_LRADC_STATUS_CHANNEL1_PRESENT      17
#define BM_LRADC_STATUS_CHANNEL1_PRESENT      0x00020000

#define BF_LRADC_STATUS_CHANNEL1_PRESENT(v)   (((v) << 17) & BM_LRADC_STATUS_CHANNEL1_PRESENT)

//--- Register HW_LRADC_STATUS, field CHANNEL0_PRESENT

#define BP_LRADC_STATUS_CHANNEL0_PRESENT      16
#define BM_LRADC_STATUS_CHANNEL0_PRESENT      0x00010000

#define BF_LRADC_STATUS_CHANNEL0_PRESENT(v)   (((v) << 16) & BM_LRADC_STATUS_CHANNEL0_PRESENT)

//--- Register HW_LRADC_STATUS, field TOUCH_DETECT_RAW

#define BP_LRADC_STATUS_TOUCH_DETECT_RAW      0
#define BM_LRADC_STATUS_TOUCH_DETECT_RAW      0x00000001

#define BF_LRADC_STATUS_TOUCH_DETECT_RAW(v)   (((v) << 0) & BM_LRADC_STATUS_TOUCH_DETECT_RAW)

#define BV_LRADC_STATUS_TOUCH_DETECT_RAW__OPEN  0x0
#define BV_LRADC_STATUS_TOUCH_DETECT_RAW__HIT   0x1


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_LRADC_CHn : base 0x80050050 : count 6 : offset 0x10
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VALUE        : 18;
        unsigned RSRVD1       :  6;
        unsigned NUM_SAMPLES  :  5;
        unsigned ACCUMULATE   :  1;
        unsigned RSRVD2       :  1;
        unsigned TOGGLE       :  1;
    } B;
} hw_lradc_chn_t;
#endif


//
// constants & macros for entire HW_LRADC_CHn multi-register
//

#define HW_LRADC_CHn_COUNT        6
#define HW_LRADC_CHn_ADDR(n)      (REGS_LRADC_BASE + 0x00000050 + ((n) * 0x10))
#define HW_LRADC_CHn_SET_ADDR(n)  (REGS_LRADC_BASE + 0x00000054 + ((n) * 0x10))
#define HW_LRADC_CHn_CLR_ADDR(n)  (REGS_LRADC_BASE + 0x00000058 + ((n) * 0x10))
#define HW_LRADC_CHn_TOG_ADDR(n)  (REGS_LRADC_BASE + 0x0000005C + ((n) * 0x10))

#ifndef __LANGUAGE_ASM__
#define HW_LRADC_CHn(n)           (*(volatile hw_lradc_chn_t *) HW_LRADC_CHn_ADDR(n))
#define HW_LRADC_CHn_RD(n)        (HW_LRADC_CHn(n).U)
#define HW_LRADC_CHn_WR(n, v)     (HW_LRADC_CHn(n).U = (v))
#define HW_LRADC_CHn_SET(n, v)    ((*(volatile reg32_t *) HW_LRADC_CHn_SET_ADDR(n)) = (v))
#define HW_LRADC_CHn_CLR(n, v)    ((*(volatile reg32_t *) HW_LRADC_CHn_CLR_ADDR(n)) = (v))
#define HW_LRADC_CHn_TOG(n, v)    ((*(volatile reg32_t *) HW_LRADC_CHn_TOG_ADDR(n)) = (v))
#endif


//
// constants & macros for individual HW_LRADC_CHn multi-register bitfields
//

//--- Register HW_LRADC_CHn, field TOGGLE

#define BP_LRADC_CHn_TOGGLE      31
#define BM_LRADC_CHn_TOGGLE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_LRADC_CHn_TOGGLE(v)   ((((reg32_t) v) << 31) & BM_LRADC_CHn_TOGGLE)
#else
#define BF_LRADC_CHn_TOGGLE(v)   (((v) << 31) & BM_LRADC_CHn_TOGGLE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CHn_TOGGLE(n, v)  BF_CS1n(LRADC_CHn, n, TOGGLE, v)
#endif

//--- Register HW_LRADC_CHn, field ACCUMULATE

#define BP_LRADC_CHn_ACCUMULATE      29
#define BM_LRADC_CHn_ACCUMULATE      0x20000000

#define BF_LRADC_CHn_ACCUMULATE(v)   (((v) << 29) & BM_LRADC_CHn_ACCUMULATE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CHn_ACCUMULATE(n, v)  BF_CS1n(LRADC_CHn, n, ACCUMULATE, v)
#endif

//--- Register HW_LRADC_CHn, field NUM_SAMPLES

#define BP_LRADC_CHn_NUM_SAMPLES      24
#define BM_LRADC_CHn_NUM_SAMPLES      0x1F000000

#define BF_LRADC_CHn_NUM_SAMPLES(v)   (((v) << 24) & BM_LRADC_CHn_NUM_SAMPLES)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CHn_NUM_SAMPLES(n, v)  BF_CS1n(LRADC_CHn, n, NUM_SAMPLES, v)
#endif

//--- Register HW_LRADC_CHn, field VALUE

#define BP_LRADC_CHn_VALUE      0
#define BM_LRADC_CHn_VALUE      0x0003FFFF

#define BF_LRADC_CHn_VALUE(v)   (((v) << 0) & BM_LRADC_CHn_VALUE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CHn_VALUE(n, v)  BF_CS1n(LRADC_CHn, n, VALUE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_LRADC_CH6 - LRADC 6 (VddIO) Result Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VALUE        : 18;
        unsigned RSRVD1       :  6;
        unsigned NUM_SAMPLES  :  5;
        unsigned ACCUMULATE   :  1;
        unsigned RSRVD2       :  1;
        unsigned TOGGLE       :  1;
    } B;
} hw_lradc_ch6_t;
#endif


//
// constants & macros for entire HW_LRADC_CH6 register
//

#define HW_LRADC_CH6_ADDR      (REGS_LRADC_BASE + 0x000000B0)
#define HW_LRADC_CH6_SET_ADDR  (REGS_LRADC_BASE + 0x000000B4)
#define HW_LRADC_CH6_CLR_ADDR  (REGS_LRADC_BASE + 0x000000B8)
#define HW_LRADC_CH6_TOG_ADDR  (REGS_LRADC_BASE + 0x000000BC)

#ifndef __LANGUAGE_ASM__
#define HW_LRADC_CH6           (*(volatile hw_lradc_ch6_t *) HW_LRADC_CH6_ADDR)
#define HW_LRADC_CH6_RD()      (HW_LRADC_CH6.U)
#define HW_LRADC_CH6_WR(v)     (HW_LRADC_CH6.U = (v))
#define HW_LRADC_CH6_SET(v)    ((*(volatile reg32_t *) HW_LRADC_CH6_SET_ADDR) = (v))
#define HW_LRADC_CH6_CLR(v)    ((*(volatile reg32_t *) HW_LRADC_CH6_CLR_ADDR) = (v))
#define HW_LRADC_CH6_TOG(v)    ((*(volatile reg32_t *) HW_LRADC_CH6_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_LRADC_CH6 bitfields
//

//--- Register HW_LRADC_CH6, field TOGGLE

#define BP_LRADC_CH6_TOGGLE      31
#define BM_LRADC_CH6_TOGGLE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_LRADC_CH6_TOGGLE(v)   ((((reg32_t) v) << 31) & BM_LRADC_CH6_TOGGLE)
#else
#define BF_LRADC_CH6_TOGGLE(v)   (((v) << 31) & BM_LRADC_CH6_TOGGLE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CH6_TOGGLE(v)   BF_CS1(LRADC_CH6, TOGGLE, v)
#endif

//--- Register HW_LRADC_CH6, field ACCUMULATE

#define BP_LRADC_CH6_ACCUMULATE      29
#define BM_LRADC_CH6_ACCUMULATE      0x20000000

#define BF_LRADC_CH6_ACCUMULATE(v)   (((v) << 29) & BM_LRADC_CH6_ACCUMULATE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CH6_ACCUMULATE(v)   BF_CS1(LRADC_CH6, ACCUMULATE, v)
#endif

//--- Register HW_LRADC_CH6, field NUM_SAMPLES

#define BP_LRADC_CH6_NUM_SAMPLES      24
#define BM_LRADC_CH6_NUM_SAMPLES      0x1F000000

#define BF_LRADC_CH6_NUM_SAMPLES(v)   (((v) << 24) & BM_LRADC_CH6_NUM_SAMPLES)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CH6_NUM_SAMPLES(v)   BF_CS1(LRADC_CH6, NUM_SAMPLES, v)
#endif

//--- Register HW_LRADC_CH6, field VALUE

#define BP_LRADC_CH6_VALUE      0
#define BM_LRADC_CH6_VALUE      0x0003FFFF

#define BF_LRADC_CH6_VALUE(v)   (((v) << 0) & BM_LRADC_CH6_VALUE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CH6_VALUE(v)   BF_CS1(LRADC_CH6, VALUE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_LRADC_CH7 - LRADC 7 (BATT) Result Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VALUE            : 18;
        unsigned RSRVD1           :  6;
        unsigned NUM_SAMPLES      :  5;
        unsigned ACCUMULATE       :  1;
        unsigned TESTMODE_TOGGLE  :  1;
        unsigned TOGGLE           :  1;
    } B;
} hw_lradc_ch7_t;
#endif


//
// constants & macros for entire HW_LRADC_CH7 register
//

#define HW_LRADC_CH7_ADDR      (REGS_LRADC_BASE + 0x000000C0)
#define HW_LRADC_CH7_SET_ADDR  (REGS_LRADC_BASE + 0x000000C4)
#define HW_LRADC_CH7_CLR_ADDR  (REGS_LRADC_BASE + 0x000000C8)
#define HW_LRADC_CH7_TOG_ADDR  (REGS_LRADC_BASE + 0x000000CC)

#ifndef __LANGUAGE_ASM__
#define HW_LRADC_CH7           (*(volatile hw_lradc_ch7_t *) HW_LRADC_CH7_ADDR)
#define HW_LRADC_CH7_RD()      (HW_LRADC_CH7.U)
#define HW_LRADC_CH7_WR(v)     (HW_LRADC_CH7.U = (v))
#define HW_LRADC_CH7_SET(v)    ((*(volatile reg32_t *) HW_LRADC_CH7_SET_ADDR) = (v))
#define HW_LRADC_CH7_CLR(v)    ((*(volatile reg32_t *) HW_LRADC_CH7_CLR_ADDR) = (v))
#define HW_LRADC_CH7_TOG(v)    ((*(volatile reg32_t *) HW_LRADC_CH7_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_LRADC_CH7 bitfields
//

//--- Register HW_LRADC_CH7, field TOGGLE

#define BP_LRADC_CH7_TOGGLE      31
#define BM_LRADC_CH7_TOGGLE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_LRADC_CH7_TOGGLE(v)   ((((reg32_t) v) << 31) & BM_LRADC_CH7_TOGGLE)
#else
#define BF_LRADC_CH7_TOGGLE(v)   (((v) << 31) & BM_LRADC_CH7_TOGGLE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CH7_TOGGLE(v)   BF_CS1(LRADC_CH7, TOGGLE, v)
#endif

//--- Register HW_LRADC_CH7, field TESTMODE_TOGGLE

#define BP_LRADC_CH7_TESTMODE_TOGGLE      30
#define BM_LRADC_CH7_TESTMODE_TOGGLE      0x40000000

#define BF_LRADC_CH7_TESTMODE_TOGGLE(v)   (((v) << 30) & BM_LRADC_CH7_TESTMODE_TOGGLE)

//--- Register HW_LRADC_CH7, field ACCUMULATE

#define BP_LRADC_CH7_ACCUMULATE      29
#define BM_LRADC_CH7_ACCUMULATE      0x20000000

#define BF_LRADC_CH7_ACCUMULATE(v)   (((v) << 29) & BM_LRADC_CH7_ACCUMULATE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CH7_ACCUMULATE(v)   BF_CS1(LRADC_CH7, ACCUMULATE, v)
#endif

//--- Register HW_LRADC_CH7, field NUM_SAMPLES

#define BP_LRADC_CH7_NUM_SAMPLES      24
#define BM_LRADC_CH7_NUM_SAMPLES      0x1F000000

#define BF_LRADC_CH7_NUM_SAMPLES(v)   (((v) << 24) & BM_LRADC_CH7_NUM_SAMPLES)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CH7_NUM_SAMPLES(v)   BF_CS1(LRADC_CH7, NUM_SAMPLES, v)
#endif

//--- Register HW_LRADC_CH7, field VALUE

#define BP_LRADC_CH7_VALUE      0
#define BM_LRADC_CH7_VALUE      0x0003FFFF

#define BF_LRADC_CH7_VALUE(v)   (((v) << 0) & BM_LRADC_CH7_VALUE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CH7_VALUE(v)   BF_CS1(LRADC_CH7, VALUE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_LRADC_DELAYn : base 0x800500D0 : count 4 : offset 0x10
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DELAY           : 11;
        unsigned LOOP_COUNT      :  5;
        unsigned TRIGGER_DELAYS  :  4;
        unsigned KICK            :  1;
        unsigned RSRVD2          :  3;
        reg8_t   TRIGGER_LRADCS;
    } B;
} hw_lradc_delayn_t;
#endif


//
// constants & macros for entire HW_LRADC_DELAYn multi-register
//

#define HW_LRADC_DELAYn_COUNT        4
#define HW_LRADC_DELAYn_ADDR(n)      (REGS_LRADC_BASE + 0x000000D0 + ((n) * 0x10))
#define HW_LRADC_DELAYn_SET_ADDR(n)  (REGS_LRADC_BASE + 0x000000D4 + ((n) * 0x10))
#define HW_LRADC_DELAYn_CLR_ADDR(n)  (REGS_LRADC_BASE + 0x000000D8 + ((n) * 0x10))
#define HW_LRADC_DELAYn_TOG_ADDR(n)  (REGS_LRADC_BASE + 0x000000DC + ((n) * 0x10))

#ifndef __LANGUAGE_ASM__
#define HW_LRADC_DELAYn(n)           (*(volatile hw_lradc_delayn_t *) HW_LRADC_DELAYn_ADDR(n))
#define HW_LRADC_DELAYn_RD(n)        (HW_LRADC_DELAYn(n).U)
#define HW_LRADC_DELAYn_WR(n, v)     (HW_LRADC_DELAYn(n).U = (v))
#define HW_LRADC_DELAYn_SET(n, v)    ((*(volatile reg32_t *) HW_LRADC_DELAYn_SET_ADDR(n)) = (v))
#define HW_LRADC_DELAYn_CLR(n, v)    ((*(volatile reg32_t *) HW_LRADC_DELAYn_CLR_ADDR(n)) = (v))
#define HW_LRADC_DELAYn_TOG(n, v)    ((*(volatile reg32_t *) HW_LRADC_DELAYn_TOG_ADDR(n)) = (v))
#endif


//
// constants & macros for individual HW_LRADC_DELAYn multi-register bitfields
//

//--- Register HW_LRADC_DELAYn, field TRIGGER_LRADCS

#define BP_LRADC_DELAYn_TRIGGER_LRADCS      24
#define BM_LRADC_DELAYn_TRIGGER_LRADCS      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_LRADC_DELAYn_TRIGGER_LRADCS(v)   ((((reg32_t) v) << 24) & BM_LRADC_DELAYn_TRIGGER_LRADCS)
#else
#define BF_LRADC_DELAYn_TRIGGER_LRADCS(v)   (((v) << 24) & BM_LRADC_DELAYn_TRIGGER_LRADCS)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_DELAYn_TRIGGER_LRADCS(n, v)  (HW_LRADC_DELAYn(n).B.TRIGGER_LRADCS = (v))
#endif

//--- Register HW_LRADC_DELAYn, field KICK

#define BP_LRADC_DELAYn_KICK      20
#define BM_LRADC_DELAYn_KICK      0x00100000

#define BF_LRADC_DELAYn_KICK(v)   (((v) << 20) & BM_LRADC_DELAYn_KICK)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_DELAYn_KICK(n, v)  BF_CS1n(LRADC_DELAYn, n, KICK, v)
#endif

//--- Register HW_LRADC_DELAYn, field TRIGGER_DELAYS

#define BP_LRADC_DELAYn_TRIGGER_DELAYS      16
#define BM_LRADC_DELAYn_TRIGGER_DELAYS      0x000F0000

#define BF_LRADC_DELAYn_TRIGGER_DELAYS(v)   (((v) << 16) & BM_LRADC_DELAYn_TRIGGER_DELAYS)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_DELAYn_TRIGGER_DELAYS(n, v)  BF_CS1n(LRADC_DELAYn, n, TRIGGER_DELAYS, v)
#endif

//--- Register HW_LRADC_DELAYn, field LOOP_COUNT

#define BP_LRADC_DELAYn_LOOP_COUNT      11
#define BM_LRADC_DELAYn_LOOP_COUNT      0x0000F800

#define BF_LRADC_DELAYn_LOOP_COUNT(v)   (((v) << 11) & BM_LRADC_DELAYn_LOOP_COUNT)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_DELAYn_LOOP_COUNT(n, v)  BF_CS1n(LRADC_DELAYn, n, LOOP_COUNT, v)
#endif

//--- Register HW_LRADC_DELAYn, field DELAY

#define BP_LRADC_DELAYn_DELAY      0
#define BM_LRADC_DELAYn_DELAY      0x000007FF

#define BF_LRADC_DELAYn_DELAY(v)   (((v) << 0) & BM_LRADC_DELAYn_DELAY)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_DELAYn_DELAY(n, v)  BF_CS1n(LRADC_DELAYn, n, DELAY, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_LRADC_DEBUG0 - LRADC Debug Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned STATE     : 12;
        unsigned RSRVD1    :  4;
        reg16_t  READONLY;
    } B;
} hw_lradc_debug0_t;
#endif


//
// constants & macros for entire HW_LRADC_DEBUG0 register
//

#define HW_LRADC_DEBUG0_ADDR      (REGS_LRADC_BASE + 0x00000110)

#ifndef __LANGUAGE_ASM__
#define HW_LRADC_DEBUG0           (*(volatile hw_lradc_debug0_t *) HW_LRADC_DEBUG0_ADDR)
#define HW_LRADC_DEBUG0_RD()      (HW_LRADC_DEBUG0.U)
#endif


//
// constants & macros for individual HW_LRADC_DEBUG0 bitfields
//

//--- Register HW_LRADC_DEBUG0, field READONLY

#define BP_LRADC_DEBUG0_READONLY      16
#define BM_LRADC_DEBUG0_READONLY      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_LRADC_DEBUG0_READONLY(v)   ((((reg32_t) v) << 16) & BM_LRADC_DEBUG0_READONLY)
#else
#define BF_LRADC_DEBUG0_READONLY(v)   (((v) << 16) & BM_LRADC_DEBUG0_READONLY)
#endif

//--- Register HW_LRADC_DEBUG0, field STATE

#define BP_LRADC_DEBUG0_STATE      0
#define BM_LRADC_DEBUG0_STATE      0x00000FFF

#define BF_LRADC_DEBUG0_STATE(v)   (((v) << 0) & BM_LRADC_DEBUG0_STATE)


////////////////////////////////////////////////////////////////////////////////
//// HW_LRADC_DEBUG1 - LRADC Debug Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TESTMODE        :  1;
        unsigned TESTMODE5       :  1;
        unsigned TESTMODE6       :  1;
        unsigned RSRVD1          :  5;
        unsigned TESTMODE_COUNT  :  5;
        unsigned RSRVD2          :  3;
        reg8_t   REQUEST;
        reg8_t   RSRVD3;
    } B;
} hw_lradc_debug1_t;
#endif


//
// constants & macros for entire HW_LRADC_DEBUG1 register
//

#define HW_LRADC_DEBUG1_ADDR      (REGS_LRADC_BASE + 0x00000120)
#define HW_LRADC_DEBUG1_SET_ADDR  (REGS_LRADC_BASE + 0x00000124)
#define HW_LRADC_DEBUG1_CLR_ADDR  (REGS_LRADC_BASE + 0x00000128)
#define HW_LRADC_DEBUG1_TOG_ADDR  (REGS_LRADC_BASE + 0x0000012C)

#ifndef __LANGUAGE_ASM__
#define HW_LRADC_DEBUG1           (*(volatile hw_lradc_debug1_t *) HW_LRADC_DEBUG1_ADDR)
#define HW_LRADC_DEBUG1_RD()      (HW_LRADC_DEBUG1.U)
#define HW_LRADC_DEBUG1_WR(v)     (HW_LRADC_DEBUG1.U = (v))
#define HW_LRADC_DEBUG1_SET(v)    ((*(volatile reg32_t *) HW_LRADC_DEBUG1_SET_ADDR) = (v))
#define HW_LRADC_DEBUG1_CLR(v)    ((*(volatile reg32_t *) HW_LRADC_DEBUG1_CLR_ADDR) = (v))
#define HW_LRADC_DEBUG1_TOG(v)    ((*(volatile reg32_t *) HW_LRADC_DEBUG1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_LRADC_DEBUG1 bitfields
//

//--- Register HW_LRADC_DEBUG1, field REQUEST

#define BP_LRADC_DEBUG1_REQUEST      16
#define BM_LRADC_DEBUG1_REQUEST      0x00FF0000

#define BF_LRADC_DEBUG1_REQUEST(v)   (((v) << 16) & BM_LRADC_DEBUG1_REQUEST)

//--- Register HW_LRADC_DEBUG1, field TESTMODE_COUNT

#define BP_LRADC_DEBUG1_TESTMODE_COUNT      8
#define BM_LRADC_DEBUG1_TESTMODE_COUNT      0x00001F00

#define BF_LRADC_DEBUG1_TESTMODE_COUNT(v)   (((v) << 8) & BM_LRADC_DEBUG1_TESTMODE_COUNT)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_DEBUG1_TESTMODE_COUNT(v)   BF_CS1(LRADC_DEBUG1, TESTMODE_COUNT, v)
#endif

//--- Register HW_LRADC_DEBUG1, field TESTMODE6

#define BP_LRADC_DEBUG1_TESTMODE6      2
#define BM_LRADC_DEBUG1_TESTMODE6      0x00000004

#define BF_LRADC_DEBUG1_TESTMODE6(v)   (((v) << 2) & BM_LRADC_DEBUG1_TESTMODE6)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_DEBUG1_TESTMODE6(v)   BF_CS1(LRADC_DEBUG1, TESTMODE6, v)
#endif

#define BV_LRADC_DEBUG1_TESTMODE6__NORMAL  0x0
#define BV_LRADC_DEBUG1_TESTMODE6__TEST    0x1

//--- Register HW_LRADC_DEBUG1, field TESTMODE5

#define BP_LRADC_DEBUG1_TESTMODE5      1
#define BM_LRADC_DEBUG1_TESTMODE5      0x00000002

#define BF_LRADC_DEBUG1_TESTMODE5(v)   (((v) << 1) & BM_LRADC_DEBUG1_TESTMODE5)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_DEBUG1_TESTMODE5(v)   BF_CS1(LRADC_DEBUG1, TESTMODE5, v)
#endif

#define BV_LRADC_DEBUG1_TESTMODE5__NORMAL  0x0
#define BV_LRADC_DEBUG1_TESTMODE5__TEST    0x1

//--- Register HW_LRADC_DEBUG1, field TESTMODE

#define BP_LRADC_DEBUG1_TESTMODE      0
#define BM_LRADC_DEBUG1_TESTMODE      0x00000001

#define BF_LRADC_DEBUG1_TESTMODE(v)   (((v) << 0) & BM_LRADC_DEBUG1_TESTMODE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_DEBUG1_TESTMODE(v)   BF_CS1(LRADC_DEBUG1, TESTMODE, v)
#endif

#define BV_LRADC_DEBUG1_TESTMODE__NORMAL  0x0
#define BV_LRADC_DEBUG1_TESTMODE__TEST    0x1


////////////////////////////////////////////////////////////////////////////////
//// HW_LRADC_CONVERSION - LRADC Battery Conversion Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SCALED_BATT_VOLTAGE  : 10;
        unsigned RSRVD1               :  6;
        unsigned SCALE_FACTOR         :  2;
        unsigned RSRVD2               :  2;
        unsigned AUTOMATIC            :  1;
        unsigned RSRVD3               : 11;
    } B;
} hw_lradc_conversion_t;
#endif


//
// constants & macros for entire HW_LRADC_CONVERSION register
//

#define HW_LRADC_CONVERSION_ADDR      (REGS_LRADC_BASE + 0x00000130)
#define HW_LRADC_CONVERSION_SET_ADDR  (REGS_LRADC_BASE + 0x00000134)
#define HW_LRADC_CONVERSION_CLR_ADDR  (REGS_LRADC_BASE + 0x00000138)
#define HW_LRADC_CONVERSION_TOG_ADDR  (REGS_LRADC_BASE + 0x0000013C)

#ifndef __LANGUAGE_ASM__
#define HW_LRADC_CONVERSION           (*(volatile hw_lradc_conversion_t *) HW_LRADC_CONVERSION_ADDR)
#define HW_LRADC_CONVERSION_RD()      (HW_LRADC_CONVERSION.U)
#define HW_LRADC_CONVERSION_WR(v)     (HW_LRADC_CONVERSION.U = (v))
#define HW_LRADC_CONVERSION_SET(v)    ((*(volatile reg32_t *) HW_LRADC_CONVERSION_SET_ADDR) = (v))
#define HW_LRADC_CONVERSION_CLR(v)    ((*(volatile reg32_t *) HW_LRADC_CONVERSION_CLR_ADDR) = (v))
#define HW_LRADC_CONVERSION_TOG(v)    ((*(volatile reg32_t *) HW_LRADC_CONVERSION_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_LRADC_CONVERSION bitfields
//

//--- Register HW_LRADC_CONVERSION, field AUTOMATIC

#define BP_LRADC_CONVERSION_AUTOMATIC      20
#define BM_LRADC_CONVERSION_AUTOMATIC      0x00100000

#define BF_LRADC_CONVERSION_AUTOMATIC(v)   (((v) << 20) & BM_LRADC_CONVERSION_AUTOMATIC)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CONVERSION_AUTOMATIC(v)   BF_CS1(LRADC_CONVERSION, AUTOMATIC, v)
#endif

#define BV_LRADC_CONVERSION_AUTOMATIC__DISABLE  0x0
#define BV_LRADC_CONVERSION_AUTOMATIC__ENABLE   0x1

//--- Register HW_LRADC_CONVERSION, field SCALE_FACTOR

#define BP_LRADC_CONVERSION_SCALE_FACTOR      16
#define BM_LRADC_CONVERSION_SCALE_FACTOR      0x00030000

#define BF_LRADC_CONVERSION_SCALE_FACTOR(v)   (((v) << 16) & BM_LRADC_CONVERSION_SCALE_FACTOR)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CONVERSION_SCALE_FACTOR(v)   BF_CS1(LRADC_CONVERSION, SCALE_FACTOR, v)
#endif

#define BV_LRADC_CONVERSION_SCALE_FACTOR__NIMH        0x0
#define BV_LRADC_CONVERSION_SCALE_FACTOR__DUAL_NIMH   0x1
#define BV_LRADC_CONVERSION_SCALE_FACTOR__LI_ION      0x2
#define BV_LRADC_CONVERSION_SCALE_FACTOR__ALT_LI_ION  0x3

//--- Register HW_LRADC_CONVERSION, field SCALED_BATT_VOLTAGE

#define BP_LRADC_CONVERSION_SCALED_BATT_VOLTAGE      0
#define BM_LRADC_CONVERSION_SCALED_BATT_VOLTAGE      0x000003FF

#define BF_LRADC_CONVERSION_SCALED_BATT_VOLTAGE(v)   (((v) << 0) & BM_LRADC_CONVERSION_SCALED_BATT_VOLTAGE)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CONVERSION_SCALED_BATT_VOLTAGE(v)   BF_CS1(LRADC_CONVERSION, SCALED_BATT_VOLTAGE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_LRADC_CTRL4 - LRADC Control Register 4
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LRADC0SELECT  :  4;
        unsigned LRADC1SELECT  :  4;
        unsigned LRADC2SELECT  :  4;
        unsigned LRADC3SELECT  :  4;
        unsigned LRADC4SELECT  :  4;
        unsigned LRADC5SELECT  :  4;
        unsigned LRADC6SELECT  :  4;
        unsigned LRADC7SELECT  :  4;
    } B;
} hw_lradc_ctrl4_t;
#endif


//
// constants & macros for entire HW_LRADC_CTRL4 register
//

#define HW_LRADC_CTRL4_ADDR      (REGS_LRADC_BASE + 0x00000140)
#define HW_LRADC_CTRL4_SET_ADDR  (REGS_LRADC_BASE + 0x00000144)
#define HW_LRADC_CTRL4_CLR_ADDR  (REGS_LRADC_BASE + 0x00000148)
#define HW_LRADC_CTRL4_TOG_ADDR  (REGS_LRADC_BASE + 0x0000014C)

#ifndef __LANGUAGE_ASM__
#define HW_LRADC_CTRL4           (*(volatile hw_lradc_ctrl4_t *) HW_LRADC_CTRL4_ADDR)
#define HW_LRADC_CTRL4_RD()      (HW_LRADC_CTRL4.U)
#define HW_LRADC_CTRL4_WR(v)     (HW_LRADC_CTRL4.U = (v))
#define HW_LRADC_CTRL4_SET(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL4_SET_ADDR) = (v))
#define HW_LRADC_CTRL4_CLR(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL4_CLR_ADDR) = (v))
#define HW_LRADC_CTRL4_TOG(v)    ((*(volatile reg32_t *) HW_LRADC_CTRL4_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_LRADC_CTRL4 bitfields
//

//--- Register HW_LRADC_CTRL4, field LRADC7SELECT

#define BP_LRADC_CTRL4_LRADC7SELECT      28
#define BM_LRADC_CTRL4_LRADC7SELECT      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_LRADC_CTRL4_LRADC7SELECT(v)   ((((reg32_t) v) << 28) & BM_LRADC_CTRL4_LRADC7SELECT)
#else
#define BF_LRADC_CTRL4_LRADC7SELECT(v)   (((v) << 28) & BM_LRADC_CTRL4_LRADC7SELECT)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL4_LRADC7SELECT(v)   BF_CS1(LRADC_CTRL4, LRADC7SELECT, v)
#endif

#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL0   0x0
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL1   0x1
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL2   0x2
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL3   0x3
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL4   0x4
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL5   0x5
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL6   0x6
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL7   0x7
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL8   0x8
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL9   0x9
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL10  0xA
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL11  0xB
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL12  0xC
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL13  0xD
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL14  0xE
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL15  0xF

//--- Register HW_LRADC_CTRL4, field LRADC6SELECT

#define BP_LRADC_CTRL4_LRADC6SELECT      24
#define BM_LRADC_CTRL4_LRADC6SELECT      0x0F000000

#define BF_LRADC_CTRL4_LRADC6SELECT(v)   (((v) << 24) & BM_LRADC_CTRL4_LRADC6SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL4_LRADC6SELECT(v)   BF_CS1(LRADC_CTRL4, LRADC6SELECT, v)
#endif

#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL0   0x0
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL1   0x1
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL2   0x2
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL3   0x3
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL4   0x4
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL5   0x5
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL6   0x6
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL7   0x7
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL8   0x8
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL9   0x9
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL10  0xA
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL11  0xB
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL12  0xC
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL13  0xD
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL14  0xE
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL15  0xF

//--- Register HW_LRADC_CTRL4, field LRADC5SELECT

#define BP_LRADC_CTRL4_LRADC5SELECT      20
#define BM_LRADC_CTRL4_LRADC5SELECT      0x00F00000

#define BF_LRADC_CTRL4_LRADC5SELECT(v)   (((v) << 20) & BM_LRADC_CTRL4_LRADC5SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL4_LRADC5SELECT(v)   BF_CS1(LRADC_CTRL4, LRADC5SELECT, v)
#endif

#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL0   0x0
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL1   0x1
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL2   0x2
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL3   0x3
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL4   0x4
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL5   0x5
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL6   0x6
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL7   0x7
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL8   0x8
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL9   0x9
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL10  0xA
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL11  0xB
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL12  0xC
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL13  0xD
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL14  0xE
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL15  0xF

//--- Register HW_LRADC_CTRL4, field LRADC4SELECT

#define BP_LRADC_CTRL4_LRADC4SELECT      16
#define BM_LRADC_CTRL4_LRADC4SELECT      0x000F0000

#define BF_LRADC_CTRL4_LRADC4SELECT(v)   (((v) << 16) & BM_LRADC_CTRL4_LRADC4SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL4_LRADC4SELECT(v)   BF_CS1(LRADC_CTRL4, LRADC4SELECT, v)
#endif

#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL0   0x0
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL1   0x1
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL2   0x2
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL3   0x3
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL4   0x4
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL5   0x5
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL6   0x6
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL7   0x7
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL8   0x8
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL9   0x9
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL10  0xA
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL11  0xB
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL12  0xC
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL13  0xD
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL14  0xE
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL15  0xF

//--- Register HW_LRADC_CTRL4, field LRADC3SELECT

#define BP_LRADC_CTRL4_LRADC3SELECT      12
#define BM_LRADC_CTRL4_LRADC3SELECT      0x0000F000

#define BF_LRADC_CTRL4_LRADC3SELECT(v)   (((v) << 12) & BM_LRADC_CTRL4_LRADC3SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL4_LRADC3SELECT(v)   BF_CS1(LRADC_CTRL4, LRADC3SELECT, v)
#endif

#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL0   0x0
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL1   0x1
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL2   0x2
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL3   0x3
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL4   0x4
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL5   0x5
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL6   0x6
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL7   0x7
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL8   0x8
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL9   0x9
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL10  0xA
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL11  0xB
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL12  0xC
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL13  0xD
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL14  0xE
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL15  0xF

//--- Register HW_LRADC_CTRL4, field LRADC2SELECT

#define BP_LRADC_CTRL4_LRADC2SELECT      8
#define BM_LRADC_CTRL4_LRADC2SELECT      0x00000F00

#define BF_LRADC_CTRL4_LRADC2SELECT(v)   (((v) << 8) & BM_LRADC_CTRL4_LRADC2SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL4_LRADC2SELECT(v)   BF_CS1(LRADC_CTRL4, LRADC2SELECT, v)
#endif

#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL0   0x0
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL1   0x1
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL2   0x2
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL3   0x3
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL4   0x4
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL5   0x5
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL6   0x6
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL7   0x7
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL8   0x8
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL9   0x9
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL10  0xA
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL11  0xB
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL12  0xC
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL13  0xD
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL14  0xE
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL15  0xF

//--- Register HW_LRADC_CTRL4, field LRADC1SELECT

#define BP_LRADC_CTRL4_LRADC1SELECT      4
#define BM_LRADC_CTRL4_LRADC1SELECT      0x000000F0

#define BF_LRADC_CTRL4_LRADC1SELECT(v)   (((v) << 4) & BM_LRADC_CTRL4_LRADC1SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL4_LRADC1SELECT(v)   BF_CS1(LRADC_CTRL4, LRADC1SELECT, v)
#endif

#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL0   0x0
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL1   0x1
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL2   0x2
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL3   0x3
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL4   0x4
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL5   0x5
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL6   0x6
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL7   0x7
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL8   0x8
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL9   0x9
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL10  0xA
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL11  0xB
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL12  0xC
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL13  0xD
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL14  0xE
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL15  0xF

//--- Register HW_LRADC_CTRL4, field LRADC0SELECT

#define BP_LRADC_CTRL4_LRADC0SELECT      0
#define BM_LRADC_CTRL4_LRADC0SELECT      0x0000000F

#define BF_LRADC_CTRL4_LRADC0SELECT(v)   (((v) << 0) & BM_LRADC_CTRL4_LRADC0SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_LRADC_CTRL4_LRADC0SELECT(v)   BF_CS1(LRADC_CTRL4, LRADC0SELECT, v)
#endif

#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL0   0x0
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL1   0x1
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL2   0x2
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL3   0x3
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL4   0x4
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL5   0x5
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL6   0x6
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL7   0x7
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL8   0x8
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL9   0x9
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL10  0xA
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL11  0xB
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL12  0xC
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL13  0xD
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL14  0xE
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL15  0xF


////////////////////////////////////////////////////////////////////////////////
//// HW_LRADC_VERSION - LRADC Version Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  STEP;
        reg8_t   MINOR;
        reg8_t   MAJOR;
    } B;
} hw_lradc_version_t;
#endif


//
// constants & macros for entire HW_LRADC_VERSION register
//

#define HW_LRADC_VERSION_ADDR      (REGS_LRADC_BASE + 0x00000150)

#ifndef __LANGUAGE_ASM__
#define HW_LRADC_VERSION           (*(volatile hw_lradc_version_t *) HW_LRADC_VERSION_ADDR)
#define HW_LRADC_VERSION_RD()      (HW_LRADC_VERSION.U)
#endif


//
// constants & macros for individual HW_LRADC_VERSION bitfields
//

//--- Register HW_LRADC_VERSION, field MAJOR

#define BP_LRADC_VERSION_MAJOR      24
#define BM_LRADC_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_LRADC_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_LRADC_VERSION_MAJOR)
#else
#define BF_LRADC_VERSION_MAJOR(v)   (((v) << 24) & BM_LRADC_VERSION_MAJOR)
#endif

//--- Register HW_LRADC_VERSION, field MINOR

#define BP_LRADC_VERSION_MINOR      16
#define BM_LRADC_VERSION_MINOR      0x00FF0000

#define BF_LRADC_VERSION_MINOR(v)   (((v) << 16) & BM_LRADC_VERSION_MINOR)

//--- Register HW_LRADC_VERSION, field STEP

#define BP_LRADC_VERSION_STEP      0
#define BM_LRADC_VERSION_STEP      0x0000FFFF

#define BF_LRADC_VERSION_STEP(v)   (((v) << 0) & BM_LRADC_VERSION_STEP)


#endif // _REGSLRADC_H

////////////////////////////////////////////////////////////////////////////////
