/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSUSBCTRL_H
#define _REGSUSBCTRL_H  1

#include "regs.h"

#ifndef REGS_USBCTRL_BASE
#define REGS_USBCTRL_BASE (REGS_BASE + 0x00080000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_ID - Identification Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ID         :  6;
        unsigned RSVD0      :  2;
        unsigned NID        :  6;
        unsigned RSVD1      :  2;
        unsigned TAG        :  5;
        unsigned REVISION   :  4;
        unsigned VERSION    :  4;
        unsigned CIVERSION  :  3;
    } B;
} hw_usbctrl_id_t;
#endif


//
// constants & macros for entire HW_USBCTRL_ID register
//

#define HW_USBCTRL_ID_ADDR      (REGS_USBCTRL_BASE + 0x00000000)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_ID           (*(volatile hw_usbctrl_id_t *) HW_USBCTRL_ID_ADDR)
#define HW_USBCTRL_ID_RD()      (HW_USBCTRL_ID.U)
#endif


//
// constants & macros for individual HW_USBCTRL_ID bitfields
//

//--- Register HW_USBCTRL_ID, field CIVERSION

#define BP_USBCTRL_ID_CIVERSION      29
#define BM_USBCTRL_ID_CIVERSION      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_USBCTRL_ID_CIVERSION(v)   ((((reg32_t) v) << 29) & BM_USBCTRL_ID_CIVERSION)
#else
#define BF_USBCTRL_ID_CIVERSION(v)   (((v) << 29) & BM_USBCTRL_ID_CIVERSION)
#endif

//--- Register HW_USBCTRL_ID, field VERSION

#define BP_USBCTRL_ID_VERSION      25
#define BM_USBCTRL_ID_VERSION      0x1E000000

#define BF_USBCTRL_ID_VERSION(v)   (((v) << 25) & BM_USBCTRL_ID_VERSION)

//--- Register HW_USBCTRL_ID, field REVISION

#define BP_USBCTRL_ID_REVISION      21
#define BM_USBCTRL_ID_REVISION      0x01E00000

#define BF_USBCTRL_ID_REVISION(v)   (((v) << 21) & BM_USBCTRL_ID_REVISION)

//--- Register HW_USBCTRL_ID, field TAG

#define BP_USBCTRL_ID_TAG      16
#define BM_USBCTRL_ID_TAG      0x001F0000

#define BF_USBCTRL_ID_TAG(v)   (((v) << 16) & BM_USBCTRL_ID_TAG)

//--- Register HW_USBCTRL_ID, field NID

#define BP_USBCTRL_ID_NID      8
#define BM_USBCTRL_ID_NID      0x00003F00

#define BF_USBCTRL_ID_NID(v)   (((v) << 8) & BM_USBCTRL_ID_NID)

//--- Register HW_USBCTRL_ID, field ID

#define BP_USBCTRL_ID_ID      0
#define BM_USBCTRL_ID_ID      0x0000003F

#define BF_USBCTRL_ID_ID(v)   (((v) << 0) & BM_USBCTRL_ID_ID)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_HWGENERAL - General Hardware Parameters Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RT    :  1;
        unsigned CLKC  :  2;
        unsigned BWT   :  1;
        unsigned PHYW  :  2;
        unsigned PHYM  :  3;
        unsigned SM    :  2;
        unsigned RSVD  : 21;
    } B;
} hw_usbctrl_hwgeneral_t;
#endif


//
// constants & macros for entire HW_USBCTRL_HWGENERAL register
//

#define HW_USBCTRL_HWGENERAL_ADDR      (REGS_USBCTRL_BASE + 0x00000004)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_HWGENERAL           (*(volatile hw_usbctrl_hwgeneral_t *) HW_USBCTRL_HWGENERAL_ADDR)
#define HW_USBCTRL_HWGENERAL_RD()      (HW_USBCTRL_HWGENERAL.U)
#endif


//
// constants & macros for individual HW_USBCTRL_HWGENERAL bitfields
//

//--- Register HW_USBCTRL_HWGENERAL, field SM

#define BP_USBCTRL_HWGENERAL_SM      9
#define BM_USBCTRL_HWGENERAL_SM      0x00000600

#define BF_USBCTRL_HWGENERAL_SM(v)   (((v) << 9) & BM_USBCTRL_HWGENERAL_SM)

//--- Register HW_USBCTRL_HWGENERAL, field PHYM

#define BP_USBCTRL_HWGENERAL_PHYM      6
#define BM_USBCTRL_HWGENERAL_PHYM      0x000001C0

#define BF_USBCTRL_HWGENERAL_PHYM(v)   (((v) << 6) & BM_USBCTRL_HWGENERAL_PHYM)

//--- Register HW_USBCTRL_HWGENERAL, field PHYW

#define BP_USBCTRL_HWGENERAL_PHYW      4
#define BM_USBCTRL_HWGENERAL_PHYW      0x00000030

#define BF_USBCTRL_HWGENERAL_PHYW(v)   (((v) << 4) & BM_USBCTRL_HWGENERAL_PHYW)

//--- Register HW_USBCTRL_HWGENERAL, field BWT

#define BP_USBCTRL_HWGENERAL_BWT      3
#define BM_USBCTRL_HWGENERAL_BWT      0x00000008

#define BF_USBCTRL_HWGENERAL_BWT(v)   (((v) << 3) & BM_USBCTRL_HWGENERAL_BWT)

//--- Register HW_USBCTRL_HWGENERAL, field CLKC

#define BP_USBCTRL_HWGENERAL_CLKC      1
#define BM_USBCTRL_HWGENERAL_CLKC      0x00000006

#define BF_USBCTRL_HWGENERAL_CLKC(v)   (((v) << 1) & BM_USBCTRL_HWGENERAL_CLKC)

//--- Register HW_USBCTRL_HWGENERAL, field RT

#define BP_USBCTRL_HWGENERAL_RT      0
#define BM_USBCTRL_HWGENERAL_RT      0x00000001

#define BF_USBCTRL_HWGENERAL_RT(v)   (((v) << 0) & BM_USBCTRL_HWGENERAL_RT)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_HWHOST - Host Hardware Parameters Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned HC     :  1;
        unsigned NPORT  :  3;
        unsigned RSVD   : 12;
        reg8_t   TTASY;
        reg8_t   TTPER;
    } B;
} hw_usbctrl_hwhost_t;
#endif


//
// constants & macros for entire HW_USBCTRL_HWHOST register
//

#define HW_USBCTRL_HWHOST_ADDR      (REGS_USBCTRL_BASE + 0x00000008)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_HWHOST           (*(volatile hw_usbctrl_hwhost_t *) HW_USBCTRL_HWHOST_ADDR)
#define HW_USBCTRL_HWHOST_RD()      (HW_USBCTRL_HWHOST.U)
#endif


//
// constants & macros for individual HW_USBCTRL_HWHOST bitfields
//

//--- Register HW_USBCTRL_HWHOST, field TTPER

#define BP_USBCTRL_HWHOST_TTPER      24
#define BM_USBCTRL_HWHOST_TTPER      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_USBCTRL_HWHOST_TTPER(v)   ((((reg32_t) v) << 24) & BM_USBCTRL_HWHOST_TTPER)
#else
#define BF_USBCTRL_HWHOST_TTPER(v)   (((v) << 24) & BM_USBCTRL_HWHOST_TTPER)
#endif

//--- Register HW_USBCTRL_HWHOST, field TTASY

#define BP_USBCTRL_HWHOST_TTASY      16
#define BM_USBCTRL_HWHOST_TTASY      0x00FF0000

#define BF_USBCTRL_HWHOST_TTASY(v)   (((v) << 16) & BM_USBCTRL_HWHOST_TTASY)

//--- Register HW_USBCTRL_HWHOST, field NPORT

#define BP_USBCTRL_HWHOST_NPORT      1
#define BM_USBCTRL_HWHOST_NPORT      0x0000000E

#define BF_USBCTRL_HWHOST_NPORT(v)   (((v) << 1) & BM_USBCTRL_HWHOST_NPORT)

//--- Register HW_USBCTRL_HWHOST, field HC

#define BP_USBCTRL_HWHOST_HC      0
#define BM_USBCTRL_HWHOST_HC      0x00000001

#define BF_USBCTRL_HWHOST_HC(v)   (((v) << 0) & BM_USBCTRL_HWHOST_HC)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_HWDEVICE - Device Hardware Parameters Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DC     :  1;
        unsigned DEVEP  :  5;
        unsigned RSVD   : 26;
    } B;
} hw_usbctrl_hwdevice_t;
#endif


//
// constants & macros for entire HW_USBCTRL_HWDEVICE register
//

#define HW_USBCTRL_HWDEVICE_ADDR      (REGS_USBCTRL_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_HWDEVICE           (*(volatile hw_usbctrl_hwdevice_t *) HW_USBCTRL_HWDEVICE_ADDR)
#define HW_USBCTRL_HWDEVICE_RD()      (HW_USBCTRL_HWDEVICE.U)
#endif


//
// constants & macros for individual HW_USBCTRL_HWDEVICE bitfields
//

//--- Register HW_USBCTRL_HWDEVICE, field DEVEP

#define BP_USBCTRL_HWDEVICE_DEVEP      1
#define BM_USBCTRL_HWDEVICE_DEVEP      0x0000003E

#define BF_USBCTRL_HWDEVICE_DEVEP(v)   (((v) << 1) & BM_USBCTRL_HWDEVICE_DEVEP)

//--- Register HW_USBCTRL_HWDEVICE, field DC

#define BP_USBCTRL_HWDEVICE_DC      0
#define BM_USBCTRL_HWDEVICE_DC      0x00000001

#define BF_USBCTRL_HWDEVICE_DC(v)   (((v) << 0) & BM_USBCTRL_HWDEVICE_DC)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_HWTXBUF - TX Buffer Hardware Parameters Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   TXBURST;
        reg8_t   TXADD;
        reg8_t   TXCHANADD;
        unsigned RSVD       :  7;
        unsigned TXLCR      :  1;
    } B;
} hw_usbctrl_hwtxbuf_t;
#endif


//
// constants & macros for entire HW_USBCTRL_HWTXBUF register
//

#define HW_USBCTRL_HWTXBUF_ADDR      (REGS_USBCTRL_BASE + 0x00000010)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_HWTXBUF           (*(volatile hw_usbctrl_hwtxbuf_t *) HW_USBCTRL_HWTXBUF_ADDR)
#define HW_USBCTRL_HWTXBUF_RD()      (HW_USBCTRL_HWTXBUF.U)
#endif


//
// constants & macros for individual HW_USBCTRL_HWTXBUF bitfields
//

//--- Register HW_USBCTRL_HWTXBUF, field TXLCR

#define BP_USBCTRL_HWTXBUF_TXLCR      31
#define BM_USBCTRL_HWTXBUF_TXLCR      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_USBCTRL_HWTXBUF_TXLCR(v)   ((((reg32_t) v) << 31) & BM_USBCTRL_HWTXBUF_TXLCR)
#else
#define BF_USBCTRL_HWTXBUF_TXLCR(v)   (((v) << 31) & BM_USBCTRL_HWTXBUF_TXLCR)
#endif

//--- Register HW_USBCTRL_HWTXBUF, field TXCHANADD

#define BP_USBCTRL_HWTXBUF_TXCHANADD      16
#define BM_USBCTRL_HWTXBUF_TXCHANADD      0x00FF0000

#define BF_USBCTRL_HWTXBUF_TXCHANADD(v)   (((v) << 16) & BM_USBCTRL_HWTXBUF_TXCHANADD)

//--- Register HW_USBCTRL_HWTXBUF, field TXADD

#define BP_USBCTRL_HWTXBUF_TXADD      8
#define BM_USBCTRL_HWTXBUF_TXADD      0x0000FF00

#define BF_USBCTRL_HWTXBUF_TXADD(v)   (((v) << 8) & BM_USBCTRL_HWTXBUF_TXADD)

//--- Register HW_USBCTRL_HWTXBUF, field TXBURST

#define BP_USBCTRL_HWTXBUF_TXBURST      0
#define BM_USBCTRL_HWTXBUF_TXBURST      0x000000FF

#define BF_USBCTRL_HWTXBUF_TXBURST(v)   (((v) << 0) & BM_USBCTRL_HWTXBUF_TXBURST)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_HWRXBUF - RX Buffer Hardware Parameters Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   RXBURST;
        reg8_t   RXADD;
        reg16_t  RSVD;
    } B;
} hw_usbctrl_hwrxbuf_t;
#endif


//
// constants & macros for entire HW_USBCTRL_HWRXBUF register
//

#define HW_USBCTRL_HWRXBUF_ADDR      (REGS_USBCTRL_BASE + 0x00000014)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_HWRXBUF           (*(volatile hw_usbctrl_hwrxbuf_t *) HW_USBCTRL_HWRXBUF_ADDR)
#define HW_USBCTRL_HWRXBUF_RD()      (HW_USBCTRL_HWRXBUF.U)
#endif


//
// constants & macros for individual HW_USBCTRL_HWRXBUF bitfields
//

//--- Register HW_USBCTRL_HWRXBUF, field RXADD

#define BP_USBCTRL_HWRXBUF_RXADD      8
#define BM_USBCTRL_HWRXBUF_RXADD      0x0000FF00

#define BF_USBCTRL_HWRXBUF_RXADD(v)   (((v) << 8) & BM_USBCTRL_HWRXBUF_RXADD)

//--- Register HW_USBCTRL_HWRXBUF, field RXBURST

#define BP_USBCTRL_HWRXBUF_RXBURST      0
#define BM_USBCTRL_HWRXBUF_RXBURST      0x000000FF

#define BF_USBCTRL_HWRXBUF_RXBURST(v)   (((v) << 0) & BM_USBCTRL_HWRXBUF_RXBURST)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_GPTIMER0LD - General-Purpose Timer 0 Load (Non-EHCI-Compliant) Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned GPTLD  : 24;
        reg8_t   RSVD0;
    } B;
} hw_usbctrl_gptimer0ld_t;
#endif


//
// constants & macros for entire HW_USBCTRL_GPTIMER0LD register
//

#define HW_USBCTRL_GPTIMER0LD_ADDR      (REGS_USBCTRL_BASE + 0x00000080)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_GPTIMER0LD           (*(volatile hw_usbctrl_gptimer0ld_t *) HW_USBCTRL_GPTIMER0LD_ADDR)
#define HW_USBCTRL_GPTIMER0LD_RD()      (HW_USBCTRL_GPTIMER0LD.U)
#define HW_USBCTRL_GPTIMER0LD_WR(v)     (HW_USBCTRL_GPTIMER0LD.U = (v))
#define HW_USBCTRL_GPTIMER0LD_SET(v)    (HW_USBCTRL_GPTIMER0LD_WR(HW_USBCTRL_GPTIMER0LD_RD() |  (v)))
#define HW_USBCTRL_GPTIMER0LD_CLR(v)    (HW_USBCTRL_GPTIMER0LD_WR(HW_USBCTRL_GPTIMER0LD_RD() & ~(v)))
#define HW_USBCTRL_GPTIMER0LD_TOG(v)    (HW_USBCTRL_GPTIMER0LD_WR(HW_USBCTRL_GPTIMER0LD_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_GPTIMER0LD bitfields
//

//--- Register HW_USBCTRL_GPTIMER0LD, field GPTLD

#define BP_USBCTRL_GPTIMER0LD_GPTLD      0
#define BM_USBCTRL_GPTIMER0LD_GPTLD      0x00FFFFFF

#define BF_USBCTRL_GPTIMER0LD_GPTLD(v)   (((v) << 0) & BM_USBCTRL_GPTIMER0LD_GPTLD)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_GPTIMER0LD_GPTLD(v)   BF_CS1(USBCTRL_GPTIMER0LD, GPTLD, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_GPTIMER0CTRL - General-Purpose Timer 0 Control (Non-EHCI-Compliant) Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned GPTCNT   : 24;
        unsigned GPTMODE  :  1;
        unsigned RSVD0    :  5;
        unsigned GPTRST   :  1;
        unsigned GPTRUN   :  1;
    } B;
} hw_usbctrl_gptimer0ctrl_t;
#endif


//
// constants & macros for entire HW_USBCTRL_GPTIMER0CTRL register
//

#define HW_USBCTRL_GPTIMER0CTRL_ADDR      (REGS_USBCTRL_BASE + 0x00000084)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_GPTIMER0CTRL           (*(volatile hw_usbctrl_gptimer0ctrl_t *) HW_USBCTRL_GPTIMER0CTRL_ADDR)
#define HW_USBCTRL_GPTIMER0CTRL_RD()      (HW_USBCTRL_GPTIMER0CTRL.U)
#define HW_USBCTRL_GPTIMER0CTRL_WR(v)     (HW_USBCTRL_GPTIMER0CTRL.U = (v))
#define HW_USBCTRL_GPTIMER0CTRL_SET(v)    (HW_USBCTRL_GPTIMER0CTRL_WR(HW_USBCTRL_GPTIMER0CTRL_RD() |  (v)))
#define HW_USBCTRL_GPTIMER0CTRL_CLR(v)    (HW_USBCTRL_GPTIMER0CTRL_WR(HW_USBCTRL_GPTIMER0CTRL_RD() & ~(v)))
#define HW_USBCTRL_GPTIMER0CTRL_TOG(v)    (HW_USBCTRL_GPTIMER0CTRL_WR(HW_USBCTRL_GPTIMER0CTRL_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_GPTIMER0CTRL bitfields
//

//--- Register HW_USBCTRL_GPTIMER0CTRL, field GPTRUN

#define BP_USBCTRL_GPTIMER0CTRL_GPTRUN      31
#define BM_USBCTRL_GPTIMER0CTRL_GPTRUN      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_USBCTRL_GPTIMER0CTRL_GPTRUN(v)   ((((reg32_t) v) << 31) & BM_USBCTRL_GPTIMER0CTRL_GPTRUN)
#else
#define BF_USBCTRL_GPTIMER0CTRL_GPTRUN(v)   (((v) << 31) & BM_USBCTRL_GPTIMER0CTRL_GPTRUN)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_GPTIMER0CTRL_GPTRUN(v)   BF_CS1(USBCTRL_GPTIMER0CTRL, GPTRUN, v)
#endif

#define BV_USBCTRL_GPTIMER0CTRL_GPTRUN__STOP  0
#define BV_USBCTRL_GPTIMER0CTRL_GPTRUN__RUN   1

//--- Register HW_USBCTRL_GPTIMER0CTRL, field GPTRST

#define BP_USBCTRL_GPTIMER0CTRL_GPTRST      30
#define BM_USBCTRL_GPTIMER0CTRL_GPTRST      0x40000000

#define BF_USBCTRL_GPTIMER0CTRL_GPTRST(v)   (((v) << 30) & BM_USBCTRL_GPTIMER0CTRL_GPTRST)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_GPTIMER0CTRL_GPTRST(v)   BF_CS1(USBCTRL_GPTIMER0CTRL, GPTRST, v)
#endif

#define BV_USBCTRL_GPTIMER0CTRL_GPTRST__NOACTION     0
#define BV_USBCTRL_GPTIMER0CTRL_GPTRST__LOADCOUNTER  1

//--- Register HW_USBCTRL_GPTIMER0CTRL, field GPTMODE

#define BP_USBCTRL_GPTIMER0CTRL_GPTMODE      24
#define BM_USBCTRL_GPTIMER0CTRL_GPTMODE      0x01000000

#define BF_USBCTRL_GPTIMER0CTRL_GPTMODE(v)   (((v) << 24) & BM_USBCTRL_GPTIMER0CTRL_GPTMODE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_GPTIMER0CTRL_GPTMODE(v)   BF_CS1(USBCTRL_GPTIMER0CTRL, GPTMODE, v)
#endif

#define BV_USBCTRL_GPTIMER0CTRL_GPTMODE__ONESHOT  0
#define BV_USBCTRL_GPTIMER0CTRL_GPTMODE__REPEAT   1

//--- Register HW_USBCTRL_GPTIMER0CTRL, field GPTCNT

#define BP_USBCTRL_GPTIMER0CTRL_GPTCNT      0
#define BM_USBCTRL_GPTIMER0CTRL_GPTCNT      0x00FFFFFF

#define BF_USBCTRL_GPTIMER0CTRL_GPTCNT(v)   (((v) << 0) & BM_USBCTRL_GPTIMER0CTRL_GPTCNT)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_GPTIMER1LD - General-Purpose Timer 1 Load (Non-EHCI-Compliant) Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned GPTLD  : 24;
        reg8_t   RSVD0;
    } B;
} hw_usbctrl_gptimer1ld_t;
#endif


//
// constants & macros for entire HW_USBCTRL_GPTIMER1LD register
//

#define HW_USBCTRL_GPTIMER1LD_ADDR      (REGS_USBCTRL_BASE + 0x00000088)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_GPTIMER1LD           (*(volatile hw_usbctrl_gptimer1ld_t *) HW_USBCTRL_GPTIMER1LD_ADDR)
#define HW_USBCTRL_GPTIMER1LD_RD()      (HW_USBCTRL_GPTIMER1LD.U)
#define HW_USBCTRL_GPTIMER1LD_WR(v)     (HW_USBCTRL_GPTIMER1LD.U = (v))
#define HW_USBCTRL_GPTIMER1LD_SET(v)    (HW_USBCTRL_GPTIMER1LD_WR(HW_USBCTRL_GPTIMER1LD_RD() |  (v)))
#define HW_USBCTRL_GPTIMER1LD_CLR(v)    (HW_USBCTRL_GPTIMER1LD_WR(HW_USBCTRL_GPTIMER1LD_RD() & ~(v)))
#define HW_USBCTRL_GPTIMER1LD_TOG(v)    (HW_USBCTRL_GPTIMER1LD_WR(HW_USBCTRL_GPTIMER1LD_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_GPTIMER1LD bitfields
//

//--- Register HW_USBCTRL_GPTIMER1LD, field GPTLD

#define BP_USBCTRL_GPTIMER1LD_GPTLD      0
#define BM_USBCTRL_GPTIMER1LD_GPTLD      0x00FFFFFF

#define BF_USBCTRL_GPTIMER1LD_GPTLD(v)   (((v) << 0) & BM_USBCTRL_GPTIMER1LD_GPTLD)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_GPTIMER1LD_GPTLD(v)   BF_CS1(USBCTRL_GPTIMER1LD, GPTLD, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_GPTIMER1CTRL - General-Purpose Timer 1 Control (Non-EHCI-Compliant) Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned GPTCNT   : 24;
        unsigned GPTMODE  :  1;
        unsigned RSVD0    :  5;
        unsigned GPTRST   :  1;
        unsigned GPTRUN   :  1;
    } B;
} hw_usbctrl_gptimer1ctrl_t;
#endif


//
// constants & macros for entire HW_USBCTRL_GPTIMER1CTRL register
//

#define HW_USBCTRL_GPTIMER1CTRL_ADDR      (REGS_USBCTRL_BASE + 0x0000008C)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_GPTIMER1CTRL           (*(volatile hw_usbctrl_gptimer1ctrl_t *) HW_USBCTRL_GPTIMER1CTRL_ADDR)
#define HW_USBCTRL_GPTIMER1CTRL_RD()      (HW_USBCTRL_GPTIMER1CTRL.U)
#define HW_USBCTRL_GPTIMER1CTRL_WR(v)     (HW_USBCTRL_GPTIMER1CTRL.U = (v))
#define HW_USBCTRL_GPTIMER1CTRL_SET(v)    (HW_USBCTRL_GPTIMER1CTRL_WR(HW_USBCTRL_GPTIMER1CTRL_RD() |  (v)))
#define HW_USBCTRL_GPTIMER1CTRL_CLR(v)    (HW_USBCTRL_GPTIMER1CTRL_WR(HW_USBCTRL_GPTIMER1CTRL_RD() & ~(v)))
#define HW_USBCTRL_GPTIMER1CTRL_TOG(v)    (HW_USBCTRL_GPTIMER1CTRL_WR(HW_USBCTRL_GPTIMER1CTRL_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_GPTIMER1CTRL bitfields
//

//--- Register HW_USBCTRL_GPTIMER1CTRL, field GPTRUN

#define BP_USBCTRL_GPTIMER1CTRL_GPTRUN      31
#define BM_USBCTRL_GPTIMER1CTRL_GPTRUN      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_USBCTRL_GPTIMER1CTRL_GPTRUN(v)   ((((reg32_t) v) << 31) & BM_USBCTRL_GPTIMER1CTRL_GPTRUN)
#else
#define BF_USBCTRL_GPTIMER1CTRL_GPTRUN(v)   (((v) << 31) & BM_USBCTRL_GPTIMER1CTRL_GPTRUN)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_GPTIMER1CTRL_GPTRUN(v)   BF_CS1(USBCTRL_GPTIMER1CTRL, GPTRUN, v)
#endif

#define BV_USBCTRL_GPTIMER1CTRL_GPTRUN__STOP  0
#define BV_USBCTRL_GPTIMER1CTRL_GPTRUN__RUN   1

//--- Register HW_USBCTRL_GPTIMER1CTRL, field GPTRST

#define BP_USBCTRL_GPTIMER1CTRL_GPTRST      30
#define BM_USBCTRL_GPTIMER1CTRL_GPTRST      0x40000000

#define BF_USBCTRL_GPTIMER1CTRL_GPTRST(v)   (((v) << 30) & BM_USBCTRL_GPTIMER1CTRL_GPTRST)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_GPTIMER1CTRL_GPTRST(v)   BF_CS1(USBCTRL_GPTIMER1CTRL, GPTRST, v)
#endif

#define BV_USBCTRL_GPTIMER1CTRL_GPTRST__NOACTION     0
#define BV_USBCTRL_GPTIMER1CTRL_GPTRST__LOADCOUNTER  1

//--- Register HW_USBCTRL_GPTIMER1CTRL, field GPTMODE

#define BP_USBCTRL_GPTIMER1CTRL_GPTMODE      24
#define BM_USBCTRL_GPTIMER1CTRL_GPTMODE      0x01000000

#define BF_USBCTRL_GPTIMER1CTRL_GPTMODE(v)   (((v) << 24) & BM_USBCTRL_GPTIMER1CTRL_GPTMODE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_GPTIMER1CTRL_GPTMODE(v)   BF_CS1(USBCTRL_GPTIMER1CTRL, GPTMODE, v)
#endif

#define BV_USBCTRL_GPTIMER1CTRL_GPTMODE__ONESHOT  0
#define BV_USBCTRL_GPTIMER1CTRL_GPTMODE__REPEAT   1

//--- Register HW_USBCTRL_GPTIMER1CTRL, field GPTCNT

#define BP_USBCTRL_GPTIMER1CTRL_GPTCNT      0
#define BM_USBCTRL_GPTIMER1CTRL_GPTCNT      0x00FFFFFF

#define BF_USBCTRL_GPTIMER1CTRL_GPTCNT(v)   (((v) << 0) & BM_USBCTRL_GPTIMER1CTRL_GPTCNT)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_SBUSCFG - System Bus Configuration (Non-EHCI-Compliant) Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AHBBRST  :  3;
        unsigned RSVD     : 29;
    } B;
} hw_usbctrl_sbuscfg_t;
#endif


//
// constants & macros for entire HW_USBCTRL_SBUSCFG register
//

#define HW_USBCTRL_SBUSCFG_ADDR      (REGS_USBCTRL_BASE + 0x00000090)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_SBUSCFG           (*(volatile hw_usbctrl_sbuscfg_t *) HW_USBCTRL_SBUSCFG_ADDR)
#define HW_USBCTRL_SBUSCFG_RD()      (HW_USBCTRL_SBUSCFG.U)
#define HW_USBCTRL_SBUSCFG_WR(v)     (HW_USBCTRL_SBUSCFG.U = (v))
#define HW_USBCTRL_SBUSCFG_SET(v)    (HW_USBCTRL_SBUSCFG_WR(HW_USBCTRL_SBUSCFG_RD() |  (v)))
#define HW_USBCTRL_SBUSCFG_CLR(v)    (HW_USBCTRL_SBUSCFG_WR(HW_USBCTRL_SBUSCFG_RD() & ~(v)))
#define HW_USBCTRL_SBUSCFG_TOG(v)    (HW_USBCTRL_SBUSCFG_WR(HW_USBCTRL_SBUSCFG_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_SBUSCFG bitfields
//

//--- Register HW_USBCTRL_SBUSCFG, field AHBBRST

#define BP_USBCTRL_SBUSCFG_AHBBRST      0
#define BM_USBCTRL_SBUSCFG_AHBBRST      0x00000007

#define BF_USBCTRL_SBUSCFG_AHBBRST(v)   (((v) << 0) & BM_USBCTRL_SBUSCFG_AHBBRST)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_SBUSCFG_AHBBRST(v)   BF_CS1(USBCTRL_SBUSCFG, AHBBRST, v)
#endif

#define BV_USBCTRL_SBUSCFG_AHBBRST__U_INCR    0x0
#define BV_USBCTRL_SBUSCFG_AHBBRST__S_INCR4   0x1
#define BV_USBCTRL_SBUSCFG_AHBBRST__S_INCR8   0x2
#define BV_USBCTRL_SBUSCFG_AHBBRST__S_INCR16  0x3
#define BV_USBCTRL_SBUSCFG_AHBBRST__RESERVED  0x4
#define BV_USBCTRL_SBUSCFG_AHBBRST__U_INCR4   0x5
#define BV_USBCTRL_SBUSCFG_AHBBRST__U_INCR8   0x6
#define BV_USBCTRL_SBUSCFG_AHBBRST__U_INCR16  0x7


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_CAPLENGTH - Capability Length and HCI Version (EHCI-Compliant) Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   CAPLENGTH;
        reg8_t   RSVD;
        reg16_t  HCIVERSION;
    } B;
} hw_usbctrl_caplength_t;
#endif


//
// constants & macros for entire HW_USBCTRL_CAPLENGTH register
//

#define HW_USBCTRL_CAPLENGTH_ADDR      (REGS_USBCTRL_BASE + 0x00000100)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_CAPLENGTH           (*(volatile hw_usbctrl_caplength_t *) HW_USBCTRL_CAPLENGTH_ADDR)
#define HW_USBCTRL_CAPLENGTH_RD()      (HW_USBCTRL_CAPLENGTH.U)
#endif


//
// constants & macros for individual HW_USBCTRL_CAPLENGTH bitfields
//

//--- Register HW_USBCTRL_CAPLENGTH, field HCIVERSION

#define BP_USBCTRL_CAPLENGTH_HCIVERSION      16
#define BM_USBCTRL_CAPLENGTH_HCIVERSION      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_USBCTRL_CAPLENGTH_HCIVERSION(v)   ((((reg32_t) v) << 16) & BM_USBCTRL_CAPLENGTH_HCIVERSION)
#else
#define BF_USBCTRL_CAPLENGTH_HCIVERSION(v)   (((v) << 16) & BM_USBCTRL_CAPLENGTH_HCIVERSION)
#endif

//--- Register HW_USBCTRL_CAPLENGTH, field CAPLENGTH

#define BP_USBCTRL_CAPLENGTH_CAPLENGTH      0
#define BM_USBCTRL_CAPLENGTH_CAPLENGTH      0x000000FF

#define BF_USBCTRL_CAPLENGTH_CAPLENGTH(v)   (((v) << 0) & BM_USBCTRL_CAPLENGTH_CAPLENGTH)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_HCSPARAMS - Host Control Structural Parameters (EHCI-Compliant with Extensions) Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned N_PORTS  :  4;
        unsigned PPC      :  1;
        unsigned RSVD0    :  3;
        unsigned N_PCC    :  4;
        unsigned N_CC     :  4;
        unsigned PI       :  1;
        unsigned RSVD1    :  3;
        unsigned N_PTT    :  4;
        unsigned N_TT     :  4;
        unsigned RSVD2    :  4;
    } B;
} hw_usbctrl_hcsparams_t;
#endif


//
// constants & macros for entire HW_USBCTRL_HCSPARAMS register
//

#define HW_USBCTRL_HCSPARAMS_ADDR      (REGS_USBCTRL_BASE + 0x00000104)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_HCSPARAMS           (*(volatile hw_usbctrl_hcsparams_t *) HW_USBCTRL_HCSPARAMS_ADDR)
#define HW_USBCTRL_HCSPARAMS_RD()      (HW_USBCTRL_HCSPARAMS.U)
#endif


//
// constants & macros for individual HW_USBCTRL_HCSPARAMS bitfields
//

//--- Register HW_USBCTRL_HCSPARAMS, field N_TT

#define BP_USBCTRL_HCSPARAMS_N_TT      24
#define BM_USBCTRL_HCSPARAMS_N_TT      0x0F000000

#define BF_USBCTRL_HCSPARAMS_N_TT(v)   (((v) << 24) & BM_USBCTRL_HCSPARAMS_N_TT)

//--- Register HW_USBCTRL_HCSPARAMS, field N_PTT

#define BP_USBCTRL_HCSPARAMS_N_PTT      20
#define BM_USBCTRL_HCSPARAMS_N_PTT      0x00F00000

#define BF_USBCTRL_HCSPARAMS_N_PTT(v)   (((v) << 20) & BM_USBCTRL_HCSPARAMS_N_PTT)

//--- Register HW_USBCTRL_HCSPARAMS, field PI

#define BP_USBCTRL_HCSPARAMS_PI      16
#define BM_USBCTRL_HCSPARAMS_PI      0x00010000

#define BF_USBCTRL_HCSPARAMS_PI(v)   (((v) << 16) & BM_USBCTRL_HCSPARAMS_PI)

//--- Register HW_USBCTRL_HCSPARAMS, field N_CC

#define BP_USBCTRL_HCSPARAMS_N_CC      12
#define BM_USBCTRL_HCSPARAMS_N_CC      0x0000F000

#define BF_USBCTRL_HCSPARAMS_N_CC(v)   (((v) << 12) & BM_USBCTRL_HCSPARAMS_N_CC)

//--- Register HW_USBCTRL_HCSPARAMS, field N_PCC

#define BP_USBCTRL_HCSPARAMS_N_PCC      8
#define BM_USBCTRL_HCSPARAMS_N_PCC      0x00000F00

#define BF_USBCTRL_HCSPARAMS_N_PCC(v)   (((v) << 8) & BM_USBCTRL_HCSPARAMS_N_PCC)

//--- Register HW_USBCTRL_HCSPARAMS, field PPC

#define BP_USBCTRL_HCSPARAMS_PPC      4
#define BM_USBCTRL_HCSPARAMS_PPC      0x00000010

#define BF_USBCTRL_HCSPARAMS_PPC(v)   (((v) << 4) & BM_USBCTRL_HCSPARAMS_PPC)

//--- Register HW_USBCTRL_HCSPARAMS, field N_PORTS

#define BP_USBCTRL_HCSPARAMS_N_PORTS      0
#define BM_USBCTRL_HCSPARAMS_N_PORTS      0x0000000F

#define BF_USBCTRL_HCSPARAMS_N_PORTS(v)   (((v) << 0) & BM_USBCTRL_HCSPARAMS_N_PORTS)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_HCCPARAMS - Host Control Capability Parameters (EHCI-Compliant) Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADC    :  1;
        unsigned PFL    :  1;
        unsigned ASP    :  1;
        unsigned RSVD0  :  1;
        unsigned IST    :  4;
        reg8_t   EECP;
        reg16_t  RSVD2;
    } B;
} hw_usbctrl_hccparams_t;
#endif


//
// constants & macros for entire HW_USBCTRL_HCCPARAMS register
//

#define HW_USBCTRL_HCCPARAMS_ADDR      (REGS_USBCTRL_BASE + 0x00000108)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_HCCPARAMS           (*(volatile hw_usbctrl_hccparams_t *) HW_USBCTRL_HCCPARAMS_ADDR)
#define HW_USBCTRL_HCCPARAMS_RD()      (HW_USBCTRL_HCCPARAMS.U)
#endif


//
// constants & macros for individual HW_USBCTRL_HCCPARAMS bitfields
//

//--- Register HW_USBCTRL_HCCPARAMS, field EECP

#define BP_USBCTRL_HCCPARAMS_EECP      8
#define BM_USBCTRL_HCCPARAMS_EECP      0x0000FF00

#define BF_USBCTRL_HCCPARAMS_EECP(v)   (((v) << 8) & BM_USBCTRL_HCCPARAMS_EECP)

//--- Register HW_USBCTRL_HCCPARAMS, field IST

#define BP_USBCTRL_HCCPARAMS_IST      4
#define BM_USBCTRL_HCCPARAMS_IST      0x000000F0

#define BF_USBCTRL_HCCPARAMS_IST(v)   (((v) << 4) & BM_USBCTRL_HCCPARAMS_IST)

//--- Register HW_USBCTRL_HCCPARAMS, field ASP

#define BP_USBCTRL_HCCPARAMS_ASP      2
#define BM_USBCTRL_HCCPARAMS_ASP      0x00000004

#define BF_USBCTRL_HCCPARAMS_ASP(v)   (((v) << 2) & BM_USBCTRL_HCCPARAMS_ASP)

//--- Register HW_USBCTRL_HCCPARAMS, field PFL

#define BP_USBCTRL_HCCPARAMS_PFL      1
#define BM_USBCTRL_HCCPARAMS_PFL      0x00000002

#define BF_USBCTRL_HCCPARAMS_PFL(v)   (((v) << 1) & BM_USBCTRL_HCCPARAMS_PFL)

//--- Register HW_USBCTRL_HCCPARAMS, field ADC

#define BP_USBCTRL_HCCPARAMS_ADC      0
#define BM_USBCTRL_HCCPARAMS_ADC      0x00000001

#define BF_USBCTRL_HCCPARAMS_ADC(v)   (((v) << 0) & BM_USBCTRL_HCCPARAMS_ADC)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_DCIVERSION - Device Interface Version Number (Non-EHCI-Compliant) Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  DCIVERSION;
        reg16_t  RSVD;
    } B;
} hw_usbctrl_dciversion_t;
#endif


//
// constants & macros for entire HW_USBCTRL_DCIVERSION register
//

#define HW_USBCTRL_DCIVERSION_ADDR      (REGS_USBCTRL_BASE + 0x00000120)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_DCIVERSION           (*(volatile hw_usbctrl_dciversion_t *) HW_USBCTRL_DCIVERSION_ADDR)
#define HW_USBCTRL_DCIVERSION_RD()      (HW_USBCTRL_DCIVERSION.U)
#define HW_USBCTRL_DCIVERSION_WR(v)     (HW_USBCTRL_DCIVERSION.U = (v))
#define HW_USBCTRL_DCIVERSION_SET(v)    (HW_USBCTRL_DCIVERSION_WR(HW_USBCTRL_DCIVERSION_RD() |  (v)))
#define HW_USBCTRL_DCIVERSION_CLR(v)    (HW_USBCTRL_DCIVERSION_WR(HW_USBCTRL_DCIVERSION_RD() & ~(v)))
#define HW_USBCTRL_DCIVERSION_TOG(v)    (HW_USBCTRL_DCIVERSION_WR(HW_USBCTRL_DCIVERSION_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_DCIVERSION bitfields
//

//--- Register HW_USBCTRL_DCIVERSION, field DCIVERSION

#define BP_USBCTRL_DCIVERSION_DCIVERSION      0
#define BM_USBCTRL_DCIVERSION_DCIVERSION      0x0000FFFF

#define BF_USBCTRL_DCIVERSION_DCIVERSION(v)   (((v) << 0) & BM_USBCTRL_DCIVERSION_DCIVERSION)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_DCIVERSION_DCIVERSION(v)   (HW_USBCTRL_DCIVERSION.B.DCIVERSION = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_DCCPARAMS - Device Control Capability Parameters (Non-EHCI-Compliant) Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DEN    :  5;
        unsigned RSVD2  :  2;
        unsigned DC     :  1;
        unsigned HC     :  1;
        unsigned RSVD1  : 23;
    } B;
} hw_usbctrl_dccparams_t;
#endif


//
// constants & macros for entire HW_USBCTRL_DCCPARAMS register
//

#define HW_USBCTRL_DCCPARAMS_ADDR      (REGS_USBCTRL_BASE + 0x00000124)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_DCCPARAMS           (*(volatile hw_usbctrl_dccparams_t *) HW_USBCTRL_DCCPARAMS_ADDR)
#define HW_USBCTRL_DCCPARAMS_RD()      (HW_USBCTRL_DCCPARAMS.U)
#endif


//
// constants & macros for individual HW_USBCTRL_DCCPARAMS bitfields
//

//--- Register HW_USBCTRL_DCCPARAMS, field HC

#define BP_USBCTRL_DCCPARAMS_HC      8
#define BM_USBCTRL_DCCPARAMS_HC      0x00000100

#define BF_USBCTRL_DCCPARAMS_HC(v)   (((v) << 8) & BM_USBCTRL_DCCPARAMS_HC)

//--- Register HW_USBCTRL_DCCPARAMS, field DC

#define BP_USBCTRL_DCCPARAMS_DC      7
#define BM_USBCTRL_DCCPARAMS_DC      0x00000080

#define BF_USBCTRL_DCCPARAMS_DC(v)   (((v) << 7) & BM_USBCTRL_DCCPARAMS_DC)

//--- Register HW_USBCTRL_DCCPARAMS, field DEN

#define BP_USBCTRL_DCCPARAMS_DEN      0
#define BM_USBCTRL_DCCPARAMS_DEN      0x0000001F

#define BF_USBCTRL_DCCPARAMS_DEN(v)   (((v) << 0) & BM_USBCTRL_DCCPARAMS_DEN)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_USBCMD - USB Command Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RS     :  1;
        unsigned RST    :  1;
        unsigned FS0    :  1;
        unsigned FS1    :  1;
        unsigned PSE    :  1;
        unsigned ASE    :  1;
        unsigned IAA    :  1;
        unsigned LR     :  1;
        unsigned ASP    :  2;
        unsigned RSVD1  :  1;
        unsigned ASPE   :  1;
        unsigned RSVD2  :  1;
        unsigned SUTW   :  1;
        unsigned ATDTW  :  1;
        unsigned FS2    :  1;
        reg8_t   ITC;
        reg8_t   RSVD3;
    } B;
} hw_usbctrl_usbcmd_t;
#endif


//
// constants & macros for entire HW_USBCTRL_USBCMD register
//

#define HW_USBCTRL_USBCMD_ADDR      (REGS_USBCTRL_BASE + 0x00000140)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_USBCMD           (*(volatile hw_usbctrl_usbcmd_t *) HW_USBCTRL_USBCMD_ADDR)
#define HW_USBCTRL_USBCMD_RD()      (HW_USBCTRL_USBCMD.U)
#define HW_USBCTRL_USBCMD_WR(v)     (HW_USBCTRL_USBCMD.U = (v))
#define HW_USBCTRL_USBCMD_SET(v)    (HW_USBCTRL_USBCMD_WR(HW_USBCTRL_USBCMD_RD() |  (v)))
#define HW_USBCTRL_USBCMD_CLR(v)    (HW_USBCTRL_USBCMD_WR(HW_USBCTRL_USBCMD_RD() & ~(v)))
#define HW_USBCTRL_USBCMD_TOG(v)    (HW_USBCTRL_USBCMD_WR(HW_USBCTRL_USBCMD_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_USBCMD bitfields
//

//--- Register HW_USBCTRL_USBCMD, field ITC

#define BP_USBCTRL_USBCMD_ITC      16
#define BM_USBCTRL_USBCMD_ITC      0x00FF0000

#define BF_USBCTRL_USBCMD_ITC(v)   (((v) << 16) & BM_USBCTRL_USBCMD_ITC)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBCMD_ITC(v)   (HW_USBCTRL_USBCMD.B.ITC = (v))
#endif

#define BV_USBCTRL_USBCMD_ITC__IMM            0x0
#define BV_USBCTRL_USBCMD_ITC__1_MICROFRAME   0x1
#define BV_USBCTRL_USBCMD_ITC__2_MICROFRAME   0x2
#define BV_USBCTRL_USBCMD_ITC__4_MICROFRAME   0x4
#define BV_USBCTRL_USBCMD_ITC__8_MICROFRAME   0x8
#define BV_USBCTRL_USBCMD_ITC__16_MICROFRAME  0x10
#define BV_USBCTRL_USBCMD_ITC__32_MICROFRAME  0x20
#define BV_USBCTRL_USBCMD_ITC__64_MICROFRAME  0x40

//--- Register HW_USBCTRL_USBCMD, field FS2

#define BP_USBCTRL_USBCMD_FS2      15
#define BM_USBCTRL_USBCMD_FS2      0x00008000

#define BF_USBCTRL_USBCMD_FS2(v)   (((v) << 15) & BM_USBCTRL_USBCMD_FS2)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBCMD_FS2(v)   BF_CS1(USBCTRL_USBCMD, FS2, v)
#endif

//--- Register HW_USBCTRL_USBCMD, field ATDTW

#define BP_USBCTRL_USBCMD_ATDTW      14
#define BM_USBCTRL_USBCMD_ATDTW      0x00004000

#define BF_USBCTRL_USBCMD_ATDTW(v)   (((v) << 14) & BM_USBCTRL_USBCMD_ATDTW)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBCMD_ATDTW(v)   BF_CS1(USBCTRL_USBCMD, ATDTW, v)
#endif

//--- Register HW_USBCTRL_USBCMD, field SUTW

#define BP_USBCTRL_USBCMD_SUTW      13
#define BM_USBCTRL_USBCMD_SUTW      0x00002000

#define BF_USBCTRL_USBCMD_SUTW(v)   (((v) << 13) & BM_USBCTRL_USBCMD_SUTW)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBCMD_SUTW(v)   BF_CS1(USBCTRL_USBCMD, SUTW, v)
#endif

//--- Register HW_USBCTRL_USBCMD, field ASPE

#define BP_USBCTRL_USBCMD_ASPE      11
#define BM_USBCTRL_USBCMD_ASPE      0x00000800

#define BF_USBCTRL_USBCMD_ASPE(v)   (((v) << 11) & BM_USBCTRL_USBCMD_ASPE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBCMD_ASPE(v)   BF_CS1(USBCTRL_USBCMD, ASPE, v)
#endif

//--- Register HW_USBCTRL_USBCMD, field ASP

#define BP_USBCTRL_USBCMD_ASP      8
#define BM_USBCTRL_USBCMD_ASP      0x00000300

#define BF_USBCTRL_USBCMD_ASP(v)   (((v) << 8) & BM_USBCTRL_USBCMD_ASP)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBCMD_ASP(v)   BF_CS1(USBCTRL_USBCMD, ASP, v)
#endif

//--- Register HW_USBCTRL_USBCMD, field LR

#define BP_USBCTRL_USBCMD_LR      7
#define BM_USBCTRL_USBCMD_LR      0x00000080

#define BF_USBCTRL_USBCMD_LR(v)   (((v) << 7) & BM_USBCTRL_USBCMD_LR)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBCMD_LR(v)   BF_CS1(USBCTRL_USBCMD, LR, v)
#endif

//--- Register HW_USBCTRL_USBCMD, field IAA

#define BP_USBCTRL_USBCMD_IAA      6
#define BM_USBCTRL_USBCMD_IAA      0x00000040

#define BF_USBCTRL_USBCMD_IAA(v)   (((v) << 6) & BM_USBCTRL_USBCMD_IAA)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBCMD_IAA(v)   BF_CS1(USBCTRL_USBCMD, IAA, v)
#endif

//--- Register HW_USBCTRL_USBCMD, field ASE

#define BP_USBCTRL_USBCMD_ASE      5
#define BM_USBCTRL_USBCMD_ASE      0x00000020

#define BF_USBCTRL_USBCMD_ASE(v)   (((v) << 5) & BM_USBCTRL_USBCMD_ASE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBCMD_ASE(v)   BF_CS1(USBCTRL_USBCMD, ASE, v)
#endif

//--- Register HW_USBCTRL_USBCMD, field PSE

#define BP_USBCTRL_USBCMD_PSE      4
#define BM_USBCTRL_USBCMD_PSE      0x00000010

#define BF_USBCTRL_USBCMD_PSE(v)   (((v) << 4) & BM_USBCTRL_USBCMD_PSE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBCMD_PSE(v)   BF_CS1(USBCTRL_USBCMD, PSE, v)
#endif

//--- Register HW_USBCTRL_USBCMD, field FS1

#define BP_USBCTRL_USBCMD_FS1      3
#define BM_USBCTRL_USBCMD_FS1      0x00000008

#define BF_USBCTRL_USBCMD_FS1(v)   (((v) << 3) & BM_USBCTRL_USBCMD_FS1)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBCMD_FS1(v)   BF_CS1(USBCTRL_USBCMD, FS1, v)
#endif

//--- Register HW_USBCTRL_USBCMD, field FS0

#define BP_USBCTRL_USBCMD_FS0      2
#define BM_USBCTRL_USBCMD_FS0      0x00000004

#define BF_USBCTRL_USBCMD_FS0(v)   (((v) << 2) & BM_USBCTRL_USBCMD_FS0)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBCMD_FS0(v)   BF_CS1(USBCTRL_USBCMD, FS0, v)
#endif

//--- Register HW_USBCTRL_USBCMD, field RST

#define BP_USBCTRL_USBCMD_RST      1
#define BM_USBCTRL_USBCMD_RST      0x00000002

#define BF_USBCTRL_USBCMD_RST(v)   (((v) << 1) & BM_USBCTRL_USBCMD_RST)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBCMD_RST(v)   BF_CS1(USBCTRL_USBCMD, RST, v)
#endif

//--- Register HW_USBCTRL_USBCMD, field RS

#define BP_USBCTRL_USBCMD_RS      0
#define BM_USBCTRL_USBCMD_RS      0x00000001

#define BF_USBCTRL_USBCMD_RS(v)   (((v) << 0) & BM_USBCTRL_USBCMD_RS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBCMD_RS(v)   BF_CS1(USBCTRL_USBCMD, RS, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_USBSTS - USB Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned UI     :  1;
        unsigned UEI    :  1;
        unsigned PCI    :  1;
        unsigned FRI    :  1;
        unsigned SEI    :  1;
        unsigned AAI    :  1;
        unsigned URI    :  1;
        unsigned SRI    :  1;
        unsigned SLI    :  1;
        unsigned RSVD1  :  1;
        unsigned ULPII  :  1;
        unsigned RSVD2  :  1;
        unsigned HCH    :  1;
        unsigned RCL    :  1;
        unsigned PS     :  1;
        unsigned AS     :  1;
        unsigned NAKI   :  1;
        unsigned RSVD3  :  1;
        unsigned UAI    :  1;
        unsigned UPI    :  1;
        unsigned RSVD4  :  4;
        unsigned TI0    :  1;
        unsigned TI1    :  1;
        unsigned RSVD5  :  6;
    } B;
} hw_usbctrl_usbsts_t;
#endif


//
// constants & macros for entire HW_USBCTRL_USBSTS register
//

#define HW_USBCTRL_USBSTS_ADDR      (REGS_USBCTRL_BASE + 0x00000144)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_USBSTS           (*(volatile hw_usbctrl_usbsts_t *) HW_USBCTRL_USBSTS_ADDR)
#define HW_USBCTRL_USBSTS_RD()      (HW_USBCTRL_USBSTS.U)
#define HW_USBCTRL_USBSTS_WR(v)     (HW_USBCTRL_USBSTS.U = (v))
#define HW_USBCTRL_USBSTS_SET(v)    (HW_USBCTRL_USBSTS_WR(HW_USBCTRL_USBSTS_RD() |  (v)))
#define HW_USBCTRL_USBSTS_CLR(v)    (HW_USBCTRL_USBSTS_WR(HW_USBCTRL_USBSTS_RD() & ~(v)))
#define HW_USBCTRL_USBSTS_TOG(v)    (HW_USBCTRL_USBSTS_WR(HW_USBCTRL_USBSTS_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_USBSTS bitfields
//

//--- Register HW_USBCTRL_USBSTS, field TI1

#define BP_USBCTRL_USBSTS_TI1      25
#define BM_USBCTRL_USBSTS_TI1      0x02000000

#define BF_USBCTRL_USBSTS_TI1(v)   (((v) << 25) & BM_USBCTRL_USBSTS_TI1)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_TI1(v)   BF_CS1(USBCTRL_USBSTS, TI1, v)
#endif

//--- Register HW_USBCTRL_USBSTS, field TI0

#define BP_USBCTRL_USBSTS_TI0      24
#define BM_USBCTRL_USBSTS_TI0      0x01000000

#define BF_USBCTRL_USBSTS_TI0(v)   (((v) << 24) & BM_USBCTRL_USBSTS_TI0)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_TI0(v)   BF_CS1(USBCTRL_USBSTS, TI0, v)
#endif

//--- Register HW_USBCTRL_USBSTS, field UPI

#define BP_USBCTRL_USBSTS_UPI      19
#define BM_USBCTRL_USBSTS_UPI      0x00080000

#define BF_USBCTRL_USBSTS_UPI(v)   (((v) << 19) & BM_USBCTRL_USBSTS_UPI)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_UPI(v)   BF_CS1(USBCTRL_USBSTS, UPI, v)
#endif

//--- Register HW_USBCTRL_USBSTS, field UAI

#define BP_USBCTRL_USBSTS_UAI      18
#define BM_USBCTRL_USBSTS_UAI      0x00040000

#define BF_USBCTRL_USBSTS_UAI(v)   (((v) << 18) & BM_USBCTRL_USBSTS_UAI)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_UAI(v)   BF_CS1(USBCTRL_USBSTS, UAI, v)
#endif

//--- Register HW_USBCTRL_USBSTS, field NAKI

#define BP_USBCTRL_USBSTS_NAKI      16
#define BM_USBCTRL_USBSTS_NAKI      0x00010000

#define BF_USBCTRL_USBSTS_NAKI(v)   (((v) << 16) & BM_USBCTRL_USBSTS_NAKI)

//--- Register HW_USBCTRL_USBSTS, field AS

#define BP_USBCTRL_USBSTS_AS      15
#define BM_USBCTRL_USBSTS_AS      0x00008000

#define BF_USBCTRL_USBSTS_AS(v)   (((v) << 15) & BM_USBCTRL_USBSTS_AS)

//--- Register HW_USBCTRL_USBSTS, field PS

#define BP_USBCTRL_USBSTS_PS      14
#define BM_USBCTRL_USBSTS_PS      0x00004000

#define BF_USBCTRL_USBSTS_PS(v)   (((v) << 14) & BM_USBCTRL_USBSTS_PS)

//--- Register HW_USBCTRL_USBSTS, field RCL

#define BP_USBCTRL_USBSTS_RCL      13
#define BM_USBCTRL_USBSTS_RCL      0x00002000

#define BF_USBCTRL_USBSTS_RCL(v)   (((v) << 13) & BM_USBCTRL_USBSTS_RCL)

//--- Register HW_USBCTRL_USBSTS, field HCH

#define BP_USBCTRL_USBSTS_HCH      12
#define BM_USBCTRL_USBSTS_HCH      0x00001000

#define BF_USBCTRL_USBSTS_HCH(v)   (((v) << 12) & BM_USBCTRL_USBSTS_HCH)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_HCH(v)   BF_CS1(USBCTRL_USBSTS, HCH, v)
#endif

//--- Register HW_USBCTRL_USBSTS, field ULPII

#define BP_USBCTRL_USBSTS_ULPII      10
#define BM_USBCTRL_USBSTS_ULPII      0x00000400

#define BF_USBCTRL_USBSTS_ULPII(v)   (((v) << 10) & BM_USBCTRL_USBSTS_ULPII)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_ULPII(v)   BF_CS1(USBCTRL_USBSTS, ULPII, v)
#endif

//--- Register HW_USBCTRL_USBSTS, field SLI

#define BP_USBCTRL_USBSTS_SLI      8
#define BM_USBCTRL_USBSTS_SLI      0x00000100

#define BF_USBCTRL_USBSTS_SLI(v)   (((v) << 8) & BM_USBCTRL_USBSTS_SLI)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_SLI(v)   BF_CS1(USBCTRL_USBSTS, SLI, v)
#endif

//--- Register HW_USBCTRL_USBSTS, field SRI

#define BP_USBCTRL_USBSTS_SRI      7
#define BM_USBCTRL_USBSTS_SRI      0x00000080

#define BF_USBCTRL_USBSTS_SRI(v)   (((v) << 7) & BM_USBCTRL_USBSTS_SRI)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_SRI(v)   BF_CS1(USBCTRL_USBSTS, SRI, v)
#endif

//--- Register HW_USBCTRL_USBSTS, field URI

#define BP_USBCTRL_USBSTS_URI      6
#define BM_USBCTRL_USBSTS_URI      0x00000040

#define BF_USBCTRL_USBSTS_URI(v)   (((v) << 6) & BM_USBCTRL_USBSTS_URI)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_URI(v)   BF_CS1(USBCTRL_USBSTS, URI, v)
#endif

//--- Register HW_USBCTRL_USBSTS, field AAI

#define BP_USBCTRL_USBSTS_AAI      5
#define BM_USBCTRL_USBSTS_AAI      0x00000020

#define BF_USBCTRL_USBSTS_AAI(v)   (((v) << 5) & BM_USBCTRL_USBSTS_AAI)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_AAI(v)   BF_CS1(USBCTRL_USBSTS, AAI, v)
#endif

//--- Register HW_USBCTRL_USBSTS, field SEI

#define BP_USBCTRL_USBSTS_SEI      4
#define BM_USBCTRL_USBSTS_SEI      0x00000010

#define BF_USBCTRL_USBSTS_SEI(v)   (((v) << 4) & BM_USBCTRL_USBSTS_SEI)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_SEI(v)   BF_CS1(USBCTRL_USBSTS, SEI, v)
#endif

//--- Register HW_USBCTRL_USBSTS, field FRI

#define BP_USBCTRL_USBSTS_FRI      3
#define BM_USBCTRL_USBSTS_FRI      0x00000008

#define BF_USBCTRL_USBSTS_FRI(v)   (((v) << 3) & BM_USBCTRL_USBSTS_FRI)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_FRI(v)   BF_CS1(USBCTRL_USBSTS, FRI, v)
#endif

//--- Register HW_USBCTRL_USBSTS, field PCI

#define BP_USBCTRL_USBSTS_PCI      2
#define BM_USBCTRL_USBSTS_PCI      0x00000004

#define BF_USBCTRL_USBSTS_PCI(v)   (((v) << 2) & BM_USBCTRL_USBSTS_PCI)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_PCI(v)   BF_CS1(USBCTRL_USBSTS, PCI, v)
#endif

//--- Register HW_USBCTRL_USBSTS, field UEI

#define BP_USBCTRL_USBSTS_UEI      1
#define BM_USBCTRL_USBSTS_UEI      0x00000002

#define BF_USBCTRL_USBSTS_UEI(v)   (((v) << 1) & BM_USBCTRL_USBSTS_UEI)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_UEI(v)   BF_CS1(USBCTRL_USBSTS, UEI, v)
#endif

//--- Register HW_USBCTRL_USBSTS, field UI

#define BP_USBCTRL_USBSTS_UI      0
#define BM_USBCTRL_USBSTS_UI      0x00000001

#define BF_USBCTRL_USBSTS_UI(v)   (((v) << 0) & BM_USBCTRL_USBSTS_UI)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBSTS_UI(v)   BF_CS1(USBCTRL_USBSTS, UI, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_USBINTR - USB Interrupt Enable Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned UE     :  1;
        unsigned UEE    :  1;
        unsigned PCE    :  1;
        unsigned FRE    :  1;
        unsigned SEE    :  1;
        unsigned AAE    :  1;
        unsigned URE    :  1;
        unsigned SRE    :  1;
        unsigned SLE    :  1;
        unsigned RSVD1  :  1;
        unsigned ULPIE  :  1;
        unsigned RSVD2  :  5;
        unsigned NAKE   :  1;
        unsigned RSVD3  :  1;
        unsigned UAIE   :  1;
        unsigned UPIE   :  1;
        unsigned RSVD4  :  4;
        unsigned TIE0   :  1;
        unsigned TIE1   :  1;
        unsigned RSVD5  :  6;
    } B;
} hw_usbctrl_usbintr_t;
#endif


//
// constants & macros for entire HW_USBCTRL_USBINTR register
//

#define HW_USBCTRL_USBINTR_ADDR      (REGS_USBCTRL_BASE + 0x00000148)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_USBINTR           (*(volatile hw_usbctrl_usbintr_t *) HW_USBCTRL_USBINTR_ADDR)
#define HW_USBCTRL_USBINTR_RD()      (HW_USBCTRL_USBINTR.U)
#define HW_USBCTRL_USBINTR_WR(v)     (HW_USBCTRL_USBINTR.U = (v))
#define HW_USBCTRL_USBINTR_SET(v)    (HW_USBCTRL_USBINTR_WR(HW_USBCTRL_USBINTR_RD() |  (v)))
#define HW_USBCTRL_USBINTR_CLR(v)    (HW_USBCTRL_USBINTR_WR(HW_USBCTRL_USBINTR_RD() & ~(v)))
#define HW_USBCTRL_USBINTR_TOG(v)    (HW_USBCTRL_USBINTR_WR(HW_USBCTRL_USBINTR_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_USBINTR bitfields
//

//--- Register HW_USBCTRL_USBINTR, field TIE1

#define BP_USBCTRL_USBINTR_TIE1      25
#define BM_USBCTRL_USBINTR_TIE1      0x02000000

#define BF_USBCTRL_USBINTR_TIE1(v)   (((v) << 25) & BM_USBCTRL_USBINTR_TIE1)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_TIE1(v)   BF_CS1(USBCTRL_USBINTR, TIE1, v)
#endif

//--- Register HW_USBCTRL_USBINTR, field TIE0

#define BP_USBCTRL_USBINTR_TIE0      24
#define BM_USBCTRL_USBINTR_TIE0      0x01000000

#define BF_USBCTRL_USBINTR_TIE0(v)   (((v) << 24) & BM_USBCTRL_USBINTR_TIE0)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_TIE0(v)   BF_CS1(USBCTRL_USBINTR, TIE0, v)
#endif

//--- Register HW_USBCTRL_USBINTR, field UPIE

#define BP_USBCTRL_USBINTR_UPIE      19
#define BM_USBCTRL_USBINTR_UPIE      0x00080000

#define BF_USBCTRL_USBINTR_UPIE(v)   (((v) << 19) & BM_USBCTRL_USBINTR_UPIE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_UPIE(v)   BF_CS1(USBCTRL_USBINTR, UPIE, v)
#endif

//--- Register HW_USBCTRL_USBINTR, field UAIE

#define BP_USBCTRL_USBINTR_UAIE      18
#define BM_USBCTRL_USBINTR_UAIE      0x00040000

#define BF_USBCTRL_USBINTR_UAIE(v)   (((v) << 18) & BM_USBCTRL_USBINTR_UAIE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_UAIE(v)   BF_CS1(USBCTRL_USBINTR, UAIE, v)
#endif

//--- Register HW_USBCTRL_USBINTR, field NAKE

#define BP_USBCTRL_USBINTR_NAKE      16
#define BM_USBCTRL_USBINTR_NAKE      0x00010000

#define BF_USBCTRL_USBINTR_NAKE(v)   (((v) << 16) & BM_USBCTRL_USBINTR_NAKE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_NAKE(v)   BF_CS1(USBCTRL_USBINTR, NAKE, v)
#endif

//--- Register HW_USBCTRL_USBINTR, field ULPIE

#define BP_USBCTRL_USBINTR_ULPIE      10
#define BM_USBCTRL_USBINTR_ULPIE      0x00000400

#define BF_USBCTRL_USBINTR_ULPIE(v)   (((v) << 10) & BM_USBCTRL_USBINTR_ULPIE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_ULPIE(v)   BF_CS1(USBCTRL_USBINTR, ULPIE, v)
#endif

//--- Register HW_USBCTRL_USBINTR, field SLE

#define BP_USBCTRL_USBINTR_SLE      8
#define BM_USBCTRL_USBINTR_SLE      0x00000100

#define BF_USBCTRL_USBINTR_SLE(v)   (((v) << 8) & BM_USBCTRL_USBINTR_SLE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_SLE(v)   BF_CS1(USBCTRL_USBINTR, SLE, v)
#endif

//--- Register HW_USBCTRL_USBINTR, field SRE

#define BP_USBCTRL_USBINTR_SRE      7
#define BM_USBCTRL_USBINTR_SRE      0x00000080

#define BF_USBCTRL_USBINTR_SRE(v)   (((v) << 7) & BM_USBCTRL_USBINTR_SRE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_SRE(v)   BF_CS1(USBCTRL_USBINTR, SRE, v)
#endif

//--- Register HW_USBCTRL_USBINTR, field URE

#define BP_USBCTRL_USBINTR_URE      6
#define BM_USBCTRL_USBINTR_URE      0x00000040

#define BF_USBCTRL_USBINTR_URE(v)   (((v) << 6) & BM_USBCTRL_USBINTR_URE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_URE(v)   BF_CS1(USBCTRL_USBINTR, URE, v)
#endif

//--- Register HW_USBCTRL_USBINTR, field AAE

#define BP_USBCTRL_USBINTR_AAE      5
#define BM_USBCTRL_USBINTR_AAE      0x00000020

#define BF_USBCTRL_USBINTR_AAE(v)   (((v) << 5) & BM_USBCTRL_USBINTR_AAE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_AAE(v)   BF_CS1(USBCTRL_USBINTR, AAE, v)
#endif

//--- Register HW_USBCTRL_USBINTR, field SEE

#define BP_USBCTRL_USBINTR_SEE      4
#define BM_USBCTRL_USBINTR_SEE      0x00000010

#define BF_USBCTRL_USBINTR_SEE(v)   (((v) << 4) & BM_USBCTRL_USBINTR_SEE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_SEE(v)   BF_CS1(USBCTRL_USBINTR, SEE, v)
#endif

//--- Register HW_USBCTRL_USBINTR, field FRE

#define BP_USBCTRL_USBINTR_FRE      3
#define BM_USBCTRL_USBINTR_FRE      0x00000008

#define BF_USBCTRL_USBINTR_FRE(v)   (((v) << 3) & BM_USBCTRL_USBINTR_FRE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_FRE(v)   BF_CS1(USBCTRL_USBINTR, FRE, v)
#endif

//--- Register HW_USBCTRL_USBINTR, field PCE

#define BP_USBCTRL_USBINTR_PCE      2
#define BM_USBCTRL_USBINTR_PCE      0x00000004

#define BF_USBCTRL_USBINTR_PCE(v)   (((v) << 2) & BM_USBCTRL_USBINTR_PCE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_PCE(v)   BF_CS1(USBCTRL_USBINTR, PCE, v)
#endif

//--- Register HW_USBCTRL_USBINTR, field UEE

#define BP_USBCTRL_USBINTR_UEE      1
#define BM_USBCTRL_USBINTR_UEE      0x00000002

#define BF_USBCTRL_USBINTR_UEE(v)   (((v) << 1) & BM_USBCTRL_USBINTR_UEE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_UEE(v)   BF_CS1(USBCTRL_USBINTR, UEE, v)
#endif

//--- Register HW_USBCTRL_USBINTR, field UE

#define BP_USBCTRL_USBINTR_UE      0
#define BM_USBCTRL_USBINTR_UE      0x00000001

#define BF_USBCTRL_USBINTR_UE(v)   (((v) << 0) & BM_USBCTRL_USBINTR_UE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBINTR_UE(v)   BF_CS1(USBCTRL_USBINTR, UE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_FRINDEX - USB Frame Index Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned UINDEX   :  3;
        unsigned FRINDEX  : 11;
        unsigned RSVD     : 18;
    } B;
} hw_usbctrl_frindex_t;
#endif


//
// constants & macros for entire HW_USBCTRL_FRINDEX register
//

#define HW_USBCTRL_FRINDEX_ADDR      (REGS_USBCTRL_BASE + 0x0000014C)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_FRINDEX           (*(volatile hw_usbctrl_frindex_t *) HW_USBCTRL_FRINDEX_ADDR)
#define HW_USBCTRL_FRINDEX_RD()      (HW_USBCTRL_FRINDEX.U)
#define HW_USBCTRL_FRINDEX_WR(v)     (HW_USBCTRL_FRINDEX.U = (v))
#define HW_USBCTRL_FRINDEX_SET(v)    (HW_USBCTRL_FRINDEX_WR(HW_USBCTRL_FRINDEX_RD() |  (v)))
#define HW_USBCTRL_FRINDEX_CLR(v)    (HW_USBCTRL_FRINDEX_WR(HW_USBCTRL_FRINDEX_RD() & ~(v)))
#define HW_USBCTRL_FRINDEX_TOG(v)    (HW_USBCTRL_FRINDEX_WR(HW_USBCTRL_FRINDEX_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_FRINDEX bitfields
//

//--- Register HW_USBCTRL_FRINDEX, field FRINDEX

#define BP_USBCTRL_FRINDEX_FRINDEX      3
#define BM_USBCTRL_FRINDEX_FRINDEX      0x00003FF8

#define BF_USBCTRL_FRINDEX_FRINDEX(v)   (((v) << 3) & BM_USBCTRL_FRINDEX_FRINDEX)

#define BV_USBCTRL_FRINDEX_FRINDEX__N_12  12
#define BV_USBCTRL_FRINDEX_FRINDEX__N_11  11
#define BV_USBCTRL_FRINDEX_FRINDEX__N_10  10
#define BV_USBCTRL_FRINDEX_FRINDEX__N_9   9
#define BV_USBCTRL_FRINDEX_FRINDEX__N_8   8
#define BV_USBCTRL_FRINDEX_FRINDEX__N_7   7
#define BV_USBCTRL_FRINDEX_FRINDEX__N_6   6
#define BV_USBCTRL_FRINDEX_FRINDEX__N_5   5

//--- Register HW_USBCTRL_FRINDEX, field UINDEX

#define BP_USBCTRL_FRINDEX_UINDEX      0
#define BM_USBCTRL_FRINDEX_UINDEX      0x00000007

#define BF_USBCTRL_FRINDEX_UINDEX(v)   (((v) << 0) & BM_USBCTRL_FRINDEX_UINDEX)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_FRINDEX_UINDEX(v)   BF_CS1(USBCTRL_FRINDEX, UINDEX, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_PERIODICLISTBASE - Frame List Base Address Register (Host Controller mode)
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD     : 12;
        unsigned PERBASE  : 20;
    } B;
} hw_usbctrl_periodiclistbase_t;
#endif


//
// constants & macros for entire HW_USBCTRL_PERIODICLISTBASE register
//

#define HW_USBCTRL_PERIODICLISTBASE_ADDR      (REGS_USBCTRL_BASE + 0x00000154)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_PERIODICLISTBASE           (*(volatile hw_usbctrl_periodiclistbase_t *) HW_USBCTRL_PERIODICLISTBASE_ADDR)
#define HW_USBCTRL_PERIODICLISTBASE_RD()      (HW_USBCTRL_PERIODICLISTBASE.U)
#define HW_USBCTRL_PERIODICLISTBASE_WR(v)     (HW_USBCTRL_PERIODICLISTBASE.U = (v))
#define HW_USBCTRL_PERIODICLISTBASE_SET(v)    (HW_USBCTRL_PERIODICLISTBASE_WR(HW_USBCTRL_PERIODICLISTBASE_RD() |  (v)))
#define HW_USBCTRL_PERIODICLISTBASE_CLR(v)    (HW_USBCTRL_PERIODICLISTBASE_WR(HW_USBCTRL_PERIODICLISTBASE_RD() & ~(v)))
#define HW_USBCTRL_PERIODICLISTBASE_TOG(v)    (HW_USBCTRL_PERIODICLISTBASE_WR(HW_USBCTRL_PERIODICLISTBASE_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_PERIODICLISTBASE bitfields
//

//--- Register HW_USBCTRL_PERIODICLISTBASE, field PERBASE

#define BP_USBCTRL_PERIODICLISTBASE_PERBASE      12
#define BM_USBCTRL_PERIODICLISTBASE_PERBASE      0xFFFFF000

#ifndef __LANGUAGE_ASM__
#define BF_USBCTRL_PERIODICLISTBASE_PERBASE(v)   ((((reg32_t) v) << 12) & BM_USBCTRL_PERIODICLISTBASE_PERBASE)
#else
#define BF_USBCTRL_PERIODICLISTBASE_PERBASE(v)   (((v) << 12) & BM_USBCTRL_PERIODICLISTBASE_PERBASE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PERIODICLISTBASE_PERBASE(v)   BF_CS1(USBCTRL_PERIODICLISTBASE, PERBASE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_DEVICEADDR - USB Device Address Register (Device Controller mode)
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD     : 24;
        unsigned USBADRA  :  1;
        unsigned USBADR   :  7;
    } B;
} hw_usbctrl_deviceaddr_t;
#endif


//
// constants & macros for entire HW_USBCTRL_DEVICEADDR register
//

#define HW_USBCTRL_DEVICEADDR_ADDR      (REGS_USBCTRL_BASE + 0x00000154)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_DEVICEADDR           (*(volatile hw_usbctrl_deviceaddr_t *) HW_USBCTRL_DEVICEADDR_ADDR)
#define HW_USBCTRL_DEVICEADDR_RD()      (HW_USBCTRL_DEVICEADDR.U)
#define HW_USBCTRL_DEVICEADDR_WR(v)     (HW_USBCTRL_DEVICEADDR.U = (v))
#define HW_USBCTRL_DEVICEADDR_SET(v)    (HW_USBCTRL_DEVICEADDR_WR(HW_USBCTRL_DEVICEADDR_RD() |  (v)))
#define HW_USBCTRL_DEVICEADDR_CLR(v)    (HW_USBCTRL_DEVICEADDR_WR(HW_USBCTRL_DEVICEADDR_RD() & ~(v)))
#define HW_USBCTRL_DEVICEADDR_TOG(v)    (HW_USBCTRL_DEVICEADDR_WR(HW_USBCTRL_DEVICEADDR_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_DEVICEADDR bitfields
//

//--- Register HW_USBCTRL_DEVICEADDR, field USBADR

#define BP_USBCTRL_DEVICEADDR_USBADR      25
#define BM_USBCTRL_DEVICEADDR_USBADR      0xFE000000

#ifndef __LANGUAGE_ASM__
#define BF_USBCTRL_DEVICEADDR_USBADR(v)   ((((reg32_t) v) << 25) & BM_USBCTRL_DEVICEADDR_USBADR)
#else
#define BF_USBCTRL_DEVICEADDR_USBADR(v)   (((v) << 25) & BM_USBCTRL_DEVICEADDR_USBADR)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_DEVICEADDR_USBADR(v)   BF_CS1(USBCTRL_DEVICEADDR, USBADR, v)
#endif

//--- Register HW_USBCTRL_DEVICEADDR, field USBADRA

#define BP_USBCTRL_DEVICEADDR_USBADRA      24
#define BM_USBCTRL_DEVICEADDR_USBADRA      0x01000000

#define BF_USBCTRL_DEVICEADDR_USBADRA(v)   (((v) << 24) & BM_USBCTRL_DEVICEADDR_USBADRA)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_DEVICEADDR_USBADRA(v)   BF_CS1(USBCTRL_DEVICEADDR, USBADRA, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_ASYNCLISTADDR - Next Asynchronous Address Register (Host Controller mode)
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD     :  5;
        unsigned ASYBASE  : 27;
    } B;
} hw_usbctrl_asynclistaddr_t;
#endif


//
// constants & macros for entire HW_USBCTRL_ASYNCLISTADDR register
//

#define HW_USBCTRL_ASYNCLISTADDR_ADDR      (REGS_USBCTRL_BASE + 0x00000158)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_ASYNCLISTADDR           (*(volatile hw_usbctrl_asynclistaddr_t *) HW_USBCTRL_ASYNCLISTADDR_ADDR)
#define HW_USBCTRL_ASYNCLISTADDR_RD()      (HW_USBCTRL_ASYNCLISTADDR.U)
#define HW_USBCTRL_ASYNCLISTADDR_WR(v)     (HW_USBCTRL_ASYNCLISTADDR.U = (v))
#define HW_USBCTRL_ASYNCLISTADDR_SET(v)    (HW_USBCTRL_ASYNCLISTADDR_WR(HW_USBCTRL_ASYNCLISTADDR_RD() |  (v)))
#define HW_USBCTRL_ASYNCLISTADDR_CLR(v)    (HW_USBCTRL_ASYNCLISTADDR_WR(HW_USBCTRL_ASYNCLISTADDR_RD() & ~(v)))
#define HW_USBCTRL_ASYNCLISTADDR_TOG(v)    (HW_USBCTRL_ASYNCLISTADDR_WR(HW_USBCTRL_ASYNCLISTADDR_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_ASYNCLISTADDR bitfields
//

//--- Register HW_USBCTRL_ASYNCLISTADDR, field ASYBASE

#define BP_USBCTRL_ASYNCLISTADDR_ASYBASE      5
#define BM_USBCTRL_ASYNCLISTADDR_ASYBASE      0xFFFFFFE0

#ifndef __LANGUAGE_ASM__
#define BF_USBCTRL_ASYNCLISTADDR_ASYBASE(v)   ((((reg32_t) v) << 5) & BM_USBCTRL_ASYNCLISTADDR_ASYBASE)
#else
#define BF_USBCTRL_ASYNCLISTADDR_ASYBASE(v)   (((v) << 5) & BM_USBCTRL_ASYNCLISTADDR_ASYBASE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ASYNCLISTADDR_ASYBASE(v)   BF_CS1(USBCTRL_ASYNCLISTADDR, ASYBASE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_ENDPOINTLISTADDR - Endpoint List Address Register (Device Controller mode)
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD    : 11;
        unsigned EPBASE  : 21;
    } B;
} hw_usbctrl_endpointlistaddr_t;
#endif


//
// constants & macros for entire HW_USBCTRL_ENDPOINTLISTADDR register
//

#define HW_USBCTRL_ENDPOINTLISTADDR_ADDR      (REGS_USBCTRL_BASE + 0x00000158)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_ENDPOINTLISTADDR           (*(volatile hw_usbctrl_endpointlistaddr_t *) HW_USBCTRL_ENDPOINTLISTADDR_ADDR)
#define HW_USBCTRL_ENDPOINTLISTADDR_RD()      (HW_USBCTRL_ENDPOINTLISTADDR.U)
#define HW_USBCTRL_ENDPOINTLISTADDR_WR(v)     (HW_USBCTRL_ENDPOINTLISTADDR.U = (v))
#define HW_USBCTRL_ENDPOINTLISTADDR_SET(v)    (HW_USBCTRL_ENDPOINTLISTADDR_WR(HW_USBCTRL_ENDPOINTLISTADDR_RD() |  (v)))
#define HW_USBCTRL_ENDPOINTLISTADDR_CLR(v)    (HW_USBCTRL_ENDPOINTLISTADDR_WR(HW_USBCTRL_ENDPOINTLISTADDR_RD() & ~(v)))
#define HW_USBCTRL_ENDPOINTLISTADDR_TOG(v)    (HW_USBCTRL_ENDPOINTLISTADDR_WR(HW_USBCTRL_ENDPOINTLISTADDR_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_ENDPOINTLISTADDR bitfields
//

//--- Register HW_USBCTRL_ENDPOINTLISTADDR, field EPBASE

#define BP_USBCTRL_ENDPOINTLISTADDR_EPBASE      11
#define BM_USBCTRL_ENDPOINTLISTADDR_EPBASE      0xFFFFF800

#ifndef __LANGUAGE_ASM__
#define BF_USBCTRL_ENDPOINTLISTADDR_EPBASE(v)   ((((reg32_t) v) << 11) & BM_USBCTRL_ENDPOINTLISTADDR_EPBASE)
#else
#define BF_USBCTRL_ENDPOINTLISTADDR_EPBASE(v)   (((v) << 11) & BM_USBCTRL_ENDPOINTLISTADDR_EPBASE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPOINTLISTADDR_EPBASE(v)   BF_CS1(USBCTRL_ENDPOINTLISTADDR, EPBASE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_TTCTRL - Embedded TT Asynchronous Buffer Status and Control Register (Host Controller mode)
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD2  : 24;
        unsigned TTHA   :  7;
        unsigned RSVD1  :  1;
    } B;
} hw_usbctrl_ttctrl_t;
#endif


//
// constants & macros for entire HW_USBCTRL_TTCTRL register
//

#define HW_USBCTRL_TTCTRL_ADDR      (REGS_USBCTRL_BASE + 0x0000015C)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_TTCTRL           (*(volatile hw_usbctrl_ttctrl_t *) HW_USBCTRL_TTCTRL_ADDR)
#define HW_USBCTRL_TTCTRL_RD()      (HW_USBCTRL_TTCTRL.U)
#define HW_USBCTRL_TTCTRL_WR(v)     (HW_USBCTRL_TTCTRL.U = (v))
#define HW_USBCTRL_TTCTRL_SET(v)    (HW_USBCTRL_TTCTRL_WR(HW_USBCTRL_TTCTRL_RD() |  (v)))
#define HW_USBCTRL_TTCTRL_CLR(v)    (HW_USBCTRL_TTCTRL_WR(HW_USBCTRL_TTCTRL_RD() & ~(v)))
#define HW_USBCTRL_TTCTRL_TOG(v)    (HW_USBCTRL_TTCTRL_WR(HW_USBCTRL_TTCTRL_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_TTCTRL bitfields
//

//--- Register HW_USBCTRL_TTCTRL, field TTHA

#define BP_USBCTRL_TTCTRL_TTHA      24
#define BM_USBCTRL_TTCTRL_TTHA      0x7F000000

#define BF_USBCTRL_TTCTRL_TTHA(v)   (((v) << 24) & BM_USBCTRL_TTCTRL_TTHA)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_TTCTRL_TTHA(v)   BF_CS1(USBCTRL_TTCTRL, TTHA, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_BURSTSIZE - Programmable Burst Size Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   RXPBURST;
        reg8_t   TXPBURST;
        reg16_t  RSVD;
    } B;
} hw_usbctrl_burstsize_t;
#endif


//
// constants & macros for entire HW_USBCTRL_BURSTSIZE register
//

#define HW_USBCTRL_BURSTSIZE_ADDR      (REGS_USBCTRL_BASE + 0x00000160)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_BURSTSIZE           (*(volatile hw_usbctrl_burstsize_t *) HW_USBCTRL_BURSTSIZE_ADDR)
#define HW_USBCTRL_BURSTSIZE_RD()      (HW_USBCTRL_BURSTSIZE.U)
#define HW_USBCTRL_BURSTSIZE_WR(v)     (HW_USBCTRL_BURSTSIZE.U = (v))
#define HW_USBCTRL_BURSTSIZE_SET(v)    (HW_USBCTRL_BURSTSIZE_WR(HW_USBCTRL_BURSTSIZE_RD() |  (v)))
#define HW_USBCTRL_BURSTSIZE_CLR(v)    (HW_USBCTRL_BURSTSIZE_WR(HW_USBCTRL_BURSTSIZE_RD() & ~(v)))
#define HW_USBCTRL_BURSTSIZE_TOG(v)    (HW_USBCTRL_BURSTSIZE_WR(HW_USBCTRL_BURSTSIZE_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_BURSTSIZE bitfields
//

//--- Register HW_USBCTRL_BURSTSIZE, field TXPBURST

#define BP_USBCTRL_BURSTSIZE_TXPBURST      8
#define BM_USBCTRL_BURSTSIZE_TXPBURST      0x0000FF00

#define BF_USBCTRL_BURSTSIZE_TXPBURST(v)   (((v) << 8) & BM_USBCTRL_BURSTSIZE_TXPBURST)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_BURSTSIZE_TXPBURST(v)   (HW_USBCTRL_BURSTSIZE.B.TXPBURST = (v))
#endif

//--- Register HW_USBCTRL_BURSTSIZE, field RXPBURST

#define BP_USBCTRL_BURSTSIZE_RXPBURST      0
#define BM_USBCTRL_BURSTSIZE_RXPBURST      0x000000FF

#define BF_USBCTRL_BURSTSIZE_RXPBURST(v)   (((v) << 0) & BM_USBCTRL_BURSTSIZE_RXPBURST)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_BURSTSIZE_RXPBURST(v)   (HW_USBCTRL_BURSTSIZE.B.RXPBURST = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_TXFILLTUNING - Host Transmit Pre-Buffer Packet Timing Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TXSCHOH      :  7;
        unsigned RSVD0        :  1;
        unsigned TXSCHEALTH   :  5;
        unsigned RSVD1        :  3;
        unsigned TXFIFOTHRES  :  6;
        unsigned RSVD2        : 10;
    } B;
} hw_usbctrl_txfilltuning_t;
#endif


//
// constants & macros for entire HW_USBCTRL_TXFILLTUNING register
//

#define HW_USBCTRL_TXFILLTUNING_ADDR      (REGS_USBCTRL_BASE + 0x00000164)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_TXFILLTUNING           (*(volatile hw_usbctrl_txfilltuning_t *) HW_USBCTRL_TXFILLTUNING_ADDR)
#define HW_USBCTRL_TXFILLTUNING_RD()      (HW_USBCTRL_TXFILLTUNING.U)
#define HW_USBCTRL_TXFILLTUNING_WR(v)     (HW_USBCTRL_TXFILLTUNING.U = (v))
#define HW_USBCTRL_TXFILLTUNING_SET(v)    (HW_USBCTRL_TXFILLTUNING_WR(HW_USBCTRL_TXFILLTUNING_RD() |  (v)))
#define HW_USBCTRL_TXFILLTUNING_CLR(v)    (HW_USBCTRL_TXFILLTUNING_WR(HW_USBCTRL_TXFILLTUNING_RD() & ~(v)))
#define HW_USBCTRL_TXFILLTUNING_TOG(v)    (HW_USBCTRL_TXFILLTUNING_WR(HW_USBCTRL_TXFILLTUNING_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_TXFILLTUNING bitfields
//

//--- Register HW_USBCTRL_TXFILLTUNING, field TXFIFOTHRES

#define BP_USBCTRL_TXFILLTUNING_TXFIFOTHRES      16
#define BM_USBCTRL_TXFILLTUNING_TXFIFOTHRES      0x003F0000

#define BF_USBCTRL_TXFILLTUNING_TXFIFOTHRES(v)   (((v) << 16) & BM_USBCTRL_TXFILLTUNING_TXFIFOTHRES)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_TXFILLTUNING_TXFIFOTHRES(v)   BF_CS1(USBCTRL_TXFILLTUNING, TXFIFOTHRES, v)
#endif

//--- Register HW_USBCTRL_TXFILLTUNING, field TXSCHEALTH

#define BP_USBCTRL_TXFILLTUNING_TXSCHEALTH      8
#define BM_USBCTRL_TXFILLTUNING_TXSCHEALTH      0x00001F00

#define BF_USBCTRL_TXFILLTUNING_TXSCHEALTH(v)   (((v) << 8) & BM_USBCTRL_TXFILLTUNING_TXSCHEALTH)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_TXFILLTUNING_TXSCHEALTH(v)   BF_CS1(USBCTRL_TXFILLTUNING, TXSCHEALTH, v)
#endif

//--- Register HW_USBCTRL_TXFILLTUNING, field TXSCHOH

#define BP_USBCTRL_TXFILLTUNING_TXSCHOH      0
#define BM_USBCTRL_TXFILLTUNING_TXSCHOH      0x0000007F

#define BF_USBCTRL_TXFILLTUNING_TXSCHOH(v)   (((v) << 0) & BM_USBCTRL_TXFILLTUNING_TXSCHOH)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_TXFILLTUNING_TXSCHOH(v)   BF_CS1(USBCTRL_TXFILLTUNING, TXSCHOH, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_IC_USB - Inter-Chip Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IC_VDD     :  3;
        unsigned IC_ENABLE  :  1;
        unsigned RSVD       : 28;
    } B;
} hw_usbctrl_ic_usb_t;
#endif


//
// constants & macros for entire HW_USBCTRL_IC_USB register
//

#define HW_USBCTRL_IC_USB_ADDR      (REGS_USBCTRL_BASE + 0x0000016C)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_IC_USB           (*(volatile hw_usbctrl_ic_usb_t *) HW_USBCTRL_IC_USB_ADDR)
#define HW_USBCTRL_IC_USB_RD()      (HW_USBCTRL_IC_USB.U)
#define HW_USBCTRL_IC_USB_WR(v)     (HW_USBCTRL_IC_USB.U = (v))
#define HW_USBCTRL_IC_USB_SET(v)    (HW_USBCTRL_IC_USB_WR(HW_USBCTRL_IC_USB_RD() |  (v)))
#define HW_USBCTRL_IC_USB_CLR(v)    (HW_USBCTRL_IC_USB_WR(HW_USBCTRL_IC_USB_RD() & ~(v)))
#define HW_USBCTRL_IC_USB_TOG(v)    (HW_USBCTRL_IC_USB_WR(HW_USBCTRL_IC_USB_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_IC_USB bitfields
//

//--- Register HW_USBCTRL_IC_USB, field IC_ENABLE

#define BP_USBCTRL_IC_USB_IC_ENABLE      3
#define BM_USBCTRL_IC_USB_IC_ENABLE      0x00000008

#define BF_USBCTRL_IC_USB_IC_ENABLE(v)   (((v) << 3) & BM_USBCTRL_IC_USB_IC_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_IC_USB_IC_ENABLE(v)   BF_CS1(USBCTRL_IC_USB, IC_ENABLE, v)
#endif

//--- Register HW_USBCTRL_IC_USB, field IC_VDD

#define BP_USBCTRL_IC_USB_IC_VDD      0
#define BM_USBCTRL_IC_USB_IC_VDD      0x00000007

#define BF_USBCTRL_IC_USB_IC_VDD(v)   (((v) << 0) & BM_USBCTRL_IC_USB_IC_VDD)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_IC_USB_IC_VDD(v)   BF_CS1(USBCTRL_IC_USB, IC_VDD, v)
#endif

#define BV_USBCTRL_IC_USB_IC_VDD__VOLTAGE_NONE  0x0
#define BV_USBCTRL_IC_USB_IC_VDD__VOLTAGE_1_0   0x1
#define BV_USBCTRL_IC_USB_IC_VDD__VOLTAGE_1_2   0x2
#define BV_USBCTRL_IC_USB_IC_VDD__VOLTAGE_1_5   0x3
#define BV_USBCTRL_IC_USB_IC_VDD__VOLTAGE_1_8   0x4
#define BV_USBCTRL_IC_USB_IC_VDD__VOLTAGE_3_0   0x5
#define BV_USBCTRL_IC_USB_IC_VDD__RESERVED0     0x6
#define BV_USBCTRL_IC_USB_IC_VDD__RESERVED1     0x7


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_ULPI - ULPI Viewport Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   ULPIDATWR;
        reg8_t   ULPIDATRD;
        reg8_t   ULPIADDR;
        unsigned ULPIPORT   :  3;
        unsigned ULPISS     :  1;
        unsigned RSVD0      :  1;
        unsigned ULPIRW     :  1;
        unsigned ULPIRUN    :  1;
        unsigned ULPIWU     :  1;
    } B;
} hw_usbctrl_ulpi_t;
#endif


//
// constants & macros for entire HW_USBCTRL_ULPI register
//

#define HW_USBCTRL_ULPI_ADDR      (REGS_USBCTRL_BASE + 0x00000170)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_ULPI           (*(volatile hw_usbctrl_ulpi_t *) HW_USBCTRL_ULPI_ADDR)
#define HW_USBCTRL_ULPI_RD()      (HW_USBCTRL_ULPI.U)
#define HW_USBCTRL_ULPI_WR(v)     (HW_USBCTRL_ULPI.U = (v))
#define HW_USBCTRL_ULPI_SET(v)    (HW_USBCTRL_ULPI_WR(HW_USBCTRL_ULPI_RD() |  (v)))
#define HW_USBCTRL_ULPI_CLR(v)    (HW_USBCTRL_ULPI_WR(HW_USBCTRL_ULPI_RD() & ~(v)))
#define HW_USBCTRL_ULPI_TOG(v)    (HW_USBCTRL_ULPI_WR(HW_USBCTRL_ULPI_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_ULPI bitfields
//

//--- Register HW_USBCTRL_ULPI, field ULPIWU

#define BP_USBCTRL_ULPI_ULPIWU      31
#define BM_USBCTRL_ULPI_ULPIWU      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_USBCTRL_ULPI_ULPIWU(v)   ((((reg32_t) v) << 31) & BM_USBCTRL_ULPI_ULPIWU)
#else
#define BF_USBCTRL_ULPI_ULPIWU(v)   (((v) << 31) & BM_USBCTRL_ULPI_ULPIWU)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ULPI_ULPIWU(v)   BF_CS1(USBCTRL_ULPI, ULPIWU, v)
#endif

//--- Register HW_USBCTRL_ULPI, field ULPIRUN

#define BP_USBCTRL_ULPI_ULPIRUN      30
#define BM_USBCTRL_ULPI_ULPIRUN      0x40000000

#define BF_USBCTRL_ULPI_ULPIRUN(v)   (((v) << 30) & BM_USBCTRL_ULPI_ULPIRUN)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ULPI_ULPIRUN(v)   BF_CS1(USBCTRL_ULPI, ULPIRUN, v)
#endif

//--- Register HW_USBCTRL_ULPI, field ULPIRW

#define BP_USBCTRL_ULPI_ULPIRW      29
#define BM_USBCTRL_ULPI_ULPIRW      0x20000000

#define BF_USBCTRL_ULPI_ULPIRW(v)   (((v) << 29) & BM_USBCTRL_ULPI_ULPIRW)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ULPI_ULPIRW(v)   BF_CS1(USBCTRL_ULPI, ULPIRW, v)
#endif

//--- Register HW_USBCTRL_ULPI, field ULPISS

#define BP_USBCTRL_ULPI_ULPISS      27
#define BM_USBCTRL_ULPI_ULPISS      0x08000000

#define BF_USBCTRL_ULPI_ULPISS(v)   (((v) << 27) & BM_USBCTRL_ULPI_ULPISS)

//--- Register HW_USBCTRL_ULPI, field ULPIPORT

#define BP_USBCTRL_ULPI_ULPIPORT      24
#define BM_USBCTRL_ULPI_ULPIPORT      0x07000000

#define BF_USBCTRL_ULPI_ULPIPORT(v)   (((v) << 24) & BM_USBCTRL_ULPI_ULPIPORT)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ULPI_ULPIPORT(v)   BF_CS1(USBCTRL_ULPI, ULPIPORT, v)
#endif

//--- Register HW_USBCTRL_ULPI, field ULPIADDR

#define BP_USBCTRL_ULPI_ULPIADDR      16
#define BM_USBCTRL_ULPI_ULPIADDR      0x00FF0000

#define BF_USBCTRL_ULPI_ULPIADDR(v)   (((v) << 16) & BM_USBCTRL_ULPI_ULPIADDR)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ULPI_ULPIADDR(v)   (HW_USBCTRL_ULPI.B.ULPIADDR = (v))
#endif

//--- Register HW_USBCTRL_ULPI, field ULPIDATRD

#define BP_USBCTRL_ULPI_ULPIDATRD      8
#define BM_USBCTRL_ULPI_ULPIDATRD      0x0000FF00

#define BF_USBCTRL_ULPI_ULPIDATRD(v)   (((v) << 8) & BM_USBCTRL_ULPI_ULPIDATRD)

//--- Register HW_USBCTRL_ULPI, field ULPIDATWR

#define BP_USBCTRL_ULPI_ULPIDATWR      0
#define BM_USBCTRL_ULPI_ULPIDATWR      0x000000FF

#define BF_USBCTRL_ULPI_ULPIDATWR(v)   (((v) << 0) & BM_USBCTRL_ULPI_ULPIDATWR)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ULPI_ULPIDATWR(v)   (HW_USBCTRL_ULPI.B.ULPIDATWR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_ENDPTNAK - Endpoint NAK Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned EPRN   :  5;
        unsigned RSVD0  : 11;
        unsigned EPTN   :  5;
        unsigned RSVD1  : 11;
    } B;
} hw_usbctrl_endptnak_t;
#endif


//
// constants & macros for entire HW_USBCTRL_ENDPTNAK register
//

#define HW_USBCTRL_ENDPTNAK_ADDR      (REGS_USBCTRL_BASE + 0x00000178)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_ENDPTNAK           (*(volatile hw_usbctrl_endptnak_t *) HW_USBCTRL_ENDPTNAK_ADDR)
#define HW_USBCTRL_ENDPTNAK_RD()      (HW_USBCTRL_ENDPTNAK.U)
#define HW_USBCTRL_ENDPTNAK_WR(v)     (HW_USBCTRL_ENDPTNAK.U = (v))
#define HW_USBCTRL_ENDPTNAK_SET(v)    (HW_USBCTRL_ENDPTNAK_WR(HW_USBCTRL_ENDPTNAK_RD() |  (v)))
#define HW_USBCTRL_ENDPTNAK_CLR(v)    (HW_USBCTRL_ENDPTNAK_WR(HW_USBCTRL_ENDPTNAK_RD() & ~(v)))
#define HW_USBCTRL_ENDPTNAK_TOG(v)    (HW_USBCTRL_ENDPTNAK_WR(HW_USBCTRL_ENDPTNAK_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_ENDPTNAK bitfields
//

//--- Register HW_USBCTRL_ENDPTNAK, field EPTN

#define BP_USBCTRL_ENDPTNAK_EPTN      16
#define BM_USBCTRL_ENDPTNAK_EPTN      0x001F0000

#define BF_USBCTRL_ENDPTNAK_EPTN(v)   (((v) << 16) & BM_USBCTRL_ENDPTNAK_EPTN)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTNAK_EPTN(v)   BF_CS1(USBCTRL_ENDPTNAK, EPTN, v)
#endif

//--- Register HW_USBCTRL_ENDPTNAK, field EPRN

#define BP_USBCTRL_ENDPTNAK_EPRN      0
#define BM_USBCTRL_ENDPTNAK_EPRN      0x0000001F

#define BF_USBCTRL_ENDPTNAK_EPRN(v)   (((v) << 0) & BM_USBCTRL_ENDPTNAK_EPRN)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTNAK_EPRN(v)   BF_CS1(USBCTRL_ENDPTNAK, EPRN, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_ENDPTNAKEN - Endpoint NAK Enable Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned EPRNE  :  5;
        unsigned RSVD0  : 11;
        unsigned EPTNE  :  5;
        unsigned RSVD1  : 11;
    } B;
} hw_usbctrl_endptnaken_t;
#endif


//
// constants & macros for entire HW_USBCTRL_ENDPTNAKEN register
//

#define HW_USBCTRL_ENDPTNAKEN_ADDR      (REGS_USBCTRL_BASE + 0x0000017C)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_ENDPTNAKEN           (*(volatile hw_usbctrl_endptnaken_t *) HW_USBCTRL_ENDPTNAKEN_ADDR)
#define HW_USBCTRL_ENDPTNAKEN_RD()      (HW_USBCTRL_ENDPTNAKEN.U)
#define HW_USBCTRL_ENDPTNAKEN_WR(v)     (HW_USBCTRL_ENDPTNAKEN.U = (v))
#define HW_USBCTRL_ENDPTNAKEN_SET(v)    (HW_USBCTRL_ENDPTNAKEN_WR(HW_USBCTRL_ENDPTNAKEN_RD() |  (v)))
#define HW_USBCTRL_ENDPTNAKEN_CLR(v)    (HW_USBCTRL_ENDPTNAKEN_WR(HW_USBCTRL_ENDPTNAKEN_RD() & ~(v)))
#define HW_USBCTRL_ENDPTNAKEN_TOG(v)    (HW_USBCTRL_ENDPTNAKEN_WR(HW_USBCTRL_ENDPTNAKEN_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_ENDPTNAKEN bitfields
//

//--- Register HW_USBCTRL_ENDPTNAKEN, field EPTNE

#define BP_USBCTRL_ENDPTNAKEN_EPTNE      16
#define BM_USBCTRL_ENDPTNAKEN_EPTNE      0x001F0000

#define BF_USBCTRL_ENDPTNAKEN_EPTNE(v)   (((v) << 16) & BM_USBCTRL_ENDPTNAKEN_EPTNE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTNAKEN_EPTNE(v)   BF_CS1(USBCTRL_ENDPTNAKEN, EPTNE, v)
#endif

//--- Register HW_USBCTRL_ENDPTNAKEN, field EPRNE

#define BP_USBCTRL_ENDPTNAKEN_EPRNE      0
#define BM_USBCTRL_ENDPTNAKEN_EPRNE      0x0000001F

#define BF_USBCTRL_ENDPTNAKEN_EPRNE(v)   (((v) << 0) & BM_USBCTRL_ENDPTNAKEN_EPRNE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTNAKEN_EPRNE(v)   BF_CS1(USBCTRL_ENDPTNAKEN, EPRNE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_PORTSC1 - Port Status and Control 1 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CCS   :  1;
        unsigned CSC   :  1;
        unsigned PE    :  1;
        unsigned PEC   :  1;
        unsigned OCA   :  1;
        unsigned OCC   :  1;
        unsigned FPR   :  1;
        unsigned SUSP  :  1;
        unsigned PR    :  1;
        unsigned HSP   :  1;
        unsigned LS    :  2;
        unsigned PP    :  1;
        unsigned PO    :  1;
        unsigned PIC   :  2;
        unsigned PTC   :  4;
        unsigned WKCN  :  1;
        unsigned WKDS  :  1;
        unsigned WKOC  :  1;
        unsigned PHCD  :  1;
        unsigned PFSC  :  1;
        unsigned SRT   :  1;
        unsigned PSPD  :  2;
        unsigned PTW   :  1;
        unsigned STS   :  1;
        unsigned PTS   :  2;
    } B;
} hw_usbctrl_portsc1_t;
#endif


//
// constants & macros for entire HW_USBCTRL_PORTSC1 register
//

#define HW_USBCTRL_PORTSC1_ADDR      (REGS_USBCTRL_BASE + 0x00000184)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_PORTSC1           (*(volatile hw_usbctrl_portsc1_t *) HW_USBCTRL_PORTSC1_ADDR)
#define HW_USBCTRL_PORTSC1_RD()      (HW_USBCTRL_PORTSC1.U)
#define HW_USBCTRL_PORTSC1_WR(v)     (HW_USBCTRL_PORTSC1.U = (v))
#define HW_USBCTRL_PORTSC1_SET(v)    (HW_USBCTRL_PORTSC1_WR(HW_USBCTRL_PORTSC1_RD() |  (v)))
#define HW_USBCTRL_PORTSC1_CLR(v)    (HW_USBCTRL_PORTSC1_WR(HW_USBCTRL_PORTSC1_RD() & ~(v)))
#define HW_USBCTRL_PORTSC1_TOG(v)    (HW_USBCTRL_PORTSC1_WR(HW_USBCTRL_PORTSC1_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_PORTSC1 bitfields
//

//--- Register HW_USBCTRL_PORTSC1, field PTS

#define BP_USBCTRL_PORTSC1_PTS      30
#define BM_USBCTRL_PORTSC1_PTS      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_USBCTRL_PORTSC1_PTS(v)   ((((reg32_t) v) << 30) & BM_USBCTRL_PORTSC1_PTS)
#else
#define BF_USBCTRL_PORTSC1_PTS(v)   (((v) << 30) & BM_USBCTRL_PORTSC1_PTS)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_PTS(v)   BF_CS1(USBCTRL_PORTSC1, PTS, v)
#endif

#define BV_USBCTRL_PORTSC1_PTS__UTMI    0
#define BV_USBCTRL_PORTSC1_PTS__PHIL    1
#define BV_USBCTRL_PORTSC1_PTS__ULPI    2
#define BV_USBCTRL_PORTSC1_PTS__SERIAL  3

//--- Register HW_USBCTRL_PORTSC1, field STS

#define BP_USBCTRL_PORTSC1_STS      29
#define BM_USBCTRL_PORTSC1_STS      0x20000000

#define BF_USBCTRL_PORTSC1_STS(v)   (((v) << 29) & BM_USBCTRL_PORTSC1_STS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_STS(v)   BF_CS1(USBCTRL_PORTSC1, STS, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field PTW

#define BP_USBCTRL_PORTSC1_PTW      28
#define BM_USBCTRL_PORTSC1_PTW      0x10000000

#define BF_USBCTRL_PORTSC1_PTW(v)   (((v) << 28) & BM_USBCTRL_PORTSC1_PTW)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_PTW(v)   BF_CS1(USBCTRL_PORTSC1, PTW, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field PSPD

#define BP_USBCTRL_PORTSC1_PSPD      26
#define BM_USBCTRL_PORTSC1_PSPD      0x0C000000

#define BF_USBCTRL_PORTSC1_PSPD(v)   (((v) << 26) & BM_USBCTRL_PORTSC1_PSPD)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_PSPD(v)   BF_CS1(USBCTRL_PORTSC1, PSPD, v)
#endif

#define BV_USBCTRL_PORTSC1_PSPD__FULL  0
#define BV_USBCTRL_PORTSC1_PSPD__LOW   1
#define BV_USBCTRL_PORTSC1_PSPD__HIGH  2

//--- Register HW_USBCTRL_PORTSC1, field PFSC

#define BP_USBCTRL_PORTSC1_PFSC      24
#define BM_USBCTRL_PORTSC1_PFSC      0x01000000

#define BF_USBCTRL_PORTSC1_PFSC(v)   (((v) << 24) & BM_USBCTRL_PORTSC1_PFSC)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_PFSC(v)   BF_CS1(USBCTRL_PORTSC1, PFSC, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field PHCD

#define BP_USBCTRL_PORTSC1_PHCD      23
#define BM_USBCTRL_PORTSC1_PHCD      0x00800000

#define BF_USBCTRL_PORTSC1_PHCD(v)   (((v) << 23) & BM_USBCTRL_PORTSC1_PHCD)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_PHCD(v)   BF_CS1(USBCTRL_PORTSC1, PHCD, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field WKOC

#define BP_USBCTRL_PORTSC1_WKOC      22
#define BM_USBCTRL_PORTSC1_WKOC      0x00400000

#define BF_USBCTRL_PORTSC1_WKOC(v)   (((v) << 22) & BM_USBCTRL_PORTSC1_WKOC)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_WKOC(v)   BF_CS1(USBCTRL_PORTSC1, WKOC, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field WKDS

#define BP_USBCTRL_PORTSC1_WKDS      21
#define BM_USBCTRL_PORTSC1_WKDS      0x00200000

#define BF_USBCTRL_PORTSC1_WKDS(v)   (((v) << 21) & BM_USBCTRL_PORTSC1_WKDS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_WKDS(v)   BF_CS1(USBCTRL_PORTSC1, WKDS, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field WKCN

#define BP_USBCTRL_PORTSC1_WKCN      20
#define BM_USBCTRL_PORTSC1_WKCN      0x00100000

#define BF_USBCTRL_PORTSC1_WKCN(v)   (((v) << 20) & BM_USBCTRL_PORTSC1_WKCN)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_WKCN(v)   BF_CS1(USBCTRL_PORTSC1, WKCN, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field PTC

#define BP_USBCTRL_PORTSC1_PTC      16
#define BM_USBCTRL_PORTSC1_PTC      0x000F0000

#define BF_USBCTRL_PORTSC1_PTC(v)   (((v) << 16) & BM_USBCTRL_PORTSC1_PTC)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_PTC(v)   BF_CS1(USBCTRL_PORTSC1, PTC, v)
#endif

#define BV_USBCTRL_PORTSC1_PTC__TEST_DISABLE          0
#define BV_USBCTRL_PORTSC1_PTC__TEST_J_STATE          1
#define BV_USBCTRL_PORTSC1_PTC__TEST_K_STATE          2
#define BV_USBCTRL_PORTSC1_PTC__TEST_J_SE0_NAK        3
#define BV_USBCTRL_PORTSC1_PTC__TEST_PACKET           4
#define BV_USBCTRL_PORTSC1_PTC__TEST_FORCE_ENABLE_HS  5
#define BV_USBCTRL_PORTSC1_PTC__TEST_FORCE_ENABLE_FS  6
#define BV_USBCTRL_PORTSC1_PTC__TEST_FORCE_ENABLE_LS  7

//--- Register HW_USBCTRL_PORTSC1, field PIC

#define BP_USBCTRL_PORTSC1_PIC      14
#define BM_USBCTRL_PORTSC1_PIC      0x0000C000

#define BF_USBCTRL_PORTSC1_PIC(v)   (((v) << 14) & BM_USBCTRL_PORTSC1_PIC)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_PIC(v)   BF_CS1(USBCTRL_PORTSC1, PIC, v)
#endif

#define BV_USBCTRL_PORTSC1_PIC__OFF    0
#define BV_USBCTRL_PORTSC1_PIC__AMBER  1
#define BV_USBCTRL_PORTSC1_PIC__GREEN  2
#define BV_USBCTRL_PORTSC1_PIC__UNDEF  3

//--- Register HW_USBCTRL_PORTSC1, field PO

#define BP_USBCTRL_PORTSC1_PO      13
#define BM_USBCTRL_PORTSC1_PO      0x00002000

#define BF_USBCTRL_PORTSC1_PO(v)   (((v) << 13) & BM_USBCTRL_PORTSC1_PO)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_PO(v)   BF_CS1(USBCTRL_PORTSC1, PO, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field PP

#define BP_USBCTRL_PORTSC1_PP      12
#define BM_USBCTRL_PORTSC1_PP      0x00001000

#define BF_USBCTRL_PORTSC1_PP(v)   (((v) << 12) & BM_USBCTRL_PORTSC1_PP)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_PP(v)   BF_CS1(USBCTRL_PORTSC1, PP, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field LS

#define BP_USBCTRL_PORTSC1_LS      10
#define BM_USBCTRL_PORTSC1_LS      0x00000C00

#define BF_USBCTRL_PORTSC1_LS(v)   (((v) << 10) & BM_USBCTRL_PORTSC1_LS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_LS(v)   BF_CS1(USBCTRL_PORTSC1, LS, v)
#endif

#define BV_USBCTRL_PORTSC1_LS__SE0      0
#define BV_USBCTRL_PORTSC1_LS__K_STATE  1
#define BV_USBCTRL_PORTSC1_LS__J_STATE  2
#define BV_USBCTRL_PORTSC1_LS__UNDEF    3

//--- Register HW_USBCTRL_PORTSC1, field HSP

#define BP_USBCTRL_PORTSC1_HSP      9
#define BM_USBCTRL_PORTSC1_HSP      0x00000200

#define BF_USBCTRL_PORTSC1_HSP(v)   (((v) << 9) & BM_USBCTRL_PORTSC1_HSP)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_HSP(v)   BF_CS1(USBCTRL_PORTSC1, HSP, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field PR

#define BP_USBCTRL_PORTSC1_PR      8
#define BM_USBCTRL_PORTSC1_PR      0x00000100

#define BF_USBCTRL_PORTSC1_PR(v)   (((v) << 8) & BM_USBCTRL_PORTSC1_PR)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_PR(v)   BF_CS1(USBCTRL_PORTSC1, PR, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field SUSP

#define BP_USBCTRL_PORTSC1_SUSP      7
#define BM_USBCTRL_PORTSC1_SUSP      0x00000080

#define BF_USBCTRL_PORTSC1_SUSP(v)   (((v) << 7) & BM_USBCTRL_PORTSC1_SUSP)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_SUSP(v)   BF_CS1(USBCTRL_PORTSC1, SUSP, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field FPR

#define BP_USBCTRL_PORTSC1_FPR      6
#define BM_USBCTRL_PORTSC1_FPR      0x00000040

#define BF_USBCTRL_PORTSC1_FPR(v)   (((v) << 6) & BM_USBCTRL_PORTSC1_FPR)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_FPR(v)   BF_CS1(USBCTRL_PORTSC1, FPR, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field OCC

#define BP_USBCTRL_PORTSC1_OCC      5
#define BM_USBCTRL_PORTSC1_OCC      0x00000020

#define BF_USBCTRL_PORTSC1_OCC(v)   (((v) << 5) & BM_USBCTRL_PORTSC1_OCC)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_OCC(v)   BF_CS1(USBCTRL_PORTSC1, OCC, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field OCA

#define BP_USBCTRL_PORTSC1_OCA      4
#define BM_USBCTRL_PORTSC1_OCA      0x00000010

#define BF_USBCTRL_PORTSC1_OCA(v)   (((v) << 4) & BM_USBCTRL_PORTSC1_OCA)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_OCA(v)   BF_CS1(USBCTRL_PORTSC1, OCA, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field PEC

#define BP_USBCTRL_PORTSC1_PEC      3
#define BM_USBCTRL_PORTSC1_PEC      0x00000008

#define BF_USBCTRL_PORTSC1_PEC(v)   (((v) << 3) & BM_USBCTRL_PORTSC1_PEC)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_PEC(v)   BF_CS1(USBCTRL_PORTSC1, PEC, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field PE

#define BP_USBCTRL_PORTSC1_PE      2
#define BM_USBCTRL_PORTSC1_PE      0x00000004

#define BF_USBCTRL_PORTSC1_PE(v)   (((v) << 2) & BM_USBCTRL_PORTSC1_PE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_PE(v)   BF_CS1(USBCTRL_PORTSC1, PE, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field CSC

#define BP_USBCTRL_PORTSC1_CSC      1
#define BM_USBCTRL_PORTSC1_CSC      0x00000002

#define BF_USBCTRL_PORTSC1_CSC(v)   (((v) << 1) & BM_USBCTRL_PORTSC1_CSC)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_CSC(v)   BF_CS1(USBCTRL_PORTSC1, CSC, v)
#endif

//--- Register HW_USBCTRL_PORTSC1, field CCS

#define BP_USBCTRL_PORTSC1_CCS      0
#define BM_USBCTRL_PORTSC1_CCS      0x00000001

#define BF_USBCTRL_PORTSC1_CCS(v)   (((v) << 0) & BM_USBCTRL_PORTSC1_CCS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_PORTSC1_CCS(v)   BF_CS1(USBCTRL_PORTSC1, CCS, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_OTGSC - OTG Status and Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VD      :  1;
        unsigned VC      :  1;
        unsigned HAAR    :  1;
        unsigned OT      :  1;
        unsigned DP      :  1;
        unsigned IDPU    :  1;
        unsigned HADP    :  1;
        unsigned HABA    :  1;
        unsigned ID      :  1;
        unsigned AVV     :  1;
        unsigned ASV     :  1;
        unsigned BSV     :  1;
        unsigned BSE     :  1;
        unsigned ONEMST  :  1;
        unsigned DPS     :  1;
        unsigned RSVD0   :  1;
        unsigned IDIS    :  1;
        unsigned AVVIS   :  1;
        unsigned ASVIS   :  1;
        unsigned BSVIS   :  1;
        unsigned BSEIS   :  1;
        unsigned ONEMSS  :  1;
        unsigned DPIS    :  1;
        unsigned RSVD1   :  1;
        unsigned IDIE    :  1;
        unsigned AVVIE   :  1;
        unsigned ASVIE   :  1;
        unsigned BSVIE   :  1;
        unsigned BSEIE   :  1;
        unsigned ONEMSE  :  1;
        unsigned DPIE    :  1;
        unsigned RSVD2   :  1;
    } B;
} hw_usbctrl_otgsc_t;
#endif


//
// constants & macros for entire HW_USBCTRL_OTGSC register
//

#define HW_USBCTRL_OTGSC_ADDR      (REGS_USBCTRL_BASE + 0x000001A4)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_OTGSC           (*(volatile hw_usbctrl_otgsc_t *) HW_USBCTRL_OTGSC_ADDR)
#define HW_USBCTRL_OTGSC_RD()      (HW_USBCTRL_OTGSC.U)
#define HW_USBCTRL_OTGSC_WR(v)     (HW_USBCTRL_OTGSC.U = (v))
#define HW_USBCTRL_OTGSC_SET(v)    (HW_USBCTRL_OTGSC_WR(HW_USBCTRL_OTGSC_RD() |  (v)))
#define HW_USBCTRL_OTGSC_CLR(v)    (HW_USBCTRL_OTGSC_WR(HW_USBCTRL_OTGSC_RD() & ~(v)))
#define HW_USBCTRL_OTGSC_TOG(v)    (HW_USBCTRL_OTGSC_WR(HW_USBCTRL_OTGSC_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_OTGSC bitfields
//

//--- Register HW_USBCTRL_OTGSC, field DPIE

#define BP_USBCTRL_OTGSC_DPIE      30
#define BM_USBCTRL_OTGSC_DPIE      0x40000000

#define BF_USBCTRL_OTGSC_DPIE(v)   (((v) << 30) & BM_USBCTRL_OTGSC_DPIE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_DPIE(v)   BF_CS1(USBCTRL_OTGSC, DPIE, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field ONEMSE

#define BP_USBCTRL_OTGSC_ONEMSE      29
#define BM_USBCTRL_OTGSC_ONEMSE      0x20000000

#define BF_USBCTRL_OTGSC_ONEMSE(v)   (((v) << 29) & BM_USBCTRL_OTGSC_ONEMSE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_ONEMSE(v)   BF_CS1(USBCTRL_OTGSC, ONEMSE, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field BSEIE

#define BP_USBCTRL_OTGSC_BSEIE      28
#define BM_USBCTRL_OTGSC_BSEIE      0x10000000

#define BF_USBCTRL_OTGSC_BSEIE(v)   (((v) << 28) & BM_USBCTRL_OTGSC_BSEIE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_BSEIE(v)   BF_CS1(USBCTRL_OTGSC, BSEIE, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field BSVIE

#define BP_USBCTRL_OTGSC_BSVIE      27
#define BM_USBCTRL_OTGSC_BSVIE      0x08000000

#define BF_USBCTRL_OTGSC_BSVIE(v)   (((v) << 27) & BM_USBCTRL_OTGSC_BSVIE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_BSVIE(v)   BF_CS1(USBCTRL_OTGSC, BSVIE, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field ASVIE

#define BP_USBCTRL_OTGSC_ASVIE      26
#define BM_USBCTRL_OTGSC_ASVIE      0x04000000

#define BF_USBCTRL_OTGSC_ASVIE(v)   (((v) << 26) & BM_USBCTRL_OTGSC_ASVIE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_ASVIE(v)   BF_CS1(USBCTRL_OTGSC, ASVIE, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field AVVIE

#define BP_USBCTRL_OTGSC_AVVIE      25
#define BM_USBCTRL_OTGSC_AVVIE      0x02000000

#define BF_USBCTRL_OTGSC_AVVIE(v)   (((v) << 25) & BM_USBCTRL_OTGSC_AVVIE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_AVVIE(v)   BF_CS1(USBCTRL_OTGSC, AVVIE, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field IDIE

#define BP_USBCTRL_OTGSC_IDIE      24
#define BM_USBCTRL_OTGSC_IDIE      0x01000000

#define BF_USBCTRL_OTGSC_IDIE(v)   (((v) << 24) & BM_USBCTRL_OTGSC_IDIE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_IDIE(v)   BF_CS1(USBCTRL_OTGSC, IDIE, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field DPIS

#define BP_USBCTRL_OTGSC_DPIS      22
#define BM_USBCTRL_OTGSC_DPIS      0x00400000

#define BF_USBCTRL_OTGSC_DPIS(v)   (((v) << 22) & BM_USBCTRL_OTGSC_DPIS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_DPIS(v)   BF_CS1(USBCTRL_OTGSC, DPIS, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field ONEMSS

#define BP_USBCTRL_OTGSC_ONEMSS      21
#define BM_USBCTRL_OTGSC_ONEMSS      0x00200000

#define BF_USBCTRL_OTGSC_ONEMSS(v)   (((v) << 21) & BM_USBCTRL_OTGSC_ONEMSS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_ONEMSS(v)   BF_CS1(USBCTRL_OTGSC, ONEMSS, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field BSEIS

#define BP_USBCTRL_OTGSC_BSEIS      20
#define BM_USBCTRL_OTGSC_BSEIS      0x00100000

#define BF_USBCTRL_OTGSC_BSEIS(v)   (((v) << 20) & BM_USBCTRL_OTGSC_BSEIS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_BSEIS(v)   BF_CS1(USBCTRL_OTGSC, BSEIS, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field BSVIS

#define BP_USBCTRL_OTGSC_BSVIS      19
#define BM_USBCTRL_OTGSC_BSVIS      0x00080000

#define BF_USBCTRL_OTGSC_BSVIS(v)   (((v) << 19) & BM_USBCTRL_OTGSC_BSVIS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_BSVIS(v)   BF_CS1(USBCTRL_OTGSC, BSVIS, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field ASVIS

#define BP_USBCTRL_OTGSC_ASVIS      18
#define BM_USBCTRL_OTGSC_ASVIS      0x00040000

#define BF_USBCTRL_OTGSC_ASVIS(v)   (((v) << 18) & BM_USBCTRL_OTGSC_ASVIS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_ASVIS(v)   BF_CS1(USBCTRL_OTGSC, ASVIS, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field AVVIS

#define BP_USBCTRL_OTGSC_AVVIS      17
#define BM_USBCTRL_OTGSC_AVVIS      0x00020000

#define BF_USBCTRL_OTGSC_AVVIS(v)   (((v) << 17) & BM_USBCTRL_OTGSC_AVVIS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_AVVIS(v)   BF_CS1(USBCTRL_OTGSC, AVVIS, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field IDIS

#define BP_USBCTRL_OTGSC_IDIS      16
#define BM_USBCTRL_OTGSC_IDIS      0x00010000

#define BF_USBCTRL_OTGSC_IDIS(v)   (((v) << 16) & BM_USBCTRL_OTGSC_IDIS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_IDIS(v)   BF_CS1(USBCTRL_OTGSC, IDIS, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field DPS

#define BP_USBCTRL_OTGSC_DPS      14
#define BM_USBCTRL_OTGSC_DPS      0x00004000

#define BF_USBCTRL_OTGSC_DPS(v)   (((v) << 14) & BM_USBCTRL_OTGSC_DPS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_DPS(v)   BF_CS1(USBCTRL_OTGSC, DPS, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field ONEMST

#define BP_USBCTRL_OTGSC_ONEMST      13
#define BM_USBCTRL_OTGSC_ONEMST      0x00002000

#define BF_USBCTRL_OTGSC_ONEMST(v)   (((v) << 13) & BM_USBCTRL_OTGSC_ONEMST)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_ONEMST(v)   BF_CS1(USBCTRL_OTGSC, ONEMST, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field BSE

#define BP_USBCTRL_OTGSC_BSE      12
#define BM_USBCTRL_OTGSC_BSE      0x00001000

#define BF_USBCTRL_OTGSC_BSE(v)   (((v) << 12) & BM_USBCTRL_OTGSC_BSE)

//--- Register HW_USBCTRL_OTGSC, field BSV

#define BP_USBCTRL_OTGSC_BSV      11
#define BM_USBCTRL_OTGSC_BSV      0x00000800

#define BF_USBCTRL_OTGSC_BSV(v)   (((v) << 11) & BM_USBCTRL_OTGSC_BSV)

//--- Register HW_USBCTRL_OTGSC, field ASV

#define BP_USBCTRL_OTGSC_ASV      10
#define BM_USBCTRL_OTGSC_ASV      0x00000400

#define BF_USBCTRL_OTGSC_ASV(v)   (((v) << 10) & BM_USBCTRL_OTGSC_ASV)

//--- Register HW_USBCTRL_OTGSC, field AVV

#define BP_USBCTRL_OTGSC_AVV      9
#define BM_USBCTRL_OTGSC_AVV      0x00000200

#define BF_USBCTRL_OTGSC_AVV(v)   (((v) << 9) & BM_USBCTRL_OTGSC_AVV)

//--- Register HW_USBCTRL_OTGSC, field ID

#define BP_USBCTRL_OTGSC_ID      8
#define BM_USBCTRL_OTGSC_ID      0x00000100

#define BF_USBCTRL_OTGSC_ID(v)   (((v) << 8) & BM_USBCTRL_OTGSC_ID)

//--- Register HW_USBCTRL_OTGSC, field HABA

#define BP_USBCTRL_OTGSC_HABA      7
#define BM_USBCTRL_OTGSC_HABA      0x00000080

#define BF_USBCTRL_OTGSC_HABA(v)   (((v) << 7) & BM_USBCTRL_OTGSC_HABA)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_HABA(v)   BF_CS1(USBCTRL_OTGSC, HABA, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field HADP

#define BP_USBCTRL_OTGSC_HADP      6
#define BM_USBCTRL_OTGSC_HADP      0x00000040

#define BF_USBCTRL_OTGSC_HADP(v)   (((v) << 6) & BM_USBCTRL_OTGSC_HADP)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_HADP(v)   BF_CS1(USBCTRL_OTGSC, HADP, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field IDPU

#define BP_USBCTRL_OTGSC_IDPU      5
#define BM_USBCTRL_OTGSC_IDPU      0x00000020

#define BF_USBCTRL_OTGSC_IDPU(v)   (((v) << 5) & BM_USBCTRL_OTGSC_IDPU)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_IDPU(v)   BF_CS1(USBCTRL_OTGSC, IDPU, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field DP

#define BP_USBCTRL_OTGSC_DP      4
#define BM_USBCTRL_OTGSC_DP      0x00000010

#define BF_USBCTRL_OTGSC_DP(v)   (((v) << 4) & BM_USBCTRL_OTGSC_DP)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_DP(v)   BF_CS1(USBCTRL_OTGSC, DP, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field OT

#define BP_USBCTRL_OTGSC_OT      3
#define BM_USBCTRL_OTGSC_OT      0x00000008

#define BF_USBCTRL_OTGSC_OT(v)   (((v) << 3) & BM_USBCTRL_OTGSC_OT)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_OT(v)   BF_CS1(USBCTRL_OTGSC, OT, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field HAAR

#define BP_USBCTRL_OTGSC_HAAR      2
#define BM_USBCTRL_OTGSC_HAAR      0x00000004

#define BF_USBCTRL_OTGSC_HAAR(v)   (((v) << 2) & BM_USBCTRL_OTGSC_HAAR)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_HAAR(v)   BF_CS1(USBCTRL_OTGSC, HAAR, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field VC

#define BP_USBCTRL_OTGSC_VC      1
#define BM_USBCTRL_OTGSC_VC      0x00000002

#define BF_USBCTRL_OTGSC_VC(v)   (((v) << 1) & BM_USBCTRL_OTGSC_VC)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_VC(v)   BF_CS1(USBCTRL_OTGSC, VC, v)
#endif

//--- Register HW_USBCTRL_OTGSC, field VD

#define BP_USBCTRL_OTGSC_VD      0
#define BM_USBCTRL_OTGSC_VD      0x00000001

#define BF_USBCTRL_OTGSC_VD(v)   (((v) << 0) & BM_USBCTRL_OTGSC_VD)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_OTGSC_VD(v)   BF_CS1(USBCTRL_OTGSC, VD, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_USBMODE - USB Device Mode Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CM    :  2;
        unsigned ES    :  1;
        unsigned SLOM  :  1;
        unsigned SDIS  :  1;
        unsigned VBPS  :  1;
        unsigned RSVD  : 26;
    } B;
} hw_usbctrl_usbmode_t;
#endif


//
// constants & macros for entire HW_USBCTRL_USBMODE register
//

#define HW_USBCTRL_USBMODE_ADDR      (REGS_USBCTRL_BASE + 0x000001A8)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_USBMODE           (*(volatile hw_usbctrl_usbmode_t *) HW_USBCTRL_USBMODE_ADDR)
#define HW_USBCTRL_USBMODE_RD()      (HW_USBCTRL_USBMODE.U)
#define HW_USBCTRL_USBMODE_WR(v)     (HW_USBCTRL_USBMODE.U = (v))
#define HW_USBCTRL_USBMODE_SET(v)    (HW_USBCTRL_USBMODE_WR(HW_USBCTRL_USBMODE_RD() |  (v)))
#define HW_USBCTRL_USBMODE_CLR(v)    (HW_USBCTRL_USBMODE_WR(HW_USBCTRL_USBMODE_RD() & ~(v)))
#define HW_USBCTRL_USBMODE_TOG(v)    (HW_USBCTRL_USBMODE_WR(HW_USBCTRL_USBMODE_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_USBMODE bitfields
//

//--- Register HW_USBCTRL_USBMODE, field VBPS

#define BP_USBCTRL_USBMODE_VBPS      5
#define BM_USBCTRL_USBMODE_VBPS      0x00000020

#define BF_USBCTRL_USBMODE_VBPS(v)   (((v) << 5) & BM_USBCTRL_USBMODE_VBPS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBMODE_VBPS(v)   BF_CS1(USBCTRL_USBMODE, VBPS, v)
#endif

//--- Register HW_USBCTRL_USBMODE, field SDIS

#define BP_USBCTRL_USBMODE_SDIS      4
#define BM_USBCTRL_USBMODE_SDIS      0x00000010

#define BF_USBCTRL_USBMODE_SDIS(v)   (((v) << 4) & BM_USBCTRL_USBMODE_SDIS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBMODE_SDIS(v)   BF_CS1(USBCTRL_USBMODE, SDIS, v)
#endif

//--- Register HW_USBCTRL_USBMODE, field SLOM

#define BP_USBCTRL_USBMODE_SLOM      3
#define BM_USBCTRL_USBMODE_SLOM      0x00000008

#define BF_USBCTRL_USBMODE_SLOM(v)   (((v) << 3) & BM_USBCTRL_USBMODE_SLOM)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBMODE_SLOM(v)   BF_CS1(USBCTRL_USBMODE, SLOM, v)
#endif

//--- Register HW_USBCTRL_USBMODE, field ES

#define BP_USBCTRL_USBMODE_ES      2
#define BM_USBCTRL_USBMODE_ES      0x00000004

#define BF_USBCTRL_USBMODE_ES(v)   (((v) << 2) & BM_USBCTRL_USBMODE_ES)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBMODE_ES(v)   BF_CS1(USBCTRL_USBMODE, ES, v)
#endif

//--- Register HW_USBCTRL_USBMODE, field CM

#define BP_USBCTRL_USBMODE_CM      0
#define BM_USBCTRL_USBMODE_CM      0x00000003

#define BF_USBCTRL_USBMODE_CM(v)   (((v) << 0) & BM_USBCTRL_USBMODE_CM)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_USBMODE_CM(v)   BF_CS1(USBCTRL_USBMODE, CM, v)
#endif

#define BV_USBCTRL_USBMODE_CM__IDLE    0x0
#define BV_USBCTRL_USBMODE_CM__DEVICE  0x2
#define BV_USBCTRL_USBMODE_CM__HOST    0x3


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_ENDPTSETUPSTAT - Endpoint Setup Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENDPTSETUPSTAT  :  5;
        unsigned RSVD            : 27;
    } B;
} hw_usbctrl_endptsetupstat_t;
#endif


//
// constants & macros for entire HW_USBCTRL_ENDPTSETUPSTAT register
//

#define HW_USBCTRL_ENDPTSETUPSTAT_ADDR      (REGS_USBCTRL_BASE + 0x000001AC)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_ENDPTSETUPSTAT           (*(volatile hw_usbctrl_endptsetupstat_t *) HW_USBCTRL_ENDPTSETUPSTAT_ADDR)
#define HW_USBCTRL_ENDPTSETUPSTAT_RD()      (HW_USBCTRL_ENDPTSETUPSTAT.U)
#define HW_USBCTRL_ENDPTSETUPSTAT_WR(v)     (HW_USBCTRL_ENDPTSETUPSTAT.U = (v))
#define HW_USBCTRL_ENDPTSETUPSTAT_SET(v)    (HW_USBCTRL_ENDPTSETUPSTAT_WR(HW_USBCTRL_ENDPTSETUPSTAT_RD() |  (v)))
#define HW_USBCTRL_ENDPTSETUPSTAT_CLR(v)    (HW_USBCTRL_ENDPTSETUPSTAT_WR(HW_USBCTRL_ENDPTSETUPSTAT_RD() & ~(v)))
#define HW_USBCTRL_ENDPTSETUPSTAT_TOG(v)    (HW_USBCTRL_ENDPTSETUPSTAT_WR(HW_USBCTRL_ENDPTSETUPSTAT_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_ENDPTSETUPSTAT bitfields
//

//--- Register HW_USBCTRL_ENDPTSETUPSTAT, field ENDPTSETUPSTAT

#define BP_USBCTRL_ENDPTSETUPSTAT_ENDPTSETUPSTAT      0
#define BM_USBCTRL_ENDPTSETUPSTAT_ENDPTSETUPSTAT      0x0000001F

#define BF_USBCTRL_ENDPTSETUPSTAT_ENDPTSETUPSTAT(v)   (((v) << 0) & BM_USBCTRL_ENDPTSETUPSTAT_ENDPTSETUPSTAT)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTSETUPSTAT_ENDPTSETUPSTAT(v)   BF_CS1(USBCTRL_ENDPTSETUPSTAT, ENDPTSETUPSTAT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_ENDPTPRIME - Endpoint Initialization Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PERB   :  5;
        unsigned RSVD0  : 11;
        unsigned PETB   :  5;
        unsigned RSVD1  : 11;
    } B;
} hw_usbctrl_endptprime_t;
#endif


//
// constants & macros for entire HW_USBCTRL_ENDPTPRIME register
//

#define HW_USBCTRL_ENDPTPRIME_ADDR      (REGS_USBCTRL_BASE + 0x000001B0)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_ENDPTPRIME           (*(volatile hw_usbctrl_endptprime_t *) HW_USBCTRL_ENDPTPRIME_ADDR)
#define HW_USBCTRL_ENDPTPRIME_RD()      (HW_USBCTRL_ENDPTPRIME.U)
#define HW_USBCTRL_ENDPTPRIME_WR(v)     (HW_USBCTRL_ENDPTPRIME.U = (v))
#define HW_USBCTRL_ENDPTPRIME_SET(v)    (HW_USBCTRL_ENDPTPRIME_WR(HW_USBCTRL_ENDPTPRIME_RD() |  (v)))
#define HW_USBCTRL_ENDPTPRIME_CLR(v)    (HW_USBCTRL_ENDPTPRIME_WR(HW_USBCTRL_ENDPTPRIME_RD() & ~(v)))
#define HW_USBCTRL_ENDPTPRIME_TOG(v)    (HW_USBCTRL_ENDPTPRIME_WR(HW_USBCTRL_ENDPTPRIME_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_ENDPTPRIME bitfields
//

//--- Register HW_USBCTRL_ENDPTPRIME, field PETB

#define BP_USBCTRL_ENDPTPRIME_PETB      16
#define BM_USBCTRL_ENDPTPRIME_PETB      0x001F0000

#define BF_USBCTRL_ENDPTPRIME_PETB(v)   (((v) << 16) & BM_USBCTRL_ENDPTPRIME_PETB)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTPRIME_PETB(v)   BF_CS1(USBCTRL_ENDPTPRIME, PETB, v)
#endif

//--- Register HW_USBCTRL_ENDPTPRIME, field PERB

#define BP_USBCTRL_ENDPTPRIME_PERB      0
#define BM_USBCTRL_ENDPTPRIME_PERB      0x0000001F

#define BF_USBCTRL_ENDPTPRIME_PERB(v)   (((v) << 0) & BM_USBCTRL_ENDPTPRIME_PERB)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTPRIME_PERB(v)   BF_CS1(USBCTRL_ENDPTPRIME, PERB, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_ENDPTFLUSH - Endpoint De-Initialize Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FERB   :  5;
        unsigned RSVD0  : 11;
        unsigned FETB   :  5;
        unsigned RSVD1  : 11;
    } B;
} hw_usbctrl_endptflush_t;
#endif


//
// constants & macros for entire HW_USBCTRL_ENDPTFLUSH register
//

#define HW_USBCTRL_ENDPTFLUSH_ADDR      (REGS_USBCTRL_BASE + 0x000001B4)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_ENDPTFLUSH           (*(volatile hw_usbctrl_endptflush_t *) HW_USBCTRL_ENDPTFLUSH_ADDR)
#define HW_USBCTRL_ENDPTFLUSH_RD()      (HW_USBCTRL_ENDPTFLUSH.U)
#define HW_USBCTRL_ENDPTFLUSH_WR(v)     (HW_USBCTRL_ENDPTFLUSH.U = (v))
#define HW_USBCTRL_ENDPTFLUSH_SET(v)    (HW_USBCTRL_ENDPTFLUSH_WR(HW_USBCTRL_ENDPTFLUSH_RD() |  (v)))
#define HW_USBCTRL_ENDPTFLUSH_CLR(v)    (HW_USBCTRL_ENDPTFLUSH_WR(HW_USBCTRL_ENDPTFLUSH_RD() & ~(v)))
#define HW_USBCTRL_ENDPTFLUSH_TOG(v)    (HW_USBCTRL_ENDPTFLUSH_WR(HW_USBCTRL_ENDPTFLUSH_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_ENDPTFLUSH bitfields
//

//--- Register HW_USBCTRL_ENDPTFLUSH, field FETB

#define BP_USBCTRL_ENDPTFLUSH_FETB      16
#define BM_USBCTRL_ENDPTFLUSH_FETB      0x001F0000

#define BF_USBCTRL_ENDPTFLUSH_FETB(v)   (((v) << 16) & BM_USBCTRL_ENDPTFLUSH_FETB)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTFLUSH_FETB(v)   BF_CS1(USBCTRL_ENDPTFLUSH, FETB, v)
#endif

//--- Register HW_USBCTRL_ENDPTFLUSH, field FERB

#define BP_USBCTRL_ENDPTFLUSH_FERB      0
#define BM_USBCTRL_ENDPTFLUSH_FERB      0x0000001F

#define BF_USBCTRL_ENDPTFLUSH_FERB(v)   (((v) << 0) & BM_USBCTRL_ENDPTFLUSH_FERB)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTFLUSH_FERB(v)   BF_CS1(USBCTRL_ENDPTFLUSH, FERB, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_ENDPTSTAT - Endpoint Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ERBR   :  5;
        unsigned RSVD0  : 11;
        unsigned ETBR   :  5;
        unsigned RSVD1  : 11;
    } B;
} hw_usbctrl_endptstat_t;
#endif


//
// constants & macros for entire HW_USBCTRL_ENDPTSTAT register
//

#define HW_USBCTRL_ENDPTSTAT_ADDR      (REGS_USBCTRL_BASE + 0x000001B8)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_ENDPTSTAT           (*(volatile hw_usbctrl_endptstat_t *) HW_USBCTRL_ENDPTSTAT_ADDR)
#define HW_USBCTRL_ENDPTSTAT_RD()      (HW_USBCTRL_ENDPTSTAT.U)
#endif


//
// constants & macros for individual HW_USBCTRL_ENDPTSTAT bitfields
//

//--- Register HW_USBCTRL_ENDPTSTAT, field ETBR

#define BP_USBCTRL_ENDPTSTAT_ETBR      16
#define BM_USBCTRL_ENDPTSTAT_ETBR      0x001F0000

#define BF_USBCTRL_ENDPTSTAT_ETBR(v)   (((v) << 16) & BM_USBCTRL_ENDPTSTAT_ETBR)

//--- Register HW_USBCTRL_ENDPTSTAT, field ERBR

#define BP_USBCTRL_ENDPTSTAT_ERBR      0
#define BM_USBCTRL_ENDPTSTAT_ERBR      0x0000001F

#define BF_USBCTRL_ENDPTSTAT_ERBR(v)   (((v) << 0) & BM_USBCTRL_ENDPTSTAT_ERBR)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_ENDPTCOMPLETE - Endpoint Complete Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ERCE   :  5;
        unsigned RSVD0  : 11;
        unsigned ETCE   :  5;
        unsigned RSVD1  : 11;
    } B;
} hw_usbctrl_endptcomplete_t;
#endif


//
// constants & macros for entire HW_USBCTRL_ENDPTCOMPLETE register
//

#define HW_USBCTRL_ENDPTCOMPLETE_ADDR      (REGS_USBCTRL_BASE + 0x000001BC)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_ENDPTCOMPLETE           (*(volatile hw_usbctrl_endptcomplete_t *) HW_USBCTRL_ENDPTCOMPLETE_ADDR)
#define HW_USBCTRL_ENDPTCOMPLETE_RD()      (HW_USBCTRL_ENDPTCOMPLETE.U)
#define HW_USBCTRL_ENDPTCOMPLETE_WR(v)     (HW_USBCTRL_ENDPTCOMPLETE.U = (v))
#define HW_USBCTRL_ENDPTCOMPLETE_SET(v)    (HW_USBCTRL_ENDPTCOMPLETE_WR(HW_USBCTRL_ENDPTCOMPLETE_RD() |  (v)))
#define HW_USBCTRL_ENDPTCOMPLETE_CLR(v)    (HW_USBCTRL_ENDPTCOMPLETE_WR(HW_USBCTRL_ENDPTCOMPLETE_RD() & ~(v)))
#define HW_USBCTRL_ENDPTCOMPLETE_TOG(v)    (HW_USBCTRL_ENDPTCOMPLETE_WR(HW_USBCTRL_ENDPTCOMPLETE_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_ENDPTCOMPLETE bitfields
//

//--- Register HW_USBCTRL_ENDPTCOMPLETE, field ETCE

#define BP_USBCTRL_ENDPTCOMPLETE_ETCE      16
#define BM_USBCTRL_ENDPTCOMPLETE_ETCE      0x001F0000

#define BF_USBCTRL_ENDPTCOMPLETE_ETCE(v)   (((v) << 16) & BM_USBCTRL_ENDPTCOMPLETE_ETCE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCOMPLETE_ETCE(v)   BF_CS1(USBCTRL_ENDPTCOMPLETE, ETCE, v)
#endif

//--- Register HW_USBCTRL_ENDPTCOMPLETE, field ERCE

#define BP_USBCTRL_ENDPTCOMPLETE_ERCE      0
#define BM_USBCTRL_ENDPTCOMPLETE_ERCE      0x0000001F

#define BF_USBCTRL_ENDPTCOMPLETE_ERCE(v)   (((v) << 0) & BM_USBCTRL_ENDPTCOMPLETE_ERCE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCOMPLETE_ERCE(v)   BF_CS1(USBCTRL_ENDPTCOMPLETE, ERCE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBCTRL_ENDPTCTRL0 - Endpoint Control 0 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RXS    :  1;
        unsigned RSVD1  :  1;
        unsigned RXT    :  2;
        unsigned RSVD2  :  3;
        unsigned RXE    :  1;
        reg8_t   RSVD3;
        unsigned TXS    :  1;
        unsigned RSVD4  :  1;
        unsigned TXT    :  2;
        unsigned RSVD5  :  3;
        unsigned TXE    :  1;
        reg8_t   RSVD6;
    } B;
} hw_usbctrl_endptctrl0_t;
#endif


//
// constants & macros for entire HW_USBCTRL_ENDPTCTRL0 register
//

#define HW_USBCTRL_ENDPTCTRL0_ADDR      (REGS_USBCTRL_BASE + 0x000001C0)

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_ENDPTCTRL0           (*(volatile hw_usbctrl_endptctrl0_t *) HW_USBCTRL_ENDPTCTRL0_ADDR)
#define HW_USBCTRL_ENDPTCTRL0_RD()      (HW_USBCTRL_ENDPTCTRL0.U)
#define HW_USBCTRL_ENDPTCTRL0_WR(v)     (HW_USBCTRL_ENDPTCTRL0.U = (v))
#define HW_USBCTRL_ENDPTCTRL0_SET(v)    (HW_USBCTRL_ENDPTCTRL0_WR(HW_USBCTRL_ENDPTCTRL0_RD() |  (v)))
#define HW_USBCTRL_ENDPTCTRL0_CLR(v)    (HW_USBCTRL_ENDPTCTRL0_WR(HW_USBCTRL_ENDPTCTRL0_RD() & ~(v)))
#define HW_USBCTRL_ENDPTCTRL0_TOG(v)    (HW_USBCTRL_ENDPTCTRL0_WR(HW_USBCTRL_ENDPTCTRL0_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_ENDPTCTRL0 bitfields
//

//--- Register HW_USBCTRL_ENDPTCTRL0, field TXE

#define BP_USBCTRL_ENDPTCTRL0_TXE      23
#define BM_USBCTRL_ENDPTCTRL0_TXE      0x00800000

#define BF_USBCTRL_ENDPTCTRL0_TXE(v)   (((v) << 23) & BM_USBCTRL_ENDPTCTRL0_TXE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRL0_TXE(v)   BF_CS1(USBCTRL_ENDPTCTRL0, TXE, v)
#endif

//--- Register HW_USBCTRL_ENDPTCTRL0, field TXT

#define BP_USBCTRL_ENDPTCTRL0_TXT      18
#define BM_USBCTRL_ENDPTCTRL0_TXT      0x000C0000

#define BF_USBCTRL_ENDPTCTRL0_TXT(v)   (((v) << 18) & BM_USBCTRL_ENDPTCTRL0_TXT)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRL0_TXT(v)   BF_CS1(USBCTRL_ENDPTCTRL0, TXT, v)
#endif

#define BV_USBCTRL_ENDPTCTRL0_TXT__CONTROL  0

//--- Register HW_USBCTRL_ENDPTCTRL0, field TXS

#define BP_USBCTRL_ENDPTCTRL0_TXS      16
#define BM_USBCTRL_ENDPTCTRL0_TXS      0x00010000

#define BF_USBCTRL_ENDPTCTRL0_TXS(v)   (((v) << 16) & BM_USBCTRL_ENDPTCTRL0_TXS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRL0_TXS(v)   BF_CS1(USBCTRL_ENDPTCTRL0, TXS, v)
#endif

//--- Register HW_USBCTRL_ENDPTCTRL0, field RXE

#define BP_USBCTRL_ENDPTCTRL0_RXE      7
#define BM_USBCTRL_ENDPTCTRL0_RXE      0x00000080

#define BF_USBCTRL_ENDPTCTRL0_RXE(v)   (((v) << 7) & BM_USBCTRL_ENDPTCTRL0_RXE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRL0_RXE(v)   BF_CS1(USBCTRL_ENDPTCTRL0, RXE, v)
#endif

//--- Register HW_USBCTRL_ENDPTCTRL0, field RXT

#define BP_USBCTRL_ENDPTCTRL0_RXT      2
#define BM_USBCTRL_ENDPTCTRL0_RXT      0x0000000C

#define BF_USBCTRL_ENDPTCTRL0_RXT(v)   (((v) << 2) & BM_USBCTRL_ENDPTCTRL0_RXT)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRL0_RXT(v)   BF_CS1(USBCTRL_ENDPTCTRL0, RXT, v)
#endif

#define BV_USBCTRL_ENDPTCTRL0_RXT__CONTROL  0

//--- Register HW_USBCTRL_ENDPTCTRL0, field RXS

#define BP_USBCTRL_ENDPTCTRL0_RXS      0
#define BM_USBCTRL_ENDPTCTRL0_RXS      0x00000001

#define BF_USBCTRL_ENDPTCTRL0_RXS(v)   (((v) << 0) & BM_USBCTRL_ENDPTCTRL0_RXS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRL0_RXS(v)   BF_CS1(USBCTRL_ENDPTCTRL0, RXS, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_USBCTRL_ENDPTCTRLn : base 0x800801C0 : count 5 : offset 0x4
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RXS    :  1;
        unsigned RXD    :  1;
        unsigned RXT    :  2;
        unsigned RSVD2  :  1;
        unsigned RXI    :  1;
        unsigned RXR    :  1;
        unsigned RXE    :  1;
        reg8_t   RSVD3;
        unsigned TXS    :  1;
        unsigned TXD    :  1;
        unsigned TXT    :  2;
        unsigned RSVD5  :  1;
        unsigned TXI    :  1;
        unsigned TXR    :  1;
        unsigned TXE    :  1;
        reg8_t   RSVD6;
    } B;
} hw_usbctrl_endptctrln_t;
#endif


//
// constants & macros for entire HW_USBCTRL_ENDPTCTRLn multi-register
//

#define HW_USBCTRL_ENDPTCTRLn_COUNT        5
#define HW_USBCTRL_ENDPTCTRLn_ADDR(n)      (REGS_USBCTRL_BASE + 0x000001C0 + ((n) * 0x4))

#ifndef __LANGUAGE_ASM__
#define HW_USBCTRL_ENDPTCTRLn(n)           (*(volatile hw_usbctrl_endptctrln_t *) HW_USBCTRL_ENDPTCTRLn_ADDR(n))
#define HW_USBCTRL_ENDPTCTRLn_RD(n)        (HW_USBCTRL_ENDPTCTRLn(n).U)
#define HW_USBCTRL_ENDPTCTRLn_WR(n, v)     (HW_USBCTRL_ENDPTCTRLn(n).U = (v))
#define HW_USBCTRL_ENDPTCTRLn_SET(n, v)    (HW_USBCTRL_ENDPTCTRLn_WR(n, HW_USBCTRL_ENDPTCTRLn_RD(n) |  (v)))
#define HW_USBCTRL_ENDPTCTRLn_CLR(n, v)    (HW_USBCTRL_ENDPTCTRLn_WR(n, HW_USBCTRL_ENDPTCTRLn_RD(n) & ~(v)))
#define HW_USBCTRL_ENDPTCTRLn_TOG(n, v)    (HW_USBCTRL_ENDPTCTRLn_WR(n, HW_USBCTRL_ENDPTCTRLn_RD(n) ^  (v)))
#endif


//
// constants & macros for individual HW_USBCTRL_ENDPTCTRLn multi-register bitfields
//

//--- Register HW_USBCTRL_ENDPTCTRLn, field TXE

#define BP_USBCTRL_ENDPTCTRLn_TXE      23
#define BM_USBCTRL_ENDPTCTRLn_TXE      0x00800000

#define BF_USBCTRL_ENDPTCTRLn_TXE(v)   (((v) << 23) & BM_USBCTRL_ENDPTCTRLn_TXE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRLn_TXE(n, v)  BF_CS1n(USBCTRL_ENDPTCTRLn, n, TXE, v)
#endif

//--- Register HW_USBCTRL_ENDPTCTRLn, field TXR

#define BP_USBCTRL_ENDPTCTRLn_TXR      22
#define BM_USBCTRL_ENDPTCTRLn_TXR      0x00400000

#define BF_USBCTRL_ENDPTCTRLn_TXR(v)   (((v) << 22) & BM_USBCTRL_ENDPTCTRLn_TXR)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRLn_TXR(n, v)  BF_CS1n(USBCTRL_ENDPTCTRLn, n, TXR, v)
#endif

//--- Register HW_USBCTRL_ENDPTCTRLn, field TXI

#define BP_USBCTRL_ENDPTCTRLn_TXI      21
#define BM_USBCTRL_ENDPTCTRLn_TXI      0x00200000

#define BF_USBCTRL_ENDPTCTRLn_TXI(v)   (((v) << 21) & BM_USBCTRL_ENDPTCTRLn_TXI)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRLn_TXI(n, v)  BF_CS1n(USBCTRL_ENDPTCTRLn, n, TXI, v)
#endif

//--- Register HW_USBCTRL_ENDPTCTRLn, field TXT

#define BP_USBCTRL_ENDPTCTRLn_TXT      18
#define BM_USBCTRL_ENDPTCTRLn_TXT      0x000C0000

#define BF_USBCTRL_ENDPTCTRLn_TXT(v)   (((v) << 18) & BM_USBCTRL_ENDPTCTRLn_TXT)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRLn_TXT(n, v)  BF_CS1n(USBCTRL_ENDPTCTRLn, n, TXT, v)
#endif

#define BV_USBCTRL_ENDPTCTRLn_TXT__CONTROL  0
#define BV_USBCTRL_ENDPTCTRLn_TXT__ISO      1
#define BV_USBCTRL_ENDPTCTRLn_TXT__BULK     2
#define BV_USBCTRL_ENDPTCTRLn_TXT__INT      3

//--- Register HW_USBCTRL_ENDPTCTRLn, field TXD

#define BP_USBCTRL_ENDPTCTRLn_TXD      17
#define BM_USBCTRL_ENDPTCTRLn_TXD      0x00020000

#define BF_USBCTRL_ENDPTCTRLn_TXD(v)   (((v) << 17) & BM_USBCTRL_ENDPTCTRLn_TXD)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRLn_TXD(n, v)  BF_CS1n(USBCTRL_ENDPTCTRLn, n, TXD, v)
#endif

//--- Register HW_USBCTRL_ENDPTCTRLn, field TXS

#define BP_USBCTRL_ENDPTCTRLn_TXS      16
#define BM_USBCTRL_ENDPTCTRLn_TXS      0x00010000

#define BF_USBCTRL_ENDPTCTRLn_TXS(v)   (((v) << 16) & BM_USBCTRL_ENDPTCTRLn_TXS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRLn_TXS(n, v)  BF_CS1n(USBCTRL_ENDPTCTRLn, n, TXS, v)
#endif

//--- Register HW_USBCTRL_ENDPTCTRLn, field RXE

#define BP_USBCTRL_ENDPTCTRLn_RXE      7
#define BM_USBCTRL_ENDPTCTRLn_RXE      0x00000080

#define BF_USBCTRL_ENDPTCTRLn_RXE(v)   (((v) << 7) & BM_USBCTRL_ENDPTCTRLn_RXE)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRLn_RXE(n, v)  BF_CS1n(USBCTRL_ENDPTCTRLn, n, RXE, v)
#endif

//--- Register HW_USBCTRL_ENDPTCTRLn, field RXR

#define BP_USBCTRL_ENDPTCTRLn_RXR      6
#define BM_USBCTRL_ENDPTCTRLn_RXR      0x00000040

#define BF_USBCTRL_ENDPTCTRLn_RXR(v)   (((v) << 6) & BM_USBCTRL_ENDPTCTRLn_RXR)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRLn_RXR(n, v)  BF_CS1n(USBCTRL_ENDPTCTRLn, n, RXR, v)
#endif

//--- Register HW_USBCTRL_ENDPTCTRLn, field RXI

#define BP_USBCTRL_ENDPTCTRLn_RXI      5
#define BM_USBCTRL_ENDPTCTRLn_RXI      0x00000020

#define BF_USBCTRL_ENDPTCTRLn_RXI(v)   (((v) << 5) & BM_USBCTRL_ENDPTCTRLn_RXI)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRLn_RXI(n, v)  BF_CS1n(USBCTRL_ENDPTCTRLn, n, RXI, v)
#endif

//--- Register HW_USBCTRL_ENDPTCTRLn, field RXT

#define BP_USBCTRL_ENDPTCTRLn_RXT      2
#define BM_USBCTRL_ENDPTCTRLn_RXT      0x0000000C

#define BF_USBCTRL_ENDPTCTRLn_RXT(v)   (((v) << 2) & BM_USBCTRL_ENDPTCTRLn_RXT)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRLn_RXT(n, v)  BF_CS1n(USBCTRL_ENDPTCTRLn, n, RXT, v)
#endif

#define BV_USBCTRL_ENDPTCTRLn_RXT__CONTROL  0
#define BV_USBCTRL_ENDPTCTRLn_RXT__ISO      1
#define BV_USBCTRL_ENDPTCTRLn_RXT__BULK     2
#define BV_USBCTRL_ENDPTCTRLn_RXT__INT      3

//--- Register HW_USBCTRL_ENDPTCTRLn, field RXD

#define BP_USBCTRL_ENDPTCTRLn_RXD      1
#define BM_USBCTRL_ENDPTCTRLn_RXD      0x00000002

#define BF_USBCTRL_ENDPTCTRLn_RXD(v)   (((v) << 1) & BM_USBCTRL_ENDPTCTRLn_RXD)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRLn_RXD(n, v)  BF_CS1n(USBCTRL_ENDPTCTRLn, n, RXD, v)
#endif

//--- Register HW_USBCTRL_ENDPTCTRLn, field RXS

#define BP_USBCTRL_ENDPTCTRLn_RXS      0
#define BM_USBCTRL_ENDPTCTRLn_RXS      0x00000001

#define BF_USBCTRL_ENDPTCTRLn_RXS(v)   (((v) << 0) & BM_USBCTRL_ENDPTCTRLn_RXS)

#ifndef __LANGUAGE_ASM__
#define BW_USBCTRL_ENDPTCTRLn_RXS(n, v)  BF_CS1n(USBCTRL_ENDPTCTRLn, n, RXS, v)
#endif


#endif // _REGSUSBCTRL_H

////////////////////////////////////////////////////////////////////////////////
