/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 1.19
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _PINCTRL_H
#define _PINCTRL_H  1

#include "regs.h"

#ifndef REGS_PINCTRL_BASE
#define REGS_PINCTRL_BASE (REGS_BASE + 0x18000)
#endif

/*
 * HW_PINCTRL_CTRL - PINCTRL Block Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQOUT0   :  1;
        unsigned IRQOUT1   :  1;
        unsigned IRQOUT2   :  1;
        unsigned IRQOUT3   :  1;
        unsigned IRQOUT4   :  1;
        unsigned RSRVD1    : 15;
        unsigned PRESENT0  :  1;
        unsigned PRESENT1  :  1;
        unsigned PRESENT2  :  1;
        unsigned PRESENT3  :  1;
        unsigned PRESENT4  :  1;
        unsigned RSRVD2    :  5;
        unsigned CLKGATE   :  1;
        unsigned SFTRST    :  1;
    } B;
} hw_pinctrl_ctrl_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_CTRL register
 */
#define HW_PINCTRL_CTRL_ADDR         (REGS_PINCTRL_BASE + 0x0)
#define HW_PINCTRL_CTRL_SET_ADDR     (HW_PINCTRL_CTRL_ADDR + 4)
#define HW_PINCTRL_CTRL_CLR_ADDR     (HW_PINCTRL_CTRL_ADDR + 8)
#define HW_PINCTRL_CTRL_TOG_ADDR     (HW_PINCTRL_CTRL_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_CTRL           (*(volatile hw_pinctrl_ctrl_t *) HW_PINCTRL_CTRL_ADDR)
#define HW_PINCTRL_CTRL_RD()      (HW_PINCTRL_CTRL.U)
#define HW_PINCTRL_CTRL_WR(v)     (HW_PINCTRL_CTRL.U = (v))
#define HW_PINCTRL_CTRL_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_CTRL_SET_ADDR) = (v))
#define HW_PINCTRL_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_CTRL_CLR_ADDR) = (v))
#define HW_PINCTRL_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_CTRL_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_CTRL bitfields
 */
/* --- Register HW_PINCTRL_CTRL, field SFTRST */

#define BP_PINCTRL_CTRL_SFTRST      31
#define BM_PINCTRL_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_CTRL_SFTRST)
#else
#define BF_PINCTRL_CTRL_SFTRST(v)   (((v) << 31) & BM_PINCTRL_CTRL_SFTRST)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_CTRL_SFTRST(v)   BF_CS1(PINCTRL_CTRL, SFTRST, v)
#endif

/* --- Register HW_PINCTRL_CTRL, field CLKGATE */

#define BP_PINCTRL_CTRL_CLKGATE      30
#define BM_PINCTRL_CTRL_CLKGATE      0x40000000

#define BF_PINCTRL_CTRL_CLKGATE(v)   (((v) << 30) & BM_PINCTRL_CTRL_CLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_CTRL_CLKGATE(v)   BF_CS1(PINCTRL_CTRL, CLKGATE, v)
#endif

/* --- Register HW_PINCTRL_CTRL, field RSRVD2 */

#define BP_PINCTRL_CTRL_RSRVD2      25
#define BM_PINCTRL_CTRL_RSRVD2      0x3E000000

#define BF_PINCTRL_CTRL_RSRVD2(v)   (((v) << 25) & BM_PINCTRL_CTRL_RSRVD2)
/* --- Register HW_PINCTRL_CTRL, field PRESENT4 */

#define BP_PINCTRL_CTRL_PRESENT4      24
#define BM_PINCTRL_CTRL_PRESENT4      0x01000000

#define BF_PINCTRL_CTRL_PRESENT4(v)   (((v) << 24) & BM_PINCTRL_CTRL_PRESENT4)
/* --- Register HW_PINCTRL_CTRL, field PRESENT3 */

#define BP_PINCTRL_CTRL_PRESENT3      23
#define BM_PINCTRL_CTRL_PRESENT3      0x00800000

#define BF_PINCTRL_CTRL_PRESENT3(v)   (((v) << 23) & BM_PINCTRL_CTRL_PRESENT3)
/* --- Register HW_PINCTRL_CTRL, field PRESENT2 */

#define BP_PINCTRL_CTRL_PRESENT2      22
#define BM_PINCTRL_CTRL_PRESENT2      0x00400000

#define BF_PINCTRL_CTRL_PRESENT2(v)   (((v) << 22) & BM_PINCTRL_CTRL_PRESENT2)
/* --- Register HW_PINCTRL_CTRL, field PRESENT1 */

#define BP_PINCTRL_CTRL_PRESENT1      21
#define BM_PINCTRL_CTRL_PRESENT1      0x00200000

#define BF_PINCTRL_CTRL_PRESENT1(v)   (((v) << 21) & BM_PINCTRL_CTRL_PRESENT1)
/* --- Register HW_PINCTRL_CTRL, field PRESENT0 */

#define BP_PINCTRL_CTRL_PRESENT0      20
#define BM_PINCTRL_CTRL_PRESENT0      0x00100000

#define BF_PINCTRL_CTRL_PRESENT0(v)   (((v) << 20) & BM_PINCTRL_CTRL_PRESENT0)
/* --- Register HW_PINCTRL_CTRL, field RSRVD1 */

#define BP_PINCTRL_CTRL_RSRVD1      5
#define BM_PINCTRL_CTRL_RSRVD1      0x000FFFE0

#define BF_PINCTRL_CTRL_RSRVD1(v)   (((v) << 5) & BM_PINCTRL_CTRL_RSRVD1)
/* --- Register HW_PINCTRL_CTRL, field IRQOUT4 */

#define BP_PINCTRL_CTRL_IRQOUT4      4
#define BM_PINCTRL_CTRL_IRQOUT4      0x00000010

#define BF_PINCTRL_CTRL_IRQOUT4(v)   (((v) << 4) & BM_PINCTRL_CTRL_IRQOUT4)
/* --- Register HW_PINCTRL_CTRL, field IRQOUT3 */

#define BP_PINCTRL_CTRL_IRQOUT3      3
#define BM_PINCTRL_CTRL_IRQOUT3      0x00000008

#define BF_PINCTRL_CTRL_IRQOUT3(v)   (((v) << 3) & BM_PINCTRL_CTRL_IRQOUT3)
/* --- Register HW_PINCTRL_CTRL, field IRQOUT2 */

#define BP_PINCTRL_CTRL_IRQOUT2      2
#define BM_PINCTRL_CTRL_IRQOUT2      0x00000004

#define BF_PINCTRL_CTRL_IRQOUT2(v)   (((v) << 2) & BM_PINCTRL_CTRL_IRQOUT2)
/* --- Register HW_PINCTRL_CTRL, field IRQOUT1 */

#define BP_PINCTRL_CTRL_IRQOUT1      1
#define BM_PINCTRL_CTRL_IRQOUT1      0x00000002

#define BF_PINCTRL_CTRL_IRQOUT1(v)   (((v) << 1) & BM_PINCTRL_CTRL_IRQOUT1)
/* --- Register HW_PINCTRL_CTRL, field IRQOUT0 */

#define BP_PINCTRL_CTRL_IRQOUT0      0
#define BM_PINCTRL_CTRL_IRQOUT0      0x00000001

#define BF_PINCTRL_CTRL_IRQOUT0(v)   (((v) << 0) & BM_PINCTRL_CTRL_IRQOUT0)


/*
 * HW_PINCTRL_MUXSEL0 - PINCTRL Pin Mux Select Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK0_PIN00  :  2;
        unsigned BANK0_PIN01  :  2;
        unsigned BANK0_PIN02  :  2;
        unsigned BANK0_PIN03  :  2;
        unsigned BANK0_PIN04  :  2;
        unsigned BANK0_PIN05  :  2;
        unsigned BANK0_PIN06  :  2;
        unsigned BANK0_PIN07  :  2;
        unsigned RSRVD0       : 16;
    } B;
} hw_pinctrl_muxsel0_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_MUXSEL0 register
 */
#define HW_PINCTRL_MUXSEL0_ADDR         (REGS_PINCTRL_BASE + 0x100)
#define HW_PINCTRL_MUXSEL0_SET_ADDR     (HW_PINCTRL_MUXSEL0_ADDR + 4)
#define HW_PINCTRL_MUXSEL0_CLR_ADDR     (HW_PINCTRL_MUXSEL0_ADDR + 8)
#define HW_PINCTRL_MUXSEL0_TOG_ADDR     (HW_PINCTRL_MUXSEL0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_MUXSEL0           (*(volatile hw_pinctrl_muxsel0_t *) HW_PINCTRL_MUXSEL0_ADDR)
#define HW_PINCTRL_MUXSEL0_RD()      (HW_PINCTRL_MUXSEL0.U)
#define HW_PINCTRL_MUXSEL0_WR(v)     (HW_PINCTRL_MUXSEL0.U = (v))
#define HW_PINCTRL_MUXSEL0_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL0_SET_ADDR) = (v))
#define HW_PINCTRL_MUXSEL0_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL0_CLR_ADDR) = (v))
#define HW_PINCTRL_MUXSEL0_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_MUXSEL0 bitfields
 */
/* --- Register HW_PINCTRL_MUXSEL0, field RSRVD0 */

#define BP_PINCTRL_MUXSEL0_RSRVD0      16
#define BM_PINCTRL_MUXSEL0_RSRVD0      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_MUXSEL0_RSRVD0(v)   ((((reg32_t) v) << 16) & BM_PINCTRL_MUXSEL0_RSRVD0)
#else
#define BF_PINCTRL_MUXSEL0_RSRVD0(v)   (((v) << 16) & BM_PINCTRL_MUXSEL0_RSRVD0)
#endif
/* --- Register HW_PINCTRL_MUXSEL0, field BANK0_PIN07 */

#define BP_PINCTRL_MUXSEL0_BANK0_PIN07      14
#define BM_PINCTRL_MUXSEL0_BANK0_PIN07      0x0000C000

#define BF_PINCTRL_MUXSEL0_BANK0_PIN07(v)   (((v) << 14) & BM_PINCTRL_MUXSEL0_BANK0_PIN07)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL0_BANK0_PIN07(v)   BF_CS1(PINCTRL_MUXSEL0, BANK0_PIN07, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL0, field BANK0_PIN06 */

#define BP_PINCTRL_MUXSEL0_BANK0_PIN06      12
#define BM_PINCTRL_MUXSEL0_BANK0_PIN06      0x00003000

#define BF_PINCTRL_MUXSEL0_BANK0_PIN06(v)   (((v) << 12) & BM_PINCTRL_MUXSEL0_BANK0_PIN06)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL0_BANK0_PIN06(v)   BF_CS1(PINCTRL_MUXSEL0, BANK0_PIN06, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL0, field BANK0_PIN05 */

#define BP_PINCTRL_MUXSEL0_BANK0_PIN05      10
#define BM_PINCTRL_MUXSEL0_BANK0_PIN05      0x00000C00

#define BF_PINCTRL_MUXSEL0_BANK0_PIN05(v)   (((v) << 10) & BM_PINCTRL_MUXSEL0_BANK0_PIN05)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL0_BANK0_PIN05(v)   BF_CS1(PINCTRL_MUXSEL0, BANK0_PIN05, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL0, field BANK0_PIN04 */

#define BP_PINCTRL_MUXSEL0_BANK0_PIN04      8
#define BM_PINCTRL_MUXSEL0_BANK0_PIN04      0x00000300

#define BF_PINCTRL_MUXSEL0_BANK0_PIN04(v)   (((v) << 8) & BM_PINCTRL_MUXSEL0_BANK0_PIN04)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL0_BANK0_PIN04(v)   BF_CS1(PINCTRL_MUXSEL0, BANK0_PIN04, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL0, field BANK0_PIN03 */

#define BP_PINCTRL_MUXSEL0_BANK0_PIN03      6
#define BM_PINCTRL_MUXSEL0_BANK0_PIN03      0x000000C0

#define BF_PINCTRL_MUXSEL0_BANK0_PIN03(v)   (((v) << 6) & BM_PINCTRL_MUXSEL0_BANK0_PIN03)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL0_BANK0_PIN03(v)   BF_CS1(PINCTRL_MUXSEL0, BANK0_PIN03, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL0, field BANK0_PIN02 */

#define BP_PINCTRL_MUXSEL0_BANK0_PIN02      4
#define BM_PINCTRL_MUXSEL0_BANK0_PIN02      0x00000030

#define BF_PINCTRL_MUXSEL0_BANK0_PIN02(v)   (((v) << 4) & BM_PINCTRL_MUXSEL0_BANK0_PIN02)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL0_BANK0_PIN02(v)   BF_CS1(PINCTRL_MUXSEL0, BANK0_PIN02, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL0, field BANK0_PIN01 */

#define BP_PINCTRL_MUXSEL0_BANK0_PIN01      2
#define BM_PINCTRL_MUXSEL0_BANK0_PIN01      0x0000000C

#define BF_PINCTRL_MUXSEL0_BANK0_PIN01(v)   (((v) << 2) & BM_PINCTRL_MUXSEL0_BANK0_PIN01)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL0_BANK0_PIN01(v)   BF_CS1(PINCTRL_MUXSEL0, BANK0_PIN01, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL0, field BANK0_PIN00 */

#define BP_PINCTRL_MUXSEL0_BANK0_PIN00      0
#define BM_PINCTRL_MUXSEL0_BANK0_PIN00      0x00000003

#define BF_PINCTRL_MUXSEL0_BANK0_PIN00(v)   (((v) << 0) & BM_PINCTRL_MUXSEL0_BANK0_PIN00)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL0_BANK0_PIN00(v)   BF_CS1(PINCTRL_MUXSEL0, BANK0_PIN00, v)
#endif



/*
 * HW_PINCTRL_MUXSEL1 - PINCTRL Pin Mux Select Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK0_PIN16  :  2;
        unsigned BANK0_PIN17  :  2;
        unsigned BANK0_PIN18  :  2;
        unsigned BANK0_PIN19  :  2;
        unsigned BANK0_PIN20  :  2;
        unsigned BANK0_PIN21  :  2;
        unsigned BANK0_PIN22  :  2;
        unsigned BANK0_PIN23  :  2;
        unsigned BANK0_PIN24  :  2;
        unsigned BANK0_PIN25  :  2;
        unsigned BANK0_PIN26  :  2;
        unsigned BANK0_PIN27  :  2;
        unsigned BANK0_PIN28  :  2;
        unsigned RSRVD0       :  6;
    } B;
} hw_pinctrl_muxsel1_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_MUXSEL1 register
 */
#define HW_PINCTRL_MUXSEL1_ADDR         (REGS_PINCTRL_BASE + 0x110)
#define HW_PINCTRL_MUXSEL1_SET_ADDR     (HW_PINCTRL_MUXSEL1_ADDR + 4)
#define HW_PINCTRL_MUXSEL1_CLR_ADDR     (HW_PINCTRL_MUXSEL1_ADDR + 8)
#define HW_PINCTRL_MUXSEL1_TOG_ADDR     (HW_PINCTRL_MUXSEL1_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_MUXSEL1           (*(volatile hw_pinctrl_muxsel1_t *) HW_PINCTRL_MUXSEL1_ADDR)
#define HW_PINCTRL_MUXSEL1_RD()      (HW_PINCTRL_MUXSEL1.U)
#define HW_PINCTRL_MUXSEL1_WR(v)     (HW_PINCTRL_MUXSEL1.U = (v))
#define HW_PINCTRL_MUXSEL1_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL1_SET_ADDR) = (v))
#define HW_PINCTRL_MUXSEL1_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL1_CLR_ADDR) = (v))
#define HW_PINCTRL_MUXSEL1_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL1_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_MUXSEL1 bitfields
 */
/* --- Register HW_PINCTRL_MUXSEL1, field RSRVD0 */

#define BP_PINCTRL_MUXSEL1_RSRVD0      26
#define BM_PINCTRL_MUXSEL1_RSRVD0      0xFC000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_MUXSEL1_RSRVD0(v)   ((((reg32_t) v) << 26) & BM_PINCTRL_MUXSEL1_RSRVD0)
#else
#define BF_PINCTRL_MUXSEL1_RSRVD0(v)   (((v) << 26) & BM_PINCTRL_MUXSEL1_RSRVD0)
#endif
/* --- Register HW_PINCTRL_MUXSEL1, field BANK0_PIN28 */

#define BP_PINCTRL_MUXSEL1_BANK0_PIN28      24
#define BM_PINCTRL_MUXSEL1_BANK0_PIN28      0x03000000

#define BF_PINCTRL_MUXSEL1_BANK0_PIN28(v)   (((v) << 24) & BM_PINCTRL_MUXSEL1_BANK0_PIN28)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL1_BANK0_PIN28(v)   BF_CS1(PINCTRL_MUXSEL1, BANK0_PIN28, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL1, field BANK0_PIN27 */

#define BP_PINCTRL_MUXSEL1_BANK0_PIN27      22
#define BM_PINCTRL_MUXSEL1_BANK0_PIN27      0x00C00000

#define BF_PINCTRL_MUXSEL1_BANK0_PIN27(v)   (((v) << 22) & BM_PINCTRL_MUXSEL1_BANK0_PIN27)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL1_BANK0_PIN27(v)   BF_CS1(PINCTRL_MUXSEL1, BANK0_PIN27, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL1, field BANK0_PIN26 */

#define BP_PINCTRL_MUXSEL1_BANK0_PIN26      20
#define BM_PINCTRL_MUXSEL1_BANK0_PIN26      0x00300000

#define BF_PINCTRL_MUXSEL1_BANK0_PIN26(v)   (((v) << 20) & BM_PINCTRL_MUXSEL1_BANK0_PIN26)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL1_BANK0_PIN26(v)   BF_CS1(PINCTRL_MUXSEL1, BANK0_PIN26, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL1, field BANK0_PIN25 */

#define BP_PINCTRL_MUXSEL1_BANK0_PIN25      18
#define BM_PINCTRL_MUXSEL1_BANK0_PIN25      0x000C0000

#define BF_PINCTRL_MUXSEL1_BANK0_PIN25(v)   (((v) << 18) & BM_PINCTRL_MUXSEL1_BANK0_PIN25)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL1_BANK0_PIN25(v)   BF_CS1(PINCTRL_MUXSEL1, BANK0_PIN25, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL1, field BANK0_PIN24 */

#define BP_PINCTRL_MUXSEL1_BANK0_PIN24      16
#define BM_PINCTRL_MUXSEL1_BANK0_PIN24      0x00030000

#define BF_PINCTRL_MUXSEL1_BANK0_PIN24(v)   (((v) << 16) & BM_PINCTRL_MUXSEL1_BANK0_PIN24)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL1_BANK0_PIN24(v)   BF_CS1(PINCTRL_MUXSEL1, BANK0_PIN24, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL1, field BANK0_PIN23 */

#define BP_PINCTRL_MUXSEL1_BANK0_PIN23      14
#define BM_PINCTRL_MUXSEL1_BANK0_PIN23      0x0000C000

#define BF_PINCTRL_MUXSEL1_BANK0_PIN23(v)   (((v) << 14) & BM_PINCTRL_MUXSEL1_BANK0_PIN23)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL1_BANK0_PIN23(v)   BF_CS1(PINCTRL_MUXSEL1, BANK0_PIN23, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL1, field BANK0_PIN22 */

#define BP_PINCTRL_MUXSEL1_BANK0_PIN22      12
#define BM_PINCTRL_MUXSEL1_BANK0_PIN22      0x00003000

#define BF_PINCTRL_MUXSEL1_BANK0_PIN22(v)   (((v) << 12) & BM_PINCTRL_MUXSEL1_BANK0_PIN22)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL1_BANK0_PIN22(v)   BF_CS1(PINCTRL_MUXSEL1, BANK0_PIN22, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL1, field BANK0_PIN21 */

#define BP_PINCTRL_MUXSEL1_BANK0_PIN21      10
#define BM_PINCTRL_MUXSEL1_BANK0_PIN21      0x00000C00

#define BF_PINCTRL_MUXSEL1_BANK0_PIN21(v)   (((v) << 10) & BM_PINCTRL_MUXSEL1_BANK0_PIN21)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL1_BANK0_PIN21(v)   BF_CS1(PINCTRL_MUXSEL1, BANK0_PIN21, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL1, field BANK0_PIN20 */

#define BP_PINCTRL_MUXSEL1_BANK0_PIN20      8
#define BM_PINCTRL_MUXSEL1_BANK0_PIN20      0x00000300

#define BF_PINCTRL_MUXSEL1_BANK0_PIN20(v)   (((v) << 8) & BM_PINCTRL_MUXSEL1_BANK0_PIN20)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL1_BANK0_PIN20(v)   BF_CS1(PINCTRL_MUXSEL1, BANK0_PIN20, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL1, field BANK0_PIN19 */

#define BP_PINCTRL_MUXSEL1_BANK0_PIN19      6
#define BM_PINCTRL_MUXSEL1_BANK0_PIN19      0x000000C0

#define BF_PINCTRL_MUXSEL1_BANK0_PIN19(v)   (((v) << 6) & BM_PINCTRL_MUXSEL1_BANK0_PIN19)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL1_BANK0_PIN19(v)   BF_CS1(PINCTRL_MUXSEL1, BANK0_PIN19, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL1, field BANK0_PIN18 */

#define BP_PINCTRL_MUXSEL1_BANK0_PIN18      4
#define BM_PINCTRL_MUXSEL1_BANK0_PIN18      0x00000030

#define BF_PINCTRL_MUXSEL1_BANK0_PIN18(v)   (((v) << 4) & BM_PINCTRL_MUXSEL1_BANK0_PIN18)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL1_BANK0_PIN18(v)   BF_CS1(PINCTRL_MUXSEL1, BANK0_PIN18, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL1, field BANK0_PIN17 */

#define BP_PINCTRL_MUXSEL1_BANK0_PIN17      2
#define BM_PINCTRL_MUXSEL1_BANK0_PIN17      0x0000000C

#define BF_PINCTRL_MUXSEL1_BANK0_PIN17(v)   (((v) << 2) & BM_PINCTRL_MUXSEL1_BANK0_PIN17)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL1_BANK0_PIN17(v)   BF_CS1(PINCTRL_MUXSEL1, BANK0_PIN17, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL1, field BANK0_PIN16 */

#define BP_PINCTRL_MUXSEL1_BANK0_PIN16      0
#define BM_PINCTRL_MUXSEL1_BANK0_PIN16      0x00000003

#define BF_PINCTRL_MUXSEL1_BANK0_PIN16(v)   (((v) << 0) & BM_PINCTRL_MUXSEL1_BANK0_PIN16)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL1_BANK0_PIN16(v)   BF_CS1(PINCTRL_MUXSEL1, BANK0_PIN16, v)
#endif



/*
 * HW_PINCTRL_MUXSEL2 - PINCTRL Pin Mux Select Register 2
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK1_PIN00  :  2;
        unsigned BANK1_PIN01  :  2;
        unsigned BANK1_PIN02  :  2;
        unsigned BANK1_PIN03  :  2;
        unsigned BANK1_PIN04  :  2;
        unsigned BANK1_PIN05  :  2;
        unsigned BANK1_PIN06  :  2;
        unsigned BANK1_PIN07  :  2;
        unsigned BANK1_PIN08  :  2;
        unsigned BANK1_PIN09  :  2;
        unsigned BANK1_PIN10  :  2;
        unsigned BANK1_PIN11  :  2;
        unsigned BANK1_PIN12  :  2;
        unsigned BANK1_PIN13  :  2;
        unsigned BANK1_PIN14  :  2;
        unsigned BANK1_PIN15  :  2;
    } B;
} hw_pinctrl_muxsel2_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_MUXSEL2 register
 */
#define HW_PINCTRL_MUXSEL2_ADDR         (REGS_PINCTRL_BASE + 0x120)
#define HW_PINCTRL_MUXSEL2_SET_ADDR     (HW_PINCTRL_MUXSEL2_ADDR + 4)
#define HW_PINCTRL_MUXSEL2_CLR_ADDR     (HW_PINCTRL_MUXSEL2_ADDR + 8)
#define HW_PINCTRL_MUXSEL2_TOG_ADDR     (HW_PINCTRL_MUXSEL2_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_MUXSEL2           (*(volatile hw_pinctrl_muxsel2_t *) HW_PINCTRL_MUXSEL2_ADDR)
#define HW_PINCTRL_MUXSEL2_RD()      (HW_PINCTRL_MUXSEL2.U)
#define HW_PINCTRL_MUXSEL2_WR(v)     (HW_PINCTRL_MUXSEL2.U = (v))
#define HW_PINCTRL_MUXSEL2_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL2_SET_ADDR) = (v))
#define HW_PINCTRL_MUXSEL2_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL2_CLR_ADDR) = (v))
#define HW_PINCTRL_MUXSEL2_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL2_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_MUXSEL2 bitfields
 */
/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN15 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN15      30
#define BM_PINCTRL_MUXSEL2_BANK1_PIN15      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_MUXSEL2_BANK1_PIN15(v)   ((((reg32_t) v) << 30) & BM_PINCTRL_MUXSEL2_BANK1_PIN15)
#else
#define BF_PINCTRL_MUXSEL2_BANK1_PIN15(v)   (((v) << 30) & BM_PINCTRL_MUXSEL2_BANK1_PIN15)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN15(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN15, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN14 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN14      28
#define BM_PINCTRL_MUXSEL2_BANK1_PIN14      0x30000000

#define BF_PINCTRL_MUXSEL2_BANK1_PIN14(v)   (((v) << 28) & BM_PINCTRL_MUXSEL2_BANK1_PIN14)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN14(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN14, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN13 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN13      26
#define BM_PINCTRL_MUXSEL2_BANK1_PIN13      0x0C000000

#define BF_PINCTRL_MUXSEL2_BANK1_PIN13(v)   (((v) << 26) & BM_PINCTRL_MUXSEL2_BANK1_PIN13)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN13(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN13, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN12 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN12      24
#define BM_PINCTRL_MUXSEL2_BANK1_PIN12      0x03000000

#define BF_PINCTRL_MUXSEL2_BANK1_PIN12(v)   (((v) << 24) & BM_PINCTRL_MUXSEL2_BANK1_PIN12)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN12(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN12, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN11 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN11      22
#define BM_PINCTRL_MUXSEL2_BANK1_PIN11      0x00C00000

#define BF_PINCTRL_MUXSEL2_BANK1_PIN11(v)   (((v) << 22) & BM_PINCTRL_MUXSEL2_BANK1_PIN11)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN11(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN11, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN10 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN10      20
#define BM_PINCTRL_MUXSEL2_BANK1_PIN10      0x00300000

#define BF_PINCTRL_MUXSEL2_BANK1_PIN10(v)   (((v) << 20) & BM_PINCTRL_MUXSEL2_BANK1_PIN10)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN10(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN10, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN09 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN09      18
#define BM_PINCTRL_MUXSEL2_BANK1_PIN09      0x000C0000

#define BF_PINCTRL_MUXSEL2_BANK1_PIN09(v)   (((v) << 18) & BM_PINCTRL_MUXSEL2_BANK1_PIN09)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN09(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN09, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN08 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN08      16
#define BM_PINCTRL_MUXSEL2_BANK1_PIN08      0x00030000

#define BF_PINCTRL_MUXSEL2_BANK1_PIN08(v)   (((v) << 16) & BM_PINCTRL_MUXSEL2_BANK1_PIN08)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN08(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN08, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN07 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN07      14
#define BM_PINCTRL_MUXSEL2_BANK1_PIN07      0x0000C000

#define BF_PINCTRL_MUXSEL2_BANK1_PIN07(v)   (((v) << 14) & BM_PINCTRL_MUXSEL2_BANK1_PIN07)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN07(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN07, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN06 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN06      12
#define BM_PINCTRL_MUXSEL2_BANK1_PIN06      0x00003000

#define BF_PINCTRL_MUXSEL2_BANK1_PIN06(v)   (((v) << 12) & BM_PINCTRL_MUXSEL2_BANK1_PIN06)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN06(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN06, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN05 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN05      10
#define BM_PINCTRL_MUXSEL2_BANK1_PIN05      0x00000C00

#define BF_PINCTRL_MUXSEL2_BANK1_PIN05(v)   (((v) << 10) & BM_PINCTRL_MUXSEL2_BANK1_PIN05)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN05(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN05, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN04 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN04      8
#define BM_PINCTRL_MUXSEL2_BANK1_PIN04      0x00000300

#define BF_PINCTRL_MUXSEL2_BANK1_PIN04(v)   (((v) << 8) & BM_PINCTRL_MUXSEL2_BANK1_PIN04)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN04(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN04, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN03 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN03      6
#define BM_PINCTRL_MUXSEL2_BANK1_PIN03      0x000000C0

#define BF_PINCTRL_MUXSEL2_BANK1_PIN03(v)   (((v) << 6) & BM_PINCTRL_MUXSEL2_BANK1_PIN03)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN03(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN03, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN02 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN02      4
#define BM_PINCTRL_MUXSEL2_BANK1_PIN02      0x00000030

#define BF_PINCTRL_MUXSEL2_BANK1_PIN02(v)   (((v) << 4) & BM_PINCTRL_MUXSEL2_BANK1_PIN02)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN02(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN02, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN01 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN01      2
#define BM_PINCTRL_MUXSEL2_BANK1_PIN01      0x0000000C

#define BF_PINCTRL_MUXSEL2_BANK1_PIN01(v)   (((v) << 2) & BM_PINCTRL_MUXSEL2_BANK1_PIN01)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN01(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN01, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL2, field BANK1_PIN00 */

#define BP_PINCTRL_MUXSEL2_BANK1_PIN00      0
#define BM_PINCTRL_MUXSEL2_BANK1_PIN00      0x00000003

#define BF_PINCTRL_MUXSEL2_BANK1_PIN00(v)   (((v) << 0) & BM_PINCTRL_MUXSEL2_BANK1_PIN00)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL2_BANK1_PIN00(v)   BF_CS1(PINCTRL_MUXSEL2, BANK1_PIN00, v)
#endif



/*
 * HW_PINCTRL_MUXSEL3 - PINCTRL Pin Mux Select Register 3
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK1_PIN16  :  2;
        unsigned BANK1_PIN17  :  2;
        unsigned BANK1_PIN18  :  2;
        unsigned BANK1_PIN19  :  2;
        unsigned BANK1_PIN20  :  2;
        unsigned BANK1_PIN21  :  2;
        unsigned BANK1_PIN22  :  2;
        unsigned BANK1_PIN23  :  2;
        unsigned BANK1_PIN24  :  2;
        unsigned BANK1_PIN25  :  2;
        unsigned BANK1_PIN26  :  2;
        unsigned BANK1_PIN27  :  2;
        unsigned BANK1_PIN28  :  2;
        unsigned BANK1_PIN29  :  2;
        unsigned BANK1_PIN30  :  2;
        unsigned BANK1_PIN31  :  2;
    } B;
} hw_pinctrl_muxsel3_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_MUXSEL3 register
 */
#define HW_PINCTRL_MUXSEL3_ADDR         (REGS_PINCTRL_BASE + 0x130)
#define HW_PINCTRL_MUXSEL3_SET_ADDR     (HW_PINCTRL_MUXSEL3_ADDR + 4)
#define HW_PINCTRL_MUXSEL3_CLR_ADDR     (HW_PINCTRL_MUXSEL3_ADDR + 8)
#define HW_PINCTRL_MUXSEL3_TOG_ADDR     (HW_PINCTRL_MUXSEL3_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_MUXSEL3           (*(volatile hw_pinctrl_muxsel3_t *) HW_PINCTRL_MUXSEL3_ADDR)
#define HW_PINCTRL_MUXSEL3_RD()      (HW_PINCTRL_MUXSEL3.U)
#define HW_PINCTRL_MUXSEL3_WR(v)     (HW_PINCTRL_MUXSEL3.U = (v))
#define HW_PINCTRL_MUXSEL3_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL3_SET_ADDR) = (v))
#define HW_PINCTRL_MUXSEL3_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL3_CLR_ADDR) = (v))
#define HW_PINCTRL_MUXSEL3_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL3_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_MUXSEL3 bitfields
 */
/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN31 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN31      30
#define BM_PINCTRL_MUXSEL3_BANK1_PIN31      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_MUXSEL3_BANK1_PIN31(v)   ((((reg32_t) v) << 30) & BM_PINCTRL_MUXSEL3_BANK1_PIN31)
#else
#define BF_PINCTRL_MUXSEL3_BANK1_PIN31(v)   (((v) << 30) & BM_PINCTRL_MUXSEL3_BANK1_PIN31)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN31(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN31, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN30 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN30      28
#define BM_PINCTRL_MUXSEL3_BANK1_PIN30      0x30000000

#define BF_PINCTRL_MUXSEL3_BANK1_PIN30(v)   (((v) << 28) & BM_PINCTRL_MUXSEL3_BANK1_PIN30)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN30(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN30, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN29 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN29      26
#define BM_PINCTRL_MUXSEL3_BANK1_PIN29      0x0C000000

#define BF_PINCTRL_MUXSEL3_BANK1_PIN29(v)   (((v) << 26) & BM_PINCTRL_MUXSEL3_BANK1_PIN29)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN29(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN29, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN28 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN28      24
#define BM_PINCTRL_MUXSEL3_BANK1_PIN28      0x03000000

#define BF_PINCTRL_MUXSEL3_BANK1_PIN28(v)   (((v) << 24) & BM_PINCTRL_MUXSEL3_BANK1_PIN28)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN28(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN28, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN27 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN27      22
#define BM_PINCTRL_MUXSEL3_BANK1_PIN27      0x00C00000

#define BF_PINCTRL_MUXSEL3_BANK1_PIN27(v)   (((v) << 22) & BM_PINCTRL_MUXSEL3_BANK1_PIN27)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN27(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN27, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN26 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN26      20
#define BM_PINCTRL_MUXSEL3_BANK1_PIN26      0x00300000

#define BF_PINCTRL_MUXSEL3_BANK1_PIN26(v)   (((v) << 20) & BM_PINCTRL_MUXSEL3_BANK1_PIN26)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN26(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN26, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN25 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN25      18
#define BM_PINCTRL_MUXSEL3_BANK1_PIN25      0x000C0000

#define BF_PINCTRL_MUXSEL3_BANK1_PIN25(v)   (((v) << 18) & BM_PINCTRL_MUXSEL3_BANK1_PIN25)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN25(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN25, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN24 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN24      16
#define BM_PINCTRL_MUXSEL3_BANK1_PIN24      0x00030000

#define BF_PINCTRL_MUXSEL3_BANK1_PIN24(v)   (((v) << 16) & BM_PINCTRL_MUXSEL3_BANK1_PIN24)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN24(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN24, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN23 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN23      14
#define BM_PINCTRL_MUXSEL3_BANK1_PIN23      0x0000C000

#define BF_PINCTRL_MUXSEL3_BANK1_PIN23(v)   (((v) << 14) & BM_PINCTRL_MUXSEL3_BANK1_PIN23)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN23(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN23, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN22 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN22      12
#define BM_PINCTRL_MUXSEL3_BANK1_PIN22      0x00003000

#define BF_PINCTRL_MUXSEL3_BANK1_PIN22(v)   (((v) << 12) & BM_PINCTRL_MUXSEL3_BANK1_PIN22)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN22(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN22, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN21 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN21      10
#define BM_PINCTRL_MUXSEL3_BANK1_PIN21      0x00000C00

#define BF_PINCTRL_MUXSEL3_BANK1_PIN21(v)   (((v) << 10) & BM_PINCTRL_MUXSEL3_BANK1_PIN21)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN21(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN21, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN20 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN20      8
#define BM_PINCTRL_MUXSEL3_BANK1_PIN20      0x00000300

#define BF_PINCTRL_MUXSEL3_BANK1_PIN20(v)   (((v) << 8) & BM_PINCTRL_MUXSEL3_BANK1_PIN20)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN20(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN20, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN19 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN19      6
#define BM_PINCTRL_MUXSEL3_BANK1_PIN19      0x000000C0

#define BF_PINCTRL_MUXSEL3_BANK1_PIN19(v)   (((v) << 6) & BM_PINCTRL_MUXSEL3_BANK1_PIN19)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN19(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN19, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN18 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN18      4
#define BM_PINCTRL_MUXSEL3_BANK1_PIN18      0x00000030

#define BF_PINCTRL_MUXSEL3_BANK1_PIN18(v)   (((v) << 4) & BM_PINCTRL_MUXSEL3_BANK1_PIN18)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN18(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN18, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN17 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN17      2
#define BM_PINCTRL_MUXSEL3_BANK1_PIN17      0x0000000C

#define BF_PINCTRL_MUXSEL3_BANK1_PIN17(v)   (((v) << 2) & BM_PINCTRL_MUXSEL3_BANK1_PIN17)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN17(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN17, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL3, field BANK1_PIN16 */

#define BP_PINCTRL_MUXSEL3_BANK1_PIN16      0
#define BM_PINCTRL_MUXSEL3_BANK1_PIN16      0x00000003

#define BF_PINCTRL_MUXSEL3_BANK1_PIN16(v)   (((v) << 0) & BM_PINCTRL_MUXSEL3_BANK1_PIN16)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL3_BANK1_PIN16(v)   BF_CS1(PINCTRL_MUXSEL3, BANK1_PIN16, v)
#endif



/*
 * HW_PINCTRL_MUXSEL4 - PINCTRL Pin Mux Select Register 4
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK2_PIN00  :  2;
        unsigned BANK2_PIN01  :  2;
        unsigned BANK2_PIN02  :  2;
        unsigned BANK2_PIN03  :  2;
        unsigned BANK2_PIN04  :  2;
        unsigned BANK2_PIN05  :  2;
        unsigned BANK2_PIN06  :  2;
        unsigned BANK2_PIN07  :  2;
        unsigned BANK2_PIN08  :  2;
        unsigned BANK2_PIN09  :  2;
        unsigned BANK2_PIN10  :  2;
        unsigned RSRVD0       :  2;
        unsigned BANK2_PIN12  :  2;
        unsigned BANK2_PIN13  :  2;
        unsigned BANK2_PIN14  :  2;
        unsigned BANK2_PIN15  :  2;
    } B;
} hw_pinctrl_muxsel4_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_MUXSEL4 register
 */
#define HW_PINCTRL_MUXSEL4_ADDR         (REGS_PINCTRL_BASE + 0x140)
#define HW_PINCTRL_MUXSEL4_SET_ADDR     (HW_PINCTRL_MUXSEL4_ADDR + 4)
#define HW_PINCTRL_MUXSEL4_CLR_ADDR     (HW_PINCTRL_MUXSEL4_ADDR + 8)
#define HW_PINCTRL_MUXSEL4_TOG_ADDR     (HW_PINCTRL_MUXSEL4_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_MUXSEL4           (*(volatile hw_pinctrl_muxsel4_t *) HW_PINCTRL_MUXSEL4_ADDR)
#define HW_PINCTRL_MUXSEL4_RD()      (HW_PINCTRL_MUXSEL4.U)
#define HW_PINCTRL_MUXSEL4_WR(v)     (HW_PINCTRL_MUXSEL4.U = (v))
#define HW_PINCTRL_MUXSEL4_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL4_SET_ADDR) = (v))
#define HW_PINCTRL_MUXSEL4_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL4_CLR_ADDR) = (v))
#define HW_PINCTRL_MUXSEL4_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL4_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_MUXSEL4 bitfields
 */
/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN15 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN15      30
#define BM_PINCTRL_MUXSEL4_BANK2_PIN15      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_MUXSEL4_BANK2_PIN15(v)   ((((reg32_t) v) << 30) & BM_PINCTRL_MUXSEL4_BANK2_PIN15)
#else
#define BF_PINCTRL_MUXSEL4_BANK2_PIN15(v)   (((v) << 30) & BM_PINCTRL_MUXSEL4_BANK2_PIN15)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN15(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN15, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN14 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN14      28
#define BM_PINCTRL_MUXSEL4_BANK2_PIN14      0x30000000

#define BF_PINCTRL_MUXSEL4_BANK2_PIN14(v)   (((v) << 28) & BM_PINCTRL_MUXSEL4_BANK2_PIN14)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN14(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN14, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN13 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN13      26
#define BM_PINCTRL_MUXSEL4_BANK2_PIN13      0x0C000000

#define BF_PINCTRL_MUXSEL4_BANK2_PIN13(v)   (((v) << 26) & BM_PINCTRL_MUXSEL4_BANK2_PIN13)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN13(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN13, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN12 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN12      24
#define BM_PINCTRL_MUXSEL4_BANK2_PIN12      0x03000000

#define BF_PINCTRL_MUXSEL4_BANK2_PIN12(v)   (((v) << 24) & BM_PINCTRL_MUXSEL4_BANK2_PIN12)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN12(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN12, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL4, field RSRVD0 */

#define BP_PINCTRL_MUXSEL4_RSRVD0      22
#define BM_PINCTRL_MUXSEL4_RSRVD0      0x00C00000

#define BF_PINCTRL_MUXSEL4_RSRVD0(v)   (((v) << 22) & BM_PINCTRL_MUXSEL4_RSRVD0)
/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN10 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN10      20
#define BM_PINCTRL_MUXSEL4_BANK2_PIN10      0x00300000

#define BF_PINCTRL_MUXSEL4_BANK2_PIN10(v)   (((v) << 20) & BM_PINCTRL_MUXSEL4_BANK2_PIN10)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN10(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN10, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN09 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN09      18
#define BM_PINCTRL_MUXSEL4_BANK2_PIN09      0x000C0000

#define BF_PINCTRL_MUXSEL4_BANK2_PIN09(v)   (((v) << 18) & BM_PINCTRL_MUXSEL4_BANK2_PIN09)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN09(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN09, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN08 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN08      16
#define BM_PINCTRL_MUXSEL4_BANK2_PIN08      0x00030000

#define BF_PINCTRL_MUXSEL4_BANK2_PIN08(v)   (((v) << 16) & BM_PINCTRL_MUXSEL4_BANK2_PIN08)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN08(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN08, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN07 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN07      14
#define BM_PINCTRL_MUXSEL4_BANK2_PIN07      0x0000C000

#define BF_PINCTRL_MUXSEL4_BANK2_PIN07(v)   (((v) << 14) & BM_PINCTRL_MUXSEL4_BANK2_PIN07)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN07(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN07, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN06 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN06      12
#define BM_PINCTRL_MUXSEL4_BANK2_PIN06      0x00003000

#define BF_PINCTRL_MUXSEL4_BANK2_PIN06(v)   (((v) << 12) & BM_PINCTRL_MUXSEL4_BANK2_PIN06)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN06(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN06, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN05 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN05      10
#define BM_PINCTRL_MUXSEL4_BANK2_PIN05      0x00000C00

#define BF_PINCTRL_MUXSEL4_BANK2_PIN05(v)   (((v) << 10) & BM_PINCTRL_MUXSEL4_BANK2_PIN05)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN05(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN05, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN04 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN04      8
#define BM_PINCTRL_MUXSEL4_BANK2_PIN04      0x00000300

#define BF_PINCTRL_MUXSEL4_BANK2_PIN04(v)   (((v) << 8) & BM_PINCTRL_MUXSEL4_BANK2_PIN04)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN04(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN04, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN03 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN03      6
#define BM_PINCTRL_MUXSEL4_BANK2_PIN03      0x000000C0

#define BF_PINCTRL_MUXSEL4_BANK2_PIN03(v)   (((v) << 6) & BM_PINCTRL_MUXSEL4_BANK2_PIN03)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN03(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN03, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN02 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN02      4
#define BM_PINCTRL_MUXSEL4_BANK2_PIN02      0x00000030

#define BF_PINCTRL_MUXSEL4_BANK2_PIN02(v)   (((v) << 4) & BM_PINCTRL_MUXSEL4_BANK2_PIN02)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN02(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN02, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN01 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN01      2
#define BM_PINCTRL_MUXSEL4_BANK2_PIN01      0x0000000C

#define BF_PINCTRL_MUXSEL4_BANK2_PIN01(v)   (((v) << 2) & BM_PINCTRL_MUXSEL4_BANK2_PIN01)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN01(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN01, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL4, field BANK2_PIN00 */

#define BP_PINCTRL_MUXSEL4_BANK2_PIN00      0
#define BM_PINCTRL_MUXSEL4_BANK2_PIN00      0x00000003

#define BF_PINCTRL_MUXSEL4_BANK2_PIN00(v)   (((v) << 0) & BM_PINCTRL_MUXSEL4_BANK2_PIN00)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL4_BANK2_PIN00(v)   BF_CS1(PINCTRL_MUXSEL4, BANK2_PIN00, v)
#endif



/*
 * HW_PINCTRL_MUXSEL5 - PINCTRL Pin Mux Select Register 5
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK2_PIN16  :  2;
        unsigned BANK2_PIN17  :  2;
        unsigned BANK2_PIN18  :  2;
        unsigned BANK2_PIN19  :  2;
        unsigned BANK2_PIN20  :  2;
        unsigned BANK2_PIN21  :  2;
        unsigned RSRVD0       :  4;
        unsigned BANK2_PIN24  :  2;
        unsigned BANK2_PIN25  :  2;
        unsigned BANK2_PIN26  :  2;
        unsigned BANK2_PIN27  :  2;
        unsigned RSRVD1       :  8;
    } B;
} hw_pinctrl_muxsel5_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_MUXSEL5 register
 */
#define HW_PINCTRL_MUXSEL5_ADDR         (REGS_PINCTRL_BASE + 0x150)
#define HW_PINCTRL_MUXSEL5_SET_ADDR     (HW_PINCTRL_MUXSEL5_ADDR + 4)
#define HW_PINCTRL_MUXSEL5_CLR_ADDR     (HW_PINCTRL_MUXSEL5_ADDR + 8)
#define HW_PINCTRL_MUXSEL5_TOG_ADDR     (HW_PINCTRL_MUXSEL5_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_MUXSEL5           (*(volatile hw_pinctrl_muxsel5_t *) HW_PINCTRL_MUXSEL5_ADDR)
#define HW_PINCTRL_MUXSEL5_RD()      (HW_PINCTRL_MUXSEL5.U)
#define HW_PINCTRL_MUXSEL5_WR(v)     (HW_PINCTRL_MUXSEL5.U = (v))
#define HW_PINCTRL_MUXSEL5_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL5_SET_ADDR) = (v))
#define HW_PINCTRL_MUXSEL5_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL5_CLR_ADDR) = (v))
#define HW_PINCTRL_MUXSEL5_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL5_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_MUXSEL5 bitfields
 */
/* --- Register HW_PINCTRL_MUXSEL5, field RSRVD1 */

#define BP_PINCTRL_MUXSEL5_RSRVD1      24
#define BM_PINCTRL_MUXSEL5_RSRVD1      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_MUXSEL5_RSRVD1(v)   ((((reg32_t) v) << 24) & BM_PINCTRL_MUXSEL5_RSRVD1)
#else
#define BF_PINCTRL_MUXSEL5_RSRVD1(v)   (((v) << 24) & BM_PINCTRL_MUXSEL5_RSRVD1)
#endif
/* --- Register HW_PINCTRL_MUXSEL5, field BANK2_PIN27 */

#define BP_PINCTRL_MUXSEL5_BANK2_PIN27      22
#define BM_PINCTRL_MUXSEL5_BANK2_PIN27      0x00C00000

#define BF_PINCTRL_MUXSEL5_BANK2_PIN27(v)   (((v) << 22) & BM_PINCTRL_MUXSEL5_BANK2_PIN27)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL5_BANK2_PIN27(v)   BF_CS1(PINCTRL_MUXSEL5, BANK2_PIN27, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL5, field BANK2_PIN26 */

#define BP_PINCTRL_MUXSEL5_BANK2_PIN26      20
#define BM_PINCTRL_MUXSEL5_BANK2_PIN26      0x00300000

#define BF_PINCTRL_MUXSEL5_BANK2_PIN26(v)   (((v) << 20) & BM_PINCTRL_MUXSEL5_BANK2_PIN26)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL5_BANK2_PIN26(v)   BF_CS1(PINCTRL_MUXSEL5, BANK2_PIN26, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL5, field BANK2_PIN25 */

#define BP_PINCTRL_MUXSEL5_BANK2_PIN25      18
#define BM_PINCTRL_MUXSEL5_BANK2_PIN25      0x000C0000

#define BF_PINCTRL_MUXSEL5_BANK2_PIN25(v)   (((v) << 18) & BM_PINCTRL_MUXSEL5_BANK2_PIN25)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL5_BANK2_PIN25(v)   BF_CS1(PINCTRL_MUXSEL5, BANK2_PIN25, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL5, field BANK2_PIN24 */

#define BP_PINCTRL_MUXSEL5_BANK2_PIN24      16
#define BM_PINCTRL_MUXSEL5_BANK2_PIN24      0x00030000

#define BF_PINCTRL_MUXSEL5_BANK2_PIN24(v)   (((v) << 16) & BM_PINCTRL_MUXSEL5_BANK2_PIN24)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL5_BANK2_PIN24(v)   BF_CS1(PINCTRL_MUXSEL5, BANK2_PIN24, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL5, field RSRVD0 */

#define BP_PINCTRL_MUXSEL5_RSRVD0      12
#define BM_PINCTRL_MUXSEL5_RSRVD0      0x0000F000

#define BF_PINCTRL_MUXSEL5_RSRVD0(v)   (((v) << 12) & BM_PINCTRL_MUXSEL5_RSRVD0)
/* --- Register HW_PINCTRL_MUXSEL5, field BANK2_PIN21 */

#define BP_PINCTRL_MUXSEL5_BANK2_PIN21      10
#define BM_PINCTRL_MUXSEL5_BANK2_PIN21      0x00000C00

#define BF_PINCTRL_MUXSEL5_BANK2_PIN21(v)   (((v) << 10) & BM_PINCTRL_MUXSEL5_BANK2_PIN21)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL5_BANK2_PIN21(v)   BF_CS1(PINCTRL_MUXSEL5, BANK2_PIN21, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL5, field BANK2_PIN20 */

#define BP_PINCTRL_MUXSEL5_BANK2_PIN20      8
#define BM_PINCTRL_MUXSEL5_BANK2_PIN20      0x00000300

#define BF_PINCTRL_MUXSEL5_BANK2_PIN20(v)   (((v) << 8) & BM_PINCTRL_MUXSEL5_BANK2_PIN20)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL5_BANK2_PIN20(v)   BF_CS1(PINCTRL_MUXSEL5, BANK2_PIN20, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL5, field BANK2_PIN19 */

#define BP_PINCTRL_MUXSEL5_BANK2_PIN19      6
#define BM_PINCTRL_MUXSEL5_BANK2_PIN19      0x000000C0

#define BF_PINCTRL_MUXSEL5_BANK2_PIN19(v)   (((v) << 6) & BM_PINCTRL_MUXSEL5_BANK2_PIN19)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL5_BANK2_PIN19(v)   BF_CS1(PINCTRL_MUXSEL5, BANK2_PIN19, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL5, field BANK2_PIN18 */

#define BP_PINCTRL_MUXSEL5_BANK2_PIN18      4
#define BM_PINCTRL_MUXSEL5_BANK2_PIN18      0x00000030

#define BF_PINCTRL_MUXSEL5_BANK2_PIN18(v)   (((v) << 4) & BM_PINCTRL_MUXSEL5_BANK2_PIN18)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL5_BANK2_PIN18(v)   BF_CS1(PINCTRL_MUXSEL5, BANK2_PIN18, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL5, field BANK2_PIN17 */

#define BP_PINCTRL_MUXSEL5_BANK2_PIN17      2
#define BM_PINCTRL_MUXSEL5_BANK2_PIN17      0x0000000C

#define BF_PINCTRL_MUXSEL5_BANK2_PIN17(v)   (((v) << 2) & BM_PINCTRL_MUXSEL5_BANK2_PIN17)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL5_BANK2_PIN17(v)   BF_CS1(PINCTRL_MUXSEL5, BANK2_PIN17, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL5, field BANK2_PIN16 */

#define BP_PINCTRL_MUXSEL5_BANK2_PIN16      0
#define BM_PINCTRL_MUXSEL5_BANK2_PIN16      0x00000003

#define BF_PINCTRL_MUXSEL5_BANK2_PIN16(v)   (((v) << 0) & BM_PINCTRL_MUXSEL5_BANK2_PIN16)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL5_BANK2_PIN16(v)   BF_CS1(PINCTRL_MUXSEL5, BANK2_PIN16, v)
#endif



/*
 * HW_PINCTRL_MUXSEL6 - PINCTRL Pin Mux Select Register 6
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK3_PIN00  :  2;
        unsigned BANK3_PIN01  :  2;
        unsigned BANK3_PIN02  :  2;
        unsigned BANK3_PIN03  :  2;
        unsigned BANK3_PIN04  :  2;
        unsigned BANK3_PIN05  :  2;
        unsigned BANK3_PIN06  :  2;
        unsigned BANK3_PIN07  :  2;
        unsigned BANK3_PIN08  :  2;
        unsigned BANK3_PIN09  :  2;
        unsigned BANK3_PIN10  :  2;
        unsigned BANK3_PIN11  :  2;
        unsigned BANK3_PIN12  :  2;
        unsigned BANK3_PIN13  :  2;
        unsigned BANK3_PIN14  :  2;
        unsigned BANK3_PIN15  :  2;
    } B;
} hw_pinctrl_muxsel6_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_MUXSEL6 register
 */
#define HW_PINCTRL_MUXSEL6_ADDR         (REGS_PINCTRL_BASE + 0x160)
#define HW_PINCTRL_MUXSEL6_SET_ADDR     (HW_PINCTRL_MUXSEL6_ADDR + 4)
#define HW_PINCTRL_MUXSEL6_CLR_ADDR     (HW_PINCTRL_MUXSEL6_ADDR + 8)
#define HW_PINCTRL_MUXSEL6_TOG_ADDR     (HW_PINCTRL_MUXSEL6_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_MUXSEL6           (*(volatile hw_pinctrl_muxsel6_t *) HW_PINCTRL_MUXSEL6_ADDR)
#define HW_PINCTRL_MUXSEL6_RD()      (HW_PINCTRL_MUXSEL6.U)
#define HW_PINCTRL_MUXSEL6_WR(v)     (HW_PINCTRL_MUXSEL6.U = (v))
#define HW_PINCTRL_MUXSEL6_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL6_SET_ADDR) = (v))
#define HW_PINCTRL_MUXSEL6_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL6_CLR_ADDR) = (v))
#define HW_PINCTRL_MUXSEL6_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL6_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_MUXSEL6 bitfields
 */
/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN15 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN15      30
#define BM_PINCTRL_MUXSEL6_BANK3_PIN15      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_MUXSEL6_BANK3_PIN15(v)   ((((reg32_t) v) << 30) & BM_PINCTRL_MUXSEL6_BANK3_PIN15)
#else
#define BF_PINCTRL_MUXSEL6_BANK3_PIN15(v)   (((v) << 30) & BM_PINCTRL_MUXSEL6_BANK3_PIN15)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN15(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN15, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN14 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN14      28
#define BM_PINCTRL_MUXSEL6_BANK3_PIN14      0x30000000

#define BF_PINCTRL_MUXSEL6_BANK3_PIN14(v)   (((v) << 28) & BM_PINCTRL_MUXSEL6_BANK3_PIN14)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN14(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN14, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN13 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN13      26
#define BM_PINCTRL_MUXSEL6_BANK3_PIN13      0x0C000000

#define BF_PINCTRL_MUXSEL6_BANK3_PIN13(v)   (((v) << 26) & BM_PINCTRL_MUXSEL6_BANK3_PIN13)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN13(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN13, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN12 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN12      24
#define BM_PINCTRL_MUXSEL6_BANK3_PIN12      0x03000000

#define BF_PINCTRL_MUXSEL6_BANK3_PIN12(v)   (((v) << 24) & BM_PINCTRL_MUXSEL6_BANK3_PIN12)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN12(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN12, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN11 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN11      22
#define BM_PINCTRL_MUXSEL6_BANK3_PIN11      0x00C00000

#define BF_PINCTRL_MUXSEL6_BANK3_PIN11(v)   (((v) << 22) & BM_PINCTRL_MUXSEL6_BANK3_PIN11)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN11(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN11, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN10 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN10      20
#define BM_PINCTRL_MUXSEL6_BANK3_PIN10      0x00300000

#define BF_PINCTRL_MUXSEL6_BANK3_PIN10(v)   (((v) << 20) & BM_PINCTRL_MUXSEL6_BANK3_PIN10)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN10(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN10, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN09 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN09      18
#define BM_PINCTRL_MUXSEL6_BANK3_PIN09      0x000C0000

#define BF_PINCTRL_MUXSEL6_BANK3_PIN09(v)   (((v) << 18) & BM_PINCTRL_MUXSEL6_BANK3_PIN09)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN09(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN09, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN08 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN08      16
#define BM_PINCTRL_MUXSEL6_BANK3_PIN08      0x00030000

#define BF_PINCTRL_MUXSEL6_BANK3_PIN08(v)   (((v) << 16) & BM_PINCTRL_MUXSEL6_BANK3_PIN08)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN08(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN08, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN07 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN07      14
#define BM_PINCTRL_MUXSEL6_BANK3_PIN07      0x0000C000

#define BF_PINCTRL_MUXSEL6_BANK3_PIN07(v)   (((v) << 14) & BM_PINCTRL_MUXSEL6_BANK3_PIN07)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN07(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN07, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN06 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN06      12
#define BM_PINCTRL_MUXSEL6_BANK3_PIN06      0x00003000

#define BF_PINCTRL_MUXSEL6_BANK3_PIN06(v)   (((v) << 12) & BM_PINCTRL_MUXSEL6_BANK3_PIN06)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN06(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN06, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN05 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN05      10
#define BM_PINCTRL_MUXSEL6_BANK3_PIN05      0x00000C00

#define BF_PINCTRL_MUXSEL6_BANK3_PIN05(v)   (((v) << 10) & BM_PINCTRL_MUXSEL6_BANK3_PIN05)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN05(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN05, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN04 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN04      8
#define BM_PINCTRL_MUXSEL6_BANK3_PIN04      0x00000300

#define BF_PINCTRL_MUXSEL6_BANK3_PIN04(v)   (((v) << 8) & BM_PINCTRL_MUXSEL6_BANK3_PIN04)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN04(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN04, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN03 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN03      6
#define BM_PINCTRL_MUXSEL6_BANK3_PIN03      0x000000C0

#define BF_PINCTRL_MUXSEL6_BANK3_PIN03(v)   (((v) << 6) & BM_PINCTRL_MUXSEL6_BANK3_PIN03)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN03(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN03, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN02 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN02      4
#define BM_PINCTRL_MUXSEL6_BANK3_PIN02      0x00000030

#define BF_PINCTRL_MUXSEL6_BANK3_PIN02(v)   (((v) << 4) & BM_PINCTRL_MUXSEL6_BANK3_PIN02)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN02(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN02, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN01 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN01      2
#define BM_PINCTRL_MUXSEL6_BANK3_PIN01      0x0000000C

#define BF_PINCTRL_MUXSEL6_BANK3_PIN01(v)   (((v) << 2) & BM_PINCTRL_MUXSEL6_BANK3_PIN01)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN01(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN01, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL6, field BANK3_PIN00 */

#define BP_PINCTRL_MUXSEL6_BANK3_PIN00      0
#define BM_PINCTRL_MUXSEL6_BANK3_PIN00      0x00000003

#define BF_PINCTRL_MUXSEL6_BANK3_PIN00(v)   (((v) << 0) & BM_PINCTRL_MUXSEL6_BANK3_PIN00)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL6_BANK3_PIN00(v)   BF_CS1(PINCTRL_MUXSEL6, BANK3_PIN00, v)
#endif



/*
 * HW_PINCTRL_MUXSEL7 - PINCTRL Pin Mux Select Register 7
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK3_PIN16  :  2;
        unsigned BANK3_PIN17  :  2;
        unsigned BANK3_PIN18  :  2;
        unsigned RSRVD0       :  2;
        unsigned BANK3_PIN20  :  2;
        unsigned BANK3_PIN21  :  2;
        unsigned BANK3_PIN22  :  2;
        unsigned BANK3_PIN23  :  2;
        unsigned BANK3_PIN24  :  2;
        unsigned BANK3_PIN25  :  2;
        unsigned BANK3_PIN26  :  2;
        unsigned BANK3_PIN27  :  2;
        unsigned BANK3_PIN28  :  2;
        unsigned BANK3_PIN29  :  2;
        unsigned BANK3_PIN30  :  2;
        unsigned RSRVD1       :  2;
    } B;
} hw_pinctrl_muxsel7_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_MUXSEL7 register
 */
#define HW_PINCTRL_MUXSEL7_ADDR         (REGS_PINCTRL_BASE + 0x170)
#define HW_PINCTRL_MUXSEL7_SET_ADDR     (HW_PINCTRL_MUXSEL7_ADDR + 4)
#define HW_PINCTRL_MUXSEL7_CLR_ADDR     (HW_PINCTRL_MUXSEL7_ADDR + 8)
#define HW_PINCTRL_MUXSEL7_TOG_ADDR     (HW_PINCTRL_MUXSEL7_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_MUXSEL7           (*(volatile hw_pinctrl_muxsel7_t *) HW_PINCTRL_MUXSEL7_ADDR)
#define HW_PINCTRL_MUXSEL7_RD()      (HW_PINCTRL_MUXSEL7.U)
#define HW_PINCTRL_MUXSEL7_WR(v)     (HW_PINCTRL_MUXSEL7.U = (v))
#define HW_PINCTRL_MUXSEL7_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL7_SET_ADDR) = (v))
#define HW_PINCTRL_MUXSEL7_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL7_CLR_ADDR) = (v))
#define HW_PINCTRL_MUXSEL7_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL7_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_MUXSEL7 bitfields
 */
/* --- Register HW_PINCTRL_MUXSEL7, field RSRVD1 */

#define BP_PINCTRL_MUXSEL7_RSRVD1      30
#define BM_PINCTRL_MUXSEL7_RSRVD1      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_MUXSEL7_RSRVD1(v)   ((((reg32_t) v) << 30) & BM_PINCTRL_MUXSEL7_RSRVD1)
#else
#define BF_PINCTRL_MUXSEL7_RSRVD1(v)   (((v) << 30) & BM_PINCTRL_MUXSEL7_RSRVD1)
#endif
/* --- Register HW_PINCTRL_MUXSEL7, field BANK3_PIN30 */

#define BP_PINCTRL_MUXSEL7_BANK3_PIN30      28
#define BM_PINCTRL_MUXSEL7_BANK3_PIN30      0x30000000

#define BF_PINCTRL_MUXSEL7_BANK3_PIN30(v)   (((v) << 28) & BM_PINCTRL_MUXSEL7_BANK3_PIN30)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL7_BANK3_PIN30(v)   BF_CS1(PINCTRL_MUXSEL7, BANK3_PIN30, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL7, field BANK3_PIN29 */

#define BP_PINCTRL_MUXSEL7_BANK3_PIN29      26
#define BM_PINCTRL_MUXSEL7_BANK3_PIN29      0x0C000000

#define BF_PINCTRL_MUXSEL7_BANK3_PIN29(v)   (((v) << 26) & BM_PINCTRL_MUXSEL7_BANK3_PIN29)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL7_BANK3_PIN29(v)   BF_CS1(PINCTRL_MUXSEL7, BANK3_PIN29, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL7, field BANK3_PIN28 */

#define BP_PINCTRL_MUXSEL7_BANK3_PIN28      24
#define BM_PINCTRL_MUXSEL7_BANK3_PIN28      0x03000000

#define BF_PINCTRL_MUXSEL7_BANK3_PIN28(v)   (((v) << 24) & BM_PINCTRL_MUXSEL7_BANK3_PIN28)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL7_BANK3_PIN28(v)   BF_CS1(PINCTRL_MUXSEL7, BANK3_PIN28, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL7, field BANK3_PIN27 */

#define BP_PINCTRL_MUXSEL7_BANK3_PIN27      22
#define BM_PINCTRL_MUXSEL7_BANK3_PIN27      0x00C00000

#define BF_PINCTRL_MUXSEL7_BANK3_PIN27(v)   (((v) << 22) & BM_PINCTRL_MUXSEL7_BANK3_PIN27)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL7_BANK3_PIN27(v)   BF_CS1(PINCTRL_MUXSEL7, BANK3_PIN27, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL7, field BANK3_PIN26 */

#define BP_PINCTRL_MUXSEL7_BANK3_PIN26      20
#define BM_PINCTRL_MUXSEL7_BANK3_PIN26      0x00300000

#define BF_PINCTRL_MUXSEL7_BANK3_PIN26(v)   (((v) << 20) & BM_PINCTRL_MUXSEL7_BANK3_PIN26)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL7_BANK3_PIN26(v)   BF_CS1(PINCTRL_MUXSEL7, BANK3_PIN26, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL7, field BANK3_PIN25 */

#define BP_PINCTRL_MUXSEL7_BANK3_PIN25      18
#define BM_PINCTRL_MUXSEL7_BANK3_PIN25      0x000C0000

#define BF_PINCTRL_MUXSEL7_BANK3_PIN25(v)   (((v) << 18) & BM_PINCTRL_MUXSEL7_BANK3_PIN25)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL7_BANK3_PIN25(v)   BF_CS1(PINCTRL_MUXSEL7, BANK3_PIN25, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL7, field BANK3_PIN24 */

#define BP_PINCTRL_MUXSEL7_BANK3_PIN24      16
#define BM_PINCTRL_MUXSEL7_BANK3_PIN24      0x00030000

#define BF_PINCTRL_MUXSEL7_BANK3_PIN24(v)   (((v) << 16) & BM_PINCTRL_MUXSEL7_BANK3_PIN24)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL7_BANK3_PIN24(v)   BF_CS1(PINCTRL_MUXSEL7, BANK3_PIN24, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL7, field BANK3_PIN23 */

#define BP_PINCTRL_MUXSEL7_BANK3_PIN23      14
#define BM_PINCTRL_MUXSEL7_BANK3_PIN23      0x0000C000

#define BF_PINCTRL_MUXSEL7_BANK3_PIN23(v)   (((v) << 14) & BM_PINCTRL_MUXSEL7_BANK3_PIN23)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL7_BANK3_PIN23(v)   BF_CS1(PINCTRL_MUXSEL7, BANK3_PIN23, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL7, field BANK3_PIN22 */

#define BP_PINCTRL_MUXSEL7_BANK3_PIN22      12
#define BM_PINCTRL_MUXSEL7_BANK3_PIN22      0x00003000

#define BF_PINCTRL_MUXSEL7_BANK3_PIN22(v)   (((v) << 12) & BM_PINCTRL_MUXSEL7_BANK3_PIN22)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL7_BANK3_PIN22(v)   BF_CS1(PINCTRL_MUXSEL7, BANK3_PIN22, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL7, field BANK3_PIN21 */

#define BP_PINCTRL_MUXSEL7_BANK3_PIN21      10
#define BM_PINCTRL_MUXSEL7_BANK3_PIN21      0x00000C00

#define BF_PINCTRL_MUXSEL7_BANK3_PIN21(v)   (((v) << 10) & BM_PINCTRL_MUXSEL7_BANK3_PIN21)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL7_BANK3_PIN21(v)   BF_CS1(PINCTRL_MUXSEL7, BANK3_PIN21, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL7, field BANK3_PIN20 */

#define BP_PINCTRL_MUXSEL7_BANK3_PIN20      8
#define BM_PINCTRL_MUXSEL7_BANK3_PIN20      0x00000300

#define BF_PINCTRL_MUXSEL7_BANK3_PIN20(v)   (((v) << 8) & BM_PINCTRL_MUXSEL7_BANK3_PIN20)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL7_BANK3_PIN20(v)   BF_CS1(PINCTRL_MUXSEL7, BANK3_PIN20, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL7, field RSRVD0 */

#define BP_PINCTRL_MUXSEL7_RSRVD0      6
#define BM_PINCTRL_MUXSEL7_RSRVD0      0x000000C0

#define BF_PINCTRL_MUXSEL7_RSRVD0(v)   (((v) << 6) & BM_PINCTRL_MUXSEL7_RSRVD0)
/* --- Register HW_PINCTRL_MUXSEL7, field BANK3_PIN18 */

#define BP_PINCTRL_MUXSEL7_BANK3_PIN18      4
#define BM_PINCTRL_MUXSEL7_BANK3_PIN18      0x00000030

#define BF_PINCTRL_MUXSEL7_BANK3_PIN18(v)   (((v) << 4) & BM_PINCTRL_MUXSEL7_BANK3_PIN18)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL7_BANK3_PIN18(v)   BF_CS1(PINCTRL_MUXSEL7, BANK3_PIN18, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL7, field BANK3_PIN17 */

#define BP_PINCTRL_MUXSEL7_BANK3_PIN17      2
#define BM_PINCTRL_MUXSEL7_BANK3_PIN17      0x0000000C

#define BF_PINCTRL_MUXSEL7_BANK3_PIN17(v)   (((v) << 2) & BM_PINCTRL_MUXSEL7_BANK3_PIN17)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL7_BANK3_PIN17(v)   BF_CS1(PINCTRL_MUXSEL7, BANK3_PIN17, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL7, field BANK3_PIN16 */

#define BP_PINCTRL_MUXSEL7_BANK3_PIN16      0
#define BM_PINCTRL_MUXSEL7_BANK3_PIN16      0x00000003

#define BF_PINCTRL_MUXSEL7_BANK3_PIN16(v)   (((v) << 0) & BM_PINCTRL_MUXSEL7_BANK3_PIN16)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL7_BANK3_PIN16(v)   BF_CS1(PINCTRL_MUXSEL7, BANK3_PIN16, v)
#endif



/*
 * HW_PINCTRL_MUXSEL8 - PINCTRL Pin Mux Select Register 8
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK4_PIN00  :  2;
        unsigned BANK4_PIN01  :  2;
        unsigned BANK4_PIN02  :  2;
        unsigned BANK4_PIN03  :  2;
        unsigned BANK4_PIN04  :  2;
        unsigned BANK4_PIN05  :  2;
        unsigned BANK4_PIN06  :  2;
        unsigned BANK4_PIN07  :  2;
        unsigned BANK4_PIN08  :  2;
        unsigned BANK4_PIN09  :  2;
        unsigned BANK4_PIN10  :  2;
        unsigned BANK4_PIN11  :  2;
        unsigned BANK4_PIN12  :  2;
        unsigned BANK4_PIN13  :  2;
        unsigned BANK4_PIN14  :  2;
        unsigned BANK4_PIN15  :  2;
    } B;
} hw_pinctrl_muxsel8_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_MUXSEL8 register
 */
#define HW_PINCTRL_MUXSEL8_ADDR         (REGS_PINCTRL_BASE + 0x180)
#define HW_PINCTRL_MUXSEL8_SET_ADDR     (HW_PINCTRL_MUXSEL8_ADDR + 4)
#define HW_PINCTRL_MUXSEL8_CLR_ADDR     (HW_PINCTRL_MUXSEL8_ADDR + 8)
#define HW_PINCTRL_MUXSEL8_TOG_ADDR     (HW_PINCTRL_MUXSEL8_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_MUXSEL8           (*(volatile hw_pinctrl_muxsel8_t *) HW_PINCTRL_MUXSEL8_ADDR)
#define HW_PINCTRL_MUXSEL8_RD()      (HW_PINCTRL_MUXSEL8.U)
#define HW_PINCTRL_MUXSEL8_WR(v)     (HW_PINCTRL_MUXSEL8.U = (v))
#define HW_PINCTRL_MUXSEL8_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL8_SET_ADDR) = (v))
#define HW_PINCTRL_MUXSEL8_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL8_CLR_ADDR) = (v))
#define HW_PINCTRL_MUXSEL8_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL8_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_MUXSEL8 bitfields
 */
/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN15 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN15      30
#define BM_PINCTRL_MUXSEL8_BANK4_PIN15      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_MUXSEL8_BANK4_PIN15(v)   ((((reg32_t) v) << 30) & BM_PINCTRL_MUXSEL8_BANK4_PIN15)
#else
#define BF_PINCTRL_MUXSEL8_BANK4_PIN15(v)   (((v) << 30) & BM_PINCTRL_MUXSEL8_BANK4_PIN15)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN15(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN15, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN14 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN14      28
#define BM_PINCTRL_MUXSEL8_BANK4_PIN14      0x30000000

#define BF_PINCTRL_MUXSEL8_BANK4_PIN14(v)   (((v) << 28) & BM_PINCTRL_MUXSEL8_BANK4_PIN14)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN14(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN14, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN13 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN13      26
#define BM_PINCTRL_MUXSEL8_BANK4_PIN13      0x0C000000

#define BF_PINCTRL_MUXSEL8_BANK4_PIN13(v)   (((v) << 26) & BM_PINCTRL_MUXSEL8_BANK4_PIN13)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN13(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN13, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN12 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN12      24
#define BM_PINCTRL_MUXSEL8_BANK4_PIN12      0x03000000

#define BF_PINCTRL_MUXSEL8_BANK4_PIN12(v)   (((v) << 24) & BM_PINCTRL_MUXSEL8_BANK4_PIN12)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN12(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN12, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN11 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN11      22
#define BM_PINCTRL_MUXSEL8_BANK4_PIN11      0x00C00000

#define BF_PINCTRL_MUXSEL8_BANK4_PIN11(v)   (((v) << 22) & BM_PINCTRL_MUXSEL8_BANK4_PIN11)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN11(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN11, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN10 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN10      20
#define BM_PINCTRL_MUXSEL8_BANK4_PIN10      0x00300000

#define BF_PINCTRL_MUXSEL8_BANK4_PIN10(v)   (((v) << 20) & BM_PINCTRL_MUXSEL8_BANK4_PIN10)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN10(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN10, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN09 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN09      18
#define BM_PINCTRL_MUXSEL8_BANK4_PIN09      0x000C0000

#define BF_PINCTRL_MUXSEL8_BANK4_PIN09(v)   (((v) << 18) & BM_PINCTRL_MUXSEL8_BANK4_PIN09)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN09(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN09, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN08 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN08      16
#define BM_PINCTRL_MUXSEL8_BANK4_PIN08      0x00030000

#define BF_PINCTRL_MUXSEL8_BANK4_PIN08(v)   (((v) << 16) & BM_PINCTRL_MUXSEL8_BANK4_PIN08)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN08(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN08, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN07 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN07      14
#define BM_PINCTRL_MUXSEL8_BANK4_PIN07      0x0000C000

#define BF_PINCTRL_MUXSEL8_BANK4_PIN07(v)   (((v) << 14) & BM_PINCTRL_MUXSEL8_BANK4_PIN07)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN07(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN07, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN06 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN06      12
#define BM_PINCTRL_MUXSEL8_BANK4_PIN06      0x00003000

#define BF_PINCTRL_MUXSEL8_BANK4_PIN06(v)   (((v) << 12) & BM_PINCTRL_MUXSEL8_BANK4_PIN06)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN06(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN06, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN05 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN05      10
#define BM_PINCTRL_MUXSEL8_BANK4_PIN05      0x00000C00

#define BF_PINCTRL_MUXSEL8_BANK4_PIN05(v)   (((v) << 10) & BM_PINCTRL_MUXSEL8_BANK4_PIN05)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN05(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN05, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN04 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN04      8
#define BM_PINCTRL_MUXSEL8_BANK4_PIN04      0x00000300

#define BF_PINCTRL_MUXSEL8_BANK4_PIN04(v)   (((v) << 8) & BM_PINCTRL_MUXSEL8_BANK4_PIN04)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN04(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN04, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN03 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN03      6
#define BM_PINCTRL_MUXSEL8_BANK4_PIN03      0x000000C0

#define BF_PINCTRL_MUXSEL8_BANK4_PIN03(v)   (((v) << 6) & BM_PINCTRL_MUXSEL8_BANK4_PIN03)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN03(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN03, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN02 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN02      4
#define BM_PINCTRL_MUXSEL8_BANK4_PIN02      0x00000030

#define BF_PINCTRL_MUXSEL8_BANK4_PIN02(v)   (((v) << 4) & BM_PINCTRL_MUXSEL8_BANK4_PIN02)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN02(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN02, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN01 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN01      2
#define BM_PINCTRL_MUXSEL8_BANK4_PIN01      0x0000000C

#define BF_PINCTRL_MUXSEL8_BANK4_PIN01(v)   (((v) << 2) & BM_PINCTRL_MUXSEL8_BANK4_PIN01)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN01(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN01, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL8, field BANK4_PIN00 */

#define BP_PINCTRL_MUXSEL8_BANK4_PIN00      0
#define BM_PINCTRL_MUXSEL8_BANK4_PIN00      0x00000003

#define BF_PINCTRL_MUXSEL8_BANK4_PIN00(v)   (((v) << 0) & BM_PINCTRL_MUXSEL8_BANK4_PIN00)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL8_BANK4_PIN00(v)   BF_CS1(PINCTRL_MUXSEL8, BANK4_PIN00, v)
#endif



/*
 * HW_PINCTRL_MUXSEL9 - PINCTRL Pin Mux Select Register 9
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK4_PIN16  :  2;
        unsigned RSRVD0       :  6;
        unsigned BANK4_PIN20  :  2;
        unsigned RSRVD1       : 22;
    } B;
} hw_pinctrl_muxsel9_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_MUXSEL9 register
 */
#define HW_PINCTRL_MUXSEL9_ADDR         (REGS_PINCTRL_BASE + 0x190)
#define HW_PINCTRL_MUXSEL9_SET_ADDR     (HW_PINCTRL_MUXSEL9_ADDR + 4)
#define HW_PINCTRL_MUXSEL9_CLR_ADDR     (HW_PINCTRL_MUXSEL9_ADDR + 8)
#define HW_PINCTRL_MUXSEL9_TOG_ADDR     (HW_PINCTRL_MUXSEL9_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_MUXSEL9           (*(volatile hw_pinctrl_muxsel9_t *) HW_PINCTRL_MUXSEL9_ADDR)
#define HW_PINCTRL_MUXSEL9_RD()      (HW_PINCTRL_MUXSEL9.U)
#define HW_PINCTRL_MUXSEL9_WR(v)     (HW_PINCTRL_MUXSEL9.U = (v))
#define HW_PINCTRL_MUXSEL9_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL9_SET_ADDR) = (v))
#define HW_PINCTRL_MUXSEL9_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL9_CLR_ADDR) = (v))
#define HW_PINCTRL_MUXSEL9_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL9_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_MUXSEL9 bitfields
 */
/* --- Register HW_PINCTRL_MUXSEL9, field RSRVD1 */

#define BP_PINCTRL_MUXSEL9_RSRVD1      10
#define BM_PINCTRL_MUXSEL9_RSRVD1      0xFFFFFC00

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_MUXSEL9_RSRVD1(v)   ((((reg32_t) v) << 10) & BM_PINCTRL_MUXSEL9_RSRVD1)
#else
#define BF_PINCTRL_MUXSEL9_RSRVD1(v)   (((v) << 10) & BM_PINCTRL_MUXSEL9_RSRVD1)
#endif
/* --- Register HW_PINCTRL_MUXSEL9, field BANK4_PIN20 */

#define BP_PINCTRL_MUXSEL9_BANK4_PIN20      8
#define BM_PINCTRL_MUXSEL9_BANK4_PIN20      0x00000300

#define BF_PINCTRL_MUXSEL9_BANK4_PIN20(v)   (((v) << 8) & BM_PINCTRL_MUXSEL9_BANK4_PIN20)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL9_BANK4_PIN20(v)   BF_CS1(PINCTRL_MUXSEL9, BANK4_PIN20, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL9, field RSRVD0 */

#define BP_PINCTRL_MUXSEL9_RSRVD0      2
#define BM_PINCTRL_MUXSEL9_RSRVD0      0x000000FC

#define BF_PINCTRL_MUXSEL9_RSRVD0(v)   (((v) << 2) & BM_PINCTRL_MUXSEL9_RSRVD0)
/* --- Register HW_PINCTRL_MUXSEL9, field BANK4_PIN16 */

#define BP_PINCTRL_MUXSEL9_BANK4_PIN16      0
#define BM_PINCTRL_MUXSEL9_BANK4_PIN16      0x00000003

#define BF_PINCTRL_MUXSEL9_BANK4_PIN16(v)   (((v) << 0) & BM_PINCTRL_MUXSEL9_BANK4_PIN16)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL9_BANK4_PIN16(v)   BF_CS1(PINCTRL_MUXSEL9, BANK4_PIN16, v)
#endif



/*
 * HW_PINCTRL_MUXSEL10 - PINCTRL Pin Mux Select Register 10
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK5_PIN00  :  2;
        unsigned BANK5_PIN01  :  2;
        unsigned BANK5_PIN02  :  2;
        unsigned BANK5_PIN03  :  2;
        unsigned BANK5_PIN04  :  2;
        unsigned BANK5_PIN05  :  2;
        unsigned BANK5_PIN06  :  2;
        unsigned BANK5_PIN07  :  2;
        unsigned BANK5_PIN08  :  2;
        unsigned BANK5_PIN09  :  2;
        unsigned BANK5_PIN10  :  2;
        unsigned BANK5_PIN11  :  2;
        unsigned BANK5_PIN12  :  2;
        unsigned BANK5_PIN13  :  2;
        unsigned BANK5_PIN14  :  2;
        unsigned BANK5_PIN15  :  2;
    } B;
} hw_pinctrl_muxsel10_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_MUXSEL10 register
 */
#define HW_PINCTRL_MUXSEL10_ADDR         (REGS_PINCTRL_BASE + 0x1a0)
#define HW_PINCTRL_MUXSEL10_SET_ADDR     (HW_PINCTRL_MUXSEL10_ADDR + 4)
#define HW_PINCTRL_MUXSEL10_CLR_ADDR     (HW_PINCTRL_MUXSEL10_ADDR + 8)
#define HW_PINCTRL_MUXSEL10_TOG_ADDR     (HW_PINCTRL_MUXSEL10_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_MUXSEL10           (*(volatile hw_pinctrl_muxsel10_t *) HW_PINCTRL_MUXSEL10_ADDR)
#define HW_PINCTRL_MUXSEL10_RD()      (HW_PINCTRL_MUXSEL10.U)
#define HW_PINCTRL_MUXSEL10_WR(v)     (HW_PINCTRL_MUXSEL10.U = (v))
#define HW_PINCTRL_MUXSEL10_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL10_SET_ADDR) = (v))
#define HW_PINCTRL_MUXSEL10_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL10_CLR_ADDR) = (v))
#define HW_PINCTRL_MUXSEL10_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL10_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_MUXSEL10 bitfields
 */
/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN15 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN15      30
#define BM_PINCTRL_MUXSEL10_BANK5_PIN15      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_MUXSEL10_BANK5_PIN15(v)   ((((reg32_t) v) << 30) & BM_PINCTRL_MUXSEL10_BANK5_PIN15)
#else
#define BF_PINCTRL_MUXSEL10_BANK5_PIN15(v)   (((v) << 30) & BM_PINCTRL_MUXSEL10_BANK5_PIN15)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN15(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN15, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN14 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN14      28
#define BM_PINCTRL_MUXSEL10_BANK5_PIN14      0x30000000

#define BF_PINCTRL_MUXSEL10_BANK5_PIN14(v)   (((v) << 28) & BM_PINCTRL_MUXSEL10_BANK5_PIN14)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN14(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN14, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN13 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN13      26
#define BM_PINCTRL_MUXSEL10_BANK5_PIN13      0x0C000000

#define BF_PINCTRL_MUXSEL10_BANK5_PIN13(v)   (((v) << 26) & BM_PINCTRL_MUXSEL10_BANK5_PIN13)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN13(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN13, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN12 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN12      24
#define BM_PINCTRL_MUXSEL10_BANK5_PIN12      0x03000000

#define BF_PINCTRL_MUXSEL10_BANK5_PIN12(v)   (((v) << 24) & BM_PINCTRL_MUXSEL10_BANK5_PIN12)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN12(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN12, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN11 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN11      22
#define BM_PINCTRL_MUXSEL10_BANK5_PIN11      0x00C00000

#define BF_PINCTRL_MUXSEL10_BANK5_PIN11(v)   (((v) << 22) & BM_PINCTRL_MUXSEL10_BANK5_PIN11)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN11(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN11, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN10 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN10      20
#define BM_PINCTRL_MUXSEL10_BANK5_PIN10      0x00300000

#define BF_PINCTRL_MUXSEL10_BANK5_PIN10(v)   (((v) << 20) & BM_PINCTRL_MUXSEL10_BANK5_PIN10)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN10(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN10, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN09 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN09      18
#define BM_PINCTRL_MUXSEL10_BANK5_PIN09      0x000C0000

#define BF_PINCTRL_MUXSEL10_BANK5_PIN09(v)   (((v) << 18) & BM_PINCTRL_MUXSEL10_BANK5_PIN09)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN09(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN09, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN08 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN08      16
#define BM_PINCTRL_MUXSEL10_BANK5_PIN08      0x00030000

#define BF_PINCTRL_MUXSEL10_BANK5_PIN08(v)   (((v) << 16) & BM_PINCTRL_MUXSEL10_BANK5_PIN08)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN08(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN08, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN07 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN07      14
#define BM_PINCTRL_MUXSEL10_BANK5_PIN07      0x0000C000

#define BF_PINCTRL_MUXSEL10_BANK5_PIN07(v)   (((v) << 14) & BM_PINCTRL_MUXSEL10_BANK5_PIN07)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN07(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN07, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN06 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN06      12
#define BM_PINCTRL_MUXSEL10_BANK5_PIN06      0x00003000

#define BF_PINCTRL_MUXSEL10_BANK5_PIN06(v)   (((v) << 12) & BM_PINCTRL_MUXSEL10_BANK5_PIN06)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN06(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN06, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN05 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN05      10
#define BM_PINCTRL_MUXSEL10_BANK5_PIN05      0x00000C00

#define BF_PINCTRL_MUXSEL10_BANK5_PIN05(v)   (((v) << 10) & BM_PINCTRL_MUXSEL10_BANK5_PIN05)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN05(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN05, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN04 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN04      8
#define BM_PINCTRL_MUXSEL10_BANK5_PIN04      0x00000300

#define BF_PINCTRL_MUXSEL10_BANK5_PIN04(v)   (((v) << 8) & BM_PINCTRL_MUXSEL10_BANK5_PIN04)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN04(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN04, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN03 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN03      6
#define BM_PINCTRL_MUXSEL10_BANK5_PIN03      0x000000C0

#define BF_PINCTRL_MUXSEL10_BANK5_PIN03(v)   (((v) << 6) & BM_PINCTRL_MUXSEL10_BANK5_PIN03)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN03(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN03, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN02 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN02      4
#define BM_PINCTRL_MUXSEL10_BANK5_PIN02      0x00000030

#define BF_PINCTRL_MUXSEL10_BANK5_PIN02(v)   (((v) << 4) & BM_PINCTRL_MUXSEL10_BANK5_PIN02)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN02(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN02, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN01 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN01      2
#define BM_PINCTRL_MUXSEL10_BANK5_PIN01      0x0000000C

#define BF_PINCTRL_MUXSEL10_BANK5_PIN01(v)   (((v) << 2) & BM_PINCTRL_MUXSEL10_BANK5_PIN01)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN01(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN01, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL10, field BANK5_PIN00 */

#define BP_PINCTRL_MUXSEL10_BANK5_PIN00      0
#define BM_PINCTRL_MUXSEL10_BANK5_PIN00      0x00000003

#define BF_PINCTRL_MUXSEL10_BANK5_PIN00(v)   (((v) << 0) & BM_PINCTRL_MUXSEL10_BANK5_PIN00)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL10_BANK5_PIN00(v)   BF_CS1(PINCTRL_MUXSEL10, BANK5_PIN00, v)
#endif



/*
 * HW_PINCTRL_MUXSEL11 - PINCTRL Pin Mux Select Register 11
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK5_PIN16  :  2;
        unsigned BANK5_PIN17  :  2;
        unsigned BANK5_PIN18  :  2;
        unsigned BANK5_PIN19  :  2;
        unsigned BANK5_PIN20  :  2;
        unsigned BANK5_PIN21  :  2;
        unsigned BANK5_PIN22  :  2;
        unsigned BANK5_PIN23  :  2;
        unsigned RSRVD0       :  4;
        unsigned BANK5_PIN26  :  2;
        unsigned RSRVD1       : 10;
    } B;
} hw_pinctrl_muxsel11_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_MUXSEL11 register
 */
#define HW_PINCTRL_MUXSEL11_ADDR         (REGS_PINCTRL_BASE + 0x1b0)
#define HW_PINCTRL_MUXSEL11_SET_ADDR     (HW_PINCTRL_MUXSEL11_ADDR + 4)
#define HW_PINCTRL_MUXSEL11_CLR_ADDR     (HW_PINCTRL_MUXSEL11_ADDR + 8)
#define HW_PINCTRL_MUXSEL11_TOG_ADDR     (HW_PINCTRL_MUXSEL11_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_MUXSEL11           (*(volatile hw_pinctrl_muxsel11_t *) HW_PINCTRL_MUXSEL11_ADDR)
#define HW_PINCTRL_MUXSEL11_RD()      (HW_PINCTRL_MUXSEL11.U)
#define HW_PINCTRL_MUXSEL11_WR(v)     (HW_PINCTRL_MUXSEL11.U = (v))
#define HW_PINCTRL_MUXSEL11_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL11_SET_ADDR) = (v))
#define HW_PINCTRL_MUXSEL11_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL11_CLR_ADDR) = (v))
#define HW_PINCTRL_MUXSEL11_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL11_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_MUXSEL11 bitfields
 */
/* --- Register HW_PINCTRL_MUXSEL11, field RSRVD1 */

#define BP_PINCTRL_MUXSEL11_RSRVD1      22
#define BM_PINCTRL_MUXSEL11_RSRVD1      0xFFC00000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_MUXSEL11_RSRVD1(v)   ((((reg32_t) v) << 22) & BM_PINCTRL_MUXSEL11_RSRVD1)
#else
#define BF_PINCTRL_MUXSEL11_RSRVD1(v)   (((v) << 22) & BM_PINCTRL_MUXSEL11_RSRVD1)
#endif
/* --- Register HW_PINCTRL_MUXSEL11, field BANK5_PIN26 */

#define BP_PINCTRL_MUXSEL11_BANK5_PIN26      20
#define BM_PINCTRL_MUXSEL11_BANK5_PIN26      0x00300000

#define BF_PINCTRL_MUXSEL11_BANK5_PIN26(v)   (((v) << 20) & BM_PINCTRL_MUXSEL11_BANK5_PIN26)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL11_BANK5_PIN26(v)   BF_CS1(PINCTRL_MUXSEL11, BANK5_PIN26, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL11, field RSRVD0 */

#define BP_PINCTRL_MUXSEL11_RSRVD0      16
#define BM_PINCTRL_MUXSEL11_RSRVD0      0x000F0000

#define BF_PINCTRL_MUXSEL11_RSRVD0(v)   (((v) << 16) & BM_PINCTRL_MUXSEL11_RSRVD0)
/* --- Register HW_PINCTRL_MUXSEL11, field BANK5_PIN23 */

#define BP_PINCTRL_MUXSEL11_BANK5_PIN23      14
#define BM_PINCTRL_MUXSEL11_BANK5_PIN23      0x0000C000

#define BF_PINCTRL_MUXSEL11_BANK5_PIN23(v)   (((v) << 14) & BM_PINCTRL_MUXSEL11_BANK5_PIN23)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL11_BANK5_PIN23(v)   BF_CS1(PINCTRL_MUXSEL11, BANK5_PIN23, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL11, field BANK5_PIN22 */

#define BP_PINCTRL_MUXSEL11_BANK5_PIN22      12
#define BM_PINCTRL_MUXSEL11_BANK5_PIN22      0x00003000

#define BF_PINCTRL_MUXSEL11_BANK5_PIN22(v)   (((v) << 12) & BM_PINCTRL_MUXSEL11_BANK5_PIN22)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL11_BANK5_PIN22(v)   BF_CS1(PINCTRL_MUXSEL11, BANK5_PIN22, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL11, field BANK5_PIN21 */

#define BP_PINCTRL_MUXSEL11_BANK5_PIN21      10
#define BM_PINCTRL_MUXSEL11_BANK5_PIN21      0x00000C00

#define BF_PINCTRL_MUXSEL11_BANK5_PIN21(v)   (((v) << 10) & BM_PINCTRL_MUXSEL11_BANK5_PIN21)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL11_BANK5_PIN21(v)   BF_CS1(PINCTRL_MUXSEL11, BANK5_PIN21, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL11, field BANK5_PIN20 */

#define BP_PINCTRL_MUXSEL11_BANK5_PIN20      8
#define BM_PINCTRL_MUXSEL11_BANK5_PIN20      0x00000300

#define BF_PINCTRL_MUXSEL11_BANK5_PIN20(v)   (((v) << 8) & BM_PINCTRL_MUXSEL11_BANK5_PIN20)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL11_BANK5_PIN20(v)   BF_CS1(PINCTRL_MUXSEL11, BANK5_PIN20, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL11, field BANK5_PIN19 */

#define BP_PINCTRL_MUXSEL11_BANK5_PIN19      6
#define BM_PINCTRL_MUXSEL11_BANK5_PIN19      0x000000C0

#define BF_PINCTRL_MUXSEL11_BANK5_PIN19(v)   (((v) << 6) & BM_PINCTRL_MUXSEL11_BANK5_PIN19)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL11_BANK5_PIN19(v)   BF_CS1(PINCTRL_MUXSEL11, BANK5_PIN19, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL11, field BANK5_PIN18 */

#define BP_PINCTRL_MUXSEL11_BANK5_PIN18      4
#define BM_PINCTRL_MUXSEL11_BANK5_PIN18      0x00000030

#define BF_PINCTRL_MUXSEL11_BANK5_PIN18(v)   (((v) << 4) & BM_PINCTRL_MUXSEL11_BANK5_PIN18)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL11_BANK5_PIN18(v)   BF_CS1(PINCTRL_MUXSEL11, BANK5_PIN18, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL11, field BANK5_PIN17 */

#define BP_PINCTRL_MUXSEL11_BANK5_PIN17      2
#define BM_PINCTRL_MUXSEL11_BANK5_PIN17      0x0000000C

#define BF_PINCTRL_MUXSEL11_BANK5_PIN17(v)   (((v) << 2) & BM_PINCTRL_MUXSEL11_BANK5_PIN17)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL11_BANK5_PIN17(v)   BF_CS1(PINCTRL_MUXSEL11, BANK5_PIN17, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL11, field BANK5_PIN16 */

#define BP_PINCTRL_MUXSEL11_BANK5_PIN16      0
#define BM_PINCTRL_MUXSEL11_BANK5_PIN16      0x00000003

#define BF_PINCTRL_MUXSEL11_BANK5_PIN16(v)   (((v) << 0) & BM_PINCTRL_MUXSEL11_BANK5_PIN16)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL11_BANK5_PIN16(v)   BF_CS1(PINCTRL_MUXSEL11, BANK5_PIN16, v)
#endif



/*
 * HW_PINCTRL_MUXSEL12 - PINCTRL Pin Mux Select Register 12
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK6_PIN00  :  2;
        unsigned BANK6_PIN01  :  2;
        unsigned BANK6_PIN02  :  2;
        unsigned BANK6_PIN03  :  2;
        unsigned BANK6_PIN04  :  2;
        unsigned BANK6_PIN05  :  2;
        unsigned BANK6_PIN06  :  2;
        unsigned BANK6_PIN07  :  2;
        unsigned BANK6_PIN08  :  2;
        unsigned BANK6_PIN09  :  2;
        unsigned BANK6_PIN10  :  2;
        unsigned BANK6_PIN11  :  2;
        unsigned BANK6_PIN12  :  2;
        unsigned BANK6_PIN13  :  2;
        unsigned BANK6_PIN14  :  2;
        unsigned RSRVD0       :  2;
    } B;
} hw_pinctrl_muxsel12_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_MUXSEL12 register
 */
#define HW_PINCTRL_MUXSEL12_ADDR         (REGS_PINCTRL_BASE + 0x1c0)
#define HW_PINCTRL_MUXSEL12_SET_ADDR     (HW_PINCTRL_MUXSEL12_ADDR + 4)
#define HW_PINCTRL_MUXSEL12_CLR_ADDR     (HW_PINCTRL_MUXSEL12_ADDR + 8)
#define HW_PINCTRL_MUXSEL12_TOG_ADDR     (HW_PINCTRL_MUXSEL12_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_MUXSEL12           (*(volatile hw_pinctrl_muxsel12_t *) HW_PINCTRL_MUXSEL12_ADDR)
#define HW_PINCTRL_MUXSEL12_RD()      (HW_PINCTRL_MUXSEL12.U)
#define HW_PINCTRL_MUXSEL12_WR(v)     (HW_PINCTRL_MUXSEL12.U = (v))
#define HW_PINCTRL_MUXSEL12_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL12_SET_ADDR) = (v))
#define HW_PINCTRL_MUXSEL12_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL12_CLR_ADDR) = (v))
#define HW_PINCTRL_MUXSEL12_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL12_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_MUXSEL12 bitfields
 */
/* --- Register HW_PINCTRL_MUXSEL12, field RSRVD0 */

#define BP_PINCTRL_MUXSEL12_RSRVD0      30
#define BM_PINCTRL_MUXSEL12_RSRVD0      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_MUXSEL12_RSRVD0(v)   ((((reg32_t) v) << 30) & BM_PINCTRL_MUXSEL12_RSRVD0)
#else
#define BF_PINCTRL_MUXSEL12_RSRVD0(v)   (((v) << 30) & BM_PINCTRL_MUXSEL12_RSRVD0)
#endif
/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN14 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN14      28
#define BM_PINCTRL_MUXSEL12_BANK6_PIN14      0x30000000

#define BF_PINCTRL_MUXSEL12_BANK6_PIN14(v)   (((v) << 28) & BM_PINCTRL_MUXSEL12_BANK6_PIN14)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN14(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN14, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN13 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN13      26
#define BM_PINCTRL_MUXSEL12_BANK6_PIN13      0x0C000000

#define BF_PINCTRL_MUXSEL12_BANK6_PIN13(v)   (((v) << 26) & BM_PINCTRL_MUXSEL12_BANK6_PIN13)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN13(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN13, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN12 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN12      24
#define BM_PINCTRL_MUXSEL12_BANK6_PIN12      0x03000000

#define BF_PINCTRL_MUXSEL12_BANK6_PIN12(v)   (((v) << 24) & BM_PINCTRL_MUXSEL12_BANK6_PIN12)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN12(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN12, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN11 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN11      22
#define BM_PINCTRL_MUXSEL12_BANK6_PIN11      0x00C00000

#define BF_PINCTRL_MUXSEL12_BANK6_PIN11(v)   (((v) << 22) & BM_PINCTRL_MUXSEL12_BANK6_PIN11)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN11(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN11, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN10 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN10      20
#define BM_PINCTRL_MUXSEL12_BANK6_PIN10      0x00300000

#define BF_PINCTRL_MUXSEL12_BANK6_PIN10(v)   (((v) << 20) & BM_PINCTRL_MUXSEL12_BANK6_PIN10)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN10(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN10, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN09 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN09      18
#define BM_PINCTRL_MUXSEL12_BANK6_PIN09      0x000C0000

#define BF_PINCTRL_MUXSEL12_BANK6_PIN09(v)   (((v) << 18) & BM_PINCTRL_MUXSEL12_BANK6_PIN09)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN09(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN09, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN08 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN08      16
#define BM_PINCTRL_MUXSEL12_BANK6_PIN08      0x00030000

#define BF_PINCTRL_MUXSEL12_BANK6_PIN08(v)   (((v) << 16) & BM_PINCTRL_MUXSEL12_BANK6_PIN08)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN08(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN08, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN07 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN07      14
#define BM_PINCTRL_MUXSEL12_BANK6_PIN07      0x0000C000

#define BF_PINCTRL_MUXSEL12_BANK6_PIN07(v)   (((v) << 14) & BM_PINCTRL_MUXSEL12_BANK6_PIN07)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN07(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN07, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN06 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN06      12
#define BM_PINCTRL_MUXSEL12_BANK6_PIN06      0x00003000

#define BF_PINCTRL_MUXSEL12_BANK6_PIN06(v)   (((v) << 12) & BM_PINCTRL_MUXSEL12_BANK6_PIN06)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN06(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN06, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN05 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN05      10
#define BM_PINCTRL_MUXSEL12_BANK6_PIN05      0x00000C00

#define BF_PINCTRL_MUXSEL12_BANK6_PIN05(v)   (((v) << 10) & BM_PINCTRL_MUXSEL12_BANK6_PIN05)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN05(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN05, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN04 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN04      8
#define BM_PINCTRL_MUXSEL12_BANK6_PIN04      0x00000300

#define BF_PINCTRL_MUXSEL12_BANK6_PIN04(v)   (((v) << 8) & BM_PINCTRL_MUXSEL12_BANK6_PIN04)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN04(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN04, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN03 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN03      6
#define BM_PINCTRL_MUXSEL12_BANK6_PIN03      0x000000C0

#define BF_PINCTRL_MUXSEL12_BANK6_PIN03(v)   (((v) << 6) & BM_PINCTRL_MUXSEL12_BANK6_PIN03)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN03(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN03, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN02 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN02      4
#define BM_PINCTRL_MUXSEL12_BANK6_PIN02      0x00000030

#define BF_PINCTRL_MUXSEL12_BANK6_PIN02(v)   (((v) << 4) & BM_PINCTRL_MUXSEL12_BANK6_PIN02)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN02(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN02, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN01 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN01      2
#define BM_PINCTRL_MUXSEL12_BANK6_PIN01      0x0000000C

#define BF_PINCTRL_MUXSEL12_BANK6_PIN01(v)   (((v) << 2) & BM_PINCTRL_MUXSEL12_BANK6_PIN01)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN01(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN01, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL12, field BANK6_PIN00 */

#define BP_PINCTRL_MUXSEL12_BANK6_PIN00      0
#define BM_PINCTRL_MUXSEL12_BANK6_PIN00      0x00000003

#define BF_PINCTRL_MUXSEL12_BANK6_PIN00(v)   (((v) << 0) & BM_PINCTRL_MUXSEL12_BANK6_PIN00)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL12_BANK6_PIN00(v)   BF_CS1(PINCTRL_MUXSEL12, BANK6_PIN00, v)
#endif



/*
 * HW_PINCTRL_MUXSEL13 - PINCTRL Pin Mux Select Register 13
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK6_PIN16  :  2;
        unsigned BANK6_PIN17  :  2;
        unsigned BANK6_PIN18  :  2;
        unsigned BANK6_PIN19  :  2;
        unsigned BANK6_PIN20  :  2;
        unsigned BANK6_PIN21  :  2;
        unsigned BANK6_PIN22  :  2;
        unsigned BANK6_PIN23  :  2;
        unsigned BANK6_PIN24  :  2;
        unsigned RSRVD0       : 14;
    } B;
} hw_pinctrl_muxsel13_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_MUXSEL13 register
 */
#define HW_PINCTRL_MUXSEL13_ADDR         (REGS_PINCTRL_BASE + 0x1d0)
#define HW_PINCTRL_MUXSEL13_SET_ADDR     (HW_PINCTRL_MUXSEL13_ADDR + 4)
#define HW_PINCTRL_MUXSEL13_CLR_ADDR     (HW_PINCTRL_MUXSEL13_ADDR + 8)
#define HW_PINCTRL_MUXSEL13_TOG_ADDR     (HW_PINCTRL_MUXSEL13_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_MUXSEL13           (*(volatile hw_pinctrl_muxsel13_t *) HW_PINCTRL_MUXSEL13_ADDR)
#define HW_PINCTRL_MUXSEL13_RD()      (HW_PINCTRL_MUXSEL13.U)
#define HW_PINCTRL_MUXSEL13_WR(v)     (HW_PINCTRL_MUXSEL13.U = (v))
#define HW_PINCTRL_MUXSEL13_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL13_SET_ADDR) = (v))
#define HW_PINCTRL_MUXSEL13_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL13_CLR_ADDR) = (v))
#define HW_PINCTRL_MUXSEL13_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_MUXSEL13_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_MUXSEL13 bitfields
 */
/* --- Register HW_PINCTRL_MUXSEL13, field RSRVD0 */

#define BP_PINCTRL_MUXSEL13_RSRVD0      18
#define BM_PINCTRL_MUXSEL13_RSRVD0      0xFFFC0000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_MUXSEL13_RSRVD0(v)   ((((reg32_t) v) << 18) & BM_PINCTRL_MUXSEL13_RSRVD0)
#else
#define BF_PINCTRL_MUXSEL13_RSRVD0(v)   (((v) << 18) & BM_PINCTRL_MUXSEL13_RSRVD0)
#endif
/* --- Register HW_PINCTRL_MUXSEL13, field BANK6_PIN24 */

#define BP_PINCTRL_MUXSEL13_BANK6_PIN24      16
#define BM_PINCTRL_MUXSEL13_BANK6_PIN24      0x00030000

#define BF_PINCTRL_MUXSEL13_BANK6_PIN24(v)   (((v) << 16) & BM_PINCTRL_MUXSEL13_BANK6_PIN24)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL13_BANK6_PIN24(v)   BF_CS1(PINCTRL_MUXSEL13, BANK6_PIN24, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL13, field BANK6_PIN23 */

#define BP_PINCTRL_MUXSEL13_BANK6_PIN23      14
#define BM_PINCTRL_MUXSEL13_BANK6_PIN23      0x0000C000

#define BF_PINCTRL_MUXSEL13_BANK6_PIN23(v)   (((v) << 14) & BM_PINCTRL_MUXSEL13_BANK6_PIN23)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL13_BANK6_PIN23(v)   BF_CS1(PINCTRL_MUXSEL13, BANK6_PIN23, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL13, field BANK6_PIN22 */

#define BP_PINCTRL_MUXSEL13_BANK6_PIN22      12
#define BM_PINCTRL_MUXSEL13_BANK6_PIN22      0x00003000

#define BF_PINCTRL_MUXSEL13_BANK6_PIN22(v)   (((v) << 12) & BM_PINCTRL_MUXSEL13_BANK6_PIN22)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL13_BANK6_PIN22(v)   BF_CS1(PINCTRL_MUXSEL13, BANK6_PIN22, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL13, field BANK6_PIN21 */

#define BP_PINCTRL_MUXSEL13_BANK6_PIN21      10
#define BM_PINCTRL_MUXSEL13_BANK6_PIN21      0x00000C00

#define BF_PINCTRL_MUXSEL13_BANK6_PIN21(v)   (((v) << 10) & BM_PINCTRL_MUXSEL13_BANK6_PIN21)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL13_BANK6_PIN21(v)   BF_CS1(PINCTRL_MUXSEL13, BANK6_PIN21, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL13, field BANK6_PIN20 */

#define BP_PINCTRL_MUXSEL13_BANK6_PIN20      8
#define BM_PINCTRL_MUXSEL13_BANK6_PIN20      0x00000300

#define BF_PINCTRL_MUXSEL13_BANK6_PIN20(v)   (((v) << 8) & BM_PINCTRL_MUXSEL13_BANK6_PIN20)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL13_BANK6_PIN20(v)   BF_CS1(PINCTRL_MUXSEL13, BANK6_PIN20, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL13, field BANK6_PIN19 */

#define BP_PINCTRL_MUXSEL13_BANK6_PIN19      6
#define BM_PINCTRL_MUXSEL13_BANK6_PIN19      0x000000C0

#define BF_PINCTRL_MUXSEL13_BANK6_PIN19(v)   (((v) << 6) & BM_PINCTRL_MUXSEL13_BANK6_PIN19)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL13_BANK6_PIN19(v)   BF_CS1(PINCTRL_MUXSEL13, BANK6_PIN19, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL13, field BANK6_PIN18 */

#define BP_PINCTRL_MUXSEL13_BANK6_PIN18      4
#define BM_PINCTRL_MUXSEL13_BANK6_PIN18      0x00000030

#define BF_PINCTRL_MUXSEL13_BANK6_PIN18(v)   (((v) << 4) & BM_PINCTRL_MUXSEL13_BANK6_PIN18)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL13_BANK6_PIN18(v)   BF_CS1(PINCTRL_MUXSEL13, BANK6_PIN18, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL13, field BANK6_PIN17 */

#define BP_PINCTRL_MUXSEL13_BANK6_PIN17      2
#define BM_PINCTRL_MUXSEL13_BANK6_PIN17      0x0000000C

#define BF_PINCTRL_MUXSEL13_BANK6_PIN17(v)   (((v) << 2) & BM_PINCTRL_MUXSEL13_BANK6_PIN17)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL13_BANK6_PIN17(v)   BF_CS1(PINCTRL_MUXSEL13, BANK6_PIN17, v)
#endif

/* --- Register HW_PINCTRL_MUXSEL13, field BANK6_PIN16 */

#define BP_PINCTRL_MUXSEL13_BANK6_PIN16      0
#define BM_PINCTRL_MUXSEL13_BANK6_PIN16      0x00000003

#define BF_PINCTRL_MUXSEL13_BANK6_PIN16(v)   (((v) << 0) & BM_PINCTRL_MUXSEL13_BANK6_PIN16)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_MUXSEL13_BANK6_PIN16(v)   BF_CS1(PINCTRL_MUXSEL13, BANK6_PIN16, v)
#endif



/*
 * HW_PINCTRL_DRIVE0 - PINCTRL Drive Strength and Voltage Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK0_PIN00_MA  :  2;
        unsigned BANK0_PIN00_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK0_PIN01_MA  :  2;
        unsigned BANK0_PIN01_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK0_PIN02_MA  :  2;
        unsigned BANK0_PIN02_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK0_PIN03_MA  :  2;
        unsigned BANK0_PIN03_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned BANK0_PIN04_MA  :  2;
        unsigned BANK0_PIN04_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK0_PIN05_MA  :  2;
        unsigned BANK0_PIN05_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned BANK0_PIN06_MA  :  2;
        unsigned BANK0_PIN06_V   :  1;
        unsigned RSRVD6          :  1;
        unsigned BANK0_PIN07_MA  :  2;
        unsigned BANK0_PIN07_V   :  1;
        unsigned RSRVD7          :  1;
    } B;
} hw_pinctrl_drive0_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE0 register
 */
#define HW_PINCTRL_DRIVE0_ADDR         (REGS_PINCTRL_BASE + 0x300)
#define HW_PINCTRL_DRIVE0_SET_ADDR     (HW_PINCTRL_DRIVE0_ADDR + 4)
#define HW_PINCTRL_DRIVE0_CLR_ADDR     (HW_PINCTRL_DRIVE0_ADDR + 8)
#define HW_PINCTRL_DRIVE0_TOG_ADDR     (HW_PINCTRL_DRIVE0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE0           (*(volatile hw_pinctrl_drive0_t *) HW_PINCTRL_DRIVE0_ADDR)
#define HW_PINCTRL_DRIVE0_RD()      (HW_PINCTRL_DRIVE0.U)
#define HW_PINCTRL_DRIVE0_WR(v)     (HW_PINCTRL_DRIVE0.U = (v))
#define HW_PINCTRL_DRIVE0_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE0_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE0_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE0_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE0_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE0 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE0, field RSRVD7 */

#define BP_PINCTRL_DRIVE0_RSRVD7      31
#define BM_PINCTRL_DRIVE0_RSRVD7      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE0_RSRVD7(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DRIVE0_RSRVD7)
#else
#define BF_PINCTRL_DRIVE0_RSRVD7(v)   (((v) << 31) & BM_PINCTRL_DRIVE0_RSRVD7)
#endif
/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN07_V */

#define BP_PINCTRL_DRIVE0_BANK0_PIN07_V      30
#define BM_PINCTRL_DRIVE0_BANK0_PIN07_V      0x40000000

#define BF_PINCTRL_DRIVE0_BANK0_PIN07_V(v)   (((v) << 30) & BM_PINCTRL_DRIVE0_BANK0_PIN07_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN07_V(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN07_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN07_MA */

#define BP_PINCTRL_DRIVE0_BANK0_PIN07_MA      28
#define BM_PINCTRL_DRIVE0_BANK0_PIN07_MA      0x30000000

#define BF_PINCTRL_DRIVE0_BANK0_PIN07_MA(v)   (((v) << 28) & BM_PINCTRL_DRIVE0_BANK0_PIN07_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN07_MA(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN07_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field RSRVD6 */

#define BP_PINCTRL_DRIVE0_RSRVD6      27
#define BM_PINCTRL_DRIVE0_RSRVD6      0x08000000

#define BF_PINCTRL_DRIVE0_RSRVD6(v)   (((v) << 27) & BM_PINCTRL_DRIVE0_RSRVD6)
/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN06_V */

#define BP_PINCTRL_DRIVE0_BANK0_PIN06_V      26
#define BM_PINCTRL_DRIVE0_BANK0_PIN06_V      0x04000000

#define BF_PINCTRL_DRIVE0_BANK0_PIN06_V(v)   (((v) << 26) & BM_PINCTRL_DRIVE0_BANK0_PIN06_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN06_V(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN06_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN06_MA */

#define BP_PINCTRL_DRIVE0_BANK0_PIN06_MA      24
#define BM_PINCTRL_DRIVE0_BANK0_PIN06_MA      0x03000000

#define BF_PINCTRL_DRIVE0_BANK0_PIN06_MA(v)   (((v) << 24) & BM_PINCTRL_DRIVE0_BANK0_PIN06_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN06_MA(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN06_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field RSRVD5 */

#define BP_PINCTRL_DRIVE0_RSRVD5      23
#define BM_PINCTRL_DRIVE0_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE0_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE0_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN05_V */

#define BP_PINCTRL_DRIVE0_BANK0_PIN05_V      22
#define BM_PINCTRL_DRIVE0_BANK0_PIN05_V      0x00400000

#define BF_PINCTRL_DRIVE0_BANK0_PIN05_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE0_BANK0_PIN05_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN05_V(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN05_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN05_MA */

#define BP_PINCTRL_DRIVE0_BANK0_PIN05_MA      20
#define BM_PINCTRL_DRIVE0_BANK0_PIN05_MA      0x00300000

#define BF_PINCTRL_DRIVE0_BANK0_PIN05_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE0_BANK0_PIN05_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN05_MA(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN05_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field RSRVD4 */

#define BP_PINCTRL_DRIVE0_RSRVD4      19
#define BM_PINCTRL_DRIVE0_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE0_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE0_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN04_V */

#define BP_PINCTRL_DRIVE0_BANK0_PIN04_V      18
#define BM_PINCTRL_DRIVE0_BANK0_PIN04_V      0x00040000

#define BF_PINCTRL_DRIVE0_BANK0_PIN04_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE0_BANK0_PIN04_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN04_V(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN04_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN04_MA */

#define BP_PINCTRL_DRIVE0_BANK0_PIN04_MA      16
#define BM_PINCTRL_DRIVE0_BANK0_PIN04_MA      0x00030000

#define BF_PINCTRL_DRIVE0_BANK0_PIN04_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE0_BANK0_PIN04_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN04_MA(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN04_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field RSRVD3 */

#define BP_PINCTRL_DRIVE0_RSRVD3      15
#define BM_PINCTRL_DRIVE0_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE0_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE0_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN03_V */

#define BP_PINCTRL_DRIVE0_BANK0_PIN03_V      14
#define BM_PINCTRL_DRIVE0_BANK0_PIN03_V      0x00004000

#define BF_PINCTRL_DRIVE0_BANK0_PIN03_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE0_BANK0_PIN03_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN03_V(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN03_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN03_MA */

#define BP_PINCTRL_DRIVE0_BANK0_PIN03_MA      12
#define BM_PINCTRL_DRIVE0_BANK0_PIN03_MA      0x00003000

#define BF_PINCTRL_DRIVE0_BANK0_PIN03_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE0_BANK0_PIN03_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN03_MA(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN03_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field RSRVD2 */

#define BP_PINCTRL_DRIVE0_RSRVD2      11
#define BM_PINCTRL_DRIVE0_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE0_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE0_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN02_V */

#define BP_PINCTRL_DRIVE0_BANK0_PIN02_V      10
#define BM_PINCTRL_DRIVE0_BANK0_PIN02_V      0x00000400

#define BF_PINCTRL_DRIVE0_BANK0_PIN02_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE0_BANK0_PIN02_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN02_V(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN02_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN02_MA */

#define BP_PINCTRL_DRIVE0_BANK0_PIN02_MA      8
#define BM_PINCTRL_DRIVE0_BANK0_PIN02_MA      0x00000300

#define BF_PINCTRL_DRIVE0_BANK0_PIN02_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE0_BANK0_PIN02_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN02_MA(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN02_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field RSRVD1 */

#define BP_PINCTRL_DRIVE0_RSRVD1      7
#define BM_PINCTRL_DRIVE0_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE0_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE0_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN01_V */

#define BP_PINCTRL_DRIVE0_BANK0_PIN01_V      6
#define BM_PINCTRL_DRIVE0_BANK0_PIN01_V      0x00000040

#define BF_PINCTRL_DRIVE0_BANK0_PIN01_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE0_BANK0_PIN01_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN01_V(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN01_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN01_MA */

#define BP_PINCTRL_DRIVE0_BANK0_PIN01_MA      4
#define BM_PINCTRL_DRIVE0_BANK0_PIN01_MA      0x00000030

#define BF_PINCTRL_DRIVE0_BANK0_PIN01_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE0_BANK0_PIN01_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN01_MA(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN01_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field RSRVD0 */

#define BP_PINCTRL_DRIVE0_RSRVD0      3
#define BM_PINCTRL_DRIVE0_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE0_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE0_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN00_V */

#define BP_PINCTRL_DRIVE0_BANK0_PIN00_V      2
#define BM_PINCTRL_DRIVE0_BANK0_PIN00_V      0x00000004

#define BF_PINCTRL_DRIVE0_BANK0_PIN00_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE0_BANK0_PIN00_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN00_V(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN00_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE0, field BANK0_PIN00_MA */

#define BP_PINCTRL_DRIVE0_BANK0_PIN00_MA      0
#define BM_PINCTRL_DRIVE0_BANK0_PIN00_MA      0x00000003

#define BF_PINCTRL_DRIVE0_BANK0_PIN00_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE0_BANK0_PIN00_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE0_BANK0_PIN00_MA(v)   BF_CS1(PINCTRL_DRIVE0, BANK0_PIN00_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE1 - PINCTRL Drive Strength and Voltage Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD0  : 32;
    } B;
} hw_pinctrl_drive1_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE1 register
 */
#define HW_PINCTRL_DRIVE1_ADDR         (REGS_PINCTRL_BASE + 0x310)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE1           (*(volatile hw_pinctrl_drive1_t *) HW_PINCTRL_DRIVE1_ADDR)
#define HW_PINCTRL_DRIVE1_RD()      (HW_PINCTRL_DRIVE1.U)
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE1 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE1, field RSRVD0 */

#define BP_PINCTRL_DRIVE1_RSRVD0      0
#define BM_PINCTRL_DRIVE1_RSRVD0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE1_RSRVD0(v)   ((reg32_t) v)
#else
#define BF_PINCTRL_DRIVE1_RSRVD0(v)   (v)
#endif


/*
 * HW_PINCTRL_DRIVE2 - PINCTRL Drive Strength and Voltage Register 2
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK0_PIN16_MA  :  2;
        unsigned BANK0_PIN16_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK0_PIN17_MA  :  2;
        unsigned BANK0_PIN17_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK0_PIN18_MA  :  2;
        unsigned BANK0_PIN18_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK0_PIN19_MA  :  2;
        unsigned BANK0_PIN19_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned BANK0_PIN20_MA  :  2;
        unsigned BANK0_PIN20_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK0_PIN21_MA  :  2;
        unsigned BANK0_PIN21_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned BANK0_PIN22_MA  :  2;
        unsigned BANK0_PIN22_V   :  1;
        unsigned RSRVD6          :  1;
        unsigned BANK0_PIN23_MA  :  2;
        unsigned BANK0_PIN23_V   :  1;
        unsigned RSRVD7          :  1;
    } B;
} hw_pinctrl_drive2_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE2 register
 */
#define HW_PINCTRL_DRIVE2_ADDR         (REGS_PINCTRL_BASE + 0x320)
#define HW_PINCTRL_DRIVE2_SET_ADDR     (HW_PINCTRL_DRIVE2_ADDR + 4)
#define HW_PINCTRL_DRIVE2_CLR_ADDR     (HW_PINCTRL_DRIVE2_ADDR + 8)
#define HW_PINCTRL_DRIVE2_TOG_ADDR     (HW_PINCTRL_DRIVE2_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE2           (*(volatile hw_pinctrl_drive2_t *) HW_PINCTRL_DRIVE2_ADDR)
#define HW_PINCTRL_DRIVE2_RD()      (HW_PINCTRL_DRIVE2.U)
#define HW_PINCTRL_DRIVE2_WR(v)     (HW_PINCTRL_DRIVE2.U = (v))
#define HW_PINCTRL_DRIVE2_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE2_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE2_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE2_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE2_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE2_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE2 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE2, field RSRVD7 */

#define BP_PINCTRL_DRIVE2_RSRVD7      31
#define BM_PINCTRL_DRIVE2_RSRVD7      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE2_RSRVD7(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DRIVE2_RSRVD7)
#else
#define BF_PINCTRL_DRIVE2_RSRVD7(v)   (((v) << 31) & BM_PINCTRL_DRIVE2_RSRVD7)
#endif
/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN23_V */

#define BP_PINCTRL_DRIVE2_BANK0_PIN23_V      30
#define BM_PINCTRL_DRIVE2_BANK0_PIN23_V      0x40000000

#define BF_PINCTRL_DRIVE2_BANK0_PIN23_V(v)   (((v) << 30) & BM_PINCTRL_DRIVE2_BANK0_PIN23_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN23_V(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN23_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN23_MA */

#define BP_PINCTRL_DRIVE2_BANK0_PIN23_MA      28
#define BM_PINCTRL_DRIVE2_BANK0_PIN23_MA      0x30000000

#define BF_PINCTRL_DRIVE2_BANK0_PIN23_MA(v)   (((v) << 28) & BM_PINCTRL_DRIVE2_BANK0_PIN23_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN23_MA(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN23_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field RSRVD6 */

#define BP_PINCTRL_DRIVE2_RSRVD6      27
#define BM_PINCTRL_DRIVE2_RSRVD6      0x08000000

#define BF_PINCTRL_DRIVE2_RSRVD6(v)   (((v) << 27) & BM_PINCTRL_DRIVE2_RSRVD6)
/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN22_V */

#define BP_PINCTRL_DRIVE2_BANK0_PIN22_V      26
#define BM_PINCTRL_DRIVE2_BANK0_PIN22_V      0x04000000

#define BF_PINCTRL_DRIVE2_BANK0_PIN22_V(v)   (((v) << 26) & BM_PINCTRL_DRIVE2_BANK0_PIN22_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN22_V(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN22_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN22_MA */

#define BP_PINCTRL_DRIVE2_BANK0_PIN22_MA      24
#define BM_PINCTRL_DRIVE2_BANK0_PIN22_MA      0x03000000

#define BF_PINCTRL_DRIVE2_BANK0_PIN22_MA(v)   (((v) << 24) & BM_PINCTRL_DRIVE2_BANK0_PIN22_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN22_MA(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN22_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field RSRVD5 */

#define BP_PINCTRL_DRIVE2_RSRVD5      23
#define BM_PINCTRL_DRIVE2_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE2_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE2_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN21_V */

#define BP_PINCTRL_DRIVE2_BANK0_PIN21_V      22
#define BM_PINCTRL_DRIVE2_BANK0_PIN21_V      0x00400000

#define BF_PINCTRL_DRIVE2_BANK0_PIN21_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE2_BANK0_PIN21_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN21_V(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN21_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN21_MA */

#define BP_PINCTRL_DRIVE2_BANK0_PIN21_MA      20
#define BM_PINCTRL_DRIVE2_BANK0_PIN21_MA      0x00300000

#define BF_PINCTRL_DRIVE2_BANK0_PIN21_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE2_BANK0_PIN21_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN21_MA(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN21_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field RSRVD4 */

#define BP_PINCTRL_DRIVE2_RSRVD4      19
#define BM_PINCTRL_DRIVE2_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE2_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE2_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN20_V */

#define BP_PINCTRL_DRIVE2_BANK0_PIN20_V      18
#define BM_PINCTRL_DRIVE2_BANK0_PIN20_V      0x00040000

#define BF_PINCTRL_DRIVE2_BANK0_PIN20_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE2_BANK0_PIN20_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN20_V(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN20_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN20_MA */

#define BP_PINCTRL_DRIVE2_BANK0_PIN20_MA      16
#define BM_PINCTRL_DRIVE2_BANK0_PIN20_MA      0x00030000

#define BF_PINCTRL_DRIVE2_BANK0_PIN20_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE2_BANK0_PIN20_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN20_MA(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN20_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field RSRVD3 */

#define BP_PINCTRL_DRIVE2_RSRVD3      15
#define BM_PINCTRL_DRIVE2_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE2_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE2_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN19_V */

#define BP_PINCTRL_DRIVE2_BANK0_PIN19_V      14
#define BM_PINCTRL_DRIVE2_BANK0_PIN19_V      0x00004000

#define BF_PINCTRL_DRIVE2_BANK0_PIN19_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE2_BANK0_PIN19_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN19_V(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN19_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN19_MA */

#define BP_PINCTRL_DRIVE2_BANK0_PIN19_MA      12
#define BM_PINCTRL_DRIVE2_BANK0_PIN19_MA      0x00003000

#define BF_PINCTRL_DRIVE2_BANK0_PIN19_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE2_BANK0_PIN19_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN19_MA(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN19_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field RSRVD2 */

#define BP_PINCTRL_DRIVE2_RSRVD2      11
#define BM_PINCTRL_DRIVE2_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE2_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE2_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN18_V */

#define BP_PINCTRL_DRIVE2_BANK0_PIN18_V      10
#define BM_PINCTRL_DRIVE2_BANK0_PIN18_V      0x00000400

#define BF_PINCTRL_DRIVE2_BANK0_PIN18_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE2_BANK0_PIN18_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN18_V(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN18_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN18_MA */

#define BP_PINCTRL_DRIVE2_BANK0_PIN18_MA      8
#define BM_PINCTRL_DRIVE2_BANK0_PIN18_MA      0x00000300

#define BF_PINCTRL_DRIVE2_BANK0_PIN18_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE2_BANK0_PIN18_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN18_MA(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN18_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field RSRVD1 */

#define BP_PINCTRL_DRIVE2_RSRVD1      7
#define BM_PINCTRL_DRIVE2_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE2_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE2_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN17_V */

#define BP_PINCTRL_DRIVE2_BANK0_PIN17_V      6
#define BM_PINCTRL_DRIVE2_BANK0_PIN17_V      0x00000040

#define BF_PINCTRL_DRIVE2_BANK0_PIN17_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE2_BANK0_PIN17_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN17_V(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN17_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN17_MA */

#define BP_PINCTRL_DRIVE2_BANK0_PIN17_MA      4
#define BM_PINCTRL_DRIVE2_BANK0_PIN17_MA      0x00000030

#define BF_PINCTRL_DRIVE2_BANK0_PIN17_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE2_BANK0_PIN17_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN17_MA(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN17_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field RSRVD0 */

#define BP_PINCTRL_DRIVE2_RSRVD0      3
#define BM_PINCTRL_DRIVE2_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE2_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE2_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN16_V */

#define BP_PINCTRL_DRIVE2_BANK0_PIN16_V      2
#define BM_PINCTRL_DRIVE2_BANK0_PIN16_V      0x00000004

#define BF_PINCTRL_DRIVE2_BANK0_PIN16_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE2_BANK0_PIN16_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN16_V(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN16_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE2, field BANK0_PIN16_MA */

#define BP_PINCTRL_DRIVE2_BANK0_PIN16_MA      0
#define BM_PINCTRL_DRIVE2_BANK0_PIN16_MA      0x00000003

#define BF_PINCTRL_DRIVE2_BANK0_PIN16_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE2_BANK0_PIN16_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE2_BANK0_PIN16_MA(v)   BF_CS1(PINCTRL_DRIVE2, BANK0_PIN16_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE3 - PINCTRL Drive Strength and Voltage Register 3
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK0_PIN24_MA  :  2;
        unsigned BANK0_PIN24_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK0_PIN25_MA  :  2;
        unsigned BANK0_PIN25_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK0_PIN26_MA  :  2;
        unsigned BANK0_PIN26_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK0_PIN27_MA  :  2;
        unsigned BANK0_PIN27_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned BANK0_PIN28_MA  :  2;
        unsigned BANK0_PIN28_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned RSRVD5          : 12;
    } B;
} hw_pinctrl_drive3_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE3 register
 */
#define HW_PINCTRL_DRIVE3_ADDR         (REGS_PINCTRL_BASE + 0x330)
#define HW_PINCTRL_DRIVE3_SET_ADDR     (HW_PINCTRL_DRIVE3_ADDR + 4)
#define HW_PINCTRL_DRIVE3_CLR_ADDR     (HW_PINCTRL_DRIVE3_ADDR + 8)
#define HW_PINCTRL_DRIVE3_TOG_ADDR     (HW_PINCTRL_DRIVE3_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE3           (*(volatile hw_pinctrl_drive3_t *) HW_PINCTRL_DRIVE3_ADDR)
#define HW_PINCTRL_DRIVE3_RD()      (HW_PINCTRL_DRIVE3.U)
#define HW_PINCTRL_DRIVE3_WR(v)     (HW_PINCTRL_DRIVE3.U = (v))
#define HW_PINCTRL_DRIVE3_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE3_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE3_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE3_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE3_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE3_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE3 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE3, field RSRVD5 */

#define BP_PINCTRL_DRIVE3_RSRVD5      20
#define BM_PINCTRL_DRIVE3_RSRVD5      0xFFF00000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE3_RSRVD5(v)   ((((reg32_t) v) << 20) & BM_PINCTRL_DRIVE3_RSRVD5)
#else
#define BF_PINCTRL_DRIVE3_RSRVD5(v)   (((v) << 20) & BM_PINCTRL_DRIVE3_RSRVD5)
#endif
/* --- Register HW_PINCTRL_DRIVE3, field RSRVD4 */

#define BP_PINCTRL_DRIVE3_RSRVD4      19
#define BM_PINCTRL_DRIVE3_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE3_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE3_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE3, field BANK0_PIN28_V */

#define BP_PINCTRL_DRIVE3_BANK0_PIN28_V      18
#define BM_PINCTRL_DRIVE3_BANK0_PIN28_V      0x00040000

#define BF_PINCTRL_DRIVE3_BANK0_PIN28_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE3_BANK0_PIN28_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE3_BANK0_PIN28_V(v)   BF_CS1(PINCTRL_DRIVE3, BANK0_PIN28_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE3, field BANK0_PIN28_MA */

#define BP_PINCTRL_DRIVE3_BANK0_PIN28_MA      16
#define BM_PINCTRL_DRIVE3_BANK0_PIN28_MA      0x00030000

#define BF_PINCTRL_DRIVE3_BANK0_PIN28_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE3_BANK0_PIN28_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE3_BANK0_PIN28_MA(v)   BF_CS1(PINCTRL_DRIVE3, BANK0_PIN28_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE3, field RSRVD3 */

#define BP_PINCTRL_DRIVE3_RSRVD3      15
#define BM_PINCTRL_DRIVE3_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE3_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE3_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE3, field BANK0_PIN27_V */

#define BP_PINCTRL_DRIVE3_BANK0_PIN27_V      14
#define BM_PINCTRL_DRIVE3_BANK0_PIN27_V      0x00004000

#define BF_PINCTRL_DRIVE3_BANK0_PIN27_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE3_BANK0_PIN27_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE3_BANK0_PIN27_V(v)   BF_CS1(PINCTRL_DRIVE3, BANK0_PIN27_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE3, field BANK0_PIN27_MA */

#define BP_PINCTRL_DRIVE3_BANK0_PIN27_MA      12
#define BM_PINCTRL_DRIVE3_BANK0_PIN27_MA      0x00003000

#define BF_PINCTRL_DRIVE3_BANK0_PIN27_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE3_BANK0_PIN27_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE3_BANK0_PIN27_MA(v)   BF_CS1(PINCTRL_DRIVE3, BANK0_PIN27_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE3, field RSRVD2 */

#define BP_PINCTRL_DRIVE3_RSRVD2      11
#define BM_PINCTRL_DRIVE3_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE3_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE3_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE3, field BANK0_PIN26_V */

#define BP_PINCTRL_DRIVE3_BANK0_PIN26_V      10
#define BM_PINCTRL_DRIVE3_BANK0_PIN26_V      0x00000400

#define BF_PINCTRL_DRIVE3_BANK0_PIN26_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE3_BANK0_PIN26_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE3_BANK0_PIN26_V(v)   BF_CS1(PINCTRL_DRIVE3, BANK0_PIN26_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE3, field BANK0_PIN26_MA */

#define BP_PINCTRL_DRIVE3_BANK0_PIN26_MA      8
#define BM_PINCTRL_DRIVE3_BANK0_PIN26_MA      0x00000300

#define BF_PINCTRL_DRIVE3_BANK0_PIN26_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE3_BANK0_PIN26_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE3_BANK0_PIN26_MA(v)   BF_CS1(PINCTRL_DRIVE3, BANK0_PIN26_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE3, field RSRVD1 */

#define BP_PINCTRL_DRIVE3_RSRVD1      7
#define BM_PINCTRL_DRIVE3_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE3_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE3_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE3, field BANK0_PIN25_V */

#define BP_PINCTRL_DRIVE3_BANK0_PIN25_V      6
#define BM_PINCTRL_DRIVE3_BANK0_PIN25_V      0x00000040

#define BF_PINCTRL_DRIVE3_BANK0_PIN25_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE3_BANK0_PIN25_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE3_BANK0_PIN25_V(v)   BF_CS1(PINCTRL_DRIVE3, BANK0_PIN25_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE3, field BANK0_PIN25_MA */

#define BP_PINCTRL_DRIVE3_BANK0_PIN25_MA      4
#define BM_PINCTRL_DRIVE3_BANK0_PIN25_MA      0x00000030

#define BF_PINCTRL_DRIVE3_BANK0_PIN25_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE3_BANK0_PIN25_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE3_BANK0_PIN25_MA(v)   BF_CS1(PINCTRL_DRIVE3, BANK0_PIN25_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE3, field RSRVD0 */

#define BP_PINCTRL_DRIVE3_RSRVD0      3
#define BM_PINCTRL_DRIVE3_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE3_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE3_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE3, field BANK0_PIN24_V */

#define BP_PINCTRL_DRIVE3_BANK0_PIN24_V      2
#define BM_PINCTRL_DRIVE3_BANK0_PIN24_V      0x00000004

#define BF_PINCTRL_DRIVE3_BANK0_PIN24_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE3_BANK0_PIN24_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE3_BANK0_PIN24_V(v)   BF_CS1(PINCTRL_DRIVE3, BANK0_PIN24_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE3, field BANK0_PIN24_MA */

#define BP_PINCTRL_DRIVE3_BANK0_PIN24_MA      0
#define BM_PINCTRL_DRIVE3_BANK0_PIN24_MA      0x00000003

#define BF_PINCTRL_DRIVE3_BANK0_PIN24_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE3_BANK0_PIN24_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE3_BANK0_PIN24_MA(v)   BF_CS1(PINCTRL_DRIVE3, BANK0_PIN24_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE4 - PINCTRL Drive Strength and Voltage Register 4
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK1_PIN00_MA  :  2;
        unsigned BANK1_PIN00_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK1_PIN01_MA  :  2;
        unsigned BANK1_PIN01_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK1_PIN02_MA  :  2;
        unsigned BANK1_PIN02_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK1_PIN03_MA  :  2;
        unsigned BANK1_PIN03_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned BANK1_PIN04_MA  :  2;
        unsigned BANK1_PIN04_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK1_PIN05_MA  :  2;
        unsigned BANK1_PIN05_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned BANK1_PIN06_MA  :  2;
        unsigned BANK1_PIN06_V   :  1;
        unsigned RSRVD6          :  1;
        unsigned BANK1_PIN07_MA  :  2;
        unsigned BANK1_PIN07_V   :  1;
        unsigned RSRVD7          :  1;
    } B;
} hw_pinctrl_drive4_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE4 register
 */
#define HW_PINCTRL_DRIVE4_ADDR         (REGS_PINCTRL_BASE + 0x340)
#define HW_PINCTRL_DRIVE4_SET_ADDR     (HW_PINCTRL_DRIVE4_ADDR + 4)
#define HW_PINCTRL_DRIVE4_CLR_ADDR     (HW_PINCTRL_DRIVE4_ADDR + 8)
#define HW_PINCTRL_DRIVE4_TOG_ADDR     (HW_PINCTRL_DRIVE4_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE4           (*(volatile hw_pinctrl_drive4_t *) HW_PINCTRL_DRIVE4_ADDR)
#define HW_PINCTRL_DRIVE4_RD()      (HW_PINCTRL_DRIVE4.U)
#define HW_PINCTRL_DRIVE4_WR(v)     (HW_PINCTRL_DRIVE4.U = (v))
#define HW_PINCTRL_DRIVE4_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE4_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE4_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE4_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE4_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE4_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE4 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE4, field RSRVD7 */

#define BP_PINCTRL_DRIVE4_RSRVD7      31
#define BM_PINCTRL_DRIVE4_RSRVD7      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE4_RSRVD7(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DRIVE4_RSRVD7)
#else
#define BF_PINCTRL_DRIVE4_RSRVD7(v)   (((v) << 31) & BM_PINCTRL_DRIVE4_RSRVD7)
#endif
/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN07_V */

#define BP_PINCTRL_DRIVE4_BANK1_PIN07_V      30
#define BM_PINCTRL_DRIVE4_BANK1_PIN07_V      0x40000000

#define BF_PINCTRL_DRIVE4_BANK1_PIN07_V(v)   (((v) << 30) & BM_PINCTRL_DRIVE4_BANK1_PIN07_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN07_V(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN07_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN07_MA */

#define BP_PINCTRL_DRIVE4_BANK1_PIN07_MA      28
#define BM_PINCTRL_DRIVE4_BANK1_PIN07_MA      0x30000000

#define BF_PINCTRL_DRIVE4_BANK1_PIN07_MA(v)   (((v) << 28) & BM_PINCTRL_DRIVE4_BANK1_PIN07_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN07_MA(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN07_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field RSRVD6 */

#define BP_PINCTRL_DRIVE4_RSRVD6      27
#define BM_PINCTRL_DRIVE4_RSRVD6      0x08000000

#define BF_PINCTRL_DRIVE4_RSRVD6(v)   (((v) << 27) & BM_PINCTRL_DRIVE4_RSRVD6)
/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN06_V */

#define BP_PINCTRL_DRIVE4_BANK1_PIN06_V      26
#define BM_PINCTRL_DRIVE4_BANK1_PIN06_V      0x04000000

#define BF_PINCTRL_DRIVE4_BANK1_PIN06_V(v)   (((v) << 26) & BM_PINCTRL_DRIVE4_BANK1_PIN06_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN06_V(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN06_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN06_MA */

#define BP_PINCTRL_DRIVE4_BANK1_PIN06_MA      24
#define BM_PINCTRL_DRIVE4_BANK1_PIN06_MA      0x03000000

#define BF_PINCTRL_DRIVE4_BANK1_PIN06_MA(v)   (((v) << 24) & BM_PINCTRL_DRIVE4_BANK1_PIN06_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN06_MA(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN06_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field RSRVD5 */

#define BP_PINCTRL_DRIVE4_RSRVD5      23
#define BM_PINCTRL_DRIVE4_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE4_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE4_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN05_V */

#define BP_PINCTRL_DRIVE4_BANK1_PIN05_V      22
#define BM_PINCTRL_DRIVE4_BANK1_PIN05_V      0x00400000

#define BF_PINCTRL_DRIVE4_BANK1_PIN05_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE4_BANK1_PIN05_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN05_V(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN05_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN05_MA */

#define BP_PINCTRL_DRIVE4_BANK1_PIN05_MA      20
#define BM_PINCTRL_DRIVE4_BANK1_PIN05_MA      0x00300000

#define BF_PINCTRL_DRIVE4_BANK1_PIN05_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE4_BANK1_PIN05_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN05_MA(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN05_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field RSRVD4 */

#define BP_PINCTRL_DRIVE4_RSRVD4      19
#define BM_PINCTRL_DRIVE4_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE4_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE4_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN04_V */

#define BP_PINCTRL_DRIVE4_BANK1_PIN04_V      18
#define BM_PINCTRL_DRIVE4_BANK1_PIN04_V      0x00040000

#define BF_PINCTRL_DRIVE4_BANK1_PIN04_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE4_BANK1_PIN04_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN04_V(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN04_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN04_MA */

#define BP_PINCTRL_DRIVE4_BANK1_PIN04_MA      16
#define BM_PINCTRL_DRIVE4_BANK1_PIN04_MA      0x00030000

#define BF_PINCTRL_DRIVE4_BANK1_PIN04_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE4_BANK1_PIN04_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN04_MA(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN04_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field RSRVD3 */

#define BP_PINCTRL_DRIVE4_RSRVD3      15
#define BM_PINCTRL_DRIVE4_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE4_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE4_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN03_V */

#define BP_PINCTRL_DRIVE4_BANK1_PIN03_V      14
#define BM_PINCTRL_DRIVE4_BANK1_PIN03_V      0x00004000

#define BF_PINCTRL_DRIVE4_BANK1_PIN03_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE4_BANK1_PIN03_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN03_V(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN03_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN03_MA */

#define BP_PINCTRL_DRIVE4_BANK1_PIN03_MA      12
#define BM_PINCTRL_DRIVE4_BANK1_PIN03_MA      0x00003000

#define BF_PINCTRL_DRIVE4_BANK1_PIN03_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE4_BANK1_PIN03_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN03_MA(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN03_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field RSRVD2 */

#define BP_PINCTRL_DRIVE4_RSRVD2      11
#define BM_PINCTRL_DRIVE4_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE4_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE4_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN02_V */

#define BP_PINCTRL_DRIVE4_BANK1_PIN02_V      10
#define BM_PINCTRL_DRIVE4_BANK1_PIN02_V      0x00000400

#define BF_PINCTRL_DRIVE4_BANK1_PIN02_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE4_BANK1_PIN02_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN02_V(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN02_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN02_MA */

#define BP_PINCTRL_DRIVE4_BANK1_PIN02_MA      8
#define BM_PINCTRL_DRIVE4_BANK1_PIN02_MA      0x00000300

#define BF_PINCTRL_DRIVE4_BANK1_PIN02_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE4_BANK1_PIN02_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN02_MA(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN02_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field RSRVD1 */

#define BP_PINCTRL_DRIVE4_RSRVD1      7
#define BM_PINCTRL_DRIVE4_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE4_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE4_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN01_V */

#define BP_PINCTRL_DRIVE4_BANK1_PIN01_V      6
#define BM_PINCTRL_DRIVE4_BANK1_PIN01_V      0x00000040

#define BF_PINCTRL_DRIVE4_BANK1_PIN01_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE4_BANK1_PIN01_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN01_V(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN01_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN01_MA */

#define BP_PINCTRL_DRIVE4_BANK1_PIN01_MA      4
#define BM_PINCTRL_DRIVE4_BANK1_PIN01_MA      0x00000030

#define BF_PINCTRL_DRIVE4_BANK1_PIN01_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE4_BANK1_PIN01_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN01_MA(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN01_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field RSRVD0 */

#define BP_PINCTRL_DRIVE4_RSRVD0      3
#define BM_PINCTRL_DRIVE4_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE4_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE4_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN00_V */

#define BP_PINCTRL_DRIVE4_BANK1_PIN00_V      2
#define BM_PINCTRL_DRIVE4_BANK1_PIN00_V      0x00000004

#define BF_PINCTRL_DRIVE4_BANK1_PIN00_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE4_BANK1_PIN00_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN00_V(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN00_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE4, field BANK1_PIN00_MA */

#define BP_PINCTRL_DRIVE4_BANK1_PIN00_MA      0
#define BM_PINCTRL_DRIVE4_BANK1_PIN00_MA      0x00000003

#define BF_PINCTRL_DRIVE4_BANK1_PIN00_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE4_BANK1_PIN00_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE4_BANK1_PIN00_MA(v)   BF_CS1(PINCTRL_DRIVE4, BANK1_PIN00_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE5 - PINCTRL Drive Strength and Voltage Register 5
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK1_PIN08_MA  :  2;
        unsigned BANK1_PIN08_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK1_PIN09_MA  :  2;
        unsigned BANK1_PIN09_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK1_PIN10_MA  :  2;
        unsigned BANK1_PIN10_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK1_PIN11_MA  :  2;
        unsigned BANK1_PIN11_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned BANK1_PIN12_MA  :  2;
        unsigned BANK1_PIN12_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK1_PIN13_MA  :  2;
        unsigned BANK1_PIN13_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned BANK1_PIN14_MA  :  2;
        unsigned BANK1_PIN14_V   :  1;
        unsigned RSRVD6          :  1;
        unsigned BANK1_PIN15_MA  :  2;
        unsigned BANK1_PIN15_V   :  1;
        unsigned RSRVD7          :  1;
    } B;
} hw_pinctrl_drive5_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE5 register
 */
#define HW_PINCTRL_DRIVE5_ADDR         (REGS_PINCTRL_BASE + 0x350)
#define HW_PINCTRL_DRIVE5_SET_ADDR     (HW_PINCTRL_DRIVE5_ADDR + 4)
#define HW_PINCTRL_DRIVE5_CLR_ADDR     (HW_PINCTRL_DRIVE5_ADDR + 8)
#define HW_PINCTRL_DRIVE5_TOG_ADDR     (HW_PINCTRL_DRIVE5_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE5           (*(volatile hw_pinctrl_drive5_t *) HW_PINCTRL_DRIVE5_ADDR)
#define HW_PINCTRL_DRIVE5_RD()      (HW_PINCTRL_DRIVE5.U)
#define HW_PINCTRL_DRIVE5_WR(v)     (HW_PINCTRL_DRIVE5.U = (v))
#define HW_PINCTRL_DRIVE5_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE5_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE5_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE5_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE5_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE5_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE5 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE5, field RSRVD7 */

#define BP_PINCTRL_DRIVE5_RSRVD7      31
#define BM_PINCTRL_DRIVE5_RSRVD7      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE5_RSRVD7(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DRIVE5_RSRVD7)
#else
#define BF_PINCTRL_DRIVE5_RSRVD7(v)   (((v) << 31) & BM_PINCTRL_DRIVE5_RSRVD7)
#endif
/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN15_V */

#define BP_PINCTRL_DRIVE5_BANK1_PIN15_V      30
#define BM_PINCTRL_DRIVE5_BANK1_PIN15_V      0x40000000

#define BF_PINCTRL_DRIVE5_BANK1_PIN15_V(v)   (((v) << 30) & BM_PINCTRL_DRIVE5_BANK1_PIN15_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN15_V(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN15_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN15_MA */

#define BP_PINCTRL_DRIVE5_BANK1_PIN15_MA      28
#define BM_PINCTRL_DRIVE5_BANK1_PIN15_MA      0x30000000

#define BF_PINCTRL_DRIVE5_BANK1_PIN15_MA(v)   (((v) << 28) & BM_PINCTRL_DRIVE5_BANK1_PIN15_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN15_MA(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN15_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field RSRVD6 */

#define BP_PINCTRL_DRIVE5_RSRVD6      27
#define BM_PINCTRL_DRIVE5_RSRVD6      0x08000000

#define BF_PINCTRL_DRIVE5_RSRVD6(v)   (((v) << 27) & BM_PINCTRL_DRIVE5_RSRVD6)
/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN14_V */

#define BP_PINCTRL_DRIVE5_BANK1_PIN14_V      26
#define BM_PINCTRL_DRIVE5_BANK1_PIN14_V      0x04000000

#define BF_PINCTRL_DRIVE5_BANK1_PIN14_V(v)   (((v) << 26) & BM_PINCTRL_DRIVE5_BANK1_PIN14_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN14_V(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN14_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN14_MA */

#define BP_PINCTRL_DRIVE5_BANK1_PIN14_MA      24
#define BM_PINCTRL_DRIVE5_BANK1_PIN14_MA      0x03000000

#define BF_PINCTRL_DRIVE5_BANK1_PIN14_MA(v)   (((v) << 24) & BM_PINCTRL_DRIVE5_BANK1_PIN14_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN14_MA(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN14_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field RSRVD5 */

#define BP_PINCTRL_DRIVE5_RSRVD5      23
#define BM_PINCTRL_DRIVE5_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE5_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE5_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN13_V */

#define BP_PINCTRL_DRIVE5_BANK1_PIN13_V      22
#define BM_PINCTRL_DRIVE5_BANK1_PIN13_V      0x00400000

#define BF_PINCTRL_DRIVE5_BANK1_PIN13_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE5_BANK1_PIN13_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN13_V(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN13_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN13_MA */

#define BP_PINCTRL_DRIVE5_BANK1_PIN13_MA      20
#define BM_PINCTRL_DRIVE5_BANK1_PIN13_MA      0x00300000

#define BF_PINCTRL_DRIVE5_BANK1_PIN13_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE5_BANK1_PIN13_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN13_MA(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN13_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field RSRVD4 */

#define BP_PINCTRL_DRIVE5_RSRVD4      19
#define BM_PINCTRL_DRIVE5_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE5_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE5_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN12_V */

#define BP_PINCTRL_DRIVE5_BANK1_PIN12_V      18
#define BM_PINCTRL_DRIVE5_BANK1_PIN12_V      0x00040000

#define BF_PINCTRL_DRIVE5_BANK1_PIN12_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE5_BANK1_PIN12_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN12_V(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN12_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN12_MA */

#define BP_PINCTRL_DRIVE5_BANK1_PIN12_MA      16
#define BM_PINCTRL_DRIVE5_BANK1_PIN12_MA      0x00030000

#define BF_PINCTRL_DRIVE5_BANK1_PIN12_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE5_BANK1_PIN12_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN12_MA(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN12_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field RSRVD3 */

#define BP_PINCTRL_DRIVE5_RSRVD3      15
#define BM_PINCTRL_DRIVE5_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE5_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE5_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN11_V */

#define BP_PINCTRL_DRIVE5_BANK1_PIN11_V      14
#define BM_PINCTRL_DRIVE5_BANK1_PIN11_V      0x00004000

#define BF_PINCTRL_DRIVE5_BANK1_PIN11_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE5_BANK1_PIN11_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN11_V(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN11_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN11_MA */

#define BP_PINCTRL_DRIVE5_BANK1_PIN11_MA      12
#define BM_PINCTRL_DRIVE5_BANK1_PIN11_MA      0x00003000

#define BF_PINCTRL_DRIVE5_BANK1_PIN11_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE5_BANK1_PIN11_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN11_MA(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN11_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field RSRVD2 */

#define BP_PINCTRL_DRIVE5_RSRVD2      11
#define BM_PINCTRL_DRIVE5_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE5_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE5_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN10_V */

#define BP_PINCTRL_DRIVE5_BANK1_PIN10_V      10
#define BM_PINCTRL_DRIVE5_BANK1_PIN10_V      0x00000400

#define BF_PINCTRL_DRIVE5_BANK1_PIN10_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE5_BANK1_PIN10_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN10_V(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN10_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN10_MA */

#define BP_PINCTRL_DRIVE5_BANK1_PIN10_MA      8
#define BM_PINCTRL_DRIVE5_BANK1_PIN10_MA      0x00000300

#define BF_PINCTRL_DRIVE5_BANK1_PIN10_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE5_BANK1_PIN10_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN10_MA(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN10_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field RSRVD1 */

#define BP_PINCTRL_DRIVE5_RSRVD1      7
#define BM_PINCTRL_DRIVE5_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE5_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE5_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN09_V */

#define BP_PINCTRL_DRIVE5_BANK1_PIN09_V      6
#define BM_PINCTRL_DRIVE5_BANK1_PIN09_V      0x00000040

#define BF_PINCTRL_DRIVE5_BANK1_PIN09_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE5_BANK1_PIN09_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN09_V(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN09_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN09_MA */

#define BP_PINCTRL_DRIVE5_BANK1_PIN09_MA      4
#define BM_PINCTRL_DRIVE5_BANK1_PIN09_MA      0x00000030

#define BF_PINCTRL_DRIVE5_BANK1_PIN09_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE5_BANK1_PIN09_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN09_MA(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN09_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field RSRVD0 */

#define BP_PINCTRL_DRIVE5_RSRVD0      3
#define BM_PINCTRL_DRIVE5_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE5_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE5_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN08_V */

#define BP_PINCTRL_DRIVE5_BANK1_PIN08_V      2
#define BM_PINCTRL_DRIVE5_BANK1_PIN08_V      0x00000004

#define BF_PINCTRL_DRIVE5_BANK1_PIN08_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE5_BANK1_PIN08_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN08_V(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN08_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE5, field BANK1_PIN08_MA */

#define BP_PINCTRL_DRIVE5_BANK1_PIN08_MA      0
#define BM_PINCTRL_DRIVE5_BANK1_PIN08_MA      0x00000003

#define BF_PINCTRL_DRIVE5_BANK1_PIN08_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE5_BANK1_PIN08_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE5_BANK1_PIN08_MA(v)   BF_CS1(PINCTRL_DRIVE5, BANK1_PIN08_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE6 - PINCTRL Drive Strength and Voltage Register 6
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK1_PIN16_MA  :  2;
        unsigned BANK1_PIN16_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK1_PIN17_MA  :  2;
        unsigned BANK1_PIN17_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK1_PIN18_MA  :  2;
        unsigned BANK1_PIN18_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK1_PIN19_MA  :  2;
        unsigned BANK1_PIN19_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned BANK1_PIN20_MA  :  2;
        unsigned BANK1_PIN20_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK1_PIN21_MA  :  2;
        unsigned BANK1_PIN21_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned BANK1_PIN22_MA  :  2;
        unsigned BANK1_PIN22_V   :  1;
        unsigned RSRVD6          :  1;
        unsigned BANK1_PIN23_MA  :  2;
        unsigned BANK1_PIN23_V   :  1;
        unsigned RSRVD7          :  1;
    } B;
} hw_pinctrl_drive6_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE6 register
 */
#define HW_PINCTRL_DRIVE6_ADDR         (REGS_PINCTRL_BASE + 0x360)
#define HW_PINCTRL_DRIVE6_SET_ADDR     (HW_PINCTRL_DRIVE6_ADDR + 4)
#define HW_PINCTRL_DRIVE6_CLR_ADDR     (HW_PINCTRL_DRIVE6_ADDR + 8)
#define HW_PINCTRL_DRIVE6_TOG_ADDR     (HW_PINCTRL_DRIVE6_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE6           (*(volatile hw_pinctrl_drive6_t *) HW_PINCTRL_DRIVE6_ADDR)
#define HW_PINCTRL_DRIVE6_RD()      (HW_PINCTRL_DRIVE6.U)
#define HW_PINCTRL_DRIVE6_WR(v)     (HW_PINCTRL_DRIVE6.U = (v))
#define HW_PINCTRL_DRIVE6_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE6_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE6_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE6_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE6_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE6_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE6 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE6, field RSRVD7 */

#define BP_PINCTRL_DRIVE6_RSRVD7      31
#define BM_PINCTRL_DRIVE6_RSRVD7      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE6_RSRVD7(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DRIVE6_RSRVD7)
#else
#define BF_PINCTRL_DRIVE6_RSRVD7(v)   (((v) << 31) & BM_PINCTRL_DRIVE6_RSRVD7)
#endif
/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN23_V */

#define BP_PINCTRL_DRIVE6_BANK1_PIN23_V      30
#define BM_PINCTRL_DRIVE6_BANK1_PIN23_V      0x40000000

#define BF_PINCTRL_DRIVE6_BANK1_PIN23_V(v)   (((v) << 30) & BM_PINCTRL_DRIVE6_BANK1_PIN23_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN23_V(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN23_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN23_MA */

#define BP_PINCTRL_DRIVE6_BANK1_PIN23_MA      28
#define BM_PINCTRL_DRIVE6_BANK1_PIN23_MA      0x30000000

#define BF_PINCTRL_DRIVE6_BANK1_PIN23_MA(v)   (((v) << 28) & BM_PINCTRL_DRIVE6_BANK1_PIN23_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN23_MA(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN23_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field RSRVD6 */

#define BP_PINCTRL_DRIVE6_RSRVD6      27
#define BM_PINCTRL_DRIVE6_RSRVD6      0x08000000

#define BF_PINCTRL_DRIVE6_RSRVD6(v)   (((v) << 27) & BM_PINCTRL_DRIVE6_RSRVD6)
/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN22_V */

#define BP_PINCTRL_DRIVE6_BANK1_PIN22_V      26
#define BM_PINCTRL_DRIVE6_BANK1_PIN22_V      0x04000000

#define BF_PINCTRL_DRIVE6_BANK1_PIN22_V(v)   (((v) << 26) & BM_PINCTRL_DRIVE6_BANK1_PIN22_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN22_V(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN22_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN22_MA */

#define BP_PINCTRL_DRIVE6_BANK1_PIN22_MA      24
#define BM_PINCTRL_DRIVE6_BANK1_PIN22_MA      0x03000000

#define BF_PINCTRL_DRIVE6_BANK1_PIN22_MA(v)   (((v) << 24) & BM_PINCTRL_DRIVE6_BANK1_PIN22_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN22_MA(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN22_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field RSRVD5 */

#define BP_PINCTRL_DRIVE6_RSRVD5      23
#define BM_PINCTRL_DRIVE6_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE6_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE6_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN21_V */

#define BP_PINCTRL_DRIVE6_BANK1_PIN21_V      22
#define BM_PINCTRL_DRIVE6_BANK1_PIN21_V      0x00400000

#define BF_PINCTRL_DRIVE6_BANK1_PIN21_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE6_BANK1_PIN21_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN21_V(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN21_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN21_MA */

#define BP_PINCTRL_DRIVE6_BANK1_PIN21_MA      20
#define BM_PINCTRL_DRIVE6_BANK1_PIN21_MA      0x00300000

#define BF_PINCTRL_DRIVE6_BANK1_PIN21_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE6_BANK1_PIN21_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN21_MA(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN21_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field RSRVD4 */

#define BP_PINCTRL_DRIVE6_RSRVD4      19
#define BM_PINCTRL_DRIVE6_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE6_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE6_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN20_V */

#define BP_PINCTRL_DRIVE6_BANK1_PIN20_V      18
#define BM_PINCTRL_DRIVE6_BANK1_PIN20_V      0x00040000

#define BF_PINCTRL_DRIVE6_BANK1_PIN20_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE6_BANK1_PIN20_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN20_V(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN20_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN20_MA */

#define BP_PINCTRL_DRIVE6_BANK1_PIN20_MA      16
#define BM_PINCTRL_DRIVE6_BANK1_PIN20_MA      0x00030000

#define BF_PINCTRL_DRIVE6_BANK1_PIN20_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE6_BANK1_PIN20_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN20_MA(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN20_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field RSRVD3 */

#define BP_PINCTRL_DRIVE6_RSRVD3      15
#define BM_PINCTRL_DRIVE6_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE6_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE6_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN19_V */

#define BP_PINCTRL_DRIVE6_BANK1_PIN19_V      14
#define BM_PINCTRL_DRIVE6_BANK1_PIN19_V      0x00004000

#define BF_PINCTRL_DRIVE6_BANK1_PIN19_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE6_BANK1_PIN19_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN19_V(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN19_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN19_MA */

#define BP_PINCTRL_DRIVE6_BANK1_PIN19_MA      12
#define BM_PINCTRL_DRIVE6_BANK1_PIN19_MA      0x00003000

#define BF_PINCTRL_DRIVE6_BANK1_PIN19_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE6_BANK1_PIN19_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN19_MA(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN19_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field RSRVD2 */

#define BP_PINCTRL_DRIVE6_RSRVD2      11
#define BM_PINCTRL_DRIVE6_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE6_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE6_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN18_V */

#define BP_PINCTRL_DRIVE6_BANK1_PIN18_V      10
#define BM_PINCTRL_DRIVE6_BANK1_PIN18_V      0x00000400

#define BF_PINCTRL_DRIVE6_BANK1_PIN18_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE6_BANK1_PIN18_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN18_V(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN18_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN18_MA */

#define BP_PINCTRL_DRIVE6_BANK1_PIN18_MA      8
#define BM_PINCTRL_DRIVE6_BANK1_PIN18_MA      0x00000300

#define BF_PINCTRL_DRIVE6_BANK1_PIN18_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE6_BANK1_PIN18_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN18_MA(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN18_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field RSRVD1 */

#define BP_PINCTRL_DRIVE6_RSRVD1      7
#define BM_PINCTRL_DRIVE6_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE6_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE6_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN17_V */

#define BP_PINCTRL_DRIVE6_BANK1_PIN17_V      6
#define BM_PINCTRL_DRIVE6_BANK1_PIN17_V      0x00000040

#define BF_PINCTRL_DRIVE6_BANK1_PIN17_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE6_BANK1_PIN17_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN17_V(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN17_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN17_MA */

#define BP_PINCTRL_DRIVE6_BANK1_PIN17_MA      4
#define BM_PINCTRL_DRIVE6_BANK1_PIN17_MA      0x00000030

#define BF_PINCTRL_DRIVE6_BANK1_PIN17_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE6_BANK1_PIN17_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN17_MA(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN17_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field RSRVD0 */

#define BP_PINCTRL_DRIVE6_RSRVD0      3
#define BM_PINCTRL_DRIVE6_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE6_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE6_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN16_V */

#define BP_PINCTRL_DRIVE6_BANK1_PIN16_V      2
#define BM_PINCTRL_DRIVE6_BANK1_PIN16_V      0x00000004

#define BF_PINCTRL_DRIVE6_BANK1_PIN16_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE6_BANK1_PIN16_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN16_V(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN16_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE6, field BANK1_PIN16_MA */

#define BP_PINCTRL_DRIVE6_BANK1_PIN16_MA      0
#define BM_PINCTRL_DRIVE6_BANK1_PIN16_MA      0x00000003

#define BF_PINCTRL_DRIVE6_BANK1_PIN16_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE6_BANK1_PIN16_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE6_BANK1_PIN16_MA(v)   BF_CS1(PINCTRL_DRIVE6, BANK1_PIN16_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE7 - PINCTRL Drive Strength and Voltage Register 7
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK1_PIN24_MA  :  2;
        unsigned BANK1_PIN24_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK1_PIN25_MA  :  2;
        unsigned BANK1_PIN25_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK1_PIN26_MA  :  2;
        unsigned BANK1_PIN26_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK1_PIN27_MA  :  2;
        unsigned BANK1_PIN27_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned BANK1_PIN28_MA  :  2;
        unsigned BANK1_PIN28_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK1_PIN29_MA  :  2;
        unsigned BANK1_PIN29_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned BANK1_PIN30_MA  :  2;
        unsigned BANK1_PIN30_V   :  1;
        unsigned RSRVD6          :  1;
        unsigned BANK1_PIN31_MA  :  2;
        unsigned BANK1_PIN31_V   :  1;
        unsigned RSRVD7          :  1;
    } B;
} hw_pinctrl_drive7_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE7 register
 */
#define HW_PINCTRL_DRIVE7_ADDR         (REGS_PINCTRL_BASE + 0x370)
#define HW_PINCTRL_DRIVE7_SET_ADDR     (HW_PINCTRL_DRIVE7_ADDR + 4)
#define HW_PINCTRL_DRIVE7_CLR_ADDR     (HW_PINCTRL_DRIVE7_ADDR + 8)
#define HW_PINCTRL_DRIVE7_TOG_ADDR     (HW_PINCTRL_DRIVE7_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE7           (*(volatile hw_pinctrl_drive7_t *) HW_PINCTRL_DRIVE7_ADDR)
#define HW_PINCTRL_DRIVE7_RD()      (HW_PINCTRL_DRIVE7.U)
#define HW_PINCTRL_DRIVE7_WR(v)     (HW_PINCTRL_DRIVE7.U = (v))
#define HW_PINCTRL_DRIVE7_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE7_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE7_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE7_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE7_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE7_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE7 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE7, field RSRVD7 */

#define BP_PINCTRL_DRIVE7_RSRVD7      31
#define BM_PINCTRL_DRIVE7_RSRVD7      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE7_RSRVD7(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DRIVE7_RSRVD7)
#else
#define BF_PINCTRL_DRIVE7_RSRVD7(v)   (((v) << 31) & BM_PINCTRL_DRIVE7_RSRVD7)
#endif
/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN31_V */

#define BP_PINCTRL_DRIVE7_BANK1_PIN31_V      30
#define BM_PINCTRL_DRIVE7_BANK1_PIN31_V      0x40000000

#define BF_PINCTRL_DRIVE7_BANK1_PIN31_V(v)   (((v) << 30) & BM_PINCTRL_DRIVE7_BANK1_PIN31_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN31_V(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN31_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN31_MA */

#define BP_PINCTRL_DRIVE7_BANK1_PIN31_MA      28
#define BM_PINCTRL_DRIVE7_BANK1_PIN31_MA      0x30000000

#define BF_PINCTRL_DRIVE7_BANK1_PIN31_MA(v)   (((v) << 28) & BM_PINCTRL_DRIVE7_BANK1_PIN31_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN31_MA(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN31_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field RSRVD6 */

#define BP_PINCTRL_DRIVE7_RSRVD6      27
#define BM_PINCTRL_DRIVE7_RSRVD6      0x08000000

#define BF_PINCTRL_DRIVE7_RSRVD6(v)   (((v) << 27) & BM_PINCTRL_DRIVE7_RSRVD6)
/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN30_V */

#define BP_PINCTRL_DRIVE7_BANK1_PIN30_V      26
#define BM_PINCTRL_DRIVE7_BANK1_PIN30_V      0x04000000

#define BF_PINCTRL_DRIVE7_BANK1_PIN30_V(v)   (((v) << 26) & BM_PINCTRL_DRIVE7_BANK1_PIN30_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN30_V(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN30_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN30_MA */

#define BP_PINCTRL_DRIVE7_BANK1_PIN30_MA      24
#define BM_PINCTRL_DRIVE7_BANK1_PIN30_MA      0x03000000

#define BF_PINCTRL_DRIVE7_BANK1_PIN30_MA(v)   (((v) << 24) & BM_PINCTRL_DRIVE7_BANK1_PIN30_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN30_MA(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN30_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field RSRVD5 */

#define BP_PINCTRL_DRIVE7_RSRVD5      23
#define BM_PINCTRL_DRIVE7_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE7_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE7_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN29_V */

#define BP_PINCTRL_DRIVE7_BANK1_PIN29_V      22
#define BM_PINCTRL_DRIVE7_BANK1_PIN29_V      0x00400000

#define BF_PINCTRL_DRIVE7_BANK1_PIN29_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE7_BANK1_PIN29_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN29_V(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN29_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN29_MA */

#define BP_PINCTRL_DRIVE7_BANK1_PIN29_MA      20
#define BM_PINCTRL_DRIVE7_BANK1_PIN29_MA      0x00300000

#define BF_PINCTRL_DRIVE7_BANK1_PIN29_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE7_BANK1_PIN29_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN29_MA(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN29_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field RSRVD4 */

#define BP_PINCTRL_DRIVE7_RSRVD4      19
#define BM_PINCTRL_DRIVE7_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE7_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE7_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN28_V */

#define BP_PINCTRL_DRIVE7_BANK1_PIN28_V      18
#define BM_PINCTRL_DRIVE7_BANK1_PIN28_V      0x00040000

#define BF_PINCTRL_DRIVE7_BANK1_PIN28_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE7_BANK1_PIN28_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN28_V(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN28_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN28_MA */

#define BP_PINCTRL_DRIVE7_BANK1_PIN28_MA      16
#define BM_PINCTRL_DRIVE7_BANK1_PIN28_MA      0x00030000

#define BF_PINCTRL_DRIVE7_BANK1_PIN28_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE7_BANK1_PIN28_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN28_MA(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN28_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field RSRVD3 */

#define BP_PINCTRL_DRIVE7_RSRVD3      15
#define BM_PINCTRL_DRIVE7_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE7_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE7_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN27_V */

#define BP_PINCTRL_DRIVE7_BANK1_PIN27_V      14
#define BM_PINCTRL_DRIVE7_BANK1_PIN27_V      0x00004000

#define BF_PINCTRL_DRIVE7_BANK1_PIN27_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE7_BANK1_PIN27_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN27_V(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN27_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN27_MA */

#define BP_PINCTRL_DRIVE7_BANK1_PIN27_MA      12
#define BM_PINCTRL_DRIVE7_BANK1_PIN27_MA      0x00003000

#define BF_PINCTRL_DRIVE7_BANK1_PIN27_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE7_BANK1_PIN27_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN27_MA(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN27_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field RSRVD2 */

#define BP_PINCTRL_DRIVE7_RSRVD2      11
#define BM_PINCTRL_DRIVE7_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE7_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE7_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN26_V */

#define BP_PINCTRL_DRIVE7_BANK1_PIN26_V      10
#define BM_PINCTRL_DRIVE7_BANK1_PIN26_V      0x00000400

#define BF_PINCTRL_DRIVE7_BANK1_PIN26_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE7_BANK1_PIN26_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN26_V(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN26_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN26_MA */

#define BP_PINCTRL_DRIVE7_BANK1_PIN26_MA      8
#define BM_PINCTRL_DRIVE7_BANK1_PIN26_MA      0x00000300

#define BF_PINCTRL_DRIVE7_BANK1_PIN26_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE7_BANK1_PIN26_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN26_MA(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN26_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field RSRVD1 */

#define BP_PINCTRL_DRIVE7_RSRVD1      7
#define BM_PINCTRL_DRIVE7_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE7_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE7_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN25_V */

#define BP_PINCTRL_DRIVE7_BANK1_PIN25_V      6
#define BM_PINCTRL_DRIVE7_BANK1_PIN25_V      0x00000040

#define BF_PINCTRL_DRIVE7_BANK1_PIN25_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE7_BANK1_PIN25_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN25_V(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN25_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN25_MA */

#define BP_PINCTRL_DRIVE7_BANK1_PIN25_MA      4
#define BM_PINCTRL_DRIVE7_BANK1_PIN25_MA      0x00000030

#define BF_PINCTRL_DRIVE7_BANK1_PIN25_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE7_BANK1_PIN25_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN25_MA(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN25_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field RSRVD0 */

#define BP_PINCTRL_DRIVE7_RSRVD0      3
#define BM_PINCTRL_DRIVE7_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE7_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE7_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN24_V */

#define BP_PINCTRL_DRIVE7_BANK1_PIN24_V      2
#define BM_PINCTRL_DRIVE7_BANK1_PIN24_V      0x00000004

#define BF_PINCTRL_DRIVE7_BANK1_PIN24_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE7_BANK1_PIN24_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN24_V(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN24_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE7, field BANK1_PIN24_MA */

#define BP_PINCTRL_DRIVE7_BANK1_PIN24_MA      0
#define BM_PINCTRL_DRIVE7_BANK1_PIN24_MA      0x00000003

#define BF_PINCTRL_DRIVE7_BANK1_PIN24_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE7_BANK1_PIN24_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE7_BANK1_PIN24_MA(v)   BF_CS1(PINCTRL_DRIVE7, BANK1_PIN24_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE8 - PINCTRL Drive Strength and Voltage Register 8
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK2_PIN00_MA  :  2;
        unsigned BANK2_PIN00_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK2_PIN01_MA  :  2;
        unsigned BANK2_PIN01_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK2_PIN02_MA  :  2;
        unsigned BANK2_PIN02_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK2_PIN03_MA  :  2;
        unsigned BANK2_PIN03_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned BANK2_PIN04_MA  :  2;
        unsigned BANK2_PIN04_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK2_PIN05_MA  :  2;
        unsigned BANK2_PIN05_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned BANK2_PIN06_MA  :  2;
        unsigned BANK2_PIN06_V   :  1;
        unsigned RSRVD6          :  1;
        unsigned BANK2_PIN07_MA  :  2;
        unsigned BANK2_PIN07_V   :  1;
        unsigned RSRVD7          :  1;
    } B;
} hw_pinctrl_drive8_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE8 register
 */
#define HW_PINCTRL_DRIVE8_ADDR         (REGS_PINCTRL_BASE + 0x380)
#define HW_PINCTRL_DRIVE8_SET_ADDR     (HW_PINCTRL_DRIVE8_ADDR + 4)
#define HW_PINCTRL_DRIVE8_CLR_ADDR     (HW_PINCTRL_DRIVE8_ADDR + 8)
#define HW_PINCTRL_DRIVE8_TOG_ADDR     (HW_PINCTRL_DRIVE8_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE8           (*(volatile hw_pinctrl_drive8_t *) HW_PINCTRL_DRIVE8_ADDR)
#define HW_PINCTRL_DRIVE8_RD()      (HW_PINCTRL_DRIVE8.U)
#define HW_PINCTRL_DRIVE8_WR(v)     (HW_PINCTRL_DRIVE8.U = (v))
#define HW_PINCTRL_DRIVE8_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE8_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE8_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE8_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE8_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE8_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE8 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE8, field RSRVD7 */

#define BP_PINCTRL_DRIVE8_RSRVD7      31
#define BM_PINCTRL_DRIVE8_RSRVD7      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE8_RSRVD7(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DRIVE8_RSRVD7)
#else
#define BF_PINCTRL_DRIVE8_RSRVD7(v)   (((v) << 31) & BM_PINCTRL_DRIVE8_RSRVD7)
#endif
/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN07_V */

#define BP_PINCTRL_DRIVE8_BANK2_PIN07_V      30
#define BM_PINCTRL_DRIVE8_BANK2_PIN07_V      0x40000000

#define BF_PINCTRL_DRIVE8_BANK2_PIN07_V(v)   (((v) << 30) & BM_PINCTRL_DRIVE8_BANK2_PIN07_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN07_V(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN07_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN07_MA */

#define BP_PINCTRL_DRIVE8_BANK2_PIN07_MA      28
#define BM_PINCTRL_DRIVE8_BANK2_PIN07_MA      0x30000000

#define BF_PINCTRL_DRIVE8_BANK2_PIN07_MA(v)   (((v) << 28) & BM_PINCTRL_DRIVE8_BANK2_PIN07_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN07_MA(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN07_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field RSRVD6 */

#define BP_PINCTRL_DRIVE8_RSRVD6      27
#define BM_PINCTRL_DRIVE8_RSRVD6      0x08000000

#define BF_PINCTRL_DRIVE8_RSRVD6(v)   (((v) << 27) & BM_PINCTRL_DRIVE8_RSRVD6)
/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN06_V */

#define BP_PINCTRL_DRIVE8_BANK2_PIN06_V      26
#define BM_PINCTRL_DRIVE8_BANK2_PIN06_V      0x04000000

#define BF_PINCTRL_DRIVE8_BANK2_PIN06_V(v)   (((v) << 26) & BM_PINCTRL_DRIVE8_BANK2_PIN06_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN06_V(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN06_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN06_MA */

#define BP_PINCTRL_DRIVE8_BANK2_PIN06_MA      24
#define BM_PINCTRL_DRIVE8_BANK2_PIN06_MA      0x03000000

#define BF_PINCTRL_DRIVE8_BANK2_PIN06_MA(v)   (((v) << 24) & BM_PINCTRL_DRIVE8_BANK2_PIN06_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN06_MA(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN06_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field RSRVD5 */

#define BP_PINCTRL_DRIVE8_RSRVD5      23
#define BM_PINCTRL_DRIVE8_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE8_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE8_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN05_V */

#define BP_PINCTRL_DRIVE8_BANK2_PIN05_V      22
#define BM_PINCTRL_DRIVE8_BANK2_PIN05_V      0x00400000

#define BF_PINCTRL_DRIVE8_BANK2_PIN05_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE8_BANK2_PIN05_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN05_V(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN05_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN05_MA */

#define BP_PINCTRL_DRIVE8_BANK2_PIN05_MA      20
#define BM_PINCTRL_DRIVE8_BANK2_PIN05_MA      0x00300000

#define BF_PINCTRL_DRIVE8_BANK2_PIN05_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE8_BANK2_PIN05_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN05_MA(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN05_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field RSRVD4 */

#define BP_PINCTRL_DRIVE8_RSRVD4      19
#define BM_PINCTRL_DRIVE8_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE8_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE8_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN04_V */

#define BP_PINCTRL_DRIVE8_BANK2_PIN04_V      18
#define BM_PINCTRL_DRIVE8_BANK2_PIN04_V      0x00040000

#define BF_PINCTRL_DRIVE8_BANK2_PIN04_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE8_BANK2_PIN04_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN04_V(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN04_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN04_MA */

#define BP_PINCTRL_DRIVE8_BANK2_PIN04_MA      16
#define BM_PINCTRL_DRIVE8_BANK2_PIN04_MA      0x00030000

#define BF_PINCTRL_DRIVE8_BANK2_PIN04_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE8_BANK2_PIN04_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN04_MA(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN04_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field RSRVD3 */

#define BP_PINCTRL_DRIVE8_RSRVD3      15
#define BM_PINCTRL_DRIVE8_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE8_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE8_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN03_V */

#define BP_PINCTRL_DRIVE8_BANK2_PIN03_V      14
#define BM_PINCTRL_DRIVE8_BANK2_PIN03_V      0x00004000

#define BF_PINCTRL_DRIVE8_BANK2_PIN03_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE8_BANK2_PIN03_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN03_V(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN03_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN03_MA */

#define BP_PINCTRL_DRIVE8_BANK2_PIN03_MA      12
#define BM_PINCTRL_DRIVE8_BANK2_PIN03_MA      0x00003000

#define BF_PINCTRL_DRIVE8_BANK2_PIN03_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE8_BANK2_PIN03_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN03_MA(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN03_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field RSRVD2 */

#define BP_PINCTRL_DRIVE8_RSRVD2      11
#define BM_PINCTRL_DRIVE8_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE8_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE8_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN02_V */

#define BP_PINCTRL_DRIVE8_BANK2_PIN02_V      10
#define BM_PINCTRL_DRIVE8_BANK2_PIN02_V      0x00000400

#define BF_PINCTRL_DRIVE8_BANK2_PIN02_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE8_BANK2_PIN02_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN02_V(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN02_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN02_MA */

#define BP_PINCTRL_DRIVE8_BANK2_PIN02_MA      8
#define BM_PINCTRL_DRIVE8_BANK2_PIN02_MA      0x00000300

#define BF_PINCTRL_DRIVE8_BANK2_PIN02_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE8_BANK2_PIN02_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN02_MA(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN02_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field RSRVD1 */

#define BP_PINCTRL_DRIVE8_RSRVD1      7
#define BM_PINCTRL_DRIVE8_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE8_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE8_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN01_V */

#define BP_PINCTRL_DRIVE8_BANK2_PIN01_V      6
#define BM_PINCTRL_DRIVE8_BANK2_PIN01_V      0x00000040

#define BF_PINCTRL_DRIVE8_BANK2_PIN01_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE8_BANK2_PIN01_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN01_V(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN01_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN01_MA */

#define BP_PINCTRL_DRIVE8_BANK2_PIN01_MA      4
#define BM_PINCTRL_DRIVE8_BANK2_PIN01_MA      0x00000030

#define BF_PINCTRL_DRIVE8_BANK2_PIN01_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE8_BANK2_PIN01_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN01_MA(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN01_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field RSRVD0 */

#define BP_PINCTRL_DRIVE8_RSRVD0      3
#define BM_PINCTRL_DRIVE8_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE8_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE8_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN00_V */

#define BP_PINCTRL_DRIVE8_BANK2_PIN00_V      2
#define BM_PINCTRL_DRIVE8_BANK2_PIN00_V      0x00000004

#define BF_PINCTRL_DRIVE8_BANK2_PIN00_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE8_BANK2_PIN00_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN00_V(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN00_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE8, field BANK2_PIN00_MA */

#define BP_PINCTRL_DRIVE8_BANK2_PIN00_MA      0
#define BM_PINCTRL_DRIVE8_BANK2_PIN00_MA      0x00000003

#define BF_PINCTRL_DRIVE8_BANK2_PIN00_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE8_BANK2_PIN00_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE8_BANK2_PIN00_MA(v)   BF_CS1(PINCTRL_DRIVE8, BANK2_PIN00_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE9 - PINCTRL Drive Strength and Voltage Register 9
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK2_PIN08_MA  :  2;
        unsigned BANK2_PIN08_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK2_PIN09_MA  :  2;
        unsigned BANK2_PIN09_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK2_PIN10_MA  :  2;
        unsigned BANK2_PIN10_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned RSRVD3          :  4;
        unsigned BANK2_PIN12_MA  :  2;
        unsigned BANK2_PIN12_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK2_PIN13_MA  :  2;
        unsigned BANK2_PIN13_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned BANK2_PIN14_MA  :  2;
        unsigned BANK2_PIN14_V   :  1;
        unsigned RSRVD6          :  1;
        unsigned BANK2_PIN15_MA  :  2;
        unsigned BANK2_PIN15_V   :  1;
        unsigned RSRVD7          :  1;
    } B;
} hw_pinctrl_drive9_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE9 register
 */
#define HW_PINCTRL_DRIVE9_ADDR         (REGS_PINCTRL_BASE + 0x390)
#define HW_PINCTRL_DRIVE9_SET_ADDR     (HW_PINCTRL_DRIVE9_ADDR + 4)
#define HW_PINCTRL_DRIVE9_CLR_ADDR     (HW_PINCTRL_DRIVE9_ADDR + 8)
#define HW_PINCTRL_DRIVE9_TOG_ADDR     (HW_PINCTRL_DRIVE9_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE9           (*(volatile hw_pinctrl_drive9_t *) HW_PINCTRL_DRIVE9_ADDR)
#define HW_PINCTRL_DRIVE9_RD()      (HW_PINCTRL_DRIVE9.U)
#define HW_PINCTRL_DRIVE9_WR(v)     (HW_PINCTRL_DRIVE9.U = (v))
#define HW_PINCTRL_DRIVE9_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE9_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE9_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE9_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE9_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE9_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE9 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE9, field RSRVD7 */

#define BP_PINCTRL_DRIVE9_RSRVD7      31
#define BM_PINCTRL_DRIVE9_RSRVD7      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE9_RSRVD7(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DRIVE9_RSRVD7)
#else
#define BF_PINCTRL_DRIVE9_RSRVD7(v)   (((v) << 31) & BM_PINCTRL_DRIVE9_RSRVD7)
#endif
/* --- Register HW_PINCTRL_DRIVE9, field BANK2_PIN15_V */

#define BP_PINCTRL_DRIVE9_BANK2_PIN15_V      30
#define BM_PINCTRL_DRIVE9_BANK2_PIN15_V      0x40000000

#define BF_PINCTRL_DRIVE9_BANK2_PIN15_V(v)   (((v) << 30) & BM_PINCTRL_DRIVE9_BANK2_PIN15_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE9_BANK2_PIN15_V(v)   BF_CS1(PINCTRL_DRIVE9, BANK2_PIN15_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE9, field BANK2_PIN15_MA */

#define BP_PINCTRL_DRIVE9_BANK2_PIN15_MA      28
#define BM_PINCTRL_DRIVE9_BANK2_PIN15_MA      0x30000000

#define BF_PINCTRL_DRIVE9_BANK2_PIN15_MA(v)   (((v) << 28) & BM_PINCTRL_DRIVE9_BANK2_PIN15_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE9_BANK2_PIN15_MA(v)   BF_CS1(PINCTRL_DRIVE9, BANK2_PIN15_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE9, field RSRVD6 */

#define BP_PINCTRL_DRIVE9_RSRVD6      27
#define BM_PINCTRL_DRIVE9_RSRVD6      0x08000000

#define BF_PINCTRL_DRIVE9_RSRVD6(v)   (((v) << 27) & BM_PINCTRL_DRIVE9_RSRVD6)
/* --- Register HW_PINCTRL_DRIVE9, field BANK2_PIN14_V */

#define BP_PINCTRL_DRIVE9_BANK2_PIN14_V      26
#define BM_PINCTRL_DRIVE9_BANK2_PIN14_V      0x04000000

#define BF_PINCTRL_DRIVE9_BANK2_PIN14_V(v)   (((v) << 26) & BM_PINCTRL_DRIVE9_BANK2_PIN14_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE9_BANK2_PIN14_V(v)   BF_CS1(PINCTRL_DRIVE9, BANK2_PIN14_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE9, field BANK2_PIN14_MA */

#define BP_PINCTRL_DRIVE9_BANK2_PIN14_MA      24
#define BM_PINCTRL_DRIVE9_BANK2_PIN14_MA      0x03000000

#define BF_PINCTRL_DRIVE9_BANK2_PIN14_MA(v)   (((v) << 24) & BM_PINCTRL_DRIVE9_BANK2_PIN14_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE9_BANK2_PIN14_MA(v)   BF_CS1(PINCTRL_DRIVE9, BANK2_PIN14_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE9, field RSRVD5 */

#define BP_PINCTRL_DRIVE9_RSRVD5      23
#define BM_PINCTRL_DRIVE9_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE9_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE9_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE9, field BANK2_PIN13_V */

#define BP_PINCTRL_DRIVE9_BANK2_PIN13_V      22
#define BM_PINCTRL_DRIVE9_BANK2_PIN13_V      0x00400000

#define BF_PINCTRL_DRIVE9_BANK2_PIN13_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE9_BANK2_PIN13_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE9_BANK2_PIN13_V(v)   BF_CS1(PINCTRL_DRIVE9, BANK2_PIN13_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE9, field BANK2_PIN13_MA */

#define BP_PINCTRL_DRIVE9_BANK2_PIN13_MA      20
#define BM_PINCTRL_DRIVE9_BANK2_PIN13_MA      0x00300000

#define BF_PINCTRL_DRIVE9_BANK2_PIN13_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE9_BANK2_PIN13_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE9_BANK2_PIN13_MA(v)   BF_CS1(PINCTRL_DRIVE9, BANK2_PIN13_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE9, field RSRVD4 */

#define BP_PINCTRL_DRIVE9_RSRVD4      19
#define BM_PINCTRL_DRIVE9_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE9_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE9_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE9, field BANK2_PIN12_V */

#define BP_PINCTRL_DRIVE9_BANK2_PIN12_V      18
#define BM_PINCTRL_DRIVE9_BANK2_PIN12_V      0x00040000

#define BF_PINCTRL_DRIVE9_BANK2_PIN12_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE9_BANK2_PIN12_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE9_BANK2_PIN12_V(v)   BF_CS1(PINCTRL_DRIVE9, BANK2_PIN12_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE9, field BANK2_PIN12_MA */

#define BP_PINCTRL_DRIVE9_BANK2_PIN12_MA      16
#define BM_PINCTRL_DRIVE9_BANK2_PIN12_MA      0x00030000

#define BF_PINCTRL_DRIVE9_BANK2_PIN12_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE9_BANK2_PIN12_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE9_BANK2_PIN12_MA(v)   BF_CS1(PINCTRL_DRIVE9, BANK2_PIN12_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE9, field RSRVD3 */

#define BP_PINCTRL_DRIVE9_RSRVD3      12
#define BM_PINCTRL_DRIVE9_RSRVD3      0x0000F000

#define BF_PINCTRL_DRIVE9_RSRVD3(v)   (((v) << 12) & BM_PINCTRL_DRIVE9_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE9, field RSRVD2 */

#define BP_PINCTRL_DRIVE9_RSRVD2      11
#define BM_PINCTRL_DRIVE9_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE9_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE9_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE9, field BANK2_PIN10_V */

#define BP_PINCTRL_DRIVE9_BANK2_PIN10_V      10
#define BM_PINCTRL_DRIVE9_BANK2_PIN10_V      0x00000400

#define BF_PINCTRL_DRIVE9_BANK2_PIN10_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE9_BANK2_PIN10_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE9_BANK2_PIN10_V(v)   BF_CS1(PINCTRL_DRIVE9, BANK2_PIN10_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE9, field BANK2_PIN10_MA */

#define BP_PINCTRL_DRIVE9_BANK2_PIN10_MA      8
#define BM_PINCTRL_DRIVE9_BANK2_PIN10_MA      0x00000300

#define BF_PINCTRL_DRIVE9_BANK2_PIN10_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE9_BANK2_PIN10_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE9_BANK2_PIN10_MA(v)   BF_CS1(PINCTRL_DRIVE9, BANK2_PIN10_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE9, field RSRVD1 */

#define BP_PINCTRL_DRIVE9_RSRVD1      7
#define BM_PINCTRL_DRIVE9_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE9_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE9_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE9, field BANK2_PIN09_V */

#define BP_PINCTRL_DRIVE9_BANK2_PIN09_V      6
#define BM_PINCTRL_DRIVE9_BANK2_PIN09_V      0x00000040

#define BF_PINCTRL_DRIVE9_BANK2_PIN09_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE9_BANK2_PIN09_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE9_BANK2_PIN09_V(v)   BF_CS1(PINCTRL_DRIVE9, BANK2_PIN09_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE9, field BANK2_PIN09_MA */

#define BP_PINCTRL_DRIVE9_BANK2_PIN09_MA      4
#define BM_PINCTRL_DRIVE9_BANK2_PIN09_MA      0x00000030

#define BF_PINCTRL_DRIVE9_BANK2_PIN09_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE9_BANK2_PIN09_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE9_BANK2_PIN09_MA(v)   BF_CS1(PINCTRL_DRIVE9, BANK2_PIN09_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE9, field RSRVD0 */

#define BP_PINCTRL_DRIVE9_RSRVD0      3
#define BM_PINCTRL_DRIVE9_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE9_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE9_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE9, field BANK2_PIN08_V */

#define BP_PINCTRL_DRIVE9_BANK2_PIN08_V      2
#define BM_PINCTRL_DRIVE9_BANK2_PIN08_V      0x00000004

#define BF_PINCTRL_DRIVE9_BANK2_PIN08_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE9_BANK2_PIN08_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE9_BANK2_PIN08_V(v)   BF_CS1(PINCTRL_DRIVE9, BANK2_PIN08_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE9, field BANK2_PIN08_MA */

#define BP_PINCTRL_DRIVE9_BANK2_PIN08_MA      0
#define BM_PINCTRL_DRIVE9_BANK2_PIN08_MA      0x00000003

#define BF_PINCTRL_DRIVE9_BANK2_PIN08_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE9_BANK2_PIN08_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE9_BANK2_PIN08_MA(v)   BF_CS1(PINCTRL_DRIVE9, BANK2_PIN08_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE10 - PINCTRL Drive Strength and Voltage Register 10
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK2_PIN16_MA  :  2;
        unsigned BANK2_PIN16_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK2_PIN17_MA  :  2;
        unsigned BANK2_PIN17_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK2_PIN18_MA  :  2;
        unsigned BANK2_PIN18_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK2_PIN19_MA  :  2;
        unsigned BANK2_PIN19_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned BANK2_PIN20_MA  :  2;
        unsigned BANK2_PIN20_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK2_PIN21_MA  :  2;
        unsigned BANK2_PIN21_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned RSRVD6          :  8;
    } B;
} hw_pinctrl_drive10_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE10 register
 */
#define HW_PINCTRL_DRIVE10_ADDR         (REGS_PINCTRL_BASE + 0x3a0)
#define HW_PINCTRL_DRIVE10_SET_ADDR     (HW_PINCTRL_DRIVE10_ADDR + 4)
#define HW_PINCTRL_DRIVE10_CLR_ADDR     (HW_PINCTRL_DRIVE10_ADDR + 8)
#define HW_PINCTRL_DRIVE10_TOG_ADDR     (HW_PINCTRL_DRIVE10_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE10           (*(volatile hw_pinctrl_drive10_t *) HW_PINCTRL_DRIVE10_ADDR)
#define HW_PINCTRL_DRIVE10_RD()      (HW_PINCTRL_DRIVE10.U)
#define HW_PINCTRL_DRIVE10_WR(v)     (HW_PINCTRL_DRIVE10.U = (v))
#define HW_PINCTRL_DRIVE10_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE10_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE10_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE10_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE10_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE10_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE10 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE10, field RSRVD6 */

#define BP_PINCTRL_DRIVE10_RSRVD6      24
#define BM_PINCTRL_DRIVE10_RSRVD6      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE10_RSRVD6(v)   ((((reg32_t) v) << 24) & BM_PINCTRL_DRIVE10_RSRVD6)
#else
#define BF_PINCTRL_DRIVE10_RSRVD6(v)   (((v) << 24) & BM_PINCTRL_DRIVE10_RSRVD6)
#endif
/* --- Register HW_PINCTRL_DRIVE10, field RSRVD5 */

#define BP_PINCTRL_DRIVE10_RSRVD5      23
#define BM_PINCTRL_DRIVE10_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE10_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE10_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE10, field BANK2_PIN21_V */

#define BP_PINCTRL_DRIVE10_BANK2_PIN21_V      22
#define BM_PINCTRL_DRIVE10_BANK2_PIN21_V      0x00400000

#define BF_PINCTRL_DRIVE10_BANK2_PIN21_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE10_BANK2_PIN21_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE10_BANK2_PIN21_V(v)   BF_CS1(PINCTRL_DRIVE10, BANK2_PIN21_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE10, field BANK2_PIN21_MA */

#define BP_PINCTRL_DRIVE10_BANK2_PIN21_MA      20
#define BM_PINCTRL_DRIVE10_BANK2_PIN21_MA      0x00300000

#define BF_PINCTRL_DRIVE10_BANK2_PIN21_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE10_BANK2_PIN21_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE10_BANK2_PIN21_MA(v)   BF_CS1(PINCTRL_DRIVE10, BANK2_PIN21_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE10, field RSRVD4 */

#define BP_PINCTRL_DRIVE10_RSRVD4      19
#define BM_PINCTRL_DRIVE10_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE10_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE10_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE10, field BANK2_PIN20_V */

#define BP_PINCTRL_DRIVE10_BANK2_PIN20_V      18
#define BM_PINCTRL_DRIVE10_BANK2_PIN20_V      0x00040000

#define BF_PINCTRL_DRIVE10_BANK2_PIN20_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE10_BANK2_PIN20_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE10_BANK2_PIN20_V(v)   BF_CS1(PINCTRL_DRIVE10, BANK2_PIN20_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE10, field BANK2_PIN20_MA */

#define BP_PINCTRL_DRIVE10_BANK2_PIN20_MA      16
#define BM_PINCTRL_DRIVE10_BANK2_PIN20_MA      0x00030000

#define BF_PINCTRL_DRIVE10_BANK2_PIN20_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE10_BANK2_PIN20_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE10_BANK2_PIN20_MA(v)   BF_CS1(PINCTRL_DRIVE10, BANK2_PIN20_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE10, field RSRVD3 */

#define BP_PINCTRL_DRIVE10_RSRVD3      15
#define BM_PINCTRL_DRIVE10_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE10_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE10_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE10, field BANK2_PIN19_V */

#define BP_PINCTRL_DRIVE10_BANK2_PIN19_V      14
#define BM_PINCTRL_DRIVE10_BANK2_PIN19_V      0x00004000

#define BF_PINCTRL_DRIVE10_BANK2_PIN19_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE10_BANK2_PIN19_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE10_BANK2_PIN19_V(v)   BF_CS1(PINCTRL_DRIVE10, BANK2_PIN19_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE10, field BANK2_PIN19_MA */

#define BP_PINCTRL_DRIVE10_BANK2_PIN19_MA      12
#define BM_PINCTRL_DRIVE10_BANK2_PIN19_MA      0x00003000

#define BF_PINCTRL_DRIVE10_BANK2_PIN19_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE10_BANK2_PIN19_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE10_BANK2_PIN19_MA(v)   BF_CS1(PINCTRL_DRIVE10, BANK2_PIN19_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE10, field RSRVD2 */

#define BP_PINCTRL_DRIVE10_RSRVD2      11
#define BM_PINCTRL_DRIVE10_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE10_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE10_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE10, field BANK2_PIN18_V */

#define BP_PINCTRL_DRIVE10_BANK2_PIN18_V      10
#define BM_PINCTRL_DRIVE10_BANK2_PIN18_V      0x00000400

#define BF_PINCTRL_DRIVE10_BANK2_PIN18_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE10_BANK2_PIN18_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE10_BANK2_PIN18_V(v)   BF_CS1(PINCTRL_DRIVE10, BANK2_PIN18_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE10, field BANK2_PIN18_MA */

#define BP_PINCTRL_DRIVE10_BANK2_PIN18_MA      8
#define BM_PINCTRL_DRIVE10_BANK2_PIN18_MA      0x00000300

#define BF_PINCTRL_DRIVE10_BANK2_PIN18_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE10_BANK2_PIN18_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE10_BANK2_PIN18_MA(v)   BF_CS1(PINCTRL_DRIVE10, BANK2_PIN18_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE10, field RSRVD1 */

#define BP_PINCTRL_DRIVE10_RSRVD1      7
#define BM_PINCTRL_DRIVE10_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE10_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE10_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE10, field BANK2_PIN17_V */

#define BP_PINCTRL_DRIVE10_BANK2_PIN17_V      6
#define BM_PINCTRL_DRIVE10_BANK2_PIN17_V      0x00000040

#define BF_PINCTRL_DRIVE10_BANK2_PIN17_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE10_BANK2_PIN17_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE10_BANK2_PIN17_V(v)   BF_CS1(PINCTRL_DRIVE10, BANK2_PIN17_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE10, field BANK2_PIN17_MA */

#define BP_PINCTRL_DRIVE10_BANK2_PIN17_MA      4
#define BM_PINCTRL_DRIVE10_BANK2_PIN17_MA      0x00000030

#define BF_PINCTRL_DRIVE10_BANK2_PIN17_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE10_BANK2_PIN17_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE10_BANK2_PIN17_MA(v)   BF_CS1(PINCTRL_DRIVE10, BANK2_PIN17_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE10, field RSRVD0 */

#define BP_PINCTRL_DRIVE10_RSRVD0      3
#define BM_PINCTRL_DRIVE10_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE10_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE10_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE10, field BANK2_PIN16_V */

#define BP_PINCTRL_DRIVE10_BANK2_PIN16_V      2
#define BM_PINCTRL_DRIVE10_BANK2_PIN16_V      0x00000004

#define BF_PINCTRL_DRIVE10_BANK2_PIN16_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE10_BANK2_PIN16_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE10_BANK2_PIN16_V(v)   BF_CS1(PINCTRL_DRIVE10, BANK2_PIN16_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE10, field BANK2_PIN16_MA */

#define BP_PINCTRL_DRIVE10_BANK2_PIN16_MA      0
#define BM_PINCTRL_DRIVE10_BANK2_PIN16_MA      0x00000003

#define BF_PINCTRL_DRIVE10_BANK2_PIN16_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE10_BANK2_PIN16_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE10_BANK2_PIN16_MA(v)   BF_CS1(PINCTRL_DRIVE10, BANK2_PIN16_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE11 - PINCTRL Drive Strength and Voltage Register 11
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK2_PIN24_MA  :  2;
        unsigned BANK2_PIN24_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK2_PIN25_MA  :  2;
        unsigned BANK2_PIN25_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK2_PIN26_MA  :  2;
        unsigned BANK2_PIN26_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK2_PIN27_MA  :  2;
        unsigned BANK2_PIN27_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned RSRVD4          : 16;
    } B;
} hw_pinctrl_drive11_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE11 register
 */
#define HW_PINCTRL_DRIVE11_ADDR         (REGS_PINCTRL_BASE + 0x3b0)
#define HW_PINCTRL_DRIVE11_SET_ADDR     (HW_PINCTRL_DRIVE11_ADDR + 4)
#define HW_PINCTRL_DRIVE11_CLR_ADDR     (HW_PINCTRL_DRIVE11_ADDR + 8)
#define HW_PINCTRL_DRIVE11_TOG_ADDR     (HW_PINCTRL_DRIVE11_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE11           (*(volatile hw_pinctrl_drive11_t *) HW_PINCTRL_DRIVE11_ADDR)
#define HW_PINCTRL_DRIVE11_RD()      (HW_PINCTRL_DRIVE11.U)
#define HW_PINCTRL_DRIVE11_WR(v)     (HW_PINCTRL_DRIVE11.U = (v))
#define HW_PINCTRL_DRIVE11_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE11_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE11_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE11_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE11_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE11_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE11 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE11, field RSRVD4 */

#define BP_PINCTRL_DRIVE11_RSRVD4      16
#define BM_PINCTRL_DRIVE11_RSRVD4      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE11_RSRVD4(v)   ((((reg32_t) v) << 16) & BM_PINCTRL_DRIVE11_RSRVD4)
#else
#define BF_PINCTRL_DRIVE11_RSRVD4(v)   (((v) << 16) & BM_PINCTRL_DRIVE11_RSRVD4)
#endif
/* --- Register HW_PINCTRL_DRIVE11, field RSRVD3 */

#define BP_PINCTRL_DRIVE11_RSRVD3      15
#define BM_PINCTRL_DRIVE11_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE11_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE11_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE11, field BANK2_PIN27_V */

#define BP_PINCTRL_DRIVE11_BANK2_PIN27_V      14
#define BM_PINCTRL_DRIVE11_BANK2_PIN27_V      0x00004000

#define BF_PINCTRL_DRIVE11_BANK2_PIN27_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE11_BANK2_PIN27_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE11_BANK2_PIN27_V(v)   BF_CS1(PINCTRL_DRIVE11, BANK2_PIN27_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE11, field BANK2_PIN27_MA */

#define BP_PINCTRL_DRIVE11_BANK2_PIN27_MA      12
#define BM_PINCTRL_DRIVE11_BANK2_PIN27_MA      0x00003000

#define BF_PINCTRL_DRIVE11_BANK2_PIN27_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE11_BANK2_PIN27_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE11_BANK2_PIN27_MA(v)   BF_CS1(PINCTRL_DRIVE11, BANK2_PIN27_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE11, field RSRVD2 */

#define BP_PINCTRL_DRIVE11_RSRVD2      11
#define BM_PINCTRL_DRIVE11_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE11_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE11_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE11, field BANK2_PIN26_V */

#define BP_PINCTRL_DRIVE11_BANK2_PIN26_V      10
#define BM_PINCTRL_DRIVE11_BANK2_PIN26_V      0x00000400

#define BF_PINCTRL_DRIVE11_BANK2_PIN26_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE11_BANK2_PIN26_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE11_BANK2_PIN26_V(v)   BF_CS1(PINCTRL_DRIVE11, BANK2_PIN26_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE11, field BANK2_PIN26_MA */

#define BP_PINCTRL_DRIVE11_BANK2_PIN26_MA      8
#define BM_PINCTRL_DRIVE11_BANK2_PIN26_MA      0x00000300

#define BF_PINCTRL_DRIVE11_BANK2_PIN26_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE11_BANK2_PIN26_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE11_BANK2_PIN26_MA(v)   BF_CS1(PINCTRL_DRIVE11, BANK2_PIN26_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE11, field RSRVD1 */

#define BP_PINCTRL_DRIVE11_RSRVD1      7
#define BM_PINCTRL_DRIVE11_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE11_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE11_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE11, field BANK2_PIN25_V */

#define BP_PINCTRL_DRIVE11_BANK2_PIN25_V      6
#define BM_PINCTRL_DRIVE11_BANK2_PIN25_V      0x00000040

#define BF_PINCTRL_DRIVE11_BANK2_PIN25_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE11_BANK2_PIN25_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE11_BANK2_PIN25_V(v)   BF_CS1(PINCTRL_DRIVE11, BANK2_PIN25_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE11, field BANK2_PIN25_MA */

#define BP_PINCTRL_DRIVE11_BANK2_PIN25_MA      4
#define BM_PINCTRL_DRIVE11_BANK2_PIN25_MA      0x00000030

#define BF_PINCTRL_DRIVE11_BANK2_PIN25_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE11_BANK2_PIN25_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE11_BANK2_PIN25_MA(v)   BF_CS1(PINCTRL_DRIVE11, BANK2_PIN25_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE11, field RSRVD0 */

#define BP_PINCTRL_DRIVE11_RSRVD0      3
#define BM_PINCTRL_DRIVE11_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE11_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE11_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE11, field BANK2_PIN24_V */

#define BP_PINCTRL_DRIVE11_BANK2_PIN24_V      2
#define BM_PINCTRL_DRIVE11_BANK2_PIN24_V      0x00000004

#define BF_PINCTRL_DRIVE11_BANK2_PIN24_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE11_BANK2_PIN24_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE11_BANK2_PIN24_V(v)   BF_CS1(PINCTRL_DRIVE11, BANK2_PIN24_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE11, field BANK2_PIN24_MA */

#define BP_PINCTRL_DRIVE11_BANK2_PIN24_MA      0
#define BM_PINCTRL_DRIVE11_BANK2_PIN24_MA      0x00000003

#define BF_PINCTRL_DRIVE11_BANK2_PIN24_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE11_BANK2_PIN24_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE11_BANK2_PIN24_MA(v)   BF_CS1(PINCTRL_DRIVE11, BANK2_PIN24_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE12 - PINCTRL Drive Strength and Voltage Register 12
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK3_PIN00_MA  :  2;
        unsigned BANK3_PIN00_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK3_PIN01_MA  :  2;
        unsigned BANK3_PIN01_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK3_PIN02_MA  :  2;
        unsigned BANK3_PIN02_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK3_PIN03_MA  :  2;
        unsigned BANK3_PIN03_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned BANK3_PIN04_MA  :  2;
        unsigned BANK3_PIN04_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK3_PIN05_MA  :  2;
        unsigned BANK3_PIN05_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned BANK3_PIN06_MA  :  2;
        unsigned BANK3_PIN06_V   :  1;
        unsigned RSRVD6          :  1;
        unsigned BANK3_PIN07_MA  :  2;
        unsigned BANK3_PIN07_V   :  1;
        unsigned RSRVD7          :  1;
    } B;
} hw_pinctrl_drive12_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE12 register
 */
#define HW_PINCTRL_DRIVE12_ADDR         (REGS_PINCTRL_BASE + 0x3c0)
#define HW_PINCTRL_DRIVE12_SET_ADDR     (HW_PINCTRL_DRIVE12_ADDR + 4)
#define HW_PINCTRL_DRIVE12_CLR_ADDR     (HW_PINCTRL_DRIVE12_ADDR + 8)
#define HW_PINCTRL_DRIVE12_TOG_ADDR     (HW_PINCTRL_DRIVE12_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE12           (*(volatile hw_pinctrl_drive12_t *) HW_PINCTRL_DRIVE12_ADDR)
#define HW_PINCTRL_DRIVE12_RD()      (HW_PINCTRL_DRIVE12.U)
#define HW_PINCTRL_DRIVE12_WR(v)     (HW_PINCTRL_DRIVE12.U = (v))
#define HW_PINCTRL_DRIVE12_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE12_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE12_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE12_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE12_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE12_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE12 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE12, field RSRVD7 */

#define BP_PINCTRL_DRIVE12_RSRVD7      31
#define BM_PINCTRL_DRIVE12_RSRVD7      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE12_RSRVD7(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DRIVE12_RSRVD7)
#else
#define BF_PINCTRL_DRIVE12_RSRVD7(v)   (((v) << 31) & BM_PINCTRL_DRIVE12_RSRVD7)
#endif
/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN07_V */

#define BP_PINCTRL_DRIVE12_BANK3_PIN07_V      30
#define BM_PINCTRL_DRIVE12_BANK3_PIN07_V      0x40000000

#define BF_PINCTRL_DRIVE12_BANK3_PIN07_V(v)   (((v) << 30) & BM_PINCTRL_DRIVE12_BANK3_PIN07_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN07_V(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN07_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN07_MA */

#define BP_PINCTRL_DRIVE12_BANK3_PIN07_MA      28
#define BM_PINCTRL_DRIVE12_BANK3_PIN07_MA      0x30000000

#define BF_PINCTRL_DRIVE12_BANK3_PIN07_MA(v)   (((v) << 28) & BM_PINCTRL_DRIVE12_BANK3_PIN07_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN07_MA(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN07_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field RSRVD6 */

#define BP_PINCTRL_DRIVE12_RSRVD6      27
#define BM_PINCTRL_DRIVE12_RSRVD6      0x08000000

#define BF_PINCTRL_DRIVE12_RSRVD6(v)   (((v) << 27) & BM_PINCTRL_DRIVE12_RSRVD6)
/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN06_V */

#define BP_PINCTRL_DRIVE12_BANK3_PIN06_V      26
#define BM_PINCTRL_DRIVE12_BANK3_PIN06_V      0x04000000

#define BF_PINCTRL_DRIVE12_BANK3_PIN06_V(v)   (((v) << 26) & BM_PINCTRL_DRIVE12_BANK3_PIN06_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN06_V(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN06_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN06_MA */

#define BP_PINCTRL_DRIVE12_BANK3_PIN06_MA      24
#define BM_PINCTRL_DRIVE12_BANK3_PIN06_MA      0x03000000

#define BF_PINCTRL_DRIVE12_BANK3_PIN06_MA(v)   (((v) << 24) & BM_PINCTRL_DRIVE12_BANK3_PIN06_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN06_MA(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN06_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field RSRVD5 */

#define BP_PINCTRL_DRIVE12_RSRVD5      23
#define BM_PINCTRL_DRIVE12_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE12_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE12_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN05_V */

#define BP_PINCTRL_DRIVE12_BANK3_PIN05_V      22
#define BM_PINCTRL_DRIVE12_BANK3_PIN05_V      0x00400000

#define BF_PINCTRL_DRIVE12_BANK3_PIN05_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE12_BANK3_PIN05_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN05_V(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN05_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN05_MA */

#define BP_PINCTRL_DRIVE12_BANK3_PIN05_MA      20
#define BM_PINCTRL_DRIVE12_BANK3_PIN05_MA      0x00300000

#define BF_PINCTRL_DRIVE12_BANK3_PIN05_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE12_BANK3_PIN05_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN05_MA(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN05_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field RSRVD4 */

#define BP_PINCTRL_DRIVE12_RSRVD4      19
#define BM_PINCTRL_DRIVE12_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE12_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE12_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN04_V */

#define BP_PINCTRL_DRIVE12_BANK3_PIN04_V      18
#define BM_PINCTRL_DRIVE12_BANK3_PIN04_V      0x00040000

#define BF_PINCTRL_DRIVE12_BANK3_PIN04_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE12_BANK3_PIN04_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN04_V(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN04_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN04_MA */

#define BP_PINCTRL_DRIVE12_BANK3_PIN04_MA      16
#define BM_PINCTRL_DRIVE12_BANK3_PIN04_MA      0x00030000

#define BF_PINCTRL_DRIVE12_BANK3_PIN04_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE12_BANK3_PIN04_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN04_MA(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN04_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field RSRVD3 */

#define BP_PINCTRL_DRIVE12_RSRVD3      15
#define BM_PINCTRL_DRIVE12_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE12_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE12_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN03_V */

#define BP_PINCTRL_DRIVE12_BANK3_PIN03_V      14
#define BM_PINCTRL_DRIVE12_BANK3_PIN03_V      0x00004000

#define BF_PINCTRL_DRIVE12_BANK3_PIN03_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE12_BANK3_PIN03_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN03_V(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN03_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN03_MA */

#define BP_PINCTRL_DRIVE12_BANK3_PIN03_MA      12
#define BM_PINCTRL_DRIVE12_BANK3_PIN03_MA      0x00003000

#define BF_PINCTRL_DRIVE12_BANK3_PIN03_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE12_BANK3_PIN03_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN03_MA(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN03_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field RSRVD2 */

#define BP_PINCTRL_DRIVE12_RSRVD2      11
#define BM_PINCTRL_DRIVE12_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE12_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE12_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN02_V */

#define BP_PINCTRL_DRIVE12_BANK3_PIN02_V      10
#define BM_PINCTRL_DRIVE12_BANK3_PIN02_V      0x00000400

#define BF_PINCTRL_DRIVE12_BANK3_PIN02_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE12_BANK3_PIN02_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN02_V(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN02_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN02_MA */

#define BP_PINCTRL_DRIVE12_BANK3_PIN02_MA      8
#define BM_PINCTRL_DRIVE12_BANK3_PIN02_MA      0x00000300

#define BF_PINCTRL_DRIVE12_BANK3_PIN02_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE12_BANK3_PIN02_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN02_MA(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN02_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field RSRVD1 */

#define BP_PINCTRL_DRIVE12_RSRVD1      7
#define BM_PINCTRL_DRIVE12_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE12_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE12_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN01_V */

#define BP_PINCTRL_DRIVE12_BANK3_PIN01_V      6
#define BM_PINCTRL_DRIVE12_BANK3_PIN01_V      0x00000040

#define BF_PINCTRL_DRIVE12_BANK3_PIN01_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE12_BANK3_PIN01_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN01_V(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN01_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN01_MA */

#define BP_PINCTRL_DRIVE12_BANK3_PIN01_MA      4
#define BM_PINCTRL_DRIVE12_BANK3_PIN01_MA      0x00000030

#define BF_PINCTRL_DRIVE12_BANK3_PIN01_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE12_BANK3_PIN01_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN01_MA(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN01_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field RSRVD0 */

#define BP_PINCTRL_DRIVE12_RSRVD0      3
#define BM_PINCTRL_DRIVE12_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE12_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE12_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN00_V */

#define BP_PINCTRL_DRIVE12_BANK3_PIN00_V      2
#define BM_PINCTRL_DRIVE12_BANK3_PIN00_V      0x00000004

#define BF_PINCTRL_DRIVE12_BANK3_PIN00_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE12_BANK3_PIN00_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN00_V(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN00_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE12, field BANK3_PIN00_MA */

#define BP_PINCTRL_DRIVE12_BANK3_PIN00_MA      0
#define BM_PINCTRL_DRIVE12_BANK3_PIN00_MA      0x00000003

#define BF_PINCTRL_DRIVE12_BANK3_PIN00_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE12_BANK3_PIN00_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE12_BANK3_PIN00_MA(v)   BF_CS1(PINCTRL_DRIVE12, BANK3_PIN00_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE13 - PINCTRL Drive Strength and Voltage Register 13
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK3_PIN08_MA  :  2;
        unsigned BANK3_PIN08_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK3_PIN09_MA  :  2;
        unsigned BANK3_PIN09_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK3_PIN10_MA  :  2;
        unsigned BANK3_PIN10_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK3_PIN11_MA  :  2;
        unsigned BANK3_PIN11_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned BANK3_PIN12_MA  :  2;
        unsigned BANK3_PIN12_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK3_PIN13_MA  :  2;
        unsigned BANK3_PIN13_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned BANK3_PIN14_MA  :  2;
        unsigned BANK3_PIN14_V   :  1;
        unsigned RSRVD6          :  1;
        unsigned BANK3_PIN15_MA  :  2;
        unsigned BANK3_PIN15_V   :  1;
        unsigned RSRVD7          :  1;
    } B;
} hw_pinctrl_drive13_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE13 register
 */
#define HW_PINCTRL_DRIVE13_ADDR         (REGS_PINCTRL_BASE + 0x3d0)
#define HW_PINCTRL_DRIVE13_SET_ADDR     (HW_PINCTRL_DRIVE13_ADDR + 4)
#define HW_PINCTRL_DRIVE13_CLR_ADDR     (HW_PINCTRL_DRIVE13_ADDR + 8)
#define HW_PINCTRL_DRIVE13_TOG_ADDR     (HW_PINCTRL_DRIVE13_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE13           (*(volatile hw_pinctrl_drive13_t *) HW_PINCTRL_DRIVE13_ADDR)
#define HW_PINCTRL_DRIVE13_RD()      (HW_PINCTRL_DRIVE13.U)
#define HW_PINCTRL_DRIVE13_WR(v)     (HW_PINCTRL_DRIVE13.U = (v))
#define HW_PINCTRL_DRIVE13_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE13_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE13_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE13_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE13_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE13_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE13 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE13, field RSRVD7 */

#define BP_PINCTRL_DRIVE13_RSRVD7      31
#define BM_PINCTRL_DRIVE13_RSRVD7      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE13_RSRVD7(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DRIVE13_RSRVD7)
#else
#define BF_PINCTRL_DRIVE13_RSRVD7(v)   (((v) << 31) & BM_PINCTRL_DRIVE13_RSRVD7)
#endif
/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN15_V */

#define BP_PINCTRL_DRIVE13_BANK3_PIN15_V      30
#define BM_PINCTRL_DRIVE13_BANK3_PIN15_V      0x40000000

#define BF_PINCTRL_DRIVE13_BANK3_PIN15_V(v)   (((v) << 30) & BM_PINCTRL_DRIVE13_BANK3_PIN15_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN15_V(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN15_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN15_MA */

#define BP_PINCTRL_DRIVE13_BANK3_PIN15_MA      28
#define BM_PINCTRL_DRIVE13_BANK3_PIN15_MA      0x30000000

#define BF_PINCTRL_DRIVE13_BANK3_PIN15_MA(v)   (((v) << 28) & BM_PINCTRL_DRIVE13_BANK3_PIN15_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN15_MA(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN15_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field RSRVD6 */

#define BP_PINCTRL_DRIVE13_RSRVD6      27
#define BM_PINCTRL_DRIVE13_RSRVD6      0x08000000

#define BF_PINCTRL_DRIVE13_RSRVD6(v)   (((v) << 27) & BM_PINCTRL_DRIVE13_RSRVD6)
/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN14_V */

#define BP_PINCTRL_DRIVE13_BANK3_PIN14_V      26
#define BM_PINCTRL_DRIVE13_BANK3_PIN14_V      0x04000000

#define BF_PINCTRL_DRIVE13_BANK3_PIN14_V(v)   (((v) << 26) & BM_PINCTRL_DRIVE13_BANK3_PIN14_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN14_V(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN14_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN14_MA */

#define BP_PINCTRL_DRIVE13_BANK3_PIN14_MA      24
#define BM_PINCTRL_DRIVE13_BANK3_PIN14_MA      0x03000000

#define BF_PINCTRL_DRIVE13_BANK3_PIN14_MA(v)   (((v) << 24) & BM_PINCTRL_DRIVE13_BANK3_PIN14_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN14_MA(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN14_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field RSRVD5 */

#define BP_PINCTRL_DRIVE13_RSRVD5      23
#define BM_PINCTRL_DRIVE13_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE13_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE13_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN13_V */

#define BP_PINCTRL_DRIVE13_BANK3_PIN13_V      22
#define BM_PINCTRL_DRIVE13_BANK3_PIN13_V      0x00400000

#define BF_PINCTRL_DRIVE13_BANK3_PIN13_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE13_BANK3_PIN13_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN13_V(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN13_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN13_MA */

#define BP_PINCTRL_DRIVE13_BANK3_PIN13_MA      20
#define BM_PINCTRL_DRIVE13_BANK3_PIN13_MA      0x00300000

#define BF_PINCTRL_DRIVE13_BANK3_PIN13_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE13_BANK3_PIN13_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN13_MA(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN13_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field RSRVD4 */

#define BP_PINCTRL_DRIVE13_RSRVD4      19
#define BM_PINCTRL_DRIVE13_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE13_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE13_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN12_V */

#define BP_PINCTRL_DRIVE13_BANK3_PIN12_V      18
#define BM_PINCTRL_DRIVE13_BANK3_PIN12_V      0x00040000

#define BF_PINCTRL_DRIVE13_BANK3_PIN12_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE13_BANK3_PIN12_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN12_V(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN12_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN12_MA */

#define BP_PINCTRL_DRIVE13_BANK3_PIN12_MA      16
#define BM_PINCTRL_DRIVE13_BANK3_PIN12_MA      0x00030000

#define BF_PINCTRL_DRIVE13_BANK3_PIN12_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE13_BANK3_PIN12_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN12_MA(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN12_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field RSRVD3 */

#define BP_PINCTRL_DRIVE13_RSRVD3      15
#define BM_PINCTRL_DRIVE13_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE13_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE13_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN11_V */

#define BP_PINCTRL_DRIVE13_BANK3_PIN11_V      14
#define BM_PINCTRL_DRIVE13_BANK3_PIN11_V      0x00004000

#define BF_PINCTRL_DRIVE13_BANK3_PIN11_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE13_BANK3_PIN11_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN11_V(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN11_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN11_MA */

#define BP_PINCTRL_DRIVE13_BANK3_PIN11_MA      12
#define BM_PINCTRL_DRIVE13_BANK3_PIN11_MA      0x00003000

#define BF_PINCTRL_DRIVE13_BANK3_PIN11_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE13_BANK3_PIN11_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN11_MA(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN11_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field RSRVD2 */

#define BP_PINCTRL_DRIVE13_RSRVD2      11
#define BM_PINCTRL_DRIVE13_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE13_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE13_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN10_V */

#define BP_PINCTRL_DRIVE13_BANK3_PIN10_V      10
#define BM_PINCTRL_DRIVE13_BANK3_PIN10_V      0x00000400

#define BF_PINCTRL_DRIVE13_BANK3_PIN10_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE13_BANK3_PIN10_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN10_V(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN10_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN10_MA */

#define BP_PINCTRL_DRIVE13_BANK3_PIN10_MA      8
#define BM_PINCTRL_DRIVE13_BANK3_PIN10_MA      0x00000300

#define BF_PINCTRL_DRIVE13_BANK3_PIN10_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE13_BANK3_PIN10_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN10_MA(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN10_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field RSRVD1 */

#define BP_PINCTRL_DRIVE13_RSRVD1      7
#define BM_PINCTRL_DRIVE13_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE13_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE13_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN09_V */

#define BP_PINCTRL_DRIVE13_BANK3_PIN09_V      6
#define BM_PINCTRL_DRIVE13_BANK3_PIN09_V      0x00000040

#define BF_PINCTRL_DRIVE13_BANK3_PIN09_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE13_BANK3_PIN09_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN09_V(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN09_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN09_MA */

#define BP_PINCTRL_DRIVE13_BANK3_PIN09_MA      4
#define BM_PINCTRL_DRIVE13_BANK3_PIN09_MA      0x00000030

#define BF_PINCTRL_DRIVE13_BANK3_PIN09_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE13_BANK3_PIN09_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN09_MA(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN09_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field RSRVD0 */

#define BP_PINCTRL_DRIVE13_RSRVD0      3
#define BM_PINCTRL_DRIVE13_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE13_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE13_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN08_V */

#define BP_PINCTRL_DRIVE13_BANK3_PIN08_V      2
#define BM_PINCTRL_DRIVE13_BANK3_PIN08_V      0x00000004

#define BF_PINCTRL_DRIVE13_BANK3_PIN08_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE13_BANK3_PIN08_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN08_V(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN08_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE13, field BANK3_PIN08_MA */

#define BP_PINCTRL_DRIVE13_BANK3_PIN08_MA      0
#define BM_PINCTRL_DRIVE13_BANK3_PIN08_MA      0x00000003

#define BF_PINCTRL_DRIVE13_BANK3_PIN08_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE13_BANK3_PIN08_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE13_BANK3_PIN08_MA(v)   BF_CS1(PINCTRL_DRIVE13, BANK3_PIN08_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE14 - PINCTRL Drive Strength and Voltage Register 14
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK3_PIN16_MA  :  2;
        unsigned BANK3_PIN16_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK3_PIN17_MA  :  2;
        unsigned BANK3_PIN17_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK3_PIN18_MA  :  2;
        unsigned BANK3_PIN18_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned RSRVD3          :  4;
        unsigned BANK3_PIN20_MA  :  2;
        unsigned BANK3_PIN20_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK3_PIN21_MA  :  2;
        unsigned BANK3_PIN21_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned BANK3_PIN22_MA  :  2;
        unsigned BANK3_PIN22_V   :  1;
        unsigned RSRVD6          :  1;
        unsigned BANK3_PIN23_MA  :  2;
        unsigned BANK3_PIN23_V   :  1;
        unsigned RSRVD7          :  1;
    } B;
} hw_pinctrl_drive14_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE14 register
 */
#define HW_PINCTRL_DRIVE14_ADDR         (REGS_PINCTRL_BASE + 0x3e0)
#define HW_PINCTRL_DRIVE14_SET_ADDR     (HW_PINCTRL_DRIVE14_ADDR + 4)
#define HW_PINCTRL_DRIVE14_CLR_ADDR     (HW_PINCTRL_DRIVE14_ADDR + 8)
#define HW_PINCTRL_DRIVE14_TOG_ADDR     (HW_PINCTRL_DRIVE14_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE14           (*(volatile hw_pinctrl_drive14_t *) HW_PINCTRL_DRIVE14_ADDR)
#define HW_PINCTRL_DRIVE14_RD()      (HW_PINCTRL_DRIVE14.U)
#define HW_PINCTRL_DRIVE14_WR(v)     (HW_PINCTRL_DRIVE14.U = (v))
#define HW_PINCTRL_DRIVE14_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE14_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE14_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE14_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE14_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE14_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE14 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE14, field RSRVD7 */

#define BP_PINCTRL_DRIVE14_RSRVD7      31
#define BM_PINCTRL_DRIVE14_RSRVD7      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE14_RSRVD7(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DRIVE14_RSRVD7)
#else
#define BF_PINCTRL_DRIVE14_RSRVD7(v)   (((v) << 31) & BM_PINCTRL_DRIVE14_RSRVD7)
#endif
/* --- Register HW_PINCTRL_DRIVE14, field BANK3_PIN23_V */

#define BP_PINCTRL_DRIVE14_BANK3_PIN23_V      30
#define BM_PINCTRL_DRIVE14_BANK3_PIN23_V      0x40000000

#define BF_PINCTRL_DRIVE14_BANK3_PIN23_V(v)   (((v) << 30) & BM_PINCTRL_DRIVE14_BANK3_PIN23_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE14_BANK3_PIN23_V(v)   BF_CS1(PINCTRL_DRIVE14, BANK3_PIN23_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE14, field BANK3_PIN23_MA */

#define BP_PINCTRL_DRIVE14_BANK3_PIN23_MA      28
#define BM_PINCTRL_DRIVE14_BANK3_PIN23_MA      0x30000000

#define BF_PINCTRL_DRIVE14_BANK3_PIN23_MA(v)   (((v) << 28) & BM_PINCTRL_DRIVE14_BANK3_PIN23_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE14_BANK3_PIN23_MA(v)   BF_CS1(PINCTRL_DRIVE14, BANK3_PIN23_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE14, field RSRVD6 */

#define BP_PINCTRL_DRIVE14_RSRVD6      27
#define BM_PINCTRL_DRIVE14_RSRVD6      0x08000000

#define BF_PINCTRL_DRIVE14_RSRVD6(v)   (((v) << 27) & BM_PINCTRL_DRIVE14_RSRVD6)
/* --- Register HW_PINCTRL_DRIVE14, field BANK3_PIN22_V */

#define BP_PINCTRL_DRIVE14_BANK3_PIN22_V      26
#define BM_PINCTRL_DRIVE14_BANK3_PIN22_V      0x04000000

#define BF_PINCTRL_DRIVE14_BANK3_PIN22_V(v)   (((v) << 26) & BM_PINCTRL_DRIVE14_BANK3_PIN22_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE14_BANK3_PIN22_V(v)   BF_CS1(PINCTRL_DRIVE14, BANK3_PIN22_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE14, field BANK3_PIN22_MA */

#define BP_PINCTRL_DRIVE14_BANK3_PIN22_MA      24
#define BM_PINCTRL_DRIVE14_BANK3_PIN22_MA      0x03000000

#define BF_PINCTRL_DRIVE14_BANK3_PIN22_MA(v)   (((v) << 24) & BM_PINCTRL_DRIVE14_BANK3_PIN22_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE14_BANK3_PIN22_MA(v)   BF_CS1(PINCTRL_DRIVE14, BANK3_PIN22_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE14, field RSRVD5 */

#define BP_PINCTRL_DRIVE14_RSRVD5      23
#define BM_PINCTRL_DRIVE14_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE14_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE14_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE14, field BANK3_PIN21_V */

#define BP_PINCTRL_DRIVE14_BANK3_PIN21_V      22
#define BM_PINCTRL_DRIVE14_BANK3_PIN21_V      0x00400000

#define BF_PINCTRL_DRIVE14_BANK3_PIN21_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE14_BANK3_PIN21_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE14_BANK3_PIN21_V(v)   BF_CS1(PINCTRL_DRIVE14, BANK3_PIN21_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE14, field BANK3_PIN21_MA */

#define BP_PINCTRL_DRIVE14_BANK3_PIN21_MA      20
#define BM_PINCTRL_DRIVE14_BANK3_PIN21_MA      0x00300000

#define BF_PINCTRL_DRIVE14_BANK3_PIN21_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE14_BANK3_PIN21_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE14_BANK3_PIN21_MA(v)   BF_CS1(PINCTRL_DRIVE14, BANK3_PIN21_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE14, field RSRVD4 */

#define BP_PINCTRL_DRIVE14_RSRVD4      19
#define BM_PINCTRL_DRIVE14_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE14_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE14_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE14, field BANK3_PIN20_V */

#define BP_PINCTRL_DRIVE14_BANK3_PIN20_V      18
#define BM_PINCTRL_DRIVE14_BANK3_PIN20_V      0x00040000

#define BF_PINCTRL_DRIVE14_BANK3_PIN20_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE14_BANK3_PIN20_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE14_BANK3_PIN20_V(v)   BF_CS1(PINCTRL_DRIVE14, BANK3_PIN20_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE14, field BANK3_PIN20_MA */

#define BP_PINCTRL_DRIVE14_BANK3_PIN20_MA      16
#define BM_PINCTRL_DRIVE14_BANK3_PIN20_MA      0x00030000

#define BF_PINCTRL_DRIVE14_BANK3_PIN20_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE14_BANK3_PIN20_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE14_BANK3_PIN20_MA(v)   BF_CS1(PINCTRL_DRIVE14, BANK3_PIN20_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE14, field RSRVD3 */

#define BP_PINCTRL_DRIVE14_RSRVD3      12
#define BM_PINCTRL_DRIVE14_RSRVD3      0x0000F000

#define BF_PINCTRL_DRIVE14_RSRVD3(v)   (((v) << 12) & BM_PINCTRL_DRIVE14_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE14, field RSRVD2 */

#define BP_PINCTRL_DRIVE14_RSRVD2      11
#define BM_PINCTRL_DRIVE14_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE14_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE14_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE14, field BANK3_PIN18_V */

#define BP_PINCTRL_DRIVE14_BANK3_PIN18_V      10
#define BM_PINCTRL_DRIVE14_BANK3_PIN18_V      0x00000400

#define BF_PINCTRL_DRIVE14_BANK3_PIN18_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE14_BANK3_PIN18_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE14_BANK3_PIN18_V(v)   BF_CS1(PINCTRL_DRIVE14, BANK3_PIN18_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE14, field BANK3_PIN18_MA */

#define BP_PINCTRL_DRIVE14_BANK3_PIN18_MA      8
#define BM_PINCTRL_DRIVE14_BANK3_PIN18_MA      0x00000300

#define BF_PINCTRL_DRIVE14_BANK3_PIN18_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE14_BANK3_PIN18_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE14_BANK3_PIN18_MA(v)   BF_CS1(PINCTRL_DRIVE14, BANK3_PIN18_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE14, field RSRVD1 */

#define BP_PINCTRL_DRIVE14_RSRVD1      7
#define BM_PINCTRL_DRIVE14_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE14_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE14_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE14, field BANK3_PIN17_V */

#define BP_PINCTRL_DRIVE14_BANK3_PIN17_V      6
#define BM_PINCTRL_DRIVE14_BANK3_PIN17_V      0x00000040

#define BF_PINCTRL_DRIVE14_BANK3_PIN17_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE14_BANK3_PIN17_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE14_BANK3_PIN17_V(v)   BF_CS1(PINCTRL_DRIVE14, BANK3_PIN17_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE14, field BANK3_PIN17_MA */

#define BP_PINCTRL_DRIVE14_BANK3_PIN17_MA      4
#define BM_PINCTRL_DRIVE14_BANK3_PIN17_MA      0x00000030

#define BF_PINCTRL_DRIVE14_BANK3_PIN17_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE14_BANK3_PIN17_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE14_BANK3_PIN17_MA(v)   BF_CS1(PINCTRL_DRIVE14, BANK3_PIN17_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE14, field RSRVD0 */

#define BP_PINCTRL_DRIVE14_RSRVD0      3
#define BM_PINCTRL_DRIVE14_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE14_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE14_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE14, field BANK3_PIN16_V */

#define BP_PINCTRL_DRIVE14_BANK3_PIN16_V      2
#define BM_PINCTRL_DRIVE14_BANK3_PIN16_V      0x00000004

#define BF_PINCTRL_DRIVE14_BANK3_PIN16_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE14_BANK3_PIN16_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE14_BANK3_PIN16_V(v)   BF_CS1(PINCTRL_DRIVE14, BANK3_PIN16_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE14, field BANK3_PIN16_MA */

#define BP_PINCTRL_DRIVE14_BANK3_PIN16_MA      0
#define BM_PINCTRL_DRIVE14_BANK3_PIN16_MA      0x00000003

#define BF_PINCTRL_DRIVE14_BANK3_PIN16_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE14_BANK3_PIN16_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE14_BANK3_PIN16_MA(v)   BF_CS1(PINCTRL_DRIVE14, BANK3_PIN16_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE15 - PINCTRL Drive Strength and Voltage Register 15
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK3_PIN24_MA  :  2;
        unsigned BANK3_PIN24_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK3_PIN25_MA  :  2;
        unsigned BANK3_PIN25_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK3_PIN26_MA  :  2;
        unsigned BANK3_PIN26_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK3_PIN27_MA  :  2;
        unsigned BANK3_PIN27_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned BANK3_PIN28_MA  :  2;
        unsigned BANK3_PIN28_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK3_PIN29_MA  :  2;
        unsigned BANK3_PIN29_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned BANK3_PIN30_MA  :  2;
        unsigned BANK3_PIN30_V   :  1;
        unsigned RSRVD6          :  1;
        unsigned RSRVD7          :  4;
    } B;
} hw_pinctrl_drive15_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE15 register
 */
#define HW_PINCTRL_DRIVE15_ADDR         (REGS_PINCTRL_BASE + 0x3f0)
#define HW_PINCTRL_DRIVE15_SET_ADDR     (HW_PINCTRL_DRIVE15_ADDR + 4)
#define HW_PINCTRL_DRIVE15_CLR_ADDR     (HW_PINCTRL_DRIVE15_ADDR + 8)
#define HW_PINCTRL_DRIVE15_TOG_ADDR     (HW_PINCTRL_DRIVE15_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE15           (*(volatile hw_pinctrl_drive15_t *) HW_PINCTRL_DRIVE15_ADDR)
#define HW_PINCTRL_DRIVE15_RD()      (HW_PINCTRL_DRIVE15.U)
#define HW_PINCTRL_DRIVE15_WR(v)     (HW_PINCTRL_DRIVE15.U = (v))
#define HW_PINCTRL_DRIVE15_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE15_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE15_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE15_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE15_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE15_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE15 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE15, field RSRVD7 */

#define BP_PINCTRL_DRIVE15_RSRVD7      28
#define BM_PINCTRL_DRIVE15_RSRVD7      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE15_RSRVD7(v)   ((((reg32_t) v) << 28) & BM_PINCTRL_DRIVE15_RSRVD7)
#else
#define BF_PINCTRL_DRIVE15_RSRVD7(v)   (((v) << 28) & BM_PINCTRL_DRIVE15_RSRVD7)
#endif
/* --- Register HW_PINCTRL_DRIVE15, field RSRVD6 */

#define BP_PINCTRL_DRIVE15_RSRVD6      27
#define BM_PINCTRL_DRIVE15_RSRVD6      0x08000000

#define BF_PINCTRL_DRIVE15_RSRVD6(v)   (((v) << 27) & BM_PINCTRL_DRIVE15_RSRVD6)
/* --- Register HW_PINCTRL_DRIVE15, field BANK3_PIN30_V */

#define BP_PINCTRL_DRIVE15_BANK3_PIN30_V      26
#define BM_PINCTRL_DRIVE15_BANK3_PIN30_V      0x04000000

#define BF_PINCTRL_DRIVE15_BANK3_PIN30_V(v)   (((v) << 26) & BM_PINCTRL_DRIVE15_BANK3_PIN30_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE15_BANK3_PIN30_V(v)   BF_CS1(PINCTRL_DRIVE15, BANK3_PIN30_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE15, field BANK3_PIN30_MA */

#define BP_PINCTRL_DRIVE15_BANK3_PIN30_MA      24
#define BM_PINCTRL_DRIVE15_BANK3_PIN30_MA      0x03000000

#define BF_PINCTRL_DRIVE15_BANK3_PIN30_MA(v)   (((v) << 24) & BM_PINCTRL_DRIVE15_BANK3_PIN30_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE15_BANK3_PIN30_MA(v)   BF_CS1(PINCTRL_DRIVE15, BANK3_PIN30_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE15, field RSRVD5 */

#define BP_PINCTRL_DRIVE15_RSRVD5      23
#define BM_PINCTRL_DRIVE15_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE15_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE15_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE15, field BANK3_PIN29_V */

#define BP_PINCTRL_DRIVE15_BANK3_PIN29_V      22
#define BM_PINCTRL_DRIVE15_BANK3_PIN29_V      0x00400000

#define BF_PINCTRL_DRIVE15_BANK3_PIN29_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE15_BANK3_PIN29_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE15_BANK3_PIN29_V(v)   BF_CS1(PINCTRL_DRIVE15, BANK3_PIN29_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE15, field BANK3_PIN29_MA */

#define BP_PINCTRL_DRIVE15_BANK3_PIN29_MA      20
#define BM_PINCTRL_DRIVE15_BANK3_PIN29_MA      0x00300000

#define BF_PINCTRL_DRIVE15_BANK3_PIN29_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE15_BANK3_PIN29_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE15_BANK3_PIN29_MA(v)   BF_CS1(PINCTRL_DRIVE15, BANK3_PIN29_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE15, field RSRVD4 */

#define BP_PINCTRL_DRIVE15_RSRVD4      19
#define BM_PINCTRL_DRIVE15_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE15_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE15_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE15, field BANK3_PIN28_V */

#define BP_PINCTRL_DRIVE15_BANK3_PIN28_V      18
#define BM_PINCTRL_DRIVE15_BANK3_PIN28_V      0x00040000

#define BF_PINCTRL_DRIVE15_BANK3_PIN28_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE15_BANK3_PIN28_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE15_BANK3_PIN28_V(v)   BF_CS1(PINCTRL_DRIVE15, BANK3_PIN28_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE15, field BANK3_PIN28_MA */

#define BP_PINCTRL_DRIVE15_BANK3_PIN28_MA      16
#define BM_PINCTRL_DRIVE15_BANK3_PIN28_MA      0x00030000

#define BF_PINCTRL_DRIVE15_BANK3_PIN28_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE15_BANK3_PIN28_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE15_BANK3_PIN28_MA(v)   BF_CS1(PINCTRL_DRIVE15, BANK3_PIN28_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE15, field RSRVD3 */

#define BP_PINCTRL_DRIVE15_RSRVD3      15
#define BM_PINCTRL_DRIVE15_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE15_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE15_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE15, field BANK3_PIN27_V */

#define BP_PINCTRL_DRIVE15_BANK3_PIN27_V      14
#define BM_PINCTRL_DRIVE15_BANK3_PIN27_V      0x00004000

#define BF_PINCTRL_DRIVE15_BANK3_PIN27_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE15_BANK3_PIN27_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE15_BANK3_PIN27_V(v)   BF_CS1(PINCTRL_DRIVE15, BANK3_PIN27_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE15, field BANK3_PIN27_MA */

#define BP_PINCTRL_DRIVE15_BANK3_PIN27_MA      12
#define BM_PINCTRL_DRIVE15_BANK3_PIN27_MA      0x00003000

#define BF_PINCTRL_DRIVE15_BANK3_PIN27_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE15_BANK3_PIN27_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE15_BANK3_PIN27_MA(v)   BF_CS1(PINCTRL_DRIVE15, BANK3_PIN27_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE15, field RSRVD2 */

#define BP_PINCTRL_DRIVE15_RSRVD2      11
#define BM_PINCTRL_DRIVE15_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE15_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE15_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE15, field BANK3_PIN26_V */

#define BP_PINCTRL_DRIVE15_BANK3_PIN26_V      10
#define BM_PINCTRL_DRIVE15_BANK3_PIN26_V      0x00000400

#define BF_PINCTRL_DRIVE15_BANK3_PIN26_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE15_BANK3_PIN26_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE15_BANK3_PIN26_V(v)   BF_CS1(PINCTRL_DRIVE15, BANK3_PIN26_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE15, field BANK3_PIN26_MA */

#define BP_PINCTRL_DRIVE15_BANK3_PIN26_MA      8
#define BM_PINCTRL_DRIVE15_BANK3_PIN26_MA      0x00000300

#define BF_PINCTRL_DRIVE15_BANK3_PIN26_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE15_BANK3_PIN26_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE15_BANK3_PIN26_MA(v)   BF_CS1(PINCTRL_DRIVE15, BANK3_PIN26_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE15, field RSRVD1 */

#define BP_PINCTRL_DRIVE15_RSRVD1      7
#define BM_PINCTRL_DRIVE15_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE15_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE15_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE15, field BANK3_PIN25_V */

#define BP_PINCTRL_DRIVE15_BANK3_PIN25_V      6
#define BM_PINCTRL_DRIVE15_BANK3_PIN25_V      0x00000040

#define BF_PINCTRL_DRIVE15_BANK3_PIN25_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE15_BANK3_PIN25_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE15_BANK3_PIN25_V(v)   BF_CS1(PINCTRL_DRIVE15, BANK3_PIN25_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE15, field BANK3_PIN25_MA */

#define BP_PINCTRL_DRIVE15_BANK3_PIN25_MA      4
#define BM_PINCTRL_DRIVE15_BANK3_PIN25_MA      0x00000030

#define BF_PINCTRL_DRIVE15_BANK3_PIN25_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE15_BANK3_PIN25_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE15_BANK3_PIN25_MA(v)   BF_CS1(PINCTRL_DRIVE15, BANK3_PIN25_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE15, field RSRVD0 */

#define BP_PINCTRL_DRIVE15_RSRVD0      3
#define BM_PINCTRL_DRIVE15_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE15_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE15_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE15, field BANK3_PIN24_V */

#define BP_PINCTRL_DRIVE15_BANK3_PIN24_V      2
#define BM_PINCTRL_DRIVE15_BANK3_PIN24_V      0x00000004

#define BF_PINCTRL_DRIVE15_BANK3_PIN24_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE15_BANK3_PIN24_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE15_BANK3_PIN24_V(v)   BF_CS1(PINCTRL_DRIVE15, BANK3_PIN24_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE15, field BANK3_PIN24_MA */

#define BP_PINCTRL_DRIVE15_BANK3_PIN24_MA      0
#define BM_PINCTRL_DRIVE15_BANK3_PIN24_MA      0x00000003

#define BF_PINCTRL_DRIVE15_BANK3_PIN24_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE15_BANK3_PIN24_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE15_BANK3_PIN24_MA(v)   BF_CS1(PINCTRL_DRIVE15, BANK3_PIN24_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE16 - PINCTRL Drive Strength and Voltage Register 16
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK4_PIN00_MA  :  2;
        unsigned BANK4_PIN00_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK4_PIN01_MA  :  2;
        unsigned BANK4_PIN01_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK4_PIN02_MA  :  2;
        unsigned BANK4_PIN02_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK4_PIN03_MA  :  2;
        unsigned BANK4_PIN03_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned BANK4_PIN04_MA  :  2;
        unsigned BANK4_PIN04_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK4_PIN05_MA  :  2;
        unsigned BANK4_PIN05_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned BANK4_PIN06_MA  :  2;
        unsigned BANK4_PIN06_V   :  1;
        unsigned RSRVD6          :  1;
        unsigned BANK4_PIN07_MA  :  2;
        unsigned BANK4_PIN07_V   :  1;
        unsigned RSRVD7          :  1;
    } B;
} hw_pinctrl_drive16_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE16 register
 */
#define HW_PINCTRL_DRIVE16_ADDR         (REGS_PINCTRL_BASE + 0x400)
#define HW_PINCTRL_DRIVE16_SET_ADDR     (HW_PINCTRL_DRIVE16_ADDR + 4)
#define HW_PINCTRL_DRIVE16_CLR_ADDR     (HW_PINCTRL_DRIVE16_ADDR + 8)
#define HW_PINCTRL_DRIVE16_TOG_ADDR     (HW_PINCTRL_DRIVE16_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE16           (*(volatile hw_pinctrl_drive16_t *) HW_PINCTRL_DRIVE16_ADDR)
#define HW_PINCTRL_DRIVE16_RD()      (HW_PINCTRL_DRIVE16.U)
#define HW_PINCTRL_DRIVE16_WR(v)     (HW_PINCTRL_DRIVE16.U = (v))
#define HW_PINCTRL_DRIVE16_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE16_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE16_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE16_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE16_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE16_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE16 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE16, field RSRVD7 */

#define BP_PINCTRL_DRIVE16_RSRVD7      31
#define BM_PINCTRL_DRIVE16_RSRVD7      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE16_RSRVD7(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DRIVE16_RSRVD7)
#else
#define BF_PINCTRL_DRIVE16_RSRVD7(v)   (((v) << 31) & BM_PINCTRL_DRIVE16_RSRVD7)
#endif
/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN07_V */

#define BP_PINCTRL_DRIVE16_BANK4_PIN07_V      30
#define BM_PINCTRL_DRIVE16_BANK4_PIN07_V      0x40000000

#define BF_PINCTRL_DRIVE16_BANK4_PIN07_V(v)   (((v) << 30) & BM_PINCTRL_DRIVE16_BANK4_PIN07_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN07_V(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN07_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN07_MA */

#define BP_PINCTRL_DRIVE16_BANK4_PIN07_MA      28
#define BM_PINCTRL_DRIVE16_BANK4_PIN07_MA      0x30000000

#define BF_PINCTRL_DRIVE16_BANK4_PIN07_MA(v)   (((v) << 28) & BM_PINCTRL_DRIVE16_BANK4_PIN07_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN07_MA(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN07_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field RSRVD6 */

#define BP_PINCTRL_DRIVE16_RSRVD6      27
#define BM_PINCTRL_DRIVE16_RSRVD6      0x08000000

#define BF_PINCTRL_DRIVE16_RSRVD6(v)   (((v) << 27) & BM_PINCTRL_DRIVE16_RSRVD6)
/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN06_V */

#define BP_PINCTRL_DRIVE16_BANK4_PIN06_V      26
#define BM_PINCTRL_DRIVE16_BANK4_PIN06_V      0x04000000

#define BF_PINCTRL_DRIVE16_BANK4_PIN06_V(v)   (((v) << 26) & BM_PINCTRL_DRIVE16_BANK4_PIN06_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN06_V(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN06_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN06_MA */

#define BP_PINCTRL_DRIVE16_BANK4_PIN06_MA      24
#define BM_PINCTRL_DRIVE16_BANK4_PIN06_MA      0x03000000

#define BF_PINCTRL_DRIVE16_BANK4_PIN06_MA(v)   (((v) << 24) & BM_PINCTRL_DRIVE16_BANK4_PIN06_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN06_MA(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN06_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field RSRVD5 */

#define BP_PINCTRL_DRIVE16_RSRVD5      23
#define BM_PINCTRL_DRIVE16_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE16_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE16_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN05_V */

#define BP_PINCTRL_DRIVE16_BANK4_PIN05_V      22
#define BM_PINCTRL_DRIVE16_BANK4_PIN05_V      0x00400000

#define BF_PINCTRL_DRIVE16_BANK4_PIN05_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE16_BANK4_PIN05_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN05_V(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN05_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN05_MA */

#define BP_PINCTRL_DRIVE16_BANK4_PIN05_MA      20
#define BM_PINCTRL_DRIVE16_BANK4_PIN05_MA      0x00300000

#define BF_PINCTRL_DRIVE16_BANK4_PIN05_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE16_BANK4_PIN05_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN05_MA(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN05_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field RSRVD4 */

#define BP_PINCTRL_DRIVE16_RSRVD4      19
#define BM_PINCTRL_DRIVE16_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE16_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE16_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN04_V */

#define BP_PINCTRL_DRIVE16_BANK4_PIN04_V      18
#define BM_PINCTRL_DRIVE16_BANK4_PIN04_V      0x00040000

#define BF_PINCTRL_DRIVE16_BANK4_PIN04_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE16_BANK4_PIN04_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN04_V(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN04_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN04_MA */

#define BP_PINCTRL_DRIVE16_BANK4_PIN04_MA      16
#define BM_PINCTRL_DRIVE16_BANK4_PIN04_MA      0x00030000

#define BF_PINCTRL_DRIVE16_BANK4_PIN04_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE16_BANK4_PIN04_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN04_MA(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN04_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field RSRVD3 */

#define BP_PINCTRL_DRIVE16_RSRVD3      15
#define BM_PINCTRL_DRIVE16_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE16_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE16_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN03_V */

#define BP_PINCTRL_DRIVE16_BANK4_PIN03_V      14
#define BM_PINCTRL_DRIVE16_BANK4_PIN03_V      0x00004000

#define BF_PINCTRL_DRIVE16_BANK4_PIN03_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE16_BANK4_PIN03_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN03_V(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN03_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN03_MA */

#define BP_PINCTRL_DRIVE16_BANK4_PIN03_MA      12
#define BM_PINCTRL_DRIVE16_BANK4_PIN03_MA      0x00003000

#define BF_PINCTRL_DRIVE16_BANK4_PIN03_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE16_BANK4_PIN03_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN03_MA(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN03_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field RSRVD2 */

#define BP_PINCTRL_DRIVE16_RSRVD2      11
#define BM_PINCTRL_DRIVE16_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE16_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE16_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN02_V */

#define BP_PINCTRL_DRIVE16_BANK4_PIN02_V      10
#define BM_PINCTRL_DRIVE16_BANK4_PIN02_V      0x00000400

#define BF_PINCTRL_DRIVE16_BANK4_PIN02_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE16_BANK4_PIN02_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN02_V(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN02_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN02_MA */

#define BP_PINCTRL_DRIVE16_BANK4_PIN02_MA      8
#define BM_PINCTRL_DRIVE16_BANK4_PIN02_MA      0x00000300

#define BF_PINCTRL_DRIVE16_BANK4_PIN02_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE16_BANK4_PIN02_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN02_MA(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN02_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field RSRVD1 */

#define BP_PINCTRL_DRIVE16_RSRVD1      7
#define BM_PINCTRL_DRIVE16_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE16_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE16_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN01_V */

#define BP_PINCTRL_DRIVE16_BANK4_PIN01_V      6
#define BM_PINCTRL_DRIVE16_BANK4_PIN01_V      0x00000040

#define BF_PINCTRL_DRIVE16_BANK4_PIN01_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE16_BANK4_PIN01_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN01_V(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN01_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN01_MA */

#define BP_PINCTRL_DRIVE16_BANK4_PIN01_MA      4
#define BM_PINCTRL_DRIVE16_BANK4_PIN01_MA      0x00000030

#define BF_PINCTRL_DRIVE16_BANK4_PIN01_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE16_BANK4_PIN01_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN01_MA(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN01_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field RSRVD0 */

#define BP_PINCTRL_DRIVE16_RSRVD0      3
#define BM_PINCTRL_DRIVE16_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE16_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE16_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN00_V */

#define BP_PINCTRL_DRIVE16_BANK4_PIN00_V      2
#define BM_PINCTRL_DRIVE16_BANK4_PIN00_V      0x00000004

#define BF_PINCTRL_DRIVE16_BANK4_PIN00_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE16_BANK4_PIN00_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN00_V(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN00_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE16, field BANK4_PIN00_MA */

#define BP_PINCTRL_DRIVE16_BANK4_PIN00_MA      0
#define BM_PINCTRL_DRIVE16_BANK4_PIN00_MA      0x00000003

#define BF_PINCTRL_DRIVE16_BANK4_PIN00_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE16_BANK4_PIN00_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE16_BANK4_PIN00_MA(v)   BF_CS1(PINCTRL_DRIVE16, BANK4_PIN00_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE17 - PINCTRL Drive Strength and Voltage Register 17
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK4_PIN08_MA  :  2;
        unsigned BANK4_PIN08_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned BANK4_PIN09_MA  :  2;
        unsigned BANK4_PIN09_V   :  1;
        unsigned RSRVD1          :  1;
        unsigned BANK4_PIN10_MA  :  2;
        unsigned BANK4_PIN10_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned BANK4_PIN11_MA  :  2;
        unsigned BANK4_PIN11_V   :  1;
        unsigned RSRVD3          :  1;
        unsigned BANK4_PIN12_MA  :  2;
        unsigned BANK4_PIN12_V   :  1;
        unsigned RSRVD4          :  1;
        unsigned BANK4_PIN13_MA  :  2;
        unsigned BANK4_PIN13_V   :  1;
        unsigned RSRVD5          :  1;
        unsigned BANK4_PIN14_MA  :  2;
        unsigned BANK4_PIN14_V   :  1;
        unsigned RSRVD6          :  1;
        unsigned BANK4_PIN15_MA  :  2;
        unsigned BANK4_PIN15_V   :  1;
        unsigned RSRVD7          :  1;
    } B;
} hw_pinctrl_drive17_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE17 register
 */
#define HW_PINCTRL_DRIVE17_ADDR         (REGS_PINCTRL_BASE + 0x410)
#define HW_PINCTRL_DRIVE17_SET_ADDR     (HW_PINCTRL_DRIVE17_ADDR + 4)
#define HW_PINCTRL_DRIVE17_CLR_ADDR     (HW_PINCTRL_DRIVE17_ADDR + 8)
#define HW_PINCTRL_DRIVE17_TOG_ADDR     (HW_PINCTRL_DRIVE17_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE17           (*(volatile hw_pinctrl_drive17_t *) HW_PINCTRL_DRIVE17_ADDR)
#define HW_PINCTRL_DRIVE17_RD()      (HW_PINCTRL_DRIVE17.U)
#define HW_PINCTRL_DRIVE17_WR(v)     (HW_PINCTRL_DRIVE17.U = (v))
#define HW_PINCTRL_DRIVE17_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE17_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE17_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE17_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE17_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE17_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE17 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE17, field RSRVD7 */

#define BP_PINCTRL_DRIVE17_RSRVD7      31
#define BM_PINCTRL_DRIVE17_RSRVD7      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE17_RSRVD7(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DRIVE17_RSRVD7)
#else
#define BF_PINCTRL_DRIVE17_RSRVD7(v)   (((v) << 31) & BM_PINCTRL_DRIVE17_RSRVD7)
#endif
/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN15_V */

#define BP_PINCTRL_DRIVE17_BANK4_PIN15_V      30
#define BM_PINCTRL_DRIVE17_BANK4_PIN15_V      0x40000000

#define BF_PINCTRL_DRIVE17_BANK4_PIN15_V(v)   (((v) << 30) & BM_PINCTRL_DRIVE17_BANK4_PIN15_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN15_V(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN15_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN15_MA */

#define BP_PINCTRL_DRIVE17_BANK4_PIN15_MA      28
#define BM_PINCTRL_DRIVE17_BANK4_PIN15_MA      0x30000000

#define BF_PINCTRL_DRIVE17_BANK4_PIN15_MA(v)   (((v) << 28) & BM_PINCTRL_DRIVE17_BANK4_PIN15_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN15_MA(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN15_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field RSRVD6 */

#define BP_PINCTRL_DRIVE17_RSRVD6      27
#define BM_PINCTRL_DRIVE17_RSRVD6      0x08000000

#define BF_PINCTRL_DRIVE17_RSRVD6(v)   (((v) << 27) & BM_PINCTRL_DRIVE17_RSRVD6)
/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN14_V */

#define BP_PINCTRL_DRIVE17_BANK4_PIN14_V      26
#define BM_PINCTRL_DRIVE17_BANK4_PIN14_V      0x04000000

#define BF_PINCTRL_DRIVE17_BANK4_PIN14_V(v)   (((v) << 26) & BM_PINCTRL_DRIVE17_BANK4_PIN14_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN14_V(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN14_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN14_MA */

#define BP_PINCTRL_DRIVE17_BANK4_PIN14_MA      24
#define BM_PINCTRL_DRIVE17_BANK4_PIN14_MA      0x03000000

#define BF_PINCTRL_DRIVE17_BANK4_PIN14_MA(v)   (((v) << 24) & BM_PINCTRL_DRIVE17_BANK4_PIN14_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN14_MA(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN14_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field RSRVD5 */

#define BP_PINCTRL_DRIVE17_RSRVD5      23
#define BM_PINCTRL_DRIVE17_RSRVD5      0x00800000

#define BF_PINCTRL_DRIVE17_RSRVD5(v)   (((v) << 23) & BM_PINCTRL_DRIVE17_RSRVD5)
/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN13_V */

#define BP_PINCTRL_DRIVE17_BANK4_PIN13_V      22
#define BM_PINCTRL_DRIVE17_BANK4_PIN13_V      0x00400000

#define BF_PINCTRL_DRIVE17_BANK4_PIN13_V(v)   (((v) << 22) & BM_PINCTRL_DRIVE17_BANK4_PIN13_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN13_V(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN13_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN13_MA */

#define BP_PINCTRL_DRIVE17_BANK4_PIN13_MA      20
#define BM_PINCTRL_DRIVE17_BANK4_PIN13_MA      0x00300000

#define BF_PINCTRL_DRIVE17_BANK4_PIN13_MA(v)   (((v) << 20) & BM_PINCTRL_DRIVE17_BANK4_PIN13_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN13_MA(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN13_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field RSRVD4 */

#define BP_PINCTRL_DRIVE17_RSRVD4      19
#define BM_PINCTRL_DRIVE17_RSRVD4      0x00080000

#define BF_PINCTRL_DRIVE17_RSRVD4(v)   (((v) << 19) & BM_PINCTRL_DRIVE17_RSRVD4)
/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN12_V */

#define BP_PINCTRL_DRIVE17_BANK4_PIN12_V      18
#define BM_PINCTRL_DRIVE17_BANK4_PIN12_V      0x00040000

#define BF_PINCTRL_DRIVE17_BANK4_PIN12_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE17_BANK4_PIN12_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN12_V(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN12_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN12_MA */

#define BP_PINCTRL_DRIVE17_BANK4_PIN12_MA      16
#define BM_PINCTRL_DRIVE17_BANK4_PIN12_MA      0x00030000

#define BF_PINCTRL_DRIVE17_BANK4_PIN12_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE17_BANK4_PIN12_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN12_MA(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN12_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field RSRVD3 */

#define BP_PINCTRL_DRIVE17_RSRVD3      15
#define BM_PINCTRL_DRIVE17_RSRVD3      0x00008000

#define BF_PINCTRL_DRIVE17_RSRVD3(v)   (((v) << 15) & BM_PINCTRL_DRIVE17_RSRVD3)
/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN11_V */

#define BP_PINCTRL_DRIVE17_BANK4_PIN11_V      14
#define BM_PINCTRL_DRIVE17_BANK4_PIN11_V      0x00004000

#define BF_PINCTRL_DRIVE17_BANK4_PIN11_V(v)   (((v) << 14) & BM_PINCTRL_DRIVE17_BANK4_PIN11_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN11_V(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN11_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN11_MA */

#define BP_PINCTRL_DRIVE17_BANK4_PIN11_MA      12
#define BM_PINCTRL_DRIVE17_BANK4_PIN11_MA      0x00003000

#define BF_PINCTRL_DRIVE17_BANK4_PIN11_MA(v)   (((v) << 12) & BM_PINCTRL_DRIVE17_BANK4_PIN11_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN11_MA(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN11_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field RSRVD2 */

#define BP_PINCTRL_DRIVE17_RSRVD2      11
#define BM_PINCTRL_DRIVE17_RSRVD2      0x00000800

#define BF_PINCTRL_DRIVE17_RSRVD2(v)   (((v) << 11) & BM_PINCTRL_DRIVE17_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN10_V */

#define BP_PINCTRL_DRIVE17_BANK4_PIN10_V      10
#define BM_PINCTRL_DRIVE17_BANK4_PIN10_V      0x00000400

#define BF_PINCTRL_DRIVE17_BANK4_PIN10_V(v)   (((v) << 10) & BM_PINCTRL_DRIVE17_BANK4_PIN10_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN10_V(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN10_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN10_MA */

#define BP_PINCTRL_DRIVE17_BANK4_PIN10_MA      8
#define BM_PINCTRL_DRIVE17_BANK4_PIN10_MA      0x00000300

#define BF_PINCTRL_DRIVE17_BANK4_PIN10_MA(v)   (((v) << 8) & BM_PINCTRL_DRIVE17_BANK4_PIN10_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN10_MA(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN10_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field RSRVD1 */

#define BP_PINCTRL_DRIVE17_RSRVD1      7
#define BM_PINCTRL_DRIVE17_RSRVD1      0x00000080

#define BF_PINCTRL_DRIVE17_RSRVD1(v)   (((v) << 7) & BM_PINCTRL_DRIVE17_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN09_V */

#define BP_PINCTRL_DRIVE17_BANK4_PIN09_V      6
#define BM_PINCTRL_DRIVE17_BANK4_PIN09_V      0x00000040

#define BF_PINCTRL_DRIVE17_BANK4_PIN09_V(v)   (((v) << 6) & BM_PINCTRL_DRIVE17_BANK4_PIN09_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN09_V(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN09_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN09_MA */

#define BP_PINCTRL_DRIVE17_BANK4_PIN09_MA      4
#define BM_PINCTRL_DRIVE17_BANK4_PIN09_MA      0x00000030

#define BF_PINCTRL_DRIVE17_BANK4_PIN09_MA(v)   (((v) << 4) & BM_PINCTRL_DRIVE17_BANK4_PIN09_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN09_MA(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN09_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field RSRVD0 */

#define BP_PINCTRL_DRIVE17_RSRVD0      3
#define BM_PINCTRL_DRIVE17_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE17_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE17_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN08_V */

#define BP_PINCTRL_DRIVE17_BANK4_PIN08_V      2
#define BM_PINCTRL_DRIVE17_BANK4_PIN08_V      0x00000004

#define BF_PINCTRL_DRIVE17_BANK4_PIN08_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE17_BANK4_PIN08_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN08_V(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN08_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE17, field BANK4_PIN08_MA */

#define BP_PINCTRL_DRIVE17_BANK4_PIN08_MA      0
#define BM_PINCTRL_DRIVE17_BANK4_PIN08_MA      0x00000003

#define BF_PINCTRL_DRIVE17_BANK4_PIN08_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE17_BANK4_PIN08_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE17_BANK4_PIN08_MA(v)   BF_CS1(PINCTRL_DRIVE17, BANK4_PIN08_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE18 - PINCTRL Drive Strength and Voltage Register 18
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK4_PIN16_MA  :  2;
        unsigned BANK4_PIN16_V   :  1;
        unsigned RSRVD0          :  1;
        unsigned RSRVD1          : 12;
        unsigned BANK4_PIN20_MA  :  2;
        unsigned BANK4_PIN20_V   :  1;
        unsigned RSRVD2          :  1;
        unsigned RSRVD3          : 12;
    } B;
} hw_pinctrl_drive18_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE18 register
 */
#define HW_PINCTRL_DRIVE18_ADDR         (REGS_PINCTRL_BASE + 0x420)
#define HW_PINCTRL_DRIVE18_SET_ADDR     (HW_PINCTRL_DRIVE18_ADDR + 4)
#define HW_PINCTRL_DRIVE18_CLR_ADDR     (HW_PINCTRL_DRIVE18_ADDR + 8)
#define HW_PINCTRL_DRIVE18_TOG_ADDR     (HW_PINCTRL_DRIVE18_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE18           (*(volatile hw_pinctrl_drive18_t *) HW_PINCTRL_DRIVE18_ADDR)
#define HW_PINCTRL_DRIVE18_RD()      (HW_PINCTRL_DRIVE18.U)
#define HW_PINCTRL_DRIVE18_WR(v)     (HW_PINCTRL_DRIVE18.U = (v))
#define HW_PINCTRL_DRIVE18_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE18_SET_ADDR) = (v))
#define HW_PINCTRL_DRIVE18_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE18_CLR_ADDR) = (v))
#define HW_PINCTRL_DRIVE18_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DRIVE18_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE18 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE18, field RSRVD3 */

#define BP_PINCTRL_DRIVE18_RSRVD3      20
#define BM_PINCTRL_DRIVE18_RSRVD3      0xFFF00000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE18_RSRVD3(v)   ((((reg32_t) v) << 20) & BM_PINCTRL_DRIVE18_RSRVD3)
#else
#define BF_PINCTRL_DRIVE18_RSRVD3(v)   (((v) << 20) & BM_PINCTRL_DRIVE18_RSRVD3)
#endif
/* --- Register HW_PINCTRL_DRIVE18, field RSRVD2 */

#define BP_PINCTRL_DRIVE18_RSRVD2      19
#define BM_PINCTRL_DRIVE18_RSRVD2      0x00080000

#define BF_PINCTRL_DRIVE18_RSRVD2(v)   (((v) << 19) & BM_PINCTRL_DRIVE18_RSRVD2)
/* --- Register HW_PINCTRL_DRIVE18, field BANK4_PIN20_V */

#define BP_PINCTRL_DRIVE18_BANK4_PIN20_V      18
#define BM_PINCTRL_DRIVE18_BANK4_PIN20_V      0x00040000

#define BF_PINCTRL_DRIVE18_BANK4_PIN20_V(v)   (((v) << 18) & BM_PINCTRL_DRIVE18_BANK4_PIN20_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE18_BANK4_PIN20_V(v)   BF_CS1(PINCTRL_DRIVE18, BANK4_PIN20_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE18, field BANK4_PIN20_MA */

#define BP_PINCTRL_DRIVE18_BANK4_PIN20_MA      16
#define BM_PINCTRL_DRIVE18_BANK4_PIN20_MA      0x00030000

#define BF_PINCTRL_DRIVE18_BANK4_PIN20_MA(v)   (((v) << 16) & BM_PINCTRL_DRIVE18_BANK4_PIN20_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE18_BANK4_PIN20_MA(v)   BF_CS1(PINCTRL_DRIVE18, BANK4_PIN20_MA, v)
#endif

/* --- Register HW_PINCTRL_DRIVE18, field RSRVD1 */

#define BP_PINCTRL_DRIVE18_RSRVD1      4
#define BM_PINCTRL_DRIVE18_RSRVD1      0x0000FFF0

#define BF_PINCTRL_DRIVE18_RSRVD1(v)   (((v) << 4) & BM_PINCTRL_DRIVE18_RSRVD1)
/* --- Register HW_PINCTRL_DRIVE18, field RSRVD0 */

#define BP_PINCTRL_DRIVE18_RSRVD0      3
#define BM_PINCTRL_DRIVE18_RSRVD0      0x00000008

#define BF_PINCTRL_DRIVE18_RSRVD0(v)   (((v) << 3) & BM_PINCTRL_DRIVE18_RSRVD0)
/* --- Register HW_PINCTRL_DRIVE18, field BANK4_PIN16_V */

#define BP_PINCTRL_DRIVE18_BANK4_PIN16_V      2
#define BM_PINCTRL_DRIVE18_BANK4_PIN16_V      0x00000004

#define BF_PINCTRL_DRIVE18_BANK4_PIN16_V(v)   (((v) << 2) & BM_PINCTRL_DRIVE18_BANK4_PIN16_V)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE18_BANK4_PIN16_V(v)   BF_CS1(PINCTRL_DRIVE18, BANK4_PIN16_V, v)
#endif

/* --- Register HW_PINCTRL_DRIVE18, field BANK4_PIN16_MA */

#define BP_PINCTRL_DRIVE18_BANK4_PIN16_MA      0
#define BM_PINCTRL_DRIVE18_BANK4_PIN16_MA      0x00000003

#define BF_PINCTRL_DRIVE18_BANK4_PIN16_MA(v)   (((v) << 0) & BM_PINCTRL_DRIVE18_BANK4_PIN16_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DRIVE18_BANK4_PIN16_MA(v)   BF_CS1(PINCTRL_DRIVE18, BANK4_PIN16_MA, v)
#endif



/*
 * HW_PINCTRL_DRIVE19 - PINCTRL Drive Strength and Voltage Register 19
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD0  : 32;
    } B;
} hw_pinctrl_drive19_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DRIVE19 register
 */
#define HW_PINCTRL_DRIVE19_ADDR         (REGS_PINCTRL_BASE + 0x430)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DRIVE19           (*(volatile hw_pinctrl_drive19_t *) HW_PINCTRL_DRIVE19_ADDR)
#define HW_PINCTRL_DRIVE19_RD()      (HW_PINCTRL_DRIVE19.U)
#endif


/*
 * constants & macros for individual HW_PINCTRL_DRIVE19 bitfields
 */
/* --- Register HW_PINCTRL_DRIVE19, field RSRVD0 */

#define BP_PINCTRL_DRIVE19_RSRVD0      0
#define BM_PINCTRL_DRIVE19_RSRVD0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DRIVE19_RSRVD0(v)   ((reg32_t) v)
#else
#define BF_PINCTRL_DRIVE19_RSRVD0(v)   (v)
#endif


/*
 * HW_PINCTRL_PULL0 - PINCTRL Bank 0 Pull Up Resistor Enable Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK0_PIN00  :  1;
        unsigned BANK0_PIN01  :  1;
        unsigned BANK0_PIN02  :  1;
        unsigned BANK0_PIN03  :  1;
        unsigned BANK0_PIN04  :  1;
        unsigned BANK0_PIN05  :  1;
        unsigned BANK0_PIN06  :  1;
        unsigned BANK0_PIN07  :  1;
        unsigned RSRVD0       :  8;
        unsigned BANK0_PIN16  :  1;
        unsigned BANK0_PIN17  :  1;
        unsigned BANK0_PIN18  :  1;
        unsigned BANK0_PIN19  :  1;
        unsigned BANK0_PIN20  :  1;
        unsigned BANK0_PIN21  :  1;
        unsigned BANK0_PIN22  :  1;
        unsigned BANK0_PIN23  :  1;
        unsigned BANK0_PIN24  :  1;
        unsigned BANK0_PIN25  :  1;
        unsigned BANK0_PIN26  :  1;
        unsigned BANK0_PIN27  :  1;
        unsigned BANK0_PIN28  :  1;
        unsigned RSRVD1       :  3;
    } B;
} hw_pinctrl_pull0_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_PULL0 register
 */
#define HW_PINCTRL_PULL0_ADDR         (REGS_PINCTRL_BASE + 0x600)
#define HW_PINCTRL_PULL0_SET_ADDR     (HW_PINCTRL_PULL0_ADDR + 4)
#define HW_PINCTRL_PULL0_CLR_ADDR     (HW_PINCTRL_PULL0_ADDR + 8)
#define HW_PINCTRL_PULL0_TOG_ADDR     (HW_PINCTRL_PULL0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_PULL0           (*(volatile hw_pinctrl_pull0_t *) HW_PINCTRL_PULL0_ADDR)
#define HW_PINCTRL_PULL0_RD()      (HW_PINCTRL_PULL0.U)
#define HW_PINCTRL_PULL0_WR(v)     (HW_PINCTRL_PULL0.U = (v))
#define HW_PINCTRL_PULL0_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL0_SET_ADDR) = (v))
#define HW_PINCTRL_PULL0_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL0_CLR_ADDR) = (v))
#define HW_PINCTRL_PULL0_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_PULL0 bitfields
 */
/* --- Register HW_PINCTRL_PULL0, field RSRVD1 */

#define BP_PINCTRL_PULL0_RSRVD1      29
#define BM_PINCTRL_PULL0_RSRVD1      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_PULL0_RSRVD1(v)   ((((reg32_t) v) << 29) & BM_PINCTRL_PULL0_RSRVD1)
#else
#define BF_PINCTRL_PULL0_RSRVD1(v)   (((v) << 29) & BM_PINCTRL_PULL0_RSRVD1)
#endif
/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN28 */

#define BP_PINCTRL_PULL0_BANK0_PIN28      28
#define BM_PINCTRL_PULL0_BANK0_PIN28      0x10000000

#define BF_PINCTRL_PULL0_BANK0_PIN28(v)   (((v) << 28) & BM_PINCTRL_PULL0_BANK0_PIN28)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN28(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN28, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN27 */

#define BP_PINCTRL_PULL0_BANK0_PIN27      27
#define BM_PINCTRL_PULL0_BANK0_PIN27      0x08000000

#define BF_PINCTRL_PULL0_BANK0_PIN27(v)   (((v) << 27) & BM_PINCTRL_PULL0_BANK0_PIN27)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN27(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN27, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN26 */

#define BP_PINCTRL_PULL0_BANK0_PIN26      26
#define BM_PINCTRL_PULL0_BANK0_PIN26      0x04000000

#define BF_PINCTRL_PULL0_BANK0_PIN26(v)   (((v) << 26) & BM_PINCTRL_PULL0_BANK0_PIN26)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN26(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN26, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN25 */

#define BP_PINCTRL_PULL0_BANK0_PIN25      25
#define BM_PINCTRL_PULL0_BANK0_PIN25      0x02000000

#define BF_PINCTRL_PULL0_BANK0_PIN25(v)   (((v) << 25) & BM_PINCTRL_PULL0_BANK0_PIN25)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN25(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN25, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN24 */

#define BP_PINCTRL_PULL0_BANK0_PIN24      24
#define BM_PINCTRL_PULL0_BANK0_PIN24      0x01000000

#define BF_PINCTRL_PULL0_BANK0_PIN24(v)   (((v) << 24) & BM_PINCTRL_PULL0_BANK0_PIN24)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN24(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN24, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN23 */

#define BP_PINCTRL_PULL0_BANK0_PIN23      23
#define BM_PINCTRL_PULL0_BANK0_PIN23      0x00800000

#define BF_PINCTRL_PULL0_BANK0_PIN23(v)   (((v) << 23) & BM_PINCTRL_PULL0_BANK0_PIN23)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN23(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN23, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN22 */

#define BP_PINCTRL_PULL0_BANK0_PIN22      22
#define BM_PINCTRL_PULL0_BANK0_PIN22      0x00400000

#define BF_PINCTRL_PULL0_BANK0_PIN22(v)   (((v) << 22) & BM_PINCTRL_PULL0_BANK0_PIN22)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN22(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN22, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN21 */

#define BP_PINCTRL_PULL0_BANK0_PIN21      21
#define BM_PINCTRL_PULL0_BANK0_PIN21      0x00200000

#define BF_PINCTRL_PULL0_BANK0_PIN21(v)   (((v) << 21) & BM_PINCTRL_PULL0_BANK0_PIN21)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN21(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN21, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN20 */

#define BP_PINCTRL_PULL0_BANK0_PIN20      20
#define BM_PINCTRL_PULL0_BANK0_PIN20      0x00100000

#define BF_PINCTRL_PULL0_BANK0_PIN20(v)   (((v) << 20) & BM_PINCTRL_PULL0_BANK0_PIN20)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN20(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN20, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN19 */

#define BP_PINCTRL_PULL0_BANK0_PIN19      19
#define BM_PINCTRL_PULL0_BANK0_PIN19      0x00080000

#define BF_PINCTRL_PULL0_BANK0_PIN19(v)   (((v) << 19) & BM_PINCTRL_PULL0_BANK0_PIN19)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN19(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN19, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN18 */

#define BP_PINCTRL_PULL0_BANK0_PIN18      18
#define BM_PINCTRL_PULL0_BANK0_PIN18      0x00040000

#define BF_PINCTRL_PULL0_BANK0_PIN18(v)   (((v) << 18) & BM_PINCTRL_PULL0_BANK0_PIN18)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN18(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN18, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN17 */

#define BP_PINCTRL_PULL0_BANK0_PIN17      17
#define BM_PINCTRL_PULL0_BANK0_PIN17      0x00020000

#define BF_PINCTRL_PULL0_BANK0_PIN17(v)   (((v) << 17) & BM_PINCTRL_PULL0_BANK0_PIN17)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN17(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN17, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN16 */

#define BP_PINCTRL_PULL0_BANK0_PIN16      16
#define BM_PINCTRL_PULL0_BANK0_PIN16      0x00010000

#define BF_PINCTRL_PULL0_BANK0_PIN16(v)   (((v) << 16) & BM_PINCTRL_PULL0_BANK0_PIN16)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN16(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN16, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field RSRVD0 */

#define BP_PINCTRL_PULL0_RSRVD0      8
#define BM_PINCTRL_PULL0_RSRVD0      0x0000FF00

#define BF_PINCTRL_PULL0_RSRVD0(v)   (((v) << 8) & BM_PINCTRL_PULL0_RSRVD0)
/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN07 */

#define BP_PINCTRL_PULL0_BANK0_PIN07      7
#define BM_PINCTRL_PULL0_BANK0_PIN07      0x00000080

#define BF_PINCTRL_PULL0_BANK0_PIN07(v)   (((v) << 7) & BM_PINCTRL_PULL0_BANK0_PIN07)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN07(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN07, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN06 */

#define BP_PINCTRL_PULL0_BANK0_PIN06      6
#define BM_PINCTRL_PULL0_BANK0_PIN06      0x00000040

#define BF_PINCTRL_PULL0_BANK0_PIN06(v)   (((v) << 6) & BM_PINCTRL_PULL0_BANK0_PIN06)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN06(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN06, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN05 */

#define BP_PINCTRL_PULL0_BANK0_PIN05      5
#define BM_PINCTRL_PULL0_BANK0_PIN05      0x00000020

#define BF_PINCTRL_PULL0_BANK0_PIN05(v)   (((v) << 5) & BM_PINCTRL_PULL0_BANK0_PIN05)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN05(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN05, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN04 */

#define BP_PINCTRL_PULL0_BANK0_PIN04      4
#define BM_PINCTRL_PULL0_BANK0_PIN04      0x00000010

#define BF_PINCTRL_PULL0_BANK0_PIN04(v)   (((v) << 4) & BM_PINCTRL_PULL0_BANK0_PIN04)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN04(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN04, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN03 */

#define BP_PINCTRL_PULL0_BANK0_PIN03      3
#define BM_PINCTRL_PULL0_BANK0_PIN03      0x00000008

#define BF_PINCTRL_PULL0_BANK0_PIN03(v)   (((v) << 3) & BM_PINCTRL_PULL0_BANK0_PIN03)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN03(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN03, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN02 */

#define BP_PINCTRL_PULL0_BANK0_PIN02      2
#define BM_PINCTRL_PULL0_BANK0_PIN02      0x00000004

#define BF_PINCTRL_PULL0_BANK0_PIN02(v)   (((v) << 2) & BM_PINCTRL_PULL0_BANK0_PIN02)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN02(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN02, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN01 */

#define BP_PINCTRL_PULL0_BANK0_PIN01      1
#define BM_PINCTRL_PULL0_BANK0_PIN01      0x00000002

#define BF_PINCTRL_PULL0_BANK0_PIN01(v)   (((v) << 1) & BM_PINCTRL_PULL0_BANK0_PIN01)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN01(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN01, v)
#endif

/* --- Register HW_PINCTRL_PULL0, field BANK0_PIN00 */

#define BP_PINCTRL_PULL0_BANK0_PIN00      0
#define BM_PINCTRL_PULL0_BANK0_PIN00      0x00000001

#define BF_PINCTRL_PULL0_BANK0_PIN00(v)   (((v) << 0) & BM_PINCTRL_PULL0_BANK0_PIN00)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL0_BANK0_PIN00(v)   BF_CS1(PINCTRL_PULL0, BANK0_PIN00, v)
#endif



/*
 * HW_PINCTRL_PULL1 - PINCTRL Bank 1 Pull Up Resistor Enable Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK1_PIN00  :  1;
        unsigned BANK1_PIN01  :  1;
        unsigned BANK1_PIN02  :  1;
        unsigned BANK1_PIN03  :  1;
        unsigned BANK1_PIN04  :  1;
        unsigned BANK1_PIN05  :  1;
        unsigned BANK1_PIN06  :  1;
        unsigned BANK1_PIN07  :  1;
        unsigned BANK1_PIN08  :  1;
        unsigned BANK1_PIN09  :  1;
        unsigned BANK1_PIN10  :  1;
        unsigned BANK1_PIN11  :  1;
        unsigned BANK1_PIN12  :  1;
        unsigned BANK1_PIN13  :  1;
        unsigned BANK1_PIN14  :  1;
        unsigned BANK1_PIN15  :  1;
        unsigned BANK1_PIN16  :  1;
        unsigned BANK1_PIN17  :  1;
        unsigned BANK1_PIN18  :  1;
        unsigned BANK1_PIN19  :  1;
        unsigned BANK1_PIN20  :  1;
        unsigned BANK1_PIN21  :  1;
        unsigned BANK1_PIN22  :  1;
        unsigned BANK1_PIN23  :  1;
        unsigned BANK1_PIN24  :  1;
        unsigned BANK1_PIN25  :  1;
        unsigned BANK1_PIN26  :  1;
        unsigned BANK1_PIN27  :  1;
        unsigned BANK1_PIN28  :  1;
        unsigned BANK1_PIN29  :  1;
        unsigned BANK1_PIN30  :  1;
        unsigned BANK1_PIN31  :  1;
    } B;
} hw_pinctrl_pull1_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_PULL1 register
 */
#define HW_PINCTRL_PULL1_ADDR         (REGS_PINCTRL_BASE + 0x610)
#define HW_PINCTRL_PULL1_SET_ADDR     (HW_PINCTRL_PULL1_ADDR + 4)
#define HW_PINCTRL_PULL1_CLR_ADDR     (HW_PINCTRL_PULL1_ADDR + 8)
#define HW_PINCTRL_PULL1_TOG_ADDR     (HW_PINCTRL_PULL1_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_PULL1           (*(volatile hw_pinctrl_pull1_t *) HW_PINCTRL_PULL1_ADDR)
#define HW_PINCTRL_PULL1_RD()      (HW_PINCTRL_PULL1.U)
#define HW_PINCTRL_PULL1_WR(v)     (HW_PINCTRL_PULL1.U = (v))
#define HW_PINCTRL_PULL1_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL1_SET_ADDR) = (v))
#define HW_PINCTRL_PULL1_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL1_CLR_ADDR) = (v))
#define HW_PINCTRL_PULL1_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL1_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_PULL1 bitfields
 */
/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN31 */

#define BP_PINCTRL_PULL1_BANK1_PIN31      31
#define BM_PINCTRL_PULL1_BANK1_PIN31      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_PULL1_BANK1_PIN31(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_PULL1_BANK1_PIN31)
#else
#define BF_PINCTRL_PULL1_BANK1_PIN31(v)   (((v) << 31) & BM_PINCTRL_PULL1_BANK1_PIN31)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN31(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN31, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN30 */

#define BP_PINCTRL_PULL1_BANK1_PIN30      30
#define BM_PINCTRL_PULL1_BANK1_PIN30      0x40000000

#define BF_PINCTRL_PULL1_BANK1_PIN30(v)   (((v) << 30) & BM_PINCTRL_PULL1_BANK1_PIN30)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN30(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN30, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN29 */

#define BP_PINCTRL_PULL1_BANK1_PIN29      29
#define BM_PINCTRL_PULL1_BANK1_PIN29      0x20000000

#define BF_PINCTRL_PULL1_BANK1_PIN29(v)   (((v) << 29) & BM_PINCTRL_PULL1_BANK1_PIN29)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN29(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN29, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN28 */

#define BP_PINCTRL_PULL1_BANK1_PIN28      28
#define BM_PINCTRL_PULL1_BANK1_PIN28      0x10000000

#define BF_PINCTRL_PULL1_BANK1_PIN28(v)   (((v) << 28) & BM_PINCTRL_PULL1_BANK1_PIN28)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN28(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN28, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN27 */

#define BP_PINCTRL_PULL1_BANK1_PIN27      27
#define BM_PINCTRL_PULL1_BANK1_PIN27      0x08000000

#define BF_PINCTRL_PULL1_BANK1_PIN27(v)   (((v) << 27) & BM_PINCTRL_PULL1_BANK1_PIN27)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN27(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN27, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN26 */

#define BP_PINCTRL_PULL1_BANK1_PIN26      26
#define BM_PINCTRL_PULL1_BANK1_PIN26      0x04000000

#define BF_PINCTRL_PULL1_BANK1_PIN26(v)   (((v) << 26) & BM_PINCTRL_PULL1_BANK1_PIN26)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN26(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN26, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN25 */

#define BP_PINCTRL_PULL1_BANK1_PIN25      25
#define BM_PINCTRL_PULL1_BANK1_PIN25      0x02000000

#define BF_PINCTRL_PULL1_BANK1_PIN25(v)   (((v) << 25) & BM_PINCTRL_PULL1_BANK1_PIN25)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN25(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN25, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN24 */

#define BP_PINCTRL_PULL1_BANK1_PIN24      24
#define BM_PINCTRL_PULL1_BANK1_PIN24      0x01000000

#define BF_PINCTRL_PULL1_BANK1_PIN24(v)   (((v) << 24) & BM_PINCTRL_PULL1_BANK1_PIN24)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN24(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN24, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN23 */

#define BP_PINCTRL_PULL1_BANK1_PIN23      23
#define BM_PINCTRL_PULL1_BANK1_PIN23      0x00800000

#define BF_PINCTRL_PULL1_BANK1_PIN23(v)   (((v) << 23) & BM_PINCTRL_PULL1_BANK1_PIN23)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN23(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN23, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN22 */

#define BP_PINCTRL_PULL1_BANK1_PIN22      22
#define BM_PINCTRL_PULL1_BANK1_PIN22      0x00400000

#define BF_PINCTRL_PULL1_BANK1_PIN22(v)   (((v) << 22) & BM_PINCTRL_PULL1_BANK1_PIN22)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN22(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN22, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN21 */

#define BP_PINCTRL_PULL1_BANK1_PIN21      21
#define BM_PINCTRL_PULL1_BANK1_PIN21      0x00200000

#define BF_PINCTRL_PULL1_BANK1_PIN21(v)   (((v) << 21) & BM_PINCTRL_PULL1_BANK1_PIN21)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN21(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN21, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN20 */

#define BP_PINCTRL_PULL1_BANK1_PIN20      20
#define BM_PINCTRL_PULL1_BANK1_PIN20      0x00100000

#define BF_PINCTRL_PULL1_BANK1_PIN20(v)   (((v) << 20) & BM_PINCTRL_PULL1_BANK1_PIN20)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN20(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN20, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN19 */

#define BP_PINCTRL_PULL1_BANK1_PIN19      19
#define BM_PINCTRL_PULL1_BANK1_PIN19      0x00080000

#define BF_PINCTRL_PULL1_BANK1_PIN19(v)   (((v) << 19) & BM_PINCTRL_PULL1_BANK1_PIN19)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN19(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN19, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN18 */

#define BP_PINCTRL_PULL1_BANK1_PIN18      18
#define BM_PINCTRL_PULL1_BANK1_PIN18      0x00040000

#define BF_PINCTRL_PULL1_BANK1_PIN18(v)   (((v) << 18) & BM_PINCTRL_PULL1_BANK1_PIN18)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN18(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN18, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN17 */

#define BP_PINCTRL_PULL1_BANK1_PIN17      17
#define BM_PINCTRL_PULL1_BANK1_PIN17      0x00020000

#define BF_PINCTRL_PULL1_BANK1_PIN17(v)   (((v) << 17) & BM_PINCTRL_PULL1_BANK1_PIN17)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN17(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN17, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN16 */

#define BP_PINCTRL_PULL1_BANK1_PIN16      16
#define BM_PINCTRL_PULL1_BANK1_PIN16      0x00010000

#define BF_PINCTRL_PULL1_BANK1_PIN16(v)   (((v) << 16) & BM_PINCTRL_PULL1_BANK1_PIN16)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN16(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN16, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN15 */

#define BP_PINCTRL_PULL1_BANK1_PIN15      15
#define BM_PINCTRL_PULL1_BANK1_PIN15      0x00008000

#define BF_PINCTRL_PULL1_BANK1_PIN15(v)   (((v) << 15) & BM_PINCTRL_PULL1_BANK1_PIN15)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN15(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN15, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN14 */

#define BP_PINCTRL_PULL1_BANK1_PIN14      14
#define BM_PINCTRL_PULL1_BANK1_PIN14      0x00004000

#define BF_PINCTRL_PULL1_BANK1_PIN14(v)   (((v) << 14) & BM_PINCTRL_PULL1_BANK1_PIN14)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN14(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN14, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN13 */

#define BP_PINCTRL_PULL1_BANK1_PIN13      13
#define BM_PINCTRL_PULL1_BANK1_PIN13      0x00002000

#define BF_PINCTRL_PULL1_BANK1_PIN13(v)   (((v) << 13) & BM_PINCTRL_PULL1_BANK1_PIN13)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN13(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN13, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN12 */

#define BP_PINCTRL_PULL1_BANK1_PIN12      12
#define BM_PINCTRL_PULL1_BANK1_PIN12      0x00001000

#define BF_PINCTRL_PULL1_BANK1_PIN12(v)   (((v) << 12) & BM_PINCTRL_PULL1_BANK1_PIN12)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN12(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN12, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN11 */

#define BP_PINCTRL_PULL1_BANK1_PIN11      11
#define BM_PINCTRL_PULL1_BANK1_PIN11      0x00000800

#define BF_PINCTRL_PULL1_BANK1_PIN11(v)   (((v) << 11) & BM_PINCTRL_PULL1_BANK1_PIN11)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN11(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN11, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN10 */

#define BP_PINCTRL_PULL1_BANK1_PIN10      10
#define BM_PINCTRL_PULL1_BANK1_PIN10      0x00000400

#define BF_PINCTRL_PULL1_BANK1_PIN10(v)   (((v) << 10) & BM_PINCTRL_PULL1_BANK1_PIN10)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN10(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN10, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN09 */

#define BP_PINCTRL_PULL1_BANK1_PIN09      9
#define BM_PINCTRL_PULL1_BANK1_PIN09      0x00000200

#define BF_PINCTRL_PULL1_BANK1_PIN09(v)   (((v) << 9) & BM_PINCTRL_PULL1_BANK1_PIN09)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN09(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN09, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN08 */

#define BP_PINCTRL_PULL1_BANK1_PIN08      8
#define BM_PINCTRL_PULL1_BANK1_PIN08      0x00000100

#define BF_PINCTRL_PULL1_BANK1_PIN08(v)   (((v) << 8) & BM_PINCTRL_PULL1_BANK1_PIN08)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN08(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN08, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN07 */

#define BP_PINCTRL_PULL1_BANK1_PIN07      7
#define BM_PINCTRL_PULL1_BANK1_PIN07      0x00000080

#define BF_PINCTRL_PULL1_BANK1_PIN07(v)   (((v) << 7) & BM_PINCTRL_PULL1_BANK1_PIN07)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN07(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN07, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN06 */

#define BP_PINCTRL_PULL1_BANK1_PIN06      6
#define BM_PINCTRL_PULL1_BANK1_PIN06      0x00000040

#define BF_PINCTRL_PULL1_BANK1_PIN06(v)   (((v) << 6) & BM_PINCTRL_PULL1_BANK1_PIN06)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN06(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN06, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN05 */

#define BP_PINCTRL_PULL1_BANK1_PIN05      5
#define BM_PINCTRL_PULL1_BANK1_PIN05      0x00000020

#define BF_PINCTRL_PULL1_BANK1_PIN05(v)   (((v) << 5) & BM_PINCTRL_PULL1_BANK1_PIN05)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN05(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN05, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN04 */

#define BP_PINCTRL_PULL1_BANK1_PIN04      4
#define BM_PINCTRL_PULL1_BANK1_PIN04      0x00000010

#define BF_PINCTRL_PULL1_BANK1_PIN04(v)   (((v) << 4) & BM_PINCTRL_PULL1_BANK1_PIN04)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN04(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN04, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN03 */

#define BP_PINCTRL_PULL1_BANK1_PIN03      3
#define BM_PINCTRL_PULL1_BANK1_PIN03      0x00000008

#define BF_PINCTRL_PULL1_BANK1_PIN03(v)   (((v) << 3) & BM_PINCTRL_PULL1_BANK1_PIN03)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN03(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN03, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN02 */

#define BP_PINCTRL_PULL1_BANK1_PIN02      2
#define BM_PINCTRL_PULL1_BANK1_PIN02      0x00000004

#define BF_PINCTRL_PULL1_BANK1_PIN02(v)   (((v) << 2) & BM_PINCTRL_PULL1_BANK1_PIN02)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN02(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN02, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN01 */

#define BP_PINCTRL_PULL1_BANK1_PIN01      1
#define BM_PINCTRL_PULL1_BANK1_PIN01      0x00000002

#define BF_PINCTRL_PULL1_BANK1_PIN01(v)   (((v) << 1) & BM_PINCTRL_PULL1_BANK1_PIN01)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN01(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN01, v)
#endif

/* --- Register HW_PINCTRL_PULL1, field BANK1_PIN00 */

#define BP_PINCTRL_PULL1_BANK1_PIN00      0
#define BM_PINCTRL_PULL1_BANK1_PIN00      0x00000001

#define BF_PINCTRL_PULL1_BANK1_PIN00(v)   (((v) << 0) & BM_PINCTRL_PULL1_BANK1_PIN00)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL1_BANK1_PIN00(v)   BF_CS1(PINCTRL_PULL1, BANK1_PIN00, v)
#endif



/*
 * HW_PINCTRL_PULL2 - PINCTRL Bank 2 Pull Up Resistor Enable Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK2_PIN00  :  1;
        unsigned BANK2_PIN01  :  1;
        unsigned BANK2_PIN02  :  1;
        unsigned BANK2_PIN03  :  1;
        unsigned BANK2_PIN04  :  1;
        unsigned BANK2_PIN05  :  1;
        unsigned BANK2_PIN06  :  1;
        unsigned BANK2_PIN07  :  1;
        unsigned BANK2_PIN08  :  1;
        unsigned BANK2_PIN09  :  1;
        unsigned BANK2_PIN10  :  1;
        unsigned RSRVD0       :  1;
        unsigned BANK2_PIN12  :  1;
        unsigned BANK2_PIN13  :  1;
        unsigned BANK2_PIN14  :  1;
        unsigned BANK2_PIN15  :  1;
        unsigned BANK2_PIN16  :  1;
        unsigned BANK2_PIN17  :  1;
        unsigned BANK2_PIN18  :  1;
        unsigned BANK2_PIN19  :  1;
        unsigned BANK2_PIN20  :  1;
        unsigned BANK2_PIN21  :  1;
        unsigned RSRVD1       :  2;
        unsigned BANK2_PIN24  :  1;
        unsigned BANK2_PIN25  :  1;
        unsigned BANK2_PIN26  :  1;
        unsigned BANK2_PIN27  :  1;
        unsigned RSRVD2       :  4;
    } B;
} hw_pinctrl_pull2_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_PULL2 register
 */
#define HW_PINCTRL_PULL2_ADDR         (REGS_PINCTRL_BASE + 0x620)
#define HW_PINCTRL_PULL2_SET_ADDR     (HW_PINCTRL_PULL2_ADDR + 4)
#define HW_PINCTRL_PULL2_CLR_ADDR     (HW_PINCTRL_PULL2_ADDR + 8)
#define HW_PINCTRL_PULL2_TOG_ADDR     (HW_PINCTRL_PULL2_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_PULL2           (*(volatile hw_pinctrl_pull2_t *) HW_PINCTRL_PULL2_ADDR)
#define HW_PINCTRL_PULL2_RD()      (HW_PINCTRL_PULL2.U)
#define HW_PINCTRL_PULL2_WR(v)     (HW_PINCTRL_PULL2.U = (v))
#define HW_PINCTRL_PULL2_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL2_SET_ADDR) = (v))
#define HW_PINCTRL_PULL2_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL2_CLR_ADDR) = (v))
#define HW_PINCTRL_PULL2_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL2_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_PULL2 bitfields
 */
/* --- Register HW_PINCTRL_PULL2, field RSRVD2 */

#define BP_PINCTRL_PULL2_RSRVD2      28
#define BM_PINCTRL_PULL2_RSRVD2      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_PULL2_RSRVD2(v)   ((((reg32_t) v) << 28) & BM_PINCTRL_PULL2_RSRVD2)
#else
#define BF_PINCTRL_PULL2_RSRVD2(v)   (((v) << 28) & BM_PINCTRL_PULL2_RSRVD2)
#endif
/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN27 */

#define BP_PINCTRL_PULL2_BANK2_PIN27      27
#define BM_PINCTRL_PULL2_BANK2_PIN27      0x08000000

#define BF_PINCTRL_PULL2_BANK2_PIN27(v)   (((v) << 27) & BM_PINCTRL_PULL2_BANK2_PIN27)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN27(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN27, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN26 */

#define BP_PINCTRL_PULL2_BANK2_PIN26      26
#define BM_PINCTRL_PULL2_BANK2_PIN26      0x04000000

#define BF_PINCTRL_PULL2_BANK2_PIN26(v)   (((v) << 26) & BM_PINCTRL_PULL2_BANK2_PIN26)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN26(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN26, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN25 */

#define BP_PINCTRL_PULL2_BANK2_PIN25      25
#define BM_PINCTRL_PULL2_BANK2_PIN25      0x02000000

#define BF_PINCTRL_PULL2_BANK2_PIN25(v)   (((v) << 25) & BM_PINCTRL_PULL2_BANK2_PIN25)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN25(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN25, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN24 */

#define BP_PINCTRL_PULL2_BANK2_PIN24      24
#define BM_PINCTRL_PULL2_BANK2_PIN24      0x01000000

#define BF_PINCTRL_PULL2_BANK2_PIN24(v)   (((v) << 24) & BM_PINCTRL_PULL2_BANK2_PIN24)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN24(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN24, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field RSRVD1 */

#define BP_PINCTRL_PULL2_RSRVD1      22
#define BM_PINCTRL_PULL2_RSRVD1      0x00C00000

#define BF_PINCTRL_PULL2_RSRVD1(v)   (((v) << 22) & BM_PINCTRL_PULL2_RSRVD1)
/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN21 */

#define BP_PINCTRL_PULL2_BANK2_PIN21      21
#define BM_PINCTRL_PULL2_BANK2_PIN21      0x00200000

#define BF_PINCTRL_PULL2_BANK2_PIN21(v)   (((v) << 21) & BM_PINCTRL_PULL2_BANK2_PIN21)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN21(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN21, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN20 */

#define BP_PINCTRL_PULL2_BANK2_PIN20      20
#define BM_PINCTRL_PULL2_BANK2_PIN20      0x00100000

#define BF_PINCTRL_PULL2_BANK2_PIN20(v)   (((v) << 20) & BM_PINCTRL_PULL2_BANK2_PIN20)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN20(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN20, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN19 */

#define BP_PINCTRL_PULL2_BANK2_PIN19      19
#define BM_PINCTRL_PULL2_BANK2_PIN19      0x00080000

#define BF_PINCTRL_PULL2_BANK2_PIN19(v)   (((v) << 19) & BM_PINCTRL_PULL2_BANK2_PIN19)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN19(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN19, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN18 */

#define BP_PINCTRL_PULL2_BANK2_PIN18      18
#define BM_PINCTRL_PULL2_BANK2_PIN18      0x00040000

#define BF_PINCTRL_PULL2_BANK2_PIN18(v)   (((v) << 18) & BM_PINCTRL_PULL2_BANK2_PIN18)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN18(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN18, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN17 */

#define BP_PINCTRL_PULL2_BANK2_PIN17      17
#define BM_PINCTRL_PULL2_BANK2_PIN17      0x00020000

#define BF_PINCTRL_PULL2_BANK2_PIN17(v)   (((v) << 17) & BM_PINCTRL_PULL2_BANK2_PIN17)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN17(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN17, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN16 */

#define BP_PINCTRL_PULL2_BANK2_PIN16      16
#define BM_PINCTRL_PULL2_BANK2_PIN16      0x00010000

#define BF_PINCTRL_PULL2_BANK2_PIN16(v)   (((v) << 16) & BM_PINCTRL_PULL2_BANK2_PIN16)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN16(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN16, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN15 */

#define BP_PINCTRL_PULL2_BANK2_PIN15      15
#define BM_PINCTRL_PULL2_BANK2_PIN15      0x00008000

#define BF_PINCTRL_PULL2_BANK2_PIN15(v)   (((v) << 15) & BM_PINCTRL_PULL2_BANK2_PIN15)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN15(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN15, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN14 */

#define BP_PINCTRL_PULL2_BANK2_PIN14      14
#define BM_PINCTRL_PULL2_BANK2_PIN14      0x00004000

#define BF_PINCTRL_PULL2_BANK2_PIN14(v)   (((v) << 14) & BM_PINCTRL_PULL2_BANK2_PIN14)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN14(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN14, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN13 */

#define BP_PINCTRL_PULL2_BANK2_PIN13      13
#define BM_PINCTRL_PULL2_BANK2_PIN13      0x00002000

#define BF_PINCTRL_PULL2_BANK2_PIN13(v)   (((v) << 13) & BM_PINCTRL_PULL2_BANK2_PIN13)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN13(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN13, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN12 */

#define BP_PINCTRL_PULL2_BANK2_PIN12      12
#define BM_PINCTRL_PULL2_BANK2_PIN12      0x00001000

#define BF_PINCTRL_PULL2_BANK2_PIN12(v)   (((v) << 12) & BM_PINCTRL_PULL2_BANK2_PIN12)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN12(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN12, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field RSRVD0 */

#define BP_PINCTRL_PULL2_RSRVD0      11
#define BM_PINCTRL_PULL2_RSRVD0      0x00000800

#define BF_PINCTRL_PULL2_RSRVD0(v)   (((v) << 11) & BM_PINCTRL_PULL2_RSRVD0)
/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN10 */

#define BP_PINCTRL_PULL2_BANK2_PIN10      10
#define BM_PINCTRL_PULL2_BANK2_PIN10      0x00000400

#define BF_PINCTRL_PULL2_BANK2_PIN10(v)   (((v) << 10) & BM_PINCTRL_PULL2_BANK2_PIN10)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN10(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN10, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN09 */

#define BP_PINCTRL_PULL2_BANK2_PIN09      9
#define BM_PINCTRL_PULL2_BANK2_PIN09      0x00000200

#define BF_PINCTRL_PULL2_BANK2_PIN09(v)   (((v) << 9) & BM_PINCTRL_PULL2_BANK2_PIN09)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN09(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN09, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN08 */

#define BP_PINCTRL_PULL2_BANK2_PIN08      8
#define BM_PINCTRL_PULL2_BANK2_PIN08      0x00000100

#define BF_PINCTRL_PULL2_BANK2_PIN08(v)   (((v) << 8) & BM_PINCTRL_PULL2_BANK2_PIN08)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN08(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN08, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN07 */

#define BP_PINCTRL_PULL2_BANK2_PIN07      7
#define BM_PINCTRL_PULL2_BANK2_PIN07      0x00000080

#define BF_PINCTRL_PULL2_BANK2_PIN07(v)   (((v) << 7) & BM_PINCTRL_PULL2_BANK2_PIN07)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN07(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN07, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN06 */

#define BP_PINCTRL_PULL2_BANK2_PIN06      6
#define BM_PINCTRL_PULL2_BANK2_PIN06      0x00000040

#define BF_PINCTRL_PULL2_BANK2_PIN06(v)   (((v) << 6) & BM_PINCTRL_PULL2_BANK2_PIN06)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN06(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN06, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN05 */

#define BP_PINCTRL_PULL2_BANK2_PIN05      5
#define BM_PINCTRL_PULL2_BANK2_PIN05      0x00000020

#define BF_PINCTRL_PULL2_BANK2_PIN05(v)   (((v) << 5) & BM_PINCTRL_PULL2_BANK2_PIN05)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN05(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN05, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN04 */

#define BP_PINCTRL_PULL2_BANK2_PIN04      4
#define BM_PINCTRL_PULL2_BANK2_PIN04      0x00000010

#define BF_PINCTRL_PULL2_BANK2_PIN04(v)   (((v) << 4) & BM_PINCTRL_PULL2_BANK2_PIN04)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN04(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN04, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN03 */

#define BP_PINCTRL_PULL2_BANK2_PIN03      3
#define BM_PINCTRL_PULL2_BANK2_PIN03      0x00000008

#define BF_PINCTRL_PULL2_BANK2_PIN03(v)   (((v) << 3) & BM_PINCTRL_PULL2_BANK2_PIN03)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN03(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN03, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN02 */

#define BP_PINCTRL_PULL2_BANK2_PIN02      2
#define BM_PINCTRL_PULL2_BANK2_PIN02      0x00000004

#define BF_PINCTRL_PULL2_BANK2_PIN02(v)   (((v) << 2) & BM_PINCTRL_PULL2_BANK2_PIN02)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN02(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN02, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN01 */

#define BP_PINCTRL_PULL2_BANK2_PIN01      1
#define BM_PINCTRL_PULL2_BANK2_PIN01      0x00000002

#define BF_PINCTRL_PULL2_BANK2_PIN01(v)   (((v) << 1) & BM_PINCTRL_PULL2_BANK2_PIN01)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN01(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN01, v)
#endif

/* --- Register HW_PINCTRL_PULL2, field BANK2_PIN00 */

#define BP_PINCTRL_PULL2_BANK2_PIN00      0
#define BM_PINCTRL_PULL2_BANK2_PIN00      0x00000001

#define BF_PINCTRL_PULL2_BANK2_PIN00(v)   (((v) << 0) & BM_PINCTRL_PULL2_BANK2_PIN00)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL2_BANK2_PIN00(v)   BF_CS1(PINCTRL_PULL2, BANK2_PIN00, v)
#endif



/*
 * HW_PINCTRL_PULL3 - PINCTRL Bank 3 Pull Up Resistor Enable Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK3_PIN00  :  1;
        unsigned BANK3_PIN01  :  1;
        unsigned BANK3_PIN02  :  1;
        unsigned BANK3_PIN03  :  1;
        unsigned BANK3_PIN04  :  1;
        unsigned BANK3_PIN05  :  1;
        unsigned BANK3_PIN06  :  1;
        unsigned BANK3_PIN07  :  1;
        unsigned BANK3_PIN08  :  1;
        unsigned BANK3_PIN09  :  1;
        unsigned BANK3_PIN10  :  1;
        unsigned BANK3_PIN11  :  1;
        unsigned BANK3_PIN12  :  1;
        unsigned BANK3_PIN13  :  1;
        unsigned BANK3_PIN14  :  1;
        unsigned BANK3_PIN15  :  1;
        unsigned BANK3_PIN16  :  1;
        unsigned BANK3_PIN17  :  1;
        unsigned BANK3_PIN18  :  1;
        unsigned RSRVD0       :  1;
        unsigned BANK3_PIN20  :  1;
        unsigned BANK3_PIN21  :  1;
        unsigned BANK3_PIN22  :  1;
        unsigned BANK3_PIN23  :  1;
        unsigned BANK3_PIN24  :  1;
        unsigned BANK3_PIN25  :  1;
        unsigned BANK3_PIN26  :  1;
        unsigned BANK3_PIN27  :  1;
        unsigned BANK3_PIN28  :  1;
        unsigned BANK3_PIN29  :  1;
        unsigned BANK3_PIN30  :  1;
        unsigned RSRVD1       :  1;
    } B;
} hw_pinctrl_pull3_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_PULL3 register
 */
#define HW_PINCTRL_PULL3_ADDR         (REGS_PINCTRL_BASE + 0x630)
#define HW_PINCTRL_PULL3_SET_ADDR     (HW_PINCTRL_PULL3_ADDR + 4)
#define HW_PINCTRL_PULL3_CLR_ADDR     (HW_PINCTRL_PULL3_ADDR + 8)
#define HW_PINCTRL_PULL3_TOG_ADDR     (HW_PINCTRL_PULL3_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_PULL3           (*(volatile hw_pinctrl_pull3_t *) HW_PINCTRL_PULL3_ADDR)
#define HW_PINCTRL_PULL3_RD()      (HW_PINCTRL_PULL3.U)
#define HW_PINCTRL_PULL3_WR(v)     (HW_PINCTRL_PULL3.U = (v))
#define HW_PINCTRL_PULL3_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL3_SET_ADDR) = (v))
#define HW_PINCTRL_PULL3_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL3_CLR_ADDR) = (v))
#define HW_PINCTRL_PULL3_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL3_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_PULL3 bitfields
 */
/* --- Register HW_PINCTRL_PULL3, field RSRVD1 */

#define BP_PINCTRL_PULL3_RSRVD1      31
#define BM_PINCTRL_PULL3_RSRVD1      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_PULL3_RSRVD1(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_PULL3_RSRVD1)
#else
#define BF_PINCTRL_PULL3_RSRVD1(v)   (((v) << 31) & BM_PINCTRL_PULL3_RSRVD1)
#endif
/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN30 */

#define BP_PINCTRL_PULL3_BANK3_PIN30      30
#define BM_PINCTRL_PULL3_BANK3_PIN30      0x40000000

#define BF_PINCTRL_PULL3_BANK3_PIN30(v)   (((v) << 30) & BM_PINCTRL_PULL3_BANK3_PIN30)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN30(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN30, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN29 */

#define BP_PINCTRL_PULL3_BANK3_PIN29      29
#define BM_PINCTRL_PULL3_BANK3_PIN29      0x20000000

#define BF_PINCTRL_PULL3_BANK3_PIN29(v)   (((v) << 29) & BM_PINCTRL_PULL3_BANK3_PIN29)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN29(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN29, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN28 */

#define BP_PINCTRL_PULL3_BANK3_PIN28      28
#define BM_PINCTRL_PULL3_BANK3_PIN28      0x10000000

#define BF_PINCTRL_PULL3_BANK3_PIN28(v)   (((v) << 28) & BM_PINCTRL_PULL3_BANK3_PIN28)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN28(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN28, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN27 */

#define BP_PINCTRL_PULL3_BANK3_PIN27      27
#define BM_PINCTRL_PULL3_BANK3_PIN27      0x08000000

#define BF_PINCTRL_PULL3_BANK3_PIN27(v)   (((v) << 27) & BM_PINCTRL_PULL3_BANK3_PIN27)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN27(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN27, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN26 */

#define BP_PINCTRL_PULL3_BANK3_PIN26      26
#define BM_PINCTRL_PULL3_BANK3_PIN26      0x04000000

#define BF_PINCTRL_PULL3_BANK3_PIN26(v)   (((v) << 26) & BM_PINCTRL_PULL3_BANK3_PIN26)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN26(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN26, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN25 */

#define BP_PINCTRL_PULL3_BANK3_PIN25      25
#define BM_PINCTRL_PULL3_BANK3_PIN25      0x02000000

#define BF_PINCTRL_PULL3_BANK3_PIN25(v)   (((v) << 25) & BM_PINCTRL_PULL3_BANK3_PIN25)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN25(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN25, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN24 */

#define BP_PINCTRL_PULL3_BANK3_PIN24      24
#define BM_PINCTRL_PULL3_BANK3_PIN24      0x01000000

#define BF_PINCTRL_PULL3_BANK3_PIN24(v)   (((v) << 24) & BM_PINCTRL_PULL3_BANK3_PIN24)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN24(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN24, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN23 */

#define BP_PINCTRL_PULL3_BANK3_PIN23      23
#define BM_PINCTRL_PULL3_BANK3_PIN23      0x00800000

#define BF_PINCTRL_PULL3_BANK3_PIN23(v)   (((v) << 23) & BM_PINCTRL_PULL3_BANK3_PIN23)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN23(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN23, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN22 */

#define BP_PINCTRL_PULL3_BANK3_PIN22      22
#define BM_PINCTRL_PULL3_BANK3_PIN22      0x00400000

#define BF_PINCTRL_PULL3_BANK3_PIN22(v)   (((v) << 22) & BM_PINCTRL_PULL3_BANK3_PIN22)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN22(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN22, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN21 */

#define BP_PINCTRL_PULL3_BANK3_PIN21      21
#define BM_PINCTRL_PULL3_BANK3_PIN21      0x00200000

#define BF_PINCTRL_PULL3_BANK3_PIN21(v)   (((v) << 21) & BM_PINCTRL_PULL3_BANK3_PIN21)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN21(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN21, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN20 */

#define BP_PINCTRL_PULL3_BANK3_PIN20      20
#define BM_PINCTRL_PULL3_BANK3_PIN20      0x00100000

#define BF_PINCTRL_PULL3_BANK3_PIN20(v)   (((v) << 20) & BM_PINCTRL_PULL3_BANK3_PIN20)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN20(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN20, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field RSRVD0 */

#define BP_PINCTRL_PULL3_RSRVD0      19
#define BM_PINCTRL_PULL3_RSRVD0      0x00080000

#define BF_PINCTRL_PULL3_RSRVD0(v)   (((v) << 19) & BM_PINCTRL_PULL3_RSRVD0)
/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN18 */

#define BP_PINCTRL_PULL3_BANK3_PIN18      18
#define BM_PINCTRL_PULL3_BANK3_PIN18      0x00040000

#define BF_PINCTRL_PULL3_BANK3_PIN18(v)   (((v) << 18) & BM_PINCTRL_PULL3_BANK3_PIN18)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN18(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN18, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN17 */

#define BP_PINCTRL_PULL3_BANK3_PIN17      17
#define BM_PINCTRL_PULL3_BANK3_PIN17      0x00020000

#define BF_PINCTRL_PULL3_BANK3_PIN17(v)   (((v) << 17) & BM_PINCTRL_PULL3_BANK3_PIN17)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN17(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN17, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN16 */

#define BP_PINCTRL_PULL3_BANK3_PIN16      16
#define BM_PINCTRL_PULL3_BANK3_PIN16      0x00010000

#define BF_PINCTRL_PULL3_BANK3_PIN16(v)   (((v) << 16) & BM_PINCTRL_PULL3_BANK3_PIN16)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN16(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN16, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN15 */

#define BP_PINCTRL_PULL3_BANK3_PIN15      15
#define BM_PINCTRL_PULL3_BANK3_PIN15      0x00008000

#define BF_PINCTRL_PULL3_BANK3_PIN15(v)   (((v) << 15) & BM_PINCTRL_PULL3_BANK3_PIN15)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN15(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN15, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN14 */

#define BP_PINCTRL_PULL3_BANK3_PIN14      14
#define BM_PINCTRL_PULL3_BANK3_PIN14      0x00004000

#define BF_PINCTRL_PULL3_BANK3_PIN14(v)   (((v) << 14) & BM_PINCTRL_PULL3_BANK3_PIN14)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN14(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN14, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN13 */

#define BP_PINCTRL_PULL3_BANK3_PIN13      13
#define BM_PINCTRL_PULL3_BANK3_PIN13      0x00002000

#define BF_PINCTRL_PULL3_BANK3_PIN13(v)   (((v) << 13) & BM_PINCTRL_PULL3_BANK3_PIN13)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN13(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN13, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN12 */

#define BP_PINCTRL_PULL3_BANK3_PIN12      12
#define BM_PINCTRL_PULL3_BANK3_PIN12      0x00001000

#define BF_PINCTRL_PULL3_BANK3_PIN12(v)   (((v) << 12) & BM_PINCTRL_PULL3_BANK3_PIN12)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN12(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN12, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN11 */

#define BP_PINCTRL_PULL3_BANK3_PIN11      11
#define BM_PINCTRL_PULL3_BANK3_PIN11      0x00000800

#define BF_PINCTRL_PULL3_BANK3_PIN11(v)   (((v) << 11) & BM_PINCTRL_PULL3_BANK3_PIN11)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN11(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN11, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN10 */

#define BP_PINCTRL_PULL3_BANK3_PIN10      10
#define BM_PINCTRL_PULL3_BANK3_PIN10      0x00000400

#define BF_PINCTRL_PULL3_BANK3_PIN10(v)   (((v) << 10) & BM_PINCTRL_PULL3_BANK3_PIN10)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN10(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN10, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN09 */

#define BP_PINCTRL_PULL3_BANK3_PIN09      9
#define BM_PINCTRL_PULL3_BANK3_PIN09      0x00000200

#define BF_PINCTRL_PULL3_BANK3_PIN09(v)   (((v) << 9) & BM_PINCTRL_PULL3_BANK3_PIN09)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN09(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN09, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN08 */

#define BP_PINCTRL_PULL3_BANK3_PIN08      8
#define BM_PINCTRL_PULL3_BANK3_PIN08      0x00000100

#define BF_PINCTRL_PULL3_BANK3_PIN08(v)   (((v) << 8) & BM_PINCTRL_PULL3_BANK3_PIN08)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN08(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN08, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN07 */

#define BP_PINCTRL_PULL3_BANK3_PIN07      7
#define BM_PINCTRL_PULL3_BANK3_PIN07      0x00000080

#define BF_PINCTRL_PULL3_BANK3_PIN07(v)   (((v) << 7) & BM_PINCTRL_PULL3_BANK3_PIN07)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN07(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN07, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN06 */

#define BP_PINCTRL_PULL3_BANK3_PIN06      6
#define BM_PINCTRL_PULL3_BANK3_PIN06      0x00000040

#define BF_PINCTRL_PULL3_BANK3_PIN06(v)   (((v) << 6) & BM_PINCTRL_PULL3_BANK3_PIN06)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN06(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN06, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN05 */

#define BP_PINCTRL_PULL3_BANK3_PIN05      5
#define BM_PINCTRL_PULL3_BANK3_PIN05      0x00000020

#define BF_PINCTRL_PULL3_BANK3_PIN05(v)   (((v) << 5) & BM_PINCTRL_PULL3_BANK3_PIN05)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN05(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN05, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN04 */

#define BP_PINCTRL_PULL3_BANK3_PIN04      4
#define BM_PINCTRL_PULL3_BANK3_PIN04      0x00000010

#define BF_PINCTRL_PULL3_BANK3_PIN04(v)   (((v) << 4) & BM_PINCTRL_PULL3_BANK3_PIN04)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN04(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN04, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN03 */

#define BP_PINCTRL_PULL3_BANK3_PIN03      3
#define BM_PINCTRL_PULL3_BANK3_PIN03      0x00000008

#define BF_PINCTRL_PULL3_BANK3_PIN03(v)   (((v) << 3) & BM_PINCTRL_PULL3_BANK3_PIN03)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN03(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN03, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN02 */

#define BP_PINCTRL_PULL3_BANK3_PIN02      2
#define BM_PINCTRL_PULL3_BANK3_PIN02      0x00000004

#define BF_PINCTRL_PULL3_BANK3_PIN02(v)   (((v) << 2) & BM_PINCTRL_PULL3_BANK3_PIN02)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN02(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN02, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN01 */

#define BP_PINCTRL_PULL3_BANK3_PIN01      1
#define BM_PINCTRL_PULL3_BANK3_PIN01      0x00000002

#define BF_PINCTRL_PULL3_BANK3_PIN01(v)   (((v) << 1) & BM_PINCTRL_PULL3_BANK3_PIN01)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN01(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN01, v)
#endif

/* --- Register HW_PINCTRL_PULL3, field BANK3_PIN00 */

#define BP_PINCTRL_PULL3_BANK3_PIN00      0
#define BM_PINCTRL_PULL3_BANK3_PIN00      0x00000001

#define BF_PINCTRL_PULL3_BANK3_PIN00(v)   (((v) << 0) & BM_PINCTRL_PULL3_BANK3_PIN00)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL3_BANK3_PIN00(v)   BF_CS1(PINCTRL_PULL3, BANK3_PIN00, v)
#endif



/*
 * HW_PINCTRL_PULL4 - PINCTRL Bank 4 Pull Up Resistor Enable Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK4_PIN00  :  1;
        unsigned BANK4_PIN01  :  1;
        unsigned BANK4_PIN02  :  1;
        unsigned BANK4_PIN03  :  1;
        unsigned BANK4_PIN04  :  1;
        unsigned BANK4_PIN05  :  1;
        unsigned BANK4_PIN06  :  1;
        unsigned BANK4_PIN07  :  1;
        unsigned BANK4_PIN08  :  1;
        unsigned BANK4_PIN09  :  1;
        unsigned BANK4_PIN10  :  1;
        unsigned BANK4_PIN11  :  1;
        unsigned BANK4_PIN12  :  1;
        unsigned BANK4_PIN13  :  1;
        unsigned BANK4_PIN14  :  1;
        unsigned BANK4_PIN15  :  1;
        unsigned BANK4_PIN16  :  1;
        unsigned RSRVD0       :  3;
        unsigned BANK4_PIN20  :  1;
        unsigned RSRVD1       : 11;
    } B;
} hw_pinctrl_pull4_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_PULL4 register
 */
#define HW_PINCTRL_PULL4_ADDR         (REGS_PINCTRL_BASE + 0x640)
#define HW_PINCTRL_PULL4_SET_ADDR     (HW_PINCTRL_PULL4_ADDR + 4)
#define HW_PINCTRL_PULL4_CLR_ADDR     (HW_PINCTRL_PULL4_ADDR + 8)
#define HW_PINCTRL_PULL4_TOG_ADDR     (HW_PINCTRL_PULL4_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_PULL4           (*(volatile hw_pinctrl_pull4_t *) HW_PINCTRL_PULL4_ADDR)
#define HW_PINCTRL_PULL4_RD()      (HW_PINCTRL_PULL4.U)
#define HW_PINCTRL_PULL4_WR(v)     (HW_PINCTRL_PULL4.U = (v))
#define HW_PINCTRL_PULL4_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL4_SET_ADDR) = (v))
#define HW_PINCTRL_PULL4_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL4_CLR_ADDR) = (v))
#define HW_PINCTRL_PULL4_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL4_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_PULL4 bitfields
 */
/* --- Register HW_PINCTRL_PULL4, field RSRVD1 */

#define BP_PINCTRL_PULL4_RSRVD1      21
#define BM_PINCTRL_PULL4_RSRVD1      0xFFE00000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_PULL4_RSRVD1(v)   ((((reg32_t) v) << 21) & BM_PINCTRL_PULL4_RSRVD1)
#else
#define BF_PINCTRL_PULL4_RSRVD1(v)   (((v) << 21) & BM_PINCTRL_PULL4_RSRVD1)
#endif
/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN20 */

#define BP_PINCTRL_PULL4_BANK4_PIN20      20
#define BM_PINCTRL_PULL4_BANK4_PIN20      0x00100000

#define BF_PINCTRL_PULL4_BANK4_PIN20(v)   (((v) << 20) & BM_PINCTRL_PULL4_BANK4_PIN20)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN20(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN20, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field RSRVD0 */

#define BP_PINCTRL_PULL4_RSRVD0      17
#define BM_PINCTRL_PULL4_RSRVD0      0x000E0000

#define BF_PINCTRL_PULL4_RSRVD0(v)   (((v) << 17) & BM_PINCTRL_PULL4_RSRVD0)
/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN16 */

#define BP_PINCTRL_PULL4_BANK4_PIN16      16
#define BM_PINCTRL_PULL4_BANK4_PIN16      0x00010000

#define BF_PINCTRL_PULL4_BANK4_PIN16(v)   (((v) << 16) & BM_PINCTRL_PULL4_BANK4_PIN16)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN16(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN16, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN15 */

#define BP_PINCTRL_PULL4_BANK4_PIN15      15
#define BM_PINCTRL_PULL4_BANK4_PIN15      0x00008000

#define BF_PINCTRL_PULL4_BANK4_PIN15(v)   (((v) << 15) & BM_PINCTRL_PULL4_BANK4_PIN15)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN15(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN15, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN14 */

#define BP_PINCTRL_PULL4_BANK4_PIN14      14
#define BM_PINCTRL_PULL4_BANK4_PIN14      0x00004000

#define BF_PINCTRL_PULL4_BANK4_PIN14(v)   (((v) << 14) & BM_PINCTRL_PULL4_BANK4_PIN14)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN14(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN14, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN13 */

#define BP_PINCTRL_PULL4_BANK4_PIN13      13
#define BM_PINCTRL_PULL4_BANK4_PIN13      0x00002000

#define BF_PINCTRL_PULL4_BANK4_PIN13(v)   (((v) << 13) & BM_PINCTRL_PULL4_BANK4_PIN13)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN13(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN13, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN12 */

#define BP_PINCTRL_PULL4_BANK4_PIN12      12
#define BM_PINCTRL_PULL4_BANK4_PIN12      0x00001000

#define BF_PINCTRL_PULL4_BANK4_PIN12(v)   (((v) << 12) & BM_PINCTRL_PULL4_BANK4_PIN12)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN12(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN12, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN11 */

#define BP_PINCTRL_PULL4_BANK4_PIN11      11
#define BM_PINCTRL_PULL4_BANK4_PIN11      0x00000800

#define BF_PINCTRL_PULL4_BANK4_PIN11(v)   (((v) << 11) & BM_PINCTRL_PULL4_BANK4_PIN11)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN11(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN11, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN10 */

#define BP_PINCTRL_PULL4_BANK4_PIN10      10
#define BM_PINCTRL_PULL4_BANK4_PIN10      0x00000400

#define BF_PINCTRL_PULL4_BANK4_PIN10(v)   (((v) << 10) & BM_PINCTRL_PULL4_BANK4_PIN10)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN10(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN10, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN09 */

#define BP_PINCTRL_PULL4_BANK4_PIN09      9
#define BM_PINCTRL_PULL4_BANK4_PIN09      0x00000200

#define BF_PINCTRL_PULL4_BANK4_PIN09(v)   (((v) << 9) & BM_PINCTRL_PULL4_BANK4_PIN09)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN09(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN09, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN08 */

#define BP_PINCTRL_PULL4_BANK4_PIN08      8
#define BM_PINCTRL_PULL4_BANK4_PIN08      0x00000100

#define BF_PINCTRL_PULL4_BANK4_PIN08(v)   (((v) << 8) & BM_PINCTRL_PULL4_BANK4_PIN08)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN08(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN08, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN07 */

#define BP_PINCTRL_PULL4_BANK4_PIN07      7
#define BM_PINCTRL_PULL4_BANK4_PIN07      0x00000080

#define BF_PINCTRL_PULL4_BANK4_PIN07(v)   (((v) << 7) & BM_PINCTRL_PULL4_BANK4_PIN07)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN07(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN07, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN06 */

#define BP_PINCTRL_PULL4_BANK4_PIN06      6
#define BM_PINCTRL_PULL4_BANK4_PIN06      0x00000040

#define BF_PINCTRL_PULL4_BANK4_PIN06(v)   (((v) << 6) & BM_PINCTRL_PULL4_BANK4_PIN06)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN06(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN06, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN05 */

#define BP_PINCTRL_PULL4_BANK4_PIN05      5
#define BM_PINCTRL_PULL4_BANK4_PIN05      0x00000020

#define BF_PINCTRL_PULL4_BANK4_PIN05(v)   (((v) << 5) & BM_PINCTRL_PULL4_BANK4_PIN05)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN05(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN05, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN04 */

#define BP_PINCTRL_PULL4_BANK4_PIN04      4
#define BM_PINCTRL_PULL4_BANK4_PIN04      0x00000010

#define BF_PINCTRL_PULL4_BANK4_PIN04(v)   (((v) << 4) & BM_PINCTRL_PULL4_BANK4_PIN04)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN04(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN04, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN03 */

#define BP_PINCTRL_PULL4_BANK4_PIN03      3
#define BM_PINCTRL_PULL4_BANK4_PIN03      0x00000008

#define BF_PINCTRL_PULL4_BANK4_PIN03(v)   (((v) << 3) & BM_PINCTRL_PULL4_BANK4_PIN03)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN03(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN03, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN02 */

#define BP_PINCTRL_PULL4_BANK4_PIN02      2
#define BM_PINCTRL_PULL4_BANK4_PIN02      0x00000004

#define BF_PINCTRL_PULL4_BANK4_PIN02(v)   (((v) << 2) & BM_PINCTRL_PULL4_BANK4_PIN02)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN02(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN02, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN01 */

#define BP_PINCTRL_PULL4_BANK4_PIN01      1
#define BM_PINCTRL_PULL4_BANK4_PIN01      0x00000002

#define BF_PINCTRL_PULL4_BANK4_PIN01(v)   (((v) << 1) & BM_PINCTRL_PULL4_BANK4_PIN01)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN01(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN01, v)
#endif

/* --- Register HW_PINCTRL_PULL4, field BANK4_PIN00 */

#define BP_PINCTRL_PULL4_BANK4_PIN00      0
#define BM_PINCTRL_PULL4_BANK4_PIN00      0x00000001

#define BF_PINCTRL_PULL4_BANK4_PIN00(v)   (((v) << 0) & BM_PINCTRL_PULL4_BANK4_PIN00)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL4_BANK4_PIN00(v)   BF_CS1(PINCTRL_PULL4, BANK4_PIN00, v)
#endif



/*
 * HW_PINCTRL_PULL5 - PINCTRL Bank 5 Pad Keeper Disable Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK5_PIN00  :  1;
        unsigned BANK5_PIN01  :  1;
        unsigned BANK5_PIN02  :  1;
        unsigned BANK5_PIN03  :  1;
        unsigned BANK5_PIN04  :  1;
        unsigned BANK5_PIN05  :  1;
        unsigned BANK5_PIN06  :  1;
        unsigned BANK5_PIN07  :  1;
        unsigned BANK5_PIN08  :  1;
        unsigned BANK5_PIN09  :  1;
        unsigned BANK5_PIN10  :  1;
        unsigned BANK5_PIN11  :  1;
        unsigned BANK5_PIN12  :  1;
        unsigned BANK5_PIN13  :  1;
        unsigned BANK5_PIN14  :  1;
        unsigned BANK5_PIN15  :  1;
        unsigned BANK5_PIN16  :  1;
        unsigned BANK5_PIN17  :  1;
        unsigned BANK5_PIN18  :  1;
        unsigned BANK5_PIN19  :  1;
        unsigned BANK5_PIN20  :  1;
        unsigned BANK5_PIN21  :  1;
        unsigned BANK5_PIN22  :  1;
        unsigned BANK5_PIN23  :  1;
        unsigned RSRVD0       :  2;
        unsigned BANK5_PIN26  :  1;
        unsigned RSRVD1       :  5;
    } B;
} hw_pinctrl_pull5_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_PULL5 register
 */
#define HW_PINCTRL_PULL5_ADDR         (REGS_PINCTRL_BASE + 0x650)
#define HW_PINCTRL_PULL5_SET_ADDR     (HW_PINCTRL_PULL5_ADDR + 4)
#define HW_PINCTRL_PULL5_CLR_ADDR     (HW_PINCTRL_PULL5_ADDR + 8)
#define HW_PINCTRL_PULL5_TOG_ADDR     (HW_PINCTRL_PULL5_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_PULL5           (*(volatile hw_pinctrl_pull5_t *) HW_PINCTRL_PULL5_ADDR)
#define HW_PINCTRL_PULL5_RD()      (HW_PINCTRL_PULL5.U)
#define HW_PINCTRL_PULL5_WR(v)     (HW_PINCTRL_PULL5.U = (v))
#define HW_PINCTRL_PULL5_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL5_SET_ADDR) = (v))
#define HW_PINCTRL_PULL5_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL5_CLR_ADDR) = (v))
#define HW_PINCTRL_PULL5_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL5_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_PULL5 bitfields
 */
/* --- Register HW_PINCTRL_PULL5, field RSRVD1 */

#define BP_PINCTRL_PULL5_RSRVD1      27
#define BM_PINCTRL_PULL5_RSRVD1      0xF8000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_PULL5_RSRVD1(v)   ((((reg32_t) v) << 27) & BM_PINCTRL_PULL5_RSRVD1)
#else
#define BF_PINCTRL_PULL5_RSRVD1(v)   (((v) << 27) & BM_PINCTRL_PULL5_RSRVD1)
#endif
/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN26 */

#define BP_PINCTRL_PULL5_BANK5_PIN26      26
#define BM_PINCTRL_PULL5_BANK5_PIN26      0x04000000

#define BF_PINCTRL_PULL5_BANK5_PIN26(v)   (((v) << 26) & BM_PINCTRL_PULL5_BANK5_PIN26)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN26(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN26, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field RSRVD0 */

#define BP_PINCTRL_PULL5_RSRVD0      24
#define BM_PINCTRL_PULL5_RSRVD0      0x03000000

#define BF_PINCTRL_PULL5_RSRVD0(v)   (((v) << 24) & BM_PINCTRL_PULL5_RSRVD0)
/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN23 */

#define BP_PINCTRL_PULL5_BANK5_PIN23      23
#define BM_PINCTRL_PULL5_BANK5_PIN23      0x00800000

#define BF_PINCTRL_PULL5_BANK5_PIN23(v)   (((v) << 23) & BM_PINCTRL_PULL5_BANK5_PIN23)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN23(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN23, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN22 */

#define BP_PINCTRL_PULL5_BANK5_PIN22      22
#define BM_PINCTRL_PULL5_BANK5_PIN22      0x00400000

#define BF_PINCTRL_PULL5_BANK5_PIN22(v)   (((v) << 22) & BM_PINCTRL_PULL5_BANK5_PIN22)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN22(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN22, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN21 */

#define BP_PINCTRL_PULL5_BANK5_PIN21      21
#define BM_PINCTRL_PULL5_BANK5_PIN21      0x00200000

#define BF_PINCTRL_PULL5_BANK5_PIN21(v)   (((v) << 21) & BM_PINCTRL_PULL5_BANK5_PIN21)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN21(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN21, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN20 */

#define BP_PINCTRL_PULL5_BANK5_PIN20      20
#define BM_PINCTRL_PULL5_BANK5_PIN20      0x00100000

#define BF_PINCTRL_PULL5_BANK5_PIN20(v)   (((v) << 20) & BM_PINCTRL_PULL5_BANK5_PIN20)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN20(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN20, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN19 */

#define BP_PINCTRL_PULL5_BANK5_PIN19      19
#define BM_PINCTRL_PULL5_BANK5_PIN19      0x00080000

#define BF_PINCTRL_PULL5_BANK5_PIN19(v)   (((v) << 19) & BM_PINCTRL_PULL5_BANK5_PIN19)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN19(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN19, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN18 */

#define BP_PINCTRL_PULL5_BANK5_PIN18      18
#define BM_PINCTRL_PULL5_BANK5_PIN18      0x00040000

#define BF_PINCTRL_PULL5_BANK5_PIN18(v)   (((v) << 18) & BM_PINCTRL_PULL5_BANK5_PIN18)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN18(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN18, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN17 */

#define BP_PINCTRL_PULL5_BANK5_PIN17      17
#define BM_PINCTRL_PULL5_BANK5_PIN17      0x00020000

#define BF_PINCTRL_PULL5_BANK5_PIN17(v)   (((v) << 17) & BM_PINCTRL_PULL5_BANK5_PIN17)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN17(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN17, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN16 */

#define BP_PINCTRL_PULL5_BANK5_PIN16      16
#define BM_PINCTRL_PULL5_BANK5_PIN16      0x00010000

#define BF_PINCTRL_PULL5_BANK5_PIN16(v)   (((v) << 16) & BM_PINCTRL_PULL5_BANK5_PIN16)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN16(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN16, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN15 */

#define BP_PINCTRL_PULL5_BANK5_PIN15      15
#define BM_PINCTRL_PULL5_BANK5_PIN15      0x00008000

#define BF_PINCTRL_PULL5_BANK5_PIN15(v)   (((v) << 15) & BM_PINCTRL_PULL5_BANK5_PIN15)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN15(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN15, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN14 */

#define BP_PINCTRL_PULL5_BANK5_PIN14      14
#define BM_PINCTRL_PULL5_BANK5_PIN14      0x00004000

#define BF_PINCTRL_PULL5_BANK5_PIN14(v)   (((v) << 14) & BM_PINCTRL_PULL5_BANK5_PIN14)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN14(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN14, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN13 */

#define BP_PINCTRL_PULL5_BANK5_PIN13      13
#define BM_PINCTRL_PULL5_BANK5_PIN13      0x00002000

#define BF_PINCTRL_PULL5_BANK5_PIN13(v)   (((v) << 13) & BM_PINCTRL_PULL5_BANK5_PIN13)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN13(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN13, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN12 */

#define BP_PINCTRL_PULL5_BANK5_PIN12      12
#define BM_PINCTRL_PULL5_BANK5_PIN12      0x00001000

#define BF_PINCTRL_PULL5_BANK5_PIN12(v)   (((v) << 12) & BM_PINCTRL_PULL5_BANK5_PIN12)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN12(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN12, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN11 */

#define BP_PINCTRL_PULL5_BANK5_PIN11      11
#define BM_PINCTRL_PULL5_BANK5_PIN11      0x00000800

#define BF_PINCTRL_PULL5_BANK5_PIN11(v)   (((v) << 11) & BM_PINCTRL_PULL5_BANK5_PIN11)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN11(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN11, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN10 */

#define BP_PINCTRL_PULL5_BANK5_PIN10      10
#define BM_PINCTRL_PULL5_BANK5_PIN10      0x00000400

#define BF_PINCTRL_PULL5_BANK5_PIN10(v)   (((v) << 10) & BM_PINCTRL_PULL5_BANK5_PIN10)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN10(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN10, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN09 */

#define BP_PINCTRL_PULL5_BANK5_PIN09      9
#define BM_PINCTRL_PULL5_BANK5_PIN09      0x00000200

#define BF_PINCTRL_PULL5_BANK5_PIN09(v)   (((v) << 9) & BM_PINCTRL_PULL5_BANK5_PIN09)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN09(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN09, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN08 */

#define BP_PINCTRL_PULL5_BANK5_PIN08      8
#define BM_PINCTRL_PULL5_BANK5_PIN08      0x00000100

#define BF_PINCTRL_PULL5_BANK5_PIN08(v)   (((v) << 8) & BM_PINCTRL_PULL5_BANK5_PIN08)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN08(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN08, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN07 */

#define BP_PINCTRL_PULL5_BANK5_PIN07      7
#define BM_PINCTRL_PULL5_BANK5_PIN07      0x00000080

#define BF_PINCTRL_PULL5_BANK5_PIN07(v)   (((v) << 7) & BM_PINCTRL_PULL5_BANK5_PIN07)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN07(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN07, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN06 */

#define BP_PINCTRL_PULL5_BANK5_PIN06      6
#define BM_PINCTRL_PULL5_BANK5_PIN06      0x00000040

#define BF_PINCTRL_PULL5_BANK5_PIN06(v)   (((v) << 6) & BM_PINCTRL_PULL5_BANK5_PIN06)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN06(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN06, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN05 */

#define BP_PINCTRL_PULL5_BANK5_PIN05      5
#define BM_PINCTRL_PULL5_BANK5_PIN05      0x00000020

#define BF_PINCTRL_PULL5_BANK5_PIN05(v)   (((v) << 5) & BM_PINCTRL_PULL5_BANK5_PIN05)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN05(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN05, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN04 */

#define BP_PINCTRL_PULL5_BANK5_PIN04      4
#define BM_PINCTRL_PULL5_BANK5_PIN04      0x00000010

#define BF_PINCTRL_PULL5_BANK5_PIN04(v)   (((v) << 4) & BM_PINCTRL_PULL5_BANK5_PIN04)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN04(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN04, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN03 */

#define BP_PINCTRL_PULL5_BANK5_PIN03      3
#define BM_PINCTRL_PULL5_BANK5_PIN03      0x00000008

#define BF_PINCTRL_PULL5_BANK5_PIN03(v)   (((v) << 3) & BM_PINCTRL_PULL5_BANK5_PIN03)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN03(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN03, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN02 */

#define BP_PINCTRL_PULL5_BANK5_PIN02      2
#define BM_PINCTRL_PULL5_BANK5_PIN02      0x00000004

#define BF_PINCTRL_PULL5_BANK5_PIN02(v)   (((v) << 2) & BM_PINCTRL_PULL5_BANK5_PIN02)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN02(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN02, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN01 */

#define BP_PINCTRL_PULL5_BANK5_PIN01      1
#define BM_PINCTRL_PULL5_BANK5_PIN01      0x00000002

#define BF_PINCTRL_PULL5_BANK5_PIN01(v)   (((v) << 1) & BM_PINCTRL_PULL5_BANK5_PIN01)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN01(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN01, v)
#endif

/* --- Register HW_PINCTRL_PULL5, field BANK5_PIN00 */

#define BP_PINCTRL_PULL5_BANK5_PIN00      0
#define BM_PINCTRL_PULL5_BANK5_PIN00      0x00000001

#define BF_PINCTRL_PULL5_BANK5_PIN00(v)   (((v) << 0) & BM_PINCTRL_PULL5_BANK5_PIN00)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL5_BANK5_PIN00(v)   BF_CS1(PINCTRL_PULL5, BANK5_PIN00, v)
#endif



/*
 * HW_PINCTRL_PULL6 - PINCTRL Bank 6 Pad Keeper Disable Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK6_PIN00  :  1;
        unsigned BANK6_PIN01  :  1;
        unsigned BANK6_PIN02  :  1;
        unsigned BANK6_PIN03  :  1;
        unsigned BANK6_PIN04  :  1;
        unsigned BANK6_PIN05  :  1;
        unsigned BANK6_PIN06  :  1;
        unsigned BANK6_PIN07  :  1;
        unsigned BANK6_PIN08  :  1;
        unsigned BANK6_PIN09  :  1;
        unsigned BANK6_PIN10  :  1;
        unsigned BANK6_PIN11  :  1;
        unsigned BANK6_PIN12  :  1;
        unsigned BANK6_PIN13  :  1;
        unsigned BANK6_PIN14  :  1;
        unsigned RSRVD0       :  1;
        unsigned BANK6_PIN16  :  1;
        unsigned BANK6_PIN17  :  1;
        unsigned BANK6_PIN18  :  1;
        unsigned BANK6_PIN19  :  1;
        unsigned BANK6_PIN20  :  1;
        unsigned BANK6_PIN21  :  1;
        unsigned BANK6_PIN22  :  1;
        unsigned BANK6_PIN23  :  1;
        unsigned BANK6_PIN24  :  1;
        unsigned RSRVD1       :  7;
    } B;
} hw_pinctrl_pull6_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_PULL6 register
 */
#define HW_PINCTRL_PULL6_ADDR         (REGS_PINCTRL_BASE + 0x660)
#define HW_PINCTRL_PULL6_SET_ADDR     (HW_PINCTRL_PULL6_ADDR + 4)
#define HW_PINCTRL_PULL6_CLR_ADDR     (HW_PINCTRL_PULL6_ADDR + 8)
#define HW_PINCTRL_PULL6_TOG_ADDR     (HW_PINCTRL_PULL6_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_PULL6           (*(volatile hw_pinctrl_pull6_t *) HW_PINCTRL_PULL6_ADDR)
#define HW_PINCTRL_PULL6_RD()      (HW_PINCTRL_PULL6.U)
#define HW_PINCTRL_PULL6_WR(v)     (HW_PINCTRL_PULL6.U = (v))
#define HW_PINCTRL_PULL6_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL6_SET_ADDR) = (v))
#define HW_PINCTRL_PULL6_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL6_CLR_ADDR) = (v))
#define HW_PINCTRL_PULL6_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_PULL6_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_PULL6 bitfields
 */
/* --- Register HW_PINCTRL_PULL6, field RSRVD1 */

#define BP_PINCTRL_PULL6_RSRVD1      25
#define BM_PINCTRL_PULL6_RSRVD1      0xFE000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_PULL6_RSRVD1(v)   ((((reg32_t) v) << 25) & BM_PINCTRL_PULL6_RSRVD1)
#else
#define BF_PINCTRL_PULL6_RSRVD1(v)   (((v) << 25) & BM_PINCTRL_PULL6_RSRVD1)
#endif
/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN24 */

#define BP_PINCTRL_PULL6_BANK6_PIN24      24
#define BM_PINCTRL_PULL6_BANK6_PIN24      0x01000000

#define BF_PINCTRL_PULL6_BANK6_PIN24(v)   (((v) << 24) & BM_PINCTRL_PULL6_BANK6_PIN24)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN24(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN24, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN23 */

#define BP_PINCTRL_PULL6_BANK6_PIN23      23
#define BM_PINCTRL_PULL6_BANK6_PIN23      0x00800000

#define BF_PINCTRL_PULL6_BANK6_PIN23(v)   (((v) << 23) & BM_PINCTRL_PULL6_BANK6_PIN23)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN23(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN23, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN22 */

#define BP_PINCTRL_PULL6_BANK6_PIN22      22
#define BM_PINCTRL_PULL6_BANK6_PIN22      0x00400000

#define BF_PINCTRL_PULL6_BANK6_PIN22(v)   (((v) << 22) & BM_PINCTRL_PULL6_BANK6_PIN22)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN22(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN22, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN21 */

#define BP_PINCTRL_PULL6_BANK6_PIN21      21
#define BM_PINCTRL_PULL6_BANK6_PIN21      0x00200000

#define BF_PINCTRL_PULL6_BANK6_PIN21(v)   (((v) << 21) & BM_PINCTRL_PULL6_BANK6_PIN21)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN21(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN21, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN20 */

#define BP_PINCTRL_PULL6_BANK6_PIN20      20
#define BM_PINCTRL_PULL6_BANK6_PIN20      0x00100000

#define BF_PINCTRL_PULL6_BANK6_PIN20(v)   (((v) << 20) & BM_PINCTRL_PULL6_BANK6_PIN20)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN20(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN20, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN19 */

#define BP_PINCTRL_PULL6_BANK6_PIN19      19
#define BM_PINCTRL_PULL6_BANK6_PIN19      0x00080000

#define BF_PINCTRL_PULL6_BANK6_PIN19(v)   (((v) << 19) & BM_PINCTRL_PULL6_BANK6_PIN19)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN19(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN19, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN18 */

#define BP_PINCTRL_PULL6_BANK6_PIN18      18
#define BM_PINCTRL_PULL6_BANK6_PIN18      0x00040000

#define BF_PINCTRL_PULL6_BANK6_PIN18(v)   (((v) << 18) & BM_PINCTRL_PULL6_BANK6_PIN18)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN18(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN18, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN17 */

#define BP_PINCTRL_PULL6_BANK6_PIN17      17
#define BM_PINCTRL_PULL6_BANK6_PIN17      0x00020000

#define BF_PINCTRL_PULL6_BANK6_PIN17(v)   (((v) << 17) & BM_PINCTRL_PULL6_BANK6_PIN17)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN17(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN17, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN16 */

#define BP_PINCTRL_PULL6_BANK6_PIN16      16
#define BM_PINCTRL_PULL6_BANK6_PIN16      0x00010000

#define BF_PINCTRL_PULL6_BANK6_PIN16(v)   (((v) << 16) & BM_PINCTRL_PULL6_BANK6_PIN16)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN16(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN16, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field RSRVD0 */

#define BP_PINCTRL_PULL6_RSRVD0      15
#define BM_PINCTRL_PULL6_RSRVD0      0x00008000

#define BF_PINCTRL_PULL6_RSRVD0(v)   (((v) << 15) & BM_PINCTRL_PULL6_RSRVD0)
/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN14 */

#define BP_PINCTRL_PULL6_BANK6_PIN14      14
#define BM_PINCTRL_PULL6_BANK6_PIN14      0x00004000

#define BF_PINCTRL_PULL6_BANK6_PIN14(v)   (((v) << 14) & BM_PINCTRL_PULL6_BANK6_PIN14)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN14(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN14, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN13 */

#define BP_PINCTRL_PULL6_BANK6_PIN13      13
#define BM_PINCTRL_PULL6_BANK6_PIN13      0x00002000

#define BF_PINCTRL_PULL6_BANK6_PIN13(v)   (((v) << 13) & BM_PINCTRL_PULL6_BANK6_PIN13)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN13(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN13, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN12 */

#define BP_PINCTRL_PULL6_BANK6_PIN12      12
#define BM_PINCTRL_PULL6_BANK6_PIN12      0x00001000

#define BF_PINCTRL_PULL6_BANK6_PIN12(v)   (((v) << 12) & BM_PINCTRL_PULL6_BANK6_PIN12)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN12(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN12, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN11 */

#define BP_PINCTRL_PULL6_BANK6_PIN11      11
#define BM_PINCTRL_PULL6_BANK6_PIN11      0x00000800

#define BF_PINCTRL_PULL6_BANK6_PIN11(v)   (((v) << 11) & BM_PINCTRL_PULL6_BANK6_PIN11)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN11(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN11, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN10 */

#define BP_PINCTRL_PULL6_BANK6_PIN10      10
#define BM_PINCTRL_PULL6_BANK6_PIN10      0x00000400

#define BF_PINCTRL_PULL6_BANK6_PIN10(v)   (((v) << 10) & BM_PINCTRL_PULL6_BANK6_PIN10)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN10(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN10, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN09 */

#define BP_PINCTRL_PULL6_BANK6_PIN09      9
#define BM_PINCTRL_PULL6_BANK6_PIN09      0x00000200

#define BF_PINCTRL_PULL6_BANK6_PIN09(v)   (((v) << 9) & BM_PINCTRL_PULL6_BANK6_PIN09)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN09(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN09, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN08 */

#define BP_PINCTRL_PULL6_BANK6_PIN08      8
#define BM_PINCTRL_PULL6_BANK6_PIN08      0x00000100

#define BF_PINCTRL_PULL6_BANK6_PIN08(v)   (((v) << 8) & BM_PINCTRL_PULL6_BANK6_PIN08)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN08(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN08, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN07 */

#define BP_PINCTRL_PULL6_BANK6_PIN07      7
#define BM_PINCTRL_PULL6_BANK6_PIN07      0x00000080

#define BF_PINCTRL_PULL6_BANK6_PIN07(v)   (((v) << 7) & BM_PINCTRL_PULL6_BANK6_PIN07)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN07(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN07, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN06 */

#define BP_PINCTRL_PULL6_BANK6_PIN06      6
#define BM_PINCTRL_PULL6_BANK6_PIN06      0x00000040

#define BF_PINCTRL_PULL6_BANK6_PIN06(v)   (((v) << 6) & BM_PINCTRL_PULL6_BANK6_PIN06)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN06(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN06, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN05 */

#define BP_PINCTRL_PULL6_BANK6_PIN05      5
#define BM_PINCTRL_PULL6_BANK6_PIN05      0x00000020

#define BF_PINCTRL_PULL6_BANK6_PIN05(v)   (((v) << 5) & BM_PINCTRL_PULL6_BANK6_PIN05)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN05(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN05, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN04 */

#define BP_PINCTRL_PULL6_BANK6_PIN04      4
#define BM_PINCTRL_PULL6_BANK6_PIN04      0x00000010

#define BF_PINCTRL_PULL6_BANK6_PIN04(v)   (((v) << 4) & BM_PINCTRL_PULL6_BANK6_PIN04)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN04(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN04, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN03 */

#define BP_PINCTRL_PULL6_BANK6_PIN03      3
#define BM_PINCTRL_PULL6_BANK6_PIN03      0x00000008

#define BF_PINCTRL_PULL6_BANK6_PIN03(v)   (((v) << 3) & BM_PINCTRL_PULL6_BANK6_PIN03)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN03(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN03, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN02 */

#define BP_PINCTRL_PULL6_BANK6_PIN02      2
#define BM_PINCTRL_PULL6_BANK6_PIN02      0x00000004

#define BF_PINCTRL_PULL6_BANK6_PIN02(v)   (((v) << 2) & BM_PINCTRL_PULL6_BANK6_PIN02)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN02(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN02, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN01 */

#define BP_PINCTRL_PULL6_BANK6_PIN01      1
#define BM_PINCTRL_PULL6_BANK6_PIN01      0x00000002

#define BF_PINCTRL_PULL6_BANK6_PIN01(v)   (((v) << 1) & BM_PINCTRL_PULL6_BANK6_PIN01)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN01(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN01, v)
#endif

/* --- Register HW_PINCTRL_PULL6, field BANK6_PIN00 */

#define BP_PINCTRL_PULL6_BANK6_PIN00      0
#define BM_PINCTRL_PULL6_BANK6_PIN00      0x00000001

#define BF_PINCTRL_PULL6_BANK6_PIN00(v)   (((v) << 0) & BM_PINCTRL_PULL6_BANK6_PIN00)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PULL6_BANK6_PIN00(v)   BF_CS1(PINCTRL_PULL6, BANK6_PIN00, v)
#endif



/*
 * HW_PINCTRL_DOUT0 - PINCTRL Bank 0 Data Output Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DOUT    : 29;
        unsigned RSRVD1  :  3;
    } B;
} hw_pinctrl_dout0_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DOUT0 register
 */
#define HW_PINCTRL_DOUT0_ADDR         (REGS_PINCTRL_BASE + 0x700)
#define HW_PINCTRL_DOUT0_SET_ADDR     (HW_PINCTRL_DOUT0_ADDR + 4)
#define HW_PINCTRL_DOUT0_CLR_ADDR     (HW_PINCTRL_DOUT0_ADDR + 8)
#define HW_PINCTRL_DOUT0_TOG_ADDR     (HW_PINCTRL_DOUT0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DOUT0           (*(volatile hw_pinctrl_dout0_t *) HW_PINCTRL_DOUT0_ADDR)
#define HW_PINCTRL_DOUT0_RD()      (HW_PINCTRL_DOUT0.U)
#define HW_PINCTRL_DOUT0_WR(v)     (HW_PINCTRL_DOUT0.U = (v))
#define HW_PINCTRL_DOUT0_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT0_SET_ADDR) = (v))
#define HW_PINCTRL_DOUT0_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT0_CLR_ADDR) = (v))
#define HW_PINCTRL_DOUT0_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DOUT0 bitfields
 */
/* --- Register HW_PINCTRL_DOUT0, field RSRVD1 */

#define BP_PINCTRL_DOUT0_RSRVD1      29
#define BM_PINCTRL_DOUT0_RSRVD1      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DOUT0_RSRVD1(v)   ((((reg32_t) v) << 29) & BM_PINCTRL_DOUT0_RSRVD1)
#else
#define BF_PINCTRL_DOUT0_RSRVD1(v)   (((v) << 29) & BM_PINCTRL_DOUT0_RSRVD1)
#endif
/* --- Register HW_PINCTRL_DOUT0, field DOUT */

#define BP_PINCTRL_DOUT0_DOUT      0
#define BM_PINCTRL_DOUT0_DOUT      0x1FFFFFFF

#define BF_PINCTRL_DOUT0_DOUT(v)   (((v) << 0) & BM_PINCTRL_DOUT0_DOUT)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DOUT0_DOUT(v)   BF_CS1(PINCTRL_DOUT0, DOUT, v)
#endif



/*
 * HW_PINCTRL_DOUT1 - PINCTRL Bank 1 Data Output Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DOUT  : 32;
    } B;
} hw_pinctrl_dout1_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DOUT1 register
 */
#define HW_PINCTRL_DOUT1_ADDR         (REGS_PINCTRL_BASE + 0x710)
#define HW_PINCTRL_DOUT1_SET_ADDR     (HW_PINCTRL_DOUT1_ADDR + 4)
#define HW_PINCTRL_DOUT1_CLR_ADDR     (HW_PINCTRL_DOUT1_ADDR + 8)
#define HW_PINCTRL_DOUT1_TOG_ADDR     (HW_PINCTRL_DOUT1_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DOUT1           (*(volatile hw_pinctrl_dout1_t *) HW_PINCTRL_DOUT1_ADDR)
#define HW_PINCTRL_DOUT1_RD()      (HW_PINCTRL_DOUT1.U)
#define HW_PINCTRL_DOUT1_WR(v)     (HW_PINCTRL_DOUT1.U = (v))
#define HW_PINCTRL_DOUT1_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT1_SET_ADDR) = (v))
#define HW_PINCTRL_DOUT1_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT1_CLR_ADDR) = (v))
#define HW_PINCTRL_DOUT1_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT1_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DOUT1 bitfields
 */
/* --- Register HW_PINCTRL_DOUT1, field DOUT */

#define BP_PINCTRL_DOUT1_DOUT      0
#define BM_PINCTRL_DOUT1_DOUT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DOUT1_DOUT(v)   ((reg32_t) v)
#else
#define BF_PINCTRL_DOUT1_DOUT(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DOUT1_DOUT(v)   (HW_PINCTRL_DOUT1.B.DOUT = (v))
#endif



/*
 * HW_PINCTRL_DOUT2 - PINCTRL Bank 2 Data Output Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DOUT    : 28;
        unsigned RSRVD1  :  4;
    } B;
} hw_pinctrl_dout2_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DOUT2 register
 */
#define HW_PINCTRL_DOUT2_ADDR         (REGS_PINCTRL_BASE + 0x720)
#define HW_PINCTRL_DOUT2_SET_ADDR     (HW_PINCTRL_DOUT2_ADDR + 4)
#define HW_PINCTRL_DOUT2_CLR_ADDR     (HW_PINCTRL_DOUT2_ADDR + 8)
#define HW_PINCTRL_DOUT2_TOG_ADDR     (HW_PINCTRL_DOUT2_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DOUT2           (*(volatile hw_pinctrl_dout2_t *) HW_PINCTRL_DOUT2_ADDR)
#define HW_PINCTRL_DOUT2_RD()      (HW_PINCTRL_DOUT2.U)
#define HW_PINCTRL_DOUT2_WR(v)     (HW_PINCTRL_DOUT2.U = (v))
#define HW_PINCTRL_DOUT2_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT2_SET_ADDR) = (v))
#define HW_PINCTRL_DOUT2_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT2_CLR_ADDR) = (v))
#define HW_PINCTRL_DOUT2_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT2_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DOUT2 bitfields
 */
/* --- Register HW_PINCTRL_DOUT2, field RSRVD1 */

#define BP_PINCTRL_DOUT2_RSRVD1      28
#define BM_PINCTRL_DOUT2_RSRVD1      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DOUT2_RSRVD1(v)   ((((reg32_t) v) << 28) & BM_PINCTRL_DOUT2_RSRVD1)
#else
#define BF_PINCTRL_DOUT2_RSRVD1(v)   (((v) << 28) & BM_PINCTRL_DOUT2_RSRVD1)
#endif
/* --- Register HW_PINCTRL_DOUT2, field DOUT */

#define BP_PINCTRL_DOUT2_DOUT      0
#define BM_PINCTRL_DOUT2_DOUT      0x0FFFFFFF

#define BF_PINCTRL_DOUT2_DOUT(v)   (((v) << 0) & BM_PINCTRL_DOUT2_DOUT)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DOUT2_DOUT(v)   BF_CS1(PINCTRL_DOUT2, DOUT, v)
#endif



/*
 * HW_PINCTRL_DOUT3 - PINCTRL Bank 3 Data Output Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DOUT    : 31;
        unsigned RSRVD1  :  1;
    } B;
} hw_pinctrl_dout3_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DOUT3 register
 */
#define HW_PINCTRL_DOUT3_ADDR         (REGS_PINCTRL_BASE + 0x730)
#define HW_PINCTRL_DOUT3_SET_ADDR     (HW_PINCTRL_DOUT3_ADDR + 4)
#define HW_PINCTRL_DOUT3_CLR_ADDR     (HW_PINCTRL_DOUT3_ADDR + 8)
#define HW_PINCTRL_DOUT3_TOG_ADDR     (HW_PINCTRL_DOUT3_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DOUT3           (*(volatile hw_pinctrl_dout3_t *) HW_PINCTRL_DOUT3_ADDR)
#define HW_PINCTRL_DOUT3_RD()      (HW_PINCTRL_DOUT3.U)
#define HW_PINCTRL_DOUT3_WR(v)     (HW_PINCTRL_DOUT3.U = (v))
#define HW_PINCTRL_DOUT3_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT3_SET_ADDR) = (v))
#define HW_PINCTRL_DOUT3_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT3_CLR_ADDR) = (v))
#define HW_PINCTRL_DOUT3_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT3_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DOUT3 bitfields
 */
/* --- Register HW_PINCTRL_DOUT3, field RSRVD1 */

#define BP_PINCTRL_DOUT3_RSRVD1      31
#define BM_PINCTRL_DOUT3_RSRVD1      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DOUT3_RSRVD1(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DOUT3_RSRVD1)
#else
#define BF_PINCTRL_DOUT3_RSRVD1(v)   (((v) << 31) & BM_PINCTRL_DOUT3_RSRVD1)
#endif
/* --- Register HW_PINCTRL_DOUT3, field DOUT */

#define BP_PINCTRL_DOUT3_DOUT      0
#define BM_PINCTRL_DOUT3_DOUT      0x7FFFFFFF

#define BF_PINCTRL_DOUT3_DOUT(v)   (((v) << 0) & BM_PINCTRL_DOUT3_DOUT)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DOUT3_DOUT(v)   BF_CS1(PINCTRL_DOUT3, DOUT, v)
#endif



/*
 * HW_PINCTRL_DOUT4 - PINCTRL Bank 4 Data Output Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DOUT    : 21;
        unsigned RSRVD1  : 11;
    } B;
} hw_pinctrl_dout4_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DOUT4 register
 */
#define HW_PINCTRL_DOUT4_ADDR         (REGS_PINCTRL_BASE + 0x740)
#define HW_PINCTRL_DOUT4_SET_ADDR     (HW_PINCTRL_DOUT4_ADDR + 4)
#define HW_PINCTRL_DOUT4_CLR_ADDR     (HW_PINCTRL_DOUT4_ADDR + 8)
#define HW_PINCTRL_DOUT4_TOG_ADDR     (HW_PINCTRL_DOUT4_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DOUT4           (*(volatile hw_pinctrl_dout4_t *) HW_PINCTRL_DOUT4_ADDR)
#define HW_PINCTRL_DOUT4_RD()      (HW_PINCTRL_DOUT4.U)
#define HW_PINCTRL_DOUT4_WR(v)     (HW_PINCTRL_DOUT4.U = (v))
#define HW_PINCTRL_DOUT4_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT4_SET_ADDR) = (v))
#define HW_PINCTRL_DOUT4_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT4_CLR_ADDR) = (v))
#define HW_PINCTRL_DOUT4_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOUT4_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DOUT4 bitfields
 */
/* --- Register HW_PINCTRL_DOUT4, field RSRVD1 */

#define BP_PINCTRL_DOUT4_RSRVD1      21
#define BM_PINCTRL_DOUT4_RSRVD1      0xFFE00000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DOUT4_RSRVD1(v)   ((((reg32_t) v) << 21) & BM_PINCTRL_DOUT4_RSRVD1)
#else
#define BF_PINCTRL_DOUT4_RSRVD1(v)   (((v) << 21) & BM_PINCTRL_DOUT4_RSRVD1)
#endif
/* --- Register HW_PINCTRL_DOUT4, field DOUT */

#define BP_PINCTRL_DOUT4_DOUT      0
#define BM_PINCTRL_DOUT4_DOUT      0x001FFFFF

#define BF_PINCTRL_DOUT4_DOUT(v)   (((v) << 0) & BM_PINCTRL_DOUT4_DOUT)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DOUT4_DOUT(v)   BF_CS1(PINCTRL_DOUT4, DOUT, v)
#endif



/*
 * HW_PINCTRL_DIN0 - PINCTRL Bank 0 Data Input Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIN     : 29;
        unsigned RSRVD1  :  3;
    } B;
} hw_pinctrl_din0_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DIN0 register
 */
#define HW_PINCTRL_DIN0_ADDR         (REGS_PINCTRL_BASE + 0x900)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DIN0           (*(volatile hw_pinctrl_din0_t *) HW_PINCTRL_DIN0_ADDR)
#define HW_PINCTRL_DIN0_RD()      (HW_PINCTRL_DIN0.U)
#endif


/*
 * constants & macros for individual HW_PINCTRL_DIN0 bitfields
 */
/* --- Register HW_PINCTRL_DIN0, field RSRVD1 */

#define BP_PINCTRL_DIN0_RSRVD1      29
#define BM_PINCTRL_DIN0_RSRVD1      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DIN0_RSRVD1(v)   ((((reg32_t) v) << 29) & BM_PINCTRL_DIN0_RSRVD1)
#else
#define BF_PINCTRL_DIN0_RSRVD1(v)   (((v) << 29) & BM_PINCTRL_DIN0_RSRVD1)
#endif
/* --- Register HW_PINCTRL_DIN0, field DIN */

#define BP_PINCTRL_DIN0_DIN      0
#define BM_PINCTRL_DIN0_DIN      0x1FFFFFFF

#define BF_PINCTRL_DIN0_DIN(v)   (((v) << 0) & BM_PINCTRL_DIN0_DIN)


/*
 * HW_PINCTRL_DIN1 - PINCTRL Bank 1 Data Input Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIN  : 32;
    } B;
} hw_pinctrl_din1_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DIN1 register
 */
#define HW_PINCTRL_DIN1_ADDR         (REGS_PINCTRL_BASE + 0x910)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DIN1           (*(volatile hw_pinctrl_din1_t *) HW_PINCTRL_DIN1_ADDR)
#define HW_PINCTRL_DIN1_RD()      (HW_PINCTRL_DIN1.U)
#endif


/*
 * constants & macros for individual HW_PINCTRL_DIN1 bitfields
 */
/* --- Register HW_PINCTRL_DIN1, field DIN */

#define BP_PINCTRL_DIN1_DIN      0
#define BM_PINCTRL_DIN1_DIN      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DIN1_DIN(v)   ((reg32_t) v)
#else
#define BF_PINCTRL_DIN1_DIN(v)   (v)
#endif


/*
 * HW_PINCTRL_DIN2 - PINCTRL Bank 2 Data Input Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIN     : 28;
        unsigned RSRVD1  :  4;
    } B;
} hw_pinctrl_din2_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DIN2 register
 */
#define HW_PINCTRL_DIN2_ADDR         (REGS_PINCTRL_BASE + 0x920)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DIN2           (*(volatile hw_pinctrl_din2_t *) HW_PINCTRL_DIN2_ADDR)
#define HW_PINCTRL_DIN2_RD()      (HW_PINCTRL_DIN2.U)
#endif


/*
 * constants & macros for individual HW_PINCTRL_DIN2 bitfields
 */
/* --- Register HW_PINCTRL_DIN2, field RSRVD1 */

#define BP_PINCTRL_DIN2_RSRVD1      28
#define BM_PINCTRL_DIN2_RSRVD1      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DIN2_RSRVD1(v)   ((((reg32_t) v) << 28) & BM_PINCTRL_DIN2_RSRVD1)
#else
#define BF_PINCTRL_DIN2_RSRVD1(v)   (((v) << 28) & BM_PINCTRL_DIN2_RSRVD1)
#endif
/* --- Register HW_PINCTRL_DIN2, field DIN */

#define BP_PINCTRL_DIN2_DIN      0
#define BM_PINCTRL_DIN2_DIN      0x0FFFFFFF

#define BF_PINCTRL_DIN2_DIN(v)   (((v) << 0) & BM_PINCTRL_DIN2_DIN)


/*
 * HW_PINCTRL_DIN3 - PINCTRL Bank 3 Data Input Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIN     : 31;
        unsigned RSRVD1  :  1;
    } B;
} hw_pinctrl_din3_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DIN3 register
 */
#define HW_PINCTRL_DIN3_ADDR         (REGS_PINCTRL_BASE + 0x930)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DIN3           (*(volatile hw_pinctrl_din3_t *) HW_PINCTRL_DIN3_ADDR)
#define HW_PINCTRL_DIN3_RD()      (HW_PINCTRL_DIN3.U)
#endif


/*
 * constants & macros for individual HW_PINCTRL_DIN3 bitfields
 */
/* --- Register HW_PINCTRL_DIN3, field RSRVD1 */

#define BP_PINCTRL_DIN3_RSRVD1      31
#define BM_PINCTRL_DIN3_RSRVD1      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DIN3_RSRVD1(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DIN3_RSRVD1)
#else
#define BF_PINCTRL_DIN3_RSRVD1(v)   (((v) << 31) & BM_PINCTRL_DIN3_RSRVD1)
#endif
/* --- Register HW_PINCTRL_DIN3, field DIN */

#define BP_PINCTRL_DIN3_DIN      0
#define BM_PINCTRL_DIN3_DIN      0x7FFFFFFF

#define BF_PINCTRL_DIN3_DIN(v)   (((v) << 0) & BM_PINCTRL_DIN3_DIN)


/*
 * HW_PINCTRL_DIN4 - PINCTRL Bank 4 Data Input Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIN     : 21;
        unsigned RSRVD1  : 11;
    } B;
} hw_pinctrl_din4_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DIN4 register
 */
#define HW_PINCTRL_DIN4_ADDR         (REGS_PINCTRL_BASE + 0x940)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DIN4           (*(volatile hw_pinctrl_din4_t *) HW_PINCTRL_DIN4_ADDR)
#define HW_PINCTRL_DIN4_RD()      (HW_PINCTRL_DIN4.U)
#endif


/*
 * constants & macros for individual HW_PINCTRL_DIN4 bitfields
 */
/* --- Register HW_PINCTRL_DIN4, field RSRVD1 */

#define BP_PINCTRL_DIN4_RSRVD1      21
#define BM_PINCTRL_DIN4_RSRVD1      0xFFE00000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DIN4_RSRVD1(v)   ((((reg32_t) v) << 21) & BM_PINCTRL_DIN4_RSRVD1)
#else
#define BF_PINCTRL_DIN4_RSRVD1(v)   (((v) << 21) & BM_PINCTRL_DIN4_RSRVD1)
#endif
/* --- Register HW_PINCTRL_DIN4, field DIN */

#define BP_PINCTRL_DIN4_DIN      0
#define BM_PINCTRL_DIN4_DIN      0x001FFFFF

#define BF_PINCTRL_DIN4_DIN(v)   (((v) << 0) & BM_PINCTRL_DIN4_DIN)


/*
 * HW_PINCTRL_DOE0 - PINCTRL Bank 0 Data Output Enable Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DOE     : 29;
        unsigned RSRVD1  :  3;
    } B;
} hw_pinctrl_doe0_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DOE0 register
 */
#define HW_PINCTRL_DOE0_ADDR         (REGS_PINCTRL_BASE + 0xb00)
#define HW_PINCTRL_DOE0_SET_ADDR     (HW_PINCTRL_DOE0_ADDR + 4)
#define HW_PINCTRL_DOE0_CLR_ADDR     (HW_PINCTRL_DOE0_ADDR + 8)
#define HW_PINCTRL_DOE0_TOG_ADDR     (HW_PINCTRL_DOE0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DOE0           (*(volatile hw_pinctrl_doe0_t *) HW_PINCTRL_DOE0_ADDR)
#define HW_PINCTRL_DOE0_RD()      (HW_PINCTRL_DOE0.U)
#define HW_PINCTRL_DOE0_WR(v)     (HW_PINCTRL_DOE0.U = (v))
#define HW_PINCTRL_DOE0_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE0_SET_ADDR) = (v))
#define HW_PINCTRL_DOE0_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE0_CLR_ADDR) = (v))
#define HW_PINCTRL_DOE0_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DOE0 bitfields
 */
/* --- Register HW_PINCTRL_DOE0, field RSRVD1 */

#define BP_PINCTRL_DOE0_RSRVD1      29
#define BM_PINCTRL_DOE0_RSRVD1      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DOE0_RSRVD1(v)   ((((reg32_t) v) << 29) & BM_PINCTRL_DOE0_RSRVD1)
#else
#define BF_PINCTRL_DOE0_RSRVD1(v)   (((v) << 29) & BM_PINCTRL_DOE0_RSRVD1)
#endif
/* --- Register HW_PINCTRL_DOE0, field DOE */

#define BP_PINCTRL_DOE0_DOE      0
#define BM_PINCTRL_DOE0_DOE      0x1FFFFFFF

#define BF_PINCTRL_DOE0_DOE(v)   (((v) << 0) & BM_PINCTRL_DOE0_DOE)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DOE0_DOE(v)   BF_CS1(PINCTRL_DOE0, DOE, v)
#endif



/*
 * HW_PINCTRL_DOE1 - PINCTRL Bank 1 Data Output Enable Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DOE  : 32;
    } B;
} hw_pinctrl_doe1_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DOE1 register
 */
#define HW_PINCTRL_DOE1_ADDR         (REGS_PINCTRL_BASE + 0xb10)
#define HW_PINCTRL_DOE1_SET_ADDR     (HW_PINCTRL_DOE1_ADDR + 4)
#define HW_PINCTRL_DOE1_CLR_ADDR     (HW_PINCTRL_DOE1_ADDR + 8)
#define HW_PINCTRL_DOE1_TOG_ADDR     (HW_PINCTRL_DOE1_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DOE1           (*(volatile hw_pinctrl_doe1_t *) HW_PINCTRL_DOE1_ADDR)
#define HW_PINCTRL_DOE1_RD()      (HW_PINCTRL_DOE1.U)
#define HW_PINCTRL_DOE1_WR(v)     (HW_PINCTRL_DOE1.U = (v))
#define HW_PINCTRL_DOE1_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE1_SET_ADDR) = (v))
#define HW_PINCTRL_DOE1_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE1_CLR_ADDR) = (v))
#define HW_PINCTRL_DOE1_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE1_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DOE1 bitfields
 */
/* --- Register HW_PINCTRL_DOE1, field DOE */

#define BP_PINCTRL_DOE1_DOE      0
#define BM_PINCTRL_DOE1_DOE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DOE1_DOE(v)   ((reg32_t) v)
#else
#define BF_PINCTRL_DOE1_DOE(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DOE1_DOE(v)   (HW_PINCTRL_DOE1.B.DOE = (v))
#endif



/*
 * HW_PINCTRL_DOE2 - PINCTRL Bank 2 Data Output Enable Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DOE     : 28;
        unsigned RSRVD1  :  4;
    } B;
} hw_pinctrl_doe2_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DOE2 register
 */
#define HW_PINCTRL_DOE2_ADDR         (REGS_PINCTRL_BASE + 0xb20)
#define HW_PINCTRL_DOE2_SET_ADDR     (HW_PINCTRL_DOE2_ADDR + 4)
#define HW_PINCTRL_DOE2_CLR_ADDR     (HW_PINCTRL_DOE2_ADDR + 8)
#define HW_PINCTRL_DOE2_TOG_ADDR     (HW_PINCTRL_DOE2_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DOE2           (*(volatile hw_pinctrl_doe2_t *) HW_PINCTRL_DOE2_ADDR)
#define HW_PINCTRL_DOE2_RD()      (HW_PINCTRL_DOE2.U)
#define HW_PINCTRL_DOE2_WR(v)     (HW_PINCTRL_DOE2.U = (v))
#define HW_PINCTRL_DOE2_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE2_SET_ADDR) = (v))
#define HW_PINCTRL_DOE2_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE2_CLR_ADDR) = (v))
#define HW_PINCTRL_DOE2_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE2_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DOE2 bitfields
 */
/* --- Register HW_PINCTRL_DOE2, field RSRVD1 */

#define BP_PINCTRL_DOE2_RSRVD1      28
#define BM_PINCTRL_DOE2_RSRVD1      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DOE2_RSRVD1(v)   ((((reg32_t) v) << 28) & BM_PINCTRL_DOE2_RSRVD1)
#else
#define BF_PINCTRL_DOE2_RSRVD1(v)   (((v) << 28) & BM_PINCTRL_DOE2_RSRVD1)
#endif
/* --- Register HW_PINCTRL_DOE2, field DOE */

#define BP_PINCTRL_DOE2_DOE      0
#define BM_PINCTRL_DOE2_DOE      0x0FFFFFFF

#define BF_PINCTRL_DOE2_DOE(v)   (((v) << 0) & BM_PINCTRL_DOE2_DOE)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DOE2_DOE(v)   BF_CS1(PINCTRL_DOE2, DOE, v)
#endif



/*
 * HW_PINCTRL_DOE3 - PINCTRL Bank 3 Data Output Enable Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DOE     : 31;
        unsigned RSRVD1  :  1;
    } B;
} hw_pinctrl_doe3_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DOE3 register
 */
#define HW_PINCTRL_DOE3_ADDR         (REGS_PINCTRL_BASE + 0xb30)
#define HW_PINCTRL_DOE3_SET_ADDR     (HW_PINCTRL_DOE3_ADDR + 4)
#define HW_PINCTRL_DOE3_CLR_ADDR     (HW_PINCTRL_DOE3_ADDR + 8)
#define HW_PINCTRL_DOE3_TOG_ADDR     (HW_PINCTRL_DOE3_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DOE3           (*(volatile hw_pinctrl_doe3_t *) HW_PINCTRL_DOE3_ADDR)
#define HW_PINCTRL_DOE3_RD()      (HW_PINCTRL_DOE3.U)
#define HW_PINCTRL_DOE3_WR(v)     (HW_PINCTRL_DOE3.U = (v))
#define HW_PINCTRL_DOE3_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE3_SET_ADDR) = (v))
#define HW_PINCTRL_DOE3_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE3_CLR_ADDR) = (v))
#define HW_PINCTRL_DOE3_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE3_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DOE3 bitfields
 */
/* --- Register HW_PINCTRL_DOE3, field RSRVD1 */

#define BP_PINCTRL_DOE3_RSRVD1      31
#define BM_PINCTRL_DOE3_RSRVD1      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DOE3_RSRVD1(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_DOE3_RSRVD1)
#else
#define BF_PINCTRL_DOE3_RSRVD1(v)   (((v) << 31) & BM_PINCTRL_DOE3_RSRVD1)
#endif
/* --- Register HW_PINCTRL_DOE3, field DOE */

#define BP_PINCTRL_DOE3_DOE      0
#define BM_PINCTRL_DOE3_DOE      0x7FFFFFFF

#define BF_PINCTRL_DOE3_DOE(v)   (((v) << 0) & BM_PINCTRL_DOE3_DOE)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DOE3_DOE(v)   BF_CS1(PINCTRL_DOE3, DOE, v)
#endif



/*
 * HW_PINCTRL_DOE4 - PINCTRL Bank 4 Data Output Enable Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DOE     : 21;
        unsigned RSRVD1  : 11;
    } B;
} hw_pinctrl_doe4_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_DOE4 register
 */
#define HW_PINCTRL_DOE4_ADDR         (REGS_PINCTRL_BASE + 0xb40)
#define HW_PINCTRL_DOE4_SET_ADDR     (HW_PINCTRL_DOE4_ADDR + 4)
#define HW_PINCTRL_DOE4_CLR_ADDR     (HW_PINCTRL_DOE4_ADDR + 8)
#define HW_PINCTRL_DOE4_TOG_ADDR     (HW_PINCTRL_DOE4_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_DOE4           (*(volatile hw_pinctrl_doe4_t *) HW_PINCTRL_DOE4_ADDR)
#define HW_PINCTRL_DOE4_RD()      (HW_PINCTRL_DOE4.U)
#define HW_PINCTRL_DOE4_WR(v)     (HW_PINCTRL_DOE4.U = (v))
#define HW_PINCTRL_DOE4_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE4_SET_ADDR) = (v))
#define HW_PINCTRL_DOE4_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE4_CLR_ADDR) = (v))
#define HW_PINCTRL_DOE4_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_DOE4_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_DOE4 bitfields
 */
/* --- Register HW_PINCTRL_DOE4, field RSRVD1 */

#define BP_PINCTRL_DOE4_RSRVD1      21
#define BM_PINCTRL_DOE4_RSRVD1      0xFFE00000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_DOE4_RSRVD1(v)   ((((reg32_t) v) << 21) & BM_PINCTRL_DOE4_RSRVD1)
#else
#define BF_PINCTRL_DOE4_RSRVD1(v)   (((v) << 21) & BM_PINCTRL_DOE4_RSRVD1)
#endif
/* --- Register HW_PINCTRL_DOE4, field DOE */

#define BP_PINCTRL_DOE4_DOE      0
#define BM_PINCTRL_DOE4_DOE      0x001FFFFF

#define BF_PINCTRL_DOE4_DOE(v)   (((v) << 0) & BM_PINCTRL_DOE4_DOE)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_DOE4_DOE(v)   BF_CS1(PINCTRL_DOE4, DOE, v)
#endif



/*
 * HW_PINCTRL_PIN2IRQ0 - PINCTRL Bank 0 Interrupt Select Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PIN2IRQ  : 29;
        unsigned RSRVD1   :  3;
    } B;
} hw_pinctrl_pin2irq0_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_PIN2IRQ0 register
 */
#define HW_PINCTRL_PIN2IRQ0_ADDR         (REGS_PINCTRL_BASE + 0x1000)
#define HW_PINCTRL_PIN2IRQ0_SET_ADDR     (HW_PINCTRL_PIN2IRQ0_ADDR + 4)
#define HW_PINCTRL_PIN2IRQ0_CLR_ADDR     (HW_PINCTRL_PIN2IRQ0_ADDR + 8)
#define HW_PINCTRL_PIN2IRQ0_TOG_ADDR     (HW_PINCTRL_PIN2IRQ0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_PIN2IRQ0           (*(volatile hw_pinctrl_pin2irq0_t *) HW_PINCTRL_PIN2IRQ0_ADDR)
#define HW_PINCTRL_PIN2IRQ0_RD()      (HW_PINCTRL_PIN2IRQ0.U)
#define HW_PINCTRL_PIN2IRQ0_WR(v)     (HW_PINCTRL_PIN2IRQ0.U = (v))
#define HW_PINCTRL_PIN2IRQ0_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ0_SET_ADDR) = (v))
#define HW_PINCTRL_PIN2IRQ0_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ0_CLR_ADDR) = (v))
#define HW_PINCTRL_PIN2IRQ0_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_PIN2IRQ0 bitfields
 */
/* --- Register HW_PINCTRL_PIN2IRQ0, field RSRVD1 */

#define BP_PINCTRL_PIN2IRQ0_RSRVD1      29
#define BM_PINCTRL_PIN2IRQ0_RSRVD1      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_PIN2IRQ0_RSRVD1(v)   ((((reg32_t) v) << 29) & BM_PINCTRL_PIN2IRQ0_RSRVD1)
#else
#define BF_PINCTRL_PIN2IRQ0_RSRVD1(v)   (((v) << 29) & BM_PINCTRL_PIN2IRQ0_RSRVD1)
#endif
/* --- Register HW_PINCTRL_PIN2IRQ0, field PIN2IRQ */

#define BP_PINCTRL_PIN2IRQ0_PIN2IRQ      0
#define BM_PINCTRL_PIN2IRQ0_PIN2IRQ      0x1FFFFFFF

#define BF_PINCTRL_PIN2IRQ0_PIN2IRQ(v)   (((v) << 0) & BM_PINCTRL_PIN2IRQ0_PIN2IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PIN2IRQ0_PIN2IRQ(v)   BF_CS1(PINCTRL_PIN2IRQ0, PIN2IRQ, v)
#endif



/*
 * HW_PINCTRL_PIN2IRQ1 - PINCTRL Bank 1 Interrupt Select Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PIN2IRQ  : 32;
    } B;
} hw_pinctrl_pin2irq1_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_PIN2IRQ1 register
 */
#define HW_PINCTRL_PIN2IRQ1_ADDR         (REGS_PINCTRL_BASE + 0x1010)
#define HW_PINCTRL_PIN2IRQ1_SET_ADDR     (HW_PINCTRL_PIN2IRQ1_ADDR + 4)
#define HW_PINCTRL_PIN2IRQ1_CLR_ADDR     (HW_PINCTRL_PIN2IRQ1_ADDR + 8)
#define HW_PINCTRL_PIN2IRQ1_TOG_ADDR     (HW_PINCTRL_PIN2IRQ1_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_PIN2IRQ1           (*(volatile hw_pinctrl_pin2irq1_t *) HW_PINCTRL_PIN2IRQ1_ADDR)
#define HW_PINCTRL_PIN2IRQ1_RD()      (HW_PINCTRL_PIN2IRQ1.U)
#define HW_PINCTRL_PIN2IRQ1_WR(v)     (HW_PINCTRL_PIN2IRQ1.U = (v))
#define HW_PINCTRL_PIN2IRQ1_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ1_SET_ADDR) = (v))
#define HW_PINCTRL_PIN2IRQ1_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ1_CLR_ADDR) = (v))
#define HW_PINCTRL_PIN2IRQ1_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ1_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_PIN2IRQ1 bitfields
 */
/* --- Register HW_PINCTRL_PIN2IRQ1, field PIN2IRQ */

#define BP_PINCTRL_PIN2IRQ1_PIN2IRQ      0
#define BM_PINCTRL_PIN2IRQ1_PIN2IRQ      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_PIN2IRQ1_PIN2IRQ(v)   ((reg32_t) v)
#else
#define BF_PINCTRL_PIN2IRQ1_PIN2IRQ(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PIN2IRQ1_PIN2IRQ(v)   (HW_PINCTRL_PIN2IRQ1.B.PIN2IRQ = (v))
#endif



/*
 * HW_PINCTRL_PIN2IRQ2 - PINCTRL Bank 2 Interrupt Select Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PIN2IRQ  : 28;
        unsigned RSRVD1   :  4;
    } B;
} hw_pinctrl_pin2irq2_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_PIN2IRQ2 register
 */
#define HW_PINCTRL_PIN2IRQ2_ADDR         (REGS_PINCTRL_BASE + 0x1020)
#define HW_PINCTRL_PIN2IRQ2_SET_ADDR     (HW_PINCTRL_PIN2IRQ2_ADDR + 4)
#define HW_PINCTRL_PIN2IRQ2_CLR_ADDR     (HW_PINCTRL_PIN2IRQ2_ADDR + 8)
#define HW_PINCTRL_PIN2IRQ2_TOG_ADDR     (HW_PINCTRL_PIN2IRQ2_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_PIN2IRQ2           (*(volatile hw_pinctrl_pin2irq2_t *) HW_PINCTRL_PIN2IRQ2_ADDR)
#define HW_PINCTRL_PIN2IRQ2_RD()      (HW_PINCTRL_PIN2IRQ2.U)
#define HW_PINCTRL_PIN2IRQ2_WR(v)     (HW_PINCTRL_PIN2IRQ2.U = (v))
#define HW_PINCTRL_PIN2IRQ2_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ2_SET_ADDR) = (v))
#define HW_PINCTRL_PIN2IRQ2_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ2_CLR_ADDR) = (v))
#define HW_PINCTRL_PIN2IRQ2_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ2_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_PIN2IRQ2 bitfields
 */
/* --- Register HW_PINCTRL_PIN2IRQ2, field RSRVD1 */

#define BP_PINCTRL_PIN2IRQ2_RSRVD1      28
#define BM_PINCTRL_PIN2IRQ2_RSRVD1      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_PIN2IRQ2_RSRVD1(v)   ((((reg32_t) v) << 28) & BM_PINCTRL_PIN2IRQ2_RSRVD1)
#else
#define BF_PINCTRL_PIN2IRQ2_RSRVD1(v)   (((v) << 28) & BM_PINCTRL_PIN2IRQ2_RSRVD1)
#endif
/* --- Register HW_PINCTRL_PIN2IRQ2, field PIN2IRQ */

#define BP_PINCTRL_PIN2IRQ2_PIN2IRQ      0
#define BM_PINCTRL_PIN2IRQ2_PIN2IRQ      0x0FFFFFFF

#define BF_PINCTRL_PIN2IRQ2_PIN2IRQ(v)   (((v) << 0) & BM_PINCTRL_PIN2IRQ2_PIN2IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PIN2IRQ2_PIN2IRQ(v)   BF_CS1(PINCTRL_PIN2IRQ2, PIN2IRQ, v)
#endif



/*
 * HW_PINCTRL_PIN2IRQ3 - PINCTRL Bank 3 Interrupt Select Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PIN2IRQ  : 31;
        unsigned RSRVD1   :  1;
    } B;
} hw_pinctrl_pin2irq3_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_PIN2IRQ3 register
 */
#define HW_PINCTRL_PIN2IRQ3_ADDR         (REGS_PINCTRL_BASE + 0x1030)
#define HW_PINCTRL_PIN2IRQ3_SET_ADDR     (HW_PINCTRL_PIN2IRQ3_ADDR + 4)
#define HW_PINCTRL_PIN2IRQ3_CLR_ADDR     (HW_PINCTRL_PIN2IRQ3_ADDR + 8)
#define HW_PINCTRL_PIN2IRQ3_TOG_ADDR     (HW_PINCTRL_PIN2IRQ3_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_PIN2IRQ3           (*(volatile hw_pinctrl_pin2irq3_t *) HW_PINCTRL_PIN2IRQ3_ADDR)
#define HW_PINCTRL_PIN2IRQ3_RD()      (HW_PINCTRL_PIN2IRQ3.U)
#define HW_PINCTRL_PIN2IRQ3_WR(v)     (HW_PINCTRL_PIN2IRQ3.U = (v))
#define HW_PINCTRL_PIN2IRQ3_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ3_SET_ADDR) = (v))
#define HW_PINCTRL_PIN2IRQ3_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ3_CLR_ADDR) = (v))
#define HW_PINCTRL_PIN2IRQ3_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ3_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_PIN2IRQ3 bitfields
 */
/* --- Register HW_PINCTRL_PIN2IRQ3, field RSRVD1 */

#define BP_PINCTRL_PIN2IRQ3_RSRVD1      31
#define BM_PINCTRL_PIN2IRQ3_RSRVD1      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_PIN2IRQ3_RSRVD1(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_PIN2IRQ3_RSRVD1)
#else
#define BF_PINCTRL_PIN2IRQ3_RSRVD1(v)   (((v) << 31) & BM_PINCTRL_PIN2IRQ3_RSRVD1)
#endif
/* --- Register HW_PINCTRL_PIN2IRQ3, field PIN2IRQ */

#define BP_PINCTRL_PIN2IRQ3_PIN2IRQ      0
#define BM_PINCTRL_PIN2IRQ3_PIN2IRQ      0x7FFFFFFF

#define BF_PINCTRL_PIN2IRQ3_PIN2IRQ(v)   (((v) << 0) & BM_PINCTRL_PIN2IRQ3_PIN2IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PIN2IRQ3_PIN2IRQ(v)   BF_CS1(PINCTRL_PIN2IRQ3, PIN2IRQ, v)
#endif



/*
 * HW_PINCTRL_PIN2IRQ4 - PINCTRL Bank 4 Interrupt Select Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PIN2IRQ  : 21;
        unsigned RSRVD1   : 11;
    } B;
} hw_pinctrl_pin2irq4_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_PIN2IRQ4 register
 */
#define HW_PINCTRL_PIN2IRQ4_ADDR         (REGS_PINCTRL_BASE + 0x1040)
#define HW_PINCTRL_PIN2IRQ4_SET_ADDR     (HW_PINCTRL_PIN2IRQ4_ADDR + 4)
#define HW_PINCTRL_PIN2IRQ4_CLR_ADDR     (HW_PINCTRL_PIN2IRQ4_ADDR + 8)
#define HW_PINCTRL_PIN2IRQ4_TOG_ADDR     (HW_PINCTRL_PIN2IRQ4_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_PIN2IRQ4           (*(volatile hw_pinctrl_pin2irq4_t *) HW_PINCTRL_PIN2IRQ4_ADDR)
#define HW_PINCTRL_PIN2IRQ4_RD()      (HW_PINCTRL_PIN2IRQ4.U)
#define HW_PINCTRL_PIN2IRQ4_WR(v)     (HW_PINCTRL_PIN2IRQ4.U = (v))
#define HW_PINCTRL_PIN2IRQ4_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ4_SET_ADDR) = (v))
#define HW_PINCTRL_PIN2IRQ4_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ4_CLR_ADDR) = (v))
#define HW_PINCTRL_PIN2IRQ4_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_PIN2IRQ4_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_PIN2IRQ4 bitfields
 */
/* --- Register HW_PINCTRL_PIN2IRQ4, field RSRVD1 */

#define BP_PINCTRL_PIN2IRQ4_RSRVD1      21
#define BM_PINCTRL_PIN2IRQ4_RSRVD1      0xFFE00000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_PIN2IRQ4_RSRVD1(v)   ((((reg32_t) v) << 21) & BM_PINCTRL_PIN2IRQ4_RSRVD1)
#else
#define BF_PINCTRL_PIN2IRQ4_RSRVD1(v)   (((v) << 21) & BM_PINCTRL_PIN2IRQ4_RSRVD1)
#endif
/* --- Register HW_PINCTRL_PIN2IRQ4, field PIN2IRQ */

#define BP_PINCTRL_PIN2IRQ4_PIN2IRQ      0
#define BM_PINCTRL_PIN2IRQ4_PIN2IRQ      0x001FFFFF

#define BF_PINCTRL_PIN2IRQ4_PIN2IRQ(v)   (((v) << 0) & BM_PINCTRL_PIN2IRQ4_PIN2IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_PIN2IRQ4_PIN2IRQ(v)   BF_CS1(PINCTRL_PIN2IRQ4, PIN2IRQ, v)
#endif



/*
 * HW_PINCTRL_IRQEN0 - PINCTRL Bank 0 Interrupt Mask Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQEN   : 29;
        unsigned RSRVD1  :  3;
    } B;
} hw_pinctrl_irqen0_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQEN0 register
 */
#define HW_PINCTRL_IRQEN0_ADDR         (REGS_PINCTRL_BASE + 0x1100)
#define HW_PINCTRL_IRQEN0_SET_ADDR     (HW_PINCTRL_IRQEN0_ADDR + 4)
#define HW_PINCTRL_IRQEN0_CLR_ADDR     (HW_PINCTRL_IRQEN0_ADDR + 8)
#define HW_PINCTRL_IRQEN0_TOG_ADDR     (HW_PINCTRL_IRQEN0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQEN0           (*(volatile hw_pinctrl_irqen0_t *) HW_PINCTRL_IRQEN0_ADDR)
#define HW_PINCTRL_IRQEN0_RD()      (HW_PINCTRL_IRQEN0.U)
#define HW_PINCTRL_IRQEN0_WR(v)     (HW_PINCTRL_IRQEN0.U = (v))
#define HW_PINCTRL_IRQEN0_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN0_SET_ADDR) = (v))
#define HW_PINCTRL_IRQEN0_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN0_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQEN0_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQEN0 bitfields
 */
/* --- Register HW_PINCTRL_IRQEN0, field RSRVD1 */

#define BP_PINCTRL_IRQEN0_RSRVD1      29
#define BM_PINCTRL_IRQEN0_RSRVD1      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQEN0_RSRVD1(v)   ((((reg32_t) v) << 29) & BM_PINCTRL_IRQEN0_RSRVD1)
#else
#define BF_PINCTRL_IRQEN0_RSRVD1(v)   (((v) << 29) & BM_PINCTRL_IRQEN0_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQEN0, field IRQEN */

#define BP_PINCTRL_IRQEN0_IRQEN      0
#define BM_PINCTRL_IRQEN0_IRQEN      0x1FFFFFFF

#define BF_PINCTRL_IRQEN0_IRQEN(v)   (((v) << 0) & BM_PINCTRL_IRQEN0_IRQEN)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQEN0_IRQEN(v)   BF_CS1(PINCTRL_IRQEN0, IRQEN, v)
#endif



/*
 * HW_PINCTRL_IRQEN1 - PINCTRL Bank 1 Interrupt Mask Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQEN  : 32;
    } B;
} hw_pinctrl_irqen1_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQEN1 register
 */
#define HW_PINCTRL_IRQEN1_ADDR         (REGS_PINCTRL_BASE + 0x1110)
#define HW_PINCTRL_IRQEN1_SET_ADDR     (HW_PINCTRL_IRQEN1_ADDR + 4)
#define HW_PINCTRL_IRQEN1_CLR_ADDR     (HW_PINCTRL_IRQEN1_ADDR + 8)
#define HW_PINCTRL_IRQEN1_TOG_ADDR     (HW_PINCTRL_IRQEN1_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQEN1           (*(volatile hw_pinctrl_irqen1_t *) HW_PINCTRL_IRQEN1_ADDR)
#define HW_PINCTRL_IRQEN1_RD()      (HW_PINCTRL_IRQEN1.U)
#define HW_PINCTRL_IRQEN1_WR(v)     (HW_PINCTRL_IRQEN1.U = (v))
#define HW_PINCTRL_IRQEN1_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN1_SET_ADDR) = (v))
#define HW_PINCTRL_IRQEN1_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN1_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQEN1_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN1_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQEN1 bitfields
 */
/* --- Register HW_PINCTRL_IRQEN1, field IRQEN */

#define BP_PINCTRL_IRQEN1_IRQEN      0
#define BM_PINCTRL_IRQEN1_IRQEN      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQEN1_IRQEN(v)   ((reg32_t) v)
#else
#define BF_PINCTRL_IRQEN1_IRQEN(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQEN1_IRQEN(v)   (HW_PINCTRL_IRQEN1.B.IRQEN = (v))
#endif



/*
 * HW_PINCTRL_IRQEN2 - PINCTRL Bank 2 Interrupt Mask Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQEN   : 28;
        unsigned RSRVD1  :  4;
    } B;
} hw_pinctrl_irqen2_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQEN2 register
 */
#define HW_PINCTRL_IRQEN2_ADDR         (REGS_PINCTRL_BASE + 0x1120)
#define HW_PINCTRL_IRQEN2_SET_ADDR     (HW_PINCTRL_IRQEN2_ADDR + 4)
#define HW_PINCTRL_IRQEN2_CLR_ADDR     (HW_PINCTRL_IRQEN2_ADDR + 8)
#define HW_PINCTRL_IRQEN2_TOG_ADDR     (HW_PINCTRL_IRQEN2_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQEN2           (*(volatile hw_pinctrl_irqen2_t *) HW_PINCTRL_IRQEN2_ADDR)
#define HW_PINCTRL_IRQEN2_RD()      (HW_PINCTRL_IRQEN2.U)
#define HW_PINCTRL_IRQEN2_WR(v)     (HW_PINCTRL_IRQEN2.U = (v))
#define HW_PINCTRL_IRQEN2_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN2_SET_ADDR) = (v))
#define HW_PINCTRL_IRQEN2_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN2_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQEN2_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN2_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQEN2 bitfields
 */
/* --- Register HW_PINCTRL_IRQEN2, field RSRVD1 */

#define BP_PINCTRL_IRQEN2_RSRVD1      28
#define BM_PINCTRL_IRQEN2_RSRVD1      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQEN2_RSRVD1(v)   ((((reg32_t) v) << 28) & BM_PINCTRL_IRQEN2_RSRVD1)
#else
#define BF_PINCTRL_IRQEN2_RSRVD1(v)   (((v) << 28) & BM_PINCTRL_IRQEN2_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQEN2, field IRQEN */

#define BP_PINCTRL_IRQEN2_IRQEN      0
#define BM_PINCTRL_IRQEN2_IRQEN      0x0FFFFFFF

#define BF_PINCTRL_IRQEN2_IRQEN(v)   (((v) << 0) & BM_PINCTRL_IRQEN2_IRQEN)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQEN2_IRQEN(v)   BF_CS1(PINCTRL_IRQEN2, IRQEN, v)
#endif



/*
 * HW_PINCTRL_IRQEN3 - PINCTRL Bank 3 Interrupt Mask Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQEN   : 31;
        unsigned RSRVD1  :  1;
    } B;
} hw_pinctrl_irqen3_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQEN3 register
 */
#define HW_PINCTRL_IRQEN3_ADDR         (REGS_PINCTRL_BASE + 0x1130)
#define HW_PINCTRL_IRQEN3_SET_ADDR     (HW_PINCTRL_IRQEN3_ADDR + 4)
#define HW_PINCTRL_IRQEN3_CLR_ADDR     (HW_PINCTRL_IRQEN3_ADDR + 8)
#define HW_PINCTRL_IRQEN3_TOG_ADDR     (HW_PINCTRL_IRQEN3_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQEN3           (*(volatile hw_pinctrl_irqen3_t *) HW_PINCTRL_IRQEN3_ADDR)
#define HW_PINCTRL_IRQEN3_RD()      (HW_PINCTRL_IRQEN3.U)
#define HW_PINCTRL_IRQEN3_WR(v)     (HW_PINCTRL_IRQEN3.U = (v))
#define HW_PINCTRL_IRQEN3_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN3_SET_ADDR) = (v))
#define HW_PINCTRL_IRQEN3_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN3_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQEN3_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN3_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQEN3 bitfields
 */
/* --- Register HW_PINCTRL_IRQEN3, field RSRVD1 */

#define BP_PINCTRL_IRQEN3_RSRVD1      31
#define BM_PINCTRL_IRQEN3_RSRVD1      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQEN3_RSRVD1(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_IRQEN3_RSRVD1)
#else
#define BF_PINCTRL_IRQEN3_RSRVD1(v)   (((v) << 31) & BM_PINCTRL_IRQEN3_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQEN3, field IRQEN */

#define BP_PINCTRL_IRQEN3_IRQEN      0
#define BM_PINCTRL_IRQEN3_IRQEN      0x7FFFFFFF

#define BF_PINCTRL_IRQEN3_IRQEN(v)   (((v) << 0) & BM_PINCTRL_IRQEN3_IRQEN)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQEN3_IRQEN(v)   BF_CS1(PINCTRL_IRQEN3, IRQEN, v)
#endif



/*
 * HW_PINCTRL_IRQEN4 - PINCTRL Bank 4 Interrupt Mask Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQEN   : 21;
        unsigned RSRVD1  : 11;
    } B;
} hw_pinctrl_irqen4_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQEN4 register
 */
#define HW_PINCTRL_IRQEN4_ADDR         (REGS_PINCTRL_BASE + 0x1140)
#define HW_PINCTRL_IRQEN4_SET_ADDR     (HW_PINCTRL_IRQEN4_ADDR + 4)
#define HW_PINCTRL_IRQEN4_CLR_ADDR     (HW_PINCTRL_IRQEN4_ADDR + 8)
#define HW_PINCTRL_IRQEN4_TOG_ADDR     (HW_PINCTRL_IRQEN4_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQEN4           (*(volatile hw_pinctrl_irqen4_t *) HW_PINCTRL_IRQEN4_ADDR)
#define HW_PINCTRL_IRQEN4_RD()      (HW_PINCTRL_IRQEN4.U)
#define HW_PINCTRL_IRQEN4_WR(v)     (HW_PINCTRL_IRQEN4.U = (v))
#define HW_PINCTRL_IRQEN4_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN4_SET_ADDR) = (v))
#define HW_PINCTRL_IRQEN4_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN4_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQEN4_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQEN4_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQEN4 bitfields
 */
/* --- Register HW_PINCTRL_IRQEN4, field RSRVD1 */

#define BP_PINCTRL_IRQEN4_RSRVD1      21
#define BM_PINCTRL_IRQEN4_RSRVD1      0xFFE00000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQEN4_RSRVD1(v)   ((((reg32_t) v) << 21) & BM_PINCTRL_IRQEN4_RSRVD1)
#else
#define BF_PINCTRL_IRQEN4_RSRVD1(v)   (((v) << 21) & BM_PINCTRL_IRQEN4_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQEN4, field IRQEN */

#define BP_PINCTRL_IRQEN4_IRQEN      0
#define BM_PINCTRL_IRQEN4_IRQEN      0x001FFFFF

#define BF_PINCTRL_IRQEN4_IRQEN(v)   (((v) << 0) & BM_PINCTRL_IRQEN4_IRQEN)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQEN4_IRQEN(v)   BF_CS1(PINCTRL_IRQEN4, IRQEN, v)
#endif



/*
 * HW_PINCTRL_IRQLEVEL0 - PINCTRL Bank 0 Interrupt Level/Edge Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQLEVEL  : 29;
        unsigned RSRVD1    :  3;
    } B;
} hw_pinctrl_irqlevel0_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQLEVEL0 register
 */
#define HW_PINCTRL_IRQLEVEL0_ADDR         (REGS_PINCTRL_BASE + 0x1200)
#define HW_PINCTRL_IRQLEVEL0_SET_ADDR     (HW_PINCTRL_IRQLEVEL0_ADDR + 4)
#define HW_PINCTRL_IRQLEVEL0_CLR_ADDR     (HW_PINCTRL_IRQLEVEL0_ADDR + 8)
#define HW_PINCTRL_IRQLEVEL0_TOG_ADDR     (HW_PINCTRL_IRQLEVEL0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQLEVEL0           (*(volatile hw_pinctrl_irqlevel0_t *) HW_PINCTRL_IRQLEVEL0_ADDR)
#define HW_PINCTRL_IRQLEVEL0_RD()      (HW_PINCTRL_IRQLEVEL0.U)
#define HW_PINCTRL_IRQLEVEL0_WR(v)     (HW_PINCTRL_IRQLEVEL0.U = (v))
#define HW_PINCTRL_IRQLEVEL0_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL0_SET_ADDR) = (v))
#define HW_PINCTRL_IRQLEVEL0_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL0_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQLEVEL0_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQLEVEL0 bitfields
 */
/* --- Register HW_PINCTRL_IRQLEVEL0, field RSRVD1 */

#define BP_PINCTRL_IRQLEVEL0_RSRVD1      29
#define BM_PINCTRL_IRQLEVEL0_RSRVD1      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQLEVEL0_RSRVD1(v)   ((((reg32_t) v) << 29) & BM_PINCTRL_IRQLEVEL0_RSRVD1)
#else
#define BF_PINCTRL_IRQLEVEL0_RSRVD1(v)   (((v) << 29) & BM_PINCTRL_IRQLEVEL0_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQLEVEL0, field IRQLEVEL */

#define BP_PINCTRL_IRQLEVEL0_IRQLEVEL      0
#define BM_PINCTRL_IRQLEVEL0_IRQLEVEL      0x1FFFFFFF

#define BF_PINCTRL_IRQLEVEL0_IRQLEVEL(v)   (((v) << 0) & BM_PINCTRL_IRQLEVEL0_IRQLEVEL)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQLEVEL0_IRQLEVEL(v)   BF_CS1(PINCTRL_IRQLEVEL0, IRQLEVEL, v)
#endif



/*
 * HW_PINCTRL_IRQLEVEL1 - PINCTRL Bank 1 Interrupt Level/Edge Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQLEVEL  : 32;
    } B;
} hw_pinctrl_irqlevel1_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQLEVEL1 register
 */
#define HW_PINCTRL_IRQLEVEL1_ADDR         (REGS_PINCTRL_BASE + 0x1210)
#define HW_PINCTRL_IRQLEVEL1_SET_ADDR     (HW_PINCTRL_IRQLEVEL1_ADDR + 4)
#define HW_PINCTRL_IRQLEVEL1_CLR_ADDR     (HW_PINCTRL_IRQLEVEL1_ADDR + 8)
#define HW_PINCTRL_IRQLEVEL1_TOG_ADDR     (HW_PINCTRL_IRQLEVEL1_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQLEVEL1           (*(volatile hw_pinctrl_irqlevel1_t *) HW_PINCTRL_IRQLEVEL1_ADDR)
#define HW_PINCTRL_IRQLEVEL1_RD()      (HW_PINCTRL_IRQLEVEL1.U)
#define HW_PINCTRL_IRQLEVEL1_WR(v)     (HW_PINCTRL_IRQLEVEL1.U = (v))
#define HW_PINCTRL_IRQLEVEL1_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL1_SET_ADDR) = (v))
#define HW_PINCTRL_IRQLEVEL1_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL1_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQLEVEL1_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL1_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQLEVEL1 bitfields
 */
/* --- Register HW_PINCTRL_IRQLEVEL1, field IRQLEVEL */

#define BP_PINCTRL_IRQLEVEL1_IRQLEVEL      0
#define BM_PINCTRL_IRQLEVEL1_IRQLEVEL      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQLEVEL1_IRQLEVEL(v)   ((reg32_t) v)
#else
#define BF_PINCTRL_IRQLEVEL1_IRQLEVEL(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQLEVEL1_IRQLEVEL(v)   (HW_PINCTRL_IRQLEVEL1.B.IRQLEVEL = (v))
#endif



/*
 * HW_PINCTRL_IRQLEVEL2 - PINCTRL Bank 2 Interrupt Level/Edge Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQLEVEL  : 28;
        unsigned RSRVD1    :  4;
    } B;
} hw_pinctrl_irqlevel2_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQLEVEL2 register
 */
#define HW_PINCTRL_IRQLEVEL2_ADDR         (REGS_PINCTRL_BASE + 0x1220)
#define HW_PINCTRL_IRQLEVEL2_SET_ADDR     (HW_PINCTRL_IRQLEVEL2_ADDR + 4)
#define HW_PINCTRL_IRQLEVEL2_CLR_ADDR     (HW_PINCTRL_IRQLEVEL2_ADDR + 8)
#define HW_PINCTRL_IRQLEVEL2_TOG_ADDR     (HW_PINCTRL_IRQLEVEL2_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQLEVEL2           (*(volatile hw_pinctrl_irqlevel2_t *) HW_PINCTRL_IRQLEVEL2_ADDR)
#define HW_PINCTRL_IRQLEVEL2_RD()      (HW_PINCTRL_IRQLEVEL2.U)
#define HW_PINCTRL_IRQLEVEL2_WR(v)     (HW_PINCTRL_IRQLEVEL2.U = (v))
#define HW_PINCTRL_IRQLEVEL2_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL2_SET_ADDR) = (v))
#define HW_PINCTRL_IRQLEVEL2_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL2_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQLEVEL2_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL2_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQLEVEL2 bitfields
 */
/* --- Register HW_PINCTRL_IRQLEVEL2, field RSRVD1 */

#define BP_PINCTRL_IRQLEVEL2_RSRVD1      28
#define BM_PINCTRL_IRQLEVEL2_RSRVD1      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQLEVEL2_RSRVD1(v)   ((((reg32_t) v) << 28) & BM_PINCTRL_IRQLEVEL2_RSRVD1)
#else
#define BF_PINCTRL_IRQLEVEL2_RSRVD1(v)   (((v) << 28) & BM_PINCTRL_IRQLEVEL2_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQLEVEL2, field IRQLEVEL */

#define BP_PINCTRL_IRQLEVEL2_IRQLEVEL      0
#define BM_PINCTRL_IRQLEVEL2_IRQLEVEL      0x0FFFFFFF

#define BF_PINCTRL_IRQLEVEL2_IRQLEVEL(v)   (((v) << 0) & BM_PINCTRL_IRQLEVEL2_IRQLEVEL)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQLEVEL2_IRQLEVEL(v)   BF_CS1(PINCTRL_IRQLEVEL2, IRQLEVEL, v)
#endif



/*
 * HW_PINCTRL_IRQLEVEL3 - PINCTRL Bank 3 Interrupt Level/Edge Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQLEVEL  : 31;
        unsigned RSRVD1    :  1;
    } B;
} hw_pinctrl_irqlevel3_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQLEVEL3 register
 */
#define HW_PINCTRL_IRQLEVEL3_ADDR         (REGS_PINCTRL_BASE + 0x1230)
#define HW_PINCTRL_IRQLEVEL3_SET_ADDR     (HW_PINCTRL_IRQLEVEL3_ADDR + 4)
#define HW_PINCTRL_IRQLEVEL3_CLR_ADDR     (HW_PINCTRL_IRQLEVEL3_ADDR + 8)
#define HW_PINCTRL_IRQLEVEL3_TOG_ADDR     (HW_PINCTRL_IRQLEVEL3_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQLEVEL3           (*(volatile hw_pinctrl_irqlevel3_t *) HW_PINCTRL_IRQLEVEL3_ADDR)
#define HW_PINCTRL_IRQLEVEL3_RD()      (HW_PINCTRL_IRQLEVEL3.U)
#define HW_PINCTRL_IRQLEVEL3_WR(v)     (HW_PINCTRL_IRQLEVEL3.U = (v))
#define HW_PINCTRL_IRQLEVEL3_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL3_SET_ADDR) = (v))
#define HW_PINCTRL_IRQLEVEL3_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL3_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQLEVEL3_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL3_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQLEVEL3 bitfields
 */
/* --- Register HW_PINCTRL_IRQLEVEL3, field RSRVD1 */

#define BP_PINCTRL_IRQLEVEL3_RSRVD1      31
#define BM_PINCTRL_IRQLEVEL3_RSRVD1      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQLEVEL3_RSRVD1(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_IRQLEVEL3_RSRVD1)
#else
#define BF_PINCTRL_IRQLEVEL3_RSRVD1(v)   (((v) << 31) & BM_PINCTRL_IRQLEVEL3_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQLEVEL3, field IRQLEVEL */

#define BP_PINCTRL_IRQLEVEL3_IRQLEVEL      0
#define BM_PINCTRL_IRQLEVEL3_IRQLEVEL      0x7FFFFFFF

#define BF_PINCTRL_IRQLEVEL3_IRQLEVEL(v)   (((v) << 0) & BM_PINCTRL_IRQLEVEL3_IRQLEVEL)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQLEVEL3_IRQLEVEL(v)   BF_CS1(PINCTRL_IRQLEVEL3, IRQLEVEL, v)
#endif



/*
 * HW_PINCTRL_IRQLEVEL4 - PINCTRL Bank 4 Interrupt Level/Edge Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQLEVEL  : 21;
        unsigned RSRVD1    : 11;
    } B;
} hw_pinctrl_irqlevel4_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQLEVEL4 register
 */
#define HW_PINCTRL_IRQLEVEL4_ADDR         (REGS_PINCTRL_BASE + 0x1240)
#define HW_PINCTRL_IRQLEVEL4_SET_ADDR     (HW_PINCTRL_IRQLEVEL4_ADDR + 4)
#define HW_PINCTRL_IRQLEVEL4_CLR_ADDR     (HW_PINCTRL_IRQLEVEL4_ADDR + 8)
#define HW_PINCTRL_IRQLEVEL4_TOG_ADDR     (HW_PINCTRL_IRQLEVEL4_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQLEVEL4           (*(volatile hw_pinctrl_irqlevel4_t *) HW_PINCTRL_IRQLEVEL4_ADDR)
#define HW_PINCTRL_IRQLEVEL4_RD()      (HW_PINCTRL_IRQLEVEL4.U)
#define HW_PINCTRL_IRQLEVEL4_WR(v)     (HW_PINCTRL_IRQLEVEL4.U = (v))
#define HW_PINCTRL_IRQLEVEL4_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL4_SET_ADDR) = (v))
#define HW_PINCTRL_IRQLEVEL4_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL4_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQLEVEL4_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQLEVEL4_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQLEVEL4 bitfields
 */
/* --- Register HW_PINCTRL_IRQLEVEL4, field RSRVD1 */

#define BP_PINCTRL_IRQLEVEL4_RSRVD1      21
#define BM_PINCTRL_IRQLEVEL4_RSRVD1      0xFFE00000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQLEVEL4_RSRVD1(v)   ((((reg32_t) v) << 21) & BM_PINCTRL_IRQLEVEL4_RSRVD1)
#else
#define BF_PINCTRL_IRQLEVEL4_RSRVD1(v)   (((v) << 21) & BM_PINCTRL_IRQLEVEL4_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQLEVEL4, field IRQLEVEL */

#define BP_PINCTRL_IRQLEVEL4_IRQLEVEL      0
#define BM_PINCTRL_IRQLEVEL4_IRQLEVEL      0x001FFFFF

#define BF_PINCTRL_IRQLEVEL4_IRQLEVEL(v)   (((v) << 0) & BM_PINCTRL_IRQLEVEL4_IRQLEVEL)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQLEVEL4_IRQLEVEL(v)   BF_CS1(PINCTRL_IRQLEVEL4, IRQLEVEL, v)
#endif



/*
 * HW_PINCTRL_IRQPOL0 - PINCTRL Bank 0 Interrupt Polarity Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQPOL  : 29;
        unsigned RSRVD1  :  3;
    } B;
} hw_pinctrl_irqpol0_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQPOL0 register
 */
#define HW_PINCTRL_IRQPOL0_ADDR         (REGS_PINCTRL_BASE + 0x1300)
#define HW_PINCTRL_IRQPOL0_SET_ADDR     (HW_PINCTRL_IRQPOL0_ADDR + 4)
#define HW_PINCTRL_IRQPOL0_CLR_ADDR     (HW_PINCTRL_IRQPOL0_ADDR + 8)
#define HW_PINCTRL_IRQPOL0_TOG_ADDR     (HW_PINCTRL_IRQPOL0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQPOL0           (*(volatile hw_pinctrl_irqpol0_t *) HW_PINCTRL_IRQPOL0_ADDR)
#define HW_PINCTRL_IRQPOL0_RD()      (HW_PINCTRL_IRQPOL0.U)
#define HW_PINCTRL_IRQPOL0_WR(v)     (HW_PINCTRL_IRQPOL0.U = (v))
#define HW_PINCTRL_IRQPOL0_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL0_SET_ADDR) = (v))
#define HW_PINCTRL_IRQPOL0_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL0_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQPOL0_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQPOL0 bitfields
 */
/* --- Register HW_PINCTRL_IRQPOL0, field RSRVD1 */

#define BP_PINCTRL_IRQPOL0_RSRVD1      29
#define BM_PINCTRL_IRQPOL0_RSRVD1      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQPOL0_RSRVD1(v)   ((((reg32_t) v) << 29) & BM_PINCTRL_IRQPOL0_RSRVD1)
#else
#define BF_PINCTRL_IRQPOL0_RSRVD1(v)   (((v) << 29) & BM_PINCTRL_IRQPOL0_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQPOL0, field IRQPOL */

#define BP_PINCTRL_IRQPOL0_IRQPOL      0
#define BM_PINCTRL_IRQPOL0_IRQPOL      0x1FFFFFFF

#define BF_PINCTRL_IRQPOL0_IRQPOL(v)   (((v) << 0) & BM_PINCTRL_IRQPOL0_IRQPOL)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQPOL0_IRQPOL(v)   BF_CS1(PINCTRL_IRQPOL0, IRQPOL, v)
#endif



/*
 * HW_PINCTRL_IRQPOL1 - PINCTRL Bank 1 Interrupt Polarity Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQPOL  : 32;
    } B;
} hw_pinctrl_irqpol1_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQPOL1 register
 */
#define HW_PINCTRL_IRQPOL1_ADDR         (REGS_PINCTRL_BASE + 0x1310)
#define HW_PINCTRL_IRQPOL1_SET_ADDR     (HW_PINCTRL_IRQPOL1_ADDR + 4)
#define HW_PINCTRL_IRQPOL1_CLR_ADDR     (HW_PINCTRL_IRQPOL1_ADDR + 8)
#define HW_PINCTRL_IRQPOL1_TOG_ADDR     (HW_PINCTRL_IRQPOL1_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQPOL1           (*(volatile hw_pinctrl_irqpol1_t *) HW_PINCTRL_IRQPOL1_ADDR)
#define HW_PINCTRL_IRQPOL1_RD()      (HW_PINCTRL_IRQPOL1.U)
#define HW_PINCTRL_IRQPOL1_WR(v)     (HW_PINCTRL_IRQPOL1.U = (v))
#define HW_PINCTRL_IRQPOL1_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL1_SET_ADDR) = (v))
#define HW_PINCTRL_IRQPOL1_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL1_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQPOL1_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL1_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQPOL1 bitfields
 */
/* --- Register HW_PINCTRL_IRQPOL1, field IRQPOL */

#define BP_PINCTRL_IRQPOL1_IRQPOL      0
#define BM_PINCTRL_IRQPOL1_IRQPOL      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQPOL1_IRQPOL(v)   ((reg32_t) v)
#else
#define BF_PINCTRL_IRQPOL1_IRQPOL(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQPOL1_IRQPOL(v)   (HW_PINCTRL_IRQPOL1.B.IRQPOL = (v))
#endif



/*
 * HW_PINCTRL_IRQPOL2 - PINCTRL Bank 2 Interrupt Polarity Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQPOL  : 28;
        unsigned RSRVD1  :  4;
    } B;
} hw_pinctrl_irqpol2_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQPOL2 register
 */
#define HW_PINCTRL_IRQPOL2_ADDR         (REGS_PINCTRL_BASE + 0x1320)
#define HW_PINCTRL_IRQPOL2_SET_ADDR     (HW_PINCTRL_IRQPOL2_ADDR + 4)
#define HW_PINCTRL_IRQPOL2_CLR_ADDR     (HW_PINCTRL_IRQPOL2_ADDR + 8)
#define HW_PINCTRL_IRQPOL2_TOG_ADDR     (HW_PINCTRL_IRQPOL2_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQPOL2           (*(volatile hw_pinctrl_irqpol2_t *) HW_PINCTRL_IRQPOL2_ADDR)
#define HW_PINCTRL_IRQPOL2_RD()      (HW_PINCTRL_IRQPOL2.U)
#define HW_PINCTRL_IRQPOL2_WR(v)     (HW_PINCTRL_IRQPOL2.U = (v))
#define HW_PINCTRL_IRQPOL2_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL2_SET_ADDR) = (v))
#define HW_PINCTRL_IRQPOL2_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL2_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQPOL2_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL2_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQPOL2 bitfields
 */
/* --- Register HW_PINCTRL_IRQPOL2, field RSRVD1 */

#define BP_PINCTRL_IRQPOL2_RSRVD1      28
#define BM_PINCTRL_IRQPOL2_RSRVD1      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQPOL2_RSRVD1(v)   ((((reg32_t) v) << 28) & BM_PINCTRL_IRQPOL2_RSRVD1)
#else
#define BF_PINCTRL_IRQPOL2_RSRVD1(v)   (((v) << 28) & BM_PINCTRL_IRQPOL2_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQPOL2, field IRQPOL */

#define BP_PINCTRL_IRQPOL2_IRQPOL      0
#define BM_PINCTRL_IRQPOL2_IRQPOL      0x0FFFFFFF

#define BF_PINCTRL_IRQPOL2_IRQPOL(v)   (((v) << 0) & BM_PINCTRL_IRQPOL2_IRQPOL)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQPOL2_IRQPOL(v)   BF_CS1(PINCTRL_IRQPOL2, IRQPOL, v)
#endif



/*
 * HW_PINCTRL_IRQPOL3 - PINCTRL Bank 3 Interrupt Polarity Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQPOL  : 31;
        unsigned RSRVD1  :  1;
    } B;
} hw_pinctrl_irqpol3_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQPOL3 register
 */
#define HW_PINCTRL_IRQPOL3_ADDR         (REGS_PINCTRL_BASE + 0x1330)
#define HW_PINCTRL_IRQPOL3_SET_ADDR     (HW_PINCTRL_IRQPOL3_ADDR + 4)
#define HW_PINCTRL_IRQPOL3_CLR_ADDR     (HW_PINCTRL_IRQPOL3_ADDR + 8)
#define HW_PINCTRL_IRQPOL3_TOG_ADDR     (HW_PINCTRL_IRQPOL3_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQPOL3           (*(volatile hw_pinctrl_irqpol3_t *) HW_PINCTRL_IRQPOL3_ADDR)
#define HW_PINCTRL_IRQPOL3_RD()      (HW_PINCTRL_IRQPOL3.U)
#define HW_PINCTRL_IRQPOL3_WR(v)     (HW_PINCTRL_IRQPOL3.U = (v))
#define HW_PINCTRL_IRQPOL3_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL3_SET_ADDR) = (v))
#define HW_PINCTRL_IRQPOL3_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL3_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQPOL3_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL3_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQPOL3 bitfields
 */
/* --- Register HW_PINCTRL_IRQPOL3, field RSRVD1 */

#define BP_PINCTRL_IRQPOL3_RSRVD1      31
#define BM_PINCTRL_IRQPOL3_RSRVD1      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQPOL3_RSRVD1(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_IRQPOL3_RSRVD1)
#else
#define BF_PINCTRL_IRQPOL3_RSRVD1(v)   (((v) << 31) & BM_PINCTRL_IRQPOL3_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQPOL3, field IRQPOL */

#define BP_PINCTRL_IRQPOL3_IRQPOL      0
#define BM_PINCTRL_IRQPOL3_IRQPOL      0x7FFFFFFF

#define BF_PINCTRL_IRQPOL3_IRQPOL(v)   (((v) << 0) & BM_PINCTRL_IRQPOL3_IRQPOL)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQPOL3_IRQPOL(v)   BF_CS1(PINCTRL_IRQPOL3, IRQPOL, v)
#endif



/*
 * HW_PINCTRL_IRQPOL4 - PINCTRL Bank 4 Interrupt Polarity Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQPOL  : 21;
        unsigned RSRVD1  : 11;
    } B;
} hw_pinctrl_irqpol4_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQPOL4 register
 */
#define HW_PINCTRL_IRQPOL4_ADDR         (REGS_PINCTRL_BASE + 0x1340)
#define HW_PINCTRL_IRQPOL4_SET_ADDR     (HW_PINCTRL_IRQPOL4_ADDR + 4)
#define HW_PINCTRL_IRQPOL4_CLR_ADDR     (HW_PINCTRL_IRQPOL4_ADDR + 8)
#define HW_PINCTRL_IRQPOL4_TOG_ADDR     (HW_PINCTRL_IRQPOL4_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQPOL4           (*(volatile hw_pinctrl_irqpol4_t *) HW_PINCTRL_IRQPOL4_ADDR)
#define HW_PINCTRL_IRQPOL4_RD()      (HW_PINCTRL_IRQPOL4.U)
#define HW_PINCTRL_IRQPOL4_WR(v)     (HW_PINCTRL_IRQPOL4.U = (v))
#define HW_PINCTRL_IRQPOL4_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL4_SET_ADDR) = (v))
#define HW_PINCTRL_IRQPOL4_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL4_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQPOL4_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQPOL4_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQPOL4 bitfields
 */
/* --- Register HW_PINCTRL_IRQPOL4, field RSRVD1 */

#define BP_PINCTRL_IRQPOL4_RSRVD1      21
#define BM_PINCTRL_IRQPOL4_RSRVD1      0xFFE00000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQPOL4_RSRVD1(v)   ((((reg32_t) v) << 21) & BM_PINCTRL_IRQPOL4_RSRVD1)
#else
#define BF_PINCTRL_IRQPOL4_RSRVD1(v)   (((v) << 21) & BM_PINCTRL_IRQPOL4_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQPOL4, field IRQPOL */

#define BP_PINCTRL_IRQPOL4_IRQPOL      0
#define BM_PINCTRL_IRQPOL4_IRQPOL      0x001FFFFF

#define BF_PINCTRL_IRQPOL4_IRQPOL(v)   (((v) << 0) & BM_PINCTRL_IRQPOL4_IRQPOL)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQPOL4_IRQPOL(v)   BF_CS1(PINCTRL_IRQPOL4, IRQPOL, v)
#endif



/*
 * HW_PINCTRL_IRQSTAT0 - PINCTRL Bank 0 Interrupt Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQSTAT  : 29;
        unsigned RSRVD1   :  3;
    } B;
} hw_pinctrl_irqstat0_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQSTAT0 register
 */
#define HW_PINCTRL_IRQSTAT0_ADDR         (REGS_PINCTRL_BASE + 0x1400)
#define HW_PINCTRL_IRQSTAT0_SET_ADDR     (HW_PINCTRL_IRQSTAT0_ADDR + 4)
#define HW_PINCTRL_IRQSTAT0_CLR_ADDR     (HW_PINCTRL_IRQSTAT0_ADDR + 8)
#define HW_PINCTRL_IRQSTAT0_TOG_ADDR     (HW_PINCTRL_IRQSTAT0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQSTAT0           (*(volatile hw_pinctrl_irqstat0_t *) HW_PINCTRL_IRQSTAT0_ADDR)
#define HW_PINCTRL_IRQSTAT0_RD()      (HW_PINCTRL_IRQSTAT0.U)
#define HW_PINCTRL_IRQSTAT0_WR(v)     (HW_PINCTRL_IRQSTAT0.U = (v))
#define HW_PINCTRL_IRQSTAT0_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT0_SET_ADDR) = (v))
#define HW_PINCTRL_IRQSTAT0_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT0_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQSTAT0_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQSTAT0 bitfields
 */
/* --- Register HW_PINCTRL_IRQSTAT0, field RSRVD1 */

#define BP_PINCTRL_IRQSTAT0_RSRVD1      29
#define BM_PINCTRL_IRQSTAT0_RSRVD1      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQSTAT0_RSRVD1(v)   ((((reg32_t) v) << 29) & BM_PINCTRL_IRQSTAT0_RSRVD1)
#else
#define BF_PINCTRL_IRQSTAT0_RSRVD1(v)   (((v) << 29) & BM_PINCTRL_IRQSTAT0_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQSTAT0, field IRQSTAT */

#define BP_PINCTRL_IRQSTAT0_IRQSTAT      0
#define BM_PINCTRL_IRQSTAT0_IRQSTAT      0x1FFFFFFF

#define BF_PINCTRL_IRQSTAT0_IRQSTAT(v)   (((v) << 0) & BM_PINCTRL_IRQSTAT0_IRQSTAT)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQSTAT0_IRQSTAT(v)   BF_CS1(PINCTRL_IRQSTAT0, IRQSTAT, v)
#endif



/*
 * HW_PINCTRL_IRQSTAT1 - PINCTRL Bank 1 Interrupt Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQSTAT  : 32;
    } B;
} hw_pinctrl_irqstat1_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQSTAT1 register
 */
#define HW_PINCTRL_IRQSTAT1_ADDR         (REGS_PINCTRL_BASE + 0x1410)
#define HW_PINCTRL_IRQSTAT1_SET_ADDR     (HW_PINCTRL_IRQSTAT1_ADDR + 4)
#define HW_PINCTRL_IRQSTAT1_CLR_ADDR     (HW_PINCTRL_IRQSTAT1_ADDR + 8)
#define HW_PINCTRL_IRQSTAT1_TOG_ADDR     (HW_PINCTRL_IRQSTAT1_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQSTAT1           (*(volatile hw_pinctrl_irqstat1_t *) HW_PINCTRL_IRQSTAT1_ADDR)
#define HW_PINCTRL_IRQSTAT1_RD()      (HW_PINCTRL_IRQSTAT1.U)
#define HW_PINCTRL_IRQSTAT1_WR(v)     (HW_PINCTRL_IRQSTAT1.U = (v))
#define HW_PINCTRL_IRQSTAT1_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT1_SET_ADDR) = (v))
#define HW_PINCTRL_IRQSTAT1_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT1_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQSTAT1_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT1_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQSTAT1 bitfields
 */
/* --- Register HW_PINCTRL_IRQSTAT1, field IRQSTAT */

#define BP_PINCTRL_IRQSTAT1_IRQSTAT      0
#define BM_PINCTRL_IRQSTAT1_IRQSTAT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQSTAT1_IRQSTAT(v)   ((reg32_t) v)
#else
#define BF_PINCTRL_IRQSTAT1_IRQSTAT(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQSTAT1_IRQSTAT(v)   (HW_PINCTRL_IRQSTAT1.B.IRQSTAT = (v))
#endif



/*
 * HW_PINCTRL_IRQSTAT2 - PINCTRL Bank 2 Interrupt Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQSTAT  : 28;
        unsigned RSRVD1   :  4;
    } B;
} hw_pinctrl_irqstat2_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQSTAT2 register
 */
#define HW_PINCTRL_IRQSTAT2_ADDR         (REGS_PINCTRL_BASE + 0x1420)
#define HW_PINCTRL_IRQSTAT2_SET_ADDR     (HW_PINCTRL_IRQSTAT2_ADDR + 4)
#define HW_PINCTRL_IRQSTAT2_CLR_ADDR     (HW_PINCTRL_IRQSTAT2_ADDR + 8)
#define HW_PINCTRL_IRQSTAT2_TOG_ADDR     (HW_PINCTRL_IRQSTAT2_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQSTAT2           (*(volatile hw_pinctrl_irqstat2_t *) HW_PINCTRL_IRQSTAT2_ADDR)
#define HW_PINCTRL_IRQSTAT2_RD()      (HW_PINCTRL_IRQSTAT2.U)
#define HW_PINCTRL_IRQSTAT2_WR(v)     (HW_PINCTRL_IRQSTAT2.U = (v))
#define HW_PINCTRL_IRQSTAT2_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT2_SET_ADDR) = (v))
#define HW_PINCTRL_IRQSTAT2_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT2_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQSTAT2_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT2_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQSTAT2 bitfields
 */
/* --- Register HW_PINCTRL_IRQSTAT2, field RSRVD1 */

#define BP_PINCTRL_IRQSTAT2_RSRVD1      28
#define BM_PINCTRL_IRQSTAT2_RSRVD1      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQSTAT2_RSRVD1(v)   ((((reg32_t) v) << 28) & BM_PINCTRL_IRQSTAT2_RSRVD1)
#else
#define BF_PINCTRL_IRQSTAT2_RSRVD1(v)   (((v) << 28) & BM_PINCTRL_IRQSTAT2_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQSTAT2, field IRQSTAT */

#define BP_PINCTRL_IRQSTAT2_IRQSTAT      0
#define BM_PINCTRL_IRQSTAT2_IRQSTAT      0x0FFFFFFF

#define BF_PINCTRL_IRQSTAT2_IRQSTAT(v)   (((v) << 0) & BM_PINCTRL_IRQSTAT2_IRQSTAT)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQSTAT2_IRQSTAT(v)   BF_CS1(PINCTRL_IRQSTAT2, IRQSTAT, v)
#endif



/*
 * HW_PINCTRL_IRQSTAT3 - PINCTRL Bank 3 Interrupt Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQSTAT  : 31;
        unsigned RSRVD1   :  1;
    } B;
} hw_pinctrl_irqstat3_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQSTAT3 register
 */
#define HW_PINCTRL_IRQSTAT3_ADDR         (REGS_PINCTRL_BASE + 0x1430)
#define HW_PINCTRL_IRQSTAT3_SET_ADDR     (HW_PINCTRL_IRQSTAT3_ADDR + 4)
#define HW_PINCTRL_IRQSTAT3_CLR_ADDR     (HW_PINCTRL_IRQSTAT3_ADDR + 8)
#define HW_PINCTRL_IRQSTAT3_TOG_ADDR     (HW_PINCTRL_IRQSTAT3_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQSTAT3           (*(volatile hw_pinctrl_irqstat3_t *) HW_PINCTRL_IRQSTAT3_ADDR)
#define HW_PINCTRL_IRQSTAT3_RD()      (HW_PINCTRL_IRQSTAT3.U)
#define HW_PINCTRL_IRQSTAT3_WR(v)     (HW_PINCTRL_IRQSTAT3.U = (v))
#define HW_PINCTRL_IRQSTAT3_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT3_SET_ADDR) = (v))
#define HW_PINCTRL_IRQSTAT3_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT3_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQSTAT3_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT3_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQSTAT3 bitfields
 */
/* --- Register HW_PINCTRL_IRQSTAT3, field RSRVD1 */

#define BP_PINCTRL_IRQSTAT3_RSRVD1      31
#define BM_PINCTRL_IRQSTAT3_RSRVD1      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQSTAT3_RSRVD1(v)   ((((reg32_t) v) << 31) & BM_PINCTRL_IRQSTAT3_RSRVD1)
#else
#define BF_PINCTRL_IRQSTAT3_RSRVD1(v)   (((v) << 31) & BM_PINCTRL_IRQSTAT3_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQSTAT3, field IRQSTAT */

#define BP_PINCTRL_IRQSTAT3_IRQSTAT      0
#define BM_PINCTRL_IRQSTAT3_IRQSTAT      0x7FFFFFFF

#define BF_PINCTRL_IRQSTAT3_IRQSTAT(v)   (((v) << 0) & BM_PINCTRL_IRQSTAT3_IRQSTAT)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQSTAT3_IRQSTAT(v)   BF_CS1(PINCTRL_IRQSTAT3, IRQSTAT, v)
#endif



/*
 * HW_PINCTRL_IRQSTAT4 - PINCTRL Bank 4 Interrupt Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQSTAT  : 21;
        unsigned RSRVD1   : 11;
    } B;
} hw_pinctrl_irqstat4_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_IRQSTAT4 register
 */
#define HW_PINCTRL_IRQSTAT4_ADDR         (REGS_PINCTRL_BASE + 0x1440)
#define HW_PINCTRL_IRQSTAT4_SET_ADDR     (HW_PINCTRL_IRQSTAT4_ADDR + 4)
#define HW_PINCTRL_IRQSTAT4_CLR_ADDR     (HW_PINCTRL_IRQSTAT4_ADDR + 8)
#define HW_PINCTRL_IRQSTAT4_TOG_ADDR     (HW_PINCTRL_IRQSTAT4_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_IRQSTAT4           (*(volatile hw_pinctrl_irqstat4_t *) HW_PINCTRL_IRQSTAT4_ADDR)
#define HW_PINCTRL_IRQSTAT4_RD()      (HW_PINCTRL_IRQSTAT4.U)
#define HW_PINCTRL_IRQSTAT4_WR(v)     (HW_PINCTRL_IRQSTAT4.U = (v))
#define HW_PINCTRL_IRQSTAT4_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT4_SET_ADDR) = (v))
#define HW_PINCTRL_IRQSTAT4_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT4_CLR_ADDR) = (v))
#define HW_PINCTRL_IRQSTAT4_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_IRQSTAT4_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_IRQSTAT4 bitfields
 */
/* --- Register HW_PINCTRL_IRQSTAT4, field RSRVD1 */

#define BP_PINCTRL_IRQSTAT4_RSRVD1      21
#define BM_PINCTRL_IRQSTAT4_RSRVD1      0xFFE00000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_IRQSTAT4_RSRVD1(v)   ((((reg32_t) v) << 21) & BM_PINCTRL_IRQSTAT4_RSRVD1)
#else
#define BF_PINCTRL_IRQSTAT4_RSRVD1(v)   (((v) << 21) & BM_PINCTRL_IRQSTAT4_RSRVD1)
#endif
/* --- Register HW_PINCTRL_IRQSTAT4, field IRQSTAT */

#define BP_PINCTRL_IRQSTAT4_IRQSTAT      0
#define BM_PINCTRL_IRQSTAT4_IRQSTAT      0x001FFFFF

#define BF_PINCTRL_IRQSTAT4_IRQSTAT(v)   (((v) << 0) & BM_PINCTRL_IRQSTAT4_IRQSTAT)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_IRQSTAT4_IRQSTAT(v)   BF_CS1(PINCTRL_IRQSTAT4, IRQSTAT, v)
#endif



/*
 * HW_PINCTRL_EMI_ODT_CTRL - PINCTRL EMI Slice ODT Control
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SLICE0_TLOAD   :  2;
        unsigned SLICE0_CALIB   :  2;
        unsigned SLICE1_TLOAD   :  2;
        unsigned SLICE1_CALIB   :  2;
        unsigned SLICE2_TLOAD   :  2;
        unsigned SLICE2_CALIB   :  2;
        unsigned SLICE3_TLOAD   :  2;
        unsigned SLICE3_CALIB   :  2;
        unsigned DUALPAD_TLOAD  :  2;
        unsigned DUALPAD_CALIB  :  2;
        unsigned CONTROL_TLOAD  :  2;
        unsigned CONTROL_CALIB  :  2;
        unsigned ADDRESS_TLOAD  :  2;
        unsigned ADDRESS_CALIB  :  2;
        unsigned RSRVD1         :  4;
    } B;
} hw_pinctrl_emi_odt_ctrl_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_EMI_ODT_CTRL register
 */
#define HW_PINCTRL_EMI_ODT_CTRL_ADDR         (REGS_PINCTRL_BASE + 0x1a40)
#define HW_PINCTRL_EMI_ODT_CTRL_SET_ADDR     (HW_PINCTRL_EMI_ODT_CTRL_ADDR + 4)
#define HW_PINCTRL_EMI_ODT_CTRL_CLR_ADDR     (HW_PINCTRL_EMI_ODT_CTRL_ADDR + 8)
#define HW_PINCTRL_EMI_ODT_CTRL_TOG_ADDR     (HW_PINCTRL_EMI_ODT_CTRL_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_EMI_ODT_CTRL           (*(volatile hw_pinctrl_emi_odt_ctrl_t *) HW_PINCTRL_EMI_ODT_CTRL_ADDR)
#define HW_PINCTRL_EMI_ODT_CTRL_RD()      (HW_PINCTRL_EMI_ODT_CTRL.U)
#define HW_PINCTRL_EMI_ODT_CTRL_WR(v)     (HW_PINCTRL_EMI_ODT_CTRL.U = (v))
#define HW_PINCTRL_EMI_ODT_CTRL_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_EMI_ODT_CTRL_SET_ADDR) = (v))
#define HW_PINCTRL_EMI_ODT_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_EMI_ODT_CTRL_CLR_ADDR) = (v))
#define HW_PINCTRL_EMI_ODT_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_EMI_ODT_CTRL_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_EMI_ODT_CTRL bitfields
 */
/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field RSRVD1 */

#define BP_PINCTRL_EMI_ODT_CTRL_RSRVD1      28
#define BM_PINCTRL_EMI_ODT_CTRL_RSRVD1      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_EMI_ODT_CTRL_RSRVD1(v)   ((((reg32_t) v) << 28) & BM_PINCTRL_EMI_ODT_CTRL_RSRVD1)
#else
#define BF_PINCTRL_EMI_ODT_CTRL_RSRVD1(v)   (((v) << 28) & BM_PINCTRL_EMI_ODT_CTRL_RSRVD1)
#endif
/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field ADDRESS_CALIB */

#define BP_PINCTRL_EMI_ODT_CTRL_ADDRESS_CALIB      26
#define BM_PINCTRL_EMI_ODT_CTRL_ADDRESS_CALIB      0x0C000000

#define BF_PINCTRL_EMI_ODT_CTRL_ADDRESS_CALIB(v)   (((v) << 26) & BM_PINCTRL_EMI_ODT_CTRL_ADDRESS_CALIB)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_ODT_CTRL_ADDRESS_CALIB(v)   BF_CS1(PINCTRL_EMI_ODT_CTRL, ADDRESS_CALIB, v)
#endif

/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field ADDRESS_TLOAD */

#define BP_PINCTRL_EMI_ODT_CTRL_ADDRESS_TLOAD      24
#define BM_PINCTRL_EMI_ODT_CTRL_ADDRESS_TLOAD      0x03000000

#define BF_PINCTRL_EMI_ODT_CTRL_ADDRESS_TLOAD(v)   (((v) << 24) & BM_PINCTRL_EMI_ODT_CTRL_ADDRESS_TLOAD)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_ODT_CTRL_ADDRESS_TLOAD(v)   BF_CS1(PINCTRL_EMI_ODT_CTRL, ADDRESS_TLOAD, v)
#endif

/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field CONTROL_CALIB */

#define BP_PINCTRL_EMI_ODT_CTRL_CONTROL_CALIB      22
#define BM_PINCTRL_EMI_ODT_CTRL_CONTROL_CALIB      0x00C00000

#define BF_PINCTRL_EMI_ODT_CTRL_CONTROL_CALIB(v)   (((v) << 22) & BM_PINCTRL_EMI_ODT_CTRL_CONTROL_CALIB)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_ODT_CTRL_CONTROL_CALIB(v)   BF_CS1(PINCTRL_EMI_ODT_CTRL, CONTROL_CALIB, v)
#endif

/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field CONTROL_TLOAD */

#define BP_PINCTRL_EMI_ODT_CTRL_CONTROL_TLOAD      20
#define BM_PINCTRL_EMI_ODT_CTRL_CONTROL_TLOAD      0x00300000

#define BF_PINCTRL_EMI_ODT_CTRL_CONTROL_TLOAD(v)   (((v) << 20) & BM_PINCTRL_EMI_ODT_CTRL_CONTROL_TLOAD)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_ODT_CTRL_CONTROL_TLOAD(v)   BF_CS1(PINCTRL_EMI_ODT_CTRL, CONTROL_TLOAD, v)
#endif

/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field DUALPAD_CALIB */

#define BP_PINCTRL_EMI_ODT_CTRL_DUALPAD_CALIB      18
#define BM_PINCTRL_EMI_ODT_CTRL_DUALPAD_CALIB      0x000C0000

#define BF_PINCTRL_EMI_ODT_CTRL_DUALPAD_CALIB(v)   (((v) << 18) & BM_PINCTRL_EMI_ODT_CTRL_DUALPAD_CALIB)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_ODT_CTRL_DUALPAD_CALIB(v)   BF_CS1(PINCTRL_EMI_ODT_CTRL, DUALPAD_CALIB, v)
#endif

/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field DUALPAD_TLOAD */

#define BP_PINCTRL_EMI_ODT_CTRL_DUALPAD_TLOAD      16
#define BM_PINCTRL_EMI_ODT_CTRL_DUALPAD_TLOAD      0x00030000

#define BF_PINCTRL_EMI_ODT_CTRL_DUALPAD_TLOAD(v)   (((v) << 16) & BM_PINCTRL_EMI_ODT_CTRL_DUALPAD_TLOAD)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_ODT_CTRL_DUALPAD_TLOAD(v)   BF_CS1(PINCTRL_EMI_ODT_CTRL, DUALPAD_TLOAD, v)
#endif

/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field SLICE3_CALIB */

#define BP_PINCTRL_EMI_ODT_CTRL_SLICE3_CALIB      14
#define BM_PINCTRL_EMI_ODT_CTRL_SLICE3_CALIB      0x0000C000

#define BF_PINCTRL_EMI_ODT_CTRL_SLICE3_CALIB(v)   (((v) << 14) & BM_PINCTRL_EMI_ODT_CTRL_SLICE3_CALIB)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_ODT_CTRL_SLICE3_CALIB(v)   BF_CS1(PINCTRL_EMI_ODT_CTRL, SLICE3_CALIB, v)
#endif

/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field SLICE3_TLOAD */

#define BP_PINCTRL_EMI_ODT_CTRL_SLICE3_TLOAD      12
#define BM_PINCTRL_EMI_ODT_CTRL_SLICE3_TLOAD      0x00003000

#define BF_PINCTRL_EMI_ODT_CTRL_SLICE3_TLOAD(v)   (((v) << 12) & BM_PINCTRL_EMI_ODT_CTRL_SLICE3_TLOAD)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_ODT_CTRL_SLICE3_TLOAD(v)   BF_CS1(PINCTRL_EMI_ODT_CTRL, SLICE3_TLOAD, v)
#endif

/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field SLICE2_CALIB */

#define BP_PINCTRL_EMI_ODT_CTRL_SLICE2_CALIB      10
#define BM_PINCTRL_EMI_ODT_CTRL_SLICE2_CALIB      0x00000C00

#define BF_PINCTRL_EMI_ODT_CTRL_SLICE2_CALIB(v)   (((v) << 10) & BM_PINCTRL_EMI_ODT_CTRL_SLICE2_CALIB)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_ODT_CTRL_SLICE2_CALIB(v)   BF_CS1(PINCTRL_EMI_ODT_CTRL, SLICE2_CALIB, v)
#endif

/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field SLICE2_TLOAD */

#define BP_PINCTRL_EMI_ODT_CTRL_SLICE2_TLOAD      8
#define BM_PINCTRL_EMI_ODT_CTRL_SLICE2_TLOAD      0x00000300

#define BF_PINCTRL_EMI_ODT_CTRL_SLICE2_TLOAD(v)   (((v) << 8) & BM_PINCTRL_EMI_ODT_CTRL_SLICE2_TLOAD)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_ODT_CTRL_SLICE2_TLOAD(v)   BF_CS1(PINCTRL_EMI_ODT_CTRL, SLICE2_TLOAD, v)
#endif

/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field SLICE1_CALIB */

#define BP_PINCTRL_EMI_ODT_CTRL_SLICE1_CALIB      6
#define BM_PINCTRL_EMI_ODT_CTRL_SLICE1_CALIB      0x000000C0

#define BF_PINCTRL_EMI_ODT_CTRL_SLICE1_CALIB(v)   (((v) << 6) & BM_PINCTRL_EMI_ODT_CTRL_SLICE1_CALIB)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_ODT_CTRL_SLICE1_CALIB(v)   BF_CS1(PINCTRL_EMI_ODT_CTRL, SLICE1_CALIB, v)
#endif

/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field SLICE1_TLOAD */

#define BP_PINCTRL_EMI_ODT_CTRL_SLICE1_TLOAD      4
#define BM_PINCTRL_EMI_ODT_CTRL_SLICE1_TLOAD      0x00000030

#define BF_PINCTRL_EMI_ODT_CTRL_SLICE1_TLOAD(v)   (((v) << 4) & BM_PINCTRL_EMI_ODT_CTRL_SLICE1_TLOAD)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_ODT_CTRL_SLICE1_TLOAD(v)   BF_CS1(PINCTRL_EMI_ODT_CTRL, SLICE1_TLOAD, v)
#endif

/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field SLICE0_CALIB */

#define BP_PINCTRL_EMI_ODT_CTRL_SLICE0_CALIB      2
#define BM_PINCTRL_EMI_ODT_CTRL_SLICE0_CALIB      0x0000000C

#define BF_PINCTRL_EMI_ODT_CTRL_SLICE0_CALIB(v)   (((v) << 2) & BM_PINCTRL_EMI_ODT_CTRL_SLICE0_CALIB)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_ODT_CTRL_SLICE0_CALIB(v)   BF_CS1(PINCTRL_EMI_ODT_CTRL, SLICE0_CALIB, v)
#endif

/* --- Register HW_PINCTRL_EMI_ODT_CTRL, field SLICE0_TLOAD */

#define BP_PINCTRL_EMI_ODT_CTRL_SLICE0_TLOAD      0
#define BM_PINCTRL_EMI_ODT_CTRL_SLICE0_TLOAD      0x00000003

#define BF_PINCTRL_EMI_ODT_CTRL_SLICE0_TLOAD(v)   (((v) << 0) & BM_PINCTRL_EMI_ODT_CTRL_SLICE0_TLOAD)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_ODT_CTRL_SLICE0_TLOAD(v)   BF_CS1(PINCTRL_EMI_ODT_CTRL, SLICE0_TLOAD, v)
#endif



/*
 * HW_PINCTRL_EMI_DS_CTRL - PINCTRL EMI Slice DS Control
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SLICE0_MA   :  2;
        unsigned SLICE1_MA   :  2;
        unsigned SLICE2_MA   :  2;
        unsigned SLICE3_MA   :  2;
        unsigned DUALPAD_MA  :  2;
        unsigned CONTROL_MA  :  2;
        unsigned ADDRESS_MA  :  2;
        unsigned RSRVD0      :  2;
        unsigned DDR_MODE    :  2;
        unsigned RSRVD1      : 14;
    } B;
} hw_pinctrl_emi_ds_ctrl_t;
#endif

/*
 * constants & macros for entire HW_PINCTRL_EMI_DS_CTRL register
 */
#define HW_PINCTRL_EMI_DS_CTRL_ADDR         (REGS_PINCTRL_BASE + 0x1b80)
#define HW_PINCTRL_EMI_DS_CTRL_SET_ADDR     (HW_PINCTRL_EMI_DS_CTRL_ADDR + 4)
#define HW_PINCTRL_EMI_DS_CTRL_CLR_ADDR     (HW_PINCTRL_EMI_DS_CTRL_ADDR + 8)
#define HW_PINCTRL_EMI_DS_CTRL_TOG_ADDR     (HW_PINCTRL_EMI_DS_CTRL_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_PINCTRL_EMI_DS_CTRL           (*(volatile hw_pinctrl_emi_ds_ctrl_t *) HW_PINCTRL_EMI_DS_CTRL_ADDR)
#define HW_PINCTRL_EMI_DS_CTRL_RD()      (HW_PINCTRL_EMI_DS_CTRL.U)
#define HW_PINCTRL_EMI_DS_CTRL_WR(v)     (HW_PINCTRL_EMI_DS_CTRL.U = (v))
#define HW_PINCTRL_EMI_DS_CTRL_SET(v)    ((*(volatile reg32_t *) HW_PINCTRL_EMI_DS_CTRL_SET_ADDR) = (v))
#define HW_PINCTRL_EMI_DS_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_PINCTRL_EMI_DS_CTRL_CLR_ADDR) = (v))
#define HW_PINCTRL_EMI_DS_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_PINCTRL_EMI_DS_CTRL_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_PINCTRL_EMI_DS_CTRL bitfields
 */
/* --- Register HW_PINCTRL_EMI_DS_CTRL, field RSRVD1 */

#define BP_PINCTRL_EMI_DS_CTRL_RSRVD1      18
#define BM_PINCTRL_EMI_DS_CTRL_RSRVD1      0xFFFC0000

#ifndef __LANGUAGE_ASM__
#define BF_PINCTRL_EMI_DS_CTRL_RSRVD1(v)   ((((reg32_t) v) << 18) & BM_PINCTRL_EMI_DS_CTRL_RSRVD1)
#else
#define BF_PINCTRL_EMI_DS_CTRL_RSRVD1(v)   (((v) << 18) & BM_PINCTRL_EMI_DS_CTRL_RSRVD1)
#endif
/* --- Register HW_PINCTRL_EMI_DS_CTRL, field DDR_MODE */

#define BP_PINCTRL_EMI_DS_CTRL_DDR_MODE      16
#define BM_PINCTRL_EMI_DS_CTRL_DDR_MODE      0x00030000

#define BF_PINCTRL_EMI_DS_CTRL_DDR_MODE(v)   (((v) << 16) & BM_PINCTRL_EMI_DS_CTRL_DDR_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_DS_CTRL_DDR_MODE(v)   BF_CS1(PINCTRL_EMI_DS_CTRL, DDR_MODE, v)
#endif

#define BV_PINCTRL_EMI_DS_CTRL_DDR_MODE__mDDR    00
#define BV_PINCTRL_EMI_DS_CTRL_DDR_MODE__GPIO    01
#define BV_PINCTRL_EMI_DS_CTRL_DDR_MODE__LVDDR2  10
#define BV_PINCTRL_EMI_DS_CTRL_DDR_MODE__DDR2    11

/* --- Register HW_PINCTRL_EMI_DS_CTRL, field RSRVD0 */

#define BP_PINCTRL_EMI_DS_CTRL_RSRVD0      14
#define BM_PINCTRL_EMI_DS_CTRL_RSRVD0      0x0000C000

#define BF_PINCTRL_EMI_DS_CTRL_RSRVD0(v)   (((v) << 14) & BM_PINCTRL_EMI_DS_CTRL_RSRVD0)
/* --- Register HW_PINCTRL_EMI_DS_CTRL, field ADDRESS_MA */

#define BP_PINCTRL_EMI_DS_CTRL_ADDRESS_MA      12
#define BM_PINCTRL_EMI_DS_CTRL_ADDRESS_MA      0x00003000

#define BF_PINCTRL_EMI_DS_CTRL_ADDRESS_MA(v)   (((v) << 12) & BM_PINCTRL_EMI_DS_CTRL_ADDRESS_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_DS_CTRL_ADDRESS_MA(v)   BF_CS1(PINCTRL_EMI_DS_CTRL, ADDRESS_MA, v)
#endif

/* --- Register HW_PINCTRL_EMI_DS_CTRL, field CONTROL_MA */

#define BP_PINCTRL_EMI_DS_CTRL_CONTROL_MA      10
#define BM_PINCTRL_EMI_DS_CTRL_CONTROL_MA      0x00000C00

#define BF_PINCTRL_EMI_DS_CTRL_CONTROL_MA(v)   (((v) << 10) & BM_PINCTRL_EMI_DS_CTRL_CONTROL_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_DS_CTRL_CONTROL_MA(v)   BF_CS1(PINCTRL_EMI_DS_CTRL, CONTROL_MA, v)
#endif

/* --- Register HW_PINCTRL_EMI_DS_CTRL, field DUALPAD_MA */

#define BP_PINCTRL_EMI_DS_CTRL_DUALPAD_MA      8
#define BM_PINCTRL_EMI_DS_CTRL_DUALPAD_MA      0x00000300

#define BF_PINCTRL_EMI_DS_CTRL_DUALPAD_MA(v)   (((v) << 8) & BM_PINCTRL_EMI_DS_CTRL_DUALPAD_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_DS_CTRL_DUALPAD_MA(v)   BF_CS1(PINCTRL_EMI_DS_CTRL, DUALPAD_MA, v)
#endif

/* --- Register HW_PINCTRL_EMI_DS_CTRL, field SLICE3_MA */

#define BP_PINCTRL_EMI_DS_CTRL_SLICE3_MA      6
#define BM_PINCTRL_EMI_DS_CTRL_SLICE3_MA      0x000000C0

#define BF_PINCTRL_EMI_DS_CTRL_SLICE3_MA(v)   (((v) << 6) & BM_PINCTRL_EMI_DS_CTRL_SLICE3_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_DS_CTRL_SLICE3_MA(v)   BF_CS1(PINCTRL_EMI_DS_CTRL, SLICE3_MA, v)
#endif

/* --- Register HW_PINCTRL_EMI_DS_CTRL, field SLICE2_MA */

#define BP_PINCTRL_EMI_DS_CTRL_SLICE2_MA      4
#define BM_PINCTRL_EMI_DS_CTRL_SLICE2_MA      0x00000030

#define BF_PINCTRL_EMI_DS_CTRL_SLICE2_MA(v)   (((v) << 4) & BM_PINCTRL_EMI_DS_CTRL_SLICE2_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_DS_CTRL_SLICE2_MA(v)   BF_CS1(PINCTRL_EMI_DS_CTRL, SLICE2_MA, v)
#endif

/* --- Register HW_PINCTRL_EMI_DS_CTRL, field SLICE1_MA */

#define BP_PINCTRL_EMI_DS_CTRL_SLICE1_MA      2
#define BM_PINCTRL_EMI_DS_CTRL_SLICE1_MA      0x0000000C

#define BF_PINCTRL_EMI_DS_CTRL_SLICE1_MA(v)   (((v) << 2) & BM_PINCTRL_EMI_DS_CTRL_SLICE1_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_DS_CTRL_SLICE1_MA(v)   BF_CS1(PINCTRL_EMI_DS_CTRL, SLICE1_MA, v)
#endif

/* --- Register HW_PINCTRL_EMI_DS_CTRL, field SLICE0_MA */

#define BP_PINCTRL_EMI_DS_CTRL_SLICE0_MA      0
#define BM_PINCTRL_EMI_DS_CTRL_SLICE0_MA      0x00000003

#define BF_PINCTRL_EMI_DS_CTRL_SLICE0_MA(v)   (((v) << 0) & BM_PINCTRL_EMI_DS_CTRL_SLICE0_MA)
#ifndef __LANGUAGE_ASM__
#define BW_PINCTRL_EMI_DS_CTRL_SLICE0_MA(v)   BF_CS1(PINCTRL_EMI_DS_CTRL, SLICE0_MA, v)
#endif


#endif /* _PINCTRL_H */

////////////////////////////////////////////////////////////////////////////////
