/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSSYDMA_H
#define _REGSSYDMA_H  1

#include "regs.h"

#ifndef REGS_SYDMA_BASE
#define REGS_SYDMA_BASE (REGS_BASE + 0x00026000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_SYDMA_CTRL - SY DMA CONTROL Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RUN              :  1;
        unsigned COMPLETE_IRQ     :  1;
        unsigned ERROR_IRQ        :  1;
        unsigned RSVD0            :  6;
        unsigned COMPLETE_IRQ_EN  :  1;
        unsigned RSVD1            : 20;
        unsigned CLKGATE          :  1;
        unsigned SFTRST           :  1;
    } B;
} hw_sydma_ctrl_t;
#endif


//
// constants & macros for entire HW_SYDMA_CTRL register
//

#define HW_SYDMA_CTRL_ADDR      (REGS_SYDMA_BASE + 0x00000000)
#define HW_SYDMA_CTRL_SET_ADDR  (REGS_SYDMA_BASE + 0x00000004)
#define HW_SYDMA_CTRL_CLR_ADDR  (REGS_SYDMA_BASE + 0x00000008)
#define HW_SYDMA_CTRL_TOG_ADDR  (REGS_SYDMA_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_SYDMA_CTRL           (*(volatile hw_sydma_ctrl_t *) HW_SYDMA_CTRL_ADDR)
#define HW_SYDMA_CTRL_RD()      (HW_SYDMA_CTRL.U)
#define HW_SYDMA_CTRL_WR(v)     (HW_SYDMA_CTRL.U = (v))
#define HW_SYDMA_CTRL_SET(v)    ((*(volatile reg32_t *) HW_SYDMA_CTRL_SET_ADDR) = (v))
#define HW_SYDMA_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_SYDMA_CTRL_CLR_ADDR) = (v))
#define HW_SYDMA_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_SYDMA_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_SYDMA_CTRL bitfields
//

//--- Register HW_SYDMA_CTRL, field SFTRST

#define BP_SYDMA_CTRL_SFTRST      31
#define BM_SYDMA_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_SYDMA_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_SYDMA_CTRL_SFTRST)
#else
#define BF_SYDMA_CTRL_SFTRST(v)   (((v) << 31) & BM_SYDMA_CTRL_SFTRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SYDMA_CTRL_SFTRST(v)   BF_CS1(SYDMA_CTRL, SFTRST, v)
#endif

#define BV_SYDMA_CTRL_SFTRST__RUN    0x0
#define BV_SYDMA_CTRL_SFTRST__RESET  0x1

//--- Register HW_SYDMA_CTRL, field CLKGATE

#define BP_SYDMA_CTRL_CLKGATE      30
#define BM_SYDMA_CTRL_CLKGATE      0x40000000

#define BF_SYDMA_CTRL_CLKGATE(v)   (((v) << 30) & BM_SYDMA_CTRL_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_SYDMA_CTRL_CLKGATE(v)   BF_CS1(SYDMA_CTRL, CLKGATE, v)
#endif

#define BV_SYDMA_CTRL_CLKGATE__RUN      0x0
#define BV_SYDMA_CTRL_CLKGATE__NO_CLKS  0x1

//--- Register HW_SYDMA_CTRL, field COMPLETE_IRQ_EN

#define BP_SYDMA_CTRL_COMPLETE_IRQ_EN      9
#define BM_SYDMA_CTRL_COMPLETE_IRQ_EN      0x00000200

#define BF_SYDMA_CTRL_COMPLETE_IRQ_EN(v)   (((v) << 9) & BM_SYDMA_CTRL_COMPLETE_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_SYDMA_CTRL_COMPLETE_IRQ_EN(v)   BF_CS1(SYDMA_CTRL, COMPLETE_IRQ_EN, v)
#endif

#define BV_SYDMA_CTRL_COMPLETE_IRQ_EN__DISABLED  0x0
#define BV_SYDMA_CTRL_COMPLETE_IRQ_EN__ENABLED   0x1

//--- Register HW_SYDMA_CTRL, field ERROR_IRQ

#define BP_SYDMA_CTRL_ERROR_IRQ      2
#define BM_SYDMA_CTRL_ERROR_IRQ      0x00000004

#define BF_SYDMA_CTRL_ERROR_IRQ(v)   (((v) << 2) & BM_SYDMA_CTRL_ERROR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_SYDMA_CTRL_ERROR_IRQ(v)   BF_CS1(SYDMA_CTRL, ERROR_IRQ, v)
#endif

//--- Register HW_SYDMA_CTRL, field COMPLETE_IRQ

#define BP_SYDMA_CTRL_COMPLETE_IRQ      1
#define BM_SYDMA_CTRL_COMPLETE_IRQ      0x00000002

#define BF_SYDMA_CTRL_COMPLETE_IRQ(v)   (((v) << 1) & BM_SYDMA_CTRL_COMPLETE_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_SYDMA_CTRL_COMPLETE_IRQ(v)   BF_CS1(SYDMA_CTRL, COMPLETE_IRQ, v)
#endif

//--- Register HW_SYDMA_CTRL, field RUN

#define BP_SYDMA_CTRL_RUN      0
#define BM_SYDMA_CTRL_RUN      0x00000001

#define BF_SYDMA_CTRL_RUN(v)   (((v) << 0) & BM_SYDMA_CTRL_RUN)

#ifndef __LANGUAGE_ASM__
#define BW_SYDMA_CTRL_RUN(v)   BF_CS1(SYDMA_CTRL, RUN, v)
#endif

#define BV_SYDMA_CTRL_RUN__HALT  0x0
#define BV_SYDMA_CTRL_RUN__RUN   0x1


////////////////////////////////////////////////////////////////////////////////
//// HW_SYDMA_RADDR - SY DMA Read Source Address
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  RSRC_ADDR;
    } B;
} hw_sydma_raddr_t;
#endif


//
// constants & macros for entire HW_SYDMA_RADDR register
//

#define HW_SYDMA_RADDR_ADDR      (REGS_SYDMA_BASE + 0x00000010)

#ifndef __LANGUAGE_ASM__
#define HW_SYDMA_RADDR           (*(volatile hw_sydma_raddr_t *) HW_SYDMA_RADDR_ADDR)
#define HW_SYDMA_RADDR_RD()      (HW_SYDMA_RADDR.U)
#define HW_SYDMA_RADDR_WR(v)     (HW_SYDMA_RADDR.U = (v))
#define HW_SYDMA_RADDR_SET(v)    (HW_SYDMA_RADDR_WR(HW_SYDMA_RADDR_RD() |  (v)))
#define HW_SYDMA_RADDR_CLR(v)    (HW_SYDMA_RADDR_WR(HW_SYDMA_RADDR_RD() & ~(v)))
#define HW_SYDMA_RADDR_TOG(v)    (HW_SYDMA_RADDR_WR(HW_SYDMA_RADDR_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SYDMA_RADDR bitfields
//

//--- Register HW_SYDMA_RADDR, field RSRC_ADDR

#define BP_SYDMA_RADDR_RSRC_ADDR      0
#define BM_SYDMA_RADDR_RSRC_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SYDMA_RADDR_RSRC_ADDR(v)   ((reg32_t) v)
#else
#define BF_SYDMA_RADDR_RSRC_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SYDMA_RADDR_RSRC_ADDR(v)   (HW_SYDMA_RADDR.B.RSRC_ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SYDMA_WADDR - SY DMA Write Source Address
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  WSRC_ADDR;
    } B;
} hw_sydma_waddr_t;
#endif


//
// constants & macros for entire HW_SYDMA_WADDR register
//

#define HW_SYDMA_WADDR_ADDR      (REGS_SYDMA_BASE + 0x00000020)

#ifndef __LANGUAGE_ASM__
#define HW_SYDMA_WADDR           (*(volatile hw_sydma_waddr_t *) HW_SYDMA_WADDR_ADDR)
#define HW_SYDMA_WADDR_RD()      (HW_SYDMA_WADDR.U)
#define HW_SYDMA_WADDR_WR(v)     (HW_SYDMA_WADDR.U = (v))
#define HW_SYDMA_WADDR_SET(v)    (HW_SYDMA_WADDR_WR(HW_SYDMA_WADDR_RD() |  (v)))
#define HW_SYDMA_WADDR_CLR(v)    (HW_SYDMA_WADDR_WR(HW_SYDMA_WADDR_RD() & ~(v)))
#define HW_SYDMA_WADDR_TOG(v)    (HW_SYDMA_WADDR_WR(HW_SYDMA_WADDR_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SYDMA_WADDR bitfields
//

//--- Register HW_SYDMA_WADDR, field WSRC_ADDR

#define BP_SYDMA_WADDR_WSRC_ADDR      0
#define BM_SYDMA_WADDR_WSRC_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SYDMA_WADDR_WSRC_ADDR(v)   ((reg32_t) v)
#else
#define BF_SYDMA_WADDR_WSRC_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SYDMA_WADDR_WSRC_ADDR(v)   (HW_SYDMA_WADDR.B.WSRC_ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SYDMA_XFER_COUNT - SY DMA TRANSFER COUNT
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  SIZE;
    } B;
} hw_sydma_xfer_count_t;
#endif


//
// constants & macros for entire HW_SYDMA_XFER_COUNT register
//

#define HW_SYDMA_XFER_COUNT_ADDR      (REGS_SYDMA_BASE + 0x00000030)

#ifndef __LANGUAGE_ASM__
#define HW_SYDMA_XFER_COUNT           (*(volatile hw_sydma_xfer_count_t *) HW_SYDMA_XFER_COUNT_ADDR)
#define HW_SYDMA_XFER_COUNT_RD()      (HW_SYDMA_XFER_COUNT.U)
#define HW_SYDMA_XFER_COUNT_WR(v)     (HW_SYDMA_XFER_COUNT.U = (v))
#define HW_SYDMA_XFER_COUNT_SET(v)    (HW_SYDMA_XFER_COUNT_WR(HW_SYDMA_XFER_COUNT_RD() |  (v)))
#define HW_SYDMA_XFER_COUNT_CLR(v)    (HW_SYDMA_XFER_COUNT_WR(HW_SYDMA_XFER_COUNT_RD() & ~(v)))
#define HW_SYDMA_XFER_COUNT_TOG(v)    (HW_SYDMA_XFER_COUNT_WR(HW_SYDMA_XFER_COUNT_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SYDMA_XFER_COUNT bitfields
//

//--- Register HW_SYDMA_XFER_COUNT, field SIZE

#define BP_SYDMA_XFER_COUNT_SIZE      0
#define BM_SYDMA_XFER_COUNT_SIZE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SYDMA_XFER_COUNT_SIZE(v)   ((reg32_t) v)
#else
#define BF_SYDMA_XFER_COUNT_SIZE(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SYDMA_XFER_COUNT_SIZE(v)   (HW_SYDMA_XFER_COUNT.B.SIZE = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SYDMA_BURST - SY DMA BURST SIZE
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RLEN   :  2;
        unsigned WLEN   :  2;
        unsigned RSVD0  : 28;
    } B;
} hw_sydma_burst_t;
#endif


//
// constants & macros for entire HW_SYDMA_BURST register
//

#define HW_SYDMA_BURST_ADDR      (REGS_SYDMA_BASE + 0x00000040)

#ifndef __LANGUAGE_ASM__
#define HW_SYDMA_BURST           (*(volatile hw_sydma_burst_t *) HW_SYDMA_BURST_ADDR)
#define HW_SYDMA_BURST_RD()      (HW_SYDMA_BURST.U)
#define HW_SYDMA_BURST_WR(v)     (HW_SYDMA_BURST.U = (v))
#define HW_SYDMA_BURST_SET(v)    (HW_SYDMA_BURST_WR(HW_SYDMA_BURST_RD() |  (v)))
#define HW_SYDMA_BURST_CLR(v)    (HW_SYDMA_BURST_WR(HW_SYDMA_BURST_RD() & ~(v)))
#define HW_SYDMA_BURST_TOG(v)    (HW_SYDMA_BURST_WR(HW_SYDMA_BURST_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SYDMA_BURST bitfields
//

//--- Register HW_SYDMA_BURST, field WLEN

#define BP_SYDMA_BURST_WLEN      2
#define BM_SYDMA_BURST_WLEN      0x0000000C

#define BF_SYDMA_BURST_WLEN(v)   (((v) << 2) & BM_SYDMA_BURST_WLEN)

#ifndef __LANGUAGE_ASM__
#define BW_SYDMA_BURST_WLEN(v)   BF_CS1(SYDMA_BURST, WLEN, v)
#endif

#define BV_SYDMA_BURST_WLEN__1  0x0
#define BV_SYDMA_BURST_WLEN__2  0x1
#define BV_SYDMA_BURST_WLEN__4  0x2
#define BV_SYDMA_BURST_WLEN__8  0x3

//--- Register HW_SYDMA_BURST, field RLEN

#define BP_SYDMA_BURST_RLEN      0
#define BM_SYDMA_BURST_RLEN      0x00000003

#define BF_SYDMA_BURST_RLEN(v)   (((v) << 0) & BM_SYDMA_BURST_RLEN)

#ifndef __LANGUAGE_ASM__
#define BW_SYDMA_BURST_RLEN(v)   BF_CS1(SYDMA_BURST, RLEN, v)
#endif

#define BV_SYDMA_BURST_RLEN__1  0x0
#define BV_SYDMA_BURST_RLEN__2  0x1
#define BV_SYDMA_BURST_RLEN__4  0x2
#define BV_SYDMA_BURST_RLEN__8  0x3


////////////////////////////////////////////////////////////////////////////////
//// HW_SYDMA_DACK - SY DMA ACK DELAY REGISTER
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RDELAY  :  4;
        unsigned WDELAY  :  4;
        unsigned RSVD0   : 24;
    } B;
} hw_sydma_dack_t;
#endif


//
// constants & macros for entire HW_SYDMA_DACK register
//

#define HW_SYDMA_DACK_ADDR      (REGS_SYDMA_BASE + 0x00000050)

#ifndef __LANGUAGE_ASM__
#define HW_SYDMA_DACK           (*(volatile hw_sydma_dack_t *) HW_SYDMA_DACK_ADDR)
#define HW_SYDMA_DACK_RD()      (HW_SYDMA_DACK.U)
#define HW_SYDMA_DACK_WR(v)     (HW_SYDMA_DACK.U = (v))
#define HW_SYDMA_DACK_SET(v)    (HW_SYDMA_DACK_WR(HW_SYDMA_DACK_RD() |  (v)))
#define HW_SYDMA_DACK_CLR(v)    (HW_SYDMA_DACK_WR(HW_SYDMA_DACK_RD() & ~(v)))
#define HW_SYDMA_DACK_TOG(v)    (HW_SYDMA_DACK_WR(HW_SYDMA_DACK_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SYDMA_DACK bitfields
//

//--- Register HW_SYDMA_DACK, field WDELAY

#define BP_SYDMA_DACK_WDELAY      4
#define BM_SYDMA_DACK_WDELAY      0x000000F0

#define BF_SYDMA_DACK_WDELAY(v)   (((v) << 4) & BM_SYDMA_DACK_WDELAY)

#ifndef __LANGUAGE_ASM__
#define BW_SYDMA_DACK_WDELAY(v)   BF_CS1(SYDMA_DACK, WDELAY, v)
#endif

//--- Register HW_SYDMA_DACK, field RDELAY

#define BP_SYDMA_DACK_RDELAY      0
#define BM_SYDMA_DACK_RDELAY      0x0000000F

#define BF_SYDMA_DACK_RDELAY(v)   (((v) << 0) & BM_SYDMA_DACK_RDELAY)

#ifndef __LANGUAGE_ASM__
#define BW_SYDMA_DACK_RDELAY(v)   BF_CS1(SYDMA_DACK, RDELAY, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SYDMA_DEBUG0 - SY DMA DEBUG0 REGISTER
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sydma_debug0_t;
#endif


//
// constants & macros for entire HW_SYDMA_DEBUG0 register
//

#define HW_SYDMA_DEBUG0_ADDR      (REGS_SYDMA_BASE + 0x00000100)

#ifndef __LANGUAGE_ASM__
#define HW_SYDMA_DEBUG0           (*(volatile hw_sydma_debug0_t *) HW_SYDMA_DEBUG0_ADDR)
#define HW_SYDMA_DEBUG0_RD()      (HW_SYDMA_DEBUG0.U)
#endif


//
// constants & macros for individual HW_SYDMA_DEBUG0 bitfields
//

//--- Register HW_SYDMA_DEBUG0, field DATA

#define BP_SYDMA_DEBUG0_DATA      0
#define BM_SYDMA_DEBUG0_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SYDMA_DEBUG0_DATA(v)   ((reg32_t) v)
#else
#define BF_SYDMA_DEBUG0_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SYDMA_DEBUG1 - SY DMA DEBUG1 REGISTER
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sydma_debug1_t;
#endif


//
// constants & macros for entire HW_SYDMA_DEBUG1 register
//

#define HW_SYDMA_DEBUG1_ADDR      (REGS_SYDMA_BASE + 0x00000110)

#ifndef __LANGUAGE_ASM__
#define HW_SYDMA_DEBUG1           (*(volatile hw_sydma_debug1_t *) HW_SYDMA_DEBUG1_ADDR)
#define HW_SYDMA_DEBUG1_RD()      (HW_SYDMA_DEBUG1.U)
#endif


//
// constants & macros for individual HW_SYDMA_DEBUG1 bitfields
//

//--- Register HW_SYDMA_DEBUG1, field DATA

#define BP_SYDMA_DEBUG1_DATA      0
#define BM_SYDMA_DEBUG1_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SYDMA_DEBUG1_DATA(v)   ((reg32_t) v)
#else
#define BF_SYDMA_DEBUG1_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SYDMA_DEBUG2 - SY DMA DEBUG1 REGISTER
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_sydma_debug2_t;
#endif


//
// constants & macros for entire HW_SYDMA_DEBUG2 register
//

#define HW_SYDMA_DEBUG2_ADDR      (REGS_SYDMA_BASE + 0x00000120)

#ifndef __LANGUAGE_ASM__
#define HW_SYDMA_DEBUG2           (*(volatile hw_sydma_debug2_t *) HW_SYDMA_DEBUG2_ADDR)
#define HW_SYDMA_DEBUG2_RD()      (HW_SYDMA_DEBUG2.U)
#endif


//
// constants & macros for individual HW_SYDMA_DEBUG2 bitfields
//

//--- Register HW_SYDMA_DEBUG2, field DATA

#define BP_SYDMA_DEBUG2_DATA      0
#define BM_SYDMA_DEBUG2_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SYDMA_DEBUG2_DATA(v)   ((reg32_t) v)
#else
#define BF_SYDMA_DEBUG2_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SYDMA_VERSION - SY DMA VERSION REGISTER
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  STEP;
        reg8_t   MINOR;
        reg8_t   MAJOR;
    } B;
} hw_sydma_version_t;
#endif


//
// constants & macros for entire HW_SYDMA_VERSION register
//

#define HW_SYDMA_VERSION_ADDR      (REGS_SYDMA_BASE + 0x00000130)

#ifndef __LANGUAGE_ASM__
#define HW_SYDMA_VERSION           (*(volatile hw_sydma_version_t *) HW_SYDMA_VERSION_ADDR)
#define HW_SYDMA_VERSION_RD()      (HW_SYDMA_VERSION.U)
#endif


//
// constants & macros for individual HW_SYDMA_VERSION bitfields
//

//--- Register HW_SYDMA_VERSION, field MAJOR

#define BP_SYDMA_VERSION_MAJOR      24
#define BM_SYDMA_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_SYDMA_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_SYDMA_VERSION_MAJOR)
#else
#define BF_SYDMA_VERSION_MAJOR(v)   (((v) << 24) & BM_SYDMA_VERSION_MAJOR)
#endif

//--- Register HW_SYDMA_VERSION, field MINOR

#define BP_SYDMA_VERSION_MINOR      16
#define BM_SYDMA_VERSION_MINOR      0x00FF0000

#define BF_SYDMA_VERSION_MINOR(v)   (((v) << 16) & BM_SYDMA_VERSION_MINOR)

//--- Register HW_SYDMA_VERSION, field STEP

#define BP_SYDMA_VERSION_STEP      0
#define BM_SYDMA_VERSION_STEP      0x0000FFFF

#define BF_SYDMA_VERSION_STEP(v)   (((v) << 0) & BM_SYDMA_VERSION_STEP)


#endif // _REGSSYDMA_H

////////////////////////////////////////////////////////////////////////////////
