import { TNodeWithLexicalScope } from '../../types/node/TNodeWithLexicalScope';
import { IOptions } from '../../interfaces/options/IOptions';
import { IRandomGenerator } from '../../interfaces/utils/IRandomGenerator';
import { AbstractIdentifierNamesGenerator } from './AbstractIdentifierNamesGenerator';
export declare class MangledIdentifierNamesGenerator extends AbstractIdentifierNamesGenerator {
    private static readonly initMangledNameCharacter;
    private static readonly lastMangledNameInScopeMap;
    private static readonly nameSequence;
    private static readonly reservedNamesSet;
    private previousMangledName;
    constructor(randomGenerator: IRandomGenerator, options: IOptions);
    generateNext(nameLength?: number): string;
    generateForGlobalScope(nameLength?: number): string;
    generateForLexicalScope(lexicalScopeNode: TNodeWithLexicalScope, nameLength?: number): string;
    isIncrementedMangledName(nextName: string, prevName: string): boolean;
    isValidIdentifierName(mangledName: string): boolean;
    protected getNameSequence(): string[];
    protected updatePreviousMangledName(name: string): void;
    protected generateNewMangledName(previousMangledName: string): string;
    private getLastMangledNameForScopes;
}
