/* input-output.c generated by valac 0.38.7, the Vala compiler
 * generated from input-output.vala, do not modify */

/*   FILE: io.vala -- Handle PiFace CAD or keyboard I/O.
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 22 February 2018
 *
 * Copyright (c) 2018 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* The PiFace CAD provides the following inputs:
 *   From left to right:
 *     Button 0 = 0
 *     Button 1 = 1
 *     Button 2 = 2
 *     Button 3 = 3
 *     Button 4 = 4
 *   Rocker switch:
 *     Select     = 5
 *     Rock left  = 6
 *     Rock right = 7
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <pifacecad.h>
#include <stdio.h>
#include <unistd.h>


#define TYPE_SWITCH_NUMBER (switch_number_get_type ())

#define TYPE_KEY_NUMBER (key_number_get_type ())

#define TYPE_INPUT_OUTPUT (input_output_get_type ())
#define INPUT_OUTPUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_OUTPUT, InputOutput))
#define INPUT_OUTPUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_OUTPUT, InputOutputClass))
#define IS_INPUT_OUTPUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_OUTPUT))
#define IS_INPUT_OUTPUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_OUTPUT))
#define INPUT_OUTPUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_OUTPUT, InputOutputClass))

typedef struct _InputOutput InputOutput;
typedef struct _InputOutputClass InputOutputClass;
typedef struct _InputOutputPrivate InputOutputPrivate;
enum  {
	INPUT_OUTPUT_0_PROPERTY,
	INPUT_OUTPUT_NUM_PROPERTIES
};
static GParamSpec* input_output_properties[INPUT_OUTPUT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	INPUT_OUTPUT_STOP_SIGNAL,
	INPUT_OUTPUT_SEEKBACK_SIGNAL,
	INPUT_OUTPUT_PAUSEPLAY_SIGNAL,
	INPUT_OUTPUT_SEEKFORWARD_SIGNAL,
	INPUT_OUTPUT_ESCAPE_SIGNAL,
	INPUT_OUTPUT_LEFT_SIGNAL,
	INPUT_OUTPUT_RIGHT_SIGNAL,
	INPUT_OUTPUT_SELECT_SIGNAL,
	INPUT_OUTPUT_NUM_SIGNALS
};
static guint input_output_signals[INPUT_OUTPUT_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	SWITCH_NUMBER_STOP = 0,
	SWITCH_NUMBER_SEEKBACK = 1,
	SWITCH_NUMBER_PAUSEPLAY = 2,
	SWITCH_NUMBER_SEEKFORWARD = 3,
	SWITCH_NUMBER_ESCAPE = 4,
	SWITCH_NUMBER_SELECT = 5,
	SWITCH_NUMBER_LEFT = 6,
	SWITCH_NUMBER_RIGHT = 7
} SwitchNumber;

typedef enum  {
	KEY_NUMBER_STOP = 'z',
	KEY_NUMBER_SEEKBACK = 'q',
	KEY_NUMBER_PAUSEPLAY = ' ',
	KEY_NUMBER_SEEKFORWARD = 'w',
	KEY_NUMBER_ESCAPE = 0x1b,
	KEY_NUMBER_SELECT = '\n',
	KEY_NUMBER_LEFT = 'a',
	KEY_NUMBER_RIGHT = 's'
} KeyNumber;

struct _InputOutput {
	GObject parent_instance;
	InputOutputPrivate * priv;
};

struct _InputOutputClass {
	GObjectClass parent_class;
};

struct _InputOutputPrivate {
	gboolean pifacecad;
	guint lights_out_id;
	guint8* lastSwitchState;
	gint lastSwitchState_length1;
	gint _lastSwitchState_size_;
};


static gpointer input_output_parent_class = NULL;
static guint input_output_output_shift;
static guint input_output_output_shift = (guint) 0;
static gchar* input_output_output_str;
static gchar* input_output_output_str = NULL;
extern gboolean no_pifacecad;

#define LIGHTS_OUT_SECONDS ((guint) 10)
#define SWITCH_POLL_MILLISECONDS ((guint) 20)
#define OUTPUT_REFRESH_FREQUENCY ((guint) 750)
GType switch_number_get_type (void) G_GNUC_CONST;
GType key_number_get_type (void) G_GNUC_CONST;
GType input_output_get_type (void) G_GNUC_CONST;
#define INPUT_OUTPUT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_INPUT_OUTPUT, InputOutputPrivate))
InputOutput* input_output_new (gboolean pifacecad);
InputOutput* input_output_construct (GType object_type, gboolean pifacecad);
static gboolean input_output_render_output (InputOutput* self);
static gboolean _input_output_render_output_gsource_func (gpointer self);
void input_output_register_handlers (InputOutput* self);
static void input_output_lights (InputOutput* self);
void input_output_output (InputOutput* self, const gchar* str);
gboolean input_output_check_keyboard (InputOutput* self, GIOChannel* channel, GIOCondition condition);
static gboolean _input_output_check_keyboard_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
gboolean input_output_check_switches (InputOutput* self);
static gboolean _input_output_check_switches_gsource_func (gpointer self);
static gboolean ___lambda4_ (InputOutput* self);
static gboolean ____lambda4__gsource_func (gpointer self);
static void input_output_finalize (GObject * obj);


GType switch_number_get_type (void) {
	static volatile gsize switch_number_type_id__volatile = 0;
	if (g_once_init_enter (&switch_number_type_id__volatile)) {
		static const GEnumValue values[] = {{SWITCH_NUMBER_STOP, "SWITCH_NUMBER_STOP", "stop"}, {SWITCH_NUMBER_SEEKBACK, "SWITCH_NUMBER_SEEKBACK", "seekback"}, {SWITCH_NUMBER_PAUSEPLAY, "SWITCH_NUMBER_PAUSEPLAY", "pauseplay"}, {SWITCH_NUMBER_SEEKFORWARD, "SWITCH_NUMBER_SEEKFORWARD", "seekforward"}, {SWITCH_NUMBER_ESCAPE, "SWITCH_NUMBER_ESCAPE", "escape"}, {SWITCH_NUMBER_SELECT, "SWITCH_NUMBER_SELECT", "select"}, {SWITCH_NUMBER_LEFT, "SWITCH_NUMBER_LEFT", "left"}, {SWITCH_NUMBER_RIGHT, "SWITCH_NUMBER_RIGHT", "right"}, {0, NULL, NULL}};
		GType switch_number_type_id;
		switch_number_type_id = g_enum_register_static ("SwitchNumber", values);
		g_once_init_leave (&switch_number_type_id__volatile, switch_number_type_id);
	}
	return switch_number_type_id__volatile;
}


GType key_number_get_type (void) {
	static volatile gsize key_number_type_id__volatile = 0;
	if (g_once_init_enter (&key_number_type_id__volatile)) {
		static const GEnumValue values[] = {{KEY_NUMBER_STOP, "KEY_NUMBER_STOP", "stop"}, {KEY_NUMBER_SEEKBACK, "KEY_NUMBER_SEEKBACK", "seekback"}, {KEY_NUMBER_PAUSEPLAY, "KEY_NUMBER_PAUSEPLAY", "pauseplay"}, {KEY_NUMBER_SEEKFORWARD, "KEY_NUMBER_SEEKFORWARD", "seekforward"}, {KEY_NUMBER_ESCAPE, "KEY_NUMBER_ESCAPE", "escape"}, {KEY_NUMBER_SELECT, "KEY_NUMBER_SELECT", "select"}, {KEY_NUMBER_LEFT, "KEY_NUMBER_LEFT", "left"}, {KEY_NUMBER_RIGHT, "KEY_NUMBER_RIGHT", "right"}, {0, NULL, NULL}};
		GType key_number_type_id;
		key_number_type_id = g_enum_register_static ("KeyNumber", values);
		g_once_init_leave (&key_number_type_id__volatile, key_number_type_id);
	}
	return key_number_type_id__volatile;
}


static gboolean _input_output_render_output_gsource_func (gpointer self) {
	gboolean result;
	result = input_output_render_output ((InputOutput*) self);
	return result;
}


InputOutput* input_output_construct (GType object_type, gboolean pifacecad) {
	InputOutput * self = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (InputOutput*) g_object_new (object_type, NULL);
	_tmp0_ = pifacecad;
	self->priv->pifacecad = _tmp0_;
	_tmp1_ = pifacecad;
	if (_tmp1_) {
		pifacecad_open ();
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 750, _input_output_render_output_gsource_func, g_object_ref (self), g_object_unref);
	}
	input_output_register_handlers (self);
	input_output_lights (self);
	return self;
}


InputOutput* input_output_new (gboolean pifacecad) {
	return input_output_construct (TYPE_INPUT_OUTPUT, pifacecad);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean input_output_render_output (InputOutput* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	pifacecad_lcd_clear ();
	_tmp0_ = input_output_output_str;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ <= 15) {
		const gchar* _tmp3_;
		_tmp3_ = input_output_output_str;
		pifacecad_lcd_write (_tmp3_);
	} else {
		GString* builder = NULL;
		GString* _tmp4_;
		gint _tmp5_ = 0;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		guint rest = 0U;
		gint _tmp12_ = 0;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		guint cutoff = 0U;
		GString* _tmp19_;
		const gchar* _tmp20_;
		guint _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GString* _tmp24_;
		GString* _tmp25_;
		const gchar* _tmp26_;
		guint _tmp27_;
		guint _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		GString* _tmp31_;
		const gchar* _tmp32_;
		guint _tmp33_ = 0U;
		guint _tmp34_;
		guint _tmp35_;
		_tmp4_ = g_string_new ("");
		builder = _tmp4_;
		_tmp6_ = input_output_output_str;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ > 30) {
			_tmp5_ = 15;
		} else {
			const gchar* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = input_output_output_str;
			_tmp10_ = strlen (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp5_ = _tmp11_ - 15;
		}
		rest = (guint) _tmp5_;
		_tmp13_ = input_output_output_str;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ > 30) {
			const gchar* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp16_ = input_output_output_str;
			_tmp17_ = strlen (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp12_ = _tmp18_ - 30;
		} else {
			_tmp12_ = 0;
		}
		cutoff = (guint) _tmp12_;
		_tmp19_ = builder;
		_tmp20_ = input_output_output_str;
		_tmp21_ = input_output_output_shift;
		_tmp22_ = string_substring (_tmp20_, (glong) _tmp21_, (glong) 15);
		_tmp23_ = _tmp22_;
		g_string_append (_tmp19_, _tmp23_);
		_g_free0 (_tmp23_);
		_tmp24_ = builder;
		g_string_append (_tmp24_, "\n ");
		_tmp25_ = builder;
		_tmp26_ = input_output_output_str;
		_tmp27_ = input_output_output_shift;
		_tmp28_ = rest;
		_tmp29_ = string_substring (_tmp26_, (glong) (15 + _tmp27_), (glong) _tmp28_);
		_tmp30_ = _tmp29_;
		g_string_append (_tmp25_, _tmp30_);
		_g_free0 (_tmp30_);
		_tmp31_ = builder;
		_tmp32_ = _tmp31_->str;
		pifacecad_lcd_write (_tmp32_);
		_tmp34_ = input_output_output_shift;
		_tmp35_ = cutoff;
		if (_tmp34_ < _tmp35_) {
			guint _tmp36_;
			_tmp36_ = input_output_output_shift;
			_tmp33_ = _tmp36_ + 1;
		} else {
			_tmp33_ = (guint) 0;
		}
		input_output_output_shift = _tmp33_;
		_g_string_free0 (builder);
	}
	result = TRUE;
	return result;
}


void input_output_output (InputOutput* self, const gchar* str) {
	FILE* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = stdout;
	_tmp1_ = str;
	fprintf (_tmp0_, "%s\n", _tmp1_);
	input_output_output_shift = (guint) 0;
	_tmp2_ = str;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (input_output_output_str);
	input_output_output_str = _tmp3_;
	_tmp4_ = no_pifacecad;
	if (!_tmp4_) {
		input_output_render_output (self);
	}
}


static gboolean _input_output_check_keyboard_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = input_output_check_keyboard ((InputOutput*) self, source, condition);
	return result;
}


static gboolean _input_output_check_switches_gsource_func (gpointer self) {
	gboolean result;
	result = input_output_check_switches ((InputOutput*) self);
	return result;
}


void input_output_register_handlers (InputOutput* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GIOChannel* channel = NULL;
		GIOChannel* _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = g_io_channel_unix_new (STDIN_FILENO);
		channel = _tmp0_;
		g_io_channel_set_encoding (channel, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_io_channel_unref0 (channel);
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch0_g_io_channel_error;
			}
			_g_io_channel_unref0 (channel);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_io_add_watch (channel, G_IO_IN, _input_output_check_keyboard_gio_func, self);
		_tmp1_ = self->priv->pifacecad;
		if (_tmp1_) {
			g_timeout_add_full (G_PRIORITY_DEFAULT, SWITCH_POLL_MILLISECONDS, _input_output_check_switches_gsource_func, g_object_ref (self), g_object_unref);
		}
		_g_io_channel_unref0 (channel);
	}
	goto __finally0;
	__catch0_g_io_channel_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_error ("input-output.vala:138: Channel error initializing state");
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean ___lambda4_ (InputOutput* self) {
	gboolean result = FALSE;
	pifacecad_lcd_backlight_off ();
	result = FALSE;
	return result;
}


static gboolean ____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda4_ ((InputOutput*) self);
	return result;
}


static void input_output_lights (InputOutput* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pifacecad;
	if (_tmp0_) {
		guint _tmp1_;
		guint _tmp3_;
		pifacecad_lcd_backlight_on ();
		_tmp1_ = self->priv->lights_out_id;
		if (((guint) 0) != _tmp1_) {
			guint _tmp2_;
			_tmp2_ = self->priv->lights_out_id;
			g_source_remove (_tmp2_);
		}
		_tmp3_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, LIGHTS_OUT_SECONDS, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->lights_out_id = _tmp3_;
	}
}


gboolean input_output_check_switches (InputOutput* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pifacecad;
	_vala_assert (_tmp0_, "pifacecad");
	{
		guint8 _switch_ = 0U;
		_switch_ = (guint8) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint8 _tmp3_;
				guint8 current = 0U;
				guint8 _tmp4_;
				guint8 _tmp5_;
				gboolean _tmp6_ = FALSE;
				guint8 _tmp7_;
				guint8* _tmp13_;
				gint _tmp13__length1;
				guint8 _tmp14_;
				guint8 _tmp15_;
				guint8 _tmp16_;
				if (!_tmp1_) {
					guint8 _tmp2_;
					_tmp2_ = _switch_;
					_switch_ = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = _switch_;
				if (!(((gint) _tmp3_) < 8)) {
					break;
				}
				_tmp4_ = _switch_;
				_tmp5_ = pifacecad_read_switch (_tmp4_);
				current = _tmp5_;
				_tmp7_ = current;
				if (0 == ((gint) _tmp7_)) {
					guint8* _tmp8_;
					gint _tmp8__length1;
					guint8 _tmp9_;
					guint8 _tmp10_;
					_tmp8_ = self->priv->lastSwitchState;
					_tmp8__length1 = self->priv->lastSwitchState_length1;
					_tmp9_ = _switch_;
					_tmp10_ = _tmp8_[_tmp9_];
					_tmp6_ = 1 == ((gint) _tmp10_);
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					guint8 _tmp11_;
					guint8 _tmp12_;
					_tmp11_ = _switch_;
					g_debug ("input-output.vala:163: Switch %d input\n", (gint) _tmp11_);
					_tmp12_ = _switch_;
					switch (_tmp12_) {
						case SWITCH_NUMBER_STOP:
						{
							g_signal_emit (self, input_output_signals[INPUT_OUTPUT_STOP_SIGNAL], 0);
							break;
						}
						case SWITCH_NUMBER_SEEKBACK:
						{
							g_signal_emit (self, input_output_signals[INPUT_OUTPUT_SEEKBACK_SIGNAL], 0);
							break;
						}
						case SWITCH_NUMBER_PAUSEPLAY:
						{
							g_signal_emit (self, input_output_signals[INPUT_OUTPUT_PAUSEPLAY_SIGNAL], 0);
							break;
						}
						case SWITCH_NUMBER_SEEKFORWARD:
						{
							g_signal_emit (self, input_output_signals[INPUT_OUTPUT_SEEKFORWARD_SIGNAL], 0);
							break;
						}
						case SWITCH_NUMBER_ESCAPE:
						{
							g_signal_emit (self, input_output_signals[INPUT_OUTPUT_ESCAPE_SIGNAL], 0);
							break;
						}
						case SWITCH_NUMBER_SELECT:
						{
							g_signal_emit (self, input_output_signals[INPUT_OUTPUT_SELECT_SIGNAL], 0);
							break;
						}
						case SWITCH_NUMBER_LEFT:
						{
							g_signal_emit (self, input_output_signals[INPUT_OUTPUT_LEFT_SIGNAL], 0);
							break;
						}
						case SWITCH_NUMBER_RIGHT:
						{
							g_signal_emit (self, input_output_signals[INPUT_OUTPUT_RIGHT_SIGNAL], 0);
							break;
						}
						default:
						{
							g_warning ("input-output.vala:191: Invalid key pressed");
							break;
						}
					}
					input_output_lights (self);
				}
				_tmp13_ = self->priv->lastSwitchState;
				_tmp13__length1 = self->priv->lastSwitchState_length1;
				_tmp14_ = _switch_;
				_tmp15_ = current;
				_tmp13_[_tmp14_] = _tmp15_;
				_tmp16_ = _tmp13_[_tmp14_];
			}
		}
	}
	result = TRUE;
	return result;
}


gboolean input_output_check_keyboard (InputOutput* self, GIOChannel* channel, GIOCondition condition) {
	gboolean result = FALSE;
	gchar* c = NULL;
	gchar* _tmp0_;
	gint c_length1;
	gint _c_size_;
	GIOCondition _tmp1_;
	gchar* _tmp19_;
	gint _tmp19__length1;
	gchar _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	_tmp0_ = g_new0 (gchar, 1);
	c = _tmp0_;
	c_length1 = 1;
	_c_size_ = c_length1;
	_tmp1_ = condition;
	if (_tmp1_ == G_IO_HUP) {
		FILE* _tmp2_;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "Standard in closed?\n");
		result = FALSE;
		c = (g_free (c), NULL);
		return result;
	}
	{
		gsize length = 0UL;
		GIOStatus status = 0;
		GIOChannel* _tmp3_;
		gchar* _tmp4_;
		gint _tmp4__length1;
		gsize _tmp5_ = 0UL;
		GIOStatus _tmp6_;
		gboolean _tmp8_ = FALSE;
		GIOStatus _tmp9_;
		length = (gsize) -1;
		_tmp3_ = channel;
		_tmp4_ = c;
		_tmp4__length1 = c_length1;
		_tmp6_ = g_io_channel_read_chars (_tmp3_, _tmp4_, _tmp4__length1, &_tmp5_, &_inner_error_);
		length = _tmp5_;
		status = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch1_g_io_channel_error;
			}
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch1_g_convert_error;
			}
			c = (g_free (c), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp7_;
		}
		_tmp9_ = status;
		if (_tmp9_ == G_IO_STATUS_EOF) {
			_tmp8_ = TRUE;
		} else {
			gsize _tmp10_;
			_tmp10_ = length;
			_tmp8_ = _tmp10_ != ((gsize) 1);
		}
		if (_tmp8_) {
			FILE* _tmp11_;
			_tmp11_ = stderr;
			fprintf (_tmp11_, "Standard in closed?\n");
			result = FALSE;
			c = (g_free (c), NULL);
			return result;
		}
	}
	goto __finally1;
	__catch1_g_io_channel_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "IOChannelError: %s\n", _tmp14_);
		result = FALSE;
		_g_error_free0 (e);
		c = (g_free (c), NULL);
		return result;
	}
	goto __finally1;
	__catch1_g_convert_error:
	{
		GError* e = NULL;
		FILE* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = stderr;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		fprintf (_tmp15_, "ConvertError: %s\n", _tmp17_);
		result = FALSE;
		_g_error_free0 (e);
		c = (g_free (c), NULL);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp18_ = FALSE;
		c = (g_free (c), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp18_;
	}
	_tmp19_ = c;
	_tmp19__length1 = c_length1;
	_tmp20_ = _tmp19_[0];
	switch (_tmp20_) {
		case KEY_NUMBER_STOP:
		{
			g_signal_emit (self, input_output_signals[INPUT_OUTPUT_STOP_SIGNAL], 0);
			break;
		}
		case KEY_NUMBER_SEEKBACK:
		{
			g_signal_emit (self, input_output_signals[INPUT_OUTPUT_SEEKBACK_SIGNAL], 0);
			break;
		}
		case KEY_NUMBER_SEEKFORWARD:
		{
			g_signal_emit (self, input_output_signals[INPUT_OUTPUT_SEEKFORWARD_SIGNAL], 0);
			break;
		}
		case KEY_NUMBER_PAUSEPLAY:
		{
			g_signal_emit (self, input_output_signals[INPUT_OUTPUT_PAUSEPLAY_SIGNAL], 0);
			break;
		}
		case KEY_NUMBER_LEFT:
		{
			g_signal_emit (self, input_output_signals[INPUT_OUTPUT_LEFT_SIGNAL], 0);
			break;
		}
		case KEY_NUMBER_RIGHT:
		{
			g_signal_emit (self, input_output_signals[INPUT_OUTPUT_RIGHT_SIGNAL], 0);
			break;
		}
		case KEY_NUMBER_SELECT:
		{
			g_signal_emit (self, input_output_signals[INPUT_OUTPUT_SELECT_SIGNAL], 0);
			break;
		}
		case KEY_NUMBER_ESCAPE:
		{
			g_signal_emit (self, input_output_signals[INPUT_OUTPUT_ESCAPE_SIGNAL], 0);
			break;
		}
		default:
		{
			FILE* _tmp21_;
			FILE* _tmp22_;
			FILE* _tmp23_;
			FILE* _tmp24_;
			FILE* _tmp25_;
			FILE* _tmp26_;
			FILE* _tmp27_;
			FILE* _tmp28_;
			FILE* _tmp29_;
			_tmp21_ = stderr;
			fprintf (_tmp21_, "Valid keys are:\n");
			_tmp22_ = stderr;
			fprintf (_tmp22_, "  'z'     (stop)\n");
			_tmp23_ = stderr;
			fprintf (_tmp23_, "  'q'     (seek backward)\n");
			_tmp24_ = stderr;
			fprintf (_tmp24_, "  'w'     (seek forward)\n");
			_tmp25_ = stderr;
			fprintf (_tmp25_, "  ' '     (pause/play)\n");
			_tmp26_ = stderr;
			fprintf (_tmp26_, "  'a'     (left)\n");
			_tmp27_ = stderr;
			fprintf (_tmp27_, "  's'     (right)\n");
			_tmp28_ = stderr;
			fprintf (_tmp28_, "  'enter' (select)\n");
			_tmp29_ = stderr;
			fprintf (_tmp29_, "  'esc'   (escape)\n");
			break;
		}
	}
	result = TRUE;
	c = (g_free (c), NULL);
	return result;
}


static void input_output_class_init (InputOutputClass * klass) {
	gchar* _tmp0_;
	input_output_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (InputOutputPrivate));
	G_OBJECT_CLASS (klass)->finalize = input_output_finalize;
	input_output_signals[INPUT_OUTPUT_STOP_SIGNAL] = g_signal_new ("stop", TYPE_INPUT_OUTPUT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	input_output_signals[INPUT_OUTPUT_SEEKBACK_SIGNAL] = g_signal_new ("seekback", TYPE_INPUT_OUTPUT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	input_output_signals[INPUT_OUTPUT_PAUSEPLAY_SIGNAL] = g_signal_new ("pauseplay", TYPE_INPUT_OUTPUT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	input_output_signals[INPUT_OUTPUT_SEEKFORWARD_SIGNAL] = g_signal_new ("seekforward", TYPE_INPUT_OUTPUT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	input_output_signals[INPUT_OUTPUT_ESCAPE_SIGNAL] = g_signal_new ("escape", TYPE_INPUT_OUTPUT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	input_output_signals[INPUT_OUTPUT_LEFT_SIGNAL] = g_signal_new ("left", TYPE_INPUT_OUTPUT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	input_output_signals[INPUT_OUTPUT_RIGHT_SIGNAL] = g_signal_new ("right", TYPE_INPUT_OUTPUT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	input_output_signals[INPUT_OUTPUT_SELECT_SIGNAL] = g_signal_new ("select", TYPE_INPUT_OUTPUT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_strdup ("");
	input_output_output_str = _tmp0_;
}


static void input_output_instance_init (InputOutput * self) {
	guint8* _tmp0_;
	self->priv = INPUT_OUTPUT_GET_PRIVATE (self);
	self->priv->lights_out_id = (guint) 0;
	_tmp0_ = g_new0 (guint8, 8);
	_tmp0_[0] = (guint8) 1;
	_tmp0_[1] = (guint8) 1;
	_tmp0_[2] = (guint8) 1;
	_tmp0_[3] = (guint8) 1;
	_tmp0_[4] = (guint8) 1;
	_tmp0_[5] = (guint8) 1;
	_tmp0_[6] = (guint8) 1;
	_tmp0_[7] = (guint8) 1;
	self->priv->lastSwitchState = _tmp0_;
	self->priv->lastSwitchState_length1 = 8;
	self->priv->_lastSwitchState_size_ = self->priv->lastSwitchState_length1;
}


static void input_output_finalize (GObject * obj) {
	InputOutput * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INPUT_OUTPUT, InputOutput);
	self->priv->lastSwitchState = (g_free (self->priv->lastSwitchState), NULL);
	G_OBJECT_CLASS (input_output_parent_class)->finalize (obj);
}


GType input_output_get_type (void) {
	static volatile gsize input_output_type_id__volatile = 0;
	if (g_once_init_enter (&input_output_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (InputOutputClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) input_output_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InputOutput), 0, (GInstanceInitFunc) input_output_instance_init, NULL };
		GType input_output_type_id;
		input_output_type_id = g_type_register_static (G_TYPE_OBJECT, "InputOutput", &g_define_type_info, 0);
		g_once_init_leave (&input_output_type_id__volatile, input_output_type_id);
	}
	return input_output_type_id__volatile;
}



