/* lcdgrilo.c generated by valac 0.38.7, the Vala compiler
 * generated from lcdgrilo.vala, do not modify */

/*   FILE: lcdgrilo.vala -- A simple DAAP music player
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 27 November 2013
 *
 * Copyright (c) 2013 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <gee.h>
#include <grilo.h>
#include <stdio.h>
#include <termios.h>
#include <unistd.h>
#include <gobject/gvaluecollector.h>


#define TYPE_LCD_PLAYER (lcd_player_get_type ())
#define LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LCD_PLAYER, LCDPlayer))
#define LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LCD_PLAYER, LCDPlayerClass))
#define IS_LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LCD_PLAYER))
#define IS_LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LCD_PLAYER))
#define LCD_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LCD_PLAYER, LCDPlayerClass))

typedef struct _LCDPlayer LCDPlayer;
typedef struct _LCDPlayerClass LCDPlayerClass;
typedef struct _LCDPlayerPrivate LCDPlayerPrivate;

#define TYPE_INPUT_OUTPUT (input_output_get_type ())
#define INPUT_OUTPUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_OUTPUT, InputOutput))
#define INPUT_OUTPUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_OUTPUT, InputOutputClass))
#define IS_INPUT_OUTPUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_OUTPUT))
#define IS_INPUT_OUTPUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_OUTPUT))
#define INPUT_OUTPUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_OUTPUT, InputOutputClass))

typedef struct _InputOutput InputOutput;
typedef struct _InputOutputClass InputOutputClass;

#define TYPE_STACK (stack_get_type ())
#define STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STACK, Stack))
#define STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STACK, StackClass))
#define IS_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STACK))
#define IS_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STACK))
#define STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STACK, StackClass))

typedef struct _Stack Stack;
typedef struct _StackClass StackClass;

#define TYPE_STATE (state_get_type ())
#define STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE, State))
#define STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE, StateClass))
#define IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE))
#define IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE))
#define STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE, StateClass))

typedef struct _State State;
typedef struct _StateClass StateClass;

#define TYPE_TRANSITIONS (transitions_get_type ())
#define TRANSITIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSITIONS, Transitions))
#define TRANSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSITIONS, TransitionsClass))
#define IS_TRANSITIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSITIONS))
#define IS_TRANSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSITIONS))
#define TRANSITIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSITIONS, TransitionsClass))

typedef struct _Transitions Transitions;
typedef struct _TransitionsClass TransitionsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _transitions_unref0(var) ((var == NULL) ? NULL : (var = (transitions_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_STATE_CHOOSE_SOURCE (state_choose_source_get_type ())
#define STATE_CHOOSE_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE_CHOOSE_SOURCE, StateChooseSource))
#define STATE_CHOOSE_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE_CHOOSE_SOURCE, StateChooseSourceClass))
#define IS_STATE_CHOOSE_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE_CHOOSE_SOURCE))
#define IS_STATE_CHOOSE_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE_CHOOSE_SOURCE))
#define STATE_CHOOSE_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE_CHOOSE_SOURCE, StateChooseSourceClass))

typedef struct _StateChooseSource StateChooseSource;
typedef struct _StateChooseSourceClass StateChooseSourceClass;
typedef struct _ParamSpecLCDPlayer ParamSpecLCDPlayer;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _lcd_player_unref0(var) ((var == NULL) ? NULL : (var = (lcd_player_unref (var), NULL)))

struct _LCDPlayer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LCDPlayerPrivate * priv;
	GstElement* element;
	GeeArrayList* playlist;
	InputOutput* io;
};

struct _LCDPlayerClass {
	GTypeClass parent_class;
	void (*finalize) (LCDPlayer *self);
};

struct _LCDPlayerPrivate {
	Stack* _stateStack;
	gint current;
	Transitions* transitions;
	GMainLoop* loop;
	GeeArrayList* sources;
	guint watch_id;
};

struct _ParamSpecLCDPlayer {
	GParamSpec parent_instance;
};


extern gboolean no_pifacecad;
gboolean no_pifacecad = FALSE;
extern gchar* tag;
gchar* tag = NULL;
extern gboolean debug;
gboolean debug = FALSE;
static gpointer lcd_player_parent_class = NULL;

gpointer lcd_player_ref (gpointer instance);
void lcd_player_unref (gpointer instance);
GParamSpec* param_spec_lcd_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_lcd_player (GValue* value, gpointer v_object);
void value_take_lcd_player (GValue* value, gpointer v_object);
gpointer value_get_lcd_player (const GValue* value);
GType lcd_player_get_type (void) G_GNUC_CONST;
GType input_output_get_type (void) G_GNUC_CONST;
GType stack_get_type (void) G_GNUC_CONST;
GType state_get_type (void) G_GNUC_CONST;
gpointer transitions_ref (gpointer instance);
void transitions_unref (gpointer instance);
GParamSpec* param_spec_transitions (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_transitions (GValue* value, gpointer v_object);
void value_take_transitions (GValue* value, gpointer v_object);
gpointer value_get_transitions (const GValue* value);
GType transitions_get_type (void) G_GNUC_CONST;
#define LCD_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LCD_PLAYER, LCDPlayerPrivate))
LCDPlayer* lcd_player_new (void);
LCDPlayer* lcd_player_construct (GType object_type);
InputOutput* input_output_new (gboolean pifacecad);
InputOutput* input_output_construct (GType object_type, gboolean pifacecad);
Stack* stack_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
Stack* stack_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
void lcd_player_set_stateStack (LCDPlayer* self, Stack* value);
Stack* lcd_player_get_stateStack (LCDPlayer* self);
Transitions* transitions_new (InputOutput* io, Stack* stateStack);
Transitions* transitions_construct (GType object_type, InputOutput* io, Stack* stateStack);
static void __lambda13_ (LCDPlayer* self, GrlSource* source);
static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle);
gpointer stack_peek (Stack* self);
void state_print_selected (State* self);
static void ___lambda13__grl_registry_source_added (GrlRegistry* _sender, GrlSource* source, gpointer self);
static void __lambda14_ (LCDPlayer* self, GrlSource* source);
static void ___lambda14__grl_registry_source_removed (GrlRegistry* _sender, GrlSource* source, gpointer self);
static gboolean lcd_player_bus_callback (LCDPlayer* self, GstBus* bus, GstMessage* message);
void input_output_output (InputOutput* self, const gchar* str);
void lcd_player_forward (LCDPlayer* self);
gboolean lcd_player_play (LCDPlayer* self);
static gboolean _lcd_player_play_gsource_func (gpointer self);
void lcd_player_stop (LCDPlayer* self);
void lcd_player_pauseplay (LCDPlayer* self);
static inline void _dynamic_set_uri0 (GstElement* obj, const gchar* value);
static inline void _dynamic_set_current_audio1 (GstElement* obj, gint value);
static gboolean _lcd_player_bus_callback_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
void lcd_player_backward (LCDPlayer* self);
gint64 lcd_player_seek (LCDPlayer* self, gboolean forward);
#define SCAN_JUMP_SECONDS ((gint64) 5)
gchar* lcd_player_current_title (LCDPlayer* self);
void lcd_player_run (LCDPlayer* self);
void stack_push (Stack* self, gconstpointer item);
StateChooseSource* state_choose_source_new (GMainLoop* loop, LCDPlayer* player, GeeArrayList* sources);
StateChooseSource* state_choose_source_construct (GType object_type, GMainLoop* loop, LCDPlayer* player, GeeArrayList* sources);
GType state_choose_source_get_type (void) G_GNUC_CONST;
static void lcd_player_finalize (LCDPlayer * obj);
gint _vala_main (gchar** args, int args_length1);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[4] = {{"no-pifacecad", 'n', 0, G_OPTION_ARG_NONE, &no_pifacecad, "Do not try to use PiFace CAD for I/O", NULL}, {"tag", 't', 0, G_OPTION_ARG_STRING, &tag, "Only show sources with the following tag", NULL}, {"debug", 'd', 0, G_OPTION_ARG_NONE, &debug, "Print debugging messages", NULL}, {NULL}};

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void __lambda13_ (LCDPlayer* self, GrlSource* source) {
	GrlSource* _tmp0_;
	guint _tmp1_;
	const gchar* _tmp2_;
	GeeArrayList* _tmp7_;
	GrlSource* _tmp8_;
	Stack* _tmp9_;
	gpointer _tmp10_;
	State* _tmp11_;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	_tmp1_ = grl_source_supported_operations (_tmp0_);
	if ((_tmp1_ & GRL_OP_BROWSE) == ((guint) 0)) {
		return;
	}
	_tmp2_ = tag;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		GrlSource* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		_tmp3_ = tag;
		_tmp4_ = source;
		_tmp6_ = _tmp5_ = grl_source_get_tags (_tmp4_);
		if (!_vala_string_array_contains (_tmp6_, _vala_array_length (_tmp5_), _tmp3_)) {
			return;
		}
	}
	_tmp7_ = self->priv->sources;
	_tmp8_ = source;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
	_tmp9_ = self->priv->_stateStack;
	_tmp10_ = stack_peek (_tmp9_);
	_tmp11_ = (State*) _tmp10_;
	state_print_selected (_tmp11_);
	_g_object_unref0 (_tmp11_);
}


static void ___lambda13__grl_registry_source_added (GrlRegistry* _sender, GrlSource* source, gpointer self) {
	__lambda13_ ((LCDPlayer*) self, source);
}


static void __lambda14_ (LCDPlayer* self, GrlSource* source) {
	GeeArrayList* _tmp0_;
	GrlSource* _tmp1_;
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->sources;
	_tmp1_ = source;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
}


static void ___lambda14__grl_registry_source_removed (GrlRegistry* _sender, GrlSource* source, gpointer self) {
	__lambda14_ ((LCDPlayer*) self, source);
}


LCDPlayer* lcd_player_construct (GType object_type) {
	LCDPlayer* self = NULL;
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	gboolean _tmp2_;
	InputOutput* _tmp3_;
	Stack* _tmp4_;
	Stack* _tmp5_;
	InputOutput* _tmp6_;
	Stack* _tmp7_;
	Transitions* _tmp8_;
	GrlRegistry* registry = NULL;
	GrlRegistry* _tmp9_;
	GrlRegistry* _tmp10_;
	const gchar* _tmp12_;
	GError * _inner_error_ = NULL;
	self = (LCDPlayer*) g_type_create_instance (object_type);
	_tmp0_ = gst_element_factory_make ("playbin", "play");
	if (_tmp0_ != NULL) {
		g_object_ref_sink (_tmp0_);
	}
	_g_object_unref0 (self->element);
	self->element = _tmp0_;
	_tmp1_ = self->element;
	((GstObject*) _tmp1_)->flags = (guint32) (0x00000002 | 0x00000010);
	_tmp2_ = no_pifacecad;
	_tmp3_ = input_output_new (!_tmp2_);
	_g_object_unref0 (self->io);
	self->io = _tmp3_;
	_tmp4_ = stack_new (TYPE_STATE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
	_tmp5_ = _tmp4_;
	lcd_player_set_stateStack (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->io;
	_tmp7_ = self->priv->_stateStack;
	_tmp8_ = transitions_new (_tmp6_, _tmp7_);
	_transitions_unref0 (self->priv->transitions);
	self->priv->transitions = _tmp8_;
	_tmp9_ = grl_registry_get_default ();
	_tmp10_ = _g_object_ref0 (_tmp9_);
	registry = _tmp10_;
	g_signal_connect (registry, "source-added", (GCallback) ___lambda13__grl_registry_source_added, self);
	g_signal_connect (registry, "source-removed", (GCallback) ___lambda14__grl_registry_source_removed, self);
	{
		grl_registry_load_all_plugins (registry, FALSE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e->message;
		g_error ("lcdgrilo.vala:86: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (registry);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp12_ = tag;
	if (_tmp12_ == NULL) {
		{
			grl_registry_activate_plugin_by_id (registry, "grl-daap", &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp13_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp13_ = e->message;
			g_error ("lcdgrilo.vala:95: %s", _tmp13_);
			_g_error_free0 (e);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (registry);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	} else {
		grl_registry_activate_all_plugins (registry);
	}
	_g_object_unref0 (registry);
	return self;
}


LCDPlayer* lcd_player_new (void) {
	return lcd_player_construct (TYPE_LCD_PLAYER);
}


static gboolean _lcd_player_play_gsource_func (gpointer self) {
	gboolean result;
	result = lcd_player_play ((LCDPlayer*) self);
	return result;
}


static gboolean lcd_player_bus_callback (LCDPlayer* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	gboolean fnval = FALSE;
	GstMessage* _tmp0_;
	GstMessageType _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	fnval = TRUE;
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	switch (_tmp1_) {
		case GST_MESSAGE_ERROR:
		{
			GError* err = NULL;
			gchar* debug = NULL;
			GstMessage* _tmp2_;
			GError* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			GString* builder = NULL;
			GString* _tmp5_;
			const gchar* _tmp6_;
			InputOutput* _tmp7_;
			const gchar* _tmp8_;
			_tmp2_ = message;
			gst_message_parse_error (_tmp2_, &_tmp3_, &_tmp4_);
			_g_error_free0 (err);
			err = _tmp3_;
			_g_free0 (debug);
			debug = _tmp4_;
			_tmp5_ = g_string_new ("");
			builder = _tmp5_;
			_tmp6_ = err->message;
			g_string_printf (builder, "Error: %s\n", _tmp6_);
			_tmp7_ = self->io;
			_tmp8_ = builder->str;
			input_output_output (_tmp7_, _tmp8_);
			exit (1);
			_g_string_free0 (builder);
			_g_free0 (debug);
			_g_error_free0 (err);
		}
		case GST_MESSAGE_EOS:
		{
			lcd_player_forward (self);
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _lcd_player_play_gsource_func, lcd_player_ref (self), lcd_player_unref);
			fnval = FALSE;
			break;
		}
		default:
		{
			break;
		}
	}
	result = fnval;
	return result;
}


void lcd_player_stop (LCDPlayer* self) {
	GstElement* _tmp0_;
	guint _tmp1_;
	GeeArrayList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->element;
	gst_element_set_state (_tmp0_, GST_STATE_NULL);
	_tmp1_ = self->priv->watch_id;
	g_source_remove (_tmp1_);
	_tmp2_ = self->playlist;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
}


void lcd_player_pauseplay (LCDPlayer* self) {
	GstState state = 0;
	GstElement* _tmp0_;
	GstState _tmp1_ = 0;
	GstState _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->element;
	gst_element_get_state (_tmp0_, &_tmp1_, NULL, (GstClockTime) 0);
	state = _tmp1_;
	_tmp2_ = state;
	if (GST_STATE_PLAYING == _tmp2_) {
		GstElement* _tmp3_;
		InputOutput* _tmp4_;
		_tmp3_ = self->element;
		gst_element_set_state (_tmp3_, GST_STATE_PAUSED);
		_tmp4_ = self->io;
		input_output_output (_tmp4_, "Paused");
	} else {
		GstState _tmp5_;
		_tmp5_ = state;
		if (GST_STATE_PAUSED == _tmp5_) {
			GstElement* _tmp6_;
			Stack* _tmp7_;
			gpointer _tmp8_;
			State* _tmp9_;
			_tmp6_ = self->element;
			gst_element_set_state (_tmp6_, GST_STATE_PLAYING);
			_tmp7_ = self->priv->_stateStack;
			_tmp8_ = stack_peek (_tmp7_);
			_tmp9_ = (State*) _tmp8_;
			state_print_selected (_tmp9_);
			_g_object_unref0 (_tmp9_);
		}
	}
}


static inline void _dynamic_set_uri0 (GstElement* obj, const gchar* value) {
	g_object_set (obj, "uri", value, NULL);
}


static inline void _dynamic_set_current_audio1 (GstElement* obj, gint value) {
	g_object_set (obj, "current-audio", value, NULL);
}


static gboolean _lcd_player_bus_callback_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = lcd_player_bus_callback ((LCDPlayer*) self, bus, message);
	return result;
}


gboolean lcd_player_play (LCDPlayer* self) {
	gboolean result = FALSE;
	GstState state = 0;
	GstElement* _tmp0_;
	GstState _tmp1_ = 0;
	GstState _tmp2_;
	GrlMedia* media = NULL;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gpointer _tmp5_;
	GstElement* _tmp6_;
	GrlMedia* _tmp7_;
	const gchar* _tmp8_;
	GstElement* _tmp9_;
	GrlMedia* _tmp10_;
	GrlKeyID _tmp11_;
	gint _tmp12_;
	GstBus* bus = NULL;
	GstElement* _tmp13_;
	GstBus* _tmp14_;
	GstBus* _tmp15_;
	guint _tmp16_;
	GstElement* _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->element;
	gst_element_get_state (_tmp0_, &_tmp1_, NULL, (GstClockTime) 0);
	state = _tmp1_;
	_tmp2_ = state;
	if (_tmp2_ == GST_STATE_PLAYING) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->playlist;
	_tmp4_ = self->priv->current;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp4_);
	media = (GrlMedia*) _tmp5_;
	_tmp6_ = self->element;
	_tmp7_ = media;
	_tmp8_ = grl_media_get_url (_tmp7_);
	_dynamic_set_uri0 (_tmp6_, _tmp8_);
	_tmp9_ = self->element;
	_tmp10_ = media;
	_tmp11_ = GRL_METADATA_KEY_AUDIO_TRACK;
	_tmp12_ = grl_data_get_int ((GrlData*) _tmp10_, _tmp11_);
	_dynamic_set_current_audio1 (_tmp9_, _tmp12_);
	_tmp13_ = self->element;
	_tmp14_ = gst_element_get_bus (_tmp13_);
	bus = _tmp14_;
	_tmp15_ = bus;
	_tmp16_ = gst_bus_add_watch_full (_tmp15_, G_PRIORITY_DEFAULT, _lcd_player_bus_callback_gst_bus_func, lcd_player_ref (self), lcd_player_unref);
	self->priv->watch_id = _tmp16_;
	_tmp17_ = self->element;
	gst_element_set_state (_tmp17_, GST_STATE_PLAYING);
	result = FALSE;
	_g_object_unref0 (bus);
	_g_object_unref0 (media);
	return result;
}


void lcd_player_forward (LCDPlayer* self) {
	GstElement* _tmp0_;
	guint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->element;
	gst_element_set_state (_tmp0_, GST_STATE_NULL);
	_tmp1_ = self->priv->watch_id;
	g_source_remove (_tmp1_);
	_tmp2_ = self->priv->current;
	_tmp3_ = self->playlist;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	self->priv->current = (_tmp2_ + 1) % _tmp5_;
}


void lcd_player_backward (LCDPlayer* self) {
	GstElement* _tmp0_;
	guint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->element;
	gst_element_set_state (_tmp0_, GST_STATE_NULL);
	_tmp1_ = self->priv->watch_id;
	g_source_remove (_tmp1_);
	_tmp2_ = self->priv->current;
	_tmp3_ = self->playlist;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->playlist;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	self->priv->current = (_tmp2_ + (_tmp5_ - 1)) % _tmp8_;
}


gint64 lcd_player_seek (LCDPlayer* self, gboolean forward) {
	gint64 result = 0LL;
	gint64 current_position = 0LL;
	gint64 next_position = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gint _tmp2_ = 0;
	gboolean _tmp3_;
	gint64 _tmp4_;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_;
	GstElement* _tmp8_;
	gint64 _tmp9_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->element;
	gst_element_query_position (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
	current_position = _tmp1_;
	_tmp3_ = forward;
	if (_tmp3_) {
		_tmp2_ = 1;
	} else {
		_tmp2_ = -1;
	}
	_tmp4_ = current_position;
	next_position = _tmp4_ + ((SCAN_JUMP_SECONDS * GST_SECOND) * _tmp2_);
	_tmp6_ = next_position;
	if (_tmp6_ < ((gint64) 0)) {
		_tmp5_ = (gint64) 0;
	} else {
		gint64 _tmp7_;
		_tmp7_ = next_position;
		_tmp5_ = _tmp7_;
	}
	next_position = _tmp5_;
	_tmp8_ = self->element;
	_tmp9_ = next_position;
	gst_element_seek_simple (_tmp8_, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_KEY_UNIT, _tmp9_);
	result = next_position;
	return result;
}


gchar* lcd_player_current_title (LCDPlayer* self) {
	gchar* result = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->playlist;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("Play queue empty");
		result = _tmp3_;
		return result;
	} else {
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gpointer _tmp6_;
		GrlMedia* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = self->playlist;
		_tmp5_ = self->priv->current;
		_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, _tmp5_);
		_tmp7_ = (GrlMedia*) _tmp6_;
		_tmp8_ = grl_media_get_title (_tmp7_);
		_tmp9_ = g_strdup (_tmp8_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp7_);
		result = _tmp10_;
		return result;
	}
}


void lcd_player_run (LCDPlayer* self) {
	GMainLoop* _tmp0_;
	Stack* _tmp1_;
	GMainLoop* _tmp2_;
	GeeArrayList* _tmp3_;
	StateChooseSource* _tmp4_;
	StateChooseSource* _tmp5_;
	GMainLoop* _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp0_;
	_tmp1_ = self->priv->_stateStack;
	_tmp2_ = self->priv->loop;
	_tmp3_ = self->priv->sources;
	_tmp4_ = state_choose_source_new (_tmp2_, self, _tmp3_);
	_tmp5_ = _tmp4_;
	stack_push (_tmp1_, (State*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->loop;
	g_main_loop_run (_tmp6_);
	_tmp7_ = no_pifacecad;
	if (!_tmp7_) {
		pifacecad_close ();
	}
}


Stack* lcd_player_get_stateStack (LCDPlayer* self) {
	Stack* result;
	Stack* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stateStack;
	result = _tmp0_;
	return result;
}


void lcd_player_set_stateStack (LCDPlayer* self, Stack* value) {
	Stack* _tmp0_;
	Stack* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_stateStack);
	self->priv->_stateStack = _tmp1_;
}


static void value_lcd_player_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_lcd_player_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		lcd_player_unref (value->data[0].v_pointer);
	}
}


static void value_lcd_player_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = lcd_player_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_lcd_player_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_lcd_player_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		LCDPlayer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = lcd_player_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_lcd_player_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	LCDPlayer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = lcd_player_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_lcd_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecLCDPlayer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_LCD_PLAYER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_lcd_player (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LCD_PLAYER), NULL);
	return value->data[0].v_pointer;
}


void value_set_lcd_player (GValue* value, gpointer v_object) {
	LCDPlayer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LCD_PLAYER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LCD_PLAYER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		lcd_player_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		lcd_player_unref (old);
	}
}


void value_take_lcd_player (GValue* value, gpointer v_object) {
	LCDPlayer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LCD_PLAYER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LCD_PLAYER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		lcd_player_unref (old);
	}
}


static void lcd_player_class_init (LCDPlayerClass * klass) {
	lcd_player_parent_class = g_type_class_peek_parent (klass);
	((LCDPlayerClass *) klass)->finalize = lcd_player_finalize;
	g_type_class_add_private (klass, sizeof (LCDPlayerPrivate));
}


static void lcd_player_instance_init (LCDPlayer * self) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self->priv = LCD_PLAYER_GET_PRIVATE (self);
	self->priv->_stateStack = NULL;
	_tmp0_ = gee_array_list_new (grl_media_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->playlist = _tmp0_;
	self->priv->current = 0;
	_tmp1_ = gee_array_list_new (grl_source_get_type (), NULL, NULL, NULL, NULL, NULL);
	self->priv->sources = _tmp1_;
	self->priv->watch_id = (guint) 0;
	self->ref_count = 1;
}


static void lcd_player_finalize (LCDPlayer * obj) {
	LCDPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LCD_PLAYER, LCDPlayer);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_stateStack);
	_g_object_unref0 (self->element);
	_g_object_unref0 (self->playlist);
	_g_object_unref0 (self->io);
	_transitions_unref0 (self->priv->transitions);
	_g_main_loop_unref0 (self->priv->loop);
	_g_object_unref0 (self->priv->sources);
}


GType lcd_player_get_type (void) {
	static volatile gsize lcd_player_type_id__volatile = 0;
	if (g_once_init_enter (&lcd_player_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_lcd_player_init, value_lcd_player_free_value, value_lcd_player_copy_value, value_lcd_player_peek_pointer, "p", value_lcd_player_collect_value, "p", value_lcd_player_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (LCDPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lcd_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LCDPlayer), 0, (GInstanceInitFunc) lcd_player_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType lcd_player_type_id;
		lcd_player_type_id = g_type_register_fundamental (g_type_fundamental_next (), "LCDPlayer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&lcd_player_type_id__volatile, lcd_player_type_id);
	}
	return lcd_player_type_id__volatile;
}


gpointer lcd_player_ref (gpointer instance) {
	LCDPlayer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void lcd_player_unref (gpointer instance) {
	LCDPlayer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		LCD_PLAYER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* opt_context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionGroup* _tmp2_;
	GOptionContext* _tmp3_;
	GOptionGroup* _tmp4_;
	GOptionContext* _tmp5_;
	gboolean _tmp17_;
	struct termios old_tio = {0};
	struct termios new_tio = {0};
	struct termios _tmp18_ = {0};
	struct termios _tmp19_;
	tcflag_t _tmp20_;
	struct termios _tmp21_;
	LCDPlayer* player = NULL;
	LCDPlayer* _tmp22_;
	LCDPlayer* _tmp23_;
	struct termios _tmp24_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new ("- Media player");
	opt_context = _tmp0_;
	_tmp1_ = opt_context;
	_tmp2_ = grl_init_get_option_group ();
	g_option_context_add_group (_tmp1_, _tmp2_);
	_tmp3_ = opt_context;
	_tmp4_ = gst_init_get_option_group ();
	g_option_context_add_group (_tmp3_, _tmp4_);
	_tmp5_ = opt_context;
	g_option_context_add_main_entries (_tmp5_, options, NULL);
	{
		GOptionContext* _tmp6_;
		_tmp6_ = opt_context;
		g_option_context_parse (_tmp6_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp7_ = 0;
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch4_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp7_;
		}
	}
	goto __finally4;
	__catch4_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		FILE* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = stderr;
		_tmp9_ = args;
		_tmp9__length1 = args_length1;
		_tmp10_ = _tmp9_[0];
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		fprintf (_tmp8_, "%s: %s\n", _tmp10_, _tmp12_);
		_tmp13_ = stderr;
		_tmp14_ = args;
		_tmp14__length1 = args_length1;
		_tmp15_ = _tmp14_[0];
		fprintf (_tmp13_, "Try '%s --help' for more information.\n", _tmp15_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (opt_context);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp16_ = 0;
		_g_option_context_free0 (opt_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp16_;
	}
	_tmp17_ = debug;
	if (_tmp17_) {
		g_setenv ("G_MESSAGES_DEBUG", "all", TRUE);
	}
	tcgetattr (STDIN_FILENO, &_tmp18_);
	old_tio = _tmp18_;
	_tmp19_ = old_tio;
	new_tio = _tmp19_;
	_tmp20_ = new_tio.c_lflag;
	new_tio.c_lflag = _tmp20_ & ((~ICANON) & (~ECHO));
	_tmp21_ = new_tio;
	tcsetattr (STDIN_FILENO, TCSANOW, &_tmp21_);
	_tmp22_ = lcd_player_new ();
	player = _tmp22_;
	_tmp23_ = player;
	lcd_player_run (_tmp23_);
	_tmp24_ = old_tio;
	tcsetattr (STDIN_FILENO, TCSANOW, &_tmp24_);
	result = 0;
	_lcd_player_unref0 (player);
	_g_option_context_free0 (opt_context);
	return result;
}


int main (int argc, char ** argv) {
	return _vala_main (argv, argc);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



