/*   FILE: transitions.vala -- Code to handle state transitions in response to inputs
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 27 November 2013
 *
 * Copyright (c) 2013 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

class Transitions {
	Stack<State> stateStack;

	public Transitions(InputOutput io, Stack stateStack) {
		io.stop.connect(() => { do_stop(); });
		io.seekback.connect(() => { do_seekback(); });
		io.pauseplay.connect(() => { do_pauseplay(); });
		io.seekforward.connect(() => { do_seekforward(); });
		io.escape.connect(() => { do_escape(); });
		io.left.connect(() => { do_left(); });
		io.right.connect(() => { do_right(); });
		io.select.connect(() => { do_select(); });

		this.stateStack = stateStack;
	}

	private void do_stop () {
		stateStack.peek ().stop ();
	}

	private void do_seekback () {
		stateStack.peek ().seekback ();
	}

	private void do_pauseplay () {
		stateStack.peek ().pauseplay ();
	}

	private void do_seekforward () {
		stateStack.peek ().seekforward ();
	}

	private void do_escape () {
		if (stateStack.size () > 1) {
			stateStack.pop ();
		}
		stateStack.peek ().print_selected ();
	}

	private void do_left () {
		stateStack.peek ().previous ();
	}

	private void do_right () {
		stateStack.peek ().next ();
	}

	private void do_select () {
		// Peek at top, call transition, push value returned (only push if new state).
		State next = stateStack.peek ().transition ();
		if (stateStack.peek () != next) {
			stateStack.push (next);
		}
	}
}
