// Copyright (c) Facebook, Inc. and its affiliates.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "PrintSubscriber.h"
#include <folly/Memory.h>
#include <folly/io/IOBufQueue.h>
#include <glog/logging.h>

namespace rsocket {

PrintSubscriber::~PrintSubscriber() {
  LOG(INFO) << "~PrintSubscriber " << this;
}

void PrintSubscriber::onSubscribe(
    std::shared_ptr<yarpl::flowable::Subscription> subscription) noexcept {
  LOG(INFO) << "PrintSubscriber " << this << " onSubscribe";
  subscription->request(std::numeric_limits<int32_t>::max());
}

void PrintSubscriber::onNext(Payload element) noexcept {
  LOG(INFO) << "PrintSubscriber " << this << " onNext " << element;
}

void PrintSubscriber::onComplete() noexcept {
  LOG(INFO) << "PrintSubscriber " << this << " onComplete";
}

void PrintSubscriber::onError(folly::exception_wrapper ex) noexcept {
  LOG(INFO) << "PrintSubscriber " << this << " onError " << ex;
}
} // namespace rsocket
