.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_file_set_mtime.mdoc -- set mtime for file in zip
.\" Copyright (C) 2014-2020 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP files.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_FILE_SET_MTIME" "3" "August 24, 2020" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_file_set_dostime\fR,
\fBzip_file_set_mtime\fR
\- set last modification time (mtime) for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.br
.PD 0
.HP 4n
\fBzip_file_set_dostime\fR(\fIzip_t\ *archive\fR, \fIzip_uint64_t\ index\fR, \fIzip_uint16_t\ dostime\fR, \fIzip_uint16_t\ dosdate\fR, \fIzip_flags_t\ flags\fR);
.PD
.PP
\fIint\fR
.br
.PD 0
.HP 4n
\fBzip_file_set_mtime\fR(\fIzip_t\ *archive\fR, \fIzip_uint64_t\ index\fR, \fItime_t\ mtime\fR, \fIzip_flags_t\ flags\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_file_set_mtime\fR()
function sets the last modification time (mtime) for the file at
position
\fIindex\fR
in the zip archive to
\fImtime\fR.
Currently, no support for any
\fIflags\fR
is implemented.
.PP
In the zip archive, the time and date are saved as two 16-bit integers.
To set the values directly, call the
\fBzip_file_set_dostime\fR()
function.
The values of the time bytes are defined as follows:
.RS 6n
.TP 7n
0-4
seconds divided by two (1-2 = 1, 3-4 = 2, ...)
.TP 7n
5-10
minute (0-59)
.TP 7n
11-15
hour (0-23)
.RE
.PP
The values of the date bytes are defined as follows:
.RS 6n
.TP 7n
0-4
day of the month (1-31)
.TP 7n
5-8
month (January = 1, February = 2, ...)
.TP 7n
9-15
year offset from 1980 (1980 = 0, 1981 = 1, ...)
.RE
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error information in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_file_set_dostime\fR()
and
\fBzip_file_set_mtime\fR()
fail if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIindex\fR
is not a valid file index in
\fIarchive\fR.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.TP 19n
[\fRZIP_ER_RDONLY\fR]
The
\fIarchive\fR
was opened in read-only mode.
.SH "SEE ALSO"
libzip(3),
zip_stat(3)
.SH "HISTORY"
\fBzip_file_set_mtime\fR()
was added in libzip 1.0.
\fBzip_file_set_dostime\fR()
was added in libzip 1.6.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
.SH "CAVEATS"
Following historical practice, the
\fBzip_file_set_mtime\fR()
function translates the time from the zip archive into the local time
zone.
If you want to avoid this, use the
\fBzip_file_set_dostime\fR()
function instead.
