package geekbang

import (
	"testing"

	"github.com/iawia002/lux/extractors/types"
	"github.com/iawia002/lux/test"
)

func TestDownload(t *testing.T) {
	tests := []struct {
		name string
		args test.Args
	}{
		{
			name: "normal test",
			args: test.Args{
				URL:   "https://time.geekbang.org/course/detail/190-97203",
				Title: "02 | 内容综述 - 玩转webpack",
				Size:  10752472,
			},
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			data, err := New().Extract(tt.args.URL, types.Options{})
			test.CheckError(t, err)
			test.Check(t, tt.args, data[0])
		})
	}
}
