#ifndef _miax_h
#define _miax_h

/*
* Miax
*
*  Copyright (C) 2004 by Ubaldo Porcheddu <ubaldo@eja.it>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

int 	debug=0;
int	status=0;
int 	bt; //bluetooth
int	m=0; //modem
char	number[1024];

int audio_init(char *dev, int compression) { 
	(bt) ?  bt_audio_init(dev, compression) : oss_audio_init(dev, compression); 
	}

int audio_open() { 
	(bt) ?  bt_audio_open() : oss_audio_open(); 
	}

int audio_out(struct iaxc_call *call, void *encoded) { 
	(bt) ?  bt_audio_out(call,encoded) : oss_audio_out(call,encoded) ; 
	}

int audio_in(struct iaxc_call *call) { 
	(bt) ?  bt_audio_in(call) : oss_audio_in(call) ; 
	}

int audio_close () { 
	(bt) ?  bt_audio_close() : oss_audio_close() ; 
	}

int modem_init(char *dev) { 
	(bt) ?  bt_modem_init(dev) : tty_modem_init(dev) ; 
	}

int modem(char *val) { 
	char tmp[1024];
	
	(bt) ?  bt_modem(val, tmp) : tty_modem(val, tmp) ; 
	}

int modem_close() { 
	(bt) ?  bt_modem_close() : tty_modem_close() ; 
	}

int modem_loop(int status, char *number) { 
	if (bt) { return bt_modem_loop(status, number); } 
	else { return tty_modem_loop(status, number); } 
	}

int miax_loop(int status, char *number) {
	if (m > 0 && bt > 0) { return bt_modem_loop(status, number); }
	if (m > 0 && bt == 0) { return tty_modem_loop(status, number); }
	if (m == 0) { 
		printf("\nMiax console.\t[h] to hangup or quit\n");
		return console_loop(status, number); 
		}
	}
#endif
