/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.shared;

import java.io.InputStream;
import java.util.Properties;

public class AppID {
    private static AppID m_appID = null;
    private Properties m_props = new Properties();

    private AppID() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/application.properties");
            this.m_props.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static synchronized AppID getAppID() {
        if (m_appID == null) {
            m_appID = new AppID();
        }
        return m_appID;
    }

    public String getProperty(String string) {
        return this.m_props.getProperty(string, "<" + string + ">");
    }

    public String getAppNameVersion() {
        return this.getAppName() + " V" + this.getFullVersion();
    }

    public String getAppName() {
        return this.getProperty("app.name");
    }

    public String getBuildDate() {
        return this.getProperty("build.date");
    }

    public String getBuildTick() {
        return this.getProperty("build.tick");
    }

    public String getVersion() {
        return this.getProperty("app.version");
    }

    public String getFullVersion() {
        return this.getVersion() + "-" + this.getBuildTick();
    }

    public String getCopyright() {
        return this.getProperty("app.copyright");
    }

    public String getLocURL() {
        return this.getProperty("app.locURL");
    }

    public String getHelpURL() {
        return this.getProperty("app.helpURL");
    }
}

