/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology	5th	Rd.
 * Science-based Industrial	Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2004, Ralink Technology, Inc.
 *
 * All rights reserved.	Ralink's source	code is	an unpublished work	and	the
 * use of a	copyright notice does not imply	otherwise. This	source code
 * contains	confidential trade secret material of Ralink Tech. Any attemp
 * or participation	in deciphering,	decoding, reverse engineering or in	any
 * way altering	the	source code	is stricitly prohibited, unless	the	prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	ral_omac.h

	Abstract:
	Ralink Wireless Chip RAL MAC related definition & structures

	Revision History:
	Who			When		  What
	--------	----------	  ----------------------------------------------
*/

#ifndef __RAL_OMAC_H__
#define __RAL_OMAC_H__

#include "rtmp_type.h"

#include "mac_ral/omac/ral_omac_txwi.h"
#include "mac_ral/omac/ral_omac_rxwi.h"

/*
	TXINFO
*/

/*
	TXINFO fields defintion:
	
	USBDMATxPktLen[b0~b14]:
		Total bytes of all sub-frame. ONLY for USB bulk Aggregation
	IPOffset[b15~b18]:
		Start byte of IP packet. The base address is from TXINFO.
		0: header will be parsed by hardware.
		This field is like backdoor.
		For AMSDU, this field is useless

	TCPOffset[b19~b23]:
		Start byte of TCP packet from IP packet The base address is IP header.
		0: header will be parsed by hardware.
		This field is like backdoor.
		For AMSDU, this field is useless

	WIV[b24]:
		Wireless Info Valid. 
		1: if Driver already fill WI
		0: if DMA needs to copy WI to correctposition

	QSEL[b25~b26]:
		Select on-chip FIFO ID for 2nd-stage output scheduler.
		0:MGMT, 1:HCCA 2:EDCA

	SwUseLastRound[b27]:
		Software used for USB-based chipset, reserved for other interfaces.

	uso[b28]:
		UDP checksum enable. 
		1: indicate this packet needs to do UDP checksum

	cso[b29]:
		Checksum offload. 
		1: indicate this packet needs to do checksum

	USBDMANextVLD[b30]:
		Used for USB-based chipset, reserved for other interfaces.
		Used ONLY in USB bulk Aggregation, host driver info DMA current 
		frame is not he last frame in current Tx queue

	USBDMATxburst[b31]:
		force DMA transmit frame from current selected endpoint
*/
#ifdef RT_BIG_ENDIAN
typedef	struct _TXINFO_OMAC {
	unsigned int USBDMATxburst:1;
	unsigned int USBDMANextVLD:1;
	unsigned int cso:1;
	unsigned int uso:1;
#ifdef USB_BULK_BUF_ALIGMENT
	unsigned int bFragLasAlignmentsectiontRound:1;
#else
	unsigned int SwUseLastRound:1;
#endif /* USB_BULK_BUF_ALIGMENT */
	unsigned int QSEL:2;
	unsigned int WIV:1;
	unsigned int TCPOffset:5;
	unsigned int IPOffset:4;
	unsigned int USBDMATxPktLen:15;
}TXINFO_OMAC;
#else
typedef	struct _TXINFO_OMAC {
	unsigned int USBDMATxPktLen:15;
	unsigned int IPOffset:4;
	unsigned int TCPOffset:5;
	unsigned int WIV:1;
	unsigned int QSEL:2;
#ifdef USB_BULK_BUF_ALIGMENT
	unsigned int bFragLasAlignmentsectiontRound:1;
#else
	unsigned int SwUseLastRound:1;
#endif /* USB_BULK_BUF_ALIGMENT */
	unsigned int uso:1;
	unsigned int cso:1;
	unsigned int USBDMANextVLD:1;
	unsigned int USBDMATxburst:1;
}TXINFO_OMAC;
#endif /* RT_BIG_ENDIAN */


#define TxInfoWIV			txinfo_omac.WIV
#define TxInfoQSEL			txinfo_omac.QSEL
#define TxInfoPktLen			txinfo_omac.USBDMATxPktLen
#define TxInfoSwLstRnd		txinfo_omac.SwUseLastRound
#define TxInfoUDMATxburst	txinfo_omac.USBDMATxburst
#define TxInfoUDMANextVld	txinfo_omac.USBDMANextVLD
#define TxInfoIPOffset		txinfo_omac.IPOffset
#define TxInfoTCPOffset		txinfo_omac.TCPOffset
#define TxInfoCSO			txinfo_omac.cso
#define TxInfoUSO			txinfo_omac.uso




/* ================================================================================= */
/* Register format */
/* ================================================================================= */

#define GPIO_CTRL_CFG	0x0228
#define MCU_CMD_CFG	0x022c


#define PAIRWISE_KEY_TABLE_BASE     0x4000      /* 32-byte * 256-entry =  -byte */
#define HW_KEY_ENTRY_SIZE           0x20

#define PAIRWISE_IVEIV_TABLE_BASE     0x6000      /* 8-byte * 256-entry =  -byte */
#define MAC_IVEIV_TABLE_BASE     0x6000      /* 8-byte * 256-entry =  -byte */
#define HW_IVEIV_ENTRY_SIZE   8

#define MAC_WCID_ATTRIBUTE_BASE     0x6800      /* 4-byte * 256-entry =  -byte */
#define HW_WCID_ATTRI_SIZE   4

#define SHARED_KEY_TABLE_BASE       0x6c00      /* 32-byte * 16-entry = 512-byte */
#define SHARED_KEY_MODE_BASE       0x7000      /* 32-byte * 16-entry = 512-byte */

#define HW_SHARED_KEY_MODE_SIZE   4
#define SHAREDKEYTABLE			0
#define PAIRWISEKEYTABLE			1

/* This resgiser is ONLY be supported for RT3883 or later.
   It conflicted with BCN#0 offset of previous chipset. */
#define WAPI_PN_TABLE_BASE		0x7800		
#define WAPI_PN_ENTRY_SIZE   		8

#endif /* __RAL_OMAC_H__ */

