"""Autogenerated source file list for QUICHE Bazel build."""

protobuf = [
    "quic/core/proto/cached_network_parameters.proto",
    "quic/core/proto/crypto_server_config.proto",
    "quic/core/proto/source_address_token.proto",
]
protobuf_test_support = [
    "quic/test_tools/send_algorithm_test_result.proto",
]
quiche_core_hdrs = [
    "balsa/balsa_enums.h",
    "balsa/balsa_frame.h",
    "balsa/balsa_headers.h",
    "balsa/balsa_visitor_interface.h",
    "balsa/framer_interface.h",
    "balsa/header_api.h",
    "balsa/header_properties.h",
    "balsa/http_validation_policy.h",
    "balsa/noop_balsa_visitor.h",
    "balsa/simple_buffer.h",
    "balsa/standard_header_map.h",
    "common/platform/api/quiche_bug_tracker.h",
    "common/platform/api/quiche_client_stats.h",
    "common/platform/api/quiche_containers.h",
    "common/platform/api/quiche_export.h",
    "common/platform/api/quiche_flag_utils.h",
    "common/platform/api/quiche_flags.h",
    "common/platform/api/quiche_header_policy.h",
    "common/platform/api/quiche_hostname_utils.h",
    "common/platform/api/quiche_iovec.h",
    "common/platform/api/quiche_logging.h",
    "common/platform/api/quiche_lower_case_string.h",
    "common/platform/api/quiche_mem_slice.h",
    "common/platform/api/quiche_mutex.h",
    "common/platform/api/quiche_prefetch.h",
    "common/platform/api/quiche_reference_counted.h",
    "common/platform/api/quiche_server_stats.h",
    "common/platform/api/quiche_stack_trace.h",
    "common/platform/api/quiche_testvalue.h",
    "common/platform/api/quiche_thread.h",
    "common/platform/api/quiche_thread_local.h",
    "common/platform/api/quiche_time_utils.h",
    "common/platform/api/quiche_url_utils.h",
    "common/print_elements.h",
    "common/quiche_buffer_allocator.h",
    "common/quiche_circular_deque.h",
    "common/quiche_data_reader.h",
    "common/quiche_data_writer.h",
    "common/quiche_endian.h",
    "common/quiche_linked_hash_map.h",
    "common/quiche_mem_slice_storage.h",
    "common/quiche_text_utils.h",
    "common/simple_buffer_allocator.h",
    "common/structured_headers.h",
    "http2/adapter/data_source.h",
    "http2/adapter/event_forwarder.h",
    "http2/adapter/header_validator.h",
    "http2/adapter/header_validator_base.h",
    "http2/adapter/http2_adapter.h",
    "http2/adapter/http2_protocol.h",
    "http2/adapter/http2_session.h",
    "http2/adapter/http2_util.h",
    "http2/adapter/http2_visitor_interface.h",
    "http2/adapter/noop_header_validator.h",
    "http2/adapter/oghttp2_adapter.h",
    "http2/adapter/oghttp2_session.h",
    "http2/adapter/oghttp2_util.h",
    "http2/adapter/window_manager.h",
    "http2/core/http2_trace_logging.h",
    "http2/core/priority_write_scheduler.h",
    "http2/core/write_scheduler.h",
    "http2/decoder/decode_buffer.h",
    "http2/decoder/decode_http2_structures.h",
    "http2/decoder/decode_status.h",
    "http2/decoder/frame_decoder_state.h",
    "http2/decoder/http2_frame_decoder.h",
    "http2/decoder/http2_frame_decoder_listener.h",
    "http2/decoder/http2_structure_decoder.h",
    "http2/decoder/payload_decoders/altsvc_payload_decoder.h",
    "http2/decoder/payload_decoders/continuation_payload_decoder.h",
    "http2/decoder/payload_decoders/data_payload_decoder.h",
    "http2/decoder/payload_decoders/goaway_payload_decoder.h",
    "http2/decoder/payload_decoders/headers_payload_decoder.h",
    "http2/decoder/payload_decoders/ping_payload_decoder.h",
    "http2/decoder/payload_decoders/priority_payload_decoder.h",
    "http2/decoder/payload_decoders/priority_update_payload_decoder.h",
    "http2/decoder/payload_decoders/push_promise_payload_decoder.h",
    "http2/decoder/payload_decoders/rst_stream_payload_decoder.h",
    "http2/decoder/payload_decoders/settings_payload_decoder.h",
    "http2/decoder/payload_decoders/unknown_payload_decoder.h",
    "http2/decoder/payload_decoders/window_update_payload_decoder.h",
    "http2/hpack/decoder/hpack_block_decoder.h",
    "http2/hpack/decoder/hpack_decoder.h",
    "http2/hpack/decoder/hpack_decoder_listener.h",
    "http2/hpack/decoder/hpack_decoder_state.h",
    "http2/hpack/decoder/hpack_decoder_string_buffer.h",
    "http2/hpack/decoder/hpack_decoder_tables.h",
    "http2/hpack/decoder/hpack_decoding_error.h",
    "http2/hpack/decoder/hpack_entry_decoder.h",
    "http2/hpack/decoder/hpack_entry_decoder_listener.h",
    "http2/hpack/decoder/hpack_entry_type_decoder.h",
    "http2/hpack/decoder/hpack_string_decoder.h",
    "http2/hpack/decoder/hpack_string_decoder_listener.h",
    "http2/hpack/decoder/hpack_whole_entry_buffer.h",
    "http2/hpack/decoder/hpack_whole_entry_listener.h",
    "http2/hpack/http2_hpack_constants.h",
    "http2/hpack/huffman/hpack_huffman_decoder.h",
    "http2/hpack/huffman/hpack_huffman_encoder.h",
    "http2/hpack/huffman/huffman_spec_tables.h",
    "http2/hpack/varint/hpack_varint_decoder.h",
    "http2/hpack/varint/hpack_varint_encoder.h",
    "http2/http2_constants.h",
    "http2/http2_structures.h",
    "quic/core/chlo_extractor.h",
    "quic/core/congestion_control/bandwidth_sampler.h",
    "quic/core/congestion_control/bbr2_drain.h",
    "quic/core/congestion_control/bbr2_misc.h",
    "quic/core/congestion_control/bbr2_probe_bw.h",
    "quic/core/congestion_control/bbr2_probe_rtt.h",
    "quic/core/congestion_control/bbr2_sender.h",
    "quic/core/congestion_control/bbr2_startup.h",
    "quic/core/congestion_control/bbr_sender.h",
    "quic/core/congestion_control/cubic_bytes.h",
    "quic/core/congestion_control/general_loss_algorithm.h",
    "quic/core/congestion_control/hybrid_slow_start.h",
    "quic/core/congestion_control/loss_detection_interface.h",
    "quic/core/congestion_control/pacing_sender.h",
    "quic/core/congestion_control/prr_sender.h",
    "quic/core/congestion_control/rtt_stats.h",
    "quic/core/congestion_control/send_algorithm_interface.h",
    "quic/core/congestion_control/tcp_cubic_sender_bytes.h",
    "quic/core/congestion_control/uber_loss_algorithm.h",
    "quic/core/congestion_control/windowed_filter.h",
    "quic/core/crypto/aead_base_decrypter.h",
    "quic/core/crypto/aead_base_encrypter.h",
    "quic/core/crypto/aes_128_gcm_12_decrypter.h",
    "quic/core/crypto/aes_128_gcm_12_encrypter.h",
    "quic/core/crypto/aes_128_gcm_decrypter.h",
    "quic/core/crypto/aes_128_gcm_encrypter.h",
    "quic/core/crypto/aes_256_gcm_decrypter.h",
    "quic/core/crypto/aes_256_gcm_encrypter.h",
    "quic/core/crypto/aes_base_decrypter.h",
    "quic/core/crypto/aes_base_encrypter.h",
    "quic/core/crypto/boring_utils.h",
    "quic/core/crypto/cert_compressor.h",
    "quic/core/crypto/certificate_util.h",
    "quic/core/crypto/certificate_view.h",
    "quic/core/crypto/chacha20_poly1305_decrypter.h",
    "quic/core/crypto/chacha20_poly1305_encrypter.h",
    "quic/core/crypto/chacha20_poly1305_tls_decrypter.h",
    "quic/core/crypto/chacha20_poly1305_tls_encrypter.h",
    "quic/core/crypto/chacha_base_decrypter.h",
    "quic/core/crypto/chacha_base_encrypter.h",
    "quic/core/crypto/channel_id.h",
    "quic/core/crypto/client_proof_source.h",
    "quic/core/crypto/crypto_framer.h",
    "quic/core/crypto/crypto_handshake.h",
    "quic/core/crypto/crypto_handshake_message.h",
    "quic/core/crypto/crypto_message_parser.h",
    "quic/core/crypto/crypto_protocol.h",
    "quic/core/crypto/crypto_secret_boxer.h",
    "quic/core/crypto/crypto_utils.h",
    "quic/core/crypto/curve25519_key_exchange.h",
    "quic/core/crypto/key_exchange.h",
    "quic/core/crypto/null_decrypter.h",
    "quic/core/crypto/null_encrypter.h",
    "quic/core/crypto/p256_key_exchange.h",
    "quic/core/crypto/proof_source.h",
    "quic/core/crypto/proof_source_x509.h",
    "quic/core/crypto/proof_verifier.h",
    "quic/core/crypto/quic_client_session_cache.h",
    "quic/core/crypto/quic_compressed_certs_cache.h",
    "quic/core/crypto/quic_crypter.h",
    "quic/core/crypto/quic_crypto_client_config.h",
    "quic/core/crypto/quic_crypto_proof.h",
    "quic/core/crypto/quic_crypto_server_config.h",
    "quic/core/crypto/quic_decrypter.h",
    "quic/core/crypto/quic_encrypter.h",
    "quic/core/crypto/quic_hkdf.h",
    "quic/core/crypto/quic_random.h",
    "quic/core/crypto/tls_client_connection.h",
    "quic/core/crypto/tls_connection.h",
    "quic/core/crypto/tls_server_connection.h",
    "quic/core/crypto/transport_parameters.h",
    "quic/core/crypto/web_transport_fingerprint_proof_verifier.h",
    "quic/core/frames/quic_ack_frame.h",
    "quic/core/frames/quic_ack_frequency_frame.h",
    "quic/core/frames/quic_blocked_frame.h",
    "quic/core/frames/quic_connection_close_frame.h",
    "quic/core/frames/quic_crypto_frame.h",
    "quic/core/frames/quic_frame.h",
    "quic/core/frames/quic_goaway_frame.h",
    "quic/core/frames/quic_handshake_done_frame.h",
    "quic/core/frames/quic_inlined_frame.h",
    "quic/core/frames/quic_max_streams_frame.h",
    "quic/core/frames/quic_message_frame.h",
    "quic/core/frames/quic_mtu_discovery_frame.h",
    "quic/core/frames/quic_new_connection_id_frame.h",
    "quic/core/frames/quic_new_token_frame.h",
    "quic/core/frames/quic_padding_frame.h",
    "quic/core/frames/quic_path_challenge_frame.h",
    "quic/core/frames/quic_path_response_frame.h",
    "quic/core/frames/quic_ping_frame.h",
    "quic/core/frames/quic_retire_connection_id_frame.h",
    "quic/core/frames/quic_rst_stream_frame.h",
    "quic/core/frames/quic_stop_sending_frame.h",
    "quic/core/frames/quic_stop_waiting_frame.h",
    "quic/core/frames/quic_stream_frame.h",
    "quic/core/frames/quic_streams_blocked_frame.h",
    "quic/core/frames/quic_window_update_frame.h",
    "quic/core/handshaker_delegate_interface.h",
    "quic/core/http/capsule.h",
    "quic/core/http/http_constants.h",
    "quic/core/http/http_decoder.h",
    "quic/core/http/http_encoder.h",
    "quic/core/http/http_frames.h",
    "quic/core/http/quic_client_promised_info.h",
    "quic/core/http/quic_client_push_promise_index.h",
    "quic/core/http/quic_header_list.h",
    "quic/core/http/quic_headers_stream.h",
    "quic/core/http/quic_receive_control_stream.h",
    "quic/core/http/quic_send_control_stream.h",
    "quic/core/http/quic_server_initiated_spdy_stream.h",
    "quic/core/http/quic_server_session_base.h",
    "quic/core/http/quic_spdy_client_session.h",
    "quic/core/http/quic_spdy_client_session_base.h",
    "quic/core/http/quic_spdy_client_stream.h",
    "quic/core/http/quic_spdy_server_stream_base.h",
    "quic/core/http/quic_spdy_session.h",
    "quic/core/http/quic_spdy_stream.h",
    "quic/core/http/quic_spdy_stream_body_manager.h",
    "quic/core/http/spdy_server_push_utils.h",
    "quic/core/http/spdy_utils.h",
    "quic/core/http/web_transport_http3.h",
    "quic/core/http/web_transport_stream_adapter.h",
    "quic/core/legacy_quic_stream_id_manager.h",
    "quic/core/packet_number_indexed_queue.h",
    "quic/core/proto/cached_network_parameters_proto.h",
    "quic/core/proto/crypto_server_config_proto.h",
    "quic/core/proto/source_address_token_proto.h",
    "quic/core/qpack/qpack_blocking_manager.h",
    "quic/core/qpack/qpack_decoded_headers_accumulator.h",
    "quic/core/qpack/qpack_decoder.h",
    "quic/core/qpack/qpack_decoder_stream_receiver.h",
    "quic/core/qpack/qpack_decoder_stream_sender.h",
    "quic/core/qpack/qpack_encoder.h",
    "quic/core/qpack/qpack_encoder_stream_receiver.h",
    "quic/core/qpack/qpack_encoder_stream_sender.h",
    "quic/core/qpack/qpack_header_table.h",
    "quic/core/qpack/qpack_index_conversions.h",
    "quic/core/qpack/qpack_instruction_decoder.h",
    "quic/core/qpack/qpack_instruction_encoder.h",
    "quic/core/qpack/qpack_instructions.h",
    "quic/core/qpack/qpack_progressive_decoder.h",
    "quic/core/qpack/qpack_receive_stream.h",
    "quic/core/qpack/qpack_required_insert_count.h",
    "quic/core/qpack/qpack_send_stream.h",
    "quic/core/qpack/qpack_static_table.h",
    "quic/core/qpack/qpack_stream_receiver.h",
    "quic/core/qpack/qpack_stream_sender_delegate.h",
    "quic/core/qpack/value_splitting_header_list.h",
    "quic/core/quic_ack_listener_interface.h",
    "quic/core/quic_alarm.h",
    "quic/core/quic_alarm_factory.h",
    "quic/core/quic_arena_scoped_ptr.h",
    "quic/core/quic_bandwidth.h",
    "quic/core/quic_blocked_writer_interface.h",
    "quic/core/quic_buffered_packet_store.h",
    "quic/core/quic_chaos_protector.h",
    "quic/core/quic_clock.h",
    "quic/core/quic_coalesced_packet.h",
    "quic/core/quic_config.h",
    "quic/core/quic_connection.h",
    "quic/core/quic_connection_context.h",
    "quic/core/quic_connection_id.h",
    "quic/core/quic_connection_id_manager.h",
    "quic/core/quic_connection_stats.h",
    "quic/core/quic_constants.h",
    "quic/core/quic_control_frame_manager.h",
    "quic/core/quic_crypto_client_handshaker.h",
    "quic/core/quic_crypto_client_stream.h",
    "quic/core/quic_crypto_handshaker.h",
    "quic/core/quic_crypto_server_stream.h",
    "quic/core/quic_crypto_server_stream_base.h",
    "quic/core/quic_crypto_stream.h",
    "quic/core/quic_data_reader.h",
    "quic/core/quic_data_writer.h",
    "quic/core/quic_datagram_queue.h",
    "quic/core/quic_default_clock.h",
    "quic/core/quic_default_connection_helper.h",
    "quic/core/quic_dispatcher.h",
    "quic/core/quic_error_codes.h",
    "quic/core/quic_flags_list.h",
    "quic/core/quic_flow_controller.h",
    "quic/core/quic_framer.h",
    "quic/core/quic_idle_network_detector.h",
    "quic/core/quic_interval.h",
    "quic/core/quic_interval_deque.h",
    "quic/core/quic_interval_set.h",
    "quic/core/quic_legacy_version_encapsulator.h",
    "quic/core/quic_lru_cache.h",
    "quic/core/quic_mtu_discovery.h",
    "quic/core/quic_network_blackhole_detector.h",
    "quic/core/quic_one_block_arena.h",
    "quic/core/quic_packet_creator.h",
    "quic/core/quic_packet_number.h",
    "quic/core/quic_packet_writer.h",
    "quic/core/quic_packet_writer_wrapper.h",
    "quic/core/quic_packets.h",
    "quic/core/quic_path_validator.h",
    "quic/core/quic_ping_manager.h",
    "quic/core/quic_process_packet_interface.h",
    "quic/core/quic_protocol_flags_list.h",
    "quic/core/quic_received_packet_manager.h",
    "quic/core/quic_sent_packet_manager.h",
    "quic/core/quic_server_id.h",
    "quic/core/quic_session.h",
    "quic/core/quic_socket_address_coder.h",
    "quic/core/quic_stream.h",
    "quic/core/quic_stream_frame_data_producer.h",
    "quic/core/quic_stream_id_manager.h",
    "quic/core/quic_stream_send_buffer.h",
    "quic/core/quic_stream_sequencer.h",
    "quic/core/quic_stream_sequencer_buffer.h",
    "quic/core/quic_sustained_bandwidth_recorder.h",
    "quic/core/quic_tag.h",
    "quic/core/quic_time.h",
    "quic/core/quic_time_accumulator.h",
    "quic/core/quic_time_wait_list_manager.h",
    "quic/core/quic_trace_visitor.h",
    "quic/core/quic_transmission_info.h",
    "quic/core/quic_types.h",
    "quic/core/quic_unacked_packet_map.h",
    "quic/core/quic_utils.h",
    "quic/core/quic_version_manager.h",
    "quic/core/quic_versions.h",
    "quic/core/quic_write_blocked_list.h",
    "quic/core/session_notifier_interface.h",
    "quic/core/stream_delegate_interface.h",
    "quic/core/tls_chlo_extractor.h",
    "quic/core/tls_client_handshaker.h",
    "quic/core/tls_handshaker.h",
    "quic/core/tls_server_handshaker.h",
    "quic/core/uber_quic_stream_id_manager.h",
    "quic/core/uber_received_packet_manager.h",
    "quic/core/web_transport_interface.h",
    "quic/platform/api/quic_bug_tracker.h",
    "quic/platform/api/quic_client_stats.h",
    "quic/platform/api/quic_export.h",
    "quic/platform/api/quic_exported_stats.h",
    "quic/platform/api/quic_flag_utils.h",
    "quic/platform/api/quic_flags.h",
    "quic/platform/api/quic_hostname_utils.h",
    "quic/platform/api/quic_ip_address.h",
    "quic/platform/api/quic_ip_address_family.h",
    "quic/platform/api/quic_logging.h",
    "quic/platform/api/quic_mutex.h",
    "quic/platform/api/quic_server_stats.h",
    "quic/platform/api/quic_socket_address.h",
    "quic/platform/api/quic_stack_trace.h",
    "quic/platform/api/quic_testvalue.h",
    "quic/platform/api/quic_thread.h",
    "spdy/core/array_output_buffer.h",
    "spdy/core/header_byte_listener_interface.h",
    "spdy/core/hpack/hpack_constants.h",
    "spdy/core/hpack/hpack_decoder_adapter.h",
    "spdy/core/hpack/hpack_encoder.h",
    "spdy/core/hpack/hpack_entry.h",
    "spdy/core/hpack/hpack_header_table.h",
    "spdy/core/hpack/hpack_output_stream.h",
    "spdy/core/hpack/hpack_static_table.h",
    "spdy/core/http2_frame_decoder_adapter.h",
    "spdy/core/http2_header_block_hpack_listener.h",
    "spdy/core/metadata_extension.h",
    "spdy/core/no_op_headers_handler.h",
    "spdy/core/recording_headers_handler.h",
    "spdy/core/spdy_alt_svc_wire_format.h",
    "spdy/core/spdy_bitmasks.h",
    "spdy/core/spdy_frame_builder.h",
    "spdy/core/spdy_framer.h",
    "spdy/core/spdy_header_block.h",
    "spdy/core/spdy_header_storage.h",
    "spdy/core/spdy_headers_handler_interface.h",
    "spdy/core/spdy_intrusive_list.h",
    "spdy/core/spdy_no_op_visitor.h",
    "spdy/core/spdy_pinnable_buffer_piece.h",
    "spdy/core/spdy_prefixed_buffer_reader.h",
    "spdy/core/spdy_protocol.h",
    "spdy/core/spdy_simple_arena.h",
    "spdy/core/zero_copy_output_buffer.h",
]
quiche_core_srcs = [
    "balsa/balsa_enums.cc",
    "balsa/balsa_frame.cc",
    "balsa/balsa_headers.cc",
    "balsa/header_properties.cc",
    "balsa/http_validation_policy.cc",
    "balsa/simple_buffer.cc",
    "balsa/standard_header_map.cc",
    "common/platform/api/quiche_hostname_utils.cc",
    "common/platform/api/quiche_mutex.cc",
    "common/quiche_buffer_allocator.cc",
    "common/quiche_data_reader.cc",
    "common/quiche_data_writer.cc",
    "common/quiche_mem_slice_storage.cc",
    "common/quiche_text_utils.cc",
    "common/simple_buffer_allocator.cc",
    "common/structured_headers.cc",
    "http2/adapter/event_forwarder.cc",
    "http2/adapter/header_validator.cc",
    "http2/adapter/http2_protocol.cc",
    "http2/adapter/http2_util.cc",
    "http2/adapter/noop_header_validator.cc",
    "http2/adapter/oghttp2_adapter.cc",
    "http2/adapter/oghttp2_session.cc",
    "http2/adapter/oghttp2_util.cc",
    "http2/adapter/window_manager.cc",
    "http2/core/http2_trace_logging.cc",
    "http2/decoder/decode_buffer.cc",
    "http2/decoder/decode_http2_structures.cc",
    "http2/decoder/decode_status.cc",
    "http2/decoder/frame_decoder_state.cc",
    "http2/decoder/http2_frame_decoder.cc",
    "http2/decoder/http2_frame_decoder_listener.cc",
    "http2/decoder/http2_structure_decoder.cc",
    "http2/decoder/payload_decoders/altsvc_payload_decoder.cc",
    "http2/decoder/payload_decoders/continuation_payload_decoder.cc",
    "http2/decoder/payload_decoders/data_payload_decoder.cc",
    "http2/decoder/payload_decoders/goaway_payload_decoder.cc",
    "http2/decoder/payload_decoders/headers_payload_decoder.cc",
    "http2/decoder/payload_decoders/ping_payload_decoder.cc",
    "http2/decoder/payload_decoders/priority_payload_decoder.cc",
    "http2/decoder/payload_decoders/priority_update_payload_decoder.cc",
    "http2/decoder/payload_decoders/push_promise_payload_decoder.cc",
    "http2/decoder/payload_decoders/rst_stream_payload_decoder.cc",
    "http2/decoder/payload_decoders/settings_payload_decoder.cc",
    "http2/decoder/payload_decoders/unknown_payload_decoder.cc",
    "http2/decoder/payload_decoders/window_update_payload_decoder.cc",
    "http2/hpack/decoder/hpack_block_decoder.cc",
    "http2/hpack/decoder/hpack_decoder.cc",
    "http2/hpack/decoder/hpack_decoder_listener.cc",
    "http2/hpack/decoder/hpack_decoder_state.cc",
    "http2/hpack/decoder/hpack_decoder_string_buffer.cc",
    "http2/hpack/decoder/hpack_decoder_tables.cc",
    "http2/hpack/decoder/hpack_decoding_error.cc",
    "http2/hpack/decoder/hpack_entry_decoder.cc",
    "http2/hpack/decoder/hpack_entry_decoder_listener.cc",
    "http2/hpack/decoder/hpack_entry_type_decoder.cc",
    "http2/hpack/decoder/hpack_string_decoder.cc",
    "http2/hpack/decoder/hpack_string_decoder_listener.cc",
    "http2/hpack/decoder/hpack_whole_entry_buffer.cc",
    "http2/hpack/decoder/hpack_whole_entry_listener.cc",
    "http2/hpack/http2_hpack_constants.cc",
    "http2/hpack/huffman/hpack_huffman_decoder.cc",
    "http2/hpack/huffman/hpack_huffman_encoder.cc",
    "http2/hpack/huffman/huffman_spec_tables.cc",
    "http2/hpack/varint/hpack_varint_decoder.cc",
    "http2/hpack/varint/hpack_varint_encoder.cc",
    "http2/http2_constants.cc",
    "http2/http2_structures.cc",
    "quic/core/chlo_extractor.cc",
    "quic/core/congestion_control/bandwidth_sampler.cc",
    "quic/core/congestion_control/bbr2_drain.cc",
    "quic/core/congestion_control/bbr2_misc.cc",
    "quic/core/congestion_control/bbr2_probe_bw.cc",
    "quic/core/congestion_control/bbr2_probe_rtt.cc",
    "quic/core/congestion_control/bbr2_sender.cc",
    "quic/core/congestion_control/bbr2_startup.cc",
    "quic/core/congestion_control/bbr_sender.cc",
    "quic/core/congestion_control/cubic_bytes.cc",
    "quic/core/congestion_control/general_loss_algorithm.cc",
    "quic/core/congestion_control/hybrid_slow_start.cc",
    "quic/core/congestion_control/pacing_sender.cc",
    "quic/core/congestion_control/prr_sender.cc",
    "quic/core/congestion_control/rtt_stats.cc",
    "quic/core/congestion_control/send_algorithm_interface.cc",
    "quic/core/congestion_control/tcp_cubic_sender_bytes.cc",
    "quic/core/congestion_control/uber_loss_algorithm.cc",
    "quic/core/crypto/aead_base_decrypter.cc",
    "quic/core/crypto/aead_base_encrypter.cc",
    "quic/core/crypto/aes_128_gcm_12_decrypter.cc",
    "quic/core/crypto/aes_128_gcm_12_encrypter.cc",
    "quic/core/crypto/aes_128_gcm_decrypter.cc",
    "quic/core/crypto/aes_128_gcm_encrypter.cc",
    "quic/core/crypto/aes_256_gcm_decrypter.cc",
    "quic/core/crypto/aes_256_gcm_encrypter.cc",
    "quic/core/crypto/aes_base_decrypter.cc",
    "quic/core/crypto/aes_base_encrypter.cc",
    "quic/core/crypto/cert_compressor.cc",
    "quic/core/crypto/certificate_util.cc",
    "quic/core/crypto/certificate_view.cc",
    "quic/core/crypto/chacha20_poly1305_decrypter.cc",
    "quic/core/crypto/chacha20_poly1305_encrypter.cc",
    "quic/core/crypto/chacha20_poly1305_tls_decrypter.cc",
    "quic/core/crypto/chacha20_poly1305_tls_encrypter.cc",
    "quic/core/crypto/chacha_base_decrypter.cc",
    "quic/core/crypto/chacha_base_encrypter.cc",
    "quic/core/crypto/channel_id.cc",
    "quic/core/crypto/client_proof_source.cc",
    "quic/core/crypto/crypto_framer.cc",
    "quic/core/crypto/crypto_handshake.cc",
    "quic/core/crypto/crypto_handshake_message.cc",
    "quic/core/crypto/crypto_secret_boxer.cc",
    "quic/core/crypto/crypto_utils.cc",
    "quic/core/crypto/curve25519_key_exchange.cc",
    "quic/core/crypto/key_exchange.cc",
    "quic/core/crypto/null_decrypter.cc",
    "quic/core/crypto/null_encrypter.cc",
    "quic/core/crypto/p256_key_exchange.cc",
    "quic/core/crypto/proof_source.cc",
    "quic/core/crypto/proof_source_x509.cc",
    "quic/core/crypto/quic_client_session_cache.cc",
    "quic/core/crypto/quic_compressed_certs_cache.cc",
    "quic/core/crypto/quic_crypter.cc",
    "quic/core/crypto/quic_crypto_client_config.cc",
    "quic/core/crypto/quic_crypto_proof.cc",
    "quic/core/crypto/quic_crypto_server_config.cc",
    "quic/core/crypto/quic_decrypter.cc",
    "quic/core/crypto/quic_encrypter.cc",
    "quic/core/crypto/quic_hkdf.cc",
    "quic/core/crypto/quic_random.cc",
    "quic/core/crypto/tls_client_connection.cc",
    "quic/core/crypto/tls_connection.cc",
    "quic/core/crypto/tls_server_connection.cc",
    "quic/core/crypto/transport_parameters.cc",
    "quic/core/crypto/web_transport_fingerprint_proof_verifier.cc",
    "quic/core/frames/quic_ack_frame.cc",
    "quic/core/frames/quic_ack_frequency_frame.cc",
    "quic/core/frames/quic_blocked_frame.cc",
    "quic/core/frames/quic_connection_close_frame.cc",
    "quic/core/frames/quic_crypto_frame.cc",
    "quic/core/frames/quic_frame.cc",
    "quic/core/frames/quic_goaway_frame.cc",
    "quic/core/frames/quic_handshake_done_frame.cc",
    "quic/core/frames/quic_max_streams_frame.cc",
    "quic/core/frames/quic_message_frame.cc",
    "quic/core/frames/quic_new_connection_id_frame.cc",
    "quic/core/frames/quic_new_token_frame.cc",
    "quic/core/frames/quic_padding_frame.cc",
    "quic/core/frames/quic_path_challenge_frame.cc",
    "quic/core/frames/quic_path_response_frame.cc",
    "quic/core/frames/quic_ping_frame.cc",
    "quic/core/frames/quic_retire_connection_id_frame.cc",
    "quic/core/frames/quic_rst_stream_frame.cc",
    "quic/core/frames/quic_stop_sending_frame.cc",
    "quic/core/frames/quic_stop_waiting_frame.cc",
    "quic/core/frames/quic_stream_frame.cc",
    "quic/core/frames/quic_streams_blocked_frame.cc",
    "quic/core/frames/quic_window_update_frame.cc",
    "quic/core/http/capsule.cc",
    "quic/core/http/http_constants.cc",
    "quic/core/http/http_decoder.cc",
    "quic/core/http/http_encoder.cc",
    "quic/core/http/quic_client_promised_info.cc",
    "quic/core/http/quic_client_push_promise_index.cc",
    "quic/core/http/quic_header_list.cc",
    "quic/core/http/quic_headers_stream.cc",
    "quic/core/http/quic_receive_control_stream.cc",
    "quic/core/http/quic_send_control_stream.cc",
    "quic/core/http/quic_server_initiated_spdy_stream.cc",
    "quic/core/http/quic_server_session_base.cc",
    "quic/core/http/quic_spdy_client_session.cc",
    "quic/core/http/quic_spdy_client_session_base.cc",
    "quic/core/http/quic_spdy_client_stream.cc",
    "quic/core/http/quic_spdy_server_stream_base.cc",
    "quic/core/http/quic_spdy_session.cc",
    "quic/core/http/quic_spdy_stream.cc",
    "quic/core/http/quic_spdy_stream_body_manager.cc",
    "quic/core/http/spdy_server_push_utils.cc",
    "quic/core/http/spdy_utils.cc",
    "quic/core/http/web_transport_http3.cc",
    "quic/core/http/web_transport_stream_adapter.cc",
    "quic/core/legacy_quic_stream_id_manager.cc",
    "quic/core/qpack/qpack_blocking_manager.cc",
    "quic/core/qpack/qpack_decoded_headers_accumulator.cc",
    "quic/core/qpack/qpack_decoder.cc",
    "quic/core/qpack/qpack_decoder_stream_receiver.cc",
    "quic/core/qpack/qpack_decoder_stream_sender.cc",
    "quic/core/qpack/qpack_encoder.cc",
    "quic/core/qpack/qpack_encoder_stream_receiver.cc",
    "quic/core/qpack/qpack_encoder_stream_sender.cc",
    "quic/core/qpack/qpack_header_table.cc",
    "quic/core/qpack/qpack_index_conversions.cc",
    "quic/core/qpack/qpack_instruction_decoder.cc",
    "quic/core/qpack/qpack_instruction_encoder.cc",
    "quic/core/qpack/qpack_instructions.cc",
    "quic/core/qpack/qpack_progressive_decoder.cc",
    "quic/core/qpack/qpack_receive_stream.cc",
    "quic/core/qpack/qpack_required_insert_count.cc",
    "quic/core/qpack/qpack_send_stream.cc",
    "quic/core/qpack/qpack_static_table.cc",
    "quic/core/qpack/value_splitting_header_list.cc",
    "quic/core/quic_ack_listener_interface.cc",
    "quic/core/quic_alarm.cc",
    "quic/core/quic_bandwidth.cc",
    "quic/core/quic_buffered_packet_store.cc",
    "quic/core/quic_chaos_protector.cc",
    "quic/core/quic_clock.cc",
    "quic/core/quic_coalesced_packet.cc",
    "quic/core/quic_config.cc",
    "quic/core/quic_connection.cc",
    "quic/core/quic_connection_context.cc",
    "quic/core/quic_connection_id.cc",
    "quic/core/quic_connection_id_manager.cc",
    "quic/core/quic_connection_stats.cc",
    "quic/core/quic_constants.cc",
    "quic/core/quic_control_frame_manager.cc",
    "quic/core/quic_crypto_client_handshaker.cc",
    "quic/core/quic_crypto_client_stream.cc",
    "quic/core/quic_crypto_handshaker.cc",
    "quic/core/quic_crypto_server_stream.cc",
    "quic/core/quic_crypto_server_stream_base.cc",
    "quic/core/quic_crypto_stream.cc",
    "quic/core/quic_data_reader.cc",
    "quic/core/quic_data_writer.cc",
    "quic/core/quic_datagram_queue.cc",
    "quic/core/quic_default_clock.cc",
    "quic/core/quic_dispatcher.cc",
    "quic/core/quic_error_codes.cc",
    "quic/core/quic_flow_controller.cc",
    "quic/core/quic_framer.cc",
    "quic/core/quic_idle_network_detector.cc",
    "quic/core/quic_legacy_version_encapsulator.cc",
    "quic/core/quic_mtu_discovery.cc",
    "quic/core/quic_network_blackhole_detector.cc",
    "quic/core/quic_packet_creator.cc",
    "quic/core/quic_packet_number.cc",
    "quic/core/quic_packet_writer_wrapper.cc",
    "quic/core/quic_packets.cc",
    "quic/core/quic_path_validator.cc",
    "quic/core/quic_ping_manager.cc",
    "quic/core/quic_received_packet_manager.cc",
    "quic/core/quic_sent_packet_manager.cc",
    "quic/core/quic_server_id.cc",
    "quic/core/quic_session.cc",
    "quic/core/quic_socket_address_coder.cc",
    "quic/core/quic_stream.cc",
    "quic/core/quic_stream_id_manager.cc",
    "quic/core/quic_stream_send_buffer.cc",
    "quic/core/quic_stream_sequencer.cc",
    "quic/core/quic_stream_sequencer_buffer.cc",
    "quic/core/quic_sustained_bandwidth_recorder.cc",
    "quic/core/quic_tag.cc",
    "quic/core/quic_time.cc",
    "quic/core/quic_time_wait_list_manager.cc",
    "quic/core/quic_trace_visitor.cc",
    "quic/core/quic_transmission_info.cc",
    "quic/core/quic_types.cc",
    "quic/core/quic_unacked_packet_map.cc",
    "quic/core/quic_utils.cc",
    "quic/core/quic_version_manager.cc",
    "quic/core/quic_versions.cc",
    "quic/core/quic_write_blocked_list.cc",
    "quic/core/tls_chlo_extractor.cc",
    "quic/core/tls_client_handshaker.cc",
    "quic/core/tls_handshaker.cc",
    "quic/core/tls_server_handshaker.cc",
    "quic/core/uber_quic_stream_id_manager.cc",
    "quic/core/uber_received_packet_manager.cc",
    "quic/platform/api/quic_ip_address.cc",
    "quic/platform/api/quic_ip_address_family.cc",
    "quic/platform/api/quic_socket_address.cc",
    "spdy/core/array_output_buffer.cc",
    "spdy/core/hpack/hpack_constants.cc",
    "spdy/core/hpack/hpack_decoder_adapter.cc",
    "spdy/core/hpack/hpack_encoder.cc",
    "spdy/core/hpack/hpack_entry.cc",
    "spdy/core/hpack/hpack_header_table.cc",
    "spdy/core/hpack/hpack_output_stream.cc",
    "spdy/core/hpack/hpack_static_table.cc",
    "spdy/core/http2_frame_decoder_adapter.cc",
    "spdy/core/metadata_extension.cc",
    "spdy/core/recording_headers_handler.cc",
    "spdy/core/spdy_alt_svc_wire_format.cc",
    "spdy/core/spdy_frame_builder.cc",
    "spdy/core/spdy_framer.cc",
    "spdy/core/spdy_header_block.cc",
    "spdy/core/spdy_header_storage.cc",
    "spdy/core/spdy_no_op_visitor.cc",
    "spdy/core/spdy_pinnable_buffer_piece.cc",
    "spdy/core/spdy_prefixed_buffer_reader.cc",
    "spdy/core/spdy_protocol.cc",
    "spdy/core/spdy_simple_arena.cc",
]
quiche_tool_support_hdrs = [
    "common/platform/api/quiche_command_line_flags.h",
    "common/platform/api/quiche_default_proof_providers.h",
    "common/platform/api/quiche_file_utils.h",
    "common/platform/api/quiche_system_event_loop.h",
    "quic/platform/api/quic_default_proof_providers.h",
    "quic/tools/fake_proof_verifier.h",
    "quic/tools/quic_backend_response.h",
    "quic/tools/quic_client_base.h",
    "quic/tools/quic_memory_cache_backend.h",
    "quic/tools/quic_simple_client_session.h",
    "quic/tools/quic_simple_client_stream.h",
    "quic/tools/quic_simple_crypto_server_stream_helper.h",
    "quic/tools/quic_simple_dispatcher.h",
    "quic/tools/quic_simple_server_backend.h",
    "quic/tools/quic_simple_server_session.h",
    "quic/tools/quic_simple_server_stream.h",
    "quic/tools/quic_spdy_client_base.h",
    "quic/tools/quic_spdy_server_base.h",
    "quic/tools/quic_tcp_like_trace_converter.h",
    "quic/tools/quic_url.h",
    "quic/tools/simple_ticket_crypter.h",
    "quic/tools/web_transport_test_visitors.h",
]
quiche_tool_support_srcs = [
    "common/platform/api/quiche_file_utils.cc",
    "quic/tools/quic_backend_response.cc",
    "quic/tools/quic_client_base.cc",
    "quic/tools/quic_memory_cache_backend.cc",
    "quic/tools/quic_simple_client_session.cc",
    "quic/tools/quic_simple_client_stream.cc",
    "quic/tools/quic_simple_crypto_server_stream_helper.cc",
    "quic/tools/quic_simple_dispatcher.cc",
    "quic/tools/quic_simple_server_session.cc",
    "quic/tools/quic_simple_server_stream.cc",
    "quic/tools/quic_spdy_client_base.cc",
    "quic/tools/quic_tcp_like_trace_converter.cc",
    "quic/tools/quic_url.cc",
    "quic/tools/simple_ticket_crypter.cc",
]
quiche_test_support_hdrs = [
    "common/platform/api/quiche_expect_bug.h",
    "common/platform/api/quiche_test.h",
    "common/platform/api/quiche_test_loopback.h",
    "common/platform/api/quiche_test_output.h",
    "common/test_tools/quiche_test_utils.h",
    "http2/adapter/mock_http2_visitor.h",
    "http2/adapter/recording_http2_visitor.h",
    "http2/adapter/test_frame_sequence.h",
    "http2/adapter/test_utils.h",
    "http2/test_tools/frame_decoder_state_test_util.h",
    "http2/test_tools/frame_parts.h",
    "http2/test_tools/frame_parts_collector.h",
    "http2/test_tools/frame_parts_collector_listener.h",
    "http2/test_tools/hpack_block_builder.h",
    "http2/test_tools/hpack_block_collector.h",
    "http2/test_tools/hpack_entry_collector.h",
    "http2/test_tools/hpack_example.h",
    "http2/test_tools/hpack_string_collector.h",
    "http2/test_tools/http2_constants_test_util.h",
    "http2/test_tools/http2_frame_builder.h",
    "http2/test_tools/http2_frame_decoder_listener_test_util.h",
    "http2/test_tools/http2_random.h",
    "http2/test_tools/http2_structure_decoder_test_util.h",
    "http2/test_tools/http2_structures_test_util.h",
    "http2/test_tools/payload_decoder_base_test_util.h",
    "http2/test_tools/random_decoder_test_base.h",
    "http2/test_tools/random_util.h",
    "http2/test_tools/verify_macros.h",
    "quic/platform/api/quic_expect_bug.h",
    "quic/platform/api/quic_test.h",
    "quic/platform/api/quic_test_loopback.h",
    "quic/platform/api/quic_test_output.h",
    "quic/test_tools/bad_packet_writer.h",
    "quic/test_tools/crypto_test_utils.h",
    "quic/test_tools/failing_proof_source.h",
    "quic/test_tools/fake_proof_source.h",
    "quic/test_tools/fake_proof_source_handle.h",
    "quic/test_tools/first_flight.h",
    "quic/test_tools/limited_mtu_test_writer.h",
    "quic/test_tools/mock_clock.h",
    "quic/test_tools/mock_quic_client_promised_info.h",
    "quic/test_tools/mock_quic_dispatcher.h",
    "quic/test_tools/mock_quic_session_visitor.h",
    "quic/test_tools/mock_quic_spdy_client_stream.h",
    "quic/test_tools/mock_quic_time_wait_list_manager.h",
    "quic/test_tools/mock_random.h",
    "quic/test_tools/packet_dropping_test_writer.h",
    "quic/test_tools/packet_reordering_writer.h",
    "quic/test_tools/qpack/qpack_decoder_test_utils.h",
    "quic/test_tools/qpack/qpack_encoder_peer.h",
    "quic/test_tools/qpack/qpack_encoder_test_utils.h",
    "quic/test_tools/qpack/qpack_offline_decoder.h",
    "quic/test_tools/qpack/qpack_test_utils.h",
    "quic/test_tools/quic_buffered_packet_store_peer.h",
    "quic/test_tools/quic_client_promised_info_peer.h",
    "quic/test_tools/quic_client_session_cache_peer.h",
    "quic/test_tools/quic_coalesced_packet_peer.h",
    "quic/test_tools/quic_config_peer.h",
    "quic/test_tools/quic_connection_id_manager_peer.h",
    "quic/test_tools/quic_connection_peer.h",
    "quic/test_tools/quic_crypto_server_config_peer.h",
    "quic/test_tools/quic_dispatcher_peer.h",
    "quic/test_tools/quic_flow_controller_peer.h",
    "quic/test_tools/quic_framer_peer.h",
    "quic/test_tools/quic_interval_deque_peer.h",
    "quic/test_tools/quic_packet_creator_peer.h",
    "quic/test_tools/quic_path_validator_peer.h",
    "quic/test_tools/quic_sent_packet_manager_peer.h",
    "quic/test_tools/quic_server_session_base_peer.h",
    "quic/test_tools/quic_session_peer.h",
    "quic/test_tools/quic_spdy_session_peer.h",
    "quic/test_tools/quic_spdy_stream_peer.h",
    "quic/test_tools/quic_stream_id_manager_peer.h",
    "quic/test_tools/quic_stream_peer.h",
    "quic/test_tools/quic_stream_send_buffer_peer.h",
    "quic/test_tools/quic_stream_sequencer_buffer_peer.h",
    "quic/test_tools/quic_stream_sequencer_peer.h",
    "quic/test_tools/quic_sustained_bandwidth_recorder_peer.h",
    "quic/test_tools/quic_test_backend.h",
    "quic/test_tools/quic_test_utils.h",
    "quic/test_tools/quic_time_wait_list_manager_peer.h",
    "quic/test_tools/quic_unacked_packet_map_peer.h",
    "quic/test_tools/rtt_stats_peer.h",
    "quic/test_tools/send_algorithm_test_utils.h",
    "quic/test_tools/simple_data_producer.h",
    "quic/test_tools/simple_quic_framer.h",
    "quic/test_tools/simple_session_cache.h",
    "quic/test_tools/simple_session_notifier.h",
    "quic/test_tools/simulator/actor.h",
    "quic/test_tools/simulator/alarm_factory.h",
    "quic/test_tools/simulator/link.h",
    "quic/test_tools/simulator/packet_filter.h",
    "quic/test_tools/simulator/port.h",
    "quic/test_tools/simulator/queue.h",
    "quic/test_tools/simulator/quic_endpoint.h",
    "quic/test_tools/simulator/quic_endpoint_base.h",
    "quic/test_tools/simulator/simulator.h",
    "quic/test_tools/simulator/switch.h",
    "quic/test_tools/simulator/test_harness.h",
    "quic/test_tools/simulator/traffic_policer.h",
    "quic/test_tools/test_certificates.h",
    "quic/test_tools/test_ticket_crypter.h",
    "quic/test_tools/web_transport_resets_backend.h",
    "quic/test_tools/web_transport_test_tools.h",
    "spdy/test_tools/mock_spdy_framer_visitor.h",
    "spdy/test_tools/spdy_test_utils.h",
]
quiche_test_support_srcs = [
    "common/platform/api/quiche_test_loopback.cc",
    "common/test_tools/quiche_test_utils.cc",
    "http2/adapter/recording_http2_visitor.cc",
    "http2/adapter/test_frame_sequence.cc",
    "http2/adapter/test_utils.cc",
    "http2/test_tools/frame_decoder_state_test_util.cc",
    "http2/test_tools/frame_parts.cc",
    "http2/test_tools/frame_parts_collector.cc",
    "http2/test_tools/frame_parts_collector_listener.cc",
    "http2/test_tools/hpack_block_builder.cc",
    "http2/test_tools/hpack_block_collector.cc",
    "http2/test_tools/hpack_entry_collector.cc",
    "http2/test_tools/hpack_example.cc",
    "http2/test_tools/hpack_string_collector.cc",
    "http2/test_tools/http2_constants_test_util.cc",
    "http2/test_tools/http2_frame_builder.cc",
    "http2/test_tools/http2_frame_decoder_listener_test_util.cc",
    "http2/test_tools/http2_random.cc",
    "http2/test_tools/http2_structure_decoder_test_util.cc",
    "http2/test_tools/http2_structures_test_util.cc",
    "http2/test_tools/payload_decoder_base_test_util.cc",
    "http2/test_tools/random_decoder_test_base.cc",
    "http2/test_tools/random_util.cc",
    "quic/test_tools/bad_packet_writer.cc",
    "quic/test_tools/crypto_test_utils.cc",
    "quic/test_tools/failing_proof_source.cc",
    "quic/test_tools/fake_proof_source.cc",
    "quic/test_tools/fake_proof_source_handle.cc",
    "quic/test_tools/first_flight.cc",
    "quic/test_tools/limited_mtu_test_writer.cc",
    "quic/test_tools/mock_clock.cc",
    "quic/test_tools/mock_quic_client_promised_info.cc",
    "quic/test_tools/mock_quic_dispatcher.cc",
    "quic/test_tools/mock_quic_session_visitor.cc",
    "quic/test_tools/mock_quic_spdy_client_stream.cc",
    "quic/test_tools/mock_quic_time_wait_list_manager.cc",
    "quic/test_tools/mock_random.cc",
    "quic/test_tools/packet_dropping_test_writer.cc",
    "quic/test_tools/packet_reordering_writer.cc",
    "quic/test_tools/qpack/qpack_decoder_test_utils.cc",
    "quic/test_tools/qpack/qpack_encoder_peer.cc",
    "quic/test_tools/qpack/qpack_encoder_test_utils.cc",
    "quic/test_tools/qpack/qpack_offline_decoder.cc",
    "quic/test_tools/qpack/qpack_test_utils.cc",
    "quic/test_tools/quic_buffered_packet_store_peer.cc",
    "quic/test_tools/quic_client_promised_info_peer.cc",
    "quic/test_tools/quic_coalesced_packet_peer.cc",
    "quic/test_tools/quic_config_peer.cc",
    "quic/test_tools/quic_connection_peer.cc",
    "quic/test_tools/quic_crypto_server_config_peer.cc",
    "quic/test_tools/quic_dispatcher_peer.cc",
    "quic/test_tools/quic_flow_controller_peer.cc",
    "quic/test_tools/quic_framer_peer.cc",
    "quic/test_tools/quic_packet_creator_peer.cc",
    "quic/test_tools/quic_path_validator_peer.cc",
    "quic/test_tools/quic_sent_packet_manager_peer.cc",
    "quic/test_tools/quic_session_peer.cc",
    "quic/test_tools/quic_spdy_session_peer.cc",
    "quic/test_tools/quic_spdy_stream_peer.cc",
    "quic/test_tools/quic_stream_id_manager_peer.cc",
    "quic/test_tools/quic_stream_peer.cc",
    "quic/test_tools/quic_stream_send_buffer_peer.cc",
    "quic/test_tools/quic_stream_sequencer_buffer_peer.cc",
    "quic/test_tools/quic_stream_sequencer_peer.cc",
    "quic/test_tools/quic_sustained_bandwidth_recorder_peer.cc",
    "quic/test_tools/quic_test_backend.cc",
    "quic/test_tools/quic_test_utils.cc",
    "quic/test_tools/quic_time_wait_list_manager_peer.cc",
    "quic/test_tools/quic_unacked_packet_map_peer.cc",
    "quic/test_tools/rtt_stats_peer.cc",
    "quic/test_tools/send_algorithm_test_utils.cc",
    "quic/test_tools/simple_data_producer.cc",
    "quic/test_tools/simple_quic_framer.cc",
    "quic/test_tools/simple_session_cache.cc",
    "quic/test_tools/simple_session_notifier.cc",
    "quic/test_tools/simulator/actor.cc",
    "quic/test_tools/simulator/alarm_factory.cc",
    "quic/test_tools/simulator/link.cc",
    "quic/test_tools/simulator/packet_filter.cc",
    "quic/test_tools/simulator/port.cc",
    "quic/test_tools/simulator/queue.cc",
    "quic/test_tools/simulator/quic_endpoint.cc",
    "quic/test_tools/simulator/quic_endpoint_base.cc",
    "quic/test_tools/simulator/simulator.cc",
    "quic/test_tools/simulator/switch.cc",
    "quic/test_tools/simulator/test_harness.cc",
    "quic/test_tools/simulator/traffic_policer.cc",
    "quic/test_tools/test_certificates.cc",
    "quic/test_tools/test_ticket_crypter.cc",
    "quic/test_tools/web_transport_resets_backend.cc",
    "spdy/test_tools/mock_spdy_framer_visitor.cc",
    "spdy/test_tools/spdy_test_utils.cc",
]
epoll_tool_support_hdrs = [
    "common/platform/api/quiche_epoll.h",
    "common/platform/api/quiche_event_loop.h",
    "common/platform/api/quiche_stream_buffer_allocator.h",
    "common/platform/api/quiche_udp_socket_platform_api.h",
    "epoll_server/platform/api/epoll_bug.h",
    "epoll_server/platform/api/epoll_logging.h",
    "epoll_server/platform/api/epoll_thread.h",
    "epoll_server/simple_epoll_server.h",
    "quic/core/batch_writer/quic_batch_writer_base.h",
    "quic/core/batch_writer/quic_batch_writer_buffer.h",
    "quic/core/batch_writer/quic_batch_writer_test.h",
    "quic/core/batch_writer/quic_gso_batch_writer.h",
    "quic/core/batch_writer/quic_sendmmsg_batch_writer.h",
    "quic/core/io/quic_default_event_loop.h",
    "quic/core/io/quic_event_loop.h",
    "quic/core/io/quic_poll_event_loop.h",
    "quic/core/io/socket.h",
    "quic/core/quic_default_packet_writer.h",
    "quic/core/quic_epoll_alarm_factory.h",
    "quic/core/quic_epoll_clock.h",
    "quic/core/quic_epoll_connection_helper.h",
    "quic/core/quic_linux_socket_utils.h",
    "quic/core/quic_packet_reader.h",
    "quic/core/quic_syscall_wrapper.h",
    "quic/core/quic_udp_socket.h",
    "quic/masque/masque_client_session.h",
    "quic/masque/masque_client_tools.h",
    "quic/masque/masque_dispatcher.h",
    "quic/masque/masque_encapsulated_client_session.h",
    "quic/masque/masque_encapsulated_epoll_client.h",
    "quic/masque/masque_epoll_client.h",
    "quic/masque/masque_epoll_server.h",
    "quic/masque/masque_server_backend.h",
    "quic/masque/masque_server_session.h",
    "quic/masque/masque_utils.h",
    "quic/platform/api/quic_epoll.h",
    "quic/platform/api/quic_udp_socket_platform_api.h",
    "quic/tools/quic_client.h",
    "quic/tools/quic_client_epoll_network_helper.h",
    "quic/tools/quic_server.h",
]
epoll_tool_support_srcs = [
    "epoll_server/simple_epoll_server.cc",
    "quic/core/batch_writer/quic_batch_writer_base.cc",
    "quic/core/batch_writer/quic_batch_writer_buffer.cc",
    "quic/core/batch_writer/quic_gso_batch_writer.cc",
    "quic/core/batch_writer/quic_sendmmsg_batch_writer.cc",
    "quic/core/io/quic_default_event_loop.cc",
    "quic/core/io/quic_poll_event_loop.cc",
    "quic/core/io/socket_posix.cc",
    "quic/core/quic_default_packet_writer.cc",
    "quic/core/quic_epoll_alarm_factory.cc",
    "quic/core/quic_epoll_clock.cc",
    "quic/core/quic_epoll_connection_helper.cc",
    "quic/core/quic_linux_socket_utils.cc",
    "quic/core/quic_packet_reader.cc",
    "quic/core/quic_syscall_wrapper.cc",
    "quic/core/quic_udp_socket_posix.cc",
    "quic/masque/masque_client_session.cc",
    "quic/masque/masque_client_tools.cc",
    "quic/masque/masque_dispatcher.cc",
    "quic/masque/masque_encapsulated_client_session.cc",
    "quic/masque/masque_encapsulated_epoll_client.cc",
    "quic/masque/masque_epoll_client.cc",
    "quic/masque/masque_epoll_server.cc",
    "quic/masque/masque_server_backend.cc",
    "quic/masque/masque_server_session.cc",
    "quic/masque/masque_utils.cc",
    "quic/tools/quic_client.cc",
    "quic/tools/quic_client_epoll_network_helper.cc",
    "quic/tools/quic_server.cc",
]
epoll_test_support_hdrs = [
    "common/platform/api/quiche_epoll_test_tools.h",
    "epoll_server/fake_simple_epoll_server.h",
    "epoll_server/platform/api/epoll_address_test_utils.h",
    "epoll_server/platform/api/epoll_expect_bug.h",
    "epoll_server/platform/api/epoll_test.h",
    "quic/bindings/quic_libevent.h",
    "quic/test_tools/quic_client_peer.h",
    "quic/test_tools/quic_mock_syscall_wrapper.h",
    "quic/test_tools/quic_server_peer.h",
    "quic/test_tools/quic_test_client.h",
    "quic/test_tools/quic_test_server.h",
    "quic/test_tools/server_thread.h",
]
epoll_test_support_srcs = [
    "epoll_server/fake_simple_epoll_server.cc",
    "quic/bindings/quic_libevent.cc",
    "quic/test_tools/quic_client_peer.cc",
    "quic/test_tools/quic_mock_syscall_wrapper.cc",
    "quic/test_tools/quic_server_peer.cc",
    "quic/test_tools/quic_test_client.cc",
    "quic/test_tools/quic_test_server.cc",
    "quic/test_tools/server_thread.cc",
]
quiche_tests_hdrs = [

]
quiche_tests_srcs = [
    "balsa/balsa_frame_test.cc",
    "balsa/balsa_headers_test.cc",
    "balsa/header_properties_test.cc",
    "balsa/simple_buffer_test.cc",
    "common/platform/api/quiche_file_utils_test.cc",
    "common/platform/api/quiche_hostname_utils_test.cc",
    "common/platform/api/quiche_lower_case_string_test.cc",
    "common/platform/api/quiche_mem_slice_test.cc",
    "common/platform/api/quiche_reference_counted_test.cc",
    "common/platform/api/quiche_stack_trace_test.cc",
    "common/platform/api/quiche_time_utils_test.cc",
    "common/platform/api/quiche_url_utils_test.cc",
    "common/print_elements_test.cc",
    "common/quiche_buffer_allocator_test.cc",
    "common/quiche_circular_deque_test.cc",
    "common/quiche_data_reader_test.cc",
    "common/quiche_data_writer_test.cc",
    "common/quiche_endian_test.cc",
    "common/quiche_linked_hash_map_test.cc",
    "common/quiche_mem_slice_storage_test.cc",
    "common/quiche_text_utils_test.cc",
    "common/simple_buffer_allocator_test.cc",
    "common/structured_headers_generated_test.cc",
    "common/structured_headers_test.cc",
    "http2/adapter/event_forwarder_test.cc",
    "http2/adapter/header_validator_test.cc",
    "http2/adapter/noop_header_validator_test.cc",
    "http2/adapter/oghttp2_adapter_test.cc",
    "http2/adapter/oghttp2_session_test.cc",
    "http2/adapter/oghttp2_util_test.cc",
    "http2/adapter/recording_http2_visitor_test.cc",
    "http2/adapter/test_utils_test.cc",
    "http2/adapter/window_manager_test.cc",
    "http2/core/priority_write_scheduler_test.cc",
    "http2/decoder/decode_buffer_test.cc",
    "http2/decoder/decode_http2_structures_test.cc",
    "http2/decoder/http2_frame_decoder_test.cc",
    "http2/decoder/http2_structure_decoder_test.cc",
    "http2/decoder/payload_decoders/altsvc_payload_decoder_test.cc",
    "http2/decoder/payload_decoders/continuation_payload_decoder_test.cc",
    "http2/decoder/payload_decoders/data_payload_decoder_test.cc",
    "http2/decoder/payload_decoders/goaway_payload_decoder_test.cc",
    "http2/decoder/payload_decoders/headers_payload_decoder_test.cc",
    "http2/decoder/payload_decoders/ping_payload_decoder_test.cc",
    "http2/decoder/payload_decoders/priority_payload_decoder_test.cc",
    "http2/decoder/payload_decoders/priority_update_payload_decoder_test.cc",
    "http2/decoder/payload_decoders/push_promise_payload_decoder_test.cc",
    "http2/decoder/payload_decoders/rst_stream_payload_decoder_test.cc",
    "http2/decoder/payload_decoders/settings_payload_decoder_test.cc",
    "http2/decoder/payload_decoders/unknown_payload_decoder_test.cc",
    "http2/decoder/payload_decoders/window_update_payload_decoder_test.cc",
    "http2/hpack/decoder/hpack_block_collector_test.cc",
    "http2/hpack/decoder/hpack_block_decoder_test.cc",
    "http2/hpack/decoder/hpack_decoder_state_test.cc",
    "http2/hpack/decoder/hpack_decoder_string_buffer_test.cc",
    "http2/hpack/decoder/hpack_decoder_tables_test.cc",
    "http2/hpack/decoder/hpack_decoder_test.cc",
    "http2/hpack/decoder/hpack_entry_collector_test.cc",
    "http2/hpack/decoder/hpack_entry_decoder_test.cc",
    "http2/hpack/decoder/hpack_entry_type_decoder_test.cc",
    "http2/hpack/decoder/hpack_string_decoder_test.cc",
    "http2/hpack/decoder/hpack_whole_entry_buffer_test.cc",
    "http2/hpack/http2_hpack_constants_test.cc",
    "http2/hpack/huffman/hpack_huffman_decoder_test.cc",
    "http2/hpack/huffman/hpack_huffman_encoder_test.cc",
    "http2/hpack/huffman/hpack_huffman_transcoder_test.cc",
    "http2/hpack/varint/hpack_varint_decoder_test.cc",
    "http2/hpack/varint/hpack_varint_encoder_test.cc",
    "http2/hpack/varint/hpack_varint_round_trip_test.cc",
    "http2/http2_constants_test.cc",
    "http2/http2_structures_test.cc",
    "http2/test_tools/hpack_block_builder_test.cc",
    "http2/test_tools/hpack_example_test.cc",
    "http2/test_tools/http2_frame_builder_test.cc",
    "http2/test_tools/http2_random_test.cc",
    "http2/test_tools/random_decoder_test_base_test.cc",
    "quic/bindings/quic_libevent_test.cc",
    "quic/core/congestion_control/bandwidth_sampler_test.cc",
    "quic/core/congestion_control/bbr2_simulator_test.cc",
    "quic/core/congestion_control/bbr_sender_test.cc",
    "quic/core/congestion_control/cubic_bytes_test.cc",
    "quic/core/congestion_control/general_loss_algorithm_test.cc",
    "quic/core/congestion_control/hybrid_slow_start_test.cc",
    "quic/core/congestion_control/pacing_sender_test.cc",
    "quic/core/congestion_control/prr_sender_test.cc",
    "quic/core/congestion_control/rtt_stats_test.cc",
    "quic/core/congestion_control/send_algorithm_test.cc",
    "quic/core/congestion_control/tcp_cubic_sender_bytes_test.cc",
    "quic/core/congestion_control/uber_loss_algorithm_test.cc",
    "quic/core/congestion_control/windowed_filter_test.cc",
    "quic/core/crypto/aes_128_gcm_12_decrypter_test.cc",
    "quic/core/crypto/aes_128_gcm_12_encrypter_test.cc",
    "quic/core/crypto/aes_128_gcm_decrypter_test.cc",
    "quic/core/crypto/aes_128_gcm_encrypter_test.cc",
    "quic/core/crypto/aes_256_gcm_decrypter_test.cc",
    "quic/core/crypto/aes_256_gcm_encrypter_test.cc",
    "quic/core/crypto/cert_compressor_test.cc",
    "quic/core/crypto/certificate_util_test.cc",
    "quic/core/crypto/certificate_view_test.cc",
    "quic/core/crypto/chacha20_poly1305_decrypter_test.cc",
    "quic/core/crypto/chacha20_poly1305_encrypter_test.cc",
    "quic/core/crypto/chacha20_poly1305_tls_decrypter_test.cc",
    "quic/core/crypto/chacha20_poly1305_tls_encrypter_test.cc",
    "quic/core/crypto/channel_id_test.cc",
    "quic/core/crypto/client_proof_source_test.cc",
    "quic/core/crypto/crypto_framer_test.cc",
    "quic/core/crypto/crypto_handshake_message_test.cc",
    "quic/core/crypto/crypto_secret_boxer_test.cc",
    "quic/core/crypto/crypto_server_test.cc",
    "quic/core/crypto/crypto_utils_test.cc",
    "quic/core/crypto/curve25519_key_exchange_test.cc",
    "quic/core/crypto/null_decrypter_test.cc",
    "quic/core/crypto/null_encrypter_test.cc",
    "quic/core/crypto/p256_key_exchange_test.cc",
    "quic/core/crypto/proof_source_x509_test.cc",
    "quic/core/crypto/quic_client_session_cache_test.cc",
    "quic/core/crypto/quic_compressed_certs_cache_test.cc",
    "quic/core/crypto/quic_crypto_client_config_test.cc",
    "quic/core/crypto/quic_crypto_server_config_test.cc",
    "quic/core/crypto/quic_hkdf_test.cc",
    "quic/core/crypto/quic_random_test.cc",
    "quic/core/crypto/transport_parameters_test.cc",
    "quic/core/crypto/web_transport_fingerprint_proof_verifier_test.cc",
    "quic/core/frames/quic_frames_test.cc",
    "quic/core/http/capsule_test.cc",
    "quic/core/http/http_decoder_test.cc",
    "quic/core/http/http_encoder_test.cc",
    "quic/core/http/http_frames_test.cc",
    "quic/core/http/quic_client_promised_info_test.cc",
    "quic/core/http/quic_client_push_promise_index_test.cc",
    "quic/core/http/quic_header_list_test.cc",
    "quic/core/http/quic_headers_stream_test.cc",
    "quic/core/http/quic_receive_control_stream_test.cc",
    "quic/core/http/quic_send_control_stream_test.cc",
    "quic/core/http/quic_server_session_base_test.cc",
    "quic/core/http/quic_spdy_session_test.cc",
    "quic/core/http/quic_spdy_stream_body_manager_test.cc",
    "quic/core/http/quic_spdy_stream_test.cc",
    "quic/core/http/spdy_server_push_utils_test.cc",
    "quic/core/http/spdy_utils_test.cc",
    "quic/core/http/web_transport_http3_test.cc",
    "quic/core/legacy_quic_stream_id_manager_test.cc",
    "quic/core/packet_number_indexed_queue_test.cc",
    "quic/core/qpack/qpack_blocking_manager_test.cc",
    "quic/core/qpack/qpack_decoded_headers_accumulator_test.cc",
    "quic/core/qpack/qpack_decoder_stream_receiver_test.cc",
    "quic/core/qpack/qpack_decoder_stream_sender_test.cc",
    "quic/core/qpack/qpack_decoder_test.cc",
    "quic/core/qpack/qpack_encoder_stream_receiver_test.cc",
    "quic/core/qpack/qpack_encoder_stream_sender_test.cc",
    "quic/core/qpack/qpack_encoder_test.cc",
    "quic/core/qpack/qpack_header_table_test.cc",
    "quic/core/qpack/qpack_index_conversions_test.cc",
    "quic/core/qpack/qpack_instruction_decoder_test.cc",
    "quic/core/qpack/qpack_instruction_encoder_test.cc",
    "quic/core/qpack/qpack_receive_stream_test.cc",
    "quic/core/qpack/qpack_required_insert_count_test.cc",
    "quic/core/qpack/qpack_round_trip_test.cc",
    "quic/core/qpack/qpack_send_stream_test.cc",
    "quic/core/qpack/qpack_static_table_test.cc",
    "quic/core/qpack/value_splitting_header_list_test.cc",
    "quic/core/quic_alarm_test.cc",
    "quic/core/quic_arena_scoped_ptr_test.cc",
    "quic/core/quic_bandwidth_test.cc",
    "quic/core/quic_buffered_packet_store_test.cc",
    "quic/core/quic_chaos_protector_test.cc",
    "quic/core/quic_coalesced_packet_test.cc",
    "quic/core/quic_config_test.cc",
    "quic/core/quic_connection_context_test.cc",
    "quic/core/quic_connection_id_manager_test.cc",
    "quic/core/quic_connection_id_test.cc",
    "quic/core/quic_connection_test.cc",
    "quic/core/quic_control_frame_manager_test.cc",
    "quic/core/quic_crypto_client_handshaker_test.cc",
    "quic/core/quic_crypto_client_stream_test.cc",
    "quic/core/quic_crypto_server_stream_test.cc",
    "quic/core/quic_crypto_stream_test.cc",
    "quic/core/quic_data_writer_test.cc",
    "quic/core/quic_datagram_queue_test.cc",
    "quic/core/quic_dispatcher_test.cc",
    "quic/core/quic_error_codes_test.cc",
    "quic/core/quic_flow_controller_test.cc",
    "quic/core/quic_framer_test.cc",
    "quic/core/quic_idle_network_detector_test.cc",
    "quic/core/quic_interval_deque_test.cc",
    "quic/core/quic_interval_set_test.cc",
    "quic/core/quic_interval_test.cc",
    "quic/core/quic_legacy_version_encapsulator_test.cc",
    "quic/core/quic_lru_cache_test.cc",
    "quic/core/quic_network_blackhole_detector_test.cc",
    "quic/core/quic_one_block_arena_test.cc",
    "quic/core/quic_packet_creator_test.cc",
    "quic/core/quic_packet_number_test.cc",
    "quic/core/quic_packets_test.cc",
    "quic/core/quic_path_validator_test.cc",
    "quic/core/quic_ping_manager_test.cc",
    "quic/core/quic_received_packet_manager_test.cc",
    "quic/core/quic_sent_packet_manager_test.cc",
    "quic/core/quic_server_id_test.cc",
    "quic/core/quic_session_test.cc",
    "quic/core/quic_socket_address_coder_test.cc",
    "quic/core/quic_stream_id_manager_test.cc",
    "quic/core/quic_stream_send_buffer_test.cc",
    "quic/core/quic_stream_sequencer_buffer_test.cc",
    "quic/core/quic_stream_sequencer_test.cc",
    "quic/core/quic_stream_test.cc",
    "quic/core/quic_sustained_bandwidth_recorder_test.cc",
    "quic/core/quic_tag_test.cc",
    "quic/core/quic_time_accumulator_test.cc",
    "quic/core/quic_time_test.cc",
    "quic/core/quic_time_wait_list_manager_test.cc",
    "quic/core/quic_trace_visitor_test.cc",
    "quic/core/quic_unacked_packet_map_test.cc",
    "quic/core/quic_utils_test.cc",
    "quic/core/quic_version_manager_test.cc",
    "quic/core/quic_versions_test.cc",
    "quic/core/quic_write_blocked_list_test.cc",
    "quic/core/tls_chlo_extractor_test.cc",
    "quic/core/tls_client_handshaker_test.cc",
    "quic/core/tls_server_handshaker_test.cc",
    "quic/core/uber_quic_stream_id_manager_test.cc",
    "quic/core/uber_received_packet_manager_test.cc",
    "quic/platform/api/quic_ip_address_test.cc",
    "quic/platform/api/quic_socket_address_test.cc",
    "quic/test_tools/crypto_test_utils_test.cc",
    "quic/test_tools/quic_test_utils_test.cc",
    "quic/test_tools/simple_session_notifier_test.cc",
    "quic/test_tools/simulator/quic_endpoint_test.cc",
    "quic/test_tools/simulator/simulator_test.cc",
    "quic/tools/quic_memory_cache_backend_test.cc",
    "quic/tools/quic_tcp_like_trace_converter_test.cc",
    "quic/tools/simple_ticket_crypter_test.cc",
    "spdy/core/array_output_buffer_test.cc",
    "spdy/core/hpack/hpack_decoder_adapter_test.cc",
    "spdy/core/hpack/hpack_encoder_test.cc",
    "spdy/core/hpack/hpack_entry_test.cc",
    "spdy/core/hpack/hpack_header_table_test.cc",
    "spdy/core/hpack/hpack_output_stream_test.cc",
    "spdy/core/hpack/hpack_round_trip_test.cc",
    "spdy/core/hpack/hpack_static_table_test.cc",
    "spdy/core/metadata_extension_test.cc",
    "spdy/core/spdy_alt_svc_wire_format_test.cc",
    "spdy/core/spdy_frame_builder_test.cc",
    "spdy/core/spdy_framer_test.cc",
    "spdy/core/spdy_header_block_test.cc",
    "spdy/core/spdy_header_storage_test.cc",
    "spdy/core/spdy_intrusive_list_test.cc",
    "spdy/core/spdy_pinnable_buffer_piece_test.cc",
    "spdy/core/spdy_prefixed_buffer_reader_test.cc",
    "spdy/core/spdy_protocol_test.cc",
    "spdy/core/spdy_simple_arena_test.cc",
]
epoll_tests_hdrs = [

]
epoll_tests_srcs = [
    "epoll_server/simple_epoll_server_test.cc",
    "quic/core/batch_writer/quic_batch_writer_buffer_test.cc",
    "quic/core/batch_writer/quic_batch_writer_test.cc",
    "quic/core/batch_writer/quic_gso_batch_writer_test.cc",
    "quic/core/batch_writer/quic_sendmmsg_batch_writer_test.cc",
    "quic/core/chlo_extractor_test.cc",
    "quic/core/http/end_to_end_test.cc",
    "quic/core/http/quic_spdy_client_session_test.cc",
    "quic/core/http/quic_spdy_client_stream_test.cc",
    "quic/core/http/quic_spdy_server_stream_base_test.cc",
    "quic/core/io/quic_all_event_loops_test.cc",
    "quic/core/io/quic_poll_event_loop_test.cc",
    "quic/core/io/socket_test.cc",
    "quic/core/quic_epoll_alarm_factory_test.cc",
    "quic/core/quic_epoll_clock_test.cc",
    "quic/core/quic_epoll_connection_helper_test.cc",
    "quic/core/quic_linux_socket_utils_test.cc",
    "quic/tools/quic_client_test.cc",
    "quic/tools/quic_server_test.cc",
    "quic/tools/quic_simple_server_session_test.cc",
    "quic/tools/quic_simple_server_stream_test.cc",
    "quic/tools/quic_url_test.cc",
]
fuzzers_hdrs = [

]
fuzzers_srcs = [
    "common/structured_headers_fuzzer.cc",
    "quic/core/crypto/certificate_view_der_fuzzer.cc",
    "quic/core/crypto/certificate_view_pem_fuzzer.cc",
    "quic/core/qpack/fuzzer/qpack_decoder_fuzzer.cc",
    "quic/core/qpack/fuzzer/qpack_decoder_stream_receiver_fuzzer.cc",
    "quic/core/qpack/fuzzer/qpack_decoder_stream_sender_fuzzer.cc",
    "quic/core/qpack/fuzzer/qpack_encoder_stream_receiver_fuzzer.cc",
    "quic/core/qpack/fuzzer/qpack_encoder_stream_sender_fuzzer.cc",
    "quic/core/qpack/fuzzer/qpack_round_trip_fuzzer.cc",
    "quic/test_tools/fuzzing/quic_framer_fuzzer.cc",
    "quic/test_tools/fuzzing/quic_framer_process_data_packet_fuzzer.cc",
]
cli_tools_hdrs = [
    "quic/tools/quic_epoll_client_factory.h",
    "quic/tools/quic_epoll_server_factory.h",
    "quic/tools/quic_toy_client.h",
    "quic/tools/quic_toy_server.h",
]
cli_tools_srcs = [
    "quic/masque/masque_client_bin.cc",
    "quic/masque/masque_server_bin.cc",
    "quic/tools/crypto_message_printer_bin.cc",
    "quic/tools/qpack_offline_decoder_bin.cc",
    "quic/tools/quic_client_bin.cc",
    "quic/tools/quic_client_interop_test_bin.cc",
    "quic/tools/quic_epoll_client_factory.cc",
    "quic/tools/quic_epoll_server_factory.cc",
    "quic/tools/quic_packet_printer_bin.cc",
    "quic/tools/quic_reject_reason_decoder_bin.cc",
    "quic/tools/quic_server_bin.cc",
    "quic/tools/quic_toy_client.cc",
    "quic/tools/quic_toy_server.cc",
]
nghttp2_hdrs = [
    "http2/adapter/callback_visitor.h",
    "http2/adapter/nghttp2.h",
    "http2/adapter/nghttp2_adapter.h",
    "http2/adapter/nghttp2_callbacks.h",
    "http2/adapter/nghttp2_data_provider.h",
    "http2/adapter/nghttp2_session.h",
    "http2/adapter/nghttp2_util.h",
]
nghttp2_srcs = [
    "http2/adapter/callback_visitor.cc",
    "http2/adapter/nghttp2_adapter.cc",
    "http2/adapter/nghttp2_callbacks.cc",
    "http2/adapter/nghttp2_data_provider.cc",
    "http2/adapter/nghttp2_session.cc",
    "http2/adapter/nghttp2_test.cc",
    "http2/adapter/nghttp2_util.cc",
]
nghttp2_test_support_hdrs = [
    "http2/adapter/mock_nghttp2_callbacks.h",
    "http2/adapter/nghttp2_test_utils.h",
]
nghttp2_test_support_srcs = [
    "http2/adapter/mock_nghttp2_callbacks.cc",
    "http2/adapter/nghttp2_test_utils.cc",
]
nghttp2_tests_hdrs = [

]
nghttp2_tests_srcs = [
    "http2/adapter/adapter_impl_comparison_test.cc",
    "http2/adapter/callback_visitor_test.cc",
    "http2/adapter/nghttp2_adapter_test.cc",
    "http2/adapter/nghttp2_data_provider_test.cc",
    "http2/adapter/nghttp2_session_test.cc",
    "http2/adapter/nghttp2_util_test.cc",
]
default_platform_impl_hdrs = [
    "common/platform/default/quiche_platform_impl/quic_flags_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_bug_tracker_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_client_stats_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_containers_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_export_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_flag_utils_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_flags_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_header_policy_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_iovec_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_logging_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_lower_case_string_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_mem_slice_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_mutex_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_prefetch_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_reference_counted_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_server_stats_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_stack_trace_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_testvalue_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_thread_local_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_time_utils_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_url_utils_impl.h",
]
default_platform_impl_srcs = [
    "common/platform/default/quiche_platform_impl/quic_flags_impl.cc",
    "common/platform/default/quiche_platform_impl/quiche_flags_impl.cc",
    "common/platform/default/quiche_platform_impl/quiche_mutex_impl.cc",
    "common/platform/default/quiche_platform_impl/quiche_stack_trace_impl.cc",
    "common/platform/default/quiche_platform_impl/quiche_time_utils_impl.cc",
    "common/platform/default/quiche_platform_impl/quiche_url_utils_impl.cc",
]
default_platform_impl_tool_support_hdrs = [
    "common/platform/default/quiche_platform_impl/quiche_command_line_flags_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_event_loop_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_file_utils_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_stream_buffer_allocator_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_system_event_loop_impl.h",
]
default_platform_impl_tool_support_srcs = [
    "common/platform/default/quiche_platform_impl/quiche_command_line_flags_impl.cc",
    "common/platform/default/quiche_platform_impl/quiche_file_utils_impl.cc",
]
default_platform_impl_test_support_hdrs = [
    "common/platform/default/quiche_platform_impl/quiche_expect_bug_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_test_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_test_loopback_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_test_output_impl.h",
    "common/platform/default/quiche_platform_impl/quiche_thread_impl.h",
]
default_platform_impl_test_support_srcs = [
    "common/platform/default/quiche_platform_impl/quiche_test_impl.cc",
    "common/platform/default/quiche_platform_impl/quiche_test_loopback_impl.cc",
]
load_balancer_hdrs = [
    "quic/load_balancer/load_balancer_config.h",
    "quic/load_balancer/load_balancer_decoder.h",
    "quic/load_balancer/load_balancer_encoder.h",
    "quic/load_balancer/load_balancer_server_id.h",
    "quic/load_balancer/load_balancer_server_id_map.h",
]
load_balancer_srcs = [
    "quic/load_balancer/load_balancer_config.cc",
    "quic/load_balancer/load_balancer_config_test.cc",
    "quic/load_balancer/load_balancer_decoder.cc",
    "quic/load_balancer/load_balancer_decoder_test.cc",
    "quic/load_balancer/load_balancer_encoder.cc",
    "quic/load_balancer/load_balancer_encoder_test.cc",
    "quic/load_balancer/load_balancer_server_id.cc",
    "quic/load_balancer/load_balancer_server_id_map_test.cc",
    "quic/load_balancer/load_balancer_server_id_test.cc",
]
qbone_hdrs = [
    "quic/qbone/bonnet/icmp_reachable.h",
    "quic/qbone/bonnet/icmp_reachable_interface.h",
    "quic/qbone/bonnet/mock_icmp_reachable.h",
    "quic/qbone/bonnet/mock_packet_exchanger_stats_interface.h",
    "quic/qbone/bonnet/mock_qbone_tunnel.h",
    "quic/qbone/bonnet/mock_tun_device.h",
    "quic/qbone/bonnet/mock_tun_device_controller.h",
    "quic/qbone/bonnet/qbone_tunnel_info.h",
    "quic/qbone/bonnet/qbone_tunnel_interface.h",
    "quic/qbone/bonnet/qbone_tunnel_silo.h",
    "quic/qbone/bonnet/tun_device.h",
    "quic/qbone/bonnet/tun_device_controller.h",
    "quic/qbone/bonnet/tun_device_interface.h",
    "quic/qbone/bonnet/tun_device_packet_exchanger.h",
    "quic/qbone/mock_qbone_client.h",
    "quic/qbone/mock_qbone_server_session.h",
    "quic/qbone/platform/icmp_packet.h",
    "quic/qbone/platform/internet_checksum.h",
    "quic/qbone/platform/ip_range.h",
    "quic/qbone/platform/kernel_interface.h",
    "quic/qbone/platform/mock_kernel.h",
    "quic/qbone/platform/mock_netlink.h",
    "quic/qbone/platform/netlink.h",
    "quic/qbone/platform/netlink_interface.h",
    "quic/qbone/platform/rtnetlink_message.h",
    "quic/qbone/platform/tcp_packet.h",
    "quic/qbone/qbone_client.h",
    "quic/qbone/qbone_client_interface.h",
    "quic/qbone/qbone_client_session.h",
    "quic/qbone/qbone_constants.h",
    "quic/qbone/qbone_control_stream.h",
    "quic/qbone/qbone_packet_exchanger.h",
    "quic/qbone/qbone_packet_processor.h",
    "quic/qbone/qbone_packet_processor_test_tools.h",
    "quic/qbone/qbone_packet_writer.h",
    "quic/qbone/qbone_server_session.h",
    "quic/qbone/qbone_session_base.h",
    "quic/qbone/qbone_stream.h",
]
qbone_srcs = [
    "quic/qbone/bonnet/icmp_reachable.cc",
    "quic/qbone/bonnet/icmp_reachable_test.cc",
    "quic/qbone/bonnet/qbone_tunnel_info.cc",
    "quic/qbone/bonnet/qbone_tunnel_silo.cc",
    "quic/qbone/bonnet/qbone_tunnel_silo_test.cc",
    "quic/qbone/bonnet/tun_device.cc",
    "quic/qbone/bonnet/tun_device_controller.cc",
    "quic/qbone/bonnet/tun_device_controller_test.cc",
    "quic/qbone/bonnet/tun_device_packet_exchanger.cc",
    "quic/qbone/bonnet/tun_device_packet_exchanger_test.cc",
    "quic/qbone/bonnet/tun_device_test.cc",
    "quic/qbone/platform/icmp_packet.cc",
    "quic/qbone/platform/icmp_packet_test.cc",
    "quic/qbone/platform/internet_checksum.cc",
    "quic/qbone/platform/internet_checksum_test.cc",
    "quic/qbone/platform/ip_range.cc",
    "quic/qbone/platform/ip_range_test.cc",
    "quic/qbone/platform/netlink.cc",
    "quic/qbone/platform/netlink_test.cc",
    "quic/qbone/platform/rtnetlink_message.cc",
    "quic/qbone/platform/rtnetlink_message_test.cc",
    "quic/qbone/platform/tcp_packet.cc",
    "quic/qbone/platform/tcp_packet_test.cc",
    "quic/qbone/qbone_client.cc",
    "quic/qbone/qbone_client_session.cc",
    "quic/qbone/qbone_client_test.cc",
    "quic/qbone/qbone_constants.cc",
    "quic/qbone/qbone_control_stream.cc",
    "quic/qbone/qbone_packet_exchanger.cc",
    "quic/qbone/qbone_packet_exchanger_test.cc",
    "quic/qbone/qbone_packet_processor.cc",
    "quic/qbone/qbone_packet_processor_test.cc",
    "quic/qbone/qbone_packet_processor_test_tools.cc",
    "quic/qbone/qbone_server_session.cc",
    "quic/qbone/qbone_session_base.cc",
    "quic/qbone/qbone_session_test.cc",
    "quic/qbone/qbone_stream.cc",
    "quic/qbone/qbone_stream_test.cc",
]
