/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 1.67 $ of : mfd-interface.m2c,v $ 
 *
 * $Id$
 */
/*
 * *********************************************************************
 * *********************************************************************
 * *********************************************************************
 * ***                                                               ***
 * ***  NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE  ***
 * ***                                                               ***
 * ***                                                               ***
 * ***       THIS FILE DOES NOT CONTAIN ANY USER EDITABLE CODE.      ***
 * ***                                                               ***
 * ***                                                               ***
 * ***       THE GENERATED CODE IS INTERNAL IMPLEMENTATION, AND      ***
 * ***                                                               ***
 * ***                                                               ***
 * ***    IS SUBJECT TO CHANGE WITHOUT WARNING IN FUTURE RELEASES.   ***
 * ***                                                               ***
 * ***                                                               ***
 * *********************************************************************
 * *********************************************************************
 * *********************************************************************
 */

/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-features.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "ipv6InterfaceTable.h"


#include <net-snmp/agent/table_container.h>
#include <net-snmp/library/container.h>

#include "ipv6InterfaceTable_interface.h"

#include "if-mib/ifTable/ifTable.h"

#include <ctype.h>

netsnmp_feature_require(row_merge)
netsnmp_feature_require(baby_steps)
netsnmp_feature_require(check_all_requests_error)

/**********************************************************************
 **********************************************************************
 ***
 *** Table ipv6InterfaceTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * IP-MIB::ipv6InterfaceTable is subid 30 of ip.
 * Its status is Current.
 * OID: .1.3.6.1.2.1.4.30, length: 8
 */
typedef struct ipv6InterfaceTable_interface_ctx_s {

    netsnmp_container *container;

    ipv6InterfaceTable_registration *user_ctx;

    netsnmp_table_registration_info tbl_info;

    netsnmp_baby_steps_access_methods access_multiplexer;

    u_long          last_changed;

} ipv6InterfaceTable_interface_ctx;

static ipv6InterfaceTable_interface_ctx ipv6InterfaceTable_if_ctx;

static void
                _ipv6InterfaceTable_container_init(ipv6InterfaceTable_interface_ctx *
                                                   if_ctx);
static void
                _ipv6InterfaceTable_container_shutdown(ipv6InterfaceTable_interface_ctx *
                                                       if_ctx);


netsnmp_container *
ipv6InterfaceTable_container_get(void)
{
    return ipv6InterfaceTable_if_ctx.container;
}

ipv6InterfaceTable_registration *
ipv6InterfaceTable_registration_get(void)
{
    return ipv6InterfaceTable_if_ctx.user_ctx;
}

ipv6InterfaceTable_registration *
ipv6InterfaceTable_registration_set(ipv6InterfaceTable_registration *
                                    newreg)
{
    ipv6InterfaceTable_registration *old =
        ipv6InterfaceTable_if_ctx.user_ctx;
    ipv6InterfaceTable_if_ctx.user_ctx = newreg;
    return old;
}

int
ipv6InterfaceTable_container_size(void)
{
    return CONTAINER_SIZE(ipv6InterfaceTable_if_ctx.container);
}

u_int
ipv6InterfaceTable_dirty_get(void)
{
    return ifTable_dirty_get();
}

void
ipv6InterfaceTable_dirty_set(u_int status)
{
    ifTable_dirty_set(status);
}

/*
 * ipv6InterfaceTableLastChanged, which is  the last time that a row in
 * the table was changed or the last time a row was added/deleted from the
 * table.
 */
void
ipv6InterfaceTable_lastChange_set(u_long table_changed)
{
    DEBUGMSGTL(("ipv6InterfaceTable:lastChanged_set",
                "called. was %ld, now %ld\n",
                ipv6InterfaceTable_if_ctx.last_changed, table_changed));
    ipv6InterfaceTable_if_ctx.last_changed = table_changed;
}

/*
 * mfd multiplexer modes
 */
static Netsnmp_Node_Handler _mfd_ipv6InterfaceTable_pre_request;
static Netsnmp_Node_Handler _mfd_ipv6InterfaceTable_post_request;
static Netsnmp_Node_Handler _mfd_ipv6InterfaceTable_object_lookup;
static Netsnmp_Node_Handler _mfd_ipv6InterfaceTable_get_values;
#ifndef NETSNMP_DISABLE_SET_SUPPORT
static Netsnmp_Node_Handler _mfd_ipv6InterfaceTable_check_objects;
static Netsnmp_Node_Handler _mfd_ipv6InterfaceTable_undo_setup;
static Netsnmp_Node_Handler _mfd_ipv6InterfaceTable_set_values;
static Netsnmp_Node_Handler _mfd_ipv6InterfaceTable_undo_cleanup;
static Netsnmp_Node_Handler _mfd_ipv6InterfaceTable_undo_values;
static Netsnmp_Node_Handler _mfd_ipv6InterfaceTable_commit;
static Netsnmp_Node_Handler _mfd_ipv6InterfaceTable_undo_commit;
static Netsnmp_Node_Handler _mfd_ipv6InterfaceTable_irreversible_commit;

NETSNMP_STATIC_INLINE int
                _ipv6InterfaceTable_undo_column(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx,
                                                netsnmp_variable_list *
                                                var, int column);
#endif

/**
 * @internal
 * Initialize the table ipv6InterfaceTable 
 *    (Define its contents and how it's structured)
 */
void
_ipv6InterfaceTable_initialize_interface(ipv6InterfaceTable_registration *
                                         reg_ptr, u_long flags)
{
    netsnmp_baby_steps_access_methods *access_multiplexer =
        &ipv6InterfaceTable_if_ctx.access_multiplexer;
    netsnmp_table_registration_info *tbl_info =
        &ipv6InterfaceTable_if_ctx.tbl_info;
    netsnmp_handler_registration *reginfo;
    netsnmp_mib_handler *handler;
    int             mfd_modes = 0;

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_ipv6InterfaceTable_initialize_interface", "called\n"));


    /*************************************************
     *
     * save interface context for ipv6InterfaceTable
     */
    /*
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_indexes(tbl_info, ASN_INTEGER,
                                               /** index: ipv6InterfaceIfIndex */
                                     0);

    /*
     * Define the minimum and maximum accessible columns.  This
     * optimizes retrieval. 
     */
    tbl_info->min_column = IPV6INTERFACETABLE_MIN_COL;
    tbl_info->max_column = IPV6INTERFACETABLE_MAX_COL;

    /*
     * save users context
     */
    ipv6InterfaceTable_if_ctx.user_ctx = reg_ptr;

    /*
     * call data access initialization code
     */
    ipv6InterfaceTable_init_data(reg_ptr);

    /*
     * set up the container
     */
    _ipv6InterfaceTable_container_init(&ipv6InterfaceTable_if_ctx);
    if (NULL == ipv6InterfaceTable_if_ctx.container) {
        snmp_log(LOG_ERR,
                 "could not initialize container for ipv6InterfaceTable\n");
        return;
    }

    /*
     * access_multiplexer: REQUIRED wrapper for get request handling
     */
    access_multiplexer->object_lookup =
        _mfd_ipv6InterfaceTable_object_lookup;
    access_multiplexer->get_values = _mfd_ipv6InterfaceTable_get_values;

    /*
     * no wrappers yet
     */
    access_multiplexer->pre_request = _mfd_ipv6InterfaceTable_pre_request;
    access_multiplexer->post_request =
        _mfd_ipv6InterfaceTable_post_request;


#ifndef NETSNMP_DISABLE_SET_SUPPORT
    /*
     * REQUIRED wrappers for set request handling
     */
    access_multiplexer->object_syntax_checks =
        _mfd_ipv6InterfaceTable_check_objects;
    access_multiplexer->undo_setup = _mfd_ipv6InterfaceTable_undo_setup;
    access_multiplexer->undo_cleanup =
        _mfd_ipv6InterfaceTable_undo_cleanup;
    access_multiplexer->set_values = _mfd_ipv6InterfaceTable_set_values;
    access_multiplexer->undo_sets = _mfd_ipv6InterfaceTable_undo_values;

    /*
     * no wrappers yet
     */
    access_multiplexer->commit = _mfd_ipv6InterfaceTable_commit;
    access_multiplexer->undo_commit = _mfd_ipv6InterfaceTable_undo_commit;
    access_multiplexer->irreversible_commit =
        _mfd_ipv6InterfaceTable_irreversible_commit;
#endif

    /*************************************************
     *
     * Create a registration, save our reg data, register table.
     */
    DEBUGMSGTL(("ipv6InterfaceTable:init_ipv6InterfaceTable",
                "Registering ipv6InterfaceTable as a mibs-for-dummies table.\n"));
    handler =
        netsnmp_baby_steps_access_multiplexer_get(access_multiplexer);
    reginfo =
        netsnmp_handler_registration_create("ipv6InterfaceTable", handler,
                                            ipv6InterfaceTable_oid,
                                            ipv6InterfaceTable_oid_size,
                                            HANDLER_CAN_BABY_STEP |
#ifndef NETSNMP_DISABLE_SET_SUPPORT
                                            HANDLER_CAN_RWRITE
#else
                                            HANDLER_CAN_RONLY
#endif /* NETSNMP_DISABLE_SET_SUPPORT */
                                          );
    if (NULL == reginfo) {
        snmp_log(LOG_ERR, "error registering table ipv6InterfaceTable\n");
        return;
    }
    reginfo->my_reg_void = &ipv6InterfaceTable_if_ctx;

    /*************************************************
     *
     * set up baby steps handler, create it and inject it
     */
    if (access_multiplexer->object_lookup)
        mfd_modes |= BABY_STEP_OBJECT_LOOKUP;
    if (access_multiplexer->pre_request)
        mfd_modes |= BABY_STEP_PRE_REQUEST;
    if (access_multiplexer->post_request)
        mfd_modes |= BABY_STEP_POST_REQUEST;

#ifndef NETSNMP_DISABLE_SET_SUPPORT
    if (access_multiplexer->set_values)
        mfd_modes |= BABY_STEP_SET_VALUES;
    if (access_multiplexer->irreversible_commit)
        mfd_modes |= BABY_STEP_IRREVERSIBLE_COMMIT;
    if (access_multiplexer->object_syntax_checks)
        mfd_modes |= BABY_STEP_CHECK_OBJECT;

    if (access_multiplexer->undo_setup)
        mfd_modes |= BABY_STEP_UNDO_SETUP;
    if (access_multiplexer->undo_cleanup)
        mfd_modes |= BABY_STEP_UNDO_CLEANUP;
    if (access_multiplexer->undo_sets)
        mfd_modes |= BABY_STEP_UNDO_SETS;

    if (access_multiplexer->row_creation)
        mfd_modes |= BABY_STEP_ROW_CREATE;
    if (access_multiplexer->consistency_checks)
        mfd_modes |= BABY_STEP_CHECK_CONSISTENCY;
    if (access_multiplexer->commit)
        mfd_modes |= BABY_STEP_COMMIT;
    if (access_multiplexer->undo_commit)
        mfd_modes |= BABY_STEP_UNDO_COMMIT;
#endif

    handler = netsnmp_baby_steps_handler_get(mfd_modes);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject row_merge helper with prefix rootoid_len + 2 (entry.col)
     */
    handler = netsnmp_get_row_merge_handler(reginfo->rootoid_len + 2);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject container_table helper
     */
    handler =
        netsnmp_container_table_handler_get(tbl_info,
                                            ipv6InterfaceTable_if_ctx.
                                            container,
                                            TABLE_CONTAINER_KEY_NETSNMP_INDEX);
    netsnmp_inject_handler(reginfo, handler);

    /*
     * register table
     */
    netsnmp_register_table(reginfo, tbl_info);

    /*
     * register LastChanged
     */
    {
        oid             lc_oid[] = { IPV6INTERFACETABLELASTCHANGE_OID };
        netsnmp_register_watched_scalar2(netsnmp_create_handler_registration
                                        ("ipv6TableLastChanged", NULL,
                                         lc_oid, OID_LENGTH(lc_oid),
                                         HANDLER_CAN_RONLY),
                                        netsnmp_create_watcher_info((void
                                                                     *)
                                                                    &ipv6InterfaceTable_if_ctx.
                                                                    last_changed,
                                                                    sizeof
                                                                    (u_long),
                                                                    ASN_TIMETICKS,
                                                                    WATCHER_FIXED_SIZE));
    }
}                               /* _ipv6InterfaceTable_initialize_interface */

/**
 * @internal
 * Shutdown the table ipv6InterfaceTable
 */
void
_ipv6InterfaceTable_shutdown_interface(ipv6InterfaceTable_registration *
                                       reg_ptr)
{
    /*
     * shutdown the container
     */
    _ipv6InterfaceTable_container_shutdown(&ipv6InterfaceTable_if_ctx);
}

void
ipv6InterfaceTable_valid_columns_set(netsnmp_column_info *vc)
{
    ipv6InterfaceTable_if_ctx.tbl_info.valid_columns = vc;
}                               /* ipv6InterfaceTable_valid_columns_set */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ipv6InterfaceTable_pre_request(netsnmp_mib_handler *handler,
                                    netsnmp_handler_registration *reginfo,
                                    netsnmp_agent_request_info
                                    *agtreq_info,
                                    netsnmp_request_info *requests)
{
    int             rc;

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_mfd_ipv6InterfaceTable_pre_request", "called\n"));

    if (1 != netsnmp_row_merge_status_first(reginfo, agtreq_info)) {
        DEBUGMSGTL(("internal:ipv6InterfaceTable",
                    "skipping additional pre_request\n"));
        return SNMP_ERR_NOERROR;
    }

    rc = ipv6InterfaceTable_pre_request(ipv6InterfaceTable_if_ctx.
                                        user_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("ipv6InterfaceTable", "error %d from "
                    "ipv6InterfaceTable_pre_request\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipv6InterfaceTable_pre_request */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ipv6InterfaceTable_post_request(netsnmp_mib_handler *handler,
                                     netsnmp_handler_registration *reginfo,
                                     netsnmp_agent_request_info
                                     *agtreq_info,
                                     netsnmp_request_info *requests)
{
    int             rc, packet_rc;

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_mfd_ipv6InterfaceTable_post_request", "called\n"));

    /*
     * wait for last call before calling user
     */
    if (1 != netsnmp_row_merge_status_last(reginfo, agtreq_info)) {
        DEBUGMSGTL(("internal:ipv6InterfaceTable",
                    "waiting for last post_request\n"));
        return SNMP_ERR_NOERROR;
    }

    packet_rc = netsnmp_check_all_requests_error(agtreq_info->asp, 0);
    if ((MFD_SUCCESS != packet_rc) && ipv6InterfaceTable_dirty_get()) {
        /*
         * we shouldn't get here. the undo steps should also clear
         * the dirty flags.
         */
        snmp_log(LOG_WARNING,
                 "ipv6InterfaceTable dirty flag set in post_request "
                 "but status != SUCCESS.\n");
    }

    rc = ipv6InterfaceTable_post_request(ipv6InterfaceTable_if_ctx.
                                         user_ctx, packet_rc);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("ipv6InterfaceTable", "error %d from "
                    "ipv6InterfaceTable_post_request\n", rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipv6InterfaceTable_post_request */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ipv6InterfaceTable_object_lookup(netsnmp_mib_handler *handler, netsnmp_handler_registration
                                      *reginfo, netsnmp_agent_request_info
                                      *agtreq_info,
                                      netsnmp_request_info *requests)
{
    int             rc = SNMP_ERR_NOERROR;
    ipv6InterfaceTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_mfd_ipv6InterfaceTable_object_lookup", "called\n"));

    /*
     * get our context from mfd
     * ipv6InterfaceTable_interface_ctx *if_ctx =
     *             (ipv6InterfaceTable_interface_ctx *)reginfo->my_reg_void;
     */

    if (NULL == rowreq_ctx) {
        rc = SNMP_ERR_NOCREATION;
    }

    if (MFD_SUCCESS != rc)
        netsnmp_request_set_error_all(requests, rc);
    else
        ipv6InterfaceTable_row_prep(rowreq_ctx);

    return SNMP_VALIDATE_ERR(rc);
}                               /* _mfd_ipv6InterfaceTable_object_lookup */

/***********************************************************************
 *
 * GET processing
 *
 ***********************************************************************/
/*
 * @internal
 * Retrieve the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ipv6InterfaceTable_get_column(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx,
                               netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_mfd_ipv6InterfaceTable_get_column", "called for %d\n", column));


    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ipv6InterfaceReasmMaxSize(2)/UNSIGNED32/ASN_UNSIGNED/u_long(u_long)//l/A/w/e/R/d/h 
         */
    case COLUMN_IPV6INTERFACEREASMMAXSIZE:
        var->val_len = sizeof(u_long);
        var->type = ASN_UNSIGNED;
        rc = ipv6InterfaceReasmMaxSize_get(rowreq_ctx,
                                           (u_long *) var->val.string);
        break;

        /*
         * ipv6InterfaceIdentifier(3)/Ipv6AddressIfIdentifierTC/ASN_OCTET_STR/char(char)//L/A/w/e/R/d/H 
         */
    case COLUMN_IPV6INTERFACEIDENTIFIER:
        var->type = ASN_OCTET_STR;
        rc = ipv6InterfaceIdentifier_get(rowreq_ctx,
                                         (char **) &var->val.string,
                                         &var->val_len);
        break;

        /*
         * ipv6InterfaceEnableStatus(5)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPV6INTERFACEENABLESTATUS:
        var->val_len = sizeof(u_long);
        var->type = ASN_INTEGER;
        rc = ipv6InterfaceEnableStatus_get(rowreq_ctx,
                                           (u_long *) var->val.string);
        break;

        /*
         * ipv6InterfaceReachableTime(6)/UNSIGNED32/ASN_UNSIGNED/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPV6INTERFACEREACHABLETIME:
        var->val_len = sizeof(u_long);
        var->type = ASN_UNSIGNED;
        rc = ipv6InterfaceReachableTime_get(rowreq_ctx,
                                            (u_long *) var->val.string);
        break;

        /*
         * ipv6InterfaceRetransmitTime(7)/UNSIGNED32/ASN_UNSIGNED/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPV6INTERFACERETRANSMITTIME:
        var->val_len = sizeof(u_long);
        var->type = ASN_UNSIGNED;
        rc = ipv6InterfaceRetransmitTime_get(rowreq_ctx,
                                             (u_long *) var->val.string);
        break;

        /*
         * ipv6InterfaceForwarding(8)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPV6INTERFACEFORWARDING:
        var->val_len = sizeof(u_long);
        var->type = ASN_INTEGER;
        rc = ipv6InterfaceForwarding_get(rowreq_ctx,
                                         (u_long *) var->val.string);
        break;

    default:
        if (COLUMN_IPV6INTERFACEREASMMAXSIZE <= column && column <= COLUMN_IPV6INTERFACEFORWARDING) {
            DEBUGMSGTL(("internal:${context}:_ipv6InterfaceTable_get_column",
                "assume column %d is reserved\n", column));
            rc = MFD_SKIP;
        } else {
            snmp_log(LOG_ERR,
                     "unknown column %d in _ipv6InterfaceTable_get_column\n",
                     column);
        }
        break;
    }

    return rc;
}                               /* _ipv6InterfaceTable_get_column */

int
_mfd_ipv6InterfaceTable_get_values(netsnmp_mib_handler *handler,
                                   netsnmp_handler_registration *reginfo,
                                   netsnmp_agent_request_info *agtreq_info,
                                   netsnmp_request_info *requests)
{
    ipv6InterfaceTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    u_char         *old_string;
    void            (*dataFreeHook) (void *);
    int             rc;

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_mfd_ipv6InterfaceTable_get_values", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    for (; requests; requests = requests->next) {
        /*
         * save old pointer, so we can free it if replaced
         */
        old_string = requests->requestvb->val.string;
        dataFreeHook = requests->requestvb->dataFreeHook;
        if (NULL == requests->requestvb->val.string) {
            requests->requestvb->val.string = requests->requestvb->buf;
            requests->requestvb->val_len =
                sizeof(requests->requestvb->buf);
        } else if (requests->requestvb->buf ==
                   requests->requestvb->val.string) {
            if (requests->requestvb->val_len !=
                sizeof(requests->requestvb->buf))
                requests->requestvb->val_len =
                    sizeof(requests->requestvb->buf);
        }

        /*
         * get column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ipv6InterfaceTable_get_column(rowreq_ctx,
                                            requests->requestvb,
                                            tri->colnum);
        if (rc) {
            if (MFD_SKIP == rc) {
                requests->requestvb->type = SNMP_NOSUCHINSTANCE;
                rc = SNMP_ERR_NOERROR;
            }
        } else if (NULL == requests->requestvb->val.string) {
            snmp_log(LOG_ERR, "NULL varbind data pointer!\n");
            rc = SNMP_ERR_GENERR;
        }
        if (rc)
            netsnmp_request_set_error(requests, SNMP_VALIDATE_ERR(rc));

        /*
         * if the buffer wasn't used previously for the old data (i.e. it
         * was allcoated memory)  and the get routine replaced the pointer,
         * we need to free the previous pointer.
         */
        if (old_string && (old_string != requests->requestvb->buf) &&
            (requests->requestvb->val.string != old_string)) {
            if (dataFreeHook)
                (*dataFreeHook) (old_string);
            else
                free(old_string);
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipv6InterfaceTable_get_values */


#ifndef NETSNMP_DISABLE_SET_SUPPORT
/***********************************************************************
 *
 * SET processing
 *
 ***********************************************************************/

/*----------------------------------------------------------------------
 *
 * SET: Syntax checks
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Check the syntax for a particular column
 */
NETSNMP_STATIC_INLINE int
_ipv6InterfaceTable_check_column(ipv6InterfaceTable_rowreq_ctx *
                                 rowreq_ctx, netsnmp_variable_list * var,
                                 int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_ipv6InterfaceTable_check_column", "called for %d\n", column));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {
        /*
         * (INDEX) ipv6InterfaceIfIndex(1)/InterfaceIndex/ASN_INTEGER/long(long)//l/a/w/e/R/d/H 
         */
    case COLUMN_IPV6INTERFACEIFINDEX:
        rc = SNMP_ERR_NOTWRITABLE;      /* can not change index of active row */
        break;

        /*
         * ipv6InterfaceReasmMaxSize(2)/UNSIGNED32/ASN_UNSIGNED/u_long(u_long)//l/A/w/e/R/d/h 
         */
    case COLUMN_IPV6INTERFACEREASMMAXSIZE:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ipv6InterfaceIdentifier(3)/Ipv6AddressIfIdentifierTC/ASN_OCTET_STR/char(char)//L/A/w/e/R/d/H 
         */
    case COLUMN_IPV6INTERFACEIDENTIFIER:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ipv6InterfaceEnableStatus(5)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPV6INTERFACEENABLESTATUS:
        rc = netsnmp_check_vb_type_and_size(var, ASN_INTEGER,
                                            sizeof(rowreq_ctx->data.
                                                   ipv6InterfaceEnableStatus));
        /*
         * check that the value is one of defined enums 
         */
        if ((SNMPERR_SUCCESS == rc)
            && (*var->val.integer != IPV6INTERFACEENABLESTATUS_UP)
            && (*var->val.integer != IPV6INTERFACEENABLESTATUS_DOWN)
            ) {
            rc = SNMP_ERR_WRONGVALUE;
        }
        if (SNMPERR_SUCCESS != rc) {
            DEBUGMSGTL(("ipv6InterfaceTable:_ipv6InterfaceTable_check_column:ipv6InterfaceEnableStatus", "varbind validation failed (eg bad type or size)\n"));
        } else {
            rc = ipv6InterfaceEnableStatus_check_value(rowreq_ctx,
                                                       *((u_long *) var->
                                                         val.string));
            if ((MFD_SUCCESS != rc) && (MFD_NOT_VALID_EVER != rc)
                && (MFD_NOT_VALID_NOW != rc)) {
                snmp_log(LOG_ERR,
                         "bad rc %d from ipv6InterfaceEnableStatus_check_value\n",
                         rc);
                rc = SNMP_ERR_GENERR;
            }
        }
        break;

        /*
         * ipv6InterfaceReachableTime(6)/UNSIGNED32/ASN_UNSIGNED/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPV6INTERFACEREACHABLETIME:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ipv6InterfaceRetransmitTime(7)/UNSIGNED32/ASN_UNSIGNED/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPV6INTERFACERETRANSMITTIME:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ipv6InterfaceForwarding(8)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPV6INTERFACEFORWARDING:
        rc = netsnmp_check_vb_type_and_size(var, ASN_INTEGER,
                                            sizeof(rowreq_ctx->data.
                                                   ipv6InterfaceForwarding));
        /*
         * check that the value is one of defined enums 
         */
        if ((SNMPERR_SUCCESS == rc)
            && (*var->val.integer != IPV6INTERFACEFORWARDING_FORWARDING)
            && (*var->val.integer != IPV6INTERFACEFORWARDING_NOTFORWARDING)
            ) {
            rc = SNMP_ERR_WRONGVALUE;
        }
        if (SNMPERR_SUCCESS != rc) {
            DEBUGMSGTL(("ipv6InterfaceTable:_ipv6InterfaceTable_check_column:ipv6InterfaceForwarding", "varbind validation failed (eg bad type or size)\n"));
        } else {
            rc = ipv6InterfaceForwarding_check_value(rowreq_ctx,
                                                     *((u_long *) var->val.
                                                       string));
            if ((MFD_SUCCESS != rc) && (MFD_NOT_VALID_EVER != rc)
                && (MFD_NOT_VALID_NOW != rc)) {
                snmp_log(LOG_ERR,
                         "bad rc %d from ipv6InterfaceForwarding_check_value\n",
                         rc);
                rc = SNMP_ERR_GENERR;
            }
        }
        break;

    default:   /** We shouldn't get here */
        rc = SNMP_ERR_GENERR;
        snmp_log(LOG_ERR,
                 "unknown column %d in _ipv6InterfaceTable_check_column\n",
                 column);
    }

    return rc;
}                               /* _ipv6InterfaceTable_check_column */

int
_mfd_ipv6InterfaceTable_check_objects(netsnmp_mib_handler *handler, netsnmp_handler_registration
                                      *reginfo, netsnmp_agent_request_info
                                      *agtreq_info,
                                      netsnmp_request_info *requests)
{
    ipv6InterfaceTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    int             rc;

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_mfd_ipv6InterfaceTable_check_objects", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    for (; requests; requests = requests->next) {

        /*
         * get column number from table request info, and check that column
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ipv6InterfaceTable_check_column(rowreq_ctx,
                                              requests->requestvb,
                                              tri->colnum);
        if (rc) {
            netsnmp_request_set_error(requests, SNMP_VALIDATE_ERR(rc));
            break;
        }

    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipv6InterfaceTable_check_objects */


/*----------------------------------------------------------------------
 *
 * SET: Undo setup
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Set the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ipv6InterfaceTable_undo_setup_column(ipv6InterfaceTable_rowreq_ctx *
                                      rowreq_ctx, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_ipv6InterfaceTable_undo_setup_column", "called for %d\n", column));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ipv6InterfaceEnableStatus(5)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPV6INTERFACEENABLESTATUS:
        rowreq_ctx->column_set_flags |=
            COLUMN_IPV6INTERFACEENABLESTATUS_FLAG;
        rc = ipv6InterfaceEnableStatus_undo_setup(rowreq_ctx);
        break;

        /*
         * ipv6InterfaceForwarding(8)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPV6INTERFACEFORWARDING:
        rowreq_ctx->column_set_flags |=
            COLUMN_IPV6INTERFACEFORWARDING_FLAG;
        rc = ipv6InterfaceForwarding_undo_setup(rowreq_ctx);
        break;

    default:
        snmp_log(LOG_ERR,
                 "unknown column %d in _ipv6InterfaceTable_undo_setup_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _ipv6InterfaceTable_undo_setup_column */


/**
 * @internal
 * undo setup
 */
int
_mfd_ipv6InterfaceTable_undo_setup(netsnmp_mib_handler *handler,
                                   netsnmp_handler_registration *reginfo,
                                   netsnmp_agent_request_info *agtreq_info,
                                   netsnmp_request_info *requests)
{
    int             rc;
    ipv6InterfaceTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_mfd_ipv6InterfaceTable_undo_setup", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * allocate undo context
     */
    rc = _mfd_ifTable_undo_setup_allocate(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        netsnmp_request_set_error_all(requests,rc);
        return SNMP_ERR_NOERROR;
    }

    /*
     * row undo setup
     */
    rc = ipv6InterfaceTable_undo_setup(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        DEBUGMSGTL(("ipv6InterfaceTable:mfd", "error %d from "
                    "ipv6InterfaceTable_undo_setup\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    } else {
        /*
         * column undo setup
         */
        netsnmp_table_request_info *tri;
        for (; requests; requests = requests->next) {
            /*
             * set column data
             */
            tri = netsnmp_extract_table_info(requests);
            if (NULL == tri)
                continue;

            rc = _ipv6InterfaceTable_undo_setup_column(rowreq_ctx,
                                                       tri->colnum);
            if (MFD_SUCCESS != rc) {
                DEBUGMSGTL(("ipv6InterfaceTable:mfd", "error %d from "
                            "ipv6InterfaceTable_undo_setup_column\n", rc));
                netsnmp_set_request_error(agtreq_info, requests,
                                          SNMP_VALIDATE_ERR(rc));
            }
        }                       /* for results */
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipv6InterfaceTable_undo_setup */

/**
 * @internal
 * undo setup
 */
int
_mfd_ipv6InterfaceTable_undo_cleanup(netsnmp_mib_handler *handler,
                                     netsnmp_handler_registration *reginfo,
                                     netsnmp_agent_request_info
                                     *agtreq_info,
                                     netsnmp_request_info *requests)
{
    ipv6InterfaceTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    int             rc;

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_mfd_ipv6InterfaceTable_undo_cleanup", "called\n"));

    /*
     * failed row create in early stages has no rowreq_ctx
     */
    if (NULL == rowreq_ctx)
        return MFD_SUCCESS;

    /*
     * call user cleanup
     */
    rc = ipv6InterfaceTable_undo_cleanup(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("ipv6InterfaceTable:mfd", "error %d from "
                    "ipv6InterfaceTable_undo_cleanup\n", rc));
    }

    /*
     * release undo context, if needed
     */
    _mfd_ifTable_undo_setup_release(rowreq_ctx);

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipv6InterfaceTable_undo_cleanup */

/*----------------------------------------------------------------------
 *
 * SET: Set values
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Set the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ipv6InterfaceTable_set_column(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx,
                               netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_ipv6InterfaceTable_set_column", "called for %d\n", column));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ipv6InterfaceEnableStatus(5)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPV6INTERFACEENABLESTATUS:
        rowreq_ctx->column_set_flags |=
            COLUMN_IPV6INTERFACEENABLESTATUS_FLAG;
        rc = ipv6InterfaceEnableStatus_set(rowreq_ctx,
                                           *((u_long *) var->val.string));
        break;

        /*
         * ipv6InterfaceForwarding(8)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPV6INTERFACEFORWARDING:
        rowreq_ctx->column_set_flags |=
            COLUMN_IPV6INTERFACEFORWARDING_FLAG;
        rc = ipv6InterfaceForwarding_set(rowreq_ctx,
                                         *((u_long *) var->val.string));
        break;

    default:
        snmp_log(LOG_ERR,
                 "unknown column %d in _ipv6InterfaceTable_set_column\n",
                 column);
        rc = SNMP_ERR_GENERR;
        break;
    }

    return rc;
}                               /* _ipv6InterfaceTable_set_column */

int
_mfd_ipv6InterfaceTable_set_values(netsnmp_mib_handler *handler,
                                   netsnmp_handler_registration *reginfo,
                                   netsnmp_agent_request_info *agtreq_info,
                                   netsnmp_request_info *requests)
{
    ipv6InterfaceTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    int             rc = SNMP_ERR_NOERROR;

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_mfd_ipv6InterfaceTable_set_values", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rowreq_ctx->column_set_flags = 0;
    for (; requests; requests = requests->next) {
        /*
         * set column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ipv6InterfaceTable_set_column(rowreq_ctx,
                                            requests->requestvb,
                                            tri->colnum);
        if (MFD_SUCCESS != rc) {
            DEBUGMSGTL(("ipv6InterfaceTable:mfd", "error %d from "
                        "ipv6InterfaceTable_set_column\n", rc));
            netsnmp_set_request_error(agtreq_info, requests,
                                      SNMP_VALIDATE_ERR(rc));
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipv6InterfaceTable_set_values */

/*----------------------------------------------------------------------
 *
 * SET: commit
 *
 *---------------------------------------------------------------------*/
/**
 * @internal
 * commit the values
 */
int
_mfd_ipv6InterfaceTable_commit(netsnmp_mib_handler *handler,
                               netsnmp_handler_registration *reginfo,
                               netsnmp_agent_request_info *agtreq_info,
                               netsnmp_request_info *requests)
{
    int             rc;
    ipv6InterfaceTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_mfd_ipv6InterfaceTable_commit", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rc = ipv6InterfaceTable_commit(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        DEBUGMSGTL(("ipv6InterfaceTable:mfd", "error %d from "
                    "ipv6InterfaceTable_commit\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    if (rowreq_ctx->rowreq_flags & MFD_ROW_DIRTY) {
        /*
         * if we successfully commited this row, set the dirty flag. Use the
         * current value + 1 (i.e. dirty = # rows changed).
         * this is checked in post_request...
         */
        ipv6InterfaceTable_dirty_set(ipv6InterfaceTable_dirty_get() + 1);       /* set table dirty flag */
    }

    return SNMP_ERR_NOERROR;
}

int
_mfd_ipv6InterfaceTable_undo_commit(netsnmp_mib_handler *handler,
                                    netsnmp_handler_registration *reginfo,
                                    netsnmp_agent_request_info
                                    *agtreq_info,
                                    netsnmp_request_info *requests)
{
    int             rc;
    ipv6InterfaceTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_mfd_ipv6InterfaceTable_undo_commit", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    if (rowreq_ctx->rowreq_flags & MFD_ROW_DIRTY) {
        u_int           d = ipv6InterfaceTable_dirty_get();

        netsnmp_assert(d != 0);
        if (d)
            ipv6InterfaceTable_dirty_set(d - 1);
    }

    rc = ipv6InterfaceTable_undo_commit(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("ipv6InterfaceTable:mfd", "error %d from "
                    "ipv6InterfaceTable_undo_commit\n", rc));
    }

    if (rowreq_ctx->rowreq_flags & MFD_ROW_DIRTY) {
        snmp_log(LOG_WARNING,
                 "ipv6InterfaceTable row dirty flag still set after undo_commit\n");
        rowreq_ctx->rowreq_flags &= ~MFD_ROW_DIRTY;
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipv6InterfaceTable_commit */

/*----------------------------------------------------------------------
 *
 * SET: Undo
 *
 *---------------------------------------------------------------------*/
/**
 * @internal
 * undo the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ipv6InterfaceTable_undo_column(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx,
                                netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_ipv6InterfaceTable_undo_column", "called for %d\n", column));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ipv6InterfaceEnableStatus(5)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPV6INTERFACEENABLESTATUS:
        rc = ipv6InterfaceEnableStatus_undo(rowreq_ctx);
        break;

        /*
         * ipv6InterfaceForwarding(8)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPV6INTERFACEFORWARDING:
        rc = ipv6InterfaceForwarding_undo(rowreq_ctx);
        break;

    default:
        snmp_log(LOG_ERR,
                 "unknown column %d in _ipv6InterfaceTable_undo_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _ipv6InterfaceTable_undo_column */

int
_mfd_ipv6InterfaceTable_undo_values(netsnmp_mib_handler *handler,
                                    netsnmp_handler_registration *reginfo,
                                    netsnmp_agent_request_info
                                    *agtreq_info,
                                    netsnmp_request_info *requests)
{
    int             rc;
    ipv6InterfaceTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_mfd_ipv6InterfaceTable_undo_values", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rc = ipv6InterfaceTable_undo(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("ipv6InterfaceTable:mfd", "error %d from "
                    "ipv6InterfaceTable_undo\n", rc));
    }

    for (; requests; requests = requests->next) {
        /*
         * set column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ipv6InterfaceTable_undo_column(rowreq_ctx,
                                             requests->requestvb,
                                             tri->colnum);
        if (MFD_SUCCESS != rc) {
            /*
             * nothing we can do about it but log it
             */
            DEBUGMSGTL(("ipv6InterfaceTable:mfd", "error %d from "
                        "ipv6InterfaceTable_undo_column\n", rc));
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipv6InterfaceTable_undo_values */

/*----------------------------------------------------------------------
 *
 * SET: irreversible commit
 *
 *---------------------------------------------------------------------*/
/**
 * @internal
 * commit irreversible actions
 */
int
_mfd_ipv6InterfaceTable_irreversible_commit(netsnmp_mib_handler *handler, netsnmp_handler_registration
                                            *reginfo, netsnmp_agent_request_info
                                            *agtreq_info,
                                            netsnmp_request_info *requests)
{
    ipv6InterfaceTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ipv6InterfaceTable:_mfd_ipv6InterfaceTable_irreversible:commit", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * check for and handle row creation/deletion
     * and update column exist flags...
     */
    if (rowreq_ctx->rowreq_flags & MFD_ROW_DELETED) {
        CONTAINER_REMOVE(ipv6InterfaceTable_if_ctx.container, rowreq_ctx);
    } else {
        if (rowreq_ctx->column_set_flags) {
            rowreq_ctx->column_set_flags = 0;
        }
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipv6InterfaceTable_irreversible_commit */
#endif

/***********************************************************************
 *
 * DATA ACCESS
 *
 ***********************************************************************/
/**
 * @internal
 */
static void
_container_free(netsnmp_container *container)
{
    DEBUGMSGTL(("internal:ipv6InterfaceTable:_container_free",
                "called\n"));

    if (NULL == container) {
        snmp_log(LOG_ERR,
                 "invalid container in ipv6InterfaceTable_container_free\n");
        return;
    }

    /*
     * call user code
     */
    ipv6InterfaceTable_container_free(container);
}                               /* _container_free */

/**
 * @internal
 * initialize the container with functions or wrappers
 */
void
_ipv6InterfaceTable_container_init(ipv6InterfaceTable_interface_ctx *
                                   if_ctx)
{
    DEBUGMSGTL(("internal:ipv6InterfaceTable:_ipv6InterfaceTable_container_init", "called\n"));

    /*
     * container init
     */
    ipv6InterfaceTable_container_init(&if_ctx->container);
    if (NULL == if_ctx->container)
        if_ctx->container =
            netsnmp_container_find("ipv6InterfaceTable:table_container");
    if (NULL == if_ctx->container) {
        snmp_log(LOG_ERR, "error creating container in "
                 "ipv6InterfaceTable_container_init\n");
        return;
    }
    if_ctx->container->container_name = strdup("ipv6InterfaceTable");
}                               /* _ipv6InterfaceTable_container_init */

/**
 * @internal
 * shutdown the container with functions or wrappers
 */
void
_ipv6InterfaceTable_container_shutdown(ipv6InterfaceTable_interface_ctx *
                                       if_ctx)
{
    DEBUGMSGTL(("internal:ipv6InterfaceTable:_ipv6InterfaceTable_container_shutdown", "called\n"));

    ipv6InterfaceTable_container_shutdown(if_ctx->container);

    _container_free(if_ctx->container);

}                               /* _ipv6InterfaceTable_container_shutdown */


ipv6InterfaceTable_rowreq_ctx *
ipv6InterfaceTable_row_find_by_mib_index(ipv6InterfaceTable_mib_index *
                                         mib_idx)
{
    ipv6InterfaceTable_rowreq_ctx *rowreq_ctx;
    oid             oid_tmp[MAX_OID_LEN];
    netsnmp_index   oid_idx;
    int             rc;

    /*
     * set up storage for OID
     */
    oid_idx.oids = oid_tmp;
    oid_idx.len = sizeof(oid_tmp) / sizeof(oid);

    /*
     * convert
     */
    rc = ifTable_index_to_oid(&oid_idx, mib_idx);
    if (MFD_SUCCESS != rc)
        return NULL;

    rowreq_ctx =
        CONTAINER_FIND(ipv6InterfaceTable_if_ctx.container, &oid_idx);

    return rowreq_ctx;
}
