#  Contributor License Agreement

We are incredibly thankful for the contributions we receive from the community.
We require our external contributors to sign a Contributor License Agreement ("CLA") in
order to ensure that our projects remain licensed under Free and Open Source licenses such
as BSD-3 while allowing Wiretrustee to build a sustainable business.

Wiretrustee is committed to having a true Open Source Software ("OSS") license for
our software. A CLA enables Wiretrustee to safely commercialize our products
while keeping a standard OSS license with all the rights that license grants to users: the
ability to use the project in their own projects or businesses, to republish modified
source, or to completely fork the project.

This page gives a human-friendly summary of our CLA, details on why we require a CLA, how
contributors can sign our CLA, and more. You may view the full legal CLA document (below).

# Human-friendly summary

This is a human-readable summary of (and not a substitute for) the full agreement (below).
This highlights only some of key terms of the CLA. It has no legal value and you should
carefully review all the terms of the actual CLA before agreeing.

<li>Grant of copyright license. You give Wiretrustee permission to use your copyrighted work
in commercial products.
</li>

<li>Grant of patent license. If your contributed work uses a patent, you give Wiretrustee a
license to use that patent including within commercial products. You also agree that you
have permission to grant this license.
</li>

<li>No Warranty or Support Obligations.
By making a contribution, you are not obligating yourself to provide support for the
contribution, and you are not taking on any warranty obligations or providing any
assurances about how it will perform.
</li>

The CLA does not change the terms of the standard open source license used by our software
such as BSD-3 or MIT.
You are still free to use our projects within your own projects or businesses, republish
modified source, and more.
Please reference the appropriate license for the project you're contributing to to learn
more.

# Why require a CLA?

Agreeing to a CLA explicitly states that you are entitled to provide a contribution, that you cannot withdraw permission
to use your contribution at a later date, and that Wiretrustee has permission to use your contribution in our commercial
products.

This removes any ambiguities or uncertainties caused by not having a CLA and allows users and customers to confidently
adopt our projects. At the same time, the CLA ensures that all contributions to our open source projects are licensed
under the project's respective open source license, such as BSD-3.

Requiring a CLA is a common and well-accepted practice in open source. Major open source projects require CLAs such as
Apache Software Foundation projects, Facebook projects (such as React), Google projects (including Go), Python, Django,
and more. Each of these projects remains licensed under permissive OSS licenses such as MIT, Apache, BSD, and more.

# Signing the CLA

Open a pull request ("PR") to any of our open source projects to sign the CLA. A bot will comment on the PR asking you
to sign the CLA if you haven't already.

Follow the steps given by the bot to sign the CLA. This will require you to log in with GitHub (we only request public
information from your account) and to fill in a few additional details such as your name and email address. We will only
use this information for CLA tracking; none of your submitted information will be used for marketing purposes.

You only have to sign the CLA once. Once you've signed the CLA, future contributions to any Wiretrustee project will not
require you to sign again.

# Legal Terms and Agreement

In order to clarify the intellectual property license granted with Contributions from any person or entity, Wiretrustee
UG (haftungsbeschränkt) ("Wiretrustee") must have a Contributor License Agreement ("CLA") on file that has been signed
by each Contributor, indicating agreement to the license terms below. This license does not change your rights to use
your own Contributions for any other purpose.

You accept and agree to the following terms and conditions for Your present and future Contributions submitted to
Wiretrustee. Except for the license granted herein to Wiretrustee and recipients of software distributed by Wiretrustee,
You reserve all right, title, and interest in and to Your Contributions.

1. Definitions.

    ```
   "You" (or "Your") shall mean the copyright owner or legal entity authorized by the copyright owner 
   that is making this Agreement with Wiretrustee. For legal entities, the entity making a Contribution and all other 
   entities that control, are controlled by, or are under common control with that entity are considered 
   to be a single Contributor. For the purposes of this definition, "control" means (i) the power, direct or indirect,
    to cause the direction or management of such entity, whether by contract or otherwise, or (ii) ownership of fifty 
   percent (50%) or more of the outstanding shares, or (iii) beneficial ownership of such entity.
   ```
   ```
    "Contribution" shall mean any original work of authorship, including any modifications or additions to 
   an existing work, that is or previously has been intentionally submitted by You to Wiretrustee for inclusion in, 
   or documentation of, any of the products owned or managed by Wiretrustee (the "Work"). 
   For the purposes of this definition, "submitted" means any form of electronic, verbal, or written communication 
   sent to Wiretrustee or its representatives, including but not limited to communication on electronic mailing lists, 
   source code control systems, and issue tracking systems that are managed by, or on behalf of, 
   Wiretrustee for the purpose of discussing and improving the Work, but excluding communication that is conspicuously 
   marked or otherwise designated in writing by You as "Not a Contribution."
   ```

2. Grant of Copyright License. Subject to the terms and conditions of this Agreement, You hereby grant to Wiretrustee
   and to recipients of software distributed by Wiretrustee a perpetual, worldwide, non-exclusive, no-charge,
   royalty-free, irrevocable copyright license to reproduce, prepare derivative works of, publicly display, publicly
   perform, sublicense, and distribute Your Contributions and such derivative works.


3. Grant of Patent License. Subject to the terms and conditions of this Agreement, You hereby grant to Wiretrustee and
   to recipients of software distributed by Wiretrustee a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
   irrevocable (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import,
   and otherwise transfer the Work, where such license applies only to those patent claims licensable by You that are
   necessarily infringed by Your Contribution(s) alone or by combination of Your Contribution(s) with the Work to which
   such Contribution(s) was submitted. If any entity institutes patent litigation against You or any other entity (
   including a cross-claim or counterclaim in a lawsuit) alleging that your Contribution, or the Work to which you have
   contributed, constitutes direct or contributory patent infringement, then any patent licenses granted to that entity
   under this Agreement for that Contribution or Work shall terminate as of the date such litigation is filed.


4. You represent that you are legally entitled to grant the above license. If your employer(s) has rights to
   intellectual property that you create that includes your Contributions, you represent that you have received
   permission to make Contributions on behalf of that employer, that you will have received permission from your current
   and future employers for all future Contributions, that your applicable employer has waived such rights for all of
   your current and future Contributions to Wiretrustee, or that your employer has executed a separate Corporate CLA
   with Wiretrustee.


5. You represent that each of Your Contributions is Your original creation (see section 7 for submissions on behalf of
   others). You represent that Your Contribution submissions include complete details of any third-party license or
   other restriction (including, but not limited to, related patents and trademarks) of which you are personally aware
   and which are associated with any part of Your Contributions.


6. You are not expected to provide support for Your Contributions, except to the extent You desire to provide support.
   You may provide support for free, for a fee, or not at all. Unless required by applicable law or agreed to in
   writing, You provide Your Contributions on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
   express or implied, including, without limitation, any warranties or conditions of TITLE, NON- INFRINGEMENT,
   MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE.


7. Should You wish to submit work that is not Your original creation, You may submit it to Wiretrustee separately from
   any Contribution, identifying the complete details of its source and of any license or other restriction (including,
   but not limited to, related patents, trademarks, and license agreements) of which you are personally aware, and
   conspicuously marking the work as "Submitted on behalf of a third-party: [named here]".


8. You agree to notify Wiretrustee of any facts or circumstances of which you become aware that would make these
   representations inaccurate in any respect.