"use strict";module.exports=function(n){require("source-map-support").install();var r=require("./modbus-basics"),d=require("./core/modbus-core"),u=require("./core/modbus-io-core"),l=require("debug")("contribModbus:read");n.nodes.registerType("modbus-read",function(e){n.nodes.createNode(this,e),this.name=e.name,this.topic=e.topic,this.unitid=e.unitid,this.dataType=e.dataType,this.adr=e.adr,this.quantity=e.quantity||1,this.rate=e.rate,this.rateUnit=e.rateUnit,this.delayOnStart=e.delayOnStart,this.startDelayTime=parseInt(e.startDelayTime)||10,this.showStatusActivities=e.showStatusActivities,this.showErrors=e.showErrors,this.connection=null,this.useIOFile=e.useIOFile,this.ioFile=n.nodes.getNode(e.ioFile),this.useIOForPayload=e.useIOForPayload,this.logIOActivities=e.logIOActivities,this.emptyMsgOnFail=e.emptyMsgOnFail,this.internalDebugLog=l,this.verboseLogging=n.settings.verbose;var s=this,o=!1;function t(e){n.settings.verbose&&s.warn("Read -> "+e+" address: "+s.adr)}s.INPUT_TIMEOUT_MILLISECONDS=1e3,s.statusText="waiting",s.delayTimerReading=!1,s.intervalTimerIdReading=!1,a(s.statusText),t("open node "+s.id);var i=n.nodes.getNode(e.server);function a(e){var t,i;"polling"===e&&o||(t=r.setNodeStatusProperties(e,s.showStatusActivities),i=s.statusText,-1!==e.search("active")||"polling"===e?(e=t.status+(" ( "+s.rate+" "+r.get_timeUnit_name(s.rateUnit))+" ) ",o=!1,e!==i&&s.status({fill:t.fill,shape:t.shape,text:e})):(e=t.status)!==i&&s.status({fill:t.fill,shape:t.shape,text:e}))}i&&(s.onModbusInit=function(){a("initialized")},s.onModbusConnect=function(){a("connected"),s.resetAllReadingTimer(),s.initializeReadingTimer()},s.onModbusRegister=function(){s.showStatusActivities&&a("registered"),i.serialSendingAllowed&&(s.resetAllReadingTimer(),s.initializeReadingTimer(),a("connected"))},s.onModbusActive=function(){a("active")},s.onModbusQueue=function(){a("queue")},s.onModbusError=function(e){a("failure"),i.reconnectOnTimeout&&s.resetAllReadingTimer(),s.showErrors&&s.warn(e)},s.onModbusClose=function(){a("closed"),s.resetAllReadingTimer()},s.onModbusBroken=function(){a("broken"),i.reconnectOnTimeout&&(a("reconnecting after "+i.reconnectTimeout+" msec."),s.resetAllReadingTimer())},s.onModbusReadDone=function(e,t){s.showStatusActivities&&a("reading done");var i,o,n=e.data,r=t.topic||s.topic;s.useIOFile&&s.ioFile.lastUpdatedAt?(s.logIOActivities&&u.internalDebug("node.adr:"+s.adr+" node.quantity:"+s.quantity),i=u.nameValuesFromIOFile(s,t,n,e,s.adr),i=u.filterValueNames(s,i,d.functionCodeModbusRead(s.dataType),s.adr,s.quantity),o={topic:r,responseBuffer:e,input:t,sendingNodeId:s.id},s.useIOForPayload?(o.payload=i,o.values=n):(o.payload=n,o.valueNames=i),s.send([o,{topic:r,payload:e,values:n,input:t,valueNames:i,sendingNodeId:s.id}])):s.send([{topic:r,payload:n,responseBuffer:e,input:t,sendingNodeId:s.id},{topic:r,payload:e,values:n,input:t,sendingNodeId:s.id}])},s.errorProtocolMsg=function(e,t){s.showErrors&&r.logMsgError(s,e,t)},s.onModbusReadError=function(e,t){s.internalDebugLog(e.message),s.errorProtocolMsg(e,t),r.sendEmptyMsgOnFail(s,e,t),r.setModbusError(s,i,e,t)},s.modbusPollingRead=function(){var e;i.client?(e={topic:s.topic||"polling",from:s.name,payload:{unitid:s.unitid,fc:d.functionCodeModbusRead(s.dataType),address:s.adr,quantity:s.quantity,messageId:d.getObjectId()}},s.showStatusActivities&&a("polling"),i.emit("readModbus",e,s.onModbusReadDone,s.onModbusReadError)):a("waiting")},s.resetDelayTimerToRead=function(e){e.delayTimerReading&&(t("resetDelayTimerToRead node "+e.id),clearTimeout(e.delayTimerReading)),e.delayTimerReading=null},s.resetIntervalToRead=function(e){e.intervalTimerIdReading&&(t("resetIntervalToRead node "+e.id),clearInterval(e.intervalTimerIdReading)),e.intervalTimerIdReading=null},s.resetAllReadingTimer=function(){s.resetDelayTimerToRead(s),s.resetIntervalToRead(s)},s.resetAllReadingTimer(),s.startIntervalReading=function(){s.intervalTimerIdReading||(t("startIntervalReading node "+s.id),s.intervalTimerIdReading=setInterval(s.modbusPollingRead,r.calc_rateByUnit(s.rate,s.rateUnit)))},s.initializeReadingTimer=function(){s.resetAllReadingTimer(),s.delayOnStart?(t("initializeReadingTimer delay timer node "+s.id),s.delayTimerReading=setTimeout(s.startIntervalReading,s.INPUT_TIMEOUT_MILLISECONDS*s.startDelayTime)):s.startIntervalReading()},s.removeNodeListenerFromModbusClient=function(){i.removeListener("mbinit",s.onModbusInit),i.removeListener("mbqueue",s.onModbusQueue),i.removeListener("mbconnected",s.onModbusConnect),i.removeListener("mbactive",s.onModbusActive),i.removeListener("mberror",s.onModbusError),i.removeListener("mbclosed",s.onModbusClose),i.removeListener("mbbroken",s.onModbusBroken),i.removeListener("mbregister",s.onModbusRegister),i.removeListener("mbderegister",s.onModbusClose)},this.on("close",function(e){s.resetAllReadingTimer(),s.removeNodeListenerFromModbusClient(),a("closed"),t("close node "+s.id),i.deregisterForModbus(s.id,e)}),s.showStatusActivities&&(i.on("mbinit",s.onModbusInit),i.on("mbqueue",s.onModbusQueue)),i.on("mbconnected",s.onModbusConnect),i.on("mbactive",s.onModbusActive),i.on("mberror",s.onModbusError),i.on("mbclosed",s.onModbusClose),i.on("mbbroken",s.onModbusBroken),i.on("mbregister",s.onModbusRegister),i.on("mbderegister",s.onModbusClose),i.registerForModbus(s))}),n.httpAdmin.post("/modbus/read/inject/:id",n.auth.needsPermission("modbus.inject.write"),function(t,i){t=n.nodes.getNode(t.params.id);if(t)try{t.modbusPollingRead(),i.sendStatus(200)}catch(e){i.sendStatus(500),t.error(n._("modbusinject.failed",{error:e.toString()}))}else i.sendStatus(404)})};
//# sourceMappingURL=maps/modbus-read.js.map
