/*
 * Decompiled with CFR 0.152.
 */
package org.olsr.v1.info.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import org.olsr.v1.info.api.util.CompareUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class JsonInfoRoutesEntry
implements Comparable<JsonInfoRoutesEntry> {
    private String destination = "";
    private int destinationPrefixLength = 0;
    private String gateway = "";
    private long metric = 0L;
    private double etx = Double.POSITIVE_INFINITY;
    private double rtpMetricCost = Double.POSITIVE_INFINITY;
    private String networkInterface = "";

    public String getDestination() {
        return this.destination;
    }

    @JsonProperty(value="destination")
    public void setDestination(InetAddress destination) {
        this.destination = destination == null ? "" : destination.getHostAddress();
    }

    public int getDestinationPrefixLength() {
        return this.destinationPrefixLength;
    }

    @JsonProperty(value="genmask")
    public void setDestinationPrefixLength(int destinationPrefixLength) {
        this.destinationPrefixLength = destinationPrefixLength;
    }

    public String getGateway() {
        return this.gateway;
    }

    @JsonProperty(value="gateway")
    public void setGateway(InetAddress gateway) {
        this.gateway = gateway == null ? "" : gateway.getHostAddress();
    }

    public long getMetric() {
        return this.metric;
    }

    @JsonProperty(value="metric")
    public void setMetric(long metric) {
        this.metric = metric;
    }

    public double getEtx() {
        return this.etx;
    }

    @JsonProperty(value="etx")
    public void setEtx(double etx) {
        this.etx = Double.compare(etx, 4.294967295E9) >= 0 ? Double.POSITIVE_INFINITY : etx;
    }

    public double getRtpMetricCost() {
        return this.rtpMetricCost;
    }

    @JsonProperty(value="rtpMetricCost")
    public void setRtpMetricCost(double rtpMetricCost) {
        this.rtpMetricCost = Double.compare(rtpMetricCost, 4.294967295E9) >= 0 ? Double.POSITIVE_INFINITY : rtpMetricCost;
    }

    public String getNetworkInterface() {
        return this.networkInterface;
    }

    @JsonProperty(value="networkInterface")
    public void setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface == null ? "" : networkInterface;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.destination.hashCode();
        result = 31 * result + this.destinationPrefixLength;
        result = 31 * result + this.gateway.hashCode();
        result = 31 * result + (int)(this.metric ^ this.metric >>> 32);
        long temp = Double.doubleToLongBits(this.etx);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.rtpMetricCost);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.networkInterface.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.compareTo((JsonInfoRoutesEntry)other) == 0;
    }

    @Override
    public int compareTo(JsonInfoRoutesEntry other) {
        if (other == null) {
            return -1;
        }
        int result = this.gateway.compareTo(other.gateway);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        result = this.destination.compareTo(other.destination);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        result = Integer.compare(this.destinationPrefixLength, other.destinationPrefixLength);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.metric, other.metric);
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.etx, other.etx);
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.rtpMetricCost, other.rtpMetricCost);
        if (result != 0) {
            return result;
        }
        result = this.networkInterface.compareTo(other.networkInterface);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JsonInfoRoutesEntry [destination=");
        builder.append(this.destination);
        builder.append(", destinationPrefixLength=");
        builder.append(this.destinationPrefixLength);
        builder.append(", gateway=");
        builder.append(this.gateway);
        builder.append(", metric=");
        builder.append(this.metric);
        builder.append(", etx=");
        builder.append(this.etx);
        builder.append(", rtpMetricCost=");
        builder.append(this.rtpMetricCost);
        builder.append(", networkInterface=");
        builder.append(this.networkInterface);
        builder.append("]");
        return builder.toString();
    }
}

