--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: Content Group Process Client Mapping
version: 7
description: Group of Process Name to Client App detectors.
bundle_description: $VAR1 = {
          'TeamViewer' => 'Remote desktop control and file transfer software.',
          'Minecraft' => 'Online game.',
          'Kaspersky' => 'Kaspersky Antivirus/Security software download and updates.',
          'Instapaper' => 'App to save wb pages for later use.',
          'CactusVPN' => 'A VPN client.',
          'Office 365' => 'Traffic generated by MS Office 365 applications and web services.',
          'Betternet' => 'A VPN tunneling app.',
          'GoToMeeting' => 'Online meeting and desktop sharing service.',
          'iCloud' => 'Apple cloud storage service.',
          'SugarSync' => 'Cloud-based backup service.',
          'Snapchat' => 'Online photo sharing.',
          'Kugou' => 'Peer-to-peer music.',
          'Apple Update' => 'Apple software updating tool.',
          'Avast' => 'Anti-virus software for Windows PCs.',
          'Kaspersky Network Agent' => 'Kaspersky Network Agent facilitates interaction between the Administration server and Kaspersky lab products.',
          'MongoDB' => 'Source-available cross-platform document-oriented database program.',
          'MagicJack' => 'Magic Jack is a USB device that allows any phone to make free calls within the US and Canada.',
          'IMO' => 'Microsoft Outlook with Internet Mail Only option.',
          'Nessus' => 'Active network scanner.',
          'SVN' => 'Managing Subversion servers.',
          'WeatherBug' => 'Windows weather application.',
          'GoodSync' => 'File transfer and synchronization service.',
          'KakaoTalk' => 'Mobile messaging for smartphones.',
          'Quake' => 'First person shooter.',
          'Flash Video' => 'Multimedia file format and Streaming video using Adobe Flash plugin.',
          'TextNow' => 'Instant text and voice services.',
          'RealVNC' => 'A VNC package that supports client and server side, and also provides cloud-based services such as chat and file transfer.',
          'Adobe Connect' => 'Online meeting and collaboration system.',
          'Code42' => 'Enterprise data management and security software.',
          'OCSPD' => 'Framework for Online certificate validation.',
          'DuckDuckGo' => 'Search engine.',
          'Draw.io' => 'Online diagram and flowchart application.',
          'Meter' => 'Registered with IANA on port 570 TCP/UDP.',
          'Grammarly' => 'Digital writing tool using artificial intelligence and natural language processing (auto corecting tool).',
          'Google' => 'Traffic generated by the Google search engine or one of the other many Internet services provided by Google Inc.',
          'Xcode' => 'Apple\'s IDE.',
          'Sharepoint' => 'Microsoft collaboration, file sharing and web publishing system.',
          'SurfEasy VPN' => 'VPN traffic generated by SurfEasy VPN.',
          'QuickBooks' => 'Intuit online accounting software.',
          'PureVPN' => 'Traffic generated by PureVPN.',
          'RDP' => 'Remote Desktop Protocol provides users with a graphical interface to another computer.',
          'YouTubeMp3' => 'An online service for converting videos to mp3.',
          'Zalo' => 'Free messaging and calling application.',
          'Syncplicity' => 'Data synch service.',
          'Yandex' => 'Russian search engine.',
          'BlueJeans' => 'An interoperable cloud-based video conferencing service.',
          'RuneScape' => 'Browser based fantasy role-playing game.',
          'TripIt' => 'Cloud based travel planner.',
          'Yammer' => 'Enterprise social networking site.',
          'LogMeIn' => 'Remote access and PC desktop control.',
          'iTunes' => 'Apple\'s media player and online store.',
          'BITS' => 'Background Intelligent Transfer Service. A file transfer protocol for Microsoft Updates.',
          'YouTube' => 'A video-sharing website on which users can upload, share, and view videos.',
          'Steam' => 'Massive gaming and communications platform.',
          'Twitter' => 'Social networking and microblogging site.',
          'Box' => 'File storage and transfer site.',
          'Prezi' => 'Presentation tool.',
          'QQ' => 'Chinese instant messaging software.',
          'Anghami' => 'Music streaming site.',
          'GitHub' => 'Code management portal for open Source projects.',
          'Baidu' => 'Chinese Search engine.',
          'Trend Micro' => 'Security software company.',
          'Adobe Software' => 'Adobe software and updates.',
          'Disney Plus' => 'Disney+ is a video on-demand streaming subscription.',
          'Duo Security' => 'A user-centric access security platform that provides two-factor authentication, endpoint security, remote access solutions and a subsidiary of Cisco.',
          'Amazon Web Services' => 'Online cloud computing service.',
          'Clip2Net' => 'Yandex cloud storage that acts like a clipboard.',
          'CloudMe' => 'Web desktop service.',
          'cURL' => 'Utility for HTTP access.',
          'Ultrasurf' => 'Freeware anti-censorship proxy.',
          'TurboVPN' => 'A VPN client on mobile devices.',
          'Flickr' => 'An image hosting and video hosting website, web services suite, and online community.',
          'Groove' => 'Microsoft desktop application designed for document collaboration.',
          'PDF Expert' => 'App for iPad to view and endit PDF files.',
          'PHP' => 'Scripting language for developing server based web applications.',
          'Gateway' => 'Manufacturer and retailer of PCs.',
          'Bria' => 'VoIP based software for video calls and instant messaging.',
          'Signal' => 'Signal is a cross-platform centralized encrypted messaging service developed by the Signal Technology Foundation and Signal Messenger LLC.',
          'Internet Explorer' => 'A Microsoft web browser.',
          'Autodesk' => 'A CAD and 3D printing software company.',
          'Asus' => 'Manufacturer of PCs and PC components.',
          'TwitchTV' => 'Justin.tv gaming specific livestreaming platform.',
          'Verizon Wireless' => 'Telecom and Internet provider.',
          'Pocket' => 'App to save web pages.',
          'NetNewsWire' => 'News feed and aggregator for iOS.',
          'Apple Maps' => 'Apple maps and navigation.',
          'Webex Teams' => 'Webex Teams is a collaboration tool with various clients (Windows, OS X, Android, Windows Mobile, iPad, iPhone, Web) for messages, calls, meetings, etc.',
          'Cisco Secure Endpoint' => 'Cloud-based real time antivirus protection. (AMP for Endpoints).',
          'WPS Office' => 'Mobile app for viewing and editing documents, spreadsheet and PPTs.',
          'Chrome' => 'Google\'s web browser.',
          'RingCentral' => 'RingCentral is an American publicly traded provider of cloud-based communications and collaboration solutions for businesses.',
          'MyHeritage' => 'Family oriented social networking service.',
          'Ngrok' => 'Multiplatform tunnelling, reverse proxy software.',
          'Power BI' => 'Power BI is a business analytics service by Microsoft which aims to provide interactive visualizations and business intelligence capabilities.',
          'Prime Video' => 'Amazon video streaming site.',
          'Apple Stocks' => 'Stock related updates.',
          'Skype' => 'A software application that allows users to chat, make voice/video calls, and transfer files over the Internet.',
          'Deezer' => 'Music streaming service based in Paris.',
          'iBooks' => 'Mobile app for download and read e-books.',
          'Zoho' => 'A Web- based online office suite containing word processing, spreadsheets, presentations, databases, note-taking, wikis, CRM, project management, invoicing and other applications developed by ZOHO Corporation.',
          'Feedly' => 'News Aggregator.',
          'PTP' => 'Performance Transparency Protocol.',
          'Mobile Safari' => 'Apple web browser for mobile devices.',
          'CyberGhost VPN' => 'An anonymizer that obfuscates web usage.',
          'Splunk' => 'System log aggregator.',
          'Kodi' => 'Open source media player.',
          'Apple Developer' => 'Web portal for Apple Developer.',
          'Thunderbird' => 'Mozilla email client.',
          'Wondershare' => 'Offers Video Software, PDF Tools, PC Utilities for Mac and Win users.',
          'Epic' => 'Software that uses the Health Level 7 protocol.',
          'Quicken' => 'Intuit personal finance software.',
          'Google Analytics' => 'Google service that tracks and generates detailed web statistics.',
          'iHeartRadio' => 'Website that provides streaming access to local and digital-only radio stations.',
          'Battle.net' => 'Game networking service.',
          'Apple News' => 'Apple News is an app the brings news and magazines, all in one place.',
          'Dropbox' => 'Cloud based file storage.',
          'Logitech' => 'Company develops Computer peripherals and accessories.',
          'BitTorrent' => 'A peer-to-peer file sharing protocol used for transferring large amounts of data.',
          'Amazon Cloud Player' => 'Media player by Amazon facilitates listening music from cloud or download on the device.',
          'Evolution' => 'Gnome email client.',
          'Java' => 'Java based application.',
          'JetBrains' => 'A collection of IDEs for different programming languages and frameworks.',
          'Shazam' => 'Media Playing and sharing application.',
          'Nmap' => 'Network Mapper, a security scanner.',
          'Letterpress' => 'Word game for iOS.',
          'LINE' => 'Mobile and Desktop App for Instant Messaging.',
          'TweetDeck' => 'Dashboard application to manage both Twitter and Facebook.',
          'Thousand Eyes' => 'Software that performances of network.',
          'Walkme' => 'Software-as-a-service company that helps users navigate the features of other web-based services.',
          'TOR' => 'The Onion Router. A client which allows a user to send and relay internet traffic anonymously.',
          'Hola' => 'An open source VPN.',
          'TuneIn' => 'Online Radio station.',
          'Facetime' => 'Apple video conferencing software.',
          'Apple TV' => 'Apple device to receive the media traffics from Internet or Local networks.',
          'Hide My Ass!' => 'Web surfing anonymizer.',
          'Target' => 'Discount retailer.',
          'Drift' => 'Conversational marketing platform.',
          'Adobe Creative Cloud' => 'Adobe cloud services.',
          'Microsoft Visual Studio' => 'Microsoft Integrated Developer Environment and toolchain designed to make it easier to develop software for Microsoft platforms.',
          'DDM' => 'IBM Lotus Domino domain monitoring, a management system for Domino networks.',
          'Firefox' => 'A mozilla web browser.',
          'Lenovo' => 'Company manufactures/markets computers, software and related services.',
          'Glide' => 'Cross-platform web desktop that allows for file sharing between different computers and mobile devices.',
          'WebEx' => 'Cisco\'s online meeting and web conferencing application.',
          'Zoho Assist' => 'A remote support and remote access software.',
          'Python urllib' => 'Python library for opening URLs.',
          'ExpressVPN' => 'A paid VPN platform with desktop and mobile apps.',
          'Wireguard' => 'An open-source VPN.',
          'KMail' => 'KDE email client.',
          'Yandex Disk' => 'A Yandex cloud storage product.',
          'Aliwangwang' => 'Instant messaging.',
          'Hide.me VPN' => 'VPN traffic generated by Hide.me vpn.',
          'Monitor' => 'Registered with IANA on port 561 TCP/UDP.',
          'Wow' => 'A search engine.',
          'SSH' => 'Secure Shell is a network protocol that allows data to be exchanged using a secure channel between two networked devices.',
          'Tanium' => 'Endpoint security and systems management software.',
          'Roblox' => 'Online gaming platform.',
          'DLS' => 'Directory Location Service, registered with IANA on port 197 tcp/udp.',
          'WhatsApp' => 'A cross-platform mobile messaging app which serves as a free alternative to SMS messages.',
          'Google Earth' => 'Google\'s virtual globe, map and geographical information program.',
          'WinSCP' => 'A free SFTP and FTP client for Windows.',
          'rlogin' => 'Unix utility that allows remote administration from one computer to another.',
          'Zoho Mail' => 'Zoho webmail.',
          'DotVPN' => 'A VPN Tunneling app.',
          'Blackjack' => 'Registered with IANA on port 1025 tcp/udp.',
          'BitDefender' => 'BitDefender Antivirus/Security software download and updates.',
          'McAfee' => 'McAfee Antivirus/Security software download and updates.',
          'Windows Media Player' => 'Microsoft application that plays files and streams, both audio and video.',
          'AnyConnect' => 'Cisco VPN server.',
          'Zoho Chat' => 'A web-enabled group chat application.',
          'Discord' => 'VoIP, instant messaging and digital distribution platform designed for creating communities.',
          'Zoho Connect' => 'A team collaboration software.',
          'Honey' => 'Digital tool to find the best savings, perks, and all around value, coupons and discounts.',
          'Squid' => 'HTTP Proxy server.',
          'WeChat' => 'Mobile text and voice messaging application.',
          'Google Drive' => 'A free office suite and cloud storage system hosted by Google.',
          'Telegram' => 'Telegram is a messaging app with a focus on speed and security.',
          'OpenDNS' => 'DNS service for reliability and security for internet surfers.',
          'Asana' => 'Collboration service.',
          'Google Desktop' => 'Google\'s Desktop search and desktop gadget software.',
          'LastPass' => 'Password management application.',
          'Linphone' => 'VoIP application using SIP.',
          'Atom' => 'Atom is a web content syndication system similar to RSS.',
          'Zoho Docs' => 'Online document management software that lets you manage and store all your files on the cloud.',
          'Mathworks' => 'Producers of MATLAB and other tools for science and engineering.',
          'Spotify' => 'Social Music Player.',
          'Microsoft Teams' => 'Microsoft Teams is a unified communication and collaboration platform for workplace communication exchange.',
          'ADrive' => 'Online file storage and backup.',
          'Eclipse' => 'Software Updates for Eclipse.',
          'Coc Coc' => 'Vietnamese search engine and advertising platform.',
          'Panda' => 'Panda Security Antivirus/Security software download and updates.',
          'World of Warcraft' => 'Massively multiplayer online role-playing game.',
          'TurboTax' => 'Intuit tax preparation software.',
          'Flock' => 'A web browser.',
          'Slack' => 'Chat and messaging app.',
          'Tableau' => 'Tableau Software is an interactive data visualization and data analytics software which provides pictorial and graphical representations of data.',
          'Jira' => 'Web based bug tracking and project management tool.',
          'New Relic' => 'Web metrics site.',
          'Canva' => 'Graphic design software.',
          'Wget' => 'Application that allows HTTP access.',
          'Winamp' => 'Media player for Windows PCs.',
          'Babylon' => 'Search engine, Translation and Dictionary toolbar.',
          'Edge' => 'Microsoft web browser.',
          'Messenger' => 'Facebook\'s standalone messenger app.',
          'Resilio Sync' => 'Syncs files and folders across devices. Formerly BitTorrent Sync.',
          'Netease' => 'Chinese web portal.',
          'Monster VPN' => 'Monster VPN is a free VPN proxy, to get connected quickly to unblock sites, WiFi hotspot secure and protect privacy.',
          'Zoom' => 'Remote conferencing via cloud computing.',
          'Ninite' => 'A tool that manages installation and upgrading of apps.',
          'Libwww-Perl' => 'Library for World wide web service.',
          'Printer Pro Desktop' => 'Software to print using the printer connected to Mac.',
          'Hotspot Shield' => 'Anonymizer and tunnel that encrypts communications.',
          'AnyDesk' => 'Remote Desktop Access Software.',
          'Facebook' => 'Facebook is a social networking service.',
          'Google Update' => 'A client that handles automated updates of Google apps.',
          'Webshots' => 'Service for uploading and sharing photos and videos.',
          'VyprVPN Login' => 'Logins to VyprVPN, a personal VPN service.',
          'Evernote' => 'Synched note taking and web bookmarking app.',
          'Pandora' => 'Audio streaming.',
          'Psiphon' => 'Web proxy/anonymizer.',
          'PaleMoon' => 'A web browser.',
          'Windscribe' => 'VPN traffic generated by Windscribe.',
          'Speedtest' => 'Test the download and upload speed of the internet.',
          'Viber' => 'Smartphone app that allows for free phone calls and text messages.',
          'Upwork' => 'Global freelancing platform for businesses and independent professionals be connected.',
          'iPass' => 'Cloud based communication service provider.',
          'Synergy' => 'Lets users a mouse and keyboard between multiple computers.',
          'CloudApp' => 'Data synch and collaboration app.',
          'Basecamp' => 'Web based project management tool.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name = "content_group_process_client",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

gProcessClientList = {
    {0, "hidrive", 90},
    --ADrive
    {17, "adrive", 90},
    --Apple Update
    {32, "softwareupdatenotificationmanage", 90},
    --BitDefender
    {59, "bitdefender", 90},
    --BITS
    {60, "bits", 90},
    --BitTorrent
    {61, "bittorrent", 90},
    --Blackjack
    {63, "blackjack", 90},
    --DLS
    {121, "dls", 90},
    --Dropbox
    {125, "dropbox", 90},
    --Flickr
    {159, "flickr", 90},
    {159, "flickrdesktop", 90},
    --Google Drive
    {180, "googledrivefs", 90},
    {180, "google drive", 90},
    --Google
    {184, "google", 90},
    --GoToMeeting
    {187, "go to meeting", 90},
    --Kaspersky
    {248, "avp", 90},
    --Kugou
    {256, "kugou", 90},
    --LogMeIn
    {270, "logmein", 90},
    --MagicJack
    {274, "magicjack", 90},
    --McAfee
    {280, "mcafee", 90},
    --Panda
    {359, "panda", 90},
    --QQ
    {386, "qq", 90},
    --rlogin
    {398, "rlogin", 90},
    --Sharepoint
    {423, "microsoft.sharepoint", 90},
    --TOR
    {473, "tor", 90},
    --World of Warcraft
    {507, "world of warcraft", 90},
    --Zoho
    {528, "cliq", 90},
    --Zoho Chat
    {529, "zohopingagent", 90},
    --Zoho Mail
    {530, "zoho mail - desktop", 90},
    --Adobe Software
    {541, "acrobat_dc_set-up(1)", 90},
    {541, "readerdc64_en_ka_cra_install", 90},
    {541, "readerdc64_en_ka_goca_install", 90},
    {541, "readerdc64_en_xa_crd_install", 90},
    {541, "readerdc64_uk_ka_install", 90},
    {541, "readerdc64_uk_xa_cra_install", 90},
    {541, "readerdc64_uk_xa_crd_install", 90},
    --Atom
    {555, "atom", 90},
    --Basecamp
    {563, "basecamp", 90},
    --Battle.net
    {564, "battle.net", 90},
    --Chrome
    {589, "chrome", 90},
    {589, "chromium", 90},
    --cURL
    {596, "curl", 90},
    --Evolution
    {626, "evolution", 90},
    --Facebook
    {629, "facebook", 90},
    --Firefox
    {638, "firefox", 70},
    --Flash Video
    {639, "flashplayerfeedbackservice", 90},
    --Google Analytics
    {660, "ga_service", 90},
    --Google Desktop
    {662, "googledesktop", 90},
    --Google Earth
    {672, "googleearth", 90},
    {672, "google earth", 90},
    --Internet Explorer
    {686, "explorer", 90},
    --iTunes
    {689, "icloud/itunes tools", 90},
    --Jira
    {695, "jira", 90},
    --KMail
    {700, "kmail", 90},
    --Mobile Safari
    {736, "mobilesafari", 90},
    --Nessus
    {752, "nessus", 90},
    --Pandora
    {779, "pandora", 90},
    --Quake
    {795, "quake", 90},
    --RDP
    {803, "microsoft remote desktop", 90},
    {803, "microsoft remote desktop beta", 90},
    --Skype
    {832, "skype", 90},
    {832, "skypebrowserhost", 90},
    --Squid
    {844, "squid", 90},
    --SSH
    {846, "ssh", 90},
    --Target
    {858, "target", 90},
    --Thunderbird
    {866, "thunderbird", 90},
    --Twitter
    {882, "twitter", 90},
    --WebEx
    {905, "cisco webex", 90},
    {905, "webex extension", 90},
    {905, "webexhelper", 90},
    --Wget
    {909, "wget", 90},
    --Windows Media Player
    {912, "wmplayer", 90},
    --YouTube
    {929, "youtube", 90},
    --Cisco Secure Endpoint
    {934, "cisco amp for endpoints", 90},
    --TeamViewer
    {958, "team viewer", 90},
    --Deezer
    {965, "deezer", 90},
    --iHeartRadio
    {984, "iheartradio", 90},
    --RuneScape
    {1003, "runescape", 90},
    --Webshots
    {1021, "webshots", 90},
    --TwitchTV
    {1051, "twitch", 90},
    --CloudMe
    {1055, "cloudme", 90},
    --MyHeritage
    {1072, "myheritage", 90},
    --Steam
    {1086, "steam", 90},
    --Winamp
    {1092, "winamp", 90},
    --IMO
    {1108, "imo", 90},
    --Adobe Connect
    {1124, "connect", 90},
    --Hotspot Shield
    {1140, "hotspot shield", 90},
    --WhatsApp
    {1143, "whatsapp", 90},
    --Spotify
    {1158, "com.barraider.spotify", 90},
    {1158, "spotify", 90},
    --Facetime
    {1186, "facetime", 90},
    --iCloud
    {1187, "icloud", 90},
    {1187, "cloudphotosd", 90},
    --Netease
    {1222, "neteasemusic", 90},
    --Avast
    {1264, "avast", 90},
    {1264, "avgtoolssvc", 90},
    --Evernote
    {1267, "evernote", 90},
    --Box
    {1326, "box", 90},
    --Baidu
    {1345, "baidu", 90},
    --Babylon
    {1346, "babylon", 90},
    --TweetDeck
    {1360, "tweetdeck", 90},
    --Verizon Wireless
    {1388, "verizon cloud", 90},
    --Amazon Web Services
    {1392, "aws", 90},
    --KakaoTalk
    {1405, "kakaotalk", 90},
    --Apple Stocks
    {1407, "apple stocks", 90},
    --Eclipse
    {1413, "eclipse", 90},
    --WeatherBug
    {1421, "weatherbug", 90},
    --Libwww-Perl
    {1430, "perl", 90},
    --PaleMoon
    {1592, "palemoon", 90},
    --Apple Developer
    {1596, "testflightserviceextension", 90},
    --Xcode
    {1602, "xcode", 90},
    --Bria
    {1604, "bria", 90},
    --Linphone
    {1606, "linphone", 90},
    --Yandex
    {1616, "yandex", 90},
    --Snapchat
    {1653, "snapchat", 90},
    --LINE
    {1667, "line", 90},
    --GitHub
    {1670, "git", 90},
    --Trend Micro
    {1671, "trend micro antivirus", 90},
    --Apple TV
    {1683, "tv", 90},
    --Java
    {1692, "java", 90},
    --Feedly
    {1799, "feedly", 90},
    --Minecraft
    {1802, "minecraft", 90},
    {1802, "minecraft.adalserver", 90},
    {1802, "minecraft.codebuilder", 90},
    {1802, "minecraft.windows", 90},
    {1802, "minecrafteducationupdater", 90},
    {1802, "minecraftpe", 90},
    --TuneIn
    {1810, "tunein", 90},
    --SugarSync
    {1819, "sugarsync", 90},
    --Splunk
    {2037, "splunk", 90},
    --Prezi
    {2040, "prezi", 90},
    --Letterpress
    {2091, "letterpress", 90},
    --Epic
    {2096, "epic", 90},
    --Speedtest
    {2103, "speedtest", 90},
    --Asus
    {2145, "asussystemanalysis", 90},
    {2145, "asusupdate", 90},
    {2145, "asuswspanel", 90},
    {2145, "asuswsservice", 90},
    --Gateway
    {2147, "gateway", 90},
    --TextNow
    {2176, "textnow", 90},
    --Yammer
    {2198, "yammer", 90},
    --Google Update
    {2203, "googleupdate", 90},
    --OCSPD
    {2217, "ocspd", 90},
    --PHP
    {2230, "php", 90},
    --PDF Expert
    {2307, "pdf expert", 90},
    --NetNewsWire
    {2324, "netnewswire", 90},
    --Viber
    {2367, "viber", 90},
    --Apple Maps
    {2381, "maps", 90},
    --Pocket
    {2431, "pocket", 90},
    --Instapaper
    {2434, "instapaper", 90},
    --Aliwangwang
    {2617, "aliwangwang", 90},
    --WeChat
    {2618, "wechat", 90},
    --Ultrasurf
    {2634, "ultrasurf", 90},
    --VyprVPN Login
    {2644, "vypr vpn", 90},
    --Hide My Ass!
    {2648, "hide my ass vpn", 90},
    --Resilio Sync
    {2667, "resilio sync", 90},
    --Printer Pro Desktop
    {2668, "printer pro desktop", 90},
    --Python urllib
    {2685, "python", 90},
    --Mathworks
    {2687, "mathworksproductinstaller", 90},
    --GoodSync
    {2688, "goodsync server", 90},
    --New Relic
    {2690, "newrelic-infra", 90},
    --OpenDNS
    {2704, "cisco umbrella", 90},
    --iBooks
    {2724, "books", 90},
    --Kodi
    {2758, "kodi", 90},
    --Amazon Cloud Player
    {2781, "amazon music", 90},
    --DuckDuckGo
    {2805, "duckduckgo", 90},
    --Office 365
    {2812, "microsoft office", 90},
    --Glide
    {2827, "glide", 90},
    --SVN
    {2887, "svn", 90},
    --AnyConnect
    {2921, "cisco anyconnect", 90},
    --Synergy
    {3063, "synergy", 90},
    {3063, "synergy-service", 90},
    --DDM
    {3109, "ddm", 90},
    --Groove
    {3139, "groove", 90},
    --Meter
    {3214, "meter", 90},
    --Monitor
    {3228, "monitor", 90},
    --Nmap
    {3248, "nmap", 90},
    --PTP
    {3623, "ptp", 90},
    --CyberGhost VPN
    {3653, "cyberghost vpn", 90},
    --Flock
    {3765, "flock", 90},
    --Clip2Net
    {3782, "clip2net", 90},
    --Prime Video
    {3793, "prime video", 90},
    {3793, "primevideo", 90},
    --Code42
    {3877, "code42 crashplan", 90},
    --Adobe Creative Cloud
    {3887, "creativecloudset-up", 90},
    {3887, "creative_cloud_set-up", 90},
    {3887, "creative_cloud_set-up (4)", 90},
    {3887, "creative_cloud_set-up(1)", 90},
    --Autodesk
    {3888, "autodesk fusion", 90},
    --Wow
    {3910, "wow", 90},
    --QuickBooks
    {3936, "quickbooks", 90},
    --Quicken
    {3937, "quicken", 90},
    --TurboTax
    {3938, "turbotax", 90},
    --Asana
    {3950, "asana", 90},
    --Draw.io
    {3956, "draw.io", 90},
    --TripIt
    {3965, "tripit", 90},
    --Microsoft Visual Studio
    {3979, "vsixautoupdate", 90},
    {3979, "vsixconfigurationupdater", 90},
    {3979, "vsixinstaller", 90},
    {3979, "vsls-agent", 90},
    {3979, "microsoft visual studio", 90},
    {3979, "vs_setup_bootstrapper", 90},
    {3979, "install_visual_studio", 90},
    {3979, "visualstudio", 90},
    --JetBrains
    {3981, "jetbrains", 90},
    --WPS Office
    {4010, "wpsoffice", 90},
    --CloudApp
    {4021, "cloudapp", 90},
    --Syncplicity
    {4027, "syncplicity", 90},
    --Ninite
    {4035, "ninite", 90},
    --Wondershare
    {4038, "wondershare", 90},
    --Hola
    {4041, "hola_updater", 90},
    --Slack
    {4045, "slack", 90},
    --Yandex Disk
    {4049, "yandex disk", 90},
    --Edge
    {4057, "edge", 90},
    --Messenger
    {4073, "facebook messenger", 90},
    --Psiphon
    {4075, "psiphon", 90},
    --Tanium
    {4076, "tanium", 90},
    --Webex Teams
    {4080, "teamctl", 90},
    --DotVPN
    {4082, "dot vpn", 90},
    --Betternet
    {4092, "betternet", 90},
    --Anghami
    {4103, "anghami", 90},
    --Telegram
    {4116, "telegram", 90},
    --Ngrok
    {4134, "ngrok", 90},
    {4134, "ngrok-mac", 90},
    --Shazam
    {4138, "shazam", 90},
    --CactusVPN
    {4139, "cactus vpn", 90},
    --TurboVPN
    {4140, "turbo vpn", 90},
    --RealVNC
    {4142, "vncviewer", 90},
    --AnyDesk
    {4145, "anydesk", 90},
    --BlueJeans
    {4151, "bluejeans", 90},
    --LastPass
    {4155, "lastpass", 90},
    --Roblox
    {4193, "roblox", 90},
    --Canva
    {4250, "canva", 90},
    --Coc Coc
    {4311, "coccocupdate", 90},
    --Upwork
    {4358, "upwork", 90},
    --YouTubeMp3
    {4384, "youtubetomp3", 90},
    --Zoom
    {4513, "zoom", 90},
    --ExpressVPN
    {4519, "expressvpn", 90},
    --Power BI
    {4520, "power bi", 90},
    --Hide.me VPN
    {4530, "hide.me", 90},
    --Windscribe
    {4541, "windscribe", 90},
    --SurfEasy VPN
    {4545, "surfeasyvpn", 90},
    --Zoho Connect
    {4548, "zoho meeting", 90},
    --Zoho Docs
    {4549, "zoho workdrive", 90},
    {4549, "notebook", 90},
    --Zoho Assist
    {4550, "zoho assist", 90},
    --PureVPN
    {4551, "purevpn", 90},
    --Kaspersky Network Agent
    {4558, "ksde", 90},
    --Drift
    {4589, "drift", 90},
    --Grammarly
    {4598, "grammarly", 90},
    --Honey
    {4599, "honey coupons", 90},
    --Walkme
    {4600, "walkme platform", 90},
    --Microsoft Teams
    {4616, "msteams", 90},
    {4616, "msteamsupdate", 90},
    {4616, "teamsupdaterdaemon", 90},
    --Disney Plus
    {4617, "disneyplus", 90},
    --Monster VPN
    {4618, "monster vpn", 90},
    --Apple News
    {4623, "apple news", 90},
    --RingCentral
    {4635, "ringcentral", 90},
    --Tableau
    {4636, "tableau", 90},
    --Signal
    {4643, "signal", 90},
    {4643, "signal-desktop", 90},
    --MongoDB
    {4644, "mongod", 90},
    {4644, "mongodb", 90},
    --Duo Security
    {4648, "duo", 90},
    --Discord
    {4654, "discord", 90},
    --WinSCP
    {4658, "winscp", 90},
    --Zalo
    {4662, "zalo", 90},
    --Wireguard
    {4663, "wireguard", 90},
    --Thousand Eyes
    {4670, "te-diagnostics", 90},
    {4670, "thousand eyes agent", 90},
    {4670, "thousandeyes recorder ide", 90},
    --Logitech
    {4671, "logiluupdater", 90},
    {4671, "logimgrdaemon", 90},
    {4671, "logioptionsmgr", 90},
    {4671, "logitune", 90},
    --Lenovo
    {4672, "lenovo telemetry", 90},
    {4672, "lenovodrvsrv", 90},
    {4672, "lenovovantage-(genericmessaginga", 90},
    --iPass
    {4673, "ipass", 90},
}

function DetectorInit(detectorInstance)
    gDetector = detectorInstance;
    if gDetector.addProcessToClientMapping then
        for i,v in ipairs(gProcessClientList) do
            gDetector:addProcessToClientMapping(v[1], v[2], v[3]);
        end
    end
    return gDetector;
end

function DetectorClean()
end
