--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: Payload Group "coldplay"
version: 15
description: Group of payload detectors.
bundle_description: $VAR1 = {
          'GoToTraining' => 'Citrix GoToMeeting service focused on online training.',
          'Wondershare' => 'Offers Video Software, PDF Tools, PC Utilities for Mac and Win users.',
          'Funshion' => 'Chinese site for online games, videos, and shopping.',
          'YiXin' => 'Instant messaging for chat, file transfer service.',
          'Yahoo! Messenger SMS' => 'SMS via Yahoo! Messenger.',
          'Net2Phone' => 'A VoIP service.',
          'Tmall' => 'Chinese web portal and online retailer.',
          'Plista' => 'Marketing analytics site.',
          'Demandbase' => 'Advertising and marketing site.',
          'wetpaint entertainment' => 'Television related news and media.',
          'Conviva' => 'Ad site.',
          'Hola' => 'An open source VPN.',
          'Siteimprove' => 'Ad site.',
          'NFL.com' => 'American football news.',
          'WeChat' => 'Mobile text and voice messaging application.',
          'F-Prot' => 'F-Prot Antivirus/Security software download and updates.',
          'GOMTV Remote Control' => 'Mobile app that allows for remote control of GOM streaming to a television set or media player.',
          'Autodesk' => 'A CAD and 3D printing software company.',
          'BaiduHi' => 'Baidu instant messaging.',
          'USAIP' => 'VPN software.',
          'Blizzard' => 'The website for Blizzard Software, a popular PC and console game company.',
          '050plus' => 'VoIP smartphone app.',
          'Battle.net site' => 'Website for Battle.net.',
          'Munin' => 'Munin networked resource monitoring tool.',
          'WD softwares Download/Update' => 'Update/Download software provided by western digital.',
          'Western Digital' => 'Data storage company and hard disk drive manufacturers.',
          'CCP Games' => 'Video game developer and publisher.',
          'Aliwangwang' => 'Instant messaging.',
          'SCCM' => 'System Center Configuration Manager. Microsoft software for controlling and managing large groups of Windows computers.',
          'Playstation Games' => 'Playstation game traffic.',
          'BBC iPlayer' => 'Web and mobile app to watch BBC TV live.',
          'Sharepoint Online' => 'Traffic generated by web access for sharepoint Online.',
          'Intralinks' => 'A secure collaboration site.',
          'Citrix Online' => 'Citrix Online services, including GoToMyPC, GoToMeeting, GoToWebinar, and GoToTraining.',
          'Blizzard Downloader' => 'A tool used to download clients and other software for Blizzard games.',
          'Marketo' => 'Ad site.',
          'GG' => 'Gadu Gadu, a polish instant messaging app.'
        };

--]]

require "DetectorCommon"



local DC = DetectorCommon

DetectorPackageInfo = {
    name =  "payload_group_backstreetboys",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

--serviceId, clientId, ClientType, PayloadId, PayloadType, hostPattern, pathPattern, schemePattern, queryPattern
gUrlPatternList = {
    --Tmall
    { 0, 0, 0, 1783, 22, "tmall.com","/", "http:", "", 2387},
    --Autodesk
    { 0, 0, 0, 1793, 22, "autodesk.com", "/", "http:", "", 3888},
    --Sharepoint Online
    { 0, 0, 0, 1795, 8, "sharepoint.microsoftonline.com", "/", "http:", "", 2813},
    { 0, 0, 0, 1795, 8, "sharepoint.com", "/", "http:", "", 2813},
    { 0, 0, 0, 1795, 8, "sharepoint.microsoft.com", "/", "http:", "", 2813},
    { 0, 0, 0, 1795, 8, "sharepointmktgv6.microsoft.com", "/", "http:", "", 2813},
    { 0, 0, 0, 1795, 8, "sharepointonline.com", "/", "http:", "", 2813},
    { 0, 0, 0, 1795, 8, "cdn.sharepointonline.com", "/", "http:", "", 2813},
    { 0, 0, 0, 1795, 8, "static.sharepointonline.com", "/", "http:", "", 2813},
    { 0, 0, 0, 1795, 8, "ajax.aspnetcdn.com", "/", "http:", "", 2813},
    { 0, 0, 0, 1795, 8, "spoprod-a.akamaihd.net", "/", "http:", "", 2813},
    { 0, 0, 0, 1795, 8, "onenote.com", "/", "http:", "", 2813},
    { 0, 0, 0, 1795, 8, "cdn.onenote.net", "/", "http:", "", 2813},
    --USAIP
    { 0, 0, 0, 1796, 46, "usaip.eu", "/", "http:", "", 3755},
    --Net2Phone
    { 0, 0, 0, 1797, 5, "net2phone.com", "/", "http:", "", 3806},
    --Playstation Games
    { 0, 0, 0, 1798, 20, "playstation.net", "/", "http:", "", 3795},
    --SCCM
    { 0, 0, 0, 1799, 3, "sccmsrv-s01.vt.local", "/", "http:", "", 1150},
    --Aliwangwang
    { 0, 0, 0, 1802, 5, "wangxin.taobao.com", "/", "http:", "", 2617},
    { 0, 0, 0, 1802, 5, "wangwang.taobao.com", "/", "http:", "", 2617},
    { 0, 0, 0, 1802, 5, "taobao.com", "/wangwang", "http:", "", 2617},
    --050plus
    { 0, 0, 0, 1804, 5, "050plus.com", "/", "http:", "", 2325},
    --GOMTV Remote Control
    { 0, 0, 0, 1805, 8, "remoteapi.gomlab.com", "/", "http:", "", 2638},
    --GG
    { 0, 0, 0, 1807, 5, "gadu-gadu.pl", "/", "http:", "", 3706},
    { 0, 0, 0, 1807, 5, "gg.pl", "/", "http:", "", 3706},
    --YiXin
    { 0, 0, 0, 1808, 5, "yixin.im", "/", "http:", "", 2914},
    { 0, 0, 0, 1808, 5, "netease.com", "/yixinpublic", "http", "", 2914},
    --wetpaint entertainment
    { 0, 0, 0, 1809, 22, "wetpaint.com", "/", "http:", "", 2378},
    { 0, 0, 0, 1809, 22, "wetpaint.me", "/", "http:", "", 2378},
    --Funshion
    { 0, 0, 0, 1810, 22, "funshion.com", "/", "http:", "", 2391},
    { 0, 0, 0, 1810, 22, "fun.tv", "/", "http:", "", 2391},
    --NFL.com
    { 0, 0, 0, 1811, 22, "nfl.com", "/", "http:", "", 2376},
    { 0, 0, 0, 1811, 22, "nflcdn.com", "/", "http:", "", 2376},
    --F-Prot
    { 0, 0, 0, 1812, 13, "f-prot.com", "/", "http:", "", 162},
    { 0, 0, 0, 1812, 13, "f-prot.net", "/", "http:", "", 162},
    --Demandbase
    { 0, 0, 0, 1814, 22, "demandbase.com", "/", "http:", "", 3890},
    --Intralinks
    { 0, 0, 0, 1815, 22, "intralinks.com", "/", "http:", "", 3891},
    --Marketo
    { 0, 0, 0, 1816, 22, "marketo.com", "/", "http:", "", 3940},
    { 0, 0, 0, 1816, 22, "marketo.net", "/", "http:", "", 3940},
    --Conviva
    { 0, 0, 0, 1817, 22, "conviva.com", "/", "http:", "", 3931},
    --Siteimprove
    { 0, 0, 0, 1818, 22, "siteimprove.com", "/", "http:", "", 3943},
    --Plista
    { 0, 0, 0, 1819, 22, "plista.com", "/", "http:", "", 3897},
    --Battle.net site
    { 0, 0, 0, 1820, 22, "battle.net", "/", "http:", "", 3749},
    --GoToTraining
    { 0, 0, 0, 1821, 8, "gototraining.com", "/", "http:", "", 2642},
    { 0, 0, 0, 1821, 8, "jointraining.com", "/", "http:", "", 2642},
    --Citrix Online
    { 0, 0, 0, 1822, 8, "citrix.com", "/", "http:", "", 87},
    { 0, 0, 0, 1822, 8, "citrixonline.com", "/", "http:", "", 87},
    { 0, 0, 0, 1822, 8, "citrixonlinecdn.com", "/", "http:", "", 87},
    --WeChat
    { 0, 0, 0, 1823, 5, "wechat.com", "/", "http:", "", 2618},
    { 0, 0, 0, 1823, 5, "weixin.qq.com", "/", "http:", "", 2618},
    { 0, 0, 0, 1823, 5, "qbwup.imtt.qq.com", "/", "http:", "", 2618},
    --BaiduHi
    { 0, 0, 0, 1824, 5, "im.baidu.com", "/", "http:", "", 3838},
    --Livemeeting
  --  { 0, 0, 0, 1825, 22, "livemeeting.com", "/", "http:", "", 265},
    --CCP Games
    { 0, 0, 0, 1826, 22, "ccpgames.com", "/", "http:", "", 4005},
    --Yahoo! Messenger SMS
    { 0, 0, 0, 1827, 5, "msg.yahoo.com", "/v1/message/sms", "http:", "", 2478},
    --Blizzard Downloader
    { 0, 0, 0, 1828, 20, "dist.blizzard.com.edgesuite.com", "/", "http:", "", 3744},
    { 0, 0, 0, 1828, 20, "dist.blizzard.com.edgesuite.net", "/", "http:", "", 3744},
    { 0, 0, 0, 1828, 20, "dist.blizzard.com", "/downloads", "http:", "", 3744},
    --BBC iPlayer
    { 0, 0, 0, 1829, 22, "bbc.co.uk", "/iplayer", "http:", "", 2857},
    --Munin
    { 0, 504, 5, 1830, 22, "munin-monitoring.org", "/", "http:", "", 1144},
    --DeNA Comm
    --{ 0, 0, 0, 1831, 22, "ssl.co-mm.com", "/", "http:", "", 2945},
    --Blizzard
    { 0, 0, 0, 1832, 22, "blizzard.com", "/", "http:", "", 3745},
    { 0, 0, 0, 1832, 22, "blzstatic.cn", "/", "http:", "", 3745},
    { 0, 0, 0, 1832, 22, "blznews.akamaized.net", "/", "http:", "", 3745},
    { 0, 0, 0, 1832, 22, "blzmedia-a.akamaihd.net", "/", "http:", "", 3745},
    { 0, 0, 0, 1832, 22, "blzprofile.akamaized.net", "/", "http:", "", 3745},
    --Wondershare
    { 0, 0, 0, 1833, 22, "wondershare.com", "/", "http:", "", 4038},
    { 0, 0, 0, 1833, 22, "wondershare.net", "/", "http:", "", 4038},
    --Western Digital
    { 0, 0, 0, 1834, 22, "wdc.com", "/", "http:", "", 4039},
    --WD softwares Download/Update
    { 0, 0, 0, 1835, 6, "download.wdc.com", "/", "http:", "", 4040},
    --Hola
    { 0, 0, 0, 1836, 46, "hola.org", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "h-cdn.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "h-infra.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "h-local.org", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "h-vpn.org", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "hola-vpn.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "holacdn.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "holaspark.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "holavpn.net", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "hypernet.net", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "l-cdn.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "lum-api.io", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "lum-bext.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "lum-cn.co", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "lum-cn.io", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "lum-ext.io", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "lum-infra.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "lum-int.io", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "lum-lpm.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "lum-sdk.io", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "lum-superproxy.io", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "luminati-china-mail.co", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "luminati-china.biz", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "luminati-china.co", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "luminati-china.io", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "luminati-cn.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "luminati-gsuit.org", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "luminati-io-china.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "luminati-io-cn.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "luminatinet.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "lumtest.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "scd-cdn.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "smv-cdn.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "sparkweb.co", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "sparkweb.org", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "svd-cdn.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "testmyproxy.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "thecodeil.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "topvpn.io", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "whatismyippro.com", "/", "http:", "", 4041},
    { 0, 0, 0, 1836, 46, "zon-networks.com", "/", "http:", "", 4041},
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    --GG
    gDetector:addHttpPattern(2, 5, 0, 501, 16, 0, 0, 'GG-Android', 3706, 1);
    gDetector:addHttpPattern(2, 5, 0, 501, 16, 0, 0, 'GG-iOS', 3706, 1);
    --YiXin
    gDetector:addHttpPattern(2, 5, 0, 502, 16, 0, 0, 'NETEASE-YIXIN', 2914, 1);
    gDetector:addHttpPattern(2, 5, 0, 502, 16, 0, 0, 'yixin_android', 2914, 1);
    gDetector:addHttpPattern(2, 5, 0, 502, 16, 0, 0, 'yixin_httputils', 2914, 1);
    gDetector:addHttpPattern(2, 5, 0, 502, 16, 0, 0, 'MWYKGVPTJP.com.yixin.yixin', 2914, 1);
    --BaiduHi
    gDetector:addHttpPattern(2, 5, 0, 503, 16, 0, 0, 'baiduHi', 3838, 1);
    --Aliwangwang
    gDetector:addHttpPattern(2, 5, 0, 504, 16, 0, 0, 'ANDROID_WW', 2617, 1);

   if gDetector.addAppUrl then
        for i,v in ipairs(gUrlPatternList) do
            gDetector:addAppUrl(v[1],v[2],v[3],v[4],v[5],v[6],v[7],v[8],v[9],v[10]);
        end
    end
    return gDetector;
end

function DetectorClean()

end
