--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group "1ders"
version: 48
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'ImageShack' => 'Image hosting website.',
          'Nielsen' => 'Global information and measurement company.',
          'Silverpop' => 'Email marketing service.',
          'Polldaddy' => 'Advertisement site.',
          'SpotXchange' => 'Advertisement site.',
          'Scorecard Research' => 'Online marketing research community.',
          'Engage BDR' => 'Advertisement site.',
          'Skimlinks' => 'Advertisement site.',
          'Reddit' => 'Social news link site.',
          'Kooora.com' => 'Webportal for Sports related news.',
          'TowerData' => 'Formerly RapLeaf, an advertisement site.',
          'Improve Digital' => 'European sell side online ad service.',
          'IBM' => 'Website for IBM.',
          'Picasa' => 'Google picasa is an image organizer and image viewer for organizing and editing digital photos, plus an integrated photo-sharing website.',
          'Alipay' => 'Online payment service.',
          'TechCrunch' => 'IT related news and research site.',
          'SoundCloud' => 'Music platform for artists to upload and promote their music.',
          'EQ Ads' => 'Advertisement site.',
          'iPerceptions' => 'Online marketing analysis provider.',
          'LinkedIn' => 'Career oriented social networking.',
          'Google Hangouts' => 'Google cross-platform messenger application.',
          'Adenin' => 'A web portal.',
          'TechInline' => 'Website that offers remote desktop control.',
          'Monetate' => 'Advertisement site.',
          'Ado Tube' => 'Video advertising solution.',
          'Marca' => 'Primarily Spanish video streaming site.',
          'contnet' => 'Advertisement site.',
          'Sears' => 'Department store retailer.',
          'Online File Folder' => 'Cloud-based file storage.',
          'Narratiive' => 'Advertisement site.',
          'LA Times' => 'News site for the west coast newspaper.',
          'eBay' => 'An online auction and shopping website.',
          'Infonline' => 'Malware-generated online advertisements.',
          'SiteScout' => 'Company targetting powerful and easy-to-use tech for real-time ads.',
          'Mixpanel' => 'Advertisement site.',
          'Telly' => 'Video sharing and streaming site.',
          'Lokalisten' => 'German social network site focused on local events.',
          'Apple Store' => 'Official online retailer of Apple products.',
          'Line2' => 'Mobile VoIP application with support for text messaging.',
          'Drawbridge' => 'Advertisement site.',
          'HubPages' => 'Social blogging site.',
          'Newegg' => 'Computer hardware and software retailer.',
          'Samsung' => 'Electronics retail site.',
          'Motley Fool' => 'Financial and Investment community.',
          'RichRelevance' => 'Targeted advertising platform.',
          'Mozilla' => 'Website for many open source software projects, including the Firefox browser.',
          'NBA' => 'Official website for the National Basketball League, an American sports organization.',
          'DomainTools' => 'A domain name registrar.',
          'Pinger' => 'Allows SMS text messaging via a data connection.',
          'HP Home & Home Office Store' => 'HP\'s online store for computers and related products.',
          'StatCounter' => 'Web traffic analyser.',
          'Dell' => 'Computer and related technologies retailer.',
          'ICQ' => 'Internet chat client.',
          'Leboncoin' => 'Auction and classified seller website.',
          'TeacherTube' => 'Educational video streaming.',
          'Optimizely' => 'Advertisement site.',
          'NetSeer' => 'Advertisement site.',
          'RhythmOne' => 'Advertisement site.',
          'SPC Media' => 'New media production company.',
          'Open Webmail' => 'Webmail service.',
          'Rocket Fuel' => 'Advertisement site.',
          'LeadBolt' => 'Advertisement site.',
          'MediaMath' => 'Advertising and business analytics.',
          'OpenX' => 'Closed advertising platform.',
          'Sogou' => 'Chinese web portal.',
          'Brilig' => 'Advertisement site.',
          'Netease' => 'Chinese web portal.',
          'Microsoft Ads' => 'Web advertisement services.',
          'CBS' => 'CBS news website.',
          'SVN' => 'Managing Subversion servers.',
          'SHOUTCast Radio' => 'Streaming media software.',
          'Sourceforge' => 'Site for sharing open source software projects.',
          'Jango' => 'Internet radio and social networking service.',
          'Rubicon Project' => 'Online advertising infrastructure company.',
          'comScore' => 'Digital business analytics.',
          'MediaFire' => 'File and image hosting site.',
          'Rambler' => 'Russian search engine.',
          'NovaBACKUP' => 'NovaStor develops and markets data protection and availability software. NovaBACKUP offers support for multi-OS environments and is capable of handling thousands of servers and petabytes of information.',
          'Last.fm' => 'A social networking music streaming site.',
          'Hotspot Shield' => 'Anonymizer and tunnel that encrypts communications.',
          'Metacafe' => 'Online video entertainment website.',
          'iStock' => 'Online royalty-free stock images.',
          'Target' => 'Discount retailer.',
          'SendSpace' => 'File sharing and hosting.',
          'MelOn' => 'Korean music site.',
          'IGN' => 'News/reviews website focused primarily on video games.',
          'Six Apart' => 'Advertisement site.',
          'SlideShare' => 'A web-based slide show service.',
          'Salesforce.com' => 'Enterprise cloud computing company.',
          'Neustar Information Services' => 'Advertisement site.',
          'Match.com' => 'Dating website.',
          'DepositFiles' => 'International file hosting and sharing service.',
          'Imgur' => 'Image hosting website.',
          'Luminate' => 'Advertisement site.',
          'PDBox' => 'Korean file-sharing site.',
          'MaxPoint Interactive' => 'Advertisement site.',
          'StumbleUpon' => 'A web browser plugin that allows users to discover and rate webpages, photos, videos and news articles.',
          'Quantcast' => 'Site for buying and selling target audiences.',
          'MediaV' => 'Advertisement site.',
          'Delicious' => 'Social bookmarking website for storing, sharing, and finding web bookmarks.',
          'ShowMyPC' => 'Cloud-based remote support and desktop sharing.',
          'SurveyMonkey' => 'A site for distributing surveys.',
          'Envato' => 'Combined software education and marketplace site.',
          'Mercado Livre' => 'Brazil online auction and shopping website.',
          'Meetup' => 'Social networking website.',
          'Krux' => 'Cloud-based online marketing and monetization service.',
          'SuperNews' => 'A Usenet/newsgroup service provider.',
          'Resonate Networks' => 'Advertisement site.',
          'LINE' => 'Mobile and Desktop App for Instant Messaging.',
          'Smart AdServer' => 'Advertisement site.',
          'DeNA websites' => 'Traffic generated by browsing DeNA Comm website and some other sites that belong to DeNA.',
          'Adtech' => 'Advertisement site.',
          'Mop.com' => 'Chinese webportal acting as bulletin board for pop culture, games and other entertainments.',
          'Crittercism' => 'Mobile application monitor.',
          'imo.im' => 'Instant messenger service for various instant messaging protocols.',
          'Naverisk' => 'Cloud-based remote monitoring and management software.',
          'Lotame' => 'Online advertising and marketing research platform.',
          'Quake Live' => 'Online video game by id Software.',
          'Tagged' => 'Social networking site based in California.',
          'iCloud' => 'Apple cloud storage service.',
          'Softonic' => 'Software download site.',
          'Kaixin001' => 'Chinese based social networking service.',
          'Tango' => 'Mobile social networking app that provides voice, chat, and gaming services.',
          'SLI Systems' => 'Advertisement site.',
          'SBS' => 'Korean Online TV shows and Movies.',
          'Doof' => 'Online gaming site.',
          'Hushmail' => 'Web mail service providing encrypted and virus scanned e-mail.',
          'Pandora' => 'Audio streaming.',
          'Microsoft Store' => 'Online retailer for Microsoft products.',
          'Photobucket' => 'An image hosting, video hosting, slideshow creation and photo sharing website.',
          'Motrixi' => 'Advertisement site.',
          'Hideman Login' => 'Logging into Hideman internet anonymizer.',
          'LogMeIn' => 'Remote access and PC desktop control.',
          'IKEA.com' => 'Online storefront for international furniture retailer.',
          'Limelight' => 'Content delivery network.'
        };

--]]

require "DetectorCommon"


local DC = DetectorCommon

DetectorPackageInfo = {
    name =  "ssl_host_group_1ders",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

--detectorType(0-> Web, 1->Client),  AppId, SSLPattern
gSSLHostPatternList = {

    -- Alipay
    { 0, 3655, 'alipay.com' },
    -- Crittercism
    { 0, 3656, 'crittercism.com' },
    -- MelOn
    { 0, 3659, 'melon.com' },
    -- Microsoft Store
    { 0, 3670, 'microsoftstore.com' },
    -- OpenCandy
    --{ 0, 3672, 'opencandy.com' },
    -- Last.fm
    { 0, 261, 'last.fm' },
    -- Microsoft Ads
    { 0, 1336, 'adcenter.microsoft.com' },
    { 0, 1336, 'bingads.microsoft.com' },
    -- Google Hangouts
    { 0, 2960, 'hangouts.google.com' },
    { 0, 2960, 'mtalk.google.com' },
    -- Hotspot Shield
    { 0, 1140, 'esellerate.net' },
    { 0, 1140, 'hsselite.com' },
    { 0, 1140, 'hsselite.zendesk.com' },
    { 0, 1140, 'hotspotshield.com' },
    { 0, 1140, 'anchorfree.us' },
    { 0, 1140, 'anchorfree.net' },
    { 0, 1140, 'anchorfree.com' },
    { 0, 1140, 'hotspotshield.s3.amazonaws.com' },
    { 0, 1140, 'a433.com' },
    { 0, 1140, 'event.shelljacket.us' },
    -- HP Home & Home Office Store
    { 0, 827, 'shopping.hp.com' },
    { 0, 827, 'store.hp.com' },
    -- HubPages
    { 0, 2485, 'hubpages.com' },
    -- Hushmail
    { 0, 981, 'hushmail.com' },
    -- IBM
    { 0, 1173, 'ibm.com' },
    -- iCloud
    { 0, 1187, 'icloud.com' },
    { 0, 1187, 'me.com' },
    { 0, 1187, 'icloud-content.com' },
    { 0, 1187, 'icloud.cdn-apple.com' }, 
    -- ICQ
    { 0, 679, 'icq.com' },
    -- IGN
    { 0, 680, 'ign.com' },
    -- IKEA.com
    { 0, 2349, 'ikea.com' },
    -- ImageShack
    { 0, 682, 'imageshack.com' },
    { 0, 682, 'imageshack.us' },
    -- Imgur
    { 0, 684, 'imgur.com' },
    -- imo.im
    { 0, 685, 'imo.im' },
    -- Improve Digital
    { 0, 2451, 'improvedigital.com' },
    { 0, 2451, '360yield.com' },
    -- Infonline
    { 0, 2461, 'infonline.de' },
    -- iPerceptions
    { 0, 2455, 'iperceptions.com' },
    -- iStock
    { 0, 2858, 'istockphoto.com' },
    -- Jango
    { 0, 987, 'jango.com' },
    -- Kaixin001
    { 0, 989, 'kaixin001.com' },
    -- Krux
    { 0, 2466, 'krux.com' },
    { 0, 2466, 'kruxdigital.com' },
    -- LA Times
    { 0, 2609, 'latimes.com' },
    -- LeadBolt
    { 0, 2505, 'leadbolt.com' },
    -- Leboncoin
    { 0, 1219, 'leboncoin.fr' },
    -- Limelight
    { 0, 711, 'llnw.com' },
    { 0, 711, 'kiptronic.com' },
    { 0, 711, 'limelight.com' },
    -- LINE
    { 1, 1667, 'line.me' },
    { 1, 1667, 'line-apps.com'},
    { 1, 1667, 'line-scdn.net'},
    { 1, 1667, 'line.naver.jp'},
    -- Line2
    { 0, 1149, 'line2.com' },
    -- LinkedIn
    { 0, 713, 'linkedin.com' },
    -- LiveRail
  --  { 0, 2520, 'liverail.com' },
    -- LogMeIn
    { 0, 270, 'logmein.com' },
    { 0, 270, 'logme.in' },
    -- Lokalisten
    { 0, 718, 'lokalisten.de' },
    { 0, 718, 'lokalisten.at' },
    -- Lotame
    { 0, 2465, 'lotame.com' },
    -- Luminate, Inc.
    { 0, 2521, 'luminate.com' },
    -- Mafiawars
--    { 0, 272, 'mafiawars.com' },
--    { 0, 272, 'mafiawars.zynga.com' },
--    { 0, 272, 'apps.facebook.com/inthemafia' },
    -- Marca
    { 0, 2486, 'marca.com' },
    { 0, 2486, 'marca.es' },
    -- Match.com
    { 0, 2363, 'match.com' },
    -- MaxPoint Interactive
    { 0, 2561, 'maxpoint.com' },
    { 0, 2561, 'maxpointexpress.com' },
    -- MediaFire
    { 0, 285, 'mediafire.com' },
    -- MediaMath
    { 0, 2416, 'mediamath.com' },
    -- Delicious
    { 0, 605, 'delicious.com' },
    { 0, 605, 'icio.us'},
    -- Dell
    { 0, 606, 'dell.com' },
    -- DepositFiles
    { 0, 1054, 'depositfiles.com' },
    -- Docstoc
--    { 0, 940, 'docstoc.com' },
    -- DomainTools
    { 0, 1172, 'domaintools.com' },
    -- Doof
    { 0, 2359, 'doof.com' },
    -- Drawbridge
    { 0, 2509, 'drawbrid.ge' },
    -- Adenin / Dynamic Intranet
    { 0, 2360, 'dynamicintranet.com' },
    { 0, 2360, 'adenin.com' },
    -- EQ Ads
    { 0, 2539, 'eqads.com' },
    { 0, 2539, 'eqworks.com' },
    -- Envato
    { 0, 1213, 'envato.com' },
    -- Engage BDR
    { 0, 2554, 'bnmla.com' },
    { 0, 2554, 'first-impression.com' },
    { 0, 2554, 'engagebdr.com' },
    -- Narratiive
    { 0, 2516, 'effectivemeasure.com' },
    { 0, 2516, 'narratiive.com' },
    -- eBay
    { 0, 132, 'ebay.co.uk' },
    { 0, 132, 'ebay.com' },
    { 0, 132, 'ebay.ca' },
    { 0, 132, 'ebay.com.au' },
    { 0, 132, 'ebay.ie' },
    { 0, 132, 'ebay.de' },
    { 0, 132, 'ebay.in' },
    { 0, 132, 'ebay.fr' },
    { 0, 132, 'ebay.es' },
    { 0, 132, 'ebay.it' },
    { 0, 132, 'ebay.at' },
    { 0, 132, 'ebay.be' },
    { 0, 132, 'ebay.nl' },
    { 0, 132, 'ebay.ch' },
    { 0, 132, 'ebay.pl' },
    { 0, 132, 'ebay.com.sg' },
    { 0, 132, 'ebay.com.cn' },
    { 0, 132, 'ebay.cn' },
    { 0, 132, 'ebay.com.tw' },
    { 0, 132, 'ebay.com.hk' },
    { 0, 132, 'ebay.co.jp' },
    { 0, 132, 'ebay.co.kr' },
    { 0, 132, 'ebay.ph' },
    { 0, 132, 'ebay.com.my' },
    { 0, 132, 'ebay.vn' },
    { 0, 132, 'ebay.co.th' },
    -- Neustar Information Services
    { 0, 2537, 'neustar.biz' },
    { 0, 2537, 'neustar.com' },
    { 0, 2537, 'neustarlife.com' },
    { 0, 2537, 'targusinfo.com' },
    { 0, 2537, 'neustarlocaleze.biz' },
    { 0, 2537, 'neustarlocaleze.com' },
    { 0, 2537, 'ultradns.com' },
    { 0, 2537, 'webmetrics.com' },
    { 0, 2537, 'tcpacompliance.us' },
    { 0, 2537, 'npac.com' },
    -- comScore
    { 0, 2462, 'comscore.com' },
    -- MediaV
    { 0, 2501, 'mediav.com' },
    { 0, 2501, 'mediav.cn' },
    { 0, 2501, 'fenxi.com' },
    -- Meetup
    { 0, 2364, 'meetup.com' },
    -- Mercado Livre
    { 0, 2860, 'mercadolivre.com' },
    { 0, 2860, 'mercadolibre.com' },
    { 0, 2860, 'mercadolivre.com.br' },
    { 0, 2860, 'mercadolibre.com.ar' },
    { 0, 2860, 'mercadolibre.com.co' },
    { 0, 2860, 'mercadolibre.co.cr' },
    { 0, 2860, 'mercadolibre.cl' },
    { 0, 2860, 'mercadolibre.com.do' },
    { 0, 2860, 'mercadolibre.com.ec' },
    { 0, 2860, 'mercadolibre.com.mx' },
    { 0, 2860, 'mercadolibre.com.pa' },
    { 0, 2860, 'mercadolibre.com.pe' },
    { 0, 2860, 'mercadolivre.pt' },
    { 0, 2860, 'mercadolibre.com.uy' },
    { 0, 2860, 'mercadolibre.com.ve' },
    { 0, 2860, 'mercadopago.com' },
    { 0, 2860, 'mercadopago.com.br' },
    { 0, 2860, 'mercadoshops.com.br' },
    -- Meta5
    --{ 0, 288, 'meta5.us' },
    --{ 0, 288, 'meta5.com' },
    -- Metacafe
    { 0, 728, 'metacafe.com' },
    -- Mixpanel
    { 0, 2593, 'mixpanel.com' },
    -- Monetate
    { 0, 2496, 'monetate.net' },
    -- Mop.com
    { 0, 2862, 'mop.com' },
    -- Motley Fool
    { 0, 2863, 'fool.com' },
    { 0, 2863, 'fool.ca' },
    { 0, 2863, 'fool.co.uk' },
    { 0, 2863, 'fool.com.au' },
    { 0, 2863, 'fool.sg' },
    -- Mozilla
    { 0, 1261, 'mozilla.com' },
    { 0, 1261, 'mozilla.org' },
    -- MUZU TV
    -- { 0, 2375, 'muzu.tv' },
    -- Naverisk
    { 0, 2390, 'naverisk.com' },
    { 0, 2390, 'naveriskusa.com' },
    -- NBA
    { 0, 1939, 'nba.com' },
    { 0, 1939, 'nba.co.in' },
    { 0, 1939, 'nba.ca' },
    -- Netease
    { 0, 1222, '163.com' },
    -- NetSeer
    { 0, 2551, 'netseer.com' },
    -- Newegg
    { 0, 759, 'newegg.com' },
    -- Nielsen
    { 0, 2468, 'nielsen.com' },
    -- NovaBACKUP
    { 0, 336, 'novastor.com' },
    -- Online File Folder
    { 0, 1223, 'onlinefilefolder.com' },
    { 0, 1223, 'login.secureserver.net' },
    -- Open Webmail
    { 0, 1175, 'openwebmail.org' },
    -- OpenX
    { 0, 2415, 'openx.com' },
    -- Optimizely
    { 0, 2530, 'optimizely.com' },
    -- Pandora
    { 0, 779, 'pandora.com' },
    -- PDBox
    { 0, 2471, 'pdbox.co.kr' },
    -- Kooora.com
    { 0, 2859, 'kooora.com' },
    -- Motrixi
    { 0, 2525, 'motrixi.com' },
    -- Netfolder.in
    --{ 0, 3814, 'netfolder.in' },
    -- SBS
    { 0, 3818, 'sbs.co.kr' },
    -- Photobucket
    { 0, 784, 'photobucket.com' },
    -- Picasa
    { 0, 785, 'picasa.com' },
    -- Pinger
    { 0, 1148, 'pinger.com' },
    -- Polldaddy
    { 0, 2582, 'polldaddy.com' },
    -- Quantcast
    { 0, 2405, 'quantcast.com' },
    -- RhythmOne
    { 0, 2564, 'radiumone.com' },
    { 0, 2564, 'rhythmone.com' },
    -- Rambler
    { 0, 2603, 'rambler.ru' },
    -- RapidShare
    --{ 0, 802, 'rapidshare.com' },
    -- Rapleaf
    { 0, 2540, 'rapleaf.com' },
    { 0, 2540, 'towerdata.com' },
    -- Reddit
    { 0, 804, 'reddit.com' },
    -- Resonate Networks
    { 0, 2553, 'resonateinsights.com' },
    -- RichRelevance
    { 0, 2404, 'richrelevance.com' },
    -- Rocket Fuel
    { 0, 2563, 'rocketfuel.com' },
    -- Rubicon Project
    { 0, 2417, 'rubiconproject.com' },
    -- Salesforce.com
    { 0, 950, 'salesforce.com' },
    { 0, 950, 'mybuys.com' },
    { 0, 950, 'evergage.com' },
    -- Samsung
    { 0, 1357, 'samsung.com' },
    { 0, 1357, 'samsungapps.com' },
    -- Scorecard Research
    { 0, 2408, 'scorecardresearch.com' },
    -- Sears
    { 0, 821, 'sears.com' },
    { 0, 821, 'sears.ca' },
    { 0, 821, 'searspartsdirect.com' },
    { 0, 821, 'searshomeservices.com' },
    { 0, 821, 'searsoutlet.com' },
    { 0, 821, 'searscommerceservices.com' },
    { 0, 821, 'searsflowers.com' },
    { 0, 821, 'searshomepro.com' },
    { 0, 821, 'searsoptical.com' },
    { 0, 821, 'searsdrivingschools.com' },
    { 0, 821, 'searsvacations.com' },
    { 0, 821, 'searscommercial.com' },
    -- SendSpace
    { 0, 2382, 'sendspace.com' },
    -- SHOUTCast Radio
    { 0, 829, 'shoutcast.com' },
    -- ShowMyPC
    { 0, 1630, 'showmypc.com' },
    -- Silverpop
    { 0, 2460, 'silverpop.com' },
    -- SiteScout
    { 0, 2864, 'sitescout.com' },
    -- Six Apart
    { 0, 2560, 'sixapart.com' },
    { 0, 2560, 'sixapart.jp' },
    { 0, 2560, 'movabletype.com' },
    -- Skimlinks
    { 0, 2590, 'skimlinks.com' },
    -- SLI Systems
    { 0, 2494, 'sli-systems.com' },
    -- SlideShare
    { 0, 1176, 'slideshare.com' },
    { 0, 1176, 'slideshare.net' },
    -- Smart AdServer
    { 0, 2568, 'smartadserver.com' },
    -- Softonic
    { 0, 2599, 'softonic.com' },
    -- Sogou
    { 0, 2383, 'sogou.com' },
    -- SoundCloud
    { 0, 1007, 'soundcloud.com' },
    -- Sourceforge
    { 0, 1177, 'sourceforge.net' },
    { 0, 1177, 'sf.net' },
    -- SPC Media
    { 0, 2411, 'spcmedia.co.uk' },
    -- SpotXchange
    { 0, 2548, 'spotxchange.com' },
    -- StatCounter
    { 0, 1521, 'statcounter.com' },
    -- StumbleUpon
    { 0, 852, 'stumbleupon.com' },
    -- SuperNews
    { 0, 454, 'supernews.com' },
    -- SurveyMonkey
    { 0, 1178, 'surveymonkey.com' },
    -- SVN
    { 0, 2887, 'visualsvn.com' },
    -- Tagged
    { 0, 1065, 'tagged.com' },
    -- Tango
    { 0, 2379, 'tango.me' },
    -- Target
    { 0, 858, 'target.com' },
    -- TeacherTube
    { 0, 2602, 'teachertube.com' },
    -- TechCrunch
    { 0, 2607, 'techcrunch.com' },
    -- TechInline
    { 0, 2351, 'techinline.com' },
    { 0, 2351, 'fixme.it' },
    -- Telemetry
    --{ 0, 2596, 'telemetry.com' },
    -- Telly
    { 0, 2487, 'telly.com' },
    -- Apple Store
    { 0, 551, 'store.storeimages.cdn-apple.com' },
    { 0, 551, 'store.apple.com' },
    { 0, 551, 'ppq.apple.com' },
    -- Brilig
    { 0, 2511, 'brilig.com' },
    -- contnet
    { 0, 2566, 'contnet.de' },
    { 0, 2566, 'contnet.com' },
    -- Ado Tube
    { 0, 2847, 'adotube.com' },
    -- Adtech
    { 0, 2503, 'adtechaustralia.com' },
    { 0, 2503, 'adtech-kyushu.com' },
    { 0, 2503, 'ad-techlondon.co.uk' },
    { 0, 2503, 'ad-tech.sg' },
    { 0, 2503, 'adtechasean.com' },
    { 0, 2503, 'ad-tech.com' },
    { 0, 2503, 'ad-tech.co.nz' },
    -- Quake Live
    { 0, 2888, 'quakelive.com' },
    -- DeNA websites
    { 0, 2946, 'dena.com' },
    { 0, 2946, 'mobage.cn' },
    { 0, 2946, 'mbga.jp' },
    { 0, 2946, 'daum-mobage.kr' },
    { 0, 2946, 'dena.jp' },
    { 0, 2946, 'dena-ec.com' },
    { 0, 2946, 'aumall.jp' },
    { 0, 2946, 'mbok.jp' },
    { 0, 2946, 'netsea.jp' },
    { 0, 2946, 'estar.jp' },
    { 0, 2946, 'paygent.co.jp' },
    { 0, 2946, 'mangabox.me' },
    { 0, 2946, 'showroom-live.com' },
    { 0, 2946, 'applizemi.com' },
    { 0, 2946, 'chirashiru.jp' },
    --{ 0, 2946, 'ssl.co-mm.com' },
    { 0, 2946, 'smcb.jp' },
    { 0, 2946, 'skygate.co.jp' },
    { 0, 2946, 'arukikata.com' },
    { 0, 2946, 'sougouhoken.jp' },
    { 0, 2946, 'gbooks.jp' },
    { 0, 2946, 'mycode.jp' },
    -- CBS
    { 0, 1332, 'cbslocal.com' },
    -- Hideman
    { 0, 2681, 'hideman.net' },
    { 0, 2681, 'hideman.com' },
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3]);
        end
    end

    return gDetector;
end

function DetectorClean()
end

