--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group "350"
version: 18
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'Southern Living' => 'Guide to Southern culture, recipes and travel.',
          'Roku' => 'Device that streams internet video and audio to a TV.',
          'Slickdeals' => 'An online coupons and deals website.',
          'Digg' => 'News discussion site.',
          'Advanced Hosters' => 'Content delivery network.',
          'NATO' => 'Web portal for NATO.',
          'RayFile' => 'Free file hosting site.',
          'HubSpot' => 'Developer/Marketer of software products for inbound marketing and sales.',
          'Betternet' => 'A VPN tunneling app.',
          'Viadeo' => 'Business focused social network.',
          'Gantter' => 'Online project management resource.',
          'CheapStuff' => 'Aggregates best deals.',
          'Entertainment Weekly' => 'Entertainment new and video clips.',
          'Kongregate' => 'Website for hosting and playing games.',
          'Baydin' => 'Gmail productivity app.',
          'Telenav' => 'Smartphone GPS app.',
          'WebMD' => 'Health information service.',
          'Youdao Dictionary' => 'A chinese dictionary, available online and offline.',
          'DINGIT.TV' => 'Sports highlights and online game portal.',
          'CNNIC' => 'China Internet Network Infromation Center is reponsible for handling domain name registrations.',
          'dl.free.fr' => 'French based file hosting service.',
          'GREE Games' => 'A Japanese social network and mobile gaming site.',
          'Giganews' => 'A popular Usenet/newsgroup service provider.',
          'Betclic' => 'Online gambling site.',
          'Zillow' => 'Online portal for Real Estate.',
          'OkeZone' => 'Web site delivering the latest news in Indonesia.',
          'TransferBigFiles.com' => 'File hosting and sharing service.',
          'Upornia' => 'Adult content videos.',
          'TuneIn' => 'Online Radio station.',
          'ShowDocument' => 'Web application that allows users to collaborate on and review documents in real time.',
          'Boomerang' => 'Gmail send and receive scheduling.',
          'CCTV.com' => 'China Central Television site.',
          'Olx.pl' => 'Platform to connect local people to buy, sell or exchange used goods and services through their mobile phone or on the web.',
          'InQuest Technologies' => 'Cloud based business automation service.',
          'Brothersoft' => 'Free software download site.',
          'DoubleVerify' => 'Verifies Online advertisements.',
          'Slingbox Media' => 'Streaming media via Slingbox.',
          'JetBrains' => 'A collection of IDEs for different programming languages and frameworks.',
          'Xnxx' => 'Adult Videos.',
          'Dangdang' => 'Chinese general E-commerce company.',
          'Friendster' => 'Social networking site.',
          'DocuSign' => 'Secure electronic document signing.',
          'ScienceDirect' => 'A website which provides subscription-based access to a large databas of scientific and medical research.',
          'Nokia' => 'Official site for Nokia.',
          'Caijing' => 'Chinese independant news resource.',
          'Chinauma' => 'Advertisement site.',
          'Vlingo' => 'Voice recognition and processing app for smartphones.',
          'The Xinhuanet' => 'Chinese official website for the news agency Xinhua.',
          'Yandex Email' => 'Webmail provided by Yandex.',
          'MSN' => 'Portal for news, video, and other content.',
          'PopCap Games' => 'Online games website.',
          'Apple Trailers' => 'Portal for quicktime motion picture trailers.',
          'TRUSTe' => 'Online security service.',
          'Sina' => 'A Chinese internet company that produces microblogging and social networking apps.',
          'Code42' => 'Enterprise data management and security software.',
          'xda-developers' => 'Large online community of smartphone and tablet enthusiasts and developers.',
          'FileServe' => 'File hosting and sharing service.',
          'Spinrilla' => 'Free hip hop mixed tape downloads.',
          'Yandex Market' => 'Yandex shopping.',
          'Cnblogs' => 'Chinese discussion forum for programmers.',
          'SpankBang' => 'Adult videos.',
          'BitDefender' => 'BitDefender Antivirus/Security software download and updates.',
          'Neopets' => 'Virtual pet website.',
          'BuzzHand' => 'Content creation site for articles and collaboration.',
          'Windows Live Hotmail' => 'Microsoft\'s free web-based email service.',
          'FrostWire' => 'Open source client for BitTorrent.',
          'ReImage' => 'Online computer repair.',
          'Mixi' => 'Japanese social blogging site.',
          'Addictive Mobility' => 'Mobile ad and media service.',
          'PHP' => 'Scripting language for developing server based web applications.',
          'Image Venue' => 'Free image hosting site.',
          'Slingbox' => 'Media streaming from a television to the internet.',
          'Flixster' => 'A movie-based social networking site allowing users to share ratings and recommendations. Available Facebook app.',
          'Clicksgear' => 'Suspicious Adware.',
          'Avira Download/Update' => 'Avira Antivirus/Security software download and updates.',
          'Soribada' => 'Peer-to-peer portal and MP3 shop.',
          'AVG' => 'AVG Antivirus/Security software download and updates.',
          'Drudge Report' => 'News aggregator.',
          'Blip.tv' => 'Online video streaming site for web series.',
          'Orkut' => 'Google social networking site.',
          'XING' => 'Business focused social network.',
          'Glide' => 'Cross-platform web desktop that allows for file sharing between different computers and mobile devices.',
          'Cricbuzz.com' => 'Online site to provide live Cricket updates.',
          'Voyages-sncf.com' => 'Travel agency website.',
          'David Jones' => 'High-end Australian department store.',
          'Pchome' => 'Computer and electronics retailer.',
          'MobileCore' => 'Mobile ad and media service.',
          'Ensighten' => 'Tag-based advertising platform.',
          'Amazon Ads System' => 'Amazon Ad services.',
          'Gfycat' => 'User-generated short video hosting company.',
          'Asus' => 'Manufacturer of PCs and PC components.',
          'SO.com' => 'Chinese internet search engine.',
          'Ppomppu' => 'South Korean news/blogs portal.',
          'Barneys New York' => 'Luxury retail department store.',
          'TicketsNow' => 'Website for buying and selling tickets for sports, concerts, and other events.',
          'Coc Coc' => 'Vietnamese search engine and advertising platform.',
          'GamerCom' => 'An internet forum for video games, comics, animation in taiwan.',
          'Hupu' => 'Sports news website.',
          'Blokus' => 'Online spatial strategy board game.',
          'PrivateHomeClips' => 'Adult videos.',
          'Google Analytics' => 'Google service that tracks and generates detailed web statistics.',
          'Coupa' => 'Procurement software.',
          'Tabelog' => 'Search/rank restaurants in Japan.',
          'Daum Blog' => 'Daum blogging app.',
          'Urban Outfitters' => 'Clothing and footwear retailer.',
          'Google Adsense' => 'AdSense for Google.',
          'Uploaded' => 'Cloud storage and backup.',
          'Seznam' => 'Web portal and search engine in the Czech Republic.',
          'Slashdot' => 'Technology related news sharing site.',
          'OptMD' => 'Web advertisement services.',
          'Digikala' => 'Online shopping and review forum from Iran.',
          'Sabah' => 'Turkish news website.',
          'CTV' => 'Canadian Television network.',
          'Blasting News' => 'Citizen journalism site.',
          'Diply' => 'Social news and entertainment with trending contents.',
          'OnClick' => 'Browser redirector.',
          'Cvent' => 'Event registration software.',
          'OnLive' => 'Online gaming portal.',
          'Instructure' => 'Online portal for teaching and learning.',
          'I Waste So Much Time' => 'Funny photos and videos around the world.',
          'Clash Royale' => 'A web and mobile-based game spun off from Clash of Clans.',
          'Yandex AppMetrica' => 'Yandex analytics.',
          'Freepik' => 'Search engine for free vector & graphic designs.',
          'Yahoo! Games' => 'Yahoo entertainment portal.',
          'Globo' => 'Mass media group of Latin America, founded in Rio de Janeiro.',
          'WooMe' => 'Online service in which users meet and interact through video chat.',
          'Sports Authority' => 'Sporting goods retailer.',
          'SaveFrom' => 'Software that allows you to download files and videos from almost all popular video sharing networks.',
          'AppNeta' => 'Web application performance metrics and analytics.',
          'RedTube' => 'Adult Videos.',
          'Google Play Books' => 'Google ebook reader.',
          'Theme Forest' => 'An Envato marketplace for themes and skins.',
          'Autohome.com.cn' => 'Chinese website targetted for automotive related information.',
          'AudioDocumentary.org' => 'Online archive of public-domain audio and video documentaries.',
          'adSage' => 'Advertisement site.',
          'ExoClick' => 'Barcelona based advertising company for both advertisers and publishers.',
          'RoadRunner' => 'Web Portal for entertainment and sports news update.',
          'Subscene' => 'Provides subtitles in more than 50 languages.',
          'Coral CDN' => 'Content distribution network.',
          'Hello' => 'Hello is a social networking service.',
          'CiteULike' => 'Social bookmarking-esque site for scholarly papers and references.',
          'Hightail' => 'Secure file transfer service. Formerly Yousendit.',
          'Facebook Apps' => 'Any facebook add on, generally games, puzzles, gifts, classifieds.',
          'RarBG' => 'Website provides torrent files and magnet links to facilitate peer-to-peer file sharing using the BitTorrent protocol.',
          'FlyProxy' => 'Anonymous proxy service.',
          'Quill Corporation' => 'Mail-order office supply retailer.',
          'Yandex Translate' => 'Online translation form Yandex.',
          'Google Play Music' => 'Google cloud music storage and streaming.',
          'Frozenway' => 'VPN for bypassing firewalls.',
          'Ubuntu Update Manager' => 'Update manager.',
          'KBS' => 'Korean Broadcasting Syste, radio station.',
          'Niantic Labs' => 'Makers of popular augmented reality games Pokemon Go and Ingress.',
          'Viber' => 'Smartphone app that allows for free phone calls and text messages.',
          'detikcom' => 'Indonesian online news portal.',
          'CloudApp' => 'Data synch and collaboration app.',
          'Ruten' => 'A Taiwanese online auction and shopping website.',
          'Backpage.com' => 'Free classified ads.',
          'Inspectlet' => 'Website informatics and analytics.',
          'Commission Junction' => 'Web advertisement services.',
          'folkd' => 'Social bookmarking and social news website.',
          'GO.com' => 'Web portal.',
          'Legacy.com' => 'Online Obituaries.',
          'East Money' => 'Chinese financial news portal.',
          'NeoGAF' => 'Internet forum based around video games.',
          'Getscreen.me' => 'Remote Desktop Access. Cloud-based software for administration, technical support and remote work.',
          'Quote.com' => 'Financial research and trading website.',
          'Addicting Games' => 'Website for flash games.',
          'Pogo' => 'Online games.',
          'eRecht24' => 'Russian Web portal for all legal related information.',
          'MetaCrawler' => 'Metasearch engine that combines results from various popular search engines.',
          'Woolik' => 'Analytics and search engine boosting.',
          'GameSpot' => 'Video game previews/reviews/news website.',
          'RedOrbit' => 'Provides information about Science, Space, Technology and health related news.',
          'Ad Redirector' => 'Ad service.',
          'Ci123' => 'Chinese marketing and ad service.',
          'Qatar Government' => 'Qatar Government website.',
          'Backpack' => 'Business focused information management and social networking.',
          'Dainik Bhaskar' => 'Hindi online news portal.',
          'Kugou' => 'Peer-to-peer music.',
          'IMzog' => 'Adult videos.',
          'Localytics' => 'Mobile application analytics.',
          'ABS-CBN' => 'Phillipines-based news.',
          'HDFC Bank' => 'Indian banking and financial services company.',
          'SpiderOak' => 'Cloud storage and backup.',
          'CrashPlan' => 'Cloud-based enterprise backup solution.',
          'I2P' => 'Invisible Internet Protocol, an anonymous p2p network.',
          'Conservative Tribune' => 'Online portal for political and cultural related news.',
          'Rapidgator' => 'File hosting site.',
          'Adobe Connect' => 'Online meeting and collaboration system.',
          'ImpressCoJp' => 'General impress.co.jp website traffic.',
          'Po.st' => 'Social sharing platform.',
          'DMM' => 'Japan-based e-commerce portal for purchasing goods and services like e-books, games, VOD, 3D priting.',
          'SAP HostControl' => 'SAP Host Control Agent protocol used for viewing logs and traces of a remote host.',
          'Merriam-Webster' => 'Online dictionary and thesaurus.',
          'SiteAdvisor' => 'Service that reports on the safety of web sites.',
          'BlueJeans' => 'An interoperable cloud-based video conferencing service.',
          'Tinychat' => 'Web chat service with both instant messaging and video chat.',
          'Bootstrap CDN' => 'Free and public content delivery network.',
          'OsiriX' => 'Image processing tool for DICOM images.',
          'Google Safebrowsing' => 'Website blacklisting service.',
          'Fingta' => 'Web Services, Malware and Ads.',
          'Tokbox' => 'Video and voice messaging for eBuddy using RTMP.',
          'BuzzFeed' => 'News portal.',
          'Pop Salad' => 'Social gaming based on Celebrities.',
          'Elmogaz' => 'Egyptian online news portal.',
          'ICICI Bank' => 'Indian multinational banking and financial services company.',
          'Maxymiser' => 'Advertising and marketing platform.',
          'NY Daily News' => 'News portal.',
          'Usenet' => 'A worldwide distributed Internet discussion forum.',
          'DivShare' => 'File hosting and sharing service.',
          'HandyCafe' => 'Internet Cafe Software.',
          'Trulia' => 'Online portal for Real Estate.',
          'Veoh' => 'Internet television and video sharing service.',
          'Multiupload' => 'Aggregator site for upload sites such as Megaupload, Filesonic, etc.',
          'CollegeHumor' => 'Site that presents humorous videos and media.',
          'ETtoday' => 'Chinese online news portal.',
          'FileHost.ro' => 'Romanian File sharing service.',
          'Eastday' => 'Chinese news portal.',
          'Mister Wong' => 'European social bookmarking service.',
          'FreeStreams' => 'Online Movies, Radio and Games.',
          'Yandex Money' => 'Financial and stock market news from Yandex.',
          'Gawker' => 'Online blog based around media news and gossip.',
          'Haber7' => 'Turkish news Website.',
          'TinyPic' => 'Photo and video sharing service.',
          'Huanqiu' => 'Chinese dialy newspaper.',
          'skyZIP' => 'Browser extenstion that uses various techniques to speed web browsing.',
          'Kaspersky' => 'Kaspersky Antivirus/Security software download and updates.',
          'Enet' => 'Web portal for Chinese-speaking IT workers.',
          'C-SPAN' => 'Cable-Satellite Public Affairs Network - Non-profit cable television.',
          '5by5 Radio' => 'Online live and recorded talk shows.',
          'GAMERSKY' => 'Entertainment media that focuses on stand-alone games.',
          'PartyPoker' => 'Web based poker.',
          'Slither' => 'Multiplayer browser game.',
          'Hatena Blog' => 'Internet services company in Japan.',
          'JonDo' => 'Anonymous surfing proxy and traffic generated by it.',
          'easyMule' => 'Open-Source P2P software.',
          'ITV' => 'Streaming video provider.',
          'Mediaplex' => 'Data-driven marketing analytics.',
          'Yandex Maps' => 'Online maps provided by Yandex.',
          'Nokia Store' => 'Nokia App store.',
          'DirectREV' => 'Real-time digital ad marketplace to connects publishers with agencies and ad networks.',
          'Crunchyroll' => 'Video streaming site specializing in Japanese animation.',
          'WarLight' => 'Online game like Risk.',
          'Zomato' => 'Online restaraunt database.',
          'Pathview' => 'An AppNeta performance metric tool.',
          'asos' => 'Clothing and fashion brand.',
          'Jungle Disk' => 'Cloud storage and backup.',
          'GearBest' => 'Platform for user feedbacks, suggestions, promotions and giveaways.',
          'oo.com.au' => 'Australian and New Zealand online department store.',
          'Silverlight' => 'Microsoft rich internet application framework.',
          'LiveJasmin' => 'Adult content videos.',
          'GSMArena' => 'Web site providing information about mobile phones.',
          'BillDesk' => 'Online payment consolidation site.',
          'eBay Watch' => 'Watching an item on eBay.',
          'C3 Metrics' => 'Visiting websites that use C3 Metrics to deliver advertisements.',
          'eBuddy' => 'Web chat client.',
          'HowardForums' => 'Cellular phone forums.',
          'Putlocker' => 'Online file hosting service.',
          'FFFFOUND!' => 'Site for sharing found images from around the web.',
          'Openload' => 'Movies online.',
          'SopCast' => 'P2P audio and video streaming.',
          'Snapdeal' => 'Indian e-commerce company.',
          'ekantipur' => 'Kantipur online news portal.',
          'Douyu' => 'Chinese portal for live video games.',
          'Undertone' => 'Advertisement site.',
          'Lucidchart' => 'Web analytics services.',
          'ShopStyle' => 'Fashion search engine which links to various retailers.',
          'Bitauto' => 'Marketing and advertising service for Chinese auto industry.',
          'Ninite' => 'A tool that manages installation and upgrading of apps.',
          'Ifeng.com' => 'Chinese webportal from Phoenix New media.',
          'WeatherBug' => 'Windows weather application.',
          'GISMETEO' => 'Website providing wheather forecasts for different areas in Russia.',
          'Suning' => 'Chinese retailer company.',
          'MyWay' => 'Adware and spyware, categorized as an internet browser hijacker.',
          'Me2day' => 'South Korean based social networking service.',
          'EarthCam' => 'Network of live cameras in public places around the world.',
          'Babytree' => 'Website with resources and shopping for expectant mothers.',
          'Genieo' => 'Web portal adware site.',
          'Middle East Broadcasting Center' => 'Web site of Arabic private free-to-air satellite broadcasting company.',
          'TripIt' => 'Cloud based travel planner.',
          'Collabedit' => 'Online collaborative code editor which allows multiple users to modify/view code together.',
          'AZLyrics' => 'Website for sharing and cataloging song lyric transcriptions.',
          'Auditude' => 'Video advertising application.',
          'Sahibinden' => 'An online classifieds and shopping platform.',
          'PBS' => 'Official website for Public Broadcasting Service, an American television network.',
          'Weather.com' => 'Weather Channel web portal.',
          'Milliyet' => 'Turkish daily newspaper published in Istanbul.',
          'WiZiQ' => 'Online learning tool meant to provide a virtual classroom environment.',
          'Aili' => 'Chinese web portal for news and reviews about fashion.',
          'BRSRVR' => 'A content delivery network.',
          'Destructoid' => 'An independent blog focused on video games.',
          'Turner Broadcasting System' => 'Content provider for branded television network.',
          'Mojang' => 'Video game developer and publisher.',
          'Hurriyet' => 'Turkish news Website.',
          'NOAA' => 'Ocean and Atmospheric research agency.',
          'Eksi sozluk' => 'Turkish online dictionary.',
          'MOG' => 'Paid subscription online music service with streaming capability.',
          'Scribol' => 'Online magazine covering bizarre and eclectic news on the internet.',
          'FRIV' => 'Free online gaming site.',
          'Qatar University' => 'Qatar University in Doha.',
          'ShopAtHome' => 'An online coupons and deals website.',
          'GIPHY' => 'Online database & search engine for animated GIF files.',
          'iAd' => 'Web advertisement services.',
          'Intermarkets' => 'Sales management firm for Advertising.',
          'People Of Walmart' => 'Website for Walmart customer posted photos.',
          'MSDN' => 'Microsoft Developer Network.',
          'Likes' => 'Entertainment website with dynamic content.',
          'Innovation Interactive' => 'Digital marketing services.',
          'TVonline.cc' => 'Web portal agregating most TV shows/series.',
          'Netflix stream' => 'Video streams from Netflix service.',
          'Shorte' => 'URL shortener company that pays for clicks.',
          'ExtraTorrent' => 'A BitTorrent network.',
          'iFunny' => 'Aggregator of humorous and interesting memes.',
          'Justin.tv' => 'Live streaming video platform.',
          'deviantART' => 'Online community focused around artwork.',
          'PopUrls' => 'Website that aggregates headlines from various popular social news sites and portals.',
          'ADNStream' => 'Spanish video streaming site.',
          'Cloudsponge' => 'Contact importer for various email services.',
          'HOLACOM' => 'Spanish news Website.',
          'Gulf Times' => 'Daily Newspaper published by GPPC Doha, Qatar.',
          'Vuze' => 'Java based BitTorrent client.',
          'RuTracker' => 'Russian torrent site.',
          'K9 Web Protection' => 'Security and Malware protection.',
          'Fry\'s Electronics' => 'Computer and electronics retailer.',
          'LiteCoin' => 'A cryptopgraphic currency similar to BitCoin which requires lighter-weight resources to mine.',
          'Argos' => 'British online retailer of appliances, hardware, and other goods.',
          'Shopify' => 'eCommerce Web based Platform.',
          'Ad Marvel' => 'Web advertisement services.',
          'Supercell' => 'Web-based game publisher.',
          'Greystripe' => 'Web advertisement services.',
          'AcFun' => 'Video sharing site.',
          'Infinity Blade' => 'Mobile game.',
          'AMMYY' => 'Remote access software.',
          'Caraytech' => 'Advertisement site.',
          'WeatherLink' => 'Site for networking of internet-capable weather devices.',
          'SlideRocket' => 'Cloud based presentation software.',
          'BV! Media' => 'Advertisement site.',
          'Pokemon Go' => 'A popular mobile augmented reality game.',
          'MyHeritage' => 'Family oriented social networking service.',
          'Gazprom Media' => 'Russian media group comprises television, radio, advertising, movie theaters and etc.',
          'Clip Converter' => 'Free online video converter application.',
          'Nico Nico Douga' => 'Japanese video streaming and sharing site.',
          'Core Audience' => 'Advertisement site.',
          'Fark' => 'News link sharing and discussion.',
          'Qzone' => 'Chinese social networking site.',
          'Anghami' => 'Music streaming site.',
          'TruuConfessions' => 'Online community for Confessions.',
          'Toshiba' => 'Manufacturer of computers and electronics.',
          'BRCDN' => 'A content delivery network.',
          'Syncplicity' => 'Data synch service.',
          'wer-kennt-wen' => 'German social network.',
          'Megashare' => 'File hosting and sharing service. Distinct from Megashares.',
          'UEFA' => 'European Football league.',
          'Trello' => 'Collaboration tool that organizes projects into boards.',
          'Eve Online' => 'Science fiction multi player online game.',
          'Ouoio.io' => 'URL shortening service where you can shorten you links to make money from it.',
          'H&M' => 'Website of a clothing-retail company.',
          'it168' => 'Chinese social media website.',
          'Movieclips' => 'Streaming video site for movie clips.',
          'Deals Direct' => 'Australian discount retailer.',
          'Asana' => 'Collboration service.',
          'SoundHound' => 'Music search and audio hands-free app.',
          'Proclivity' => 'Advertisement site.',
          'ABC' => 'Web Portal for television network.',
          'Edmunds.com' => 'General automotive information website.',
          'EL PAIS' => 'Spanish daily newspaper portal.',
          'Raging Bull' => 'Financial message board.',
          'Fluent' => 'Marketing and analytics.',
          'CK101' => 'Chinese Internet forum.',
          'Gothere' => 'Navigation app for finding directions and places in Singapore.',
          'Wondershare' => 'Offers Video Software, PDF Tools, PC Utilities for Mac and Win users.',
          'CPX Interactive' => 'Web advertisement services.',
          'Sberbank of Russia' => 'A state-owned Russian banking and financial services company.',
          'Bilibili' => 'Chinese site for uploading and discussing anime.',
          'eBay Search' => 'Browsing eBay listings.',
          'Qatar Living' => 'Guide about living in Qatar.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name =  "ssl_host_group_350",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

gSSLHostPatternList = {
    -- 2Leep (Deprecated)
    --{0, 1781, '2leep.com', },
    -- 5by5 Radio
    {0, 2218, '5by5.tv', },
    -- ABC
    {0, 1389, 'abcnews.go.com', },
    -- ABS-CBN
    {0, 4168, 'abs-cbn.com', },
    -- AcFun
    {0, 4169, 'acfun.cn', },
    -- Ad Marvel
    {0, 1308, 'map.admarvel.com', },
    -- Ad Redirector
    {0, 4170, 'adexchangeprediction.com', },
    -- Addicting Games
    {0, 540, 'addictinggames.com', },
    -- Addictive Mobility
    {0, 4087, 'addictivemobility.com', },
    -- ADNStream
    {0, 2370, 'adnstream.com', },
    -- Adobe Connect
    {0, 1124, 'meet.adobeconnect.com', },
    -- adSage
    {0, 2491, 'adsage.com', },
    -- Advanced Hosters
    {0, 4171, 'ahcdn.com', },
    -- Aili
    {0, 1615, 'aili.com', },
    -- Amazon Ads System
    {0, 1804, 's.amazon-adsystem.com', },
    -- AMMYY
    {0, 2894, 'ammyy.com', },
    -- Anghami
    {0, 4103, 'anghami.com', },
    -- Apple Trailers
    {0, 1194, 'trailers.apple.com', },
    -- AppNeta
    {0, 3742, 'appneta.com', },
    -- Argos
    {0, 554, 'argos.co.uk', },
    -- Asana
    {0, 3950, 'asana.com', },
    -- asos
    {0, 4174, 'asos.com', },
    -- Asus
    {0, 2145, 'asus.com', },
    -- AudioDocumentary.org
    {0, 2271, 'audiodocumentary.org', },
    -- Auditude
    {0, 2129, 'connect.auditude.com', },
    -- Autohome.com.cn
    {0, 2852, 'autohome.com.cn', },
    -- AVG
    {0, 44, 'avg.com', },
    -- Avira Download/Update
    {0, 45, 'avira.com', },
    -- AZLyrics
    {0, 4176, 'azlyrics.com', },
    -- Babytree
    {0, 4177, 'babytree.com', },
    -- Backpack
    {0, 48, 'backpackit.com', },
    -- Backpage.com
    {0, 1494, 'backpage.com', },
    -- Barneys New York
    {0, 562, 'barneys.com', },
    -- Baydin
    {0, 3951, 'baydin.com', },
    -- Betclic
    {0, 3703, 'en.betclic.com', },
    -- Betternet
    {0, 4092, 'betternet.co', },
    -- Bilibili
    {0, 4240, 'bilibili.com', },
    -- BillDesk
    {0, 4241, 'billdesk.com', },
    -- Bitauto
    {0, 4242, 'bitauto.com', },
    -- BitDefender
    {0, 59, 'bitdefender.com', },
    -- Blasting News
    {0, 4243, 'blastingnews.com', },
    -- Blip.tv
    {0, 574, 'blip.tv', },
    -- Blokus
    {0, 2482, 'blokus.com', },
    -- BlueJeans
    {0, 4151, 'bluejeans.com', },
    -- Boomerang
    {0, 3952, 'boomeranggmail.com', },
    -- Bootstrap CDN
    {0, 3822, 'bootstrapcdn.com', },
    -- BRCDN
    {0, 2459, 'p1.brcdn.com', },
    -- Brothersoft
    {0, 1210, 'brothersoft.com', },
    -- BRSRVR
    {0, 2457, 'cdn.brsrvr.com', },
    -- Burstly (Deprecated)
    --{0, 1312, 'appads.com.w3snoop.com', },
    -- BuzzFeed
    {0, 1508, 'buzzfeed.com', },
    -- BuzzHand
    {0, 4248, 'buzzhand.com', },
    -- BV! Media
    {0, 2576, 'bvmedia.ca', },
    -- C-SPAN
    {0, 2074, 'c-span.org', },
    -- C3 Metrics
    {0, 3819, 'c3metrics.com', },
    -- Caijing
    {0, 4249, 'caijing.com.cn', },
    -- CanvasRider
    --{0, 1361, 'canvasrider.com', },
    -- Caraytech
    {0, 2573, 'caraytech.com.ar', },
    -- CCTV.com
    {0, 4251, 'cctv.com', },
    -- CheapStuff
    {0, 2061, 'cheapstuff.com', },
    -- Chinauma
    {0, 2490, 'chinauma.com', },
    -- Ci123
    {0, 4254, 'ci123.com', },
    -- CiteULike
    {0, 979, 'citeulike.org', },
    -- CK101
    {0, 4305, 'ck101.com', },
    -- Clash Royale
    {0, 4098, 'clashroyale.com', },
    -- Clicksgear
    {0, 4306, 'clicksgear.com', },
    -- Clip Converter
    {0, 4307, 'clipconverter.cc', },
    -- CloudApp
    {0, 4021, 'my.cl.ly', },
    -- Cloudsponge
    {0, 3953, 'cloudsponge.com', },
    -- Cnblogs
    {0, 4308, 'cnblogs.com', },
    -- CNNIC
    {0, 4309, 'cnnic.cn', },
    -- CNNIC
    {0, 4309, 'cnnic.com.cn', },
    -- Coc Coc
    {0, 4311, 'coccoc.com', },
    -- Code42
    {0, 3877, 'code42.com', },
    -- Collabedit
    {0, 592, 'collabedit.com', },
    -- CollegeHumor
    {0, 2164, 'collegehumor.com', },
    -- Commission Junction
    {0, 1492, 'cj.com', },
    -- Conservative Tribune
    {0, 4312, 'conservativetribune.com', },
    -- Coral CDN
    {0, 2838, 'coralcdn.org', },
    -- Core Audience
    {0, 2552, 'coreaudience.com', },
    -- Coupa
    {0, 2429, 'coupa.com', },
    -- CPX Interactive
    {0, 1457, 'cpxinteractive.com', },
    -- CrashPlan
    {0, 3878, 'crashplan.com', },
    -- Cricbuzz.com
    {0, 4313, 'cricbuzz.com', },
    -- Crunchyroll
    {0, 2138, 'crunchyroll.com', },
    -- CTV
    {0, 2750, 'ctv.ca', },
    -- Cvent
    {0, 3954, 'cvent.com', },
    -- Dainik Bhaskar
    {0, 4315, 'bhaskar.com', },
    -- Dangdang
    {0, 1074, 'dangdang.com', },
    -- Daum Blog
    {0, 4052, 'blog.daum.net', },
    -- David Jones
    {0, 601, 'davidjones.com.au', },
    -- Deals Direct
    {0, 604, 'dealsdirect.com.au', },
    -- Destructoid
    {0, 607, 'destructoid.com', },
    -- detikcom
    {0, 4317, 'detik.com', },
    -- Digg
    {0, 117, 'digg.com', },
    -- Digikala
    {0, 4319, 'digikala.com', },
    -- DINGIT.TV
    {0, 4320, 'dingit.tv', },
    -- Diply
    {0, 4321, 'diply.com', },
    -- DirectREV
    {0, 4322, 'directrev.com', },
    -- DivShare
    {0, 966, 'divshare.com', },
    -- dl.free.fr
    {0, 967, 'dl.free.fr', },
    -- DMM
    {0, 4323, 'dmm.com', },
    -- DocuSign
    {0, 3955, 'docusign.com', },
    -- DoubleVerify
    {0, 1776, 'doubleverify.com', },
    -- Douyu
    {0, 4324, 'douyu.com', },
    -- Drudge Report
    {0, 1387, 'drudgereport.com', },
    -- EarthCam
    {0, 2604, 'earthcam.com', },
    -- East Money
    {0, 2481, 'eastmoney.com', },
    -- Eastday
    {0, 4325, 'eastday.com', },
    -- easyMule
    {0, 3728, 'easymule.com', },
    -- eBay Search
    {0, 134, 'shop.ebay.com', },
    -- eBay Watch
    {0, 135, 'cgi1.ebay.com', },
    -- eBuddy
    {0, 136, 'ebuddy.com', },
    -- Edmunds.com
    {0, 622, 'edmunds.com', },
    -- ekantipur
    {0, 4326, 'ekantipur.com', },
    -- Eksi sozluk
    {0, 4327, 'eksisozluk.com', },
    -- EL PAIS
    {0, 4329, 'elpais.com', },
    -- Elmogaz
    {0, 4328, 'elmogaz.com', },
    -- Enet
    {0, 1212, 'enet.com.cn', },
    -- Ensighten
    {0, 2157, 'nexus.ensighten.com', },
    -- Entertainment Weekly
    {0, 2095, 'ew.com', },
    -- ETtoday
    {0, 4330, 'ettoday.net', },
    -- Eve Online
    {0, 4004, 'eveonline.com', },
    -- Eve Online
    {0, 4004, 'secure.eveonline.com', },
    -- ExoClick
    {0, 4331, 'exoclick.com', },
    -- ExtraTorrent
    {0, 1214, 'extratorrent.com', },
    -- Facebook Apps
    {0, 149, 'apps.facebook.com', },
    -- Fark
    {0, 150, 'fark.com', },
    -- FFFFOUND!
    {0, 2255, 'ffffound.com', },
    -- FileHost.ro
    {0, 2884, 'filehost.ro', },
    -- FileServe
    {0, 973, 'fileserve.com', },
    -- Fingta
    {0, 4255, 'rudateblue2.fingta.com', },
    -- Flixster
    {0, 160, 'flixster.com', },
    -- Fluent
    {0, 3658, 'asotrack1.fluentmobile.com', },
    -- FlyProxy
    {0, 2837, 'flyproxy.com.ipaddress.com', },
    -- folkd
    {0, 975, 'folkd.com', },
    -- Freepik
    {0, 4256, 'freepik.com', },
    -- FreeStreams
    {0, 2063, 'freestreams.com', },
    -- Friendster
    {0, 642, 'friendster.com', },
    -- FRIV
    {0, 4257, 'friv.com', },
    -- FrostWire
    {0, 2214, 'frostwire.com', },
    -- Frozenway
    {0, 4096, 'frozendo.com', },
    -- Fry's Electronics
    {0, 643, 'frys.com', },
    -- GamerCom
    {0, 4258, 'gamer.com.tw', },
    -- GAMERSKY
    {0, 4259, 'gamersky.com', },
    -- GameSpot
    {0, 648, 'gamespot.com', },
    -- Gantter
    {0, 3957, 'gantter.com', },
    -- Gawker
    {0, 652, 'gawker.com', },
    -- Gazprom Media
    {0, 2760, 'gazprom-media.com', },
    -- GearBest
    {0, 4260, 'gearbest.com', },
    -- Genieo
    {0, 2686, 'genieo.com', },
    -- Gfycat
    {0, 4261, 'gfycat.com', },
    -- Giganews
    {0, 175, 'giganews.com', },
    -- GIPHY
    {0, 4262, 'giphy.com', },
    -- GISMETEO
    {0, 4263, 'gismeteo.ru', },
    -- Glide
    {0, 2827, 'glideos.com', },
    -- Globo
    {0, 4264, 'globo.com', },
    -- GO.com
    {0, 1304, 'go.com', },
    -- Google Adsense
    {0, 1424, 'googlesyndication.com', },
    -- Google Analytics
    {0, 660, 'google-analytics.com', },
    -- Google Play Books
    {0, 1230, 'books.google.com', },
    -- Google Play Music
    {0, 1231, 'music.youtube.com', },
    -- Google Safebrowsing
    {0, 665, 'safebrowsing-cache.google.com', },
    -- Gothere
    {0, 4131, 'gothere.sg', },
    -- GREE Games
    {0, 3852, 'gree.net', },
    {0, 3852, 'gree.jp', },
    -- Greystripe
    {0, 1318, 'greystripe.com', },
    -- GSMArena
    {0, 4265, 'gsmarena.com', },
    -- Gulf Times
    {0, 4266, 'gulf-times.com', },
    -- H&M
    {0, 4271, 'hm.com', },
    -- Haber7
    {0, 4267, 'haber7.com', },
    -- HandyCafe
    {0, 4268, 'handycafe.com', },
    -- Hatena Blog
    {0, 4269, 'hatenablog.com', },
    -- HDFC Bank
    {0, 4270, 'hdfcbank.com', },
    -- Hello
    {0, 4108, 'hello.com', },
    -- Hightail
    {0, 928, 'yousendit.com', },
    {0, 928, 'hightail.com', },
    -- HLN (Deprecated)
    --{0, 2254, 'hlntv.com', },
    -- HOLACOM
    {0, 4272, 'hola.com', },
    -- HowardForums
    {0, 2598, 'howardforums.com', },
    -- Huanqiu
    {0, 4273, 'huanqiu.com', },
    -- HubSpot
    {0, 4274, 'hubspot.com', },
    -- Hupu
    {0, 2356, 'hupu.com', },
    -- Hurriyet
    {0, 4275, 'hurriyet.com.tr', },
    -- I Waste So Much Time
    {0, 2001, 'iwastesomuchtime.com', },
    -- I2P
    {0, 4033, 'geti2p.net', },
    -- iAd
    {0, 1319, 'advertising.apple.com', },
    -- ICICI Bank
    {0, 4276, 'icicibank.com', },
    -- Ifeng.com
    {0, 2856, 'ifeng.com', },
    -- iFunny
    {0, 2133, 'ifunny.com', },
    -- Image Venue
    {0, 1217, 'imagevenue.com', },
    -- ImpressCoJp
    {0, 4277, 'impress.co.jp', },
    -- Infinity Blade
    {0, 2335, 'infinitybladegame.com', },
    -- Innovation Interactive
    {0, 2418, 'innovationinteractive.com', },
    -- InQuest Technologies
    {0, 3959, 'inquesttechnologies.com', },
    -- Inspectlet
    {0, 3960, 'inspectlet.com', },
    -- Instructure
    {0, 4332, 'instructure.com', },
    -- Intermarkets
    {0, 2068, 'intermarkets.net', },
    -- it168
    {0, 2373, 'it168.com', },
    -- ITV
    {0, 3859, 'tom.itv.com', },
    -- ITV
    {0, 3859, 'itv.com', },
    -- JetBrains
    {0, 3981, 'jetbrains.com', },
    -- JonDo
    {0, 2947, 'anonymous-proxy-servers.net', },
    -- Jungle Disk
    {0, 4034, 'jungledisk.com', },
    -- Justin.tv
    {0, 988, 'justin.tv', },
    -- K9 Web Protection
    {0, 2013, 'k9webprotection.com', },
    -- Kaspersky
    {0, 248, 'usa.kaspersky.com', },
    -- KBS
    {0, 2435, 'kbs.co.kr', },
    -- Kongregate
    {0, 705, 'kongregate.com', },
    -- Kugou
    {0, 256, 'static.kugou.com', },
    -- Legacy.com
    {0, 1524, 'legacy.com', },
    -- Likes
    {0, 4349, 'likes.com', },
    -- LiteCoin
    {0, 2084, 'litecoin.org', },
    -- Localytics
    {0, 1426, 'localytics.com', },
    -- Lucidchart
    {0, 3961, 'lucidchart.com', },
    -- Maxymiser
    {0, 2158, 'service.maxymiser.net', },
    -- Me2day
    {0, 992, 'me2day.net', },
    -- Media Innovation Groupa (Deprecated)
    -- {0, 2523, 'mookie1.com', },
    -- Mediaplex
    {0, 2407, 'mediaplex.com', },
    -- Megashare
    {0, 993, 'megashare.com', },
    -- Merriam-Webster
    {0, 2789, 'merriam-webster.com', },
    -- MetaCrawler
    {0, 1132, 'metacrawler.com', },
    -- Middle East Broadcasting Center
    {0, 4206, 'mbc.net', },
    -- Milliyet
    {0, 4210, 'milliyet.com.tr', },
    -- Mixi
    {0, 295, 'mixi.jp', },
    -- MobileCore
    {0, 4086, 'mobilecore.com', },
    -- MOG
    {0, 1041, 'mog.com', },
    -- Mojang
    {0, 4006, 'mojang.com', },
    -- Movieclips
    {0, 1084, 'movieclips.com', },
    -- MSDN
    {0, 304, 'msdn.microsoft.com', },
    -- MSN
    {0, 308, 'msn.co.uk', },
    {0, 308, 'msn.com', },
    -- Multiupload
    {0, 1220, 'multiupload.com', },
    -- MyHeritage
    {0, 1072, 'myheritage.com', },
    -- MyWay
    {0, 4211, 'hp.myway.com', },
    -- NATO
    {0, 1418, 'nato.int', },
    -- NeoGAF
    {0, 1080, 'neogaf.com', },
    -- Neopets
    {0, 996, 'neopets.com', },
    -- Netflix stream
    {0, 939, 'nflxvideo.net', },
    -- Niantic Labs
    {0, 4104, 'nianticlabs.com', },
    -- Nico Nico Douga
    {0, 762, 'nicovideo.jp', },
    -- Ninite
    {0, 4035, 'ninite.com', },
    -- NOAA
    {0, 1420, 'noaa.gov', },
    -- Nokia
    {0, 1769, 'nokia.com', },
    -- Nokia Store
    {0, 1771, 'static.store.ovi.com', },
    -- NY Daily News
    {0, 1517, 'nydailynews.com', },
    -- OkeZone
    {0, 4220, 'okezone.com', },
    -- Olx.pl
    {0, 4221, 'olx.pl', },
    -- OnClick
    {0, 4222, 'onclkds.com', },
    -- OnLive
    {0, 1305, 'onlive.com', },
    -- oo.com.au
    {0, 770, 'oo.com.au', },
    -- Openload
    {0, 4159, 'openload.co', },
    -- OptMD
    {0, 1372, 'optmd.com', },
    -- Orkut
    {0, 356, 'orkut.com', },
    -- Ouoio.io
    {0, 4227, 'ouo.io', },
    -- PartyPoker
    {0, 360, 'partypoker.com', },
    -- Pathview
    {0, 3752, 'pathviewcloud.com', },
    -- PBS
    {0, 1772, 'pbs.org', },
    -- Pchome
    {0, 2350, 'pchome.net', },
    -- People Of Walmart
    {0, 1783, 'peopleofwalmart.com', },
    -- PHP
    {0, 2230, 'php.net', },
    -- Po.st
    {0, 2060, 'po.st', },
    -- Pogo
    {0, 787, 'pogo.com', },
    -- Pokemon Go
    {0, 4105, 'pokemongo.com', },
    -- Pop Salad
    {0, 1787, 'popsalad.com', },
    -- PopCap Games
    {0, 789, 'popcap.com', },
    -- PopUrls
    {0, 790, 'popurls.com', },
    -- Ppomppu
    {0, 4237, 'ppomppu.co.kr', },
    -- Proclivity
    {0, 2533, 'www.proclivitysystems.com', },
    {0, 2533, 't.pswec.com', },
    -- Putlocker
    {0, 1224, 'putlocker.com', },
    {0, 1224, 'putlocker.is', },
    -- Qatar Government
    {0, 4183, 'portal.www.gov.qa', },
    -- Qatar Living
    {0, 4184, 'qatarliving.com', },
    -- Qatar University
    {0, 4185, 'qu.edu.qa', },
    -- Quill Corporation
    {0, 797, 'quill.com', },
    -- Quote.com
    {0, 2353, 'quote.com', },
    -- Qzone
    {0, 799, 'qzone.qq.com', },
    -- Raging Bull
    {0, 1225, 'ragingbull.com', },
    -- Rapidgator
    {0, 4024, 'rapidgator.net', },
    -- RarBG
    {0, 4190, 'rarbg.to', },
    -- RayFile
    {0, 2823, 'rayfile.com', },
    -- Realview TV (Deprecated)
    --{0, 2439, 'realviewtv.com', },
    -- RedOrbit
    {0, 1989, 'redorbit.com', },
    -- ReImage
    {0, 4192, 'reimageplus.com', },
    -- RoadRunner
    {0, 1386, 'rr.com', },
    -- Roku
    {0, 2034, 'roku.com', },
    -- Ruten
    {0, 4196, 'ruten.com.tw', },
    -- RuTracker
    {0, 4197, 'rutracker.org', },
    -- Sabah
    {0, 4198, 'sabah.com.tr', },
    -- Sahibinden
    {0, 4199, 'sahibinden.com', },
    -- SAP HostControl
    {0, 410, 'sap.com', },
    -- SaveFrom
    {0, 4200, 'en.savefrom.net', },
    -- Sberbank of Russia
    {0, 4201, 'sberbank.ru', },
    -- ScienceDirect
    {0, 4203, 'sciencedirect.com', },
    -- Scribol
    {0, 4279, 'scribol.com', },
    -- Search-Result.com (Deprecated)
    --{0, 1384, 'search-result.com', },
    -- Seznam
    {0, 4281, 'onas.seznam.cz', },
    -- ShopAtHome
    {0, 1487, 'shopathome.com', },
    -- Shopify
    {0, 4282, 'shopify.com', },
    -- ShopStyle
    {0, 828, 'shopstyle.com', },
    -- Shorte
    {0, 4283, 'shorte.st', },
    -- ShowDocument
    {0, 831, 'showdocument.co', },
    {0, 831, 'showdocument.net', },
    -- Silverlight
    {0, 1302, 'silverlight.net', },
    -- Sina
    {0, 3675, 'sina.com', },
    -- SiteAdvisor
    {0, 4284, 'siteadvisor.com', },
    -- skyZIP
    {0, 4047, 'skyzip.de', },
    -- Slashdot
    {0, 834, 'slashdot.com', },
    -- Slickdeals
    {0, 1504, 'slickdeals.net', },
    -- SlideRocket
    {0, 3963, 'sliderocket.com', },
    -- SlideRocket
    {0, 3963, 'clearslide.com', },
    -- Slingbox
    {0, 432, 'slingmedia.com', },
    -- Slingbox Media
    {0, 3753, 'sso.slingmedia.com', },
    -- Slither
    {0, 4285, 'slither.io', },
    -- Snapdeal
    {0, 4286, 'snapdeal.com', },
    -- SO.com
    {0, 4287, 'so.com', },
    -- SopCast
    {0, 2628, 'sopcast.com', },
    -- Soribada
    {0, 840, 'soribada.com', },
    -- SoundHound
    {0, 4102, 'soundhound.com', },
    -- Southern Living
    {0, 2427, 'southernliving.com', },
    -- SpiderOak
    {0, 4036, 'spideroak.com', },
    -- Spinrilla
    {0, 4044, 'spinrilla.com', },
    -- Sports Authority
    {0, 842, 'sportsauthority.com', },
    -- Subscene
    {0, 4290, 'subscene.com', },
    -- Suning
    {0, 4291, 'suning.com', },
    -- Supercell
    {0, 4097, 'supercell.com', },
    -- Syncplicity
    {0, 4027, 'syncplicity.com', },
    -- Tabelog
    {0, 4292, 'tabelog.com', },
    -- Telenav
    {0, 2134, 'telenav.com', },
    -- The Xinhuanet
    {0, 1628, 'xinhuanet.com', },
    -- Theme Forest
    {0, 1227, 'themeforest.net', },
    -- TicketsNow
    {0, 869, 'ticketsnow.com', },
    -- Tinychat
    {0, 1013, 'tinychat.com', },
    -- TinyPic
    {0, 873, 'tinypic.com', },
    -- Tokbox
    {0, 2400, 'tokbox.com', },
    -- Toshiba
    {0, 2148, 'toshiba.com', },
    -- TransferBigFiles.com
    {0, 1015, 'transferbigfiles.com', },
    -- Trello
    {0, 4300, 'trello.com', },
    -- TripIt
    {0, 3965, 'tripit.com', },
    -- Trulia
    {0, 1503, 'trulia.com', },
    -- TRUSTe
    {0, 1775, 'truste.com', },
    -- TruuConfessions
    {0, 1789, 'truuconfessions.com', },
    -- TuneIn
    {0, 1810, 'tunein.com', },
    -- TurboUpload (Deprecated)
    --{0, 1017, 'turboupload.com', },
    -- Turner Broadcasting System
    {0, 2057, 'turner.com', },
    -- TVonline.cc
    {0, 2735, 'tvonline.cc', },
    -- Ubuntu Update Manager
    {0, 1409, 'archive.ubuntu.com', },
    -- UEFA
    {0, 3966, 'uefa.com', },
    -- Undertone
    {0, 2583, 'undertone.com', },
    -- Uploaded
    {0, 4037, 'uploaded.net', },
    -- Urban Outfitters
    {0, 883, 'urbanoutfitters.com', },
    -- Usenet
    {0, 487, 'usenetserver.com', },
    -- Veoh
    {0, 889, 'veoh.com', },
    -- Viadeo
    {0, 891, 'viadeo.com', },
    -- Viber
    {0, 2367, 'viber.com', },
    -- Vlingo
    {0, 2135, 'vlingo.com', },
    -- Vuze
    {0, 497, 'vuze.com', },
    -- WarLight
    {0, 3967, 'warlight.net', },
    -- Weather.com
    {0, 1367, 'weather.com', },
    -- WeatherBug
    {0, 1421, 'weather.weatherbug.com', },
    -- WeatherLink
    {0, 2195, 'weatherlink.com', },
    -- WebMD
    {0, 1502, 'webmd.com', },
    -- wer-kennt-wen
    {0, 908, 'wer-kennt-wen.de', },
    -- Windows Live Hotmail
    {0, 205, 'hotmail.com', },
    -- WiZiQ
    {0, 914, 'wiziq.com', },
    -- Wondershare
    {0, 4038, 'wondershare.net', },
    -- Woolik
    {0, 3674, 'woolik.com', },
    -- WooMe
    {0, 1025, 'woome.com', },
    -- xda-developers
    {0, 1078, 'xda-developers.com', },
    -- XING
    {0, 922, 'xing.com', },
    -- Yahoo! Games
    {0, 522, 'games.yahoo.com', },
    -- Yandex AppMetrica
    {0, 4059, 'appmetrica.yandex.com', },
    -- Yandex Email
    {0, 4061, 'mail.yandex.com', },
    -- Yandex Maps
    {0, 4062, 'suggest-maps.yandex.ru', },
    -- Yandex Market
    {0, 4064, 'market.yandex.ru', },
    -- Yandex Money
    {0, 4063, 'money.yandex.com', },
    -- Yandex Translate
    {0, 4066, 'translate.yandex.com', },
    -- Youdao Dictionary
    {0, 3982, 'youdao.com', },
    -- Zillow
    {0, 1480, 'zillow.com', },
    -- Zomato
    {0, 3968, 'zomato.com', },
    -- deviantART
    {0, 608, 'deviantart.com', },
    -- IMzog
    {0, 4278, 'imzog.com', },
    -- LiveJasmin
    {0, 4351, 'livejasmin.com', },
    -- PrivateHomeClips
    {0, 4238, 'hclips.com', },
    -- RedTube
    {0, 4191, 'redtube.com', },
    -- SpankBang
    {0, 4289, 'spankbang.com', },
    -- Upornia
    {0, 4355, 'upornia.com', },
    -- Xnxx
    {0, 4378, 'xnxx.com', },
    -- Getscreen.me
    {0, 4660, 'getscreen.me', },
}

gSSLCnamePatternList = {
    -- 2Leep (Deprecated)
    --{0, 1781, '2leep.com', },
    -- 5by5 Radio
    {0, 2218, '5by5.tv', },
    -- ABC
    {0, 1389, 'abcnews.go.com', },
    -- ABS-CBN
    {0, 4168, 'abs-cbn.com', },
    -- AcFun
    {0, 4169, 'acfun.cn', },
    -- Ad Marvel
    {0, 1308, 'map.admarvel.com', },
    -- Ad Redirector
    {0, 4170, 'adexchangeprediction.com', },
    -- Addicting Games
    {0, 540, 'addictinggames.com', },
    -- Addictive Mobility
    {0, 4087, 'addictivemobility.com', },
    -- ADNStream
    {0, 2370, 'adnstream.com', },
    -- Adobe Connect
    {0, 1124, 'meet.adobeconnect.com', },
    -- adSage
    {0, 2491, 'adsage.com', },
    -- Advanced Hosters
    {0, 4171, 'ahcdn.com', },
    -- Aili
    {0, 1615, 'aili.com', },
    -- Amazon Ads System
    {0, 1804, 's.amazon-adsystem.com', },
    -- AMMYY
    {0, 2894, 'ammyy.com', },
    -- Anghami
    {0, 4103, 'anghami.com', },
    -- Apple Trailers
    {0, 1194, 'trailers.apple.com', },
    -- AppNeta
    {0, 3742, 'appneta.com', },
    -- Argos
    {0, 554, 'argos.co.uk', },
    -- Asana
    {0, 3950, 'asana.com', },
    -- asos
    {0, 4174, 'asos.com', },
    -- Asus
    {0, 2145, 'asus.com', },
    -- AudioDocumentary.org
    {0, 2271, 'audiodocumentary.org', },
    -- Auditude
    {0, 2129, 'connect.auditude.com', },
    -- Autohome.com.cn
    {0, 2852, 'autohome.com.cn', },
    -- AVG
    {0, 44, 'avg.com', },
    -- Avira Download/Update
    {0, 45, 'avira.com', },
    -- AZLyrics
    {0, 4176, 'azlyrics.com', },
    -- Babytree
    {0, 4177, 'babytree.com', },
    -- Backpack
    {0, 48, 'backpackit.com', },
    -- Backpage.com
    {0, 1494, 'backpage.com', },
    -- Barneys New York
    {0, 562, 'barneys.com', },
    -- Baydin
    {0, 3951, 'baydin.com', },
    -- Betclic
    {0, 3703, 'en.betclic.com', },
    -- Betternet
    {0, 4092, 'betternet.co', },
    -- Bilibili
    {0, 4240, 'bilibili.com', },
    -- BillDesk
    {0, 4241, 'billdesk.com', },
    -- Bitauto
    {0, 4242, 'bitauto.com', },
    -- BitDefender
    {0, 59, 'bitdefender.com', },
    -- Blasting News
    {0, 4243, 'blastingnews.com', },
    -- Blip.tv
    {0, 574, 'blip.tv', },
    -- Blokus
    {0, 2482, 'blokus.com', },
    -- BlueJeans
    {0, 4151, 'bluejeans.com', },
    -- Boomerang
    {0, 3952, 'boomeranggmail.com', },
    -- Bootstrap CDN
    {0, 3822, 'bootstrapcdn.com', },
    -- BRCDN
    {0, 2459, 'p1.brcdn.com', },
    -- Brothersoft
    {0, 1210, 'brothersoft.com', },
    -- BRSRVR
    {0, 2457, 'cdn.brsrvr.com', },
    -- Burstly (Deprecated)
    --{0, 1312, 'appads.com.w3snoop.com', },
    -- BuzzFeed
    {0, 1508, 'buzzfeed.com', },
    -- BuzzHand
    {0, 4248, 'buzzhand.com', },
    -- BV! Media
    {0, 2576, 'bvmedia.ca', },
    -- C-SPAN
    {0, 2074, 'c-span.org', },
    -- C3 Metrics
    {0, 3819, 'c3metrics.com', },
    -- Caijing
    {0, 4249, 'caijing.com.cn', },
    -- Caraytech
    {0, 2573, 'caraytech.com.ar', },
    -- CCTV.com
    {0, 4251, 'cctv.com', },
    -- CheapStuff
    {0, 2061, 'cheapstuff.com', },
    -- Chinauma
    {0, 2490, 'chinauma.com', },
    -- Ci123
    {0, 4254, 'ci123.com', },
    -- CiteULike
    {0, 979, 'citeulike.org', },
    -- CK101
    {0, 4305, 'ck101.com', },
    -- Clash Royale
    {0, 4098, 'clashroyale.com', },
    -- Clicksgear
    {0, 4306, 'clicksgear.com', },
    -- Clip Converter
    {0, 4307, 'clipconverter.cc', },
    -- CloudApp
    {0, 4021, 'my.cl.ly', },
    -- Cloudsponge
    {0, 3953, 'cloudsponge.com', },
    -- Cnblogs
    {0, 4308, 'cnblogs.com', },
    -- CNNIC
    {0, 4309, 'cnnic.cn', },
    -- CNNIC
    {0, 4309, 'cnnic.com.cn', },
    -- Coc Coc
    {0, 4311, 'coccoc.com', },
    -- Code42
    {0, 3877, 'code42.com', },
    -- Collabedit
    {0, 592, 'collabedit.com', },
    -- CollegeHumor
    {0, 2164, 'collegehumor.com', },
    -- Commission Junction
    {0, 1492, 'cj.com', },
    -- Conservative Tribune
    {0, 4312, 'conservativetribune.com', },
    -- Coral CDN
    {0, 2838, 'coralcdn.org', },
    -- Core Audience
    {0, 2552, 'coreaudience.com', },
    -- Coupa
    {0, 2429, 'coupa.com', },
    -- CPX Interactive
    {0, 1457, 'cpxinteractive.com', },
    -- CrashPlan
    {0, 3878, 'crashplan.com', },
    -- Cricbuzz.com
    {0, 4313, 'cricbuzz.com', },
    -- Crunchyroll
    {0, 2138, 'crunchyroll.com', },
    -- CTV
    {0, 2750, 'ctv.ca', },
    -- Cvent
    {0, 3954, 'cvent.com', },
    -- Dainik Bhaskar
    {0, 4315, 'bhaskar.com', },
    -- Dangdang
    {0, 1074, 'dangdang.com', },
    -- Daum Blog
    {0, 4052, 'blog.daum.net', },
    -- David Jones
    {0, 601, 'davidjones.com.au', },
    -- Deals Direct
    {0, 604, 'dealsdirect.com.au', },
    -- Destructoid
    {0, 607, 'destructoid.com', },
    -- detikcom
    {0, 4317, 'detik.com', },
    -- Digg
    {0, 117, 'digg.com', },
    -- Digikala
    {0, 4319, 'digikala.com', },
    -- DINGIT.TV
    {0, 4320, 'dingit.tv', },
    -- Diply
    {0, 4321, 'diply.com', },
    -- DirectREV
    {0, 4322, 'directrev.com', },
    -- DivShare
    {0, 966, 'divshare.com', },
    -- dl.free.fr
    {0, 967, 'dl.free.fr', },
    -- DMM
    {0, 4323, 'dmm.com', },
    -- DocuSign
    {0, 3955, 'docusign.com', },
    -- DoubleVerify
    {0, 1776, 'doubleverify.com', },
    -- Douyu
    {0, 4324, 'douyu.com', },
    -- Drudge Report
    {0, 1387, 'drudgereport.com', },
    -- EarthCam
    {0, 2604, 'earthcam.com', },
    -- East Money
    {0, 2481, 'eastmoney.com', },
    -- Eastday
    {0, 4325, 'eastday.com', },
    -- easyMule
    {0, 3728, 'easymule.com', },
    -- eBay Search
    {0, 134, 'shop.ebay.com', },
    -- eBay Watch
    {0, 135, 'cgi1.ebay.com', },
    -- eBuddy
    {0, 136, 'ebuddy.com', },
    -- Edmunds.com
    {0, 622, 'edmunds.com', },
    -- ekantipur
    {0, 4326, 'ekantipur.com', },
    -- Eksi sozluk
    {0, 4327, 'eksisozluk.com', },
    -- EL PAIS
    {0, 4329, 'elpais.com', },
    -- Elmogaz
    {0, 4328, 'elmogaz.com', },
    -- Enet
    {0, 1212, 'enet.com.cn', },
    -- Ensighten
    {0, 2157, 'nexus.ensighten.com', },
    -- Entertainment Weekly
    {0, 2095, 'ew.com', },
    -- eRecht24
    {0, 2785, 'e-recht24.de', },
    -- ETtoday
    {0, 4330, 'ettoday.net', },
    -- Eve Online
    {0, 4004, 'eveonline.com', },
    -- Eve Online
    {0, 4004, 'secure.eveonline.com', },
    -- ExoClick
    {0, 4331, 'exoclick.com', },
    -- ExtraTorrent
    {0, 1214, 'extratorrent.com', },
    -- Facebook Apps
    {0, 149, 'apps.facebook.com', },
    -- Fark
    {0, 150, 'fark.com', },
    -- FFFFOUND!
    {0, 2255, 'ffffound.com', },
    -- FileHost.ro
    {0, 2884, 'filehost.ro', },
    -- FileServe
    {0, 973, 'fileserve.com', },
    -- Fingta
    {0, 4255, 'Rudateblue2.fingta.com', },
    -- Flixster
    {0, 160, 'flixster.com', },
    -- Fluent
    {0, 3658, 'asotrack1.fluentmobile.com', },
    -- FlyProxy
    {0, 2837, 'flyproxy.com.ipaddress.com', },
    -- folkd
    {0, 975, 'folkd.com', },
    -- Freepik
    {0, 4256, 'freepik.com', },
    -- FreeStreams
    {0, 2063, 'freestreams.com', },
    -- Friendster
    {0, 642, 'friendster.com', },
    -- FRIV
    {0, 4257, 'friv.com', },
    -- FrostWire
    {0, 2214, 'frostwire.com', },
    -- Frozenway
    {0, 4096, 'frozendo.com', },
    -- Fry's Electronics
    {0, 643, 'frys.com', },
    -- GamerCom
    {0, 4258, 'gamer.com.tw', },
    -- GAMERSKY
    {0, 4259, 'gamersky.com', },
    -- GameSpot
    {0, 648, 'gamespot.com', },
    -- Gantter
    {0, 3957, 'gantter.com', },
    -- Gawker
    {0, 652, 'gawker.com', },
    -- Gazprom Media
    {0, 2760, 'gazprom-media.com', },
    -- GearBest
    {0, 4260, 'gearbest.com', },
    -- Genieo
    {0, 2686, 'genieo.com', },
    -- Gfycat
    {0, 4261, 'gfycat.com', },
    -- Giganews
    {0, 175, 'giganews.com', },
    -- GIPHY
    {0, 4262, 'giphy.com', },
    -- GISMETEO
    {0, 4263, 'gismeteo.ru', },
    -- Glide
    {0, 2827, 'glideos.com', },
    -- Globo
    {0, 4264, 'globo.com', },
    -- GO.com
    {0, 1304, 'go.com', },
    -- Google Adsense
    {0, 1424, 'googlesyndication.com', },
    -- Google Analytics
    {0, 660, 'google-analytics.com', },
    -- Google Play Books
    {0, 1230, 'books.google.com', },
    -- Google Play Music
    {0, 1231, 'music.youtube.com', },
    -- Google Safebrowsing
    {0, 665, 'safebrowsing-cache.google.com', },
    -- Gothere
    {0, 4131, 'gothere.sg', },
    -- GREE Games
    {0, 3852, 'gree.net', },
    {0, 3852, 'gree.jp', },
    -- Greystripe
    {0, 1318, 'greystripe.com', },
    -- GSMArena
    {0, 4265, 'gsmarena.com', },
    -- Gulf Times
    {0, 4266, 'gulf-times.com', },
    -- H&M
    {0, 4271, 'hm.com', },
    -- Haber7
    {0, 4267, 'haber7.com', },
    -- HandyCafe
    {0, 4268, 'handycafe.com', },
    -- Hatena Blog
    {0, 4269, 'hatenablog.com', },
    -- HDFC Bank
    {0, 4270, 'hdfcbank.com', },
    -- Hello
    {0, 4108, 'hello.com', },
    -- Hightail
    {0, 928, 'yousendit.com', },
    {0, 928, 'hightail.com', },
    -- HLN (Deprecated)
    --{0, 2254, 'hlntv.com', },
    -- HOLACOM
    {0, 4272, 'hola.com', },
    -- HowardForums
    {0, 2598, 'howardforums.com', },
    -- Huanqiu
    {0, 4273, 'huanqiu.com', },
    -- HubSpot
    {0, 4274, 'hubspot.com', },
    -- Hupu
    {0, 2356, 'hupu.com', },
    -- Hurriyet
    {0, 4275, 'hurriyet.com.tr', },
    -- I Waste So Much Time
    {0, 2001, 'iwastesomuchtime.com', },
    -- I2P
    {0, 4033, 'geti2p.net', },
    -- iAd
    {0, 1319, 'advertising.apple.com', },
    -- ICICI Bank
    {0, 4276, 'icicibank.com', },
    -- Ifeng.com
    {0, 2856, 'ifeng.com', },
    -- iFunny
    {0, 2133, 'ifunny.com', },
    -- Image Venue
    {0, 1217, 'imagevenue.com', },
    -- ImpressCoJp
    {0, 4277, 'impress.co.jp', },
    -- Infinity Blade
    {0, 2335, 'infinitybladegame.com', },
    -- Innovation Interactive
    {0, 2418, 'innovationinteractive.com', },
    -- InQuest Technologies
    {0, 3959, 'inquesttechnologies.com', },
    -- Inspectlet
    {0, 3960, 'inspectlet.com', },
    -- Instructure
    {0, 4332, 'instructure.com', },
    -- Intermarkets
    {0, 2068, 'intermarkets.net', },
    -- it168
    {0, 2373, 'it168.com', },
    -- ITV
    {0, 3859, 'tom.itv.com', },
    -- ITV
    {0, 3859, 'itv.com', },
    -- JetBrains
    {0, 3981, 'jetbrains.com', },
    -- JonDo
    {0, 2947, 'anonymous-proxy-servers.net', },
    -- Jungle Disk
    {0, 4034, 'jungledisk.com', },
    -- Justin.tv
    {0, 988, 'justin.tv', },
    -- K9 Web Protection
    {0, 2013, 'k9webprotection.com', },
    -- Kaspersky
    {0, 248, 'usa.kaspersky.com', },
    -- KBS
    {0, 2435, 'kbs.co.kr', },
    -- Kongregate
    {0, 705, 'kongregate.com', },
    -- Kugou
    {0, 256, 'static.kugou.com', },
    -- Legacy.com
    {0, 1524, 'legacy.com', },
    -- Likes
    {0, 4349, 'likes.com', },
    -- LiteCoin
    {0, 2084, 'litecoin.org', },
    -- Localytics
    {0, 1426, 'localytics.com', },
    -- Lucidchart
    {0, 3961, 'lucidchart.com', },
    -- Maxymiser
    {0, 2158, 'service.maxymiser.net', },
    -- Me2day
    {0, 992, 'me2day.net', },
    -- Media Innovation Group (Deprecated)
    -- {0, 2523, 'mookie1.com', },
    -- Mediaplex
    {0, 2407, 'mediaplex.com', },
    -- Megashare
    {0, 993, 'megashare.com', },
    -- Merriam-Webster
    {0, 2789, 'merriam-webster.com', },
    -- MetaCrawler
    {0, 1132, 'metacrawler.com', },
    -- Middle East Broadcasting Center
    {0, 4206, 'mbc.net', },
    -- Milliyet
    {0, 4210, 'milliyet.com.tr', },
    -- Mister Wong
    {0, 999, 'mister-wong.com', },
    -- Mixi
    {0, 295, 'mixi.jp', },
    -- MobileCore
    {0, 4086, 'mobilecore.com', },
    -- MOG
    {0, 1041, 'mog.com', },
    -- Mojang
    {0, 4006, 'mojang.com', },
    -- Movieclips
    {0, 1084, 'movieclips.com', },
    -- MSDN
    {0, 304, 'msdn.microsoft.com', },
    -- MSN
    {0, 308, 'msn.co.uk', },
    {0, 308, 'msn.com', },
    -- Multiupload
    {0, 1220, 'multiupload.com', },
    -- MyHeritage
    {0, 1072, 'myheritage.com', },
    -- MyWay
    {0, 4211, 'hp.myway.com', },
    -- NATO
    {0, 1418, 'nato.int', },
    -- NeoGAF
    {0, 1080, 'neogaf.com', },
    -- Neopets
    {0, 996, 'neopets.com', },
    -- Netflix stream
    {0, 939, 'nflxvideo.net', },
    -- Niantic Labs
    {0, 4104, 'nianticlabs.com', },
    -- Nico Nico Douga
    {0, 762, 'nicovideo.jp', },
    -- Ninite
    {0, 4035, 'ninite.com', },
    -- NOAA
    {0, 1420, 'noaa.gov', },
    -- Nokia
    {0, 1769, 'nokia.com', },
    -- Nokia Store
    {0, 1771, 'static.store.ovi.com', },
    -- NY Daily News
    {0, 1517, 'nydailynews.com', },
    -- OkeZone
    {0, 4220, 'okezone.com', },
    -- Olx.pl
    {0, 4221, 'olx.pl', },
    -- OnClick
    {0, 4222, 'onclkds.com', },
    -- OnLive
    {0, 1305, 'onlive.com', },
    -- oo.com.au
    {0, 770, 'oo.com.au', },
    -- Openload
    {0, 4159, 'openload.co', },
    -- OptMD
    {0, 1372, 'optmd.com', },
    -- Orkut
    {0, 356, 'orkut.com', },
    -- OsiriX
    {0, 1677, 'osirix-viewer.com', },
    -- Ouoio.io
    {0, 4227, 'ouo.io', },
    -- PartyPoker
    {0, 360, 'partypoker.com', },
    -- Pathview
    {0, 3752, 'pathviewcloud.com', },
    -- PBS
    {0, 1772, 'pbs.org', },
    -- Pchome
    {0, 2350, 'pchome.net', },
    -- People Of Walmart
    {0, 1783, 'peopleofwalmart.com', },
    -- PHP
    {0, 2230, 'php.net', },
    -- Po.st
    {0, 2060, 'po.st', },
    -- Pogo
    {0, 787, 'pogo.com', },
    -- Pokemon Go
    {0, 4105, 'pokemongo.com', },
    -- Pop Salad
    {0, 1787, 'popsalad.com', },
    -- PopCap Games
    {0, 789, 'popcap.com', },
    -- PopUrls
    {0, 790, 'popurls.com', },
    -- Ppomppu
    {0, 4237, 'ppomppu.co.kr', },
    -- Putlocker
    {0, 1224, 'putlocker.com', },
    {0, 1224, 'putlocker.is', },
    -- Qatar Government
    {0, 4183, 'portal.www.gov.qa', },
    -- Qatar Living
    {0, 4184, 'qatarliving.com', },
    -- Qatar University
    {0, 4185, 'qu.edu.qa', },
    -- Quill Corporation
    {0, 797, 'quill.com', },
    -- Quote.com
    {0, 2353, 'quote.com', },
    -- Qzone
    {0, 799, 'qzone.qq.com', },
    -- Raging Bull
    {0, 1225, 'ragingbull.com', },
    -- Rapidgator
    {0, 4024, 'rapidgator.net', },
    -- RarBG
    {0, 4190, 'rarbg.to', },
    -- RayFile
    {0, 2823, 'rayfile.com', },
    -- Realview TV (Deprecated)
    --{0, 2439, 'realviewtv.com', },
    -- RedOrbit
    {0, 1989, 'redorbit.com', },
    -- ReImage
    {0, 4192, 'reimageplus.com', },
    -- RoadRunner
    {0, 1386, 'rr.com', },
    -- Roku
    {0, 2034, 'roku.com', },
    -- Ruten
    {0, 4196, 'ruten.com.tw', },
    -- RuTracker
    {0, 4197, 'rutracker.org', },
    -- Sabah
    {0, 4198, 'sabah.com.tr', },
    -- Sahibinden
    {0, 4199, 'sahibinden.com', },
    -- SAP HostControl
    {0, 410, 'sap.com', },
    -- SaveFrom
    {0, 4200, 'en.savefrom.net', },
    -- Sberbank of Russia
    {0, 4201, 'sberbank.ru', },
    -- ScienceDirect
    {0, 4203, 'sciencedirect.com', },
    -- Scribol
    {0, 4279, 'scribol.com', },
    -- Search-Result.com (Deprecated)
    --{0, 1384, 'search-result.com', },
    -- Seznam
    {0, 4281, 'onas.seznam.cz', },
    -- ShopAtHome
    {0, 1487, 'shopathome.com', },
    -- Shopify
    {0, 4282, 'shopify.com', },
    -- ShopStyle
    {0, 828, 'shopstyle.com', },
    -- Shorte
    {0, 4283, 'shorte.st', },
    -- ShowDocument
    {0, 831, 'showdocument.co', },
    {0, 831, 'showdocument.net', },
    -- Silverlight
    {0, 1302, 'silverlight.net', },
    -- Sina
    {0, 3675, 'sina.com', },
    -- SiteAdvisor
    {0, 4284, 'siteadvisor.com', },
    -- skyZIP
    {0, 4047, 'skyzip.de', },
    -- Slashdot
    {0, 834, 'slashdot.com', },
    -- Slickdeals
    {0, 1504, 'slickdeals.net', },
    -- SlideRocket
    {0, 3963, 'sliderocket.com', },
    -- SlideRocket
    {0, 3963, 'clearslide.com', },
    -- Slingbox
    {0, 432, 'slingmedia.com', },
    -- Slingbox Media
    {0, 3753, 'sso.slingmedia.com', },
    -- Slither
    {0, 4285, 'slither.io', },
    -- Snapdeal
    {0, 4286, 'snapdeal.com', },
    -- SO.com
    {0, 4287, 'so.com', },
    -- SopCast
    {0, 2628, 'sopcast.com', },
    -- Soribada
    {0, 840, 'soribada.com', },
    -- SoundHound
    {0, 4102, 'soundhound.com', },
    -- Southern Living
    {0, 2427, 'southernliving.com', },
    -- SpiderOak
    {0, 4036, 'spideroak.com', },
    -- Spinrilla
    {0, 4044, 'spinrilla.com', },
    -- Sports Authority
    {0, 842, 'sportsauthority.com', },
    -- Subscene
    {0, 4290, 'subscene.com', },
    -- Suning
    {0, 4291, 'suning.com', },
    -- Supercell
    {0, 4097, 'supercell.com', },
    -- Syncplicity
    {0, 4027, 'syncplicity.com', },
    -- Tabelog
    {0, 4292, 'tabelog.com', },
    -- Telenav
    {0, 2134, 'telenav.com', },
    -- The Xinhuanet
    {0, 1628, 'xinhuanet.com', },
    -- Theme Forest
    {0, 1227, 'themeforest.net', },
    -- TicketsNow
    {0, 869, 'ticketsnow.com', },
    -- Tinychat
    {0, 1013, 'tinychat.com', },
    -- TinyPic
    {0, 873, 'tinypic.com', },
    -- Tokbox
    {0, 2400, 'tokbox.com', },
    -- Toshiba
    {0, 2148, 'toshiba.com', },
    -- TransferBigFiles.com
    {0, 1015, 'transferbigfiles.com', },
    -- Trello
    {0, 4300, 'trello.com', },
    -- TripIt
    {0, 3965, 'tripit.com', },
    -- Trulia
    {0, 1503, 'trulia.com', },
    -- TRUSTe
    {0, 1775, 'truste.com', },
    -- TruuConfessions
    {0, 1789, 'truuconfessions.com', },
    -- TuneIn
    {0, 1810, 'tunein.com', },
    -- TurboUpload (Deprecated)
    --{0, 1017, 'turboupload.com', },
    -- TVonline.cc
    {0, 2735, 'tvonline.cc', },
    -- Ubuntu Update Manager
    {0, 1409, 'archive.ubuntu.com', },
    -- UEFA
    {0, 3966, 'uefa.com', },
    -- Undertone
    {0, 2583, 'undertone.com', },
    -- Uploaded
    {0, 4037, 'uploaded.net', },
    -- Urban Outfitters
    {0, 883, 'urbanoutfitters.com', },
    -- Usenet
    {0, 487, 'usenetserver.com', },
    -- Veoh
    {0, 889, 'veoh.com', },
    -- Viadeo
    {0, 891, 'viadeo.com', },
    -- Viber
    {0, 2367, 'viber.com', },
    -- Vlingo
    {0, 2135, 'vlingo.com', },
    -- Voyages-sncf.com
    {0, 899, 'voyages-sncf.com', },
    -- Vuze
    {0, 497, 'vuze.com', },
    -- WarLight
    {0, 3967, 'warlight.net', },
    -- Weather.com
    {0, 1367, 'weather.com', },
    -- WeatherBug
    {0, 1421, 'weather.weatherbug.com', },
    -- WeatherLink
    {0, 2195, 'weatherlink.com', },
    -- WebMD
    {0, 1502, 'webmd.com', },
    -- wer-kennt-wen
    {0, 908, 'wer-kennt-wen.de', },
    -- Windows Live Hotmail
    {0, 205, 'hotmail.com', },
    -- WiZiQ
    {0, 914, 'wiziq.com', },
    -- Wondershare
    {0, 4038, 'wondershare.net', },
    -- Woolik
    {0, 3674, 'woolik.com', },
    -- WooMe
    {0, 1025, 'woome.com', },
    -- xda-developers
    {0, 1078, 'xda-developers.com', },
    -- XING
    {0, 922, 'xing.com', },
    -- Yahoo! Games
    {0, 522, 'games.yahoo.com', },
    -- Yandex AppMetrica
    {0, 4059, 'appmetrica.yandex.com', },
    -- Yandex Email
    {0, 4061, 'mail.yandex.com', },
    -- Yandex Maps
    {0, 4062, 'suggest-maps.yandex.ru', },
    -- Yandex Market
    {0, 4064, 'market.yandex.ru', },
    -- Yandex Money
    {0, 4063, 'money.yandex.com', },
    -- Yandex Translate
    {0, 4066, 'translate.yandex.com', },
    -- Youdao Dictionary
    {0, 3982, 'youdao.com', },
    -- Zillow
    {0, 1480, 'zillow.com', },
    -- Zomato
    {0, 3968, 'zomato.com', },
    -- deviantART
    {0, 608, 'deviantart.com', },
    -- IMzog
    {0, 4278, 'imzog.com', },
    -- LiveJasmin
    {0, 4351, 'livejasmin.com', },
    -- PrivateHomeClips
    {0, 4238, 'hclips.com', },
    -- RedTube
    {0, 4191, 'redtube.com', },
    -- SpankBang
    {0, 4289, 'spankbang.com', },
    -- Upornia
    {0, 4355, 'upornia.com', },
    -- Xnxx
    {0, 4378, 'xnxx.com', },
    -- Getscreen.me
    {0, 4660, 'getscreen.me', },
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3]);
        end
    end
    gSSLHostPatternList = nil

    if gDetector.addSSLCnamePattern then
        for i,v in ipairs(gSSLCnamePatternList) do
            gDetector:addSSLCnamePattern(v[1],v[2],v[3]);
        end
    end
    gSSLCnamePatternList = nil

    return gDetector;
end

function DetectorClean()
end
