Contributing
============

Contributions to OpenELP are welcome from anyone in the form of a pull request
on GitHub. If you decide to contribute to OpenELP be sure to add yourself to
the `AUTHORS` file in the project root.

Before issuing a PR
-------------------
* Add any appropriate tests to the `tests/` directory.
* Run `make doc` and fix any Doxygen warnings
* Verify that your code's style aligns with the rest of the project.
* Squash your commits so that each commit deals with exactly one feature or
  issue.

Code Format
-----------
* All functions should have a prototype in either an appropriate header file,
  or at the beginning of the source file. This includes static functions.
* All functions should be listed and implemented alphabetically.
* All functions should have Doxygen documentation on the prototype which
  includes at least a `brief`, `param` where appropriate and `returns` where
  appropriate.

Important Links
---------------
* [OpenELP authors list](https://raw.githubusercontent.com/cottsay/openelp/main/AUTHORS)
* [OpenELP license](https://raw.githubusercontent.com/cottsay/openelp/main/LICENSE)
* [OpenELP bug tracker](https://github.com/cottsay/openelp/issues)
* [EchoLink proxy information](http://www.echolink.org/proxy.htm)
